prsm_data =
{
    "prsm": {
        "prsm_id": "61",
        "p_value": "0.19",
        "e_value": "0.22",
        "fdr": "4.29e-03",
        "matched_fragment_number": "7",
        "matched_peak_number": "8",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "81",
                "ms1_scans": "161",
                "ids": "82",
                "scans": "165",
                "precursor_mono_mass": "9896.8399",
                "precursor_charge": "11",
                "precursor_mz": "900.7200",
                "feature_inte": "3.4418e+07"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "82",
                        "peak_id": "0",
                        "monoisotopic_mass": "3518.7997",
                        "monoisotopic_mz": "1173.9405",
                        "intensity": "12232.06",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0017",
                                "ppm": "-0.49"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "1",
                        "monoisotopic_mass": "3518.8003",
                        "monoisotopic_mz": "880.7074",
                        "intensity": "13121.55",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0011",
                                "ppm": "-0.31"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "2",
                        "monoisotopic_mass": "3535.7979",
                        "monoisotopic_mz": "884.9568",
                        "intensity": "5313.49",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "3",
                        "monoisotopic_mass": "3618.8522",
                        "monoisotopic_mz": "905.7203",
                        "intensity": "8081.08",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "4",
                        "monoisotopic_mass": "3598.8663",
                        "monoisotopic_mz": "900.7238",
                        "intensity": "6648.46",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "5",
                        "monoisotopic_mass": "2560.2057",
                        "monoisotopic_mz": "854.4092",
                        "intensity": "3493.28",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "0.0040",
                                "ppm": "1.58"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "6",
                        "monoisotopic_mass": "3635.8499",
                        "monoisotopic_mz": "909.9698",
                        "intensity": "5429.10",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "7",
                        "monoisotopic_mass": "2579.2882",
                        "monoisotopic_mz": "860.7700",
                        "intensity": "2874.83",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "8",
                        "monoisotopic_mass": "2579.2846",
                        "monoisotopic_mz": "1290.6496",
                        "intensity": "3673.94",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "9",
                        "monoisotopic_mass": "3620.8590",
                        "monoisotopic_mz": "1207.9603",
                        "intensity": "4637.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "10",
                        "monoisotopic_mass": "2294.1367",
                        "monoisotopic_mz": "1148.0756",
                        "intensity": "3301.54",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "11",
                        "monoisotopic_mass": "3889.9907",
                        "monoisotopic_mz": "1297.6708",
                        "intensity": "2369.74",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "12",
                        "monoisotopic_mass": "770.3558",
                        "monoisotopic_mz": "771.3631",
                        "intensity": "2899.48",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0001",
                                "ppm": "-0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "13",
                        "monoisotopic_mass": "7951.2881",
                        "monoisotopic_mz": "994.9183",
                        "intensity": "2456.64",
                        "charge": "8"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "14",
                        "monoisotopic_mass": "2521.2615",
                        "monoisotopic_mz": "1261.6380",
                        "intensity": "3701.26",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "15",
                        "monoisotopic_mass": "3891.0005",
                        "monoisotopic_mz": "973.7574",
                        "intensity": "2384.78",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3891.0023",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "55",
                                "mass_error": "-0.0018",
                                "ppm": "-0.46"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "16",
                        "monoisotopic_mass": "1794.9334",
                        "monoisotopic_mz": "898.4740",
                        "intensity": "3174.58",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "17",
                        "monoisotopic_mass": "9268.9495",
                        "monoisotopic_mz": "927.9022",
                        "intensity": "1221.97",
                        "charge": "10"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "18",
                        "monoisotopic_mass": "3566.7816",
                        "monoisotopic_mz": "892.7027",
                        "intensity": "2487.25",
                        "charge": "4"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "19",
                        "monoisotopic_mass": "6807.1673",
                        "monoisotopic_mz": "973.4598",
                        "intensity": "858.30",
                        "charge": "7"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "20",
                        "monoisotopic_mass": "1827.7659",
                        "monoisotopic_mz": "914.8902",
                        "intensity": "1085.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "21",
                        "monoisotopic_mass": "2023.6801",
                        "monoisotopic_mz": "1012.8473",
                        "intensity": "1066.08",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "22",
                        "monoisotopic_mass": "3444.7145",
                        "monoisotopic_mz": "1149.2455",
                        "intensity": "1010.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "23",
                        "monoisotopic_mass": "6754.2836",
                        "monoisotopic_mz": "965.9049",
                        "intensity": "2516.68",
                        "charge": "7"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "24",
                        "monoisotopic_mass": "2229.0120",
                        "monoisotopic_mz": "744.0113",
                        "intensity": "920.42",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "-0.0001",
                                "ppm": "-0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "25",
                        "monoisotopic_mass": "1028.5311",
                        "monoisotopic_mz": "1029.5383",
                        "intensity": "1352.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "26",
                        "monoisotopic_mass": "4492.7352",
                        "monoisotopic_mz": "899.5543",
                        "intensity": "1258.08",
                        "charge": "5"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "27",
                        "monoisotopic_mass": "2377.0815",
                        "monoisotopic_mz": "793.3678",
                        "intensity": "1736.55",
                        "charge": "3"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "28",
                        "monoisotopic_mass": "1895.9863",
                        "monoisotopic_mz": "949.0005",
                        "intensity": "1511.37",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "29",
                        "monoisotopic_mass": "1942.9965",
                        "monoisotopic_mz": "972.5055",
                        "intensity": "792.35",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "30",
                        "monoisotopic_mass": "6022.0102",
                        "monoisotopic_mz": "1004.6756",
                        "intensity": "1246.24",
                        "charge": "6"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "31",
                        "monoisotopic_mass": "968.9994",
                        "monoisotopic_mz": "970.0067",
                        "intensity": "998.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "32",
                        "monoisotopic_mass": "5692.8874",
                        "monoisotopic_mz": "949.8218",
                        "intensity": "2339.47",
                        "charge": "6"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "33",
                        "monoisotopic_mass": "982.5213",
                        "monoisotopic_mz": "983.5286",
                        "intensity": "766.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "34",
                        "monoisotopic_mass": "1987.0165",
                        "monoisotopic_mz": "994.5155",
                        "intensity": "1875.93",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "35",
                        "monoisotopic_mass": "830.0555",
                        "monoisotopic_mz": "831.0628",
                        "intensity": "1674.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "36",
                        "monoisotopic_mass": "875.4482",
                        "monoisotopic_mz": "876.4555",
                        "intensity": "1168.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "37",
                        "monoisotopic_mass": "743.0045",
                        "monoisotopic_mz": "744.0118",
                        "intensity": "1331.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "38",
                        "monoisotopic_mass": "2774.2977",
                        "monoisotopic_mz": "925.7732",
                        "intensity": "1040.96",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2774.2970",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0007",
                                "ppm": "0.27"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "39",
                        "monoisotopic_mass": "942.4870",
                        "monoisotopic_mz": "943.4943",
                        "intensity": "1752.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "40",
                        "monoisotopic_mass": "1111.0980",
                        "monoisotopic_mz": "1112.1052",
                        "intensity": "676.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "41",
                        "monoisotopic_mass": "4718.3550",
                        "monoisotopic_mz": "944.6783",
                        "intensity": "1218.81",
                        "charge": "5"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "42",
                        "monoisotopic_mass": "5406.3611",
                        "monoisotopic_mz": "902.0675",
                        "intensity": "852.61",
                        "charge": "6"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "43",
                        "monoisotopic_mass": "1263.1373",
                        "monoisotopic_mz": "1264.1446",
                        "intensity": "409.28",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "44",
                        "monoisotopic_mass": "1872.6969",
                        "monoisotopic_mz": "937.3557",
                        "intensity": "1524.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "45",
                        "monoisotopic_mass": "1057.4357",
                        "monoisotopic_mz": "1058.4430",
                        "intensity": "636.52",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "46",
                        "monoisotopic_mass": "6669.1997",
                        "monoisotopic_mz": "953.7501",
                        "intensity": "1278.17",
                        "charge": "7"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "47",
                        "monoisotopic_mass": "1081.5683",
                        "monoisotopic_mz": "1082.5756",
                        "intensity": "726.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "48",
                        "monoisotopic_mass": "5715.8905",
                        "monoisotopic_mz": "953.6557",
                        "intensity": "1286.00",
                        "charge": "6"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "49",
                        "monoisotopic_mass": "1124.5876",
                        "monoisotopic_mz": "1125.5949",
                        "intensity": "919.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "50",
                        "monoisotopic_mass": "3619.8509",
                        "monoisotopic_mz": "724.9775",
                        "intensity": "2304.85",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "0.0018",
                                "ppm": "0.51"
                            }
                        }
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "51",
                        "monoisotopic_mass": "843.4299",
                        "monoisotopic_mz": "844.4372",
                        "intensity": "955.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "82",
                        "peak_id": "52",
                        "monoisotopic_mass": "1781.6314",
                        "monoisotopic_mz": "891.8230",
                        "intensity": "1517.79",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "21",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9897.1350",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "82",
                                "peak_id": "12",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "spec_id": "82",
                                "peak_id": "24",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "spec_id": "82",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "82",
                                "peak_id": "38",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "spec_id": "82",
                                "peak_id": "15",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "spec_id": "82",
                                "peak_id": "50",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "82",
                                    "peak_id": "0",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "82",
                                    "peak_id": "1",
                                    "peak_charge": "4"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "46",
                    "right_position": "76",
                    "anno": "48.2633",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
