prsm_data =
{
    "prsm": {
        "prsm_id": "52",
        "p_value": "1.12e-05",
        "e_value": "1.12e-05",
        "fdr": "0",
        "matched_fragment_number": "13",
        "matched_peak_number": "16",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "78",
                "ms1_scans": "144",
                "ids": "68",
                "scans": "148",
                "precursor_mono_mass": "9863.8359",
                "precursor_charge": "11",
                "precursor_mz": "897.7196",
                "feature_inte": "1.2480e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "68",
                        "peak_id": "0",
                        "monoisotopic_mass": "3534.7937",
                        "monoisotopic_mz": "884.7057",
                        "intensity": "24756.67",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "1",
                        "monoisotopic_mass": "3518.8023",
                        "monoisotopic_mz": "880.7079",
                        "intensity": "23569.12",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "0.0009",
                                "ppm": "0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "2",
                        "monoisotopic_mass": "3534.7917",
                        "monoisotopic_mz": "1179.2712",
                        "intensity": "17087.07",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "3",
                        "monoisotopic_mass": "3518.7975",
                        "monoisotopic_mz": "1173.9398",
                        "intensity": "16852.28",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0039",
                                "ppm": "-1.12"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "4",
                        "monoisotopic_mass": "3635.8426",
                        "monoisotopic_mz": "909.9679",
                        "intensity": "16372.83",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "5",
                        "monoisotopic_mass": "2560.2007",
                        "monoisotopic_mz": "854.4075",
                        "intensity": "8387.11",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "-0.0009",
                                "ppm": "-0.35"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "6",
                        "monoisotopic_mass": "2295.1361",
                        "monoisotopic_mz": "1148.5753",
                        "intensity": "7497.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "7",
                        "monoisotopic_mass": "3619.8494",
                        "monoisotopic_mz": "905.9696",
                        "intensity": "18580.68",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "0.0003",
                                "ppm": "0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "8",
                        "monoisotopic_mass": "3635.8414",
                        "monoisotopic_mz": "1212.9544",
                        "intensity": "6005.27",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "9",
                        "monoisotopic_mass": "3619.8461",
                        "monoisotopic_mz": "1207.6226",
                        "intensity": "11048.29",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0031",
                                "ppm": "-0.85"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "10",
                        "monoisotopic_mass": "2376.0812",
                        "monoisotopic_mz": "793.0344",
                        "intensity": "9685.01",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "0.0008",
                                "ppm": "0.33"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "11",
                        "monoisotopic_mass": "3890.9989",
                        "monoisotopic_mz": "1298.0069",
                        "intensity": "5999.42",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3891.0023",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "55",
                                "mass_error": "-0.0034",
                                "ppm": "-0.89"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "12",
                        "monoisotopic_mass": "3253.6197",
                        "monoisotopic_mz": "1085.5472",
                        "intensity": "5255.43",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "13",
                        "monoisotopic_mass": "3889.9934",
                        "monoisotopic_mz": "973.5056",
                        "intensity": "5128.52",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "14",
                        "monoisotopic_mass": "2489.1653",
                        "monoisotopic_mz": "830.7291",
                        "intensity": "8387.31",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "0.0008",
                                "ppm": "0.33"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "15",
                        "monoisotopic_mass": "770.3561",
                        "monoisotopic_mz": "771.3633",
                        "intensity": "6449.49",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0002",
                                "ppm": "0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "16",
                        "monoisotopic_mass": "3872.9886",
                        "monoisotopic_mz": "969.2544",
                        "intensity": "6664.17",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "17",
                        "monoisotopic_mass": "2579.2855",
                        "monoisotopic_mz": "1290.6500",
                        "intensity": "8224.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "18",
                        "monoisotopic_mass": "4059.0869",
                        "monoisotopic_mz": "1015.7790",
                        "intensity": "3730.90",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "19",
                        "monoisotopic_mass": "2229.0117",
                        "monoisotopic_mz": "744.0112",
                        "intensity": "9125.12",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "-0.0004",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "20",
                        "monoisotopic_mass": "2659.2689",
                        "monoisotopic_mz": "887.4302",
                        "intensity": "6012.35",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "-0.0012",
                                "ppm": "-0.44"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "21",
                        "monoisotopic_mass": "2522.2685",
                        "monoisotopic_mz": "1262.1415",
                        "intensity": "6159.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "22",
                        "monoisotopic_mass": "2295.1411",
                        "monoisotopic_mz": "766.0543",
                        "intensity": "3963.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "23",
                        "monoisotopic_mass": "3469.7823",
                        "monoisotopic_mz": "1157.6014",
                        "intensity": "3793.64",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "24",
                        "monoisotopic_mass": "3598.8672",
                        "monoisotopic_mz": "900.7241",
                        "intensity": "4925.63",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "25",
                        "monoisotopic_mass": "2578.2824",
                        "monoisotopic_mz": "860.4347",
                        "intensity": "7803.14",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "26",
                        "monoisotopic_mass": "3350.7162",
                        "monoisotopic_mz": "1117.9127",
                        "intensity": "2589.79",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3350.7116",
                                "ion_position": "61",
                                "ion_display_position": "28",
                                "ion_sort_name": "Y00028",
                                "ion_left_position": "61",
                                "mass_error": "0.0047",
                                "ppm": "1.39"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "27",
                        "monoisotopic_mass": "2972.3589",
                        "monoisotopic_mz": "991.7936",
                        "intensity": "5552.52",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "28",
                        "monoisotopic_mass": "2521.2599",
                        "monoisotopic_mz": "841.4272",
                        "intensity": "2578.94",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "29",
                        "monoisotopic_mass": "3369.7438",
                        "monoisotopic_mz": "1124.2552",
                        "intensity": "4841.63",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "30",
                        "monoisotopic_mass": "2775.2953",
                        "monoisotopic_mz": "926.1057",
                        "intensity": "4834.33",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "31",
                        "monoisotopic_mass": "3470.7918",
                        "monoisotopic_mz": "868.7052",
                        "intensity": "2974.17",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "32",
                        "monoisotopic_mass": "3500.7745",
                        "monoisotopic_mz": "876.2009",
                        "intensity": "3992.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "33",
                        "monoisotopic_mass": "2846.4373",
                        "monoisotopic_mz": "949.8197",
                        "intensity": "2715.63",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "34",
                        "monoisotopic_mass": "7278.6935",
                        "monoisotopic_mz": "910.8440",
                        "intensity": "4479.27",
                        "charge": "8"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "35",
                        "monoisotopic_mass": "3517.8003",
                        "monoisotopic_mz": "704.5673",
                        "intensity": "4125.45",
                        "charge": "5"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "36",
                        "monoisotopic_mass": "2376.0779",
                        "monoisotopic_mz": "1189.0462",
                        "intensity": "2181.32",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "-0.0025",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "37",
                        "monoisotopic_mass": "3237.6199",
                        "monoisotopic_mz": "1080.2139",
                        "intensity": "3013.10",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3237.6275",
                                "ion_position": "62",
                                "ion_display_position": "27",
                                "ion_sort_name": "Y00027",
                                "ion_left_position": "62",
                                "mass_error": "-0.0076",
                                "ppm": "-2.33"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "38",
                        "monoisotopic_mass": "3500.7836",
                        "monoisotopic_mz": "1167.9351",
                        "intensity": "3351.73",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "39",
                        "monoisotopic_mass": "2542.1916",
                        "monoisotopic_mz": "848.4045",
                        "intensity": "3971.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "40",
                        "monoisotopic_mass": "1010.7731",
                        "monoisotopic_mz": "1011.7804",
                        "intensity": "1339.82",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "41",
                        "monoisotopic_mass": "5380.7361",
                        "monoisotopic_mz": "897.7966",
                        "intensity": "2712.06",
                        "charge": "6"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "42",
                        "monoisotopic_mass": "3620.8463",
                        "monoisotopic_mz": "725.1765",
                        "intensity": "1105.89",
                        "charge": "5"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "43",
                        "monoisotopic_mass": "2348.0840",
                        "monoisotopic_mz": "783.7020",
                        "intensity": "2659.21",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "44",
                        "monoisotopic_mass": "584.2913",
                        "monoisotopic_mz": "585.2986",
                        "intensity": "1298.71",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "584.2918",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "-0.0005",
                                "ppm": "-0.88"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "45",
                        "monoisotopic_mass": "955.4882",
                        "monoisotopic_mz": "956.4955",
                        "intensity": "1374.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "46",
                        "monoisotopic_mass": "6729.6948",
                        "monoisotopic_mz": "962.3922",
                        "intensity": "752.66",
                        "charge": "7"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "47",
                        "monoisotopic_mass": "5418.6605",
                        "monoisotopic_mz": "904.1174",
                        "intensity": "982.19",
                        "charge": "6"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "48",
                        "monoisotopic_mass": "6092.2375",
                        "monoisotopic_mz": "871.3269",
                        "intensity": "1172.20",
                        "charge": "7"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "49",
                        "monoisotopic_mass": "5883.4126",
                        "monoisotopic_mz": "981.5760",
                        "intensity": "892.57",
                        "charge": "6"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "50",
                        "monoisotopic_mass": "6011.7410",
                        "monoisotopic_mz": "859.8274",
                        "intensity": "2268.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "51",
                        "monoisotopic_mass": "3873.9909",
                        "monoisotopic_mz": "1292.3376",
                        "intensity": "1225.74",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "52",
                        "monoisotopic_mass": "1295.6581",
                        "monoisotopic_mz": "1296.6654",
                        "intensity": "1221.49",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "53",
                        "monoisotopic_mass": "7705.7374",
                        "monoisotopic_mz": "964.2244",
                        "intensity": "2815.39",
                        "charge": "8"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "54",
                        "monoisotopic_mass": "9553.0228",
                        "monoisotopic_mz": "1062.4543",
                        "intensity": "1067.91",
                        "charge": "9"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "55",
                        "monoisotopic_mass": "3450.0462",
                        "monoisotopic_mz": "863.5188",
                        "intensity": "979.36",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "56",
                        "monoisotopic_mass": "9242.6810",
                        "monoisotopic_mz": "925.2754",
                        "intensity": "1069.02",
                        "charge": "10"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "57",
                        "monoisotopic_mass": "9797.7997",
                        "monoisotopic_mz": "891.7163",
                        "intensity": "3487.58",
                        "charge": "11"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "58",
                        "monoisotopic_mass": "2023.9923",
                        "monoisotopic_mz": "1013.0034",
                        "intensity": "1905.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "59",
                        "monoisotopic_mass": "933.8173",
                        "monoisotopic_mz": "934.8246",
                        "intensity": "1338.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "60",
                        "monoisotopic_mass": "2884.2981",
                        "monoisotopic_mz": "962.4400",
                        "intensity": "1069.13",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "61",
                        "monoisotopic_mass": "884.1743",
                        "monoisotopic_mz": "885.1816",
                        "intensity": "783.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "62",
                        "monoisotopic_mass": "1805.9056",
                        "monoisotopic_mz": "903.9601",
                        "intensity": "1439.20",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "63",
                        "monoisotopic_mass": "4172.1065",
                        "monoisotopic_mz": "1044.0339",
                        "intensity": "2057.92",
                        "charge": "4"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "64",
                        "monoisotopic_mass": "2721.7107",
                        "monoisotopic_mz": "908.2442",
                        "intensity": "1981.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "65",
                        "monoisotopic_mass": "841.9278",
                        "monoisotopic_mz": "842.9351",
                        "intensity": "2327.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "66",
                        "monoisotopic_mass": "869.9082",
                        "monoisotopic_mz": "870.9155",
                        "intensity": "2186.26",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "67",
                        "monoisotopic_mass": "817.4296",
                        "monoisotopic_mz": "818.4369",
                        "intensity": "1328.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "68",
                        "monoisotopic_mass": "8367.9339",
                        "monoisotopic_mz": "930.7777",
                        "intensity": "2697.64",
                        "charge": "9"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "69",
                        "monoisotopic_mass": "7360.9667",
                        "monoisotopic_mz": "818.8925",
                        "intensity": "1268.25",
                        "charge": "9"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "70",
                        "monoisotopic_mass": "2139.0494",
                        "monoisotopic_mz": "1070.5320",
                        "intensity": "976.62",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "71",
                        "monoisotopic_mass": "1092.8964",
                        "monoisotopic_mz": "1093.9037",
                        "intensity": "749.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "72",
                        "monoisotopic_mass": "6698.3443",
                        "monoisotopic_mz": "957.9136",
                        "intensity": "1997.43",
                        "charge": "7"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "73",
                        "monoisotopic_mass": "3409.6883",
                        "monoisotopic_mz": "1137.5700",
                        "intensity": "1047.82",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "74",
                        "monoisotopic_mass": "3138.5464",
                        "monoisotopic_mz": "1047.1894",
                        "intensity": "2032.68",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3138.5591",
                                "ion_position": "63",
                                "ion_display_position": "26",
                                "ion_sort_name": "Y00026",
                                "ion_left_position": "63",
                                "mass_error": "-0.0127",
                                "ppm": "-4.05"
                            }
                        }
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "75",
                        "monoisotopic_mass": "4436.7239",
                        "monoisotopic_mz": "888.3521",
                        "intensity": "1966.18",
                        "charge": "5"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "76",
                        "monoisotopic_mass": "7303.1897",
                        "monoisotopic_mz": "1044.3201",
                        "intensity": "2052.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "77",
                        "monoisotopic_mass": "1280.1028",
                        "monoisotopic_mz": "641.0587",
                        "intensity": "667.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "78",
                        "monoisotopic_mass": "7778.6221",
                        "monoisotopic_mz": "973.3350",
                        "intensity": "1267.49",
                        "charge": "8"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "79",
                        "monoisotopic_mass": "2846.4398",
                        "monoisotopic_mz": "1424.2272",
                        "intensity": "3078.90",
                        "charge": "2"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "80",
                        "monoisotopic_mass": "1055.9258",
                        "monoisotopic_mz": "1056.9331",
                        "intensity": "934.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "81",
                        "monoisotopic_mass": "1273.3171",
                        "monoisotopic_mz": "1274.3243",
                        "intensity": "640.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "82",
                        "monoisotopic_mass": "4728.0782",
                        "monoisotopic_mz": "946.6229",
                        "intensity": "1235.62",
                        "charge": "5"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "83",
                        "monoisotopic_mass": "1042.5466",
                        "monoisotopic_mz": "1043.5538",
                        "intensity": "507.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "84",
                        "monoisotopic_mass": "9198.8868",
                        "monoisotopic_mz": "920.8960",
                        "intensity": "2268.00",
                        "charge": "10"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "85",
                        "monoisotopic_mass": "4481.1665",
                        "monoisotopic_mz": "897.2406",
                        "intensity": "2089.18",
                        "charge": "5"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "86",
                        "monoisotopic_mass": "1078.5328",
                        "monoisotopic_mz": "1079.5400",
                        "intensity": "1109.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "87",
                        "monoisotopic_mass": "2750.2183",
                        "monoisotopic_mz": "917.7467",
                        "intensity": "990.28",
                        "charge": "3"
                    },
                    {
                        "spec_id": "68",
                        "peak_id": "88",
                        "monoisotopic_mass": "1454.7682",
                        "monoisotopic_mz": "728.3914",
                        "intensity": "580.46",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "6",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9864.1309",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "68",
                                "peak_id": "44",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "68",
                                "peak_id": "15",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "spec_id": "68",
                                "peak_id": "19",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "68",
                                    "peak_id": "36",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "68",
                                    "peak_id": "10",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "68",
                                "peak_id": "14",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "spec_id": "68",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "spec_id": "68",
                                "peak_id": "20",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "spec_id": "68",
                                "peak_id": "11",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "68",
                                    "peak_id": "9",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "68",
                                    "peak_id": "7",
                                    "peak_charge": "4"
                                }
                            ]
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "68",
                                    "peak_id": "3",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "68",
                                    "peak_id": "1",
                                    "peak_charge": "4"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "61",
                                "ion_display_position": "28",
                                "spec_id": "68",
                                "peak_id": "26",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "62",
                                "ion_display_position": "27",
                                "spec_id": "68",
                                "peak_id": "37",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "63",
                                "ion_display_position": "26",
                                "spec_id": "68",
                                "peak_id": "74",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "45",
                    "right_position": "76",
                    "anno": "15.2592",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
