prsm_data =
{
    "prsm": {
        "prsm_id": "45",
        "p_value": "5.68e-04",
        "e_value": "5.68e-04",
        "fdr": "0",
        "matched_fragment_number": "8",
        "matched_peak_number": "9",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "75",
                "ms1_scans": "133",
                "ids": "59",
                "scans": "136",
                "precursor_mono_mass": "15921.1970",
                "precursor_charge": "17",
                "precursor_mz": "937.5483",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "59",
                        "peak_id": "0",
                        "monoisotopic_mass": "7478.8823",
                        "monoisotopic_mz": "935.8676",
                        "intensity": "15783.98",
                        "charge": "8"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "1",
                        "monoisotopic_mass": "6429.3400",
                        "monoisotopic_mz": "1072.5639",
                        "intensity": "7153.33",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6429.3359",
                                "ion_position": "91",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "91",
                                "mass_error": "0.0040",
                                "ppm": "0.63"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "2",
                        "monoisotopic_mass": "7544.8825",
                        "monoisotopic_mz": "1258.4877",
                        "intensity": "6084.44",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "80",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "80",
                                "mass_error": "0.0007",
                                "ppm": "0.09"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "3",
                        "monoisotopic_mass": "4360.2101",
                        "monoisotopic_mz": "873.0493",
                        "intensity": "9169.01",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "-132.0275620509",
                                "theoretical_mass": "4360.2322",
                                "ion_position": "40",
                                "ion_display_position": "40",
                                "ion_sort_name": "B00040",
                                "ion_left_position": "40",
                                "mass_error": "-0.0221",
                                "ppm": "-5.08"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "4",
                        "monoisotopic_mass": "1136.6188",
                        "monoisotopic_mz": "1137.6261",
                        "intensity": "4933.33",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "139",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "139",
                                "mass_error": "-0.0002",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "5",
                        "monoisotopic_mass": "7473.8491",
                        "monoisotopic_mz": "1068.7000",
                        "intensity": "4997.93",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "81",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "81",
                                "mass_error": "0.0044",
                                "ppm": "0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "6",
                        "monoisotopic_mass": "7285.7426",
                        "monoisotopic_mz": "1041.8277",
                        "intensity": "3779.26",
                        "charge": "7"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "7",
                        "monoisotopic_mass": "2136.1008",
                        "monoisotopic_mz": "1069.0577",
                        "intensity": "3448.57",
                        "charge": "2"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "8",
                        "monoisotopic_mass": "6544.5558",
                        "monoisotopic_mz": "935.9438",
                        "intensity": "4373.92",
                        "charge": "7"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "9",
                        "monoisotopic_mass": "1909.4658",
                        "monoisotopic_mz": "955.7402",
                        "intensity": "1494.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "10",
                        "monoisotopic_mass": "7473.8592",
                        "monoisotopic_mz": "1246.6505",
                        "intensity": "2452.49",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "81",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "81",
                                "mass_error": "0.0145",
                                "ppm": "1.94"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "11",
                        "monoisotopic_mass": "969.9005",
                        "monoisotopic_mz": "970.9078",
                        "intensity": "1325.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "12",
                        "monoisotopic_mass": "755.4176",
                        "monoisotopic_mz": "756.4249",
                        "intensity": "1755.40",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "143",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "143",
                                "mass_error": "-0.0001",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "13",
                        "monoisotopic_mass": "2032.0428",
                        "monoisotopic_mz": "1017.0287",
                        "intensity": "1854.27",
                        "charge": "2"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "14",
                        "monoisotopic_mass": "1746.1343",
                        "monoisotopic_mz": "874.0744",
                        "intensity": "1800.72",
                        "charge": "2"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "15",
                        "monoisotopic_mass": "8919.3474",
                        "monoisotopic_mz": "1115.9257",
                        "intensity": "1113.95",
                        "charge": "8"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "16",
                        "monoisotopic_mass": "8729.5839",
                        "monoisotopic_mz": "873.9657",
                        "intensity": "1213.68",
                        "charge": "10"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "17",
                        "monoisotopic_mass": "2180.1118",
                        "monoisotopic_mz": "1091.0632",
                        "intensity": "2031.75",
                        "charge": "2"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "18",
                        "monoisotopic_mass": "1047.5453",
                        "monoisotopic_mz": "1048.5526",
                        "intensity": "1251.95",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "-132.0275620509",
                                "theoretical_mass": "1047.5471",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "-0.0018",
                                "ppm": "-1.68"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "19",
                        "monoisotopic_mass": "4681.2820",
                        "monoisotopic_mz": "937.2637",
                        "intensity": "1670.27",
                        "charge": "5"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "20",
                        "monoisotopic_mass": "1012.7184",
                        "monoisotopic_mz": "1013.7256",
                        "intensity": "1079.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "21",
                        "monoisotopic_mass": "3716.9223",
                        "monoisotopic_mz": "930.2378",
                        "intensity": "4469.78",
                        "charge": "4"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "22",
                        "monoisotopic_mass": "848.9339",
                        "monoisotopic_mz": "849.9412",
                        "intensity": "1025.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "23",
                        "monoisotopic_mass": "937.2355",
                        "monoisotopic_mz": "938.2428",
                        "intensity": "1218.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "24",
                        "monoisotopic_mass": "8210.2530",
                        "monoisotopic_mz": "822.0326",
                        "intensity": "1764.58",
                        "charge": "10"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "25",
                        "monoisotopic_mass": "3763.4485",
                        "monoisotopic_mz": "941.8694",
                        "intensity": "1149.42",
                        "charge": "4"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "26",
                        "monoisotopic_mass": "919.4775",
                        "monoisotopic_mz": "920.4848",
                        "intensity": "1493.94",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "-132.0275620509",
                                "theoretical_mass": "919.4885",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "-0.0110",
                                "ppm": "-11.96"
                            }
                        }
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "27",
                        "monoisotopic_mass": "8603.2382",
                        "monoisotopic_mz": "956.9226",
                        "intensity": "884.22",
                        "charge": "9"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "28",
                        "monoisotopic_mass": "7619.6263",
                        "monoisotopic_mz": "1089.5253",
                        "intensity": "2203.14",
                        "charge": "7"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "29",
                        "monoisotopic_mass": "7279.8215",
                        "monoisotopic_mz": "910.9850",
                        "intensity": "2767.68",
                        "charge": "8"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "30",
                        "monoisotopic_mass": "14039.8365",
                        "monoisotopic_mz": "936.9964",
                        "intensity": "3306.53",
                        "charge": "15"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "31",
                        "monoisotopic_mass": "3801.9261",
                        "monoisotopic_mz": "951.4888",
                        "intensity": "1501.30",
                        "charge": "4"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "32",
                        "monoisotopic_mass": "994.2132",
                        "monoisotopic_mz": "995.2205",
                        "intensity": "1509.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "33",
                        "monoisotopic_mass": "882.6144",
                        "monoisotopic_mz": "883.6217",
                        "intensity": "1569.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "34",
                        "monoisotopic_mass": "11143.6213",
                        "monoisotopic_mz": "1014.0638",
                        "intensity": "2136.28",
                        "charge": "11"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "35",
                        "monoisotopic_mass": "5893.0062",
                        "monoisotopic_mz": "983.1750",
                        "intensity": "2500.39",
                        "charge": "6"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "36",
                        "monoisotopic_mass": "861.5485",
                        "monoisotopic_mz": "862.5557",
                        "intensity": "2105.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "37",
                        "monoisotopic_mass": "1026.0609",
                        "monoisotopic_mz": "1027.0681",
                        "intensity": "865.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "38",
                        "monoisotopic_mass": "4364.1835",
                        "monoisotopic_mz": "1092.0531",
                        "intensity": "1826.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "39",
                        "monoisotopic_mass": "899.5924",
                        "monoisotopic_mz": "900.5996",
                        "intensity": "1066.03",
                        "charge": "1"
                    },
                    {
                        "spec_id": "59",
                        "peak_id": "40",
                        "monoisotopic_mass": "6409.1907",
                        "monoisotopic_mz": "1069.2057",
                        "intensity": "1925.15",
                        "charge": "6"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15921.2570",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "0",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "59",
                                "peak_id": "26",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "59",
                                "peak_id": "18",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "40",
                                "ion_display_position": "40",
                                "spec_id": "59",
                                "peak_id": "3",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "69",
                                "spec_id": "59",
                                "peak_id": "2",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "81",
                                    "ion_display_position": "68",
                                    "spec_id": "59",
                                    "peak_id": "5",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "81",
                                    "ion_display_position": "68",
                                    "spec_id": "59",
                                    "peak_id": "10",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "91",
                                "ion_display_position": "58",
                                "spec_id": "59",
                                "peak_id": "1",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "139",
                                "ion_display_position": "10",
                                "spec_id": "59",
                                "peak_id": "4",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "143",
                                "ion_display_position": "6",
                                "spec_id": "59",
                                "peak_id": "12",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "0",
                    "right_position": "9",
                    "anno": "-132.0276",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
