prsm_data =
{
    "prsm": {
        "prsm_id": "179",
        "p_value": "3.01e-10",
        "e_value": "3.01e-10",
        "fdr": "0",
        "matched_fragment_number": "19",
        "matched_peak_number": "21",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "134",
                "ms1_scans": "388",
                "ids": "254",
                "scans": "390",
                "precursor_mono_mass": "9173.4138",
                "precursor_charge": "9",
                "precursor_mz": "1020.2755",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "254",
                        "peak_id": "0",
                        "monoisotopic_mass": "8831.2302",
                        "monoisotopic_mz": "1104.9111",
                        "intensity": "41552.59",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0128",
                                "ppm": "-1.45"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "1",
                        "monoisotopic_mass": "8831.2377",
                        "monoisotopic_mz": "1262.6127",
                        "intensity": "40438.28",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0054",
                                "ppm": "-0.61"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "2",
                        "monoisotopic_mass": "8814.2322",
                        "monoisotopic_mz": "1102.7863",
                        "intensity": "19783.11",
                        "charge": "8"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "3",
                        "monoisotopic_mass": "7579.7963",
                        "monoisotopic_mz": "1264.3067",
                        "intensity": "19313.15",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "4",
                        "monoisotopic_mass": "8927.3079",
                        "monoisotopic_mz": "1116.9208",
                        "intensity": "22929.16",
                        "charge": "8"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "5",
                        "monoisotopic_mass": "8944.3156",
                        "monoisotopic_mz": "1119.0467",
                        "intensity": "19703.10",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0116",
                                "ppm": "-1.29"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "6",
                        "monoisotopic_mass": "3973.8142",
                        "monoisotopic_mz": "1325.6120",
                        "intensity": "13437.90",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "-0.0006",
                                "ppm": "-0.14"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "7",
                        "monoisotopic_mass": "8910.2767",
                        "monoisotopic_mz": "1114.7919",
                        "intensity": "16317.86",
                        "charge": "8"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "8",
                        "monoisotopic_mass": "8814.2206",
                        "monoisotopic_mz": "1260.1816",
                        "intensity": "12378.01",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "9",
                        "monoisotopic_mass": "8612.1810",
                        "monoisotopic_mz": "1231.3189",
                        "intensity": "11857.63",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "10",
                        "monoisotopic_mass": "8632.1967",
                        "monoisotopic_mz": "1234.1782",
                        "intensity": "9532.08",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "11",
                        "monoisotopic_mass": "4136.8758",
                        "monoisotopic_mz": "1379.9659",
                        "intensity": "11232.92",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "-0.0023",
                                "ppm": "-0.55"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "12",
                        "monoisotopic_mass": "4448.6432",
                        "monoisotopic_mz": "1113.1681",
                        "intensity": "10499.00",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "13",
                        "monoisotopic_mass": "5368.4491",
                        "monoisotopic_mz": "1343.1196",
                        "intensity": "6620.89",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5367.4509",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "ion_sort_name": "B00047",
                                "ion_left_position": "47",
                                "mass_error": "-0.0041",
                                "ppm": "-0.77"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "14",
                        "monoisotopic_mass": "3018.4826",
                        "monoisotopic_mz": "1007.1681",
                        "intensity": "8493.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "15",
                        "monoisotopic_mass": "4494.0310",
                        "monoisotopic_mz": "1124.5150",
                        "intensity": "7764.11",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4494.0429",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0119",
                                "ppm": "-2.66"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "16",
                        "monoisotopic_mass": "7433.7174",
                        "monoisotopic_mz": "1239.9602",
                        "intensity": "10360.20",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7433.7204",
                                "ion_position": "15",
                                "ion_display_position": "64",
                                "ion_sort_name": "Y00064",
                                "ion_left_position": "15",
                                "mass_error": "-0.0030",
                                "ppm": "-0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "17",
                        "monoisotopic_mass": "3955.8017",
                        "monoisotopic_mz": "1319.6079",
                        "intensity": "6086.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "18",
                        "monoisotopic_mass": "3921.9744",
                        "monoisotopic_mz": "1308.3321",
                        "intensity": "5920.06",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "19",
                        "monoisotopic_mass": "4036.0363",
                        "monoisotopic_mz": "1346.3527",
                        "intensity": "8269.43",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "20",
                        "monoisotopic_mass": "7560.7632",
                        "monoisotopic_mz": "1261.1345",
                        "intensity": "6300.81",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "21",
                        "monoisotopic_mass": "3121.5944",
                        "monoisotopic_mz": "1561.8045",
                        "intensity": "7096.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "22",
                        "monoisotopic_mass": "4019.0130",
                        "monoisotopic_mz": "1340.6783",
                        "intensity": "4794.13",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "23",
                        "monoisotopic_mass": "4778.2105",
                        "monoisotopic_mz": "1195.5599",
                        "intensity": "9373.83",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "24",
                        "monoisotopic_mass": "3463.7959",
                        "monoisotopic_mz": "1155.6059",
                        "intensity": "4882.68",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3463.7922",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "50",
                                "mass_error": "0.0037",
                                "ppm": "1.06"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "25",
                        "monoisotopic_mass": "7818.8628",
                        "monoisotopic_mz": "1304.1511",
                        "intensity": "8425.82",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "26",
                        "monoisotopic_mass": "1364.5337",
                        "monoisotopic_mz": "683.2741",
                        "intensity": "3482.69",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1364.5337",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "ion_sort_name": "B00012",
                                "ion_left_position": "12",
                                "mass_error": "-0.0000",
                                "ppm": "-0.00"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "27",
                        "monoisotopic_mass": "3691.9226",
                        "monoisotopic_mz": "1231.6481",
                        "intensity": "5460.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "28",
                        "monoisotopic_mass": "720.3437",
                        "monoisotopic_mz": "721.3510",
                        "intensity": "4386.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "29",
                        "monoisotopic_mass": "7204.6067",
                        "monoisotopic_mz": "1201.7751",
                        "intensity": "4829.29",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "30",
                        "monoisotopic_mass": "1380.6288",
                        "monoisotopic_mz": "1381.6361",
                        "intensity": "3309.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "31",
                        "monoisotopic_mass": "4795.1973",
                        "monoisotopic_mz": "1199.8066",
                        "intensity": "3684.53",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4795.2067",
                                "ion_position": "42",
                                "ion_display_position": "42",
                                "ion_sort_name": "B00042",
                                "ion_left_position": "42",
                                "mass_error": "-0.0093",
                                "ppm": "-1.95"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "32",
                        "monoisotopic_mass": "3707.8546",
                        "monoisotopic_mz": "1236.9588",
                        "intensity": "3366.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "33",
                        "monoisotopic_mass": "8515.1048",
                        "monoisotopic_mz": "1217.4508",
                        "intensity": "7032.07",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8515.1412",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "ion_sort_name": "B00073",
                                "ion_left_position": "73",
                                "mass_error": "-0.0364",
                                "ppm": "-4.28"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "34",
                        "monoisotopic_mass": "8431.0912",
                        "monoisotopic_mz": "1205.4489",
                        "intensity": "6633.88",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "35",
                        "monoisotopic_mass": "947.4011",
                        "monoisotopic_mz": "948.4084",
                        "intensity": "3417.97",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "947.4018",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "-0.0007",
                                "ppm": "-0.78"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "36",
                        "monoisotopic_mass": "1102.9002",
                        "monoisotopic_mz": "1103.9075",
                        "intensity": "2462.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "37",
                        "monoisotopic_mass": "8545.1915",
                        "monoisotopic_mz": "1221.7489",
                        "intensity": "9403.92",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "38",
                        "monoisotopic_mass": "1739.7143",
                        "monoisotopic_mz": "1740.7216",
                        "intensity": "2157.09",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1739.7131",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "ion_sort_name": "B00015",
                                "ion_left_position": "15",
                                "mass_error": "0.0012",
                                "ppm": "0.69"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "39",
                        "monoisotopic_mass": "3855.4127",
                        "monoisotopic_mz": "1286.1448",
                        "intensity": "4914.00",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "40",
                        "monoisotopic_mass": "8444.0981",
                        "monoisotopic_mz": "1207.3070",
                        "intensity": "4754.87",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8444.1041",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "ion_sort_name": "B00072",
                                "ion_left_position": "72",
                                "mass_error": "-0.0059",
                                "ppm": "-0.70"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "41",
                        "monoisotopic_mass": "3008.5103",
                        "monoisotopic_mz": "1505.2624",
                        "intensity": "3102.43",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "42",
                        "monoisotopic_mass": "3349.7025",
                        "monoisotopic_mz": "1117.5748",
                        "intensity": "4490.31",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "43",
                        "monoisotopic_mass": "2569.9397",
                        "monoisotopic_mz": "1285.9771",
                        "intensity": "3508.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "44",
                        "monoisotopic_mass": "2612.2990",
                        "monoisotopic_mz": "1307.1568",
                        "intensity": "3698.24",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "45",
                        "monoisotopic_mass": "1207.3028",
                        "monoisotopic_mz": "1208.3101",
                        "intensity": "2508.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "46",
                        "monoisotopic_mass": "934.4754",
                        "monoisotopic_mz": "935.4827",
                        "intensity": "2887.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "47",
                        "monoisotopic_mass": "8073.8947",
                        "monoisotopic_mz": "1154.4208",
                        "intensity": "3451.40",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8073.9076",
                                "ion_position": "69",
                                "ion_display_position": "69",
                                "ion_sort_name": "B00069",
                                "ion_left_position": "69",
                                "mass_error": "-0.0130",
                                "ppm": "-1.60"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "48",
                        "monoisotopic_mass": "2435.1996",
                        "monoisotopic_mz": "1218.6071",
                        "intensity": "3764.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "49",
                        "monoisotopic_mass": "3732.3522",
                        "monoisotopic_mz": "1245.1247",
                        "intensity": "3352.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "50",
                        "monoisotopic_mass": "996.4981",
                        "monoisotopic_mz": "997.5054",
                        "intensity": "1519.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "51",
                        "monoisotopic_mass": "2130.0392",
                        "monoisotopic_mz": "1066.0269",
                        "intensity": "1876.21",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "52",
                        "monoisotopic_mass": "3000.4793",
                        "monoisotopic_mz": "1001.1670",
                        "intensity": "2533.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "53",
                        "monoisotopic_mass": "8794.1848",
                        "monoisotopic_mz": "1100.2804",
                        "intensity": "5913.14",
                        "charge": "8"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "54",
                        "monoisotopic_mass": "2068.0415",
                        "monoisotopic_mz": "1035.0280",
                        "intensity": "2573.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "55",
                        "monoisotopic_mass": "2495.1139",
                        "monoisotopic_mz": "1248.5642",
                        "intensity": "2796.92",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2495.1131",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "0.0008",
                                "ppm": "0.33"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "56",
                        "monoisotopic_mass": "3234.6764",
                        "monoisotopic_mz": "1079.2327",
                        "intensity": "2236.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "57",
                        "monoisotopic_mass": "8474.1293",
                        "monoisotopic_mz": "1211.5972",
                        "intensity": "1001.40",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "58",
                        "monoisotopic_mass": "8596.1935",
                        "monoisotopic_mz": "1229.0349",
                        "intensity": "3458.38",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "59",
                        "monoisotopic_mass": "3103.5739",
                        "monoisotopic_mz": "1552.7942",
                        "intensity": "2289.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "60",
                        "monoisotopic_mass": "5055.9293",
                        "monoisotopic_mz": "1264.9896",
                        "intensity": "6452.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "61",
                        "monoisotopic_mass": "5153.3881",
                        "monoisotopic_mz": "1289.3543",
                        "intensity": "1157.05",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "62",
                        "monoisotopic_mass": "2019.0157",
                        "monoisotopic_mz": "1010.5151",
                        "intensity": "1824.07",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "63",
                        "monoisotopic_mass": "8716.1486",
                        "monoisotopic_mz": "1090.5259",
                        "intensity": "3661.60",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8716.2161",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "ion_sort_name": "B00075",
                                "ion_left_position": "75",
                                "mass_error": "-0.0675",
                                "ppm": "-7.75"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "64",
                        "monoisotopic_mass": "6117.7821",
                        "monoisotopic_mz": "1020.6376",
                        "intensity": "2281.51",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "65",
                        "monoisotopic_mass": "821.3916",
                        "monoisotopic_mz": "822.3989",
                        "intensity": "2000.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "66",
                        "monoisotopic_mass": "8716.2325",
                        "monoisotopic_mz": "1246.1834",
                        "intensity": "1062.72",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8716.2161",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "ion_sort_name": "B00075",
                                "ion_left_position": "75",
                                "mass_error": "0.0164",
                                "ppm": "1.88"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "67",
                        "monoisotopic_mass": "3248.6495",
                        "monoisotopic_mz": "1083.8904",
                        "intensity": "1887.91",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "68",
                        "monoisotopic_mass": "6250.0473",
                        "monoisotopic_mz": "1251.0167",
                        "intensity": "1518.21",
                        "charge": "5"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "69",
                        "monoisotopic_mass": "4328.5670",
                        "monoisotopic_mz": "1083.1490",
                        "intensity": "1013.70",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "70",
                        "monoisotopic_mass": "6969.2987",
                        "monoisotopic_mz": "1162.5571",
                        "intensity": "1113.82",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6968.3520",
                                "ion_position": "60",
                                "ion_display_position": "60",
                                "ion_sort_name": "B00060",
                                "ion_left_position": "60",
                                "mass_error": "-0.0556",
                                "ppm": "-7.98"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "71",
                        "monoisotopic_mass": "3546.7650",
                        "monoisotopic_mz": "1183.2623",
                        "intensity": "3293.42",
                        "charge": "3"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "72",
                        "monoisotopic_mass": "8856.8990",
                        "monoisotopic_mz": "1266.2786",
                        "intensity": "1338.96",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "73",
                        "monoisotopic_mass": "8729.2240",
                        "monoisotopic_mz": "1092.1603",
                        "intensity": "3156.71",
                        "charge": "8"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "74",
                        "monoisotopic_mass": "4986.2101",
                        "monoisotopic_mz": "1247.5598",
                        "intensity": "966.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "75",
                        "monoisotopic_mass": "2185.7994",
                        "monoisotopic_mz": "1093.9070",
                        "intensity": "1090.46",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "76",
                        "monoisotopic_mass": "1174.2880",
                        "monoisotopic_mz": "1175.2953",
                        "intensity": "910.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "77",
                        "monoisotopic_mass": "846.3531",
                        "monoisotopic_mz": "847.3604",
                        "intensity": "1984.98",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "846.3542",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0010",
                                "ppm": "-1.21"
                            }
                        }
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "78",
                        "monoisotopic_mass": "7186.5526",
                        "monoisotopic_mz": "1198.7660",
                        "intensity": "3872.32",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "79",
                        "monoisotopic_mass": "8760.3175",
                        "monoisotopic_mz": "1252.4812",
                        "intensity": "7672.75",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "80",
                        "monoisotopic_mass": "1018.4878",
                        "monoisotopic_mz": "1019.4951",
                        "intensity": "1201.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "81",
                        "monoisotopic_mass": "4387.5731",
                        "monoisotopic_mz": "1097.9006",
                        "intensity": "3283.71",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "82",
                        "monoisotopic_mass": "1346.5230",
                        "monoisotopic_mz": "674.2688",
                        "intensity": "1620.79",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "83",
                        "monoisotopic_mass": "1288.1388",
                        "monoisotopic_mz": "1289.1461",
                        "intensity": "1065.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "84",
                        "monoisotopic_mass": "7551.6070",
                        "monoisotopic_mz": "1079.8083",
                        "intensity": "1257.70",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "85",
                        "monoisotopic_mass": "1417.0568",
                        "monoisotopic_mz": "1418.0641",
                        "intensity": "3179.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "86",
                        "monoisotopic_mass": "6542.1479",
                        "monoisotopic_mz": "935.5998",
                        "intensity": "2429.02",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "87",
                        "monoisotopic_mass": "1140.5688",
                        "monoisotopic_mz": "1141.5760",
                        "intensity": "3515.46",
                        "charge": "1"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "88",
                        "monoisotopic_mass": "7733.7223",
                        "monoisotopic_mz": "1105.8247",
                        "intensity": "1411.86",
                        "charge": "7"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "89",
                        "monoisotopic_mass": "2308.1255",
                        "monoisotopic_mz": "1155.0700",
                        "intensity": "1332.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "90",
                        "monoisotopic_mass": "4560.3184",
                        "monoisotopic_mz": "1141.0869",
                        "intensity": "2114.72",
                        "charge": "4"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "91",
                        "monoisotopic_mass": "6705.4423",
                        "monoisotopic_mz": "1118.5810",
                        "intensity": "3483.33",
                        "charge": "6"
                    },
                    {
                        "spec_id": "254",
                        "peak_id": "92",
                        "monoisotopic_mass": "7747.8864",
                        "monoisotopic_mz": "1107.8482",
                        "intensity": "2707.94",
                        "charge": "7"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "254",
                                "peak_id": "77",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "254",
                                "peak_id": "35",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "spec_id": "254",
                                "peak_id": "26",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "15",
                                    "ion_display_position": "15",
                                    "spec_id": "254",
                                    "peak_id": "38",
                                    "peak_charge": "1"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "15",
                                    "ion_display_position": "64",
                                    "spec_id": "254",
                                    "peak_id": "16",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "254",
                                "peak_id": "55",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "254",
                                "peak_id": "6",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "254",
                                "peak_id": "11",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "254",
                                "peak_id": "15",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "42",
                                "ion_display_position": "42",
                                "spec_id": "254",
                                "peak_id": "31",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "spec_id": "254",
                                "peak_id": "13",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "spec_id": "254",
                                "peak_id": "24",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "60",
                                "ion_display_position": "60",
                                "spec_id": "254",
                                "peak_id": "70",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "69",
                                "ion_display_position": "69",
                                "spec_id": "254",
                                "peak_id": "47",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "spec_id": "254",
                                "peak_id": "40",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "spec_id": "254",
                                "peak_id": "33",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "75",
                                    "ion_display_position": "75",
                                    "spec_id": "254",
                                    "peak_id": "63",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "75",
                                    "ion_display_position": "75",
                                    "spec_id": "254",
                                    "peak_id": "66",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "254",
                                    "peak_id": "0",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "254",
                                    "peak_id": "1",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "spec_id": "254",
                                "peak_id": "5",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
