prsm_data =
{
    "prsm": {
        "prsm_id": "155",
        "p_value": "4.06e-06",
        "e_value": "4.06e-06",
        "fdr": "0",
        "matched_fragment_number": "12",
        "matched_peak_number": "16",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "122",
                "ms1_scans": "336",
                "ids": "215",
                "scans": "339",
                "precursor_mono_mass": "9863.8453",
                "precursor_charge": "11",
                "precursor_mz": "897.7205",
                "feature_inte": "1.2480e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "215",
                        "peak_id": "0",
                        "monoisotopic_mass": "3518.8011",
                        "monoisotopic_mz": "1173.9410",
                        "intensity": "20726.67",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0003",
                                "ppm": "-0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "1",
                        "monoisotopic_mass": "3518.8023",
                        "monoisotopic_mz": "880.7079",
                        "intensity": "24933.13",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "0.0009",
                                "ppm": "0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "2",
                        "monoisotopic_mass": "3635.8477",
                        "monoisotopic_mz": "909.9692",
                        "intensity": "16118.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "3",
                        "monoisotopic_mass": "3533.7912",
                        "monoisotopic_mz": "884.4551",
                        "intensity": "23888.03",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "4",
                        "monoisotopic_mass": "3534.7910",
                        "monoisotopic_mz": "1179.2709",
                        "intensity": "15163.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "5",
                        "monoisotopic_mass": "3619.8430",
                        "monoisotopic_mz": "905.9680",
                        "intensity": "17848.89",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0061",
                                "ppm": "-1.67"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "6",
                        "monoisotopic_mass": "2229.0126",
                        "monoisotopic_mz": "744.0115",
                        "intensity": "10006.12",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "0.0005",
                                "ppm": "0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "7",
                        "monoisotopic_mass": "3618.8477",
                        "monoisotopic_mz": "1207.2899",
                        "intensity": "11788.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "8",
                        "monoisotopic_mass": "2579.2895",
                        "monoisotopic_mz": "1290.6520",
                        "intensity": "9907.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "9",
                        "monoisotopic_mass": "3635.8477",
                        "monoisotopic_mz": "1212.9565",
                        "intensity": "8417.22",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "10",
                        "monoisotopic_mass": "2376.0807",
                        "monoisotopic_mz": "793.0342",
                        "intensity": "5854.12",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "0.0002",
                                "ppm": "0.10"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "11",
                        "monoisotopic_mass": "3889.9895",
                        "monoisotopic_mz": "973.5047",
                        "intensity": "5881.16",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "12",
                        "monoisotopic_mass": "2294.1352",
                        "monoisotopic_mz": "1148.0749",
                        "intensity": "6785.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "13",
                        "monoisotopic_mass": "7196.7348",
                        "monoisotopic_mz": "900.5991",
                        "intensity": "7586.21",
                        "charge": "8"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "14",
                        "monoisotopic_mass": "2489.1589",
                        "monoisotopic_mz": "830.7269",
                        "intensity": "6062.15",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "-0.0056",
                                "ppm": "-2.25"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "15",
                        "monoisotopic_mass": "770.3557",
                        "monoisotopic_mz": "771.3630",
                        "intensity": "6491.13",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0002",
                                "ppm": "-0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "16",
                        "monoisotopic_mass": "2903.3402",
                        "monoisotopic_mz": "968.7873",
                        "intensity": "4372.70",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2903.3396",
                                "ion_position": "26",
                                "ion_display_position": "26",
                                "ion_sort_name": "B00026",
                                "ion_left_position": "26",
                                "mass_error": "0.0006",
                                "ppm": "0.21"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "17",
                        "monoisotopic_mass": "2560.1967",
                        "monoisotopic_mz": "854.4062",
                        "intensity": "7834.81",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "-0.0049",
                                "ppm": "-1.91"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "18",
                        "monoisotopic_mass": "2376.0761",
                        "monoisotopic_mz": "1189.0453",
                        "intensity": "3484.60",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "-0.0044",
                                "ppm": "-1.85"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "19",
                        "monoisotopic_mass": "3253.6186",
                        "monoisotopic_mz": "1085.5468",
                        "intensity": "4893.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "20",
                        "monoisotopic_mass": "2658.2683",
                        "monoisotopic_mz": "887.0967",
                        "intensity": "4293.30",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "21",
                        "monoisotopic_mass": "2580.2861",
                        "monoisotopic_mz": "861.1027",
                        "intensity": "3418.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "22",
                        "monoisotopic_mass": "3871.9902",
                        "monoisotopic_mz": "969.0048",
                        "intensity": "5780.77",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "23",
                        "monoisotopic_mass": "3369.7442",
                        "monoisotopic_mz": "1124.2553",
                        "intensity": "4896.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "24",
                        "monoisotopic_mass": "1261.1330",
                        "monoisotopic_mz": "1262.1403",
                        "intensity": "4101.01",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "25",
                        "monoisotopic_mass": "3872.9615",
                        "monoisotopic_mz": "1291.9944",
                        "intensity": "3528.26",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "26",
                        "monoisotopic_mass": "3888.9847",
                        "monoisotopic_mz": "1297.3355",
                        "intensity": "3584.84",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "27",
                        "monoisotopic_mass": "3471.7964",
                        "monoisotopic_mz": "868.9564",
                        "intensity": "3297.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "28",
                        "monoisotopic_mass": "2393.1980",
                        "monoisotopic_mz": "1197.6063",
                        "intensity": "4900.09",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "29",
                        "monoisotopic_mass": "3906.9898",
                        "monoisotopic_mz": "977.7547",
                        "intensity": "4517.00",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "30",
                        "monoisotopic_mass": "3819.9601",
                        "monoisotopic_mz": "1274.3273",
                        "intensity": "4154.36",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3819.9652",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "ion_sort_name": "Y00033",
                                "ion_left_position": "56",
                                "mass_error": "-0.0051",
                                "ppm": "-1.32"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "31",
                        "monoisotopic_mass": "2775.3008",
                        "monoisotopic_mz": "926.1075",
                        "intensity": "3303.35",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "32",
                        "monoisotopic_mass": "3236.6220",
                        "monoisotopic_mz": "1079.8813",
                        "intensity": "2652.65",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "33",
                        "monoisotopic_mass": "3010.4899",
                        "monoisotopic_mz": "1004.5039",
                        "intensity": "2988.33",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3010.5005",
                                "ion_position": "64",
                                "ion_display_position": "25",
                                "ion_sort_name": "Y00025",
                                "ion_left_position": "64",
                                "mass_error": "-0.0106",
                                "ppm": "-3.52"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "34",
                        "monoisotopic_mass": "3471.7972",
                        "monoisotopic_mz": "1158.2730",
                        "intensity": "3250.86",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "35",
                        "monoisotopic_mass": "584.2913",
                        "monoisotopic_mz": "585.2986",
                        "intensity": "1591.96",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "584.2918",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "-0.0005",
                                "ppm": "-0.88"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "36",
                        "monoisotopic_mass": "2229.0097",
                        "monoisotopic_mz": "1115.5121",
                        "intensity": "1160.81",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "-0.0024",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "37",
                        "monoisotopic_mass": "1346.6860",
                        "monoisotopic_mz": "1347.6932",
                        "intensity": "2111.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "38",
                        "monoisotopic_mass": "1280.1011",
                        "monoisotopic_mz": "1281.1084",
                        "intensity": "1605.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "39",
                        "monoisotopic_mass": "1240.3060",
                        "monoisotopic_mz": "1241.3132",
                        "intensity": "1656.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "40",
                        "monoisotopic_mass": "3420.7409",
                        "monoisotopic_mz": "1141.2542",
                        "intensity": "3050.05",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "41",
                        "monoisotopic_mass": "859.7616",
                        "monoisotopic_mz": "860.7689",
                        "intensity": "2834.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "42",
                        "monoisotopic_mass": "1909.9765",
                        "monoisotopic_mz": "955.9955",
                        "intensity": "2066.83",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "43",
                        "monoisotopic_mass": "3518.7958",
                        "monoisotopic_mz": "704.7664",
                        "intensity": "2005.80",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0056",
                                "ppm": "-1.59"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "44",
                        "monoisotopic_mass": "1034.0137",
                        "monoisotopic_mz": "1035.0210",
                        "intensity": "1432.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "45",
                        "monoisotopic_mass": "897.8744",
                        "monoisotopic_mz": "898.8817",
                        "intensity": "1257.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "46",
                        "monoisotopic_mass": "1825.9128",
                        "monoisotopic_mz": "913.9637",
                        "intensity": "1870.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "47",
                        "monoisotopic_mass": "3603.8342",
                        "monoisotopic_mz": "901.9658",
                        "intensity": "1091.96",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "48",
                        "monoisotopic_mass": "4361.2294",
                        "monoisotopic_mz": "1091.3146",
                        "intensity": "2585.87",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "49",
                        "monoisotopic_mass": "3161.1602",
                        "monoisotopic_mz": "1054.7273",
                        "intensity": "2346.57",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "50",
                        "monoisotopic_mass": "786.6894",
                        "monoisotopic_mz": "787.6967",
                        "intensity": "1218.57",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "51",
                        "monoisotopic_mass": "1077.0298",
                        "monoisotopic_mz": "1078.0371",
                        "intensity": "1144.94",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "52",
                        "monoisotopic_mass": "3026.4942",
                        "monoisotopic_mz": "1009.8387",
                        "intensity": "2686.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "53",
                        "monoisotopic_mass": "4062.7804",
                        "monoisotopic_mz": "1016.7024",
                        "intensity": "1135.00",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "54",
                        "monoisotopic_mass": "2160.7552",
                        "monoisotopic_mz": "1081.3849",
                        "intensity": "1685.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "55",
                        "monoisotopic_mass": "1336.7085",
                        "monoisotopic_mz": "669.3615",
                        "intensity": "717.79",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1336.7099",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "ion_sort_name": "B00013",
                                "ion_left_position": "13",
                                "mass_error": "-0.0014",
                                "ppm": "-1.08"
                            }
                        }
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "56",
                        "monoisotopic_mass": "1109.5737",
                        "monoisotopic_mz": "1110.5809",
                        "intensity": "1228.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "57",
                        "monoisotopic_mass": "2211.0744",
                        "monoisotopic_mz": "1106.5445",
                        "intensity": "2002.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "58",
                        "monoisotopic_mass": "2802.9321",
                        "monoisotopic_mz": "935.3180",
                        "intensity": "1465.22",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "59",
                        "monoisotopic_mass": "1091.2327",
                        "monoisotopic_mz": "1092.2400",
                        "intensity": "1226.69",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "60",
                        "monoisotopic_mass": "1048.9231",
                        "monoisotopic_mz": "1049.9304",
                        "intensity": "1204.68",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "61",
                        "monoisotopic_mass": "6208.0963",
                        "monoisotopic_mz": "1035.6900",
                        "intensity": "1335.25",
                        "charge": "6"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "62",
                        "monoisotopic_mass": "2972.3589",
                        "monoisotopic_mz": "991.7936",
                        "intensity": "3076.15",
                        "charge": "3"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "63",
                        "monoisotopic_mass": "1009.6147",
                        "monoisotopic_mz": "1010.6219",
                        "intensity": "2187.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "64",
                        "monoisotopic_mass": "1408.3205",
                        "monoisotopic_mz": "705.1675",
                        "intensity": "1484.54",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "65",
                        "monoisotopic_mass": "7293.6063",
                        "monoisotopic_mz": "912.7081",
                        "intensity": "946.06",
                        "charge": "8"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "66",
                        "monoisotopic_mass": "4043.0912",
                        "monoisotopic_mz": "1011.7801",
                        "intensity": "3143.33",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "67",
                        "monoisotopic_mass": "8182.1105",
                        "monoisotopic_mz": "910.1307",
                        "intensity": "2523.78",
                        "charge": "9"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "68",
                        "monoisotopic_mass": "916.4694",
                        "monoisotopic_mz": "917.4767",
                        "intensity": "1415.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "69",
                        "monoisotopic_mass": "981.9318",
                        "monoisotopic_mz": "982.9391",
                        "intensity": "1044.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "70",
                        "monoisotopic_mass": "2333.5005",
                        "monoisotopic_mz": "1167.7575",
                        "intensity": "2354.90",
                        "charge": "2"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "71",
                        "monoisotopic_mass": "3548.7741",
                        "monoisotopic_mz": "888.2008",
                        "intensity": "3569.81",
                        "charge": "4"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "72",
                        "monoisotopic_mass": "933.9758",
                        "monoisotopic_mz": "934.9830",
                        "intensity": "794.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "73",
                        "monoisotopic_mass": "1123.2368",
                        "monoisotopic_mz": "1124.2440",
                        "intensity": "646.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "215",
                        "peak_id": "74",
                        "monoisotopic_mass": "843.1794",
                        "monoisotopic_mz": "844.1867",
                        "intensity": "1038.14",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "6",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9864.1403",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "215",
                                "peak_id": "35",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "215",
                                "peak_id": "15",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "spec_id": "215",
                                "peak_id": "55",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "20",
                                    "ion_display_position": "20",
                                    "spec_id": "215",
                                    "peak_id": "36",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "20",
                                    "ion_display_position": "20",
                                    "spec_id": "215",
                                    "peak_id": "6",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "215",
                                    "peak_id": "18",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "215",
                                    "peak_id": "10",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "215",
                                "peak_id": "14",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "spec_id": "215",
                                "peak_id": "17",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "26",
                                "ion_display_position": "26",
                                "spec_id": "215",
                                "peak_id": "16",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "spec_id": "215",
                                "peak_id": "30",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "spec_id": "215",
                                "peak_id": "5",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "215",
                                    "peak_id": "43",
                                    "peak_charge": "5"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "215",
                                    "peak_id": "0",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "215",
                                    "peak_id": "1",
                                    "peak_charge": "4"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "64",
                                "ion_display_position": "25",
                                "spec_id": "215",
                                "peak_id": "33",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "47",
                    "right_position": "77",
                    "anno": "15.2686",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
