prsm_data =
{
    "prsm": {
        "prsm_id": "154",
        "p_value": "6.59e-05",
        "e_value": "6.59e-05",
        "fdr": "0",
        "matched_fragment_number": "12",
        "matched_peak_number": "13",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "122",
                "ms1_scans": "336",
                "ids": "214",
                "scans": "338",
                "precursor_mono_mass": "15920.2217",
                "precursor_charge": "18",
                "precursor_mz": "885.4640",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "214",
                        "peak_id": "0",
                        "monoisotopic_mass": "6429.3433",
                        "monoisotopic_mz": "1072.5645",
                        "intensity": "15095.11",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6429.3359",
                                "ion_position": "90",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "90",
                                "mass_error": "0.0074",
                                "ppm": "1.15"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "1",
                        "monoisotopic_mass": "6428.3438",
                        "monoisotopic_mz": "919.3421",
                        "intensity": "6634.85",
                        "charge": "7",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6427.2473",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "ion_sort_name": "B00060",
                                    "ion_left_position": "60",
                                    "mass_error": "0.0942",
                                    "ppm": "14.65"
                                },
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6429.3359",
                                    "ion_position": "90",
                                    "ion_display_position": "58",
                                    "ion_sort_name": "Y00058",
                                    "ion_left_position": "90",
                                    "mass_error": "0.0102",
                                    "ppm": "1.59"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "2",
                        "monoisotopic_mass": "4361.2136",
                        "monoisotopic_mz": "873.2500",
                        "intensity": "9491.96",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0056",
                                "ppm": "-1.29"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "3",
                        "monoisotopic_mass": "2137.1112",
                        "monoisotopic_mz": "1069.5629",
                        "intensity": "4274.65",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "4",
                        "monoisotopic_mass": "1136.6195",
                        "monoisotopic_mz": "1137.6268",
                        "intensity": "4562.90",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "0.0005",
                                "ppm": "0.48"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "5",
                        "monoisotopic_mass": "4360.2173",
                        "monoisotopic_mz": "1091.0616",
                        "intensity": "5375.48",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "6",
                        "monoisotopic_mass": "3535.7941",
                        "monoisotopic_mz": "884.9558",
                        "intensity": "5081.10",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "7",
                        "monoisotopic_mass": "7062.6479",
                        "monoisotopic_mz": "883.8383",
                        "intensity": "2676.87",
                        "charge": "8"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "8",
                        "monoisotopic_mass": "5873.0642",
                        "monoisotopic_mz": "979.8513",
                        "intensity": "2663.20",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5874.0707",
                                "ion_position": "96",
                                "ion_display_position": "52",
                                "ion_sort_name": "Y00052",
                                "ion_left_position": "96",
                                "mass_error": "-0.0041",
                                "ppm": "-0.71"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "9",
                        "monoisotopic_mass": "4574.2466",
                        "monoisotopic_mz": "915.8566",
                        "intensity": "3242.20",
                        "charge": "5"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "10",
                        "monoisotopic_mass": "2669.7112",
                        "monoisotopic_mz": "890.9110",
                        "intensity": "2677.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "11",
                        "monoisotopic_mass": "3055.8577",
                        "monoisotopic_mz": "1019.6265",
                        "intensity": "2559.59",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "12",
                        "monoisotopic_mass": "3761.9085",
                        "monoisotopic_mz": "941.4844",
                        "intensity": "3168.89",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "13",
                        "monoisotopic_mass": "11428.8397",
                        "monoisotopic_mz": "953.4106",
                        "intensity": "2434.03",
                        "charge": "12",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "-1.9123669624",
                                "theoretical_mass": "11428.9692",
                                "ion_position": "109",
                                "ion_display_position": "109",
                                "ion_sort_name": "B00109",
                                "ion_left_position": "109",
                                "mass_error": "-0.1295",
                                "ppm": "-11.33"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "14",
                        "monoisotopic_mass": "3012.6170",
                        "monoisotopic_mz": "1005.2129",
                        "intensity": "2481.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "15",
                        "monoisotopic_mass": "2202.4296",
                        "monoisotopic_mz": "1102.2221",
                        "intensity": "1059.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "16",
                        "monoisotopic_mass": "980.4864",
                        "monoisotopic_mz": "981.4937",
                        "intensity": "1314.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "17",
                        "monoisotopic_mass": "2081.0686",
                        "monoisotopic_mz": "1041.5416",
                        "intensity": "1888.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "18",
                        "monoisotopic_mass": "2308.2436",
                        "monoisotopic_mz": "1155.1291",
                        "intensity": "987.08",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "19",
                        "monoisotopic_mass": "914.2219",
                        "monoisotopic_mz": "915.2291",
                        "intensity": "988.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "20",
                        "monoisotopic_mass": "9793.4042",
                        "monoisotopic_mz": "980.3477",
                        "intensity": "999.01",
                        "charge": "10"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "21",
                        "monoisotopic_mass": "1780.8990",
                        "monoisotopic_mz": "891.4568",
                        "intensity": "1209.67",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "22",
                        "monoisotopic_mass": "938.9865",
                        "monoisotopic_mz": "939.9938",
                        "intensity": "1381.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "23",
                        "monoisotopic_mass": "8849.8181",
                        "monoisotopic_mz": "885.9891",
                        "intensity": "826.46",
                        "charge": "10"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "24",
                        "monoisotopic_mass": "6089.1594",
                        "monoisotopic_mz": "1015.8672",
                        "intensity": "2910.78",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6089.1613",
                                "ion_position": "94",
                                "ion_display_position": "54",
                                "ion_sort_name": "Y00054",
                                "ion_left_position": "94",
                                "mass_error": "-0.0019",
                                "ppm": "-0.30"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "25",
                        "monoisotopic_mass": "6428.3450",
                        "monoisotopic_mz": "1286.6763",
                        "intensity": "1218.06",
                        "charge": "5",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6427.2473",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "ion_sort_name": "B00060",
                                    "ion_left_position": "60",
                                    "mass_error": "0.0954",
                                    "ppm": "14.84"
                                },
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6429.3359",
                                    "ion_position": "90",
                                    "ion_display_position": "58",
                                    "ion_sort_name": "Y00058",
                                    "ion_left_position": "90",
                                    "mass_error": "0.0114",
                                    "ppm": "1.78"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "26",
                        "monoisotopic_mass": "9337.8381",
                        "monoisotopic_mz": "1038.5448",
                        "intensity": "1320.58",
                        "charge": "9"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "27",
                        "monoisotopic_mass": "4090.0760",
                        "monoisotopic_mz": "819.0225",
                        "intensity": "1156.52",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4090.0661",
                                "ion_position": "36",
                                "ion_display_position": "36",
                                "ion_sort_name": "B00036",
                                "ion_left_position": "36",
                                "mass_error": "0.0099",
                                "ppm": "2.42"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "28",
                        "monoisotopic_mass": "4415.3601",
                        "monoisotopic_mz": "884.0793",
                        "intensity": "2622.13",
                        "charge": "5"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "29",
                        "monoisotopic_mass": "5393.7677",
                        "monoisotopic_mz": "899.9686",
                        "intensity": "686.87",
                        "charge": "6"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "30",
                        "monoisotopic_mass": "871.2291",
                        "monoisotopic_mz": "872.2363",
                        "intensity": "1593.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "31",
                        "monoisotopic_mass": "8782.4013",
                        "monoisotopic_mz": "976.8296",
                        "intensity": "1277.38",
                        "charge": "9"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "32",
                        "monoisotopic_mass": "1000.5133",
                        "monoisotopic_mz": "1001.5206",
                        "intensity": "1354.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "33",
                        "monoisotopic_mass": "3710.9766",
                        "monoisotopic_mz": "928.7514",
                        "intensity": "905.66",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "34",
                        "monoisotopic_mass": "1100.8935",
                        "monoisotopic_mz": "1101.9008",
                        "intensity": "2165.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "35",
                        "monoisotopic_mass": "5211.6085",
                        "monoisotopic_mz": "1043.3290",
                        "intensity": "1099.25",
                        "charge": "5"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "36",
                        "monoisotopic_mass": "6371.2432",
                        "monoisotopic_mz": "911.1849",
                        "intensity": "1230.34",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6370.2258",
                                "ion_position": "59",
                                "ion_display_position": "59",
                                "ion_sort_name": "B00059",
                                "ion_left_position": "59",
                                "mass_error": "0.0150",
                                "ppm": "2.36"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "37",
                        "monoisotopic_mass": "1073.2625",
                        "monoisotopic_mz": "1074.2698",
                        "intensity": "1072.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "38",
                        "monoisotopic_mass": "1027.0355",
                        "monoisotopic_mz": "1028.0427",
                        "intensity": "688.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "39",
                        "monoisotopic_mass": "4212.4940",
                        "monoisotopic_mz": "843.5061",
                        "intensity": "1915.84",
                        "charge": "5"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "40",
                        "monoisotopic_mass": "6295.4020",
                        "monoisotopic_mz": "900.3504",
                        "intensity": "1984.50",
                        "charge": "7"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "41",
                        "monoisotopic_mass": "755.4197",
                        "monoisotopic_mz": "756.4270",
                        "intensity": "1802.84",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "142",
                                "mass_error": "0.0019",
                                "ppm": "2.57"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "42",
                        "monoisotopic_mass": "953.3060",
                        "monoisotopic_mz": "954.3133",
                        "intensity": "999.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "43",
                        "monoisotopic_mass": "887.4756",
                        "monoisotopic_mz": "888.4829",
                        "intensity": "1658.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "44",
                        "monoisotopic_mass": "12399.5243",
                        "monoisotopic_mz": "954.8168",
                        "intensity": "1118.17",
                        "charge": "13"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "45",
                        "monoisotopic_mass": "7758.9186",
                        "monoisotopic_mz": "863.1093",
                        "intensity": "1204.97",
                        "charge": "9"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "46",
                        "monoisotopic_mass": "2795.9946",
                        "monoisotopic_mz": "933.0055",
                        "intensity": "1087.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "47",
                        "monoisotopic_mass": "8756.2303",
                        "monoisotopic_mz": "876.6303",
                        "intensity": "886.03",
                        "charge": "10"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "48",
                        "monoisotopic_mass": "5462.8917",
                        "monoisotopic_mz": "1093.5856",
                        "intensity": "928.00",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5462.8912",
                                "ion_position": "99",
                                "ion_display_position": "49",
                                "ion_sort_name": "Y00049",
                                "ion_left_position": "99",
                                "mass_error": "0.0005",
                                "ppm": "0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "49",
                        "monoisotopic_mass": "845.4248",
                        "monoisotopic_mz": "846.4321",
                        "intensity": "1248.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "50",
                        "monoisotopic_mass": "1121.2409",
                        "monoisotopic_mz": "1122.2482",
                        "intensity": "733.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "51",
                        "monoisotopic_mass": "2695.0715",
                        "monoisotopic_mz": "899.3644",
                        "intensity": "2034.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "52",
                        "monoisotopic_mass": "7022.5827",
                        "monoisotopic_mz": "878.8301",
                        "intensity": "2313.19",
                        "charge": "8"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "53",
                        "monoisotopic_mass": "8271.1614",
                        "monoisotopic_mz": "1034.9025",
                        "intensity": "1223.81",
                        "charge": "8"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "54",
                        "monoisotopic_mass": "14020.0743",
                        "monoisotopic_mz": "935.6789",
                        "intensity": "1166.13",
                        "charge": "15"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "55",
                        "monoisotopic_mass": "1925.7410",
                        "monoisotopic_mz": "963.8778",
                        "intensity": "1353.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "56",
                        "monoisotopic_mass": "14139.3220",
                        "monoisotopic_mz": "884.7149",
                        "intensity": "2449.34",
                        "charge": "16"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "57",
                        "monoisotopic_mass": "3852.5199",
                        "monoisotopic_mz": "964.1372",
                        "intensity": "831.60",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "58",
                        "monoisotopic_mass": "9112.0076",
                        "monoisotopic_mz": "1013.4526",
                        "intensity": "1205.87",
                        "charge": "9"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "59",
                        "monoisotopic_mass": "2631.6972",
                        "monoisotopic_mz": "878.2397",
                        "intensity": "1003.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "60",
                        "monoisotopic_mass": "6323.8006",
                        "monoisotopic_mz": "904.4074",
                        "intensity": "1744.80",
                        "charge": "7"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "61",
                        "monoisotopic_mass": "965.4911",
                        "monoisotopic_mz": "966.4984",
                        "intensity": "1114.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "62",
                        "monoisotopic_mass": "15490.1156",
                        "monoisotopic_mz": "861.5693",
                        "intensity": "1227.48",
                        "charge": "18",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-1.9123669624",
                                "theoretical_mass": "15489.1148",
                                "ion_position": "4",
                                "ion_display_position": "144",
                                "ion_sort_name": "Y00144",
                                "ion_left_position": "4",
                                "mass_error": "-0.0016",
                                "ppm": "-0.10"
                            }
                        }
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "63",
                        "monoisotopic_mass": "1720.8668",
                        "monoisotopic_mz": "861.4407",
                        "intensity": "2145.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "64",
                        "monoisotopic_mass": "3272.6710",
                        "monoisotopic_mz": "1091.8976",
                        "intensity": "2240.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "65",
                        "monoisotopic_mass": "5569.7555",
                        "monoisotopic_mz": "929.2999",
                        "intensity": "2076.42",
                        "charge": "6"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "66",
                        "monoisotopic_mass": "7421.6256",
                        "monoisotopic_mz": "928.7105",
                        "intensity": "813.14",
                        "charge": "8"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "67",
                        "monoisotopic_mass": "2611.3421",
                        "monoisotopic_mz": "871.4546",
                        "intensity": "2785.00",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "68",
                        "monoisotopic_mass": "9264.7987",
                        "monoisotopic_mz": "843.2617",
                        "intensity": "942.67",
                        "charge": "11"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "69",
                        "monoisotopic_mass": "6583.9573",
                        "monoisotopic_mz": "941.5726",
                        "intensity": "2631.05",
                        "charge": "7"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "70",
                        "monoisotopic_mass": "2582.3490",
                        "monoisotopic_mz": "861.7903",
                        "intensity": "997.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "71",
                        "monoisotopic_mass": "3875.5063",
                        "monoisotopic_mz": "969.8838",
                        "intensity": "1010.67",
                        "charge": "4"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "72",
                        "monoisotopic_mass": "2746.8630",
                        "monoisotopic_mz": "916.6283",
                        "intensity": "1107.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "73",
                        "monoisotopic_mass": "6184.2720",
                        "monoisotopic_mz": "1031.7193",
                        "intensity": "2272.74",
                        "charge": "6"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "74",
                        "monoisotopic_mass": "900.8075",
                        "monoisotopic_mz": "901.8148",
                        "intensity": "1331.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "75",
                        "monoisotopic_mass": "8305.9949",
                        "monoisotopic_mz": "923.8956",
                        "intensity": "1271.27",
                        "charge": "9"
                    },
                    {
                        "spec_id": "214",
                        "peak_id": "76",
                        "monoisotopic_mass": "810.1196",
                        "monoisotopic_mz": "811.1269",
                        "intensity": "874.06",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15920.3317",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "4",
                                "ion_display_position": "144",
                                "spec_id": "214",
                                "peak_id": "62",
                                "peak_charge": "18"
                            }
                        }
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "36",
                                "ion_display_position": "36",
                                "spec_id": "214",
                                "peak_id": "27",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "214",
                                "peak_id": "2",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "59",
                                "ion_display_position": "59",
                                "spec_id": "214",
                                "peak_id": "36",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "spec_id": "214",
                                    "peak_id": "1",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "spec_id": "214",
                                    "peak_id": "25",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "90",
                                    "ion_display_position": "58",
                                    "spec_id": "214",
                                    "peak_id": "0",
                                    "peak_charge": "6"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "90",
                                    "ion_display_position": "58",
                                    "spec_id": "214",
                                    "peak_id": "1",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "90",
                                    "ion_display_position": "58",
                                    "spec_id": "214",
                                    "peak_id": "25",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "94",
                                "ion_display_position": "54",
                                "spec_id": "214",
                                "peak_id": "24",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "96",
                                "ion_display_position": "52",
                                "spec_id": "214",
                                "peak_id": "8",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "99",
                                "ion_display_position": "49",
                                "spec_id": "214",
                                "peak_id": "48",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "109",
                                "ion_display_position": "109",
                                "spec_id": "214",
                                "peak_id": "13",
                                "peak_charge": "12"
                            }
                        }
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "spec_id": "214",
                                "peak_id": "4",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "spec_id": "214",
                                "peak_id": "41",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "61",
                    "right_position": "91",
                    "anno": "-1.9124",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
