prsm_data =
{
    "prsm": {
        "prsm_id": "152",
        "p_value": "6.88e-04",
        "e_value": "6.88e-04",
        "fdr": "0",
        "matched_fragment_number": "6",
        "matched_peak_number": "7",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "121",
                "ms1_scans": "331",
                "ids": "211",
                "scans": "334",
                "precursor_mono_mass": "15921.2302",
                "precursor_charge": "16",
                "precursor_mz": "996.0842",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "211",
                        "peak_id": "0",
                        "monoisotopic_mass": "7543.8765",
                        "monoisotopic_mz": "1258.3200",
                        "intensity": "7053.30",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "79",
                                "mass_error": "-0.0029",
                                "ppm": "-0.39"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "1",
                        "monoisotopic_mass": "7544.8762",
                        "monoisotopic_mz": "1078.8467",
                        "intensity": "5954.11",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "79",
                                "mass_error": "-0.0057",
                                "ppm": "-0.75"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "2",
                        "monoisotopic_mass": "7474.8344",
                        "monoisotopic_mz": "1068.8408",
                        "intensity": "4230.56",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "80",
                                "mass_error": "-0.0127",
                                "ppm": "-1.70"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "3",
                        "monoisotopic_mass": "14487.2245",
                        "monoisotopic_mz": "966.8222",
                        "intensity": "1426.40",
                        "charge": "15"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "4",
                        "monoisotopic_mass": "973.7545",
                        "monoisotopic_mz": "974.7618",
                        "intensity": "1690.35",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "5",
                        "monoisotopic_mass": "3616.8080",
                        "monoisotopic_mz": "905.2093",
                        "intensity": "868.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "6",
                        "monoisotopic_mass": "8314.3412",
                        "monoisotopic_mz": "924.8230",
                        "intensity": "1138.28",
                        "charge": "9"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "7",
                        "monoisotopic_mass": "7800.0061",
                        "monoisotopic_mz": "1115.2939",
                        "intensity": "855.48",
                        "charge": "7"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "8",
                        "monoisotopic_mass": "5897.0561",
                        "monoisotopic_mz": "983.8500",
                        "intensity": "1026.88",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5897.0137",
                                "ion_position": "54",
                                "ion_display_position": "54",
                                "ion_sort_name": "B00054",
                                "ion_left_position": "54",
                                "mass_error": "0.0424",
                                "ppm": "7.20"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "9",
                        "monoisotopic_mass": "12763.4863",
                        "monoisotopic_mz": "1064.6311",
                        "intensity": "818.31",
                        "charge": "12"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "10",
                        "monoisotopic_mass": "6125.2777",
                        "monoisotopic_mz": "1021.8869",
                        "intensity": "1892.94",
                        "charge": "6"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "11",
                        "monoisotopic_mass": "2982.5341",
                        "monoisotopic_mz": "995.1853",
                        "intensity": "2485.23",
                        "charge": "3"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "12",
                        "monoisotopic_mass": "1090.3876",
                        "monoisotopic_mz": "1091.3949",
                        "intensity": "1158.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "13",
                        "monoisotopic_mass": "4492.3674",
                        "monoisotopic_mz": "1124.0991",
                        "intensity": "1146.68",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "14",
                        "monoisotopic_mass": "3195.9510",
                        "monoisotopic_mz": "1066.3243",
                        "intensity": "1893.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "15",
                        "monoisotopic_mass": "3934.1212",
                        "monoisotopic_mz": "984.5376",
                        "intensity": "964.40",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "16",
                        "monoisotopic_mass": "4361.2079",
                        "monoisotopic_mz": "1091.3092",
                        "intensity": "3055.41",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0114",
                                "ppm": "-2.61"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "17",
                        "monoisotopic_mass": "7195.3845",
                        "monoisotopic_mz": "900.4303",
                        "intensity": "867.74",
                        "charge": "8"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "18",
                        "monoisotopic_mass": "1810.9274",
                        "monoisotopic_mz": "906.4710",
                        "intensity": "1386.58",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "19",
                        "monoisotopic_mass": "11424.6985",
                        "monoisotopic_mz": "1039.6162",
                        "intensity": "852.57",
                        "charge": "11"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "20",
                        "monoisotopic_mass": "3215.6469",
                        "monoisotopic_mz": "1072.8896",
                        "intensity": "2504.99",
                        "charge": "3"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "21",
                        "monoisotopic_mass": "1041.3901",
                        "monoisotopic_mz": "1042.3973",
                        "intensity": "687.53",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "22",
                        "monoisotopic_mass": "2819.9276",
                        "monoisotopic_mz": "940.9831",
                        "intensity": "2281.10",
                        "charge": "3"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "23",
                        "monoisotopic_mass": "9101.4698",
                        "monoisotopic_mz": "1138.6910",
                        "intensity": "1368.55",
                        "charge": "8"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "24",
                        "monoisotopic_mass": "2137.1001",
                        "monoisotopic_mz": "1069.5573",
                        "intensity": "2520.60",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "25",
                        "monoisotopic_mass": "4362.2239",
                        "monoisotopic_mz": "873.4521",
                        "intensity": "2832.07",
                        "charge": "5"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "26",
                        "monoisotopic_mass": "902.0276",
                        "monoisotopic_mz": "903.0348",
                        "intensity": "1090.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "27",
                        "monoisotopic_mass": "5997.0544",
                        "monoisotopic_mz": "1000.5163",
                        "intensity": "927.81",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5998.0613",
                                "ion_position": "55",
                                "ion_display_position": "55",
                                "ion_sort_name": "B00055",
                                "ion_left_position": "55",
                                "mass_error": "-0.0046",
                                "ppm": "-0.76"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "28",
                        "monoisotopic_mass": "2033.0445",
                        "monoisotopic_mz": "1017.5295",
                        "intensity": "1197.05",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "29",
                        "monoisotopic_mass": "6796.1201",
                        "monoisotopic_mz": "1133.6940",
                        "intensity": "2228.50",
                        "charge": "6"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "30",
                        "monoisotopic_mass": "1203.9103",
                        "monoisotopic_mz": "1204.9176",
                        "intensity": "691.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "31",
                        "monoisotopic_mass": "1136.6175",
                        "monoisotopic_mz": "1137.6248",
                        "intensity": "1709.61",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "-0.0015",
                                "ppm": "-1.34"
                            }
                        }
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "32",
                        "monoisotopic_mass": "1953.0015",
                        "monoisotopic_mz": "977.5080",
                        "intensity": "1618.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "33",
                        "monoisotopic_mass": "10663.4746",
                        "monoisotopic_mz": "1067.3547",
                        "intensity": "2033.07",
                        "charge": "10"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "34",
                        "monoisotopic_mass": "2002.0349",
                        "monoisotopic_mz": "1002.0247",
                        "intensity": "2198.11",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "35",
                        "monoisotopic_mass": "1878.6151",
                        "monoisotopic_mz": "940.3148",
                        "intensity": "906.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "36",
                        "monoisotopic_mass": "7550.5116",
                        "monoisotopic_mz": "944.8212",
                        "intensity": "2933.08",
                        "charge": "8"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "37",
                        "monoisotopic_mass": "1290.1452",
                        "monoisotopic_mz": "1291.1525",
                        "intensity": "600.65",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "38",
                        "monoisotopic_mass": "1190.1025",
                        "monoisotopic_mz": "1191.1097",
                        "intensity": "719.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "39",
                        "monoisotopic_mass": "3717.8495",
                        "monoisotopic_mz": "930.4696",
                        "intensity": "990.23",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "40",
                        "monoisotopic_mass": "8036.2249",
                        "monoisotopic_mz": "1005.5354",
                        "intensity": "1178.77",
                        "charge": "8"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "41",
                        "monoisotopic_mass": "3987.0316",
                        "monoisotopic_mz": "997.7652",
                        "intensity": "2940.34",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "42",
                        "monoisotopic_mass": "1027.2362",
                        "monoisotopic_mz": "1028.2435",
                        "intensity": "933.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "43",
                        "monoisotopic_mass": "1151.0773",
                        "monoisotopic_mz": "1152.0846",
                        "intensity": "746.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "44",
                        "monoisotopic_mass": "4967.1153",
                        "monoisotopic_mz": "1242.7861",
                        "intensity": "1695.04",
                        "charge": "4"
                    },
                    {
                        "spec_id": "211",
                        "peak_id": "45",
                        "monoisotopic_mass": "890.3429",
                        "monoisotopic_mz": "891.3502",
                        "intensity": "950.03",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15922.2440",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "211",
                                "peak_id": "16",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "54",
                                "ion_display_position": "54",
                                "spec_id": "211",
                                "peak_id": "8",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "55",
                                "ion_display_position": "55",
                                "spec_id": "211",
                                "peak_id": "27",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "79",
                                    "ion_display_position": "69",
                                    "spec_id": "211",
                                    "peak_id": "1",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "79",
                                    "ion_display_position": "69",
                                    "spec_id": "211",
                                    "peak_id": "0",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "spec_id": "211",
                                "peak_id": "2",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "spec_id": "211",
                                "peak_id": "31",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
