prsm_data =
{
    "prsm": {
        "prsm_id": "136",
        "p_value": "8.86e-05",
        "e_value": "8.86e-05",
        "fdr": "0",
        "matched_fragment_number": "9",
        "matched_peak_number": "10",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "116",
                "ms1_scans": "304",
                "ids": "187",
                "scans": "305",
                "precursor_mono_mass": "15922.2107",
                "precursor_charge": "17",
                "precursor_mz": "937.6079",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "187",
                        "peak_id": "0",
                        "monoisotopic_mass": "7478.8876",
                        "monoisotopic_mz": "935.8682",
                        "intensity": "22307.14",
                        "charge": "8"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "1",
                        "monoisotopic_mass": "7543.8765",
                        "monoisotopic_mz": "1078.7039",
                        "intensity": "13705.45",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "79",
                                "mass_error": "-0.0030",
                                "ppm": "-0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "2",
                        "monoisotopic_mass": "7473.8414",
                        "monoisotopic_mz": "1068.6989",
                        "intensity": "8471.03",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "80",
                                "mass_error": "-0.0033",
                                "ppm": "-0.44"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "3",
                        "monoisotopic_mass": "4361.2226",
                        "monoisotopic_mz": "873.2518",
                        "intensity": "6529.67",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "0.0034",
                                "ppm": "0.77"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "4",
                        "monoisotopic_mass": "6430.3529",
                        "monoisotopic_mz": "1072.7328",
                        "intensity": "7757.71",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6429.3359",
                                "ion_position": "90",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "90",
                                "mass_error": "0.0146",
                                "ppm": "2.28"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "5",
                        "monoisotopic_mass": "1136.6191",
                        "monoisotopic_mz": "1137.6263",
                        "intensity": "5065.77",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "0.0001",
                                "ppm": "0.05"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "6",
                        "monoisotopic_mass": "13368.7871",
                        "monoisotopic_mz": "1029.3755",
                        "intensity": "2286.04",
                        "charge": "13"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "7",
                        "monoisotopic_mass": "2310.2452",
                        "monoisotopic_mz": "1156.1299",
                        "intensity": "1660.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "8",
                        "monoisotopic_mass": "6540.3445",
                        "monoisotopic_mz": "1091.0647",
                        "intensity": "1548.19",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6540.3314",
                                "ion_position": "61",
                                "ion_display_position": "61",
                                "ion_sort_name": "B00061",
                                "ion_left_position": "61",
                                "mass_error": "0.0132",
                                "ppm": "2.02"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "9",
                        "monoisotopic_mass": "4574.3136",
                        "monoisotopic_mz": "915.8700",
                        "intensity": "2254.92",
                        "charge": "5"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "10",
                        "monoisotopic_mass": "4554.3668",
                        "monoisotopic_mz": "1139.5990",
                        "intensity": "2885.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "11",
                        "monoisotopic_mass": "5639.8633",
                        "monoisotopic_mz": "940.9845",
                        "intensity": "4440.54",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5640.8601",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "ion_sort_name": "B00051",
                                "ion_left_position": "51",
                                "mass_error": "0.0055",
                                "ppm": "0.98"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "12",
                        "monoisotopic_mass": "986.4931",
                        "monoisotopic_mz": "987.5004",
                        "intensity": "1246.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "13",
                        "monoisotopic_mass": "13008.6363",
                        "monoisotopic_mz": "1001.6716",
                        "intensity": "3170.04",
                        "charge": "13"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "14",
                        "monoisotopic_mass": "15851.8680",
                        "monoisotopic_mz": "933.4701",
                        "intensity": "1217.81",
                        "charge": "17"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "15",
                        "monoisotopic_mass": "2172.1119",
                        "monoisotopic_mz": "1087.0633",
                        "intensity": "1076.64",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "16",
                        "monoisotopic_mass": "15904.1264",
                        "monoisotopic_mz": "936.5441",
                        "intensity": "1223.64",
                        "charge": "17"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "17",
                        "monoisotopic_mass": "7791.0523",
                        "monoisotopic_mz": "866.6798",
                        "intensity": "1167.36",
                        "charge": "9"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "18",
                        "monoisotopic_mass": "958.7352",
                        "monoisotopic_mz": "959.7424",
                        "intensity": "2121.39",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "19",
                        "monoisotopic_mass": "14011.3960",
                        "monoisotopic_mz": "935.1003",
                        "intensity": "1382.15",
                        "charge": "15"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "20",
                        "monoisotopic_mass": "7631.6934",
                        "monoisotopic_mz": "1091.2492",
                        "intensity": "1409.53",
                        "charge": "7"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "21",
                        "monoisotopic_mass": "4843.5794",
                        "monoisotopic_mz": "969.7232",
                        "intensity": "3074.37",
                        "charge": "5"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "22",
                        "monoisotopic_mass": "9401.4472",
                        "monoisotopic_mz": "941.1520",
                        "intensity": "2445.45",
                        "charge": "10"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "23",
                        "monoisotopic_mass": "6082.1135",
                        "monoisotopic_mz": "869.8806",
                        "intensity": "2273.31",
                        "charge": "7"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "24",
                        "monoisotopic_mass": "1176.7803",
                        "monoisotopic_mz": "1177.7876",
                        "intensity": "974.46",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "25",
                        "monoisotopic_mass": "7875.0241",
                        "monoisotopic_mz": "876.0099",
                        "intensity": "1269.96",
                        "charge": "9"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "26",
                        "monoisotopic_mass": "5611.1567",
                        "monoisotopic_mz": "936.2001",
                        "intensity": "849.00",
                        "charge": "6"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "27",
                        "monoisotopic_mass": "909.2986",
                        "monoisotopic_mz": "910.3058",
                        "intensity": "1795.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "28",
                        "monoisotopic_mass": "2748.5374",
                        "monoisotopic_mz": "917.1864",
                        "intensity": "2176.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "29",
                        "monoisotopic_mass": "7649.8509",
                        "monoisotopic_mz": "850.9907",
                        "intensity": "948.69",
                        "charge": "9"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "30",
                        "monoisotopic_mass": "8119.2189",
                        "monoisotopic_mz": "903.1427",
                        "intensity": "1683.99",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8120.2247",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0035",
                                "ppm": "-0.43"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "31",
                        "monoisotopic_mass": "10994.1310",
                        "monoisotopic_mz": "917.1849",
                        "intensity": "1271.18",
                        "charge": "12"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "32",
                        "monoisotopic_mass": "755.4177",
                        "monoisotopic_mz": "756.4250",
                        "intensity": "2001.12",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "142",
                                "mass_error": "-0.0001",
                                "ppm": "-0.10"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "33",
                        "monoisotopic_mass": "9163.6026",
                        "monoisotopic_mz": "1019.1853",
                        "intensity": "1038.65",
                        "charge": "9"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "34",
                        "monoisotopic_mass": "6412.3079",
                        "monoisotopic_mz": "1069.7253",
                        "intensity": "4257.14",
                        "charge": "6"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "35",
                        "monoisotopic_mass": "888.4560",
                        "monoisotopic_mz": "889.4633",
                        "intensity": "1823.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "36",
                        "monoisotopic_mass": "7597.1105",
                        "monoisotopic_mz": "1086.3088",
                        "intensity": "2090.19",
                        "charge": "7"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "37",
                        "monoisotopic_mass": "15305.4358",
                        "monoisotopic_mz": "1021.3697",
                        "intensity": "914.37",
                        "charge": "15"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "38",
                        "monoisotopic_mass": "1015.3628",
                        "monoisotopic_mz": "1016.3701",
                        "intensity": "1295.86",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "39",
                        "monoisotopic_mass": "11129.4543",
                        "monoisotopic_mz": "928.4618",
                        "intensity": "1631.29",
                        "charge": "12"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "40",
                        "monoisotopic_mass": "11200.7911",
                        "monoisotopic_mz": "1019.2610",
                        "intensity": "1026.60",
                        "charge": "11"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "41",
                        "monoisotopic_mass": "6073.1025",
                        "monoisotopic_mz": "1013.1910",
                        "intensity": "2606.63",
                        "charge": "6"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "42",
                        "monoisotopic_mass": "7004.0136",
                        "monoisotopic_mz": "1001.5807",
                        "intensity": "2379.53",
                        "charge": "7"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "43",
                        "monoisotopic_mass": "4665.4334",
                        "monoisotopic_mz": "934.0940",
                        "intensity": "2134.90",
                        "charge": "5"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "44",
                        "monoisotopic_mass": "8317.1341",
                        "monoisotopic_mz": "1040.6490",
                        "intensity": "1314.91",
                        "charge": "8"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "45",
                        "monoisotopic_mass": "1041.5331",
                        "monoisotopic_mz": "1042.5404",
                        "intensity": "1597.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "46",
                        "monoisotopic_mass": "1136.6184",
                        "monoisotopic_mz": "569.3165",
                        "intensity": "743.05",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "-0.0006",
                                "ppm": "-0.55"
                            }
                        }
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "47",
                        "monoisotopic_mass": "1029.3598",
                        "monoisotopic_mz": "1030.3671",
                        "intensity": "1066.10",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "48",
                        "monoisotopic_mass": "3046.0880",
                        "monoisotopic_mz": "1016.3699",
                        "intensity": "1406.28",
                        "charge": "3"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "49",
                        "monoisotopic_mass": "11927.7027",
                        "monoisotopic_mz": "1085.3439",
                        "intensity": "917.17",
                        "charge": "11"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "50",
                        "monoisotopic_mass": "4513.0160",
                        "monoisotopic_mz": "903.6105",
                        "intensity": "1775.66",
                        "charge": "5"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "51",
                        "monoisotopic_mass": "2117.4027",
                        "monoisotopic_mz": "1059.7086",
                        "intensity": "2001.08",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "52",
                        "monoisotopic_mass": "2228.8070",
                        "monoisotopic_mz": "1115.4108",
                        "intensity": "1620.29",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "53",
                        "monoisotopic_mass": "12613.6765",
                        "monoisotopic_mz": "841.9190",
                        "intensity": "1428.77",
                        "charge": "15"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "54",
                        "monoisotopic_mass": "1737.8855",
                        "monoisotopic_mz": "869.9500",
                        "intensity": "1052.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "55",
                        "monoisotopic_mass": "1839.9252",
                        "monoisotopic_mz": "920.9699",
                        "intensity": "1584.33",
                        "charge": "2"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "56",
                        "monoisotopic_mass": "4303.6290",
                        "monoisotopic_mz": "1076.9145",
                        "intensity": "1682.96",
                        "charge": "4"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "57",
                        "monoisotopic_mass": "11147.5407",
                        "monoisotopic_mz": "929.9690",
                        "intensity": "1342.20",
                        "charge": "12"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "58",
                        "monoisotopic_mass": "859.9233",
                        "monoisotopic_mz": "860.9306",
                        "intensity": "2188.44",
                        "charge": "1"
                    },
                    {
                        "spec_id": "187",
                        "peak_id": "59",
                        "monoisotopic_mass": "1056.1170",
                        "monoisotopic_mz": "1057.1243",
                        "intensity": "851.42",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15922.2440",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "187",
                                "peak_id": "3",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "spec_id": "187",
                                "peak_id": "11",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "61",
                                "ion_display_position": "61",
                                "spec_id": "187",
                                "peak_id": "8",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "spec_id": "187",
                                "peak_id": "30",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "spec_id": "187",
                                "peak_id": "1",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "spec_id": "187",
                                "peak_id": "2",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "90",
                                "ion_display_position": "58",
                                "spec_id": "187",
                                "peak_id": "4",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "spec_id": "187",
                                    "peak_id": "46",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "spec_id": "187",
                                    "peak_id": "5",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "spec_id": "187",
                                "peak_id": "32",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
