prsm_data =
{
    "prsm": {
        "prsm_id": "130",
        "p_value": "1.11e-12",
        "e_value": "1.11e-12",
        "fdr": "0",
        "matched_fragment_number": "19",
        "matched_peak_number": "22",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "113",
                "ms1_scans": "291",
                "ids": "177",
                "scans": "292",
                "precursor_mono_mass": "8320.0767",
                "precursor_charge": "12",
                "precursor_mz": "694.3470",
                "feature_inte": "1.2232e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "177",
                        "peak_id": "0",
                        "monoisotopic_mass": "4741.3629",
                        "monoisotopic_mz": "791.2344",
                        "intensity": "51213.46",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4741.3637",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "31",
                                "mass_error": "-0.0009",
                                "ppm": "-0.19"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "1",
                        "monoisotopic_mass": "4628.2795",
                        "monoisotopic_mz": "772.3872",
                        "intensity": "20756.16",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4628.2797",
                                "ion_position": "32",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "32",
                                "mass_error": "-0.0002",
                                "ppm": "-0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "2",
                        "monoisotopic_mass": "4609.2661",
                        "monoisotopic_mz": "769.2183",
                        "intensity": "21806.58",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "3",
                        "monoisotopic_mass": "1338.6102",
                        "monoisotopic_mz": "670.3124",
                        "intensity": "22711.25",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1338.6106",
                                "ion_position": "60",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "60",
                                "mass_error": "-0.0004",
                                "ppm": "-0.28"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "4",
                        "monoisotopic_mass": "1453.6388",
                        "monoisotopic_mz": "727.8267",
                        "intensity": "13071.31",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1453.6375",
                                "ion_position": "59",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "59",
                                "mass_error": "0.0013",
                                "ppm": "0.87"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "5",
                        "monoisotopic_mass": "4499.2378",
                        "monoisotopic_mz": "750.8802",
                        "intensity": "24440.28",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4499.2371",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "33",
                                "mass_error": "0.0007",
                                "ppm": "0.15"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "6",
                        "monoisotopic_mass": "8188.0457",
                        "monoisotopic_mz": "745.3751",
                        "intensity": "17206.64",
                        "charge": "11",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8189.0519",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "1",
                                "mass_error": "-0.0038",
                                "ppm": "-0.47"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "7",
                        "monoisotopic_mass": "8302.0650",
                        "monoisotopic_mz": "692.8460",
                        "intensity": "15910.63",
                        "charge": "12"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "8",
                        "monoisotopic_mass": "4853.4485",
                        "monoisotopic_mz": "809.9154",
                        "intensity": "12889.85",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "9",
                        "monoisotopic_mass": "1023.4881",
                        "monoisotopic_mz": "512.7513",
                        "intensity": "10570.98",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1023.4887",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "62",
                                "mass_error": "-0.0005",
                                "ppm": "-0.52"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "10",
                        "monoisotopic_mass": "4954.4912",
                        "monoisotopic_mz": "826.7558",
                        "intensity": "11719.72",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "11",
                        "monoisotopic_mass": "4740.3615",
                        "monoisotopic_mz": "678.2018",
                        "intensity": "15748.03",
                        "charge": "7"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "12",
                        "monoisotopic_mass": "3234.5575",
                        "monoisotopic_mz": "647.9188",
                        "intensity": "7980.75",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "13",
                        "monoisotopic_mass": "2773.0282",
                        "monoisotopic_mz": "694.2643",
                        "intensity": "20555.08",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "14",
                        "monoisotopic_mass": "3448.6347",
                        "monoisotopic_mz": "863.1660",
                        "intensity": "7415.80",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "15",
                        "monoisotopic_mass": "7701.8387",
                        "monoisotopic_mz": "771.1911",
                        "intensity": "7850.75",
                        "charge": "10",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7702.8445",
                                "ion_position": "5",
                                "ion_display_position": "64",
                                "ion_sort_name": "Y00064",
                                "ion_left_position": "5",
                                "mass_error": "-0.0034",
                                "ppm": "-0.45"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "16",
                        "monoisotopic_mass": "4499.2359",
                        "monoisotopic_mz": "643.7553",
                        "intensity": "7957.83",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4499.2371",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "33",
                                "mass_error": "-0.0012",
                                "ppm": "-0.27"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "17",
                        "monoisotopic_mass": "1552.7065",
                        "monoisotopic_mz": "777.3605",
                        "intensity": "6596.00",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1552.7059",
                                "ion_position": "58",
                                "ion_display_position": "11",
                                "ion_sort_name": "Y00011",
                                "ion_left_position": "58",
                                "mass_error": "0.0006",
                                "ppm": "0.38"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "18",
                        "monoisotopic_mass": "6241.5690",
                        "monoisotopic_mz": "694.5149",
                        "intensity": "7510.91",
                        "charge": "9"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "19",
                        "monoisotopic_mass": "4499.2440",
                        "monoisotopic_mz": "900.8561",
                        "intensity": "8220.52",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4499.2371",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "33",
                                "mass_error": "0.0069",
                                "ppm": "1.54"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "20",
                        "monoisotopic_mass": "1780.8161",
                        "monoisotopic_mz": "891.4153",
                        "intensity": "4747.61",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1780.8169",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "ion_sort_name": "Y00013",
                                "ion_left_position": "56",
                                "mass_error": "-0.0009",
                                "ppm": "-0.48"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "21",
                        "monoisotopic_mass": "4628.2777",
                        "monoisotopic_mz": "926.6628",
                        "intensity": "8407.59",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4628.2797",
                                "ion_position": "32",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "32",
                                "mass_error": "-0.0020",
                                "ppm": "-0.44"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "22",
                        "monoisotopic_mass": "3233.5576",
                        "monoisotopic_mz": "809.3967",
                        "intensity": "7990.47",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3233.5564",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "0.0012",
                                "ppm": "0.37"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "23",
                        "monoisotopic_mass": "3702.7845",
                        "monoisotopic_mz": "926.7034",
                        "intensity": "7490.97",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3702.7816",
                                "ion_position": "40",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "40",
                                "mass_error": "0.0029",
                                "ppm": "0.78"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "24",
                        "monoisotopic_mass": "3446.6240",
                        "monoisotopic_mz": "690.3321",
                        "intensity": "5962.50",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "25",
                        "monoisotopic_mass": "3465.6436",
                        "monoisotopic_mz": "867.4182",
                        "intensity": "4695.15",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3465.6446",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "-0.0009",
                                "ppm": "-0.27"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "26",
                        "monoisotopic_mass": "2362.1727",
                        "monoisotopic_mz": "788.3982",
                        "intensity": "4155.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "27",
                        "monoisotopic_mass": "8273.0523",
                        "monoisotopic_mz": "690.4283",
                        "intensity": "6154.10",
                        "charge": "12"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "28",
                        "monoisotopic_mass": "523.2541",
                        "monoisotopic_mz": "524.2614",
                        "intensity": "3592.41",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "523.2544",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "ion_sort_name": "Y00003",
                                "ion_left_position": "66",
                                "mass_error": "-0.0002",
                                "ppm": "-0.41"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "29",
                        "monoisotopic_mass": "2079.7728",
                        "monoisotopic_mz": "694.2649",
                        "intensity": "5860.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "30",
                        "monoisotopic_mass": "3288.5884",
                        "monoisotopic_mz": "658.7250",
                        "intensity": "5228.19",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "31",
                        "monoisotopic_mass": "3364.5984",
                        "monoisotopic_mz": "842.1569",
                        "intensity": "2965.01",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3364.5969",
                                "ion_position": "29",
                                "ion_display_position": "29",
                                "ion_sort_name": "B00029",
                                "ion_left_position": "29",
                                "mass_error": "0.0015",
                                "ppm": "0.44"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "32",
                        "monoisotopic_mass": "2745.6814",
                        "monoisotopic_mz": "687.4276",
                        "intensity": "2751.57",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "33",
                        "monoisotopic_mass": "3816.4093",
                        "monoisotopic_mz": "764.2891",
                        "intensity": "8769.94",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "34",
                        "monoisotopic_mass": "1152.5313",
                        "monoisotopic_mz": "577.2730",
                        "intensity": "4486.77",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1152.5313",
                                "ion_position": "61",
                                "ion_display_position": "8",
                                "ion_sort_name": "Y00008",
                                "ion_left_position": "61",
                                "mass_error": "0.0001",
                                "ppm": "0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "35",
                        "monoisotopic_mass": "3101.5089",
                        "monoisotopic_mz": "621.3091",
                        "intensity": "3492.72",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "36",
                        "monoisotopic_mass": "3118.5302",
                        "monoisotopic_mz": "780.6398",
                        "intensity": "3689.46",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3118.5295",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "ion_sort_name": "B00027",
                                "ion_left_position": "27",
                                "mass_error": "0.0008",
                                "ppm": "0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "37",
                        "monoisotopic_mass": "690.9212",
                        "monoisotopic_mz": "691.9285",
                        "intensity": "1681.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "38",
                        "monoisotopic_mass": "3402.7495",
                        "monoisotopic_mz": "851.6947",
                        "intensity": "2876.17",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "39",
                        "monoisotopic_mass": "1481.9146",
                        "monoisotopic_mz": "741.9646",
                        "intensity": "2297.68",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "40",
                        "monoisotopic_mass": "1371.5090",
                        "monoisotopic_mz": "686.7618",
                        "intensity": "1711.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "41",
                        "monoisotopic_mass": "4937.4760",
                        "monoisotopic_mz": "823.9199",
                        "intensity": "1291.15",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "42",
                        "monoisotopic_mass": "3409.7124",
                        "monoisotopic_mz": "682.9498",
                        "intensity": "877.41",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "43",
                        "monoisotopic_mass": "4163.9620",
                        "monoisotopic_mz": "695.0009",
                        "intensity": "4146.33",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "44",
                        "monoisotopic_mass": "3974.9945",
                        "monoisotopic_mz": "796.0062",
                        "intensity": "1846.40",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "45",
                        "monoisotopic_mass": "6838.5282",
                        "monoisotopic_mz": "684.8601",
                        "intensity": "1444.24",
                        "charge": "10"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "46",
                        "monoisotopic_mass": "8237.0446",
                        "monoisotopic_mz": "687.4277",
                        "intensity": "1429.27",
                        "charge": "12"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "47",
                        "monoisotopic_mass": "4308.1762",
                        "monoisotopic_mz": "719.0366",
                        "intensity": "858.58",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "48",
                        "monoisotopic_mass": "784.0251",
                        "monoisotopic_mz": "785.0323",
                        "intensity": "1596.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "49",
                        "monoisotopic_mass": "3346.5792",
                        "monoisotopic_mz": "837.6521",
                        "intensity": "1092.13",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "50",
                        "monoisotopic_mass": "7503.7311",
                        "monoisotopic_mz": "751.3804",
                        "intensity": "2054.80",
                        "charge": "10"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "51",
                        "monoisotopic_mass": "7271.7552",
                        "monoisotopic_mz": "662.0759",
                        "intensity": "1283.59",
                        "charge": "11"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "52",
                        "monoisotopic_mass": "825.9131",
                        "monoisotopic_mz": "826.9203",
                        "intensity": "1127.59",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "53",
                        "monoisotopic_mass": "5519.0001",
                        "monoisotopic_mz": "690.8823",
                        "intensity": "677.37",
                        "charge": "8"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "54",
                        "monoisotopic_mass": "1388.8766",
                        "monoisotopic_mz": "695.4456",
                        "intensity": "2804.30",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "55",
                        "monoisotopic_mass": "7615.7822",
                        "monoisotopic_mz": "762.5855",
                        "intensity": "1208.70",
                        "charge": "10"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "56",
                        "monoisotopic_mass": "5188.1815",
                        "monoisotopic_mz": "742.1761",
                        "intensity": "1645.05",
                        "charge": "7"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "57",
                        "monoisotopic_mass": "4407.4224",
                        "monoisotopic_mz": "735.5777",
                        "intensity": "1248.03",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "58",
                        "monoisotopic_mass": "760.9708",
                        "monoisotopic_mz": "761.9781",
                        "intensity": "1071.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "59",
                        "monoisotopic_mass": "6771.3883",
                        "monoisotopic_mz": "753.3838",
                        "intensity": "1054.44",
                        "charge": "9"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "60",
                        "monoisotopic_mass": "6864.5186",
                        "monoisotopic_mz": "763.7316",
                        "intensity": "822.86",
                        "charge": "9"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "61",
                        "monoisotopic_mass": "5635.7217",
                        "monoisotopic_mz": "806.1104",
                        "intensity": "978.25",
                        "charge": "7"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "62",
                        "monoisotopic_mass": "737.8154",
                        "monoisotopic_mz": "738.8227",
                        "intensity": "1169.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "63",
                        "monoisotopic_mass": "6630.2563",
                        "monoisotopic_mz": "737.7024",
                        "intensity": "3269.56",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6629.3038",
                                "ion_position": "15",
                                "ion_display_position": "54",
                                "ion_sort_name": "Y00054",
                                "ion_left_position": "15",
                                "mass_error": "-0.0499",
                                "ppm": "-7.52"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "64",
                        "monoisotopic_mass": "2728.0023",
                        "monoisotopic_mz": "683.0078",
                        "intensity": "988.81",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "65",
                        "monoisotopic_mass": "2220.0316",
                        "monoisotopic_mz": "741.0178",
                        "intensity": "2401.50",
                        "charge": "3"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "66",
                        "monoisotopic_mass": "3334.5954",
                        "monoisotopic_mz": "834.6561",
                        "intensity": "1090.44",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "67",
                        "monoisotopic_mass": "3716.8641",
                        "monoisotopic_mz": "930.2233",
                        "intensity": "1512.43",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "68",
                        "monoisotopic_mass": "708.6443",
                        "monoisotopic_mz": "709.6515",
                        "intensity": "1141.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "69",
                        "monoisotopic_mass": "4435.7397",
                        "monoisotopic_mz": "740.2972",
                        "intensity": "1240.25",
                        "charge": "6"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "70",
                        "monoisotopic_mass": "7465.3085",
                        "monoisotopic_mz": "830.4860",
                        "intensity": "827.42",
                        "charge": "9"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "71",
                        "monoisotopic_mass": "2505.3198",
                        "monoisotopic_mz": "836.1139",
                        "intensity": "1634.62",
                        "charge": "3"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "72",
                        "monoisotopic_mass": "5508.8010",
                        "monoisotopic_mz": "787.9788",
                        "intensity": "1008.60",
                        "charge": "7"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "73",
                        "monoisotopic_mass": "3216.5378",
                        "monoisotopic_mz": "805.1417",
                        "intensity": "2915.23",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "74",
                        "monoisotopic_mass": "3365.5941",
                        "monoisotopic_mz": "674.1261",
                        "intensity": "1808.75",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "75",
                        "monoisotopic_mass": "2924.7738",
                        "monoisotopic_mz": "732.2007",
                        "intensity": "1809.71",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "76",
                        "monoisotopic_mass": "5809.0396",
                        "monoisotopic_mz": "830.8701",
                        "intensity": "741.21",
                        "charge": "7"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "77",
                        "monoisotopic_mass": "2960.0263",
                        "monoisotopic_mz": "741.0138",
                        "intensity": "1053.16",
                        "charge": "4"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "78",
                        "monoisotopic_mass": "5568.8727",
                        "monoisotopic_mz": "697.1164",
                        "intensity": "889.27",
                        "charge": "8"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "79",
                        "monoisotopic_mass": "1650.7901",
                        "monoisotopic_mz": "826.4023",
                        "intensity": "3147.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "80",
                        "monoisotopic_mass": "8294.9459",
                        "monoisotopic_mz": "830.5019",
                        "intensity": "665.41",
                        "charge": "10"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "81",
                        "monoisotopic_mass": "6872.3703",
                        "monoisotopic_mz": "688.2443",
                        "intensity": "881.45",
                        "charge": "10"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "82",
                        "monoisotopic_mass": "862.2331",
                        "monoisotopic_mz": "863.2404",
                        "intensity": "1333.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "83",
                        "monoisotopic_mass": "1436.0484",
                        "monoisotopic_mz": "719.0315",
                        "intensity": "1189.34",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "84",
                        "monoisotopic_mass": "3501.1121",
                        "monoisotopic_mz": "701.2297",
                        "intensity": "2314.55",
                        "charge": "5"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "85",
                        "monoisotopic_mass": "1468.3044",
                        "monoisotopic_mz": "735.1595",
                        "intensity": "641.68",
                        "charge": "2"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "86",
                        "monoisotopic_mass": "6170.9770",
                        "monoisotopic_mz": "772.3794",
                        "intensity": "2221.40",
                        "charge": "8"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "87",
                        "monoisotopic_mass": "5966.1357",
                        "monoisotopic_mz": "746.7742",
                        "intensity": "3068.43",
                        "charge": "8"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "88",
                        "monoisotopic_mass": "7297.6634",
                        "monoisotopic_mz": "730.7736",
                        "intensity": "2271.68",
                        "charge": "10",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7296.6037",
                                "ion_position": "62",
                                "ion_display_position": "62",
                                "ion_sort_name": "B00062",
                                "ion_left_position": "62",
                                "mass_error": "0.0573",
                                "ppm": "7.85"
                            }
                        }
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "89",
                        "monoisotopic_mass": "8076.5364",
                        "monoisotopic_mz": "735.2379",
                        "intensity": "1145.66",
                        "charge": "11"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "90",
                        "monoisotopic_mass": "2271.1325",
                        "monoisotopic_mz": "758.0514",
                        "intensity": "1688.25",
                        "charge": "3"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "91",
                        "monoisotopic_mass": "805.8903",
                        "monoisotopic_mz": "806.8976",
                        "intensity": "820.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "177",
                        "peak_id": "92",
                        "monoisotopic_mass": "6004.8407",
                        "monoisotopic_mz": "668.2118",
                        "intensity": "2524.00",
                        "charge": "9"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P68206|YJBJ_ECOLI",
            "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
            "proteoform_mass": "8320.0923",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "69",
                "first_residue_position": "0",
                "last_residue_position": "68",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "D"
                    },
                    {
                        "position": "4",
                        "acid": "E"
                    },
                    {
                        "position": "5",
                        "acid": "A"
                    },
                    {
                        "position": "6",
                        "acid": "G"
                    },
                    {
                        "position": "7",
                        "acid": "G"
                    },
                    {
                        "position": "8",
                        "acid": "N"
                    },
                    {
                        "position": "9",
                        "acid": "W"
                    },
                    {
                        "position": "10",
                        "acid": "K"
                    },
                    {
                        "position": "11",
                        "acid": "Q"
                    },
                    {
                        "position": "12",
                        "acid": "F"
                    },
                    {
                        "position": "13",
                        "acid": "K"
                    },
                    {
                        "position": "14",
                        "acid": "G"
                    },
                    {
                        "position": "15",
                        "acid": "K"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "E"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "W"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "K"
                    },
                    {
                        "position": "23",
                        "acid": "L"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "D"
                    },
                    {
                        "position": "27",
                        "acid": "D"
                    },
                    {
                        "position": "28",
                        "acid": "M"
                    },
                    {
                        "position": "29",
                        "acid": "T"
                    },
                    {
                        "position": "30",
                        "acid": "I"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "G"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "R"
                    },
                    {
                        "position": "36",
                        "acid": "D"
                    },
                    {
                        "position": "37",
                        "acid": "Q"
                    },
                    {
                        "position": "38",
                        "acid": "L"
                    },
                    {
                        "position": "39",
                        "acid": "V"
                    },
                    {
                        "position": "40",
                        "acid": "G"
                    },
                    {
                        "position": "41",
                        "acid": "K"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "Q"
                    },
                    {
                        "position": "44",
                        "acid": "E"
                    },
                    {
                        "position": "45",
                        "acid": "R"
                    },
                    {
                        "position": "46",
                        "acid": "Y"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "Y"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "Q"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "E"
                    },
                    {
                        "position": "55",
                        "acid": "K"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "V"
                    },
                    {
                        "position": "58",
                        "acid": "V"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "W"
                    },
                    {
                        "position": "61",
                        "acid": "E"
                    },
                    {
                        "position": "62",
                        "acid": "T"
                    },
                    {
                        "position": "63",
                        "acid": "R"
                    },
                    {
                        "position": "64",
                        "acid": "N"
                    },
                    {
                        "position": "65",
                        "acid": "E"
                    },
                    {
                        "position": "66",
                        "acid": "Y"
                    },
                    {
                        "position": "67",
                        "acid": "R"
                    },
                    {
                        "position": "68",
                        "acid": "W"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "spec_id": "177",
                                "peak_id": "6",
                                "peak_charge": "11"
                            }
                        }
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "5",
                                "ion_display_position": "64",
                                "spec_id": "177",
                                "peak_id": "15",
                                "peak_charge": "10"
                            }
                        }
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "15",
                                "ion_display_position": "54",
                                "spec_id": "177",
                                "peak_id": "63",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "spec_id": "177",
                                "peak_id": "36",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "spec_id": "177",
                                "peak_id": "22",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "29",
                                "ion_display_position": "29",
                                "spec_id": "177",
                                "peak_id": "31",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "spec_id": "177",
                                "peak_id": "25",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "spec_id": "177",
                                "peak_id": "0",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "32",
                                    "ion_display_position": "37",
                                    "spec_id": "177",
                                    "peak_id": "21",
                                    "peak_charge": "5"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "32",
                                    "ion_display_position": "37",
                                    "spec_id": "177",
                                    "peak_id": "1",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "33",
                                    "ion_display_position": "36",
                                    "spec_id": "177",
                                    "peak_id": "16",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "33",
                                    "ion_display_position": "36",
                                    "spec_id": "177",
                                    "peak_id": "5",
                                    "peak_charge": "6"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "33",
                                    "ion_display_position": "36",
                                    "spec_id": "177",
                                    "peak_id": "19",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "40",
                                "ion_display_position": "29",
                                "spec_id": "177",
                                "peak_id": "23",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "spec_id": "177",
                                "peak_id": "20",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "58",
                                "ion_display_position": "11",
                                "spec_id": "177",
                                "peak_id": "17",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "59",
                                "ion_display_position": "10",
                                "spec_id": "177",
                                "peak_id": "4",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "60",
                                "ion_display_position": "9",
                                "spec_id": "177",
                                "peak_id": "3",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "61",
                                "ion_display_position": "8",
                                "spec_id": "177",
                                "peak_id": "34",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "62",
                                    "ion_display_position": "7",
                                    "spec_id": "177",
                                    "peak_id": "9",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "62",
                                    "ion_display_position": "62",
                                    "spec_id": "177",
                                    "peak_id": "88",
                                    "peak_charge": "10"
                                }
                            ]
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "spec_id": "177",
                                "peak_id": "28",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
