prsm_data =
{
    "prsm": {
        "prsm_id": "121",
        "p_value": "9.44e-07",
        "e_value": "9.44e-07",
        "fdr": "0",
        "matched_fragment_number": "15",
        "matched_peak_number": "15",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "109",
                "ms1_scans": "274",
                "ids": "166",
                "scans": "277",
                "precursor_mono_mass": "8320.0825",
                "precursor_charge": "10",
                "precursor_mz": "833.0155",
                "feature_inte": "1.2232e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "166",
                        "peak_id": "0",
                        "monoisotopic_mass": "4160.5442",
                        "monoisotopic_mz": "833.1161",
                        "intensity": "81392.86",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "1",
                        "monoisotopic_mass": "4741.3618",
                        "monoisotopic_mz": "949.2796",
                        "intensity": "34906.85",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4741.3637",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "31",
                                "mass_error": "-0.0020",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "2",
                        "monoisotopic_mass": "5941.0329",
                        "monoisotopic_mz": "991.1794",
                        "intensity": "22765.41",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "3",
                        "monoisotopic_mass": "8301.0479",
                        "monoisotopic_mz": "831.1121",
                        "intensity": "35960.97",
                        "charge": "10"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "4",
                        "monoisotopic_mass": "4627.2756",
                        "monoisotopic_mz": "926.4624",
                        "intensity": "30261.08",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "5",
                        "monoisotopic_mass": "7476.8745",
                        "monoisotopic_mz": "831.7711",
                        "intensity": "20175.42",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "6",
                        "monoisotopic_mass": "4498.2333",
                        "monoisotopic_mz": "900.6539",
                        "intensity": "19922.30",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "7",
                        "monoisotopic_mass": "8074.0157",
                        "monoisotopic_mz": "898.1201",
                        "intensity": "18697.55",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8075.0090",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "ion_sort_name": "Y00067",
                                "ion_left_position": "2",
                                "mass_error": "0.0090",
                                "ppm": "1.12"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "8",
                        "monoisotopic_mass": "8188.0570",
                        "monoisotopic_mz": "910.7914",
                        "intensity": "18233.66",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8189.0519",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "1",
                                "mass_error": "0.0075",
                                "ppm": "0.91"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "9",
                        "monoisotopic_mass": "6980.4745",
                        "monoisotopic_mz": "873.5666",
                        "intensity": "12981.04",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6981.4818",
                                "ion_position": "60",
                                "ion_display_position": "60",
                                "ion_sort_name": "B00060",
                                "ion_left_position": "60",
                                "mass_error": "-0.0050",
                                "ppm": "-0.72"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "10",
                        "monoisotopic_mass": "8284.0524",
                        "monoisotopic_mz": "829.4125",
                        "intensity": "17791.49",
                        "charge": "10"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "11",
                        "monoisotopic_mass": "4853.4460",
                        "monoisotopic_mz": "971.6965",
                        "intensity": "13330.81",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "12",
                        "monoisotopic_mass": "3447.6304",
                        "monoisotopic_mz": "862.9149",
                        "intensity": "14199.45",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "13",
                        "monoisotopic_mass": "6082.0340",
                        "monoisotopic_mz": "869.8693",
                        "intensity": "6986.94",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6083.0422",
                                "ion_position": "52",
                                "ion_display_position": "52",
                                "ion_sort_name": "B00052",
                                "ion_left_position": "52",
                                "mass_error": "-0.0059",
                                "ppm": "-0.97"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "14",
                        "monoisotopic_mass": "4955.4947",
                        "monoisotopic_mz": "992.1062",
                        "intensity": "11044.33",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4955.4955",
                                "ion_position": "29",
                                "ion_display_position": "40",
                                "ion_sort_name": "Y00040",
                                "ion_left_position": "29",
                                "mass_error": "-0.0008",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "15",
                        "monoisotopic_mass": "1338.6098",
                        "monoisotopic_mz": "670.3122",
                        "intensity": "14620.78",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1338.6106",
                                "ion_position": "60",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "60",
                                "mass_error": "-0.0007",
                                "ppm": "-0.54"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "16",
                        "monoisotopic_mass": "6041.1012",
                        "monoisotopic_mz": "1007.8575",
                        "intensity": "6928.34",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "17",
                        "monoisotopic_mass": "832.9100",
                        "monoisotopic_mz": "833.9172",
                        "intensity": "6045.52",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "18",
                        "monoisotopic_mass": "2237.0493",
                        "monoisotopic_mz": "746.6904",
                        "intensity": "4455.67",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2237.0502",
                                "ion_position": "52",
                                "ion_display_position": "17",
                                "ion_sort_name": "Y00017",
                                "ion_left_position": "52",
                                "mass_error": "-0.0009",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "19",
                        "monoisotopic_mass": "3465.6465",
                        "monoisotopic_mz": "867.4189",
                        "intensity": "6804.19",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3465.6446",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "0.0020",
                                "ppm": "0.57"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "20",
                        "monoisotopic_mass": "5229.7309",
                        "monoisotopic_mz": "1046.9535",
                        "intensity": "3636.12",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "21",
                        "monoisotopic_mass": "4740.3616",
                        "monoisotopic_mz": "791.0675",
                        "intensity": "9462.91",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "22",
                        "monoisotopic_mass": "2477.7472",
                        "monoisotopic_mz": "826.9230",
                        "intensity": "3764.79",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "23",
                        "monoisotopic_mass": "883.4367",
                        "monoisotopic_mz": "884.4440",
                        "intensity": "3871.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "24",
                        "monoisotopic_mass": "3329.0352",
                        "monoisotopic_mz": "833.2661",
                        "intensity": "38860.27",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "25",
                        "monoisotopic_mass": "2794.9337",
                        "monoisotopic_mz": "932.6518",
                        "intensity": "5046.54",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "26",
                        "monoisotopic_mass": "1023.4874",
                        "monoisotopic_mz": "512.7510",
                        "intensity": "3461.42",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1023.4887",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "62",
                                "mass_error": "-0.0013",
                                "ppm": "-1.23"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "27",
                        "monoisotopic_mass": "4856.4460",
                        "monoisotopic_mz": "810.4149",
                        "intensity": "4615.36",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "28",
                        "monoisotopic_mass": "4095.0335",
                        "monoisotopic_mz": "820.0140",
                        "intensity": "5099.26",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "29",
                        "monoisotopic_mass": "3578.7253",
                        "monoisotopic_mz": "895.6886",
                        "intensity": "2985.81",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3578.7286",
                                "ion_position": "31",
                                "ion_display_position": "31",
                                "ion_sort_name": "B00031",
                                "ion_left_position": "31",
                                "mass_error": "-0.0033",
                                "ppm": "-0.93"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "30",
                        "monoisotopic_mass": "970.8887",
                        "monoisotopic_mz": "971.8960",
                        "intensity": "1956.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "31",
                        "monoisotopic_mass": "1780.8170",
                        "monoisotopic_mz": "891.4158",
                        "intensity": "2651.63",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1780.8169",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "ion_sort_name": "Y00013",
                                "ion_left_position": "56",
                                "mass_error": "0.0001",
                                "ppm": "0.06"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "32",
                        "monoisotopic_mass": "2649.9743",
                        "monoisotopic_mz": "884.3320",
                        "intensity": "2470.71",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "33",
                        "monoisotopic_mass": "8263.0502",
                        "monoisotopic_mz": "827.3123",
                        "intensity": "1400.44",
                        "charge": "10"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "34",
                        "monoisotopic_mass": "909.2023",
                        "monoisotopic_mz": "910.2095",
                        "intensity": "1386.68",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "35",
                        "monoisotopic_mass": "5267.2983",
                        "monoisotopic_mz": "878.8903",
                        "intensity": "1162.86",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "36",
                        "monoisotopic_mass": "4627.2724",
                        "monoisotopic_mz": "772.2193",
                        "intensity": "2962.32",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "37",
                        "monoisotopic_mass": "4547.0077",
                        "monoisotopic_mz": "910.4088",
                        "intensity": "1146.90",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "38",
                        "monoisotopic_mass": "750.0398",
                        "monoisotopic_mz": "751.0471",
                        "intensity": "1307.86",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "39",
                        "monoisotopic_mass": "2730.4800",
                        "monoisotopic_mz": "911.1673",
                        "intensity": "3455.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "40",
                        "monoisotopic_mass": "2979.8294",
                        "monoisotopic_mz": "994.2838",
                        "intensity": "2292.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "41",
                        "monoisotopic_mass": "613.3143",
                        "monoisotopic_mz": "614.3216",
                        "intensity": "2072.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "42",
                        "monoisotopic_mass": "2426.7196",
                        "monoisotopic_mz": "809.9138",
                        "intensity": "932.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "43",
                        "monoisotopic_mass": "5981.4043",
                        "monoisotopic_mz": "855.4936",
                        "intensity": "1310.88",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "44",
                        "monoisotopic_mass": "848.1709",
                        "monoisotopic_mz": "849.1782",
                        "intensity": "1652.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "45",
                        "monoisotopic_mass": "5001.0418",
                        "monoisotopic_mz": "834.5142",
                        "intensity": "14148.69",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "46",
                        "monoisotopic_mass": "4939.4863",
                        "monoisotopic_mz": "988.9045",
                        "intensity": "1335.65",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "47",
                        "monoisotopic_mass": "988.0057",
                        "monoisotopic_mz": "989.0129",
                        "intensity": "1450.52",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "48",
                        "monoisotopic_mass": "523.2537",
                        "monoisotopic_mz": "524.2610",
                        "intensity": "2729.79",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "523.2544",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "ion_sort_name": "Y00003",
                                "ion_left_position": "66",
                                "mass_error": "-0.0006",
                                "ppm": "-1.23"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "49",
                        "monoisotopic_mass": "8104.1385",
                        "monoisotopic_mz": "1014.0246",
                        "intensity": "1443.28",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "50",
                        "monoisotopic_mass": "8057.9859",
                        "monoisotopic_mz": "896.3390",
                        "intensity": "6444.17",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "51",
                        "monoisotopic_mass": "4973.6474",
                        "monoisotopic_mz": "829.9485",
                        "intensity": "3928.57",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "52",
                        "monoisotopic_mass": "7070.5287",
                        "monoisotopic_mz": "884.8234",
                        "intensity": "1868.46",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "53",
                        "monoisotopic_mass": "8088.0713",
                        "monoisotopic_mz": "809.8144",
                        "intensity": "833.16",
                        "charge": "10"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "54",
                        "monoisotopic_mass": "5656.4636",
                        "monoisotopic_mz": "809.0735",
                        "intensity": "1405.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "55",
                        "monoisotopic_mass": "3464.6389",
                        "monoisotopic_mz": "693.9351",
                        "intensity": "3060.79",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "56",
                        "monoisotopic_mass": "3729.5927",
                        "monoisotopic_mz": "933.4055",
                        "intensity": "2766.88",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "57",
                        "monoisotopic_mass": "7369.8538",
                        "monoisotopic_mz": "819.8799",
                        "intensity": "1362.07",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "58",
                        "monoisotopic_mass": "1755.5327",
                        "monoisotopic_mz": "878.7736",
                        "intensity": "2841.52",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "59",
                        "monoisotopic_mass": "4985.2460",
                        "monoisotopic_mz": "831.8816",
                        "intensity": "5334.19",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "60",
                        "monoisotopic_mass": "2919.1578",
                        "monoisotopic_mz": "974.0599",
                        "intensity": "2875.36",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "61",
                        "monoisotopic_mass": "7736.9805",
                        "monoisotopic_mz": "968.1298",
                        "intensity": "1459.39",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "62",
                        "monoisotopic_mass": "944.4736",
                        "monoisotopic_mz": "945.4808",
                        "intensity": "1971.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "63",
                        "monoisotopic_mass": "1903.9833",
                        "monoisotopic_mz": "952.9989",
                        "intensity": "1795.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "64",
                        "monoisotopic_mass": "1000.7511",
                        "monoisotopic_mz": "1001.7584",
                        "intensity": "1196.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "65",
                        "monoisotopic_mass": "3805.8571",
                        "monoisotopic_mz": "952.4716",
                        "intensity": "809.78",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "66",
                        "monoisotopic_mass": "5924.0023",
                        "monoisotopic_mz": "988.3410",
                        "intensity": "2549.97",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "67",
                        "monoisotopic_mass": "5138.5971",
                        "monoisotopic_mz": "857.4401",
                        "intensity": "1045.49",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "68",
                        "monoisotopic_mass": "6995.4388",
                        "monoisotopic_mz": "875.4371",
                        "intensity": "1174.83",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "69",
                        "monoisotopic_mass": "7828.7436",
                        "monoisotopic_mz": "870.8677",
                        "intensity": "1307.74",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "70",
                        "monoisotopic_mass": "2766.3326",
                        "monoisotopic_mz": "923.1182",
                        "intensity": "3165.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "71",
                        "monoisotopic_mass": "7522.1432",
                        "monoisotopic_mz": "941.2752",
                        "intensity": "1416.78",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "72",
                        "monoisotopic_mass": "7572.7823",
                        "monoisotopic_mz": "947.6051",
                        "intensity": "1029.01",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "73",
                        "monoisotopic_mass": "6491.2749",
                        "monoisotopic_mz": "928.3323",
                        "intensity": "999.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "74",
                        "monoisotopic_mass": "4610.2700",
                        "monoisotopic_mz": "923.0613",
                        "intensity": "2976.31",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "75",
                        "monoisotopic_mass": "5050.5958",
                        "monoisotopic_mz": "1011.1264",
                        "intensity": "997.51",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "76",
                        "monoisotopic_mass": "4275.2522",
                        "monoisotopic_mz": "856.0577",
                        "intensity": "2670.17",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "77",
                        "monoisotopic_mass": "5814.4873",
                        "monoisotopic_mz": "970.0885",
                        "intensity": "1378.85",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "78",
                        "monoisotopic_mass": "6655.2886",
                        "monoisotopic_mz": "951.7628",
                        "intensity": "902.41",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "79",
                        "monoisotopic_mass": "1933.9940",
                        "monoisotopic_mz": "968.0043",
                        "intensity": "3133.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "80",
                        "monoisotopic_mass": "4643.4245",
                        "monoisotopic_mz": "929.6922",
                        "intensity": "2374.55",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "81",
                        "monoisotopic_mass": "1019.4791",
                        "monoisotopic_mz": "1020.4864",
                        "intensity": "1134.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "82",
                        "monoisotopic_mass": "4825.3966",
                        "monoisotopic_mz": "966.0866",
                        "intensity": "1378.16",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "83",
                        "monoisotopic_mass": "5788.5254",
                        "monoisotopic_mz": "827.9395",
                        "intensity": "877.61",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "84",
                        "monoisotopic_mass": "2617.6411",
                        "monoisotopic_mz": "873.5543",
                        "intensity": "3375.54",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "85",
                        "monoisotopic_mass": "8031.0220",
                        "monoisotopic_mz": "893.3431",
                        "intensity": "1350.61",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "86",
                        "monoisotopic_mass": "6521.5953",
                        "monoisotopic_mz": "932.6637",
                        "intensity": "1832.04",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "87",
                        "monoisotopic_mass": "1042.3760",
                        "monoisotopic_mz": "1043.3833",
                        "intensity": "1354.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "88",
                        "monoisotopic_mass": "1740.5851",
                        "monoisotopic_mz": "871.2998",
                        "intensity": "1483.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "89",
                        "monoisotopic_mass": "6624.3770",
                        "monoisotopic_mz": "947.3468",
                        "intensity": "1343.45",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "90",
                        "monoisotopic_mass": "4518.8735",
                        "monoisotopic_mz": "904.7820",
                        "intensity": "3075.03",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "91",
                        "monoisotopic_mass": "6009.2401",
                        "monoisotopic_mz": "1002.5473",
                        "intensity": "2017.41",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "92",
                        "monoisotopic_mass": "4352.3085",
                        "monoisotopic_mz": "871.4690",
                        "intensity": "2105.74",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "93",
                        "monoisotopic_mass": "1453.6364",
                        "monoisotopic_mz": "727.8255",
                        "intensity": "775.89",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1453.6375",
                                "ion_position": "59",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "59",
                                "mass_error": "-0.0011",
                                "ppm": "-0.73"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "94",
                        "monoisotopic_mass": "6767.2500",
                        "monoisotopic_mz": "846.9135",
                        "intensity": "1044.10",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "95",
                        "monoisotopic_mass": "3288.5909",
                        "monoisotopic_mz": "823.1550",
                        "intensity": "1792.47",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "96",
                        "monoisotopic_mass": "6614.5687",
                        "monoisotopic_mz": "827.8284",
                        "intensity": "1488.66",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "97",
                        "monoisotopic_mass": "6635.0770",
                        "monoisotopic_mz": "830.3919",
                        "intensity": "3808.77",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "98",
                        "monoisotopic_mass": "6180.2450",
                        "monoisotopic_mz": "883.8994",
                        "intensity": "2404.57",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "99",
                        "monoisotopic_mass": "6930.1751",
                        "monoisotopic_mz": "867.2792",
                        "intensity": "3085.89",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "100",
                        "monoisotopic_mass": "5279.7209",
                        "monoisotopic_mz": "880.9608",
                        "intensity": "2596.82",
                        "charge": "6"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "101",
                        "monoisotopic_mass": "6457.5181",
                        "monoisotopic_mz": "923.5099",
                        "intensity": "2835.97",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "102",
                        "monoisotopic_mass": "5831.7805",
                        "monoisotopic_mz": "972.9707",
                        "intensity": "1769.89",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5830.8650",
                                "ion_position": "21",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "21",
                                "mass_error": "-0.0869",
                                "ppm": "-14.90"
                            }
                        }
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "103",
                        "monoisotopic_mass": "3391.3555",
                        "monoisotopic_mz": "848.8461",
                        "intensity": "1650.98",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "104",
                        "monoisotopic_mass": "7780.4390",
                        "monoisotopic_mz": "973.5622",
                        "intensity": "1330.36",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "105",
                        "monoisotopic_mass": "6434.3659",
                        "monoisotopic_mz": "920.2024",
                        "intensity": "2088.48",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "106",
                        "monoisotopic_mass": "6388.0990",
                        "monoisotopic_mz": "799.5197",
                        "intensity": "2068.30",
                        "charge": "8"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "107",
                        "monoisotopic_mass": "1412.5440",
                        "monoisotopic_mz": "707.2793",
                        "intensity": "716.15",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "108",
                        "monoisotopic_mass": "4477.0043",
                        "monoisotopic_mz": "896.4081",
                        "intensity": "1119.06",
                        "charge": "5"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "109",
                        "monoisotopic_mass": "1133.8987",
                        "monoisotopic_mz": "1134.9060",
                        "intensity": "769.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "110",
                        "monoisotopic_mass": "7636.3632",
                        "monoisotopic_mz": "849.4921",
                        "intensity": "2620.68",
                        "charge": "9"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "111",
                        "monoisotopic_mass": "2095.2931",
                        "monoisotopic_mz": "1048.6538",
                        "intensity": "1299.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "112",
                        "monoisotopic_mass": "1119.2518",
                        "monoisotopic_mz": "1120.2590",
                        "intensity": "897.36",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "113",
                        "monoisotopic_mass": "3052.9980",
                        "monoisotopic_mz": "1018.6733",
                        "intensity": "2078.82",
                        "charge": "3"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "114",
                        "monoisotopic_mass": "5948.1761",
                        "monoisotopic_mz": "850.7467",
                        "intensity": "1087.51",
                        "charge": "7"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "115",
                        "monoisotopic_mass": "1071.5185",
                        "monoisotopic_mz": "1072.5258",
                        "intensity": "913.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "116",
                        "monoisotopic_mass": "3629.2187",
                        "monoisotopic_mz": "908.3120",
                        "intensity": "2043.69",
                        "charge": "4"
                    },
                    {
                        "spec_id": "166",
                        "peak_id": "117",
                        "monoisotopic_mass": "4096.7499",
                        "monoisotopic_mz": "1025.1947",
                        "intensity": "2614.43",
                        "charge": "4"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P68206|YJBJ_ECOLI",
            "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
            "proteoform_mass": "8320.0923",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "69",
                "first_residue_position": "0",
                "last_residue_position": "68",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "D"
                    },
                    {
                        "position": "4",
                        "acid": "E"
                    },
                    {
                        "position": "5",
                        "acid": "A"
                    },
                    {
                        "position": "6",
                        "acid": "G"
                    },
                    {
                        "position": "7",
                        "acid": "G"
                    },
                    {
                        "position": "8",
                        "acid": "N"
                    },
                    {
                        "position": "9",
                        "acid": "W"
                    },
                    {
                        "position": "10",
                        "acid": "K"
                    },
                    {
                        "position": "11",
                        "acid": "Q"
                    },
                    {
                        "position": "12",
                        "acid": "F"
                    },
                    {
                        "position": "13",
                        "acid": "K"
                    },
                    {
                        "position": "14",
                        "acid": "G"
                    },
                    {
                        "position": "15",
                        "acid": "K"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "E"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "W"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "K"
                    },
                    {
                        "position": "23",
                        "acid": "L"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "D"
                    },
                    {
                        "position": "27",
                        "acid": "D"
                    },
                    {
                        "position": "28",
                        "acid": "M"
                    },
                    {
                        "position": "29",
                        "acid": "T"
                    },
                    {
                        "position": "30",
                        "acid": "I"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "G"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "R"
                    },
                    {
                        "position": "36",
                        "acid": "D"
                    },
                    {
                        "position": "37",
                        "acid": "Q"
                    },
                    {
                        "position": "38",
                        "acid": "L"
                    },
                    {
                        "position": "39",
                        "acid": "V"
                    },
                    {
                        "position": "40",
                        "acid": "G"
                    },
                    {
                        "position": "41",
                        "acid": "K"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "Q"
                    },
                    {
                        "position": "44",
                        "acid": "E"
                    },
                    {
                        "position": "45",
                        "acid": "R"
                    },
                    {
                        "position": "46",
                        "acid": "Y"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "Y"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "Q"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "E"
                    },
                    {
                        "position": "55",
                        "acid": "K"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "V"
                    },
                    {
                        "position": "58",
                        "acid": "V"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "W"
                    },
                    {
                        "position": "61",
                        "acid": "E"
                    },
                    {
                        "position": "62",
                        "acid": "T"
                    },
                    {
                        "position": "63",
                        "acid": "R"
                    },
                    {
                        "position": "64",
                        "acid": "N"
                    },
                    {
                        "position": "65",
                        "acid": "E"
                    },
                    {
                        "position": "66",
                        "acid": "Y"
                    },
                    {
                        "position": "67",
                        "acid": "R"
                    },
                    {
                        "position": "68",
                        "acid": "W"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "spec_id": "166",
                                "peak_id": "8",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "spec_id": "166",
                                "peak_id": "7",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "21",
                                "ion_display_position": "48",
                                "spec_id": "166",
                                "peak_id": "102",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "29",
                                "ion_display_position": "40",
                                "spec_id": "166",
                                "peak_id": "14",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "spec_id": "166",
                                "peak_id": "19",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "31",
                                    "ion_display_position": "31",
                                    "spec_id": "166",
                                    "peak_id": "29",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "31",
                                    "ion_display_position": "38",
                                    "spec_id": "166",
                                    "peak_id": "1",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "52",
                                    "ion_display_position": "17",
                                    "spec_id": "166",
                                    "peak_id": "18",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "52",
                                    "ion_display_position": "52",
                                    "spec_id": "166",
                                    "peak_id": "13",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "spec_id": "166",
                                "peak_id": "31",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "59",
                                "ion_display_position": "10",
                                "spec_id": "166",
                                "peak_id": "93",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "60",
                                    "ion_display_position": "9",
                                    "spec_id": "166",
                                    "peak_id": "15",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "spec_id": "166",
                                    "peak_id": "9",
                                    "peak_charge": "8"
                                }
                            ]
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "spec_id": "166",
                                "peak_id": "26",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "spec_id": "166",
                                "peak_id": "48",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
