prsm_data =
{
    "prsm": {
        "prsm_id": "119",
        "p_value": "0.70",
        "e_value": "1.07",
        "fdr": "8.51e-03",
        "matched_fragment_number": "7",
        "matched_peak_number": "9",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "109",
                "ms1_scans": "274",
                "ids": "164",
                "scans": "275",
                "precursor_mono_mass": "9173.4093",
                "precursor_charge": "10",
                "precursor_mz": "918.3482",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "164",
                        "peak_id": "0",
                        "monoisotopic_mass": "4777.1920",
                        "monoisotopic_mz": "1195.3053",
                        "intensity": "7614.27",
                        "charge": "4"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "1",
                        "monoisotopic_mass": "6913.4772",
                        "monoisotopic_mz": "988.6469",
                        "intensity": "10076.69",
                        "charge": "7"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "2",
                        "monoisotopic_mass": "5831.9299",
                        "monoisotopic_mz": "1167.3932",
                        "intensity": "5515.73",
                        "charge": "5"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "3",
                        "monoisotopic_mass": "3463.7857",
                        "monoisotopic_mz": "1155.6025",
                        "intensity": "6740.34",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "3463.7932",
                                "ion_position": "51",
                                "ion_display_position": "32",
                                "ion_sort_name": "Y00032",
                                "ion_left_position": "51",
                                "mass_error": "-0.0075",
                                "ppm": "-2.17"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "4",
                        "monoisotopic_mass": "4036.0363",
                        "monoisotopic_mz": "1346.3527",
                        "intensity": "6218.50",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "4036.0374",
                                "ion_position": "46",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "46",
                                "mass_error": "-0.0011",
                                "ppm": "-0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "5",
                        "monoisotopic_mass": "7330.7810",
                        "monoisotopic_mz": "917.3549",
                        "intensity": "9006.33",
                        "charge": "8"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "6",
                        "monoisotopic_mass": "720.3433",
                        "monoisotopic_mz": "721.3505",
                        "intensity": "5199.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "7",
                        "monoisotopic_mass": "3008.5165",
                        "monoisotopic_mz": "1505.2655",
                        "intensity": "4629.86",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "3008.5188",
                                "ion_position": "55",
                                "ion_display_position": "28",
                                "ion_sort_name": "Y00028",
                                "ion_left_position": "55",
                                "mass_error": "-0.0023",
                                "ppm": "-0.77"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "8",
                        "monoisotopic_mass": "7320.6393",
                        "monoisotopic_mz": "1221.1138",
                        "intensity": "6112.27",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "7319.6420",
                                "ion_position": "17",
                                "ion_display_position": "66",
                                "ion_sort_name": "Y00066",
                                "ion_left_position": "17",
                                "mass_error": "-0.0051",
                                "ppm": "-0.69"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "9",
                        "monoisotopic_mass": "3975.8152",
                        "monoisotopic_mz": "1326.2790",
                        "intensity": "4338.21",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "10",
                        "monoisotopic_mass": "3792.9503",
                        "monoisotopic_mz": "1265.3240",
                        "intensity": "6076.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "11",
                        "monoisotopic_mass": "3956.7982",
                        "monoisotopic_mz": "1319.9400",
                        "intensity": "4242.08",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "12",
                        "monoisotopic_mass": "3008.5180",
                        "monoisotopic_mz": "1003.8466",
                        "intensity": "3024.00",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "3008.5188",
                                "ion_position": "55",
                                "ion_display_position": "28",
                                "ion_sort_name": "Y00028",
                                "ion_left_position": "55",
                                "mass_error": "-0.0008",
                                "ppm": "-0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "13",
                        "monoisotopic_mass": "2609.2801",
                        "monoisotopic_mz": "1305.6473",
                        "intensity": "4067.34",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "14",
                        "monoisotopic_mass": "3120.6003",
                        "monoisotopic_mz": "1561.3074",
                        "intensity": "5476.54",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "15",
                        "monoisotopic_mass": "8629.1272",
                        "monoisotopic_mz": "1079.6482",
                        "intensity": "5814.35",
                        "charge": "8"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "16",
                        "monoisotopic_mass": "3690.9074",
                        "monoisotopic_mz": "1231.3097",
                        "intensity": "3492.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "17",
                        "monoisotopic_mass": "934.4741",
                        "monoisotopic_mz": "935.4814",
                        "intensity": "2291.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "18",
                        "monoisotopic_mass": "1386.6707",
                        "monoisotopic_mz": "1387.6780",
                        "intensity": "2328.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "19",
                        "monoisotopic_mass": "1005.4502",
                        "monoisotopic_mz": "1006.4575",
                        "intensity": "2124.21",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "1005.4525",
                                "ion_position": "71",
                                "ion_display_position": "12",
                                "ion_sort_name": "Y00012",
                                "ion_left_position": "71",
                                "mass_error": "-0.0024",
                                "ppm": "-2.35"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "20",
                        "monoisotopic_mass": "2483.2306",
                        "monoisotopic_mz": "1242.6226",
                        "intensity": "3049.60",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "21",
                        "monoisotopic_mass": "2971.5149",
                        "monoisotopic_mz": "991.5122",
                        "intensity": "3176.82",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "22",
                        "monoisotopic_mass": "1839.9303",
                        "monoisotopic_mz": "920.9724",
                        "intensity": "3778.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "23",
                        "monoisotopic_mass": "528.2725",
                        "monoisotopic_mz": "529.2798",
                        "intensity": "1732.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "24",
                        "monoisotopic_mass": "557.2803",
                        "monoisotopic_mz": "558.2875",
                        "intensity": "2353.57",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "25",
                        "monoisotopic_mass": "3922.9552",
                        "monoisotopic_mz": "1308.6590",
                        "intensity": "1349.59",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "3922.9533",
                                "ion_position": "47",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "47",
                                "mass_error": "0.0018",
                                "ppm": "0.47"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "26",
                        "monoisotopic_mass": "3279.5870",
                        "monoisotopic_mz": "1094.2029",
                        "intensity": "2608.35",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "27",
                        "monoisotopic_mass": "1189.8066",
                        "monoisotopic_mz": "1190.8138",
                        "intensity": "2753.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "28",
                        "monoisotopic_mass": "2748.4117",
                        "monoisotopic_mz": "917.1445",
                        "intensity": "2589.38",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "29",
                        "monoisotopic_mass": "682.2665",
                        "monoisotopic_mz": "683.2737",
                        "intensity": "2171.52",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "30",
                        "monoisotopic_mass": "947.4005",
                        "monoisotopic_mz": "948.4078",
                        "intensity": "4190.72",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "31",
                        "monoisotopic_mass": "984.9170",
                        "monoisotopic_mz": "985.9243",
                        "intensity": "1341.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "32",
                        "monoisotopic_mass": "3642.8079",
                        "monoisotopic_mz": "1215.2766",
                        "intensity": "1234.26",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "33",
                        "monoisotopic_mass": "3679.8629",
                        "monoisotopic_mz": "1227.6282",
                        "intensity": "1361.48",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "3679.8678",
                                "ion_position": "49",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "49",
                                "mass_error": "-0.0049",
                                "ppm": "-1.33"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "34",
                        "monoisotopic_mass": "1148.9219",
                        "monoisotopic_mz": "1149.9292",
                        "intensity": "2784.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "35",
                        "monoisotopic_mass": "1107.4295",
                        "monoisotopic_mz": "1108.4368",
                        "intensity": "1234.01",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "36",
                        "monoisotopic_mass": "1121.6889",
                        "monoisotopic_mz": "1122.6962",
                        "intensity": "1613.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "37",
                        "monoisotopic_mass": "5589.8704",
                        "monoisotopic_mz": "932.6523",
                        "intensity": "3401.54",
                        "charge": "6"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "38",
                        "monoisotopic_mass": "4019.0079",
                        "monoisotopic_mz": "1340.6766",
                        "intensity": "1264.59",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "39",
                        "monoisotopic_mass": "702.3332",
                        "monoisotopic_mz": "703.3405",
                        "intensity": "1632.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "40",
                        "monoisotopic_mass": "2402.1847",
                        "monoisotopic_mz": "1202.0996",
                        "intensity": "1081.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "41",
                        "monoisotopic_mass": "1067.3843",
                        "monoisotopic_mz": "1068.3916",
                        "intensity": "1194.60",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "42",
                        "monoisotopic_mass": "2135.3854",
                        "monoisotopic_mz": "1068.7000",
                        "intensity": "1153.51",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "43",
                        "monoisotopic_mass": "1028.5140",
                        "monoisotopic_mz": "1029.5212",
                        "intensity": "1361.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "44",
                        "monoisotopic_mass": "1961.4860",
                        "monoisotopic_mz": "981.7503",
                        "intensity": "2720.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "45",
                        "monoisotopic_mass": "2232.7948",
                        "monoisotopic_mz": "1117.4047",
                        "intensity": "3619.47",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "46",
                        "monoisotopic_mass": "1217.6059",
                        "monoisotopic_mz": "1218.6132",
                        "intensity": "1086.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "47",
                        "monoisotopic_mass": "3338.0589",
                        "monoisotopic_mz": "1113.6936",
                        "intensity": "2412.44",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "48",
                        "monoisotopic_mass": "821.3919",
                        "monoisotopic_mz": "822.3992",
                        "intensity": "2716.81",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "49",
                        "monoisotopic_mass": "803.3822",
                        "monoisotopic_mz": "804.3895",
                        "intensity": "2678.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "50",
                        "monoisotopic_mass": "972.4911",
                        "monoisotopic_mz": "973.4984",
                        "intensity": "1906.69",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "51",
                        "monoisotopic_mass": "912.2223",
                        "monoisotopic_mz": "913.2296",
                        "intensity": "1662.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "52",
                        "monoisotopic_mass": "2193.7791",
                        "monoisotopic_mz": "1097.8968",
                        "intensity": "911.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "53",
                        "monoisotopic_mass": "1095.4050",
                        "monoisotopic_mz": "1096.4122",
                        "intensity": "1242.14",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "54",
                        "monoisotopic_mass": "1050.4130",
                        "monoisotopic_mz": "1051.4203",
                        "intensity": "1918.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "55",
                        "monoisotopic_mass": "743.3242",
                        "monoisotopic_mz": "744.3315",
                        "intensity": "1878.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "56",
                        "monoisotopic_mass": "4243.8017",
                        "monoisotopic_mz": "1061.9577",
                        "intensity": "1216.85",
                        "charge": "4"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "57",
                        "monoisotopic_mass": "2219.7006",
                        "monoisotopic_mz": "1110.8576",
                        "intensity": "2539.77",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "58",
                        "monoisotopic_mass": "4036.0314",
                        "monoisotopic_mz": "1010.0151",
                        "intensity": "3172.33",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "-342.1893879173",
                                "theoretical_mass": "4036.0374",
                                "ion_position": "46",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "46",
                                "mass_error": "-0.0060",
                                "ppm": "-1.48"
                            }
                        }
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "59",
                        "monoisotopic_mass": "1162.5859",
                        "monoisotopic_mz": "1163.5931",
                        "intensity": "1738.67",
                        "charge": "1"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "60",
                        "monoisotopic_mass": "5620.9016",
                        "monoisotopic_mz": "1125.1876",
                        "intensity": "2091.75",
                        "charge": "5"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "61",
                        "monoisotopic_mass": "8037.9639",
                        "monoisotopic_mz": "1005.7528",
                        "intensity": "2858.81",
                        "charge": "8"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "62",
                        "monoisotopic_mass": "3931.3934",
                        "monoisotopic_mz": "983.8556",
                        "intensity": "2392.71",
                        "charge": "4"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "63",
                        "monoisotopic_mass": "9108.0368",
                        "monoisotopic_mz": "1139.5119",
                        "intensity": "994.21",
                        "charge": "8"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "64",
                        "monoisotopic_mass": "2015.6833",
                        "monoisotopic_mz": "1008.8489",
                        "intensity": "1488.57",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "65",
                        "monoisotopic_mass": "4138.0982",
                        "monoisotopic_mz": "1380.3733",
                        "intensity": "2602.47",
                        "charge": "3"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "66",
                        "monoisotopic_mass": "5511.9547",
                        "monoisotopic_mz": "919.6664",
                        "intensity": "3410.13",
                        "charge": "6"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "67",
                        "monoisotopic_mass": "4067.8951",
                        "monoisotopic_mz": "1017.9811",
                        "intensity": "1946.40",
                        "charge": "4"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "68",
                        "monoisotopic_mass": "1943.6337",
                        "monoisotopic_mz": "972.8241",
                        "intensity": "1626.88",
                        "charge": "2"
                    },
                    {
                        "spec_id": "164",
                        "peak_id": "69",
                        "monoisotopic_mass": "2940.6285",
                        "monoisotopic_mz": "981.2168",
                        "intensity": "1760.22",
                        "charge": "3"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4343",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "25",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "17",
                                "ion_display_position": "66",
                                "spec_id": "164",
                                "peak_id": "8",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "46",
                                    "ion_display_position": "37",
                                    "spec_id": "164",
                                    "peak_id": "58",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "46",
                                    "ion_display_position": "37",
                                    "spec_id": "164",
                                    "peak_id": "4",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "47",
                                "ion_display_position": "36",
                                "spec_id": "164",
                                "peak_id": "25",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "49",
                                "ion_display_position": "34",
                                "spec_id": "164",
                                "peak_id": "33",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "51",
                                "ion_display_position": "32",
                                "spec_id": "164",
                                "peak_id": "3",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "28",
                                    "spec_id": "164",
                                    "peak_id": "7",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "28",
                                    "spec_id": "164",
                                    "peak_id": "12",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "71",
                                "ion_display_position": "12",
                                "spec_id": "164",
                                "peak_id": "19",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "96",
                    "right_position": "108",
                    "anno": "-342.1894",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
