prsm_data =
{
    "prsm": {
        "prsm_id": "114",
        "p_value": "2.64e-05",
        "e_value": "2.64e-05",
        "fdr": "0",
        "matched_fragment_number": "11",
        "matched_peak_number": "13",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "105",
                "ms1_scans": "262",
                "ids": "158",
                "scans": "265",
                "precursor_mono_mass": "9864.8396",
                "precursor_charge": "11",
                "precursor_mz": "897.8109",
                "feature_inte": "1.2480e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "158",
                        "peak_id": "0",
                        "monoisotopic_mass": "3518.8018",
                        "monoisotopic_mz": "880.7077",
                        "intensity": "28147.16",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "0.0004",
                                "ppm": "0.11"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "1",
                        "monoisotopic_mass": "3534.7974",
                        "monoisotopic_mz": "884.7066",
                        "intensity": "27855.59",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "2",
                        "monoisotopic_mass": "3518.8023",
                        "monoisotopic_mz": "1173.9414",
                        "intensity": "21060.65",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "0.0008",
                                "ppm": "0.23"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "3",
                        "monoisotopic_mass": "3619.8509",
                        "monoisotopic_mz": "905.9700",
                        "intensity": "16997.30",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "0.0018",
                                "ppm": "0.48"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "4",
                        "monoisotopic_mass": "3635.8433",
                        "monoisotopic_mz": "909.9681",
                        "intensity": "20965.91",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "5",
                        "monoisotopic_mass": "3618.8452",
                        "monoisotopic_mz": "1207.2890",
                        "intensity": "11758.79",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "6",
                        "monoisotopic_mass": "3534.7990",
                        "monoisotopic_mz": "1179.2736",
                        "intensity": "13585.49",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "7",
                        "monoisotopic_mass": "3237.6284",
                        "monoisotopic_mz": "1080.2167",
                        "intensity": "7373.47",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3237.6275",
                                "ion_position": "62",
                                "ion_display_position": "27",
                                "ion_sort_name": "Y00027",
                                "ion_left_position": "62",
                                "mass_error": "0.0009",
                                "ppm": "0.27"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "8",
                        "monoisotopic_mass": "2229.0122",
                        "monoisotopic_mz": "744.0113",
                        "intensity": "8176.31",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "0.0002",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "9",
                        "monoisotopic_mass": "2376.0809",
                        "monoisotopic_mz": "793.0342",
                        "intensity": "8353.91",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "0.0004",
                                "ppm": "0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "10",
                        "monoisotopic_mass": "2560.2016",
                        "monoisotopic_mz": "854.4078",
                        "intensity": "8475.42",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "0.0000",
                                "ppm": "0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "11",
                        "monoisotopic_mass": "7197.7299",
                        "monoisotopic_mz": "900.7235",
                        "intensity": "7862.70",
                        "charge": "8"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "12",
                        "monoisotopic_mass": "2774.2941",
                        "monoisotopic_mz": "925.7720",
                        "intensity": "5741.28",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2774.2970",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "-0.0029",
                                "ppm": "-1.05"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "13",
                        "monoisotopic_mass": "2578.2856",
                        "monoisotopic_mz": "1290.1501",
                        "intensity": "8056.19",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "14",
                        "monoisotopic_mass": "3635.8366",
                        "monoisotopic_mz": "1212.9528",
                        "intensity": "8010.50",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "15",
                        "monoisotopic_mass": "3369.7493",
                        "monoisotopic_mz": "1124.2570",
                        "intensity": "6882.58",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "16",
                        "monoisotopic_mass": "2578.2871",
                        "monoisotopic_mz": "860.4363",
                        "intensity": "6121.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "17",
                        "monoisotopic_mass": "770.3562",
                        "monoisotopic_mz": "771.3635",
                        "intensity": "7727.93",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0003",
                                "ppm": "0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "18",
                        "monoisotopic_mass": "3253.6193",
                        "monoisotopic_mz": "1085.5470",
                        "intensity": "6390.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "19",
                        "monoisotopic_mass": "2295.1408",
                        "monoisotopic_mz": "1148.5777",
                        "intensity": "6929.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "20",
                        "monoisotopic_mass": "3872.9925",
                        "monoisotopic_mz": "969.2554",
                        "intensity": "5703.78",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "21",
                        "monoisotopic_mass": "2394.2075",
                        "monoisotopic_mz": "1198.1110",
                        "intensity": "5098.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "22",
                        "monoisotopic_mass": "2560.2018",
                        "monoisotopic_mz": "1281.1082",
                        "intensity": "4038.60",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "0.0002",
                                "ppm": "0.06"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "23",
                        "monoisotopic_mass": "2489.1688",
                        "monoisotopic_mz": "830.7302",
                        "intensity": "4733.50",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "0.0043",
                                "ppm": "1.73"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "24",
                        "monoisotopic_mass": "2521.2643",
                        "monoisotopic_mz": "841.4287",
                        "intensity": "3082.82",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "25",
                        "monoisotopic_mass": "3500.7953",
                        "monoisotopic_mz": "1167.9390",
                        "intensity": "5620.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "26",
                        "monoisotopic_mass": "2522.2645",
                        "monoisotopic_mz": "1262.1395",
                        "intensity": "3904.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "27",
                        "monoisotopic_mass": "1944.9943",
                        "monoisotopic_mz": "973.5044",
                        "intensity": "4890.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "28",
                        "monoisotopic_mass": "3907.9890",
                        "monoisotopic_mz": "978.0045",
                        "intensity": "4052.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "29",
                        "monoisotopic_mass": "2659.2707",
                        "monoisotopic_mz": "887.4308",
                        "intensity": "3805.20",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "0.0007",
                                "ppm": "0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "30",
                        "monoisotopic_mass": "3890.0009",
                        "monoisotopic_mz": "1297.6742",
                        "intensity": "5491.18",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "31",
                        "monoisotopic_mass": "3137.5546",
                        "monoisotopic_mz": "1046.8588",
                        "intensity": "4651.55",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "32",
                        "monoisotopic_mass": "2295.1393",
                        "monoisotopic_mz": "766.0537",
                        "intensity": "3183.23",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "33",
                        "monoisotopic_mass": "2972.3609",
                        "monoisotopic_mz": "991.7943",
                        "intensity": "3710.81",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "34",
                        "monoisotopic_mass": "3350.7221",
                        "monoisotopic_mz": "1117.9146",
                        "intensity": "3478.39",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3350.7116",
                                "ion_position": "61",
                                "ion_display_position": "28",
                                "ion_sort_name": "Y00028",
                                "ion_left_position": "61",
                                "mass_error": "0.0105",
                                "ppm": "3.14"
                            }
                        }
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "35",
                        "monoisotopic_mass": "2541.1905",
                        "monoisotopic_mz": "848.0708",
                        "intensity": "4131.77",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "36",
                        "monoisotopic_mass": "2230.0152",
                        "monoisotopic_mz": "1116.0149",
                        "intensity": "1993.82",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "37",
                        "monoisotopic_mass": "1090.0541",
                        "monoisotopic_mz": "1091.0614",
                        "intensity": "1718.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "38",
                        "monoisotopic_mass": "3088.5783",
                        "monoisotopic_mz": "1030.5334",
                        "intensity": "2297.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "39",
                        "monoisotopic_mass": "1290.6426",
                        "monoisotopic_mz": "1291.6499",
                        "intensity": "2881.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "40",
                        "monoisotopic_mass": "882.4555",
                        "monoisotopic_mz": "883.4628",
                        "intensity": "2183.81",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "41",
                        "monoisotopic_mass": "4170.1011",
                        "monoisotopic_mz": "835.0275",
                        "intensity": "3846.10",
                        "charge": "5"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "42",
                        "monoisotopic_mass": "3470.7843",
                        "monoisotopic_mz": "868.7033",
                        "intensity": "1863.13",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "43",
                        "monoisotopic_mass": "5391.8840",
                        "monoisotopic_mz": "899.6546",
                        "intensity": "3322.58",
                        "charge": "6"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "44",
                        "monoisotopic_mass": "955.2414",
                        "monoisotopic_mz": "956.2487",
                        "intensity": "1508.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "45",
                        "monoisotopic_mass": "3742.9661",
                        "monoisotopic_mz": "936.7488",
                        "intensity": "1239.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "46",
                        "monoisotopic_mass": "829.6331",
                        "monoisotopic_mz": "830.6404",
                        "intensity": "3273.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "47",
                        "monoisotopic_mass": "1040.1775",
                        "monoisotopic_mz": "1041.1848",
                        "intensity": "1672.71",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "48",
                        "monoisotopic_mass": "1796.9079",
                        "monoisotopic_mz": "899.4612",
                        "intensity": "1547.27",
                        "charge": "2"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "49",
                        "monoisotopic_mass": "3009.4963",
                        "monoisotopic_mz": "1004.1727",
                        "intensity": "2909.14",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "50",
                        "monoisotopic_mass": "987.5043",
                        "monoisotopic_mz": "988.5116",
                        "intensity": "1619.43",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "51",
                        "monoisotopic_mass": "1000.2498",
                        "monoisotopic_mz": "1001.2571",
                        "intensity": "2255.64",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "52",
                        "monoisotopic_mass": "5523.5919",
                        "monoisotopic_mz": "1105.7257",
                        "intensity": "1252.00",
                        "charge": "5"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "53",
                        "monoisotopic_mass": "6861.4211",
                        "monoisotopic_mz": "1144.5775",
                        "intensity": "2391.13",
                        "charge": "6"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "54",
                        "monoisotopic_mass": "4498.0178",
                        "monoisotopic_mz": "900.6108",
                        "intensity": "2476.56",
                        "charge": "5"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "55",
                        "monoisotopic_mass": "3823.9672",
                        "monoisotopic_mz": "956.9991",
                        "intensity": "1861.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "56",
                        "monoisotopic_mass": "1013.4975",
                        "monoisotopic_mz": "1014.5048",
                        "intensity": "1551.80",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "57",
                        "monoisotopic_mass": "1240.6409",
                        "monoisotopic_mz": "1241.6482",
                        "intensity": "1056.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "58",
                        "monoisotopic_mass": "2691.8510",
                        "monoisotopic_mz": "898.2909",
                        "intensity": "2343.32",
                        "charge": "3"
                    },
                    {
                        "spec_id": "158",
                        "peak_id": "59",
                        "monoisotopic_mass": "1346.6721",
                        "monoisotopic_mz": "1347.6794",
                        "intensity": "945.03",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "6",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9865.1347",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "158",
                                "peak_id": "17",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "spec_id": "158",
                                "peak_id": "8",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "spec_id": "158",
                                "peak_id": "9",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "158",
                                "peak_id": "23",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "158",
                                    "peak_id": "10",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "158",
                                    "peak_id": "22",
                                    "peak_charge": "2"
                                }
                            ]
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "spec_id": "158",
                                "peak_id": "29",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "158",
                                "peak_id": "12",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "spec_id": "158",
                                "peak_id": "3",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "158",
                                    "peak_id": "0",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "158",
                                    "peak_id": "2",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "61",
                                "ion_display_position": "28",
                                "spec_id": "158",
                                "peak_id": "34",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "62",
                                "ion_display_position": "27",
                                "spec_id": "158",
                                "peak_id": "7",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "46",
                    "right_position": "79",
                    "anno": "16.2630",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
