prsm_data =
{
    "prsm": {
        "prsm_id": "110",
        "p_value": "1.56e-08",
        "e_value": "1.56e-08",
        "fdr": "0",
        "matched_fragment_number": "16",
        "matched_peak_number": "15",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "103",
                "ms1_scans": "254",
                "ids": "151",
                "scans": "256",
                "precursor_mono_mass": "9174.4099",
                "precursor_charge": "8",
                "precursor_mz": "1147.8085",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "151",
                        "peak_id": "0",
                        "monoisotopic_mass": "8944.3153",
                        "monoisotopic_mz": "1278.7666",
                        "intensity": "458603.23",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0119",
                                "ppm": "-1.33"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "1",
                        "monoisotopic_mass": "8927.3049",
                        "monoisotopic_mz": "1276.3365",
                        "intensity": "104144.24",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "2",
                        "monoisotopic_mass": "8831.2523",
                        "monoisotopic_mz": "1262.6147",
                        "intensity": "31307.83",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "0.0092",
                                "ppm": "1.04"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "3",
                        "monoisotopic_mass": "8959.3125",
                        "monoisotopic_mz": "1280.9091",
                        "intensity": "30679.99",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "4",
                        "monoisotopic_mass": "8909.2725",
                        "monoisotopic_mz": "1273.7605",
                        "intensity": "20546.68",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "5",
                        "monoisotopic_mass": "3973.8090",
                        "monoisotopic_mz": "1325.6103",
                        "intensity": "12903.89",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "-0.0057",
                                "ppm": "-1.43"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "6",
                        "monoisotopic_mass": "4136.8736",
                        "monoisotopic_mz": "1379.9651",
                        "intensity": "9878.71",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "-0.0045",
                                "ppm": "-1.08"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "7",
                        "monoisotopic_mass": "3121.5990",
                        "monoisotopic_mz": "1561.8068",
                        "intensity": "12362.78",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "8",
                        "monoisotopic_mass": "8812.2321",
                        "monoisotopic_mz": "1259.8976",
                        "intensity": "13055.82",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "9",
                        "monoisotopic_mass": "4250.1628",
                        "monoisotopic_mz": "1417.7282",
                        "intensity": "11258.43",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "10",
                        "monoisotopic_mass": "4494.0412",
                        "monoisotopic_mz": "1124.5176",
                        "intensity": "14918.88",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4494.0429",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0017",
                                "ppm": "-0.38"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "11",
                        "monoisotopic_mass": "5565.7660",
                        "monoisotopic_mz": "1392.4488",
                        "intensity": "8470.30",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "12",
                        "monoisotopic_mass": "9154.4104",
                        "monoisotopic_mz": "1145.3086",
                        "intensity": "12946.00",
                        "charge": "8"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "13",
                        "monoisotopic_mass": "4678.3531",
                        "monoisotopic_mz": "1560.4583",
                        "intensity": "9338.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "14",
                        "monoisotopic_mass": "8718.2175",
                        "monoisotopic_mz": "1246.4669",
                        "intensity": "8637.32",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "15",
                        "monoisotopic_mass": "3773.6931",
                        "monoisotopic_mz": "1258.9050",
                        "intensity": "4117.44",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3773.6986",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "ion_sort_name": "B00032",
                                "ion_left_position": "32",
                                "mass_error": "-0.0056",
                                "ppm": "-1.48"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "16",
                        "monoisotopic_mass": "8928.2995",
                        "monoisotopic_mz": "1117.0447",
                        "intensity": "9824.75",
                        "charge": "8"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "17",
                        "monoisotopic_mass": "4036.0386",
                        "monoisotopic_mz": "1346.3535",
                        "intensity": "8080.58",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "18",
                        "monoisotopic_mass": "8515.1185",
                        "monoisotopic_mz": "1217.4528",
                        "intensity": "11512.12",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8515.1412",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "ion_sort_name": "B00073",
                                "ion_left_position": "73",
                                "mass_error": "-0.0227",
                                "ppm": "-2.67"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "19",
                        "monoisotopic_mass": "4586.7097",
                        "monoisotopic_mz": "1147.6847",
                        "intensity": "6475.81",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "20",
                        "monoisotopic_mass": "3955.7951",
                        "monoisotopic_mz": "1319.6057",
                        "intensity": "6058.59",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "21",
                        "monoisotopic_mass": "3121.5995",
                        "monoisotopic_mz": "1041.5405",
                        "intensity": "5431.52",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "22",
                        "monoisotopic_mass": "4450.2774",
                        "monoisotopic_mz": "1484.4331",
                        "intensity": "7772.85",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "23",
                        "monoisotopic_mass": "4521.1861",
                        "monoisotopic_mz": "1131.3038",
                        "intensity": "5955.40",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "24",
                        "monoisotopic_mass": "6977.4641",
                        "monoisotopic_mz": "1163.9180",
                        "intensity": "2193.79",
                        "charge": "6"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "25",
                        "monoisotopic_mass": "5367.4477",
                        "monoisotopic_mz": "1342.8692",
                        "intensity": "10218.00",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5367.4509",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "ion_sort_name": "B00047",
                                "ion_left_position": "47",
                                "mass_error": "-0.0031",
                                "ppm": "-0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "26",
                        "monoisotopic_mass": "8445.0552",
                        "monoisotopic_mz": "1207.4437",
                        "intensity": "10038.29",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8444.1041",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "ion_sort_name": "B00072",
                                "ion_left_position": "72",
                                "mass_error": "-0.0512",
                                "ppm": "-6.06"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "27",
                        "monoisotopic_mass": "2228.0758",
                        "monoisotopic_mz": "1115.0452",
                        "intensity": "4353.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "28",
                        "monoisotopic_mass": "5808.8861",
                        "monoisotopic_mz": "1453.2288",
                        "intensity": "3025.00",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "29",
                        "monoisotopic_mass": "2511.6670",
                        "monoisotopic_mz": "1256.8408",
                        "intensity": "2786.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "30",
                        "monoisotopic_mass": "3344.8792",
                        "monoisotopic_mz": "1115.9670",
                        "intensity": "7504.32",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "31",
                        "monoisotopic_mass": "4694.1461",
                        "monoisotopic_mz": "1174.5438",
                        "intensity": "3067.95",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4694.1590",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "-0.0129",
                                "ppm": "-2.75"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "32",
                        "monoisotopic_mass": "8869.2686",
                        "monoisotopic_mz": "1268.0456",
                        "intensity": "4824.16",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "33",
                        "monoisotopic_mass": "3792.9642",
                        "monoisotopic_mz": "1265.3287",
                        "intensity": "4503.47",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "34",
                        "monoisotopic_mass": "8603.1824",
                        "monoisotopic_mz": "1230.0333",
                        "intensity": "4668.21",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8602.1732",
                                "ion_position": "74",
                                "ion_display_position": "74",
                                "ion_sort_name": "B00074",
                                "ion_left_position": "74",
                                "mass_error": "0.0068",
                                "ppm": "0.80"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "35",
                        "monoisotopic_mass": "1215.2160",
                        "monoisotopic_mz": "1216.2233",
                        "intensity": "2351.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "36",
                        "monoisotopic_mass": "1966.8385",
                        "monoisotopic_mz": "984.4265",
                        "intensity": "1321.76",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1966.8401",
                                "ion_position": "17",
                                "ion_display_position": "17",
                                "ion_sort_name": "B00017",
                                "ion_left_position": "17",
                                "mass_error": "-0.0016",
                                "ppm": "-0.79"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "37",
                        "monoisotopic_mass": "5678.8504",
                        "monoisotopic_mz": "1420.7199",
                        "intensity": "3968.05",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "38",
                        "monoisotopic_mass": "8853.3324",
                        "monoisotopic_mz": "1265.7690",
                        "intensity": "5308.23",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "39",
                        "monoisotopic_mass": "4333.5699",
                        "monoisotopic_mz": "1084.3997",
                        "intensity": "1594.45",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "40",
                        "monoisotopic_mass": "1201.1069",
                        "monoisotopic_mz": "1202.1141",
                        "intensity": "2517.52",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "41",
                        "monoisotopic_mass": "3398.0790",
                        "monoisotopic_mz": "1133.7003",
                        "intensity": "1111.66",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "42",
                        "monoisotopic_mass": "3922.9892",
                        "monoisotopic_mz": "1308.6704",
                        "intensity": "3822.77",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "43",
                        "monoisotopic_mass": "2762.2667",
                        "monoisotopic_mz": "1382.1406",
                        "intensity": "3081.17",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2762.2714",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "-0.0046",
                                "ppm": "-1.68"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "44",
                        "monoisotopic_mass": "4777.1914",
                        "monoisotopic_mz": "1195.3051",
                        "intensity": "5462.06",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "45",
                        "monoisotopic_mass": "2402.5385",
                        "monoisotopic_mz": "1202.2765",
                        "intensity": "2918.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "46",
                        "monoisotopic_mass": "1154.5965",
                        "monoisotopic_mz": "1155.6038",
                        "intensity": "1363.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "47",
                        "monoisotopic_mass": "1245.4594",
                        "monoisotopic_mz": "1246.4667",
                        "intensity": "1588.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "48",
                        "monoisotopic_mass": "720.3431",
                        "monoisotopic_mz": "721.3504",
                        "intensity": "2332.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "49",
                        "monoisotopic_mass": "8739.1978",
                        "monoisotopic_mz": "1249.4641",
                        "intensity": "1262.03",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "50",
                        "monoisotopic_mass": "5792.8690",
                        "monoisotopic_mz": "1449.2245",
                        "intensity": "1036.34",
                        "charge": "4"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "51",
                        "monoisotopic_mass": "9010.2786",
                        "monoisotopic_mz": "1127.2921",
                        "intensity": "1343.82",
                        "charge": "8"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "52",
                        "monoisotopic_mass": "1076.1898",
                        "monoisotopic_mz": "1077.1970",
                        "intensity": "2437.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "53",
                        "monoisotopic_mass": "1116.5107",
                        "monoisotopic_mz": "1117.5179",
                        "intensity": "1083.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "54",
                        "monoisotopic_mass": "3426.3904",
                        "monoisotopic_mz": "1143.1374",
                        "intensity": "1192.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "55",
                        "monoisotopic_mass": "5823.7135",
                        "monoisotopic_mz": "1165.7500",
                        "intensity": "950.74",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5822.7253",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "ion_sort_name": "B00051",
                                "ion_left_position": "51",
                                "mass_error": "-0.0142",
                                "ppm": "-2.43"
                            }
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "56",
                        "monoisotopic_mass": "6002.3508",
                        "monoisotopic_mz": "1201.4774",
                        "intensity": "1306.53",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "57",
                        "monoisotopic_mass": "3445.8014",
                        "monoisotopic_mz": "1149.6077",
                        "intensity": "1146.26",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "58",
                        "monoisotopic_mass": "1395.8940",
                        "monoisotopic_mz": "1396.9012",
                        "intensity": "824.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "59",
                        "monoisotopic_mass": "2496.1164",
                        "monoisotopic_mz": "1249.0655",
                        "intensity": "1089.21",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "60",
                        "monoisotopic_mass": "2361.4545",
                        "monoisotopic_mz": "1181.7345",
                        "intensity": "1096.52",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "61",
                        "monoisotopic_mass": "2743.3337",
                        "monoisotopic_mz": "1372.6741",
                        "intensity": "1158.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "62",
                        "monoisotopic_mass": "4047.9854",
                        "monoisotopic_mz": "1350.3357",
                        "intensity": "2517.21",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "63",
                        "monoisotopic_mass": "7662.7346",
                        "monoisotopic_mz": "1095.6836",
                        "intensity": "2334.44",
                        "charge": "7",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "7661.8314",
                                    "ion_position": "13",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "Y00066",
                                    "ion_left_position": "13",
                                    "mass_error": "-0.0991",
                                    "ppm": "-12.94"
                                },
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "7662.7282",
                                    "ion_position": "66",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "B00066",
                                    "ion_left_position": "66",
                                    "mass_error": "0.0064",
                                    "ppm": "0.84"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "64",
                        "monoisotopic_mass": "5478.2652",
                        "monoisotopic_mz": "1096.6603",
                        "intensity": "1068.81",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "65",
                        "monoisotopic_mass": "6731.6470",
                        "monoisotopic_mz": "1347.3367",
                        "intensity": "1301.63",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "66",
                        "monoisotopic_mass": "934.4751",
                        "monoisotopic_mz": "935.4824",
                        "intensity": "1344.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "67",
                        "monoisotopic_mass": "870.4195",
                        "monoisotopic_mz": "871.4268",
                        "intensity": "1864.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "68",
                        "monoisotopic_mass": "1337.8611",
                        "monoisotopic_mz": "1338.8684",
                        "intensity": "838.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "69",
                        "monoisotopic_mass": "6058.0417",
                        "monoisotopic_mz": "1212.6156",
                        "intensity": "945.22",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "70",
                        "monoisotopic_mass": "1467.7492",
                        "monoisotopic_mz": "1468.7565",
                        "intensity": "729.83",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "71",
                        "monoisotopic_mass": "5742.8629",
                        "monoisotopic_mz": "1149.5799",
                        "intensity": "874.31",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "72",
                        "monoisotopic_mass": "8001.0390",
                        "monoisotopic_mz": "1144.0128",
                        "intensity": "774.50",
                        "charge": "7"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "73",
                        "monoisotopic_mass": "6598.3325",
                        "monoisotopic_mz": "1320.6738",
                        "intensity": "2292.16",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "74",
                        "monoisotopic_mass": "7223.5867",
                        "monoisotopic_mz": "1204.9384",
                        "intensity": "1015.95",
                        "charge": "6"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "75",
                        "monoisotopic_mass": "1167.5933",
                        "monoisotopic_mz": "1168.6006",
                        "intensity": "681.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "76",
                        "monoisotopic_mass": "1306.5336",
                        "monoisotopic_mz": "1307.5409",
                        "intensity": "1411.03",
                        "charge": "1"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "77",
                        "monoisotopic_mass": "2169.0432",
                        "monoisotopic_mz": "1085.5289",
                        "intensity": "1776.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "78",
                        "monoisotopic_mass": "4019.0104",
                        "monoisotopic_mz": "1340.6774",
                        "intensity": "2978.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "79",
                        "monoisotopic_mass": "2609.9339",
                        "monoisotopic_mz": "1305.9742",
                        "intensity": "4329.92",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "80",
                        "monoisotopic_mass": "5452.6967",
                        "monoisotopic_mz": "1091.5466",
                        "intensity": "2308.22",
                        "charge": "5"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "81",
                        "monoisotopic_mass": "2203.2766",
                        "monoisotopic_mz": "1102.6456",
                        "intensity": "1837.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "151",
                        "peak_id": "82",
                        "monoisotopic_mass": "2261.8384",
                        "monoisotopic_mz": "1131.9265",
                        "intensity": "2928.53",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "13",
                                "ion_display_position": "66",
                                "spec_id": "151",
                                "peak_id": "63",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "17",
                                "ion_display_position": "17",
                                "spec_id": "151",
                                "peak_id": "36",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "151",
                                "peak_id": "43",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "32",
                                "ion_display_position": "32",
                                "spec_id": "151",
                                "peak_id": "15",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "151",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "151",
                                "peak_id": "6",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "151",
                                "peak_id": "10",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "151",
                                "peak_id": "31",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "spec_id": "151",
                                "peak_id": "25",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "spec_id": "151",
                                "peak_id": "55",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "66",
                                "ion_display_position": "66",
                                "spec_id": "151",
                                "peak_id": "63",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "spec_id": "151",
                                "peak_id": "26",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "spec_id": "151",
                                "peak_id": "18",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "74",
                                "ion_display_position": "74",
                                "spec_id": "151",
                                "peak_id": "34",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "spec_id": "151",
                                "peak_id": "2",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "spec_id": "151",
                                "peak_id": "0",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
