prsm_data =
{
    "prsm": {
        "prsm_id": "107",
        "p_value": "0.05",
        "e_value": "0.05",
        "fdr": "4.39e-03",
        "matched_fragment_number": "5",
        "matched_peak_number": "5",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "102",
                "ms1_scans": "248",
                "ids": "147",
                "scans": "251",
                "precursor_mono_mass": "15921.2159",
                "precursor_charge": "19",
                "precursor_mz": "838.9660",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "147",
                        "peak_id": "0",
                        "monoisotopic_mass": "9218.9900",
                        "monoisotopic_mz": "839.0973",
                        "intensity": "50156.25",
                        "charge": "11"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "1",
                        "monoisotopic_mass": "9202.9868",
                        "monoisotopic_mz": "837.6424",
                        "intensity": "14391.83",
                        "charge": "11"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "2",
                        "monoisotopic_mass": "8047.3473",
                        "monoisotopic_mz": "895.1570",
                        "intensity": "5128.14",
                        "charge": "9"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "3",
                        "monoisotopic_mass": "2426.1710",
                        "monoisotopic_mz": "809.7310",
                        "intensity": "5614.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "4",
                        "monoisotopic_mass": "9236.9872",
                        "monoisotopic_mz": "840.7334",
                        "intensity": "7516.02",
                        "charge": "11"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "5",
                        "monoisotopic_mass": "3519.8067",
                        "monoisotopic_mz": "880.9589",
                        "intensity": "4027.04",
                        "charge": "4"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "6",
                        "monoisotopic_mass": "4361.2092",
                        "monoisotopic_mz": "873.2491",
                        "intensity": "7127.28",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0101",
                                "ppm": "-2.31"
                            }
                        }
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "7",
                        "monoisotopic_mass": "1136.6197",
                        "monoisotopic_mz": "1137.6270",
                        "intensity": "4163.62",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "0.0007",
                                "ppm": "0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "8",
                        "monoisotopic_mass": "6624.3397",
                        "monoisotopic_mz": "947.3415",
                        "intensity": "3543.40",
                        "charge": "7"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "9",
                        "monoisotopic_mass": "1677.8174",
                        "monoisotopic_mz": "839.9160",
                        "intensity": "6392.30",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "10",
                        "monoisotopic_mass": "5463.6884",
                        "monoisotopic_mz": "911.6220",
                        "intensity": "7175.19",
                        "charge": "6"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "11",
                        "monoisotopic_mass": "1556.8040",
                        "monoisotopic_mz": "779.4093",
                        "intensity": "3136.82",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "12",
                        "monoisotopic_mass": "755.4175",
                        "monoisotopic_mz": "756.4248",
                        "intensity": "3153.50",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "142",
                                "mass_error": "-0.0003",
                                "ppm": "-0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "13",
                        "monoisotopic_mass": "3332.7227",
                        "monoisotopic_mz": "834.1879",
                        "intensity": "2699.34",
                        "charge": "4"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "14",
                        "monoisotopic_mass": "826.4508",
                        "monoisotopic_mz": "827.4581",
                        "intensity": "2005.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "15",
                        "monoisotopic_mass": "1472.8099",
                        "monoisotopic_mz": "737.4122",
                        "intensity": "2969.17",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "16",
                        "monoisotopic_mass": "7541.8294",
                        "monoisotopic_mz": "838.9883",
                        "intensity": "2558.31",
                        "charge": "9"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "17",
                        "monoisotopic_mass": "3701.8428",
                        "monoisotopic_mz": "926.4680",
                        "intensity": "4718.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "18",
                        "monoisotopic_mass": "8390.4537",
                        "monoisotopic_mz": "840.0527",
                        "intensity": "1023.19",
                        "charge": "10"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "19",
                        "monoisotopic_mass": "14278.2911",
                        "monoisotopic_mz": "893.4005",
                        "intensity": "3797.88",
                        "charge": "16"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "20",
                        "monoisotopic_mass": "8276.3036",
                        "monoisotopic_mz": "1035.5452",
                        "intensity": "1199.84",
                        "charge": "8"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "21",
                        "monoisotopic_mass": "7217.0525",
                        "monoisotopic_mz": "903.1388",
                        "intensity": "954.71",
                        "charge": "8"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "22",
                        "monoisotopic_mass": "929.7958",
                        "monoisotopic_mz": "930.8031",
                        "intensity": "1188.53",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "23",
                        "monoisotopic_mass": "11210.8421",
                        "monoisotopic_mz": "935.2441",
                        "intensity": "1056.89",
                        "charge": "12"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "24",
                        "monoisotopic_mass": "9083.9063",
                        "monoisotopic_mz": "826.8169",
                        "intensity": "1164.76",
                        "charge": "11"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "25",
                        "monoisotopic_mass": "11747.1630",
                        "monoisotopic_mz": "979.9375",
                        "intensity": "4503.42",
                        "charge": "12"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "26",
                        "monoisotopic_mass": "907.4139",
                        "monoisotopic_mz": "908.4211",
                        "intensity": "1324.62",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "27",
                        "monoisotopic_mass": "11154.4474",
                        "monoisotopic_mz": "930.5446",
                        "intensity": "2169.41",
                        "charge": "12"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "28",
                        "monoisotopic_mass": "2020.0406",
                        "monoisotopic_mz": "1011.0276",
                        "intensity": "2068.79",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "29",
                        "monoisotopic_mass": "8720.4787",
                        "monoisotopic_mz": "1091.0671",
                        "intensity": "3152.26",
                        "charge": "8"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "30",
                        "monoisotopic_mass": "1880.6319",
                        "monoisotopic_mz": "941.3232",
                        "intensity": "2218.21",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "31",
                        "monoisotopic_mass": "1068.5531",
                        "monoisotopic_mz": "1069.5604",
                        "intensity": "1207.82",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "32",
                        "monoisotopic_mass": "4487.9601",
                        "monoisotopic_mz": "898.5993",
                        "intensity": "3540.41",
                        "charge": "5"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "33",
                        "monoisotopic_mass": "2581.3097",
                        "monoisotopic_mz": "861.4438",
                        "intensity": "1830.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "34",
                        "monoisotopic_mass": "10614.0284",
                        "monoisotopic_mz": "885.5096",
                        "intensity": "2306.71",
                        "charge": "12"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "35",
                        "monoisotopic_mass": "642.3335",
                        "monoisotopic_mz": "643.3408",
                        "intensity": "1244.73",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "642.3337",
                                "ion_position": "143",
                                "ion_display_position": "5",
                                "ion_sort_name": "Y00005",
                                "ion_left_position": "143",
                                "mass_error": "-0.0002",
                                "ppm": "-0.29"
                            }
                        }
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "36",
                        "monoisotopic_mass": "14789.2296",
                        "monoisotopic_mz": "925.3341",
                        "intensity": "1114.03",
                        "charge": "16"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "37",
                        "monoisotopic_mass": "5791.5623",
                        "monoisotopic_mz": "828.3733",
                        "intensity": "2809.62",
                        "charge": "7"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "38",
                        "monoisotopic_mass": "8200.6083",
                        "monoisotopic_mz": "912.1860",
                        "intensity": "2834.78",
                        "charge": "9"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "39",
                        "monoisotopic_mass": "8331.1028",
                        "monoisotopic_mz": "834.1176",
                        "intensity": "2898.09",
                        "charge": "10"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "40",
                        "monoisotopic_mass": "15831.6752",
                        "monoisotopic_mz": "932.2823",
                        "intensity": "1392.25",
                        "charge": "17"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "41",
                        "monoisotopic_mass": "2658.7651",
                        "monoisotopic_mz": "887.2623",
                        "intensity": "2499.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "42",
                        "monoisotopic_mass": "6402.8244",
                        "monoisotopic_mz": "915.6965",
                        "intensity": "1763.88",
                        "charge": "7"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "43",
                        "monoisotopic_mass": "2738.3391",
                        "monoisotopic_mz": "913.7870",
                        "intensity": "2947.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "44",
                        "monoisotopic_mass": "1866.5194",
                        "monoisotopic_mz": "934.2670",
                        "intensity": "1760.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "45",
                        "monoisotopic_mass": "12582.1314",
                        "monoisotopic_mz": "839.8160",
                        "intensity": "1106.71",
                        "charge": "15"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "46",
                        "monoisotopic_mass": "869.4458",
                        "monoisotopic_mz": "870.4531",
                        "intensity": "2760.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "47",
                        "monoisotopic_mass": "7411.8179",
                        "monoisotopic_mz": "927.4845",
                        "intensity": "1142.62",
                        "charge": "8"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "48",
                        "monoisotopic_mass": "2308.2436",
                        "monoisotopic_mz": "1155.1291",
                        "intensity": "2611.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "49",
                        "monoisotopic_mass": "846.4183",
                        "monoisotopic_mz": "847.4256",
                        "intensity": "1263.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "50",
                        "monoisotopic_mass": "7951.1034",
                        "monoisotopic_mz": "796.1176",
                        "intensity": "2694.70",
                        "charge": "10"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "51",
                        "monoisotopic_mass": "1954.9720",
                        "monoisotopic_mz": "978.4933",
                        "intensity": "1883.31",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "52",
                        "monoisotopic_mass": "3215.6770",
                        "monoisotopic_mz": "1072.8996",
                        "intensity": "2989.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "53",
                        "monoisotopic_mass": "970.9136",
                        "monoisotopic_mz": "971.9208",
                        "intensity": "2023.39",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "54",
                        "monoisotopic_mass": "13028.2673",
                        "monoisotopic_mz": "815.2740",
                        "intensity": "2742.19",
                        "charge": "16"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "55",
                        "monoisotopic_mass": "12746.3340",
                        "monoisotopic_mz": "1063.2018",
                        "intensity": "2647.58",
                        "charge": "12"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "56",
                        "monoisotopic_mass": "4049.0685",
                        "monoisotopic_mz": "1013.2744",
                        "intensity": "4034.42",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4049.1085",
                                "ion_position": "113",
                                "ion_display_position": "35",
                                "ion_sort_name": "Y00035",
                                "ion_left_position": "113",
                                "mass_error": "-0.0400",
                                "ppm": "-9.87"
                            }
                        }
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "57",
                        "monoisotopic_mass": "4509.9047",
                        "monoisotopic_mz": "902.9882",
                        "intensity": "2573.94",
                        "charge": "5"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "58",
                        "monoisotopic_mass": "13742.2939",
                        "monoisotopic_mz": "917.1602",
                        "intensity": "3206.47",
                        "charge": "15"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "59",
                        "monoisotopic_mass": "15814.8579",
                        "monoisotopic_mz": "833.3682",
                        "intensity": "2465.37",
                        "charge": "19"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "60",
                        "monoisotopic_mass": "1444.2542",
                        "monoisotopic_mz": "723.1344",
                        "intensity": "763.40",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "61",
                        "monoisotopic_mass": "2439.2953",
                        "monoisotopic_mz": "814.1057",
                        "intensity": "2289.47",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "62",
                        "monoisotopic_mass": "2610.2878",
                        "monoisotopic_mz": "871.1032",
                        "intensity": "2942.79",
                        "charge": "3"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "63",
                        "monoisotopic_mass": "4398.7255",
                        "monoisotopic_mz": "880.7524",
                        "intensity": "2106.95",
                        "charge": "5"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "64",
                        "monoisotopic_mass": "7521.0961",
                        "monoisotopic_mz": "941.1443",
                        "intensity": "1687.42",
                        "charge": "8"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "65",
                        "monoisotopic_mass": "1252.2471",
                        "monoisotopic_mz": "1253.2544",
                        "intensity": "1449.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "66",
                        "monoisotopic_mass": "1838.9684",
                        "monoisotopic_mz": "920.4915",
                        "intensity": "1970.97",
                        "charge": "2"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "67",
                        "monoisotopic_mass": "1041.6828",
                        "monoisotopic_mz": "1042.6901",
                        "intensity": "914.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "68",
                        "monoisotopic_mass": "4699.5416",
                        "monoisotopic_mz": "784.2642",
                        "intensity": "3008.43",
                        "charge": "6"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "69",
                        "monoisotopic_mass": "4175.1555",
                        "monoisotopic_mz": "836.0384",
                        "intensity": "2968.92",
                        "charge": "5"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "70",
                        "monoisotopic_mass": "6284.2940",
                        "monoisotopic_mz": "898.7636",
                        "intensity": "3015.92",
                        "charge": "7"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "71",
                        "monoisotopic_mass": "6579.5105",
                        "monoisotopic_mz": "940.9374",
                        "intensity": "1966.96",
                        "charge": "7"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "72",
                        "monoisotopic_mass": "3975.8627",
                        "monoisotopic_mz": "994.9729",
                        "intensity": "1599.01",
                        "charge": "4"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "73",
                        "monoisotopic_mass": "946.1094",
                        "monoisotopic_mz": "947.1167",
                        "intensity": "905.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "74",
                        "monoisotopic_mass": "800.4146",
                        "monoisotopic_mz": "801.4218",
                        "intensity": "989.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "75",
                        "monoisotopic_mass": "4430.2716",
                        "monoisotopic_mz": "887.0616",
                        "intensity": "1731.84",
                        "charge": "5"
                    },
                    {
                        "spec_id": "147",
                        "peak_id": "76",
                        "monoisotopic_mass": "3566.2778",
                        "monoisotopic_mz": "892.5767",
                        "intensity": "1944.63",
                        "charge": "4"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15922.2440",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "147",
                                "peak_id": "6",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "113",
                                "ion_display_position": "35",
                                "spec_id": "147",
                                "peak_id": "56",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "spec_id": "147",
                                "peak_id": "7",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "spec_id": "147",
                                "peak_id": "12",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "143",
                                "ion_display_position": "5",
                                "spec_id": "147",
                                "peak_id": "35",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
