prsm_data =
{
    "prsm": {
        "prsm_id": "105",
        "p_value": "2.37e-07",
        "e_value": "2.37e-07",
        "fdr": "0",
        "matched_fragment_number": "11",
        "matched_peak_number": "11",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "102",
                "ms1_scans": "248",
                "ids": "145",
                "scans": "249",
                "precursor_mono_mass": "15921.2011",
                "precursor_charge": "17",
                "precursor_mz": "937.5485",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "145",
                        "peak_id": "0",
                        "monoisotopic_mass": "7543.8739",
                        "monoisotopic_mz": "1078.7035",
                        "intensity": "13720.88",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "79",
                                "mass_error": "-0.0056",
                                "ppm": "-0.74"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "1",
                        "monoisotopic_mass": "4361.2194",
                        "monoisotopic_mz": "873.2512",
                        "intensity": "7990.82",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "0.0002",
                                "ppm": "0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "2",
                        "monoisotopic_mass": "3738.9340",
                        "monoisotopic_mz": "935.7408",
                        "intensity": "8862.58",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "3",
                        "monoisotopic_mass": "1136.6189",
                        "monoisotopic_mz": "1137.6262",
                        "intensity": "5459.06",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "-0.0001",
                                "ppm": "-0.06"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "4",
                        "monoisotopic_mass": "6429.3376",
                        "monoisotopic_mz": "1286.8748",
                        "intensity": "7974.34",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6429.3359",
                                "ion_position": "90",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "90",
                                "mass_error": "0.0017",
                                "ppm": "0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "5",
                        "monoisotopic_mass": "8007.1434",
                        "monoisotopic_mz": "890.6899",
                        "intensity": "13034.12",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8007.1407",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "ion_sort_name": "B00075",
                                "ion_left_position": "75",
                                "mass_error": "0.0027",
                                "ppm": "0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "6",
                        "monoisotopic_mass": "6882.4510",
                        "monoisotopic_mz": "861.3137",
                        "intensity": "5299.89",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "7",
                        "monoisotopic_mass": "1065.5457",
                        "monoisotopic_mz": "1066.5530",
                        "intensity": "3248.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "8",
                        "monoisotopic_mass": "6543.5616",
                        "monoisotopic_mz": "935.8018",
                        "intensity": "14985.92",
                        "charge": "7"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "9",
                        "monoisotopic_mass": "920.4758",
                        "monoisotopic_mz": "921.4831",
                        "intensity": "3063.16",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "920.4756",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0002",
                                "ppm": "0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "10",
                        "monoisotopic_mass": "4360.2139",
                        "monoisotopic_mz": "1091.0608",
                        "intensity": "6196.31",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "11",
                        "monoisotopic_mass": "1742.4587",
                        "monoisotopic_mz": "872.2366",
                        "intensity": "2595.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "12",
                        "monoisotopic_mass": "2582.9778",
                        "monoisotopic_mz": "861.9999",
                        "intensity": "3668.61",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "13",
                        "monoisotopic_mass": "4051.0883",
                        "monoisotopic_mz": "1013.7793",
                        "intensity": "3407.63",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "14",
                        "monoisotopic_mass": "7473.8607",
                        "monoisotopic_mz": "1246.6507",
                        "intensity": "2205.39",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "80",
                                "mass_error": "0.0160",
                                "ppm": "2.14"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "15",
                        "monoisotopic_mass": "4530.0463",
                        "monoisotopic_mz": "907.0165",
                        "intensity": "834.05",
                        "charge": "5"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "16",
                        "monoisotopic_mass": "10937.6840",
                        "monoisotopic_mz": "912.4809",
                        "intensity": "1249.72",
                        "charge": "12"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "17",
                        "monoisotopic_mass": "5176.7119",
                        "monoisotopic_mz": "1036.3497",
                        "intensity": "959.39",
                        "charge": "5"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "18",
                        "monoisotopic_mass": "905.8007",
                        "monoisotopic_mz": "906.8079",
                        "intensity": "1180.32",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "19",
                        "monoisotopic_mass": "13790.7567",
                        "monoisotopic_mz": "920.3911",
                        "intensity": "1177.18",
                        "charge": "15"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "20",
                        "monoisotopic_mass": "2232.7360",
                        "monoisotopic_mz": "1117.3753",
                        "intensity": "881.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "21",
                        "monoisotopic_mass": "8735.6053",
                        "monoisotopic_mz": "874.5678",
                        "intensity": "5056.26",
                        "charge": "10"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "22",
                        "monoisotopic_mass": "2045.5475",
                        "monoisotopic_mz": "1023.7810",
                        "intensity": "2234.17",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "23",
                        "monoisotopic_mass": "3872.9998",
                        "monoisotopic_mz": "969.2572",
                        "intensity": "1032.19",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "24",
                        "monoisotopic_mass": "7277.9086",
                        "monoisotopic_mz": "1040.7085",
                        "intensity": "736.33",
                        "charge": "7"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "25",
                        "monoisotopic_mass": "15589.2036",
                        "monoisotopic_mz": "1040.2875",
                        "intensity": "1241.39",
                        "charge": "15"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "26",
                        "monoisotopic_mass": "2123.0753",
                        "monoisotopic_mz": "1062.5449",
                        "intensity": "4856.28",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "27",
                        "monoisotopic_mass": "9692.3432",
                        "monoisotopic_mz": "1212.5502",
                        "intensity": "1150.58",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "28",
                        "monoisotopic_mass": "1039.5650",
                        "monoisotopic_mz": "1040.5723",
                        "intensity": "1184.19",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1039.5662",
                                "ion_position": "139",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "139",
                                "mass_error": "-0.0013",
                                "ppm": "-1.21"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "29",
                        "monoisotopic_mass": "2602.6629",
                        "monoisotopic_mz": "868.5616",
                        "intensity": "2418.94",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "30",
                        "monoisotopic_mass": "8941.8744",
                        "monoisotopic_mz": "895.1947",
                        "intensity": "957.03",
                        "charge": "10"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "31",
                        "monoisotopic_mass": "1087.7214",
                        "monoisotopic_mz": "1088.7286",
                        "intensity": "1257.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "32",
                        "monoisotopic_mass": "8960.1218",
                        "monoisotopic_mz": "996.5764",
                        "intensity": "1964.97",
                        "charge": "9"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "33",
                        "monoisotopic_mass": "966.5103",
                        "monoisotopic_mz": "967.5176",
                        "intensity": "1407.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "34",
                        "monoisotopic_mass": "755.4180",
                        "monoisotopic_mz": "756.4252",
                        "intensity": "2245.72",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "142",
                                "mass_error": "0.0002",
                                "ppm": "0.23"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "35",
                        "monoisotopic_mass": "1001.3944",
                        "monoisotopic_mz": "1002.4017",
                        "intensity": "1585.72",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "36",
                        "monoisotopic_mass": "12044.4109",
                        "monoisotopic_mz": "1004.7082",
                        "intensity": "1701.49",
                        "charge": "12"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "37",
                        "monoisotopic_mass": "5640.8605",
                        "monoisotopic_mz": "941.1507",
                        "intensity": "2822.14",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5640.8601",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "ion_sort_name": "B00051",
                                "ion_left_position": "51",
                                "mass_error": "0.0004",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "38",
                        "monoisotopic_mass": "6274.1922",
                        "monoisotopic_mz": "1046.7060",
                        "intensity": "2948.36",
                        "charge": "6"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "39",
                        "monoisotopic_mass": "6310.3188",
                        "monoisotopic_mz": "1052.7271",
                        "intensity": "1163.55",
                        "charge": "6"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "40",
                        "monoisotopic_mass": "7776.3173",
                        "monoisotopic_mz": "973.0469",
                        "intensity": "2452.62",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "41",
                        "monoisotopic_mass": "2135.7712",
                        "monoisotopic_mz": "1068.8929",
                        "intensity": "2508.69",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "42",
                        "monoisotopic_mass": "8932.9593",
                        "monoisotopic_mz": "1117.6272",
                        "intensity": "1235.72",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "43",
                        "monoisotopic_mass": "8365.9290",
                        "monoisotopic_mz": "1046.7484",
                        "intensity": "1172.78",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "44",
                        "monoisotopic_mass": "950.4880",
                        "monoisotopic_mz": "951.4952",
                        "intensity": "1076.68",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "45",
                        "monoisotopic_mass": "888.3479",
                        "monoisotopic_mz": "889.3552",
                        "intensity": "1729.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "46",
                        "monoisotopic_mass": "10427.2072",
                        "monoisotopic_mz": "1043.7280",
                        "intensity": "1218.20",
                        "charge": "10"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "47",
                        "monoisotopic_mass": "3471.1041",
                        "monoisotopic_mz": "1158.0420",
                        "intensity": "1041.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "48",
                        "monoisotopic_mass": "1246.8127",
                        "monoisotopic_mz": "1247.8199",
                        "intensity": "1175.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "49",
                        "monoisotopic_mass": "3763.4393",
                        "monoisotopic_mz": "941.8671",
                        "intensity": "1022.29",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "50",
                        "monoisotopic_mass": "7210.3244",
                        "monoisotopic_mz": "1031.0536",
                        "intensity": "1992.22",
                        "charge": "7"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "51",
                        "monoisotopic_mass": "1299.6827",
                        "monoisotopic_mz": "1300.6899",
                        "intensity": "1215.06",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1299.6823",
                                "ion_position": "137",
                                "ion_display_position": "11",
                                "ion_sort_name": "Y00011",
                                "ion_left_position": "137",
                                "mass_error": "0.0003",
                                "ppm": "0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "52",
                        "monoisotopic_mass": "2728.4031",
                        "monoisotopic_mz": "910.4750",
                        "intensity": "4403.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "53",
                        "monoisotopic_mass": "1118.1648",
                        "monoisotopic_mz": "1119.1721",
                        "intensity": "733.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "54",
                        "monoisotopic_mass": "7890.0157",
                        "monoisotopic_mz": "877.6757",
                        "intensity": "2777.63",
                        "charge": "9"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "55",
                        "monoisotopic_mass": "8425.1361",
                        "monoisotopic_mz": "937.1335",
                        "intensity": "2366.22",
                        "charge": "9"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "56",
                        "monoisotopic_mass": "7679.9845",
                        "monoisotopic_mz": "961.0053",
                        "intensity": "1211.80",
                        "charge": "8"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "57",
                        "monoisotopic_mass": "8217.3751",
                        "monoisotopic_mz": "914.0490",
                        "intensity": "2994.63",
                        "charge": "9"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "58",
                        "monoisotopic_mass": "4022.1048",
                        "monoisotopic_mz": "1006.5335",
                        "intensity": "2287.42",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "59",
                        "monoisotopic_mass": "3215.6781",
                        "monoisotopic_mz": "1072.9000",
                        "intensity": "2403.94",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "60",
                        "monoisotopic_mass": "4514.8970",
                        "monoisotopic_mz": "1129.7315",
                        "intensity": "969.31",
                        "charge": "4"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "61",
                        "monoisotopic_mass": "1175.9917",
                        "monoisotopic_mz": "1176.9990",
                        "intensity": "693.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "62",
                        "monoisotopic_mass": "3255.1948",
                        "monoisotopic_mz": "1086.0722",
                        "intensity": "2175.16",
                        "charge": "3"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "63",
                        "monoisotopic_mass": "2001.1678",
                        "monoisotopic_mz": "1001.5912",
                        "intensity": "1895.43",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "64",
                        "monoisotopic_mass": "2083.7474",
                        "monoisotopic_mz": "1042.8810",
                        "intensity": "1856.96",
                        "charge": "2"
                    },
                    {
                        "spec_id": "145",
                        "peak_id": "65",
                        "monoisotopic_mass": "2170.7979",
                        "monoisotopic_mz": "1086.4062",
                        "intensity": "1459.24",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15922.2440",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "145",
                                "peak_id": "9",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "145",
                                "peak_id": "1",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "51",
                                "ion_display_position": "51",
                                "spec_id": "145",
                                "peak_id": "37",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "spec_id": "145",
                                "peak_id": "5",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "69",
                                "spec_id": "145",
                                "peak_id": "0",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "68",
                                "spec_id": "145",
                                "peak_id": "14",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "90",
                                "ion_display_position": "58",
                                "spec_id": "145",
                                "peak_id": "4",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "137",
                                "ion_display_position": "11",
                                "spec_id": "145",
                                "peak_id": "51",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "spec_id": "145",
                                "peak_id": "3",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "139",
                                "ion_display_position": "9",
                                "spec_id": "145",
                                "peak_id": "28",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "spec_id": "145",
                                "peak_id": "34",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
