prsm_data =
{
    "prsm": {
        "prsm_id": "104",
        "p_value": "5.23e-15",
        "e_value": "5.23e-15",
        "fdr": "0",
        "matched_fragment_number": "19",
        "matched_peak_number": "25",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "101",
                "ms1_scans": "245",
                "ids": "143",
                "scans": "246",
                "precursor_mono_mass": "9848.8526",
                "precursor_charge": "9",
                "precursor_mz": "1095.3242",
                "feature_inte": "1.3385e+09"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "143",
                        "peak_id": "0",
                        "monoisotopic_mass": "3518.8008",
                        "monoisotopic_mz": "1173.9409",
                        "intensity": "43568.33",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0006",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "1",
                        "monoisotopic_mass": "3891.0025",
                        "monoisotopic_mz": "1298.0081",
                        "intensity": "35260.95",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3891.0023",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "55",
                                "mass_error": "0.0002",
                                "ppm": "0.06"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "2",
                        "monoisotopic_mass": "6583.3693",
                        "monoisotopic_mz": "1317.6811",
                        "intensity": "30988.07",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6583.3731",
                                "ion_position": "29",
                                "ion_display_position": "60",
                                "ion_sort_name": "Y00060",
                                "ion_left_position": "29",
                                "mass_error": "-0.0038",
                                "ppm": "-0.58"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "3",
                        "monoisotopic_mass": "3819.9660",
                        "monoisotopic_mz": "1274.3293",
                        "intensity": "32139.03",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3819.9652",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "ion_sort_name": "Y00033",
                                "ion_left_position": "56",
                                "mass_error": "0.0008",
                                "ppm": "0.22"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "4",
                        "monoisotopic_mass": "3619.8479",
                        "monoisotopic_mz": "1207.6232",
                        "intensity": "44964.09",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0012",
                                "ppm": "-0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "5",
                        "monoisotopic_mass": "3718.9178",
                        "monoisotopic_mz": "1240.6466",
                        "intensity": "20428.32",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3718.9175",
                                "ion_position": "57",
                                "ion_display_position": "32",
                                "ion_sort_name": "Y00032",
                                "ion_left_position": "57",
                                "mass_error": "0.0003",
                                "ppm": "0.09"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "6",
                        "monoisotopic_mass": "4061.1079",
                        "monoisotopic_mz": "1354.7099",
                        "intensity": "19197.99",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4061.1078",
                                "ion_position": "53",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "53",
                                "mass_error": "0.0000",
                                "ppm": "0.00"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "7",
                        "monoisotopic_mass": "2774.2975",
                        "monoisotopic_mz": "925.7731",
                        "intensity": "12291.13",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2774.2970",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0006",
                                "ppm": "0.20"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "8",
                        "monoisotopic_mass": "6565.3688",
                        "monoisotopic_mz": "1314.0810",
                        "intensity": "17043.84",
                        "charge": "5"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "9",
                        "monoisotopic_mass": "3518.7986",
                        "monoisotopic_mz": "880.7069",
                        "intensity": "11768.43",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0028",
                                "ppm": "-0.79"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "10",
                        "monoisotopic_mass": "2560.2006",
                        "monoisotopic_mz": "1281.1076",
                        "intensity": "12085.94",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "-0.0011",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "11",
                        "monoisotopic_mass": "3872.9868",
                        "monoisotopic_mz": "1292.0029",
                        "intensity": "13708.76",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "12",
                        "monoisotopic_mass": "3500.7858",
                        "monoisotopic_mz": "1167.9359",
                        "intensity": "7558.49",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "13",
                        "monoisotopic_mass": "4043.1020",
                        "monoisotopic_mz": "1348.7079",
                        "intensity": "10810.50",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "14",
                        "monoisotopic_mass": "2522.2692",
                        "monoisotopic_mz": "1262.1419",
                        "intensity": "9592.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "15",
                        "monoisotopic_mass": "2579.2902",
                        "monoisotopic_mz": "1290.6524",
                        "intensity": "7119.42",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "16",
                        "monoisotopic_mass": "2659.2683",
                        "monoisotopic_mz": "887.4300",
                        "intensity": "8309.30",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "-0.0017",
                                "ppm": "-0.65"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "17",
                        "monoisotopic_mass": "2376.0788",
                        "monoisotopic_mz": "1189.0467",
                        "intensity": "7239.45",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "-0.0017",
                                "ppm": "-0.72"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "18",
                        "monoisotopic_mass": "2560.2037",
                        "monoisotopic_mz": "854.4085",
                        "intensity": "8622.05",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "0.0020",
                                "ppm": "0.79"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "19",
                        "monoisotopic_mass": "770.3557",
                        "monoisotopic_mz": "771.3630",
                        "intensity": "8812.10",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0002",
                                "ppm": "-0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "20",
                        "monoisotopic_mass": "3266.5048",
                        "monoisotopic_mz": "1089.8422",
                        "intensity": "7338.75",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "21",
                        "monoisotopic_mass": "2489.1620",
                        "monoisotopic_mz": "1245.5883",
                        "intensity": "8318.20",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "-0.0025",
                                "ppm": "-1.01"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "22",
                        "monoisotopic_mass": "2903.3395",
                        "monoisotopic_mz": "968.7871",
                        "intensity": "7963.03",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2903.3396",
                                "ion_position": "26",
                                "ion_display_position": "26",
                                "ion_sort_name": "B00026",
                                "ion_left_position": "26",
                                "mass_error": "-0.0001",
                                "ppm": "-0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "23",
                        "monoisotopic_mass": "2435.2973",
                        "monoisotopic_mz": "1218.6559",
                        "intensity": "5608.03",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2435.2995",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "69",
                                "mass_error": "-0.0023",
                                "ppm": "-0.93"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "24",
                        "monoisotopic_mass": "2692.3722",
                        "monoisotopic_mz": "1347.1934",
                        "intensity": "7735.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "25",
                        "monoisotopic_mass": "2763.4108",
                        "monoisotopic_mz": "1382.7127",
                        "intensity": "7012.92",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "26",
                        "monoisotopic_mass": "2990.3719",
                        "monoisotopic_mz": "997.7979",
                        "intensity": "5835.40",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2990.3716",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "ion_sort_name": "B00027",
                                "ion_left_position": "27",
                                "mass_error": "0.0003",
                                "ppm": "0.09"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "27",
                        "monoisotopic_mass": "3801.9532",
                        "monoisotopic_mz": "1268.3250",
                        "intensity": "5072.50",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "28",
                        "monoisotopic_mass": "4005.0779",
                        "monoisotopic_mz": "1336.0332",
                        "intensity": "6075.43",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "29",
                        "monoisotopic_mass": "3369.7471",
                        "monoisotopic_mz": "1124.2563",
                        "intensity": "5461.23",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "30",
                        "monoisotopic_mass": "3619.8476",
                        "monoisotopic_mz": "905.9692",
                        "intensity": "10493.02",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0015",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "31",
                        "monoisotopic_mass": "3742.9559",
                        "monoisotopic_mz": "1248.6593",
                        "intensity": "3477.25",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "32",
                        "monoisotopic_mass": "2489.1641",
                        "monoisotopic_mz": "830.7286",
                        "intensity": "6087.33",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "-0.0004",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "33",
                        "monoisotopic_mass": "2294.1365",
                        "monoisotopic_mz": "1148.0755",
                        "intensity": "4087.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "34",
                        "monoisotopic_mass": "2659.2677",
                        "monoisotopic_mz": "1330.6411",
                        "intensity": "5797.84",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "-0.0023",
                                "ppm": "-0.88"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "35",
                        "monoisotopic_mass": "2186.3269",
                        "monoisotopic_mz": "1094.1707",
                        "intensity": "3649.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "36",
                        "monoisotopic_mass": "3890.9977",
                        "monoisotopic_mz": "973.7567",
                        "intensity": "3781.85",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3891.0023",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "55",
                                "mass_error": "-0.0046",
                                "ppm": "-1.18"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "37",
                        "monoisotopic_mass": "2470.1471",
                        "monoisotopic_mz": "824.3896",
                        "intensity": "4501.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "38",
                        "monoisotopic_mass": "3469.7893",
                        "monoisotopic_mz": "1157.6037",
                        "intensity": "4019.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "39",
                        "monoisotopic_mass": "4171.1377",
                        "monoisotopic_mz": "1391.3865",
                        "intensity": "5657.56",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "40",
                        "monoisotopic_mass": "3602.8334",
                        "monoisotopic_mz": "1201.9517",
                        "intensity": "3873.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "41",
                        "monoisotopic_mass": "4154.1265",
                        "monoisotopic_mz": "1385.7161",
                        "intensity": "4193.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "42",
                        "monoisotopic_mass": "3247.4809",
                        "monoisotopic_mz": "1083.5009",
                        "intensity": "4425.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "43",
                        "monoisotopic_mass": "2394.2047",
                        "monoisotopic_mz": "1198.1096",
                        "intensity": "7119.62",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "44",
                        "monoisotopic_mass": "3872.9911",
                        "monoisotopic_mz": "969.2551",
                        "intensity": "4418.62",
                        "charge": "4"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "45",
                        "monoisotopic_mass": "1079.5448",
                        "monoisotopic_mz": "1080.5521",
                        "intensity": "2669.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "46",
                        "monoisotopic_mass": "3912.0597",
                        "monoisotopic_mz": "1305.0272",
                        "intensity": "3085.36",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "47",
                        "monoisotopic_mass": "3820.9697",
                        "monoisotopic_mz": "956.2497",
                        "intensity": "2781.77",
                        "charge": "4"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "48",
                        "monoisotopic_mass": "2229.0082",
                        "monoisotopic_mz": "1115.5114",
                        "intensity": "4008.32",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "-0.0039",
                                "ppm": "-1.73"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "49",
                        "monoisotopic_mass": "820.3891",
                        "monoisotopic_mz": "821.3964",
                        "intensity": "1502.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "50",
                        "monoisotopic_mass": "2855.4148",
                        "monoisotopic_mz": "1428.7147",
                        "intensity": "2504.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "51",
                        "monoisotopic_mass": "9304.3860",
                        "monoisotopic_mz": "1164.0555",
                        "intensity": "1444.56",
                        "charge": "8"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "52",
                        "monoisotopic_mass": "5010.4987",
                        "monoisotopic_mz": "1253.6319",
                        "intensity": "2890.27",
                        "charge": "4"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "53",
                        "monoisotopic_mass": "4043.0999",
                        "monoisotopic_mz": "1011.7822",
                        "intensity": "2595.60",
                        "charge": "4"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "54",
                        "monoisotopic_mass": "2228.0069",
                        "monoisotopic_mz": "743.6763",
                        "intensity": "1679.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "55",
                        "monoisotopic_mass": "5542.1703",
                        "monoisotopic_mz": "1386.5498",
                        "intensity": "1303.26",
                        "charge": "4"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "56",
                        "monoisotopic_mass": "843.4116",
                        "monoisotopic_mz": "844.4189",
                        "intensity": "1614.04",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "57",
                        "monoisotopic_mass": "2543.1904",
                        "monoisotopic_mz": "848.7374",
                        "intensity": "2539.44",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "58",
                        "monoisotopic_mass": "6694.4006",
                        "monoisotopic_mz": "1339.8874",
                        "intensity": "8646.23",
                        "charge": "5"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "59",
                        "monoisotopic_mass": "5814.9519",
                        "monoisotopic_mz": "1163.9977",
                        "intensity": "2600.88",
                        "charge": "5"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "60",
                        "monoisotopic_mass": "1438.5254",
                        "monoisotopic_mz": "1439.5327",
                        "intensity": "602.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "61",
                        "monoisotopic_mass": "862.4330",
                        "monoisotopic_mz": "863.4402",
                        "intensity": "1420.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "62",
                        "monoisotopic_mass": "1423.7293",
                        "monoisotopic_mz": "1424.7366",
                        "intensity": "2458.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "63",
                        "monoisotopic_mass": "1360.6991",
                        "monoisotopic_mz": "1361.7064",
                        "intensity": "664.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "64",
                        "monoisotopic_mass": "1223.6326",
                        "monoisotopic_mz": "1224.6399",
                        "intensity": "1409.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "65",
                        "monoisotopic_mass": "1759.4003",
                        "monoisotopic_mz": "1760.4076",
                        "intensity": "1847.08",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "66",
                        "monoisotopic_mass": "7186.5300",
                        "monoisotopic_mz": "1438.3133",
                        "intensity": "1233.27",
                        "charge": "5"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "67",
                        "monoisotopic_mass": "1012.4940",
                        "monoisotopic_mz": "1013.5013",
                        "intensity": "1599.72",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1012.4938",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "0.0002",
                                "ppm": "0.23"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "68",
                        "monoisotopic_mass": "1034.0132",
                        "monoisotopic_mz": "1035.0205",
                        "intensity": "1478.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "69",
                        "monoisotopic_mass": "1062.4344",
                        "monoisotopic_mz": "1063.4416",
                        "intensity": "870.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "70",
                        "monoisotopic_mass": "3635.8114",
                        "monoisotopic_mz": "1212.9444",
                        "intensity": "1140.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "71",
                        "monoisotopic_mass": "1336.7090",
                        "monoisotopic_mz": "669.3618",
                        "intensity": "1608.79",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1336.7099",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "ion_sort_name": "B00013",
                                "ion_left_position": "13",
                                "mass_error": "-0.0010",
                                "ppm": "-0.71"
                            }
                        }
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "72",
                        "monoisotopic_mass": "2973.3627",
                        "monoisotopic_mz": "992.1282",
                        "intensity": "2696.76",
                        "charge": "3"
                    },
                    {
                        "spec_id": "143",
                        "peak_id": "73",
                        "monoisotopic_mass": "3279.8089",
                        "monoisotopic_mz": "1094.2769",
                        "intensity": "3964.26",
                        "charge": "3"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "0",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9848.8717",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "143",
                                "peak_id": "19",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "spec_id": "143",
                                "peak_id": "67",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "13",
                                "ion_display_position": "13",
                                "spec_id": "143",
                                "peak_id": "71",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "spec_id": "143",
                                "peak_id": "48",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "spec_id": "143",
                                "peak_id": "17",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "spec_id": "143",
                                    "peak_id": "21",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "spec_id": "143",
                                    "peak_id": "32",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "143",
                                    "peak_id": "10",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "143",
                                    "peak_id": "18",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "24",
                                    "ion_display_position": "24",
                                    "spec_id": "143",
                                    "peak_id": "34",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "24",
                                    "ion_display_position": "24",
                                    "spec_id": "143",
                                    "peak_id": "16",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "143",
                                "peak_id": "7",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "26",
                                "ion_display_position": "26",
                                "spec_id": "143",
                                "peak_id": "22",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "spec_id": "143",
                                "peak_id": "26",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "29",
                                "ion_display_position": "60",
                                "spec_id": "143",
                                "peak_id": "2",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "53",
                                "ion_display_position": "36",
                                "spec_id": "143",
                                "peak_id": "6",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "34",
                                    "spec_id": "143",
                                    "peak_id": "36",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "55",
                                    "ion_display_position": "34",
                                    "spec_id": "143",
                                    "peak_id": "1",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "spec_id": "143",
                                "peak_id": "3",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "57",
                                "ion_display_position": "32",
                                "spec_id": "143",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "143",
                                    "peak_id": "30",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "143",
                                    "peak_id": "4",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "143",
                                    "peak_id": "9",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "143",
                                    "peak_id": "0",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "spec_id": "143",
                                "peak_id": "23",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
