prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "7",
        "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
        "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
        "proteoform_id": "9",
        "prsm_number": "17",
        "prsm": [
            {
                "prsm_id": "94",
                "p_value": "8.38e-08",
                "e_value": "8.38e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "96",
                        "ms1_scans": "223",
                        "ids": "128",
                        "scans": "226",
                        "precursor_mono_mass": "9219.9652",
                        "precursor_charge": "12",
                        "precursor_mz": "769.3377",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "128",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5778",
                                "monoisotopic_mz": "784.2702",
                                "intensity": "55733.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6499",
                                "monoisotopic_mz": "800.7823",
                                "intensity": "23337.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0028",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7291",
                                "monoisotopic_mz": "819.4621",
                                "intensity": "15974.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "3",
                                "monoisotopic_mass": "2793.5148",
                                "monoisotopic_mz": "932.1789",
                                "intensity": "7519.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "4",
                                "monoisotopic_mass": "4138.1611",
                                "monoisotopic_mz": "1035.5476",
                                "intensity": "9173.43",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0031",
                                        "ppm": "0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "5",
                                "monoisotopic_mass": "4495.4896",
                                "monoisotopic_mz": "750.2555",
                                "intensity": "5146.07",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0007",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5643",
                                "monoisotopic_mz": "781.4347",
                                "intensity": "8673.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "7",
                                "monoisotopic_mass": "1472.8091",
                                "monoisotopic_mz": "737.4118",
                                "intensity": "7089.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "8",
                                "monoisotopic_mass": "4642.5515",
                                "monoisotopic_mz": "774.7659",
                                "intensity": "11140.29",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0058",
                                        "ppm": "-1.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "9",
                                "monoisotopic_mass": "4980.7555",
                                "monoisotopic_mz": "831.1332",
                                "intensity": "6756.01",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "10",
                                "monoisotopic_mass": "4566.5308",
                                "monoisotopic_mz": "762.0957",
                                "intensity": "7122.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "11",
                                "monoisotopic_mass": "4665.5894",
                                "monoisotopic_mz": "778.6055",
                                "intensity": "4907.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "12",
                                "monoisotopic_mass": "3047.6596",
                                "monoisotopic_mz": "1016.8938",
                                "intensity": "2614.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "13",
                                "monoisotopic_mass": "2680.4325",
                                "monoisotopic_mz": "894.4848",
                                "intensity": "4599.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "14",
                                "monoisotopic_mass": "3852.0714",
                                "monoisotopic_mz": "771.4216",
                                "intensity": "6580.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "15",
                                "monoisotopic_mass": "797.1012",
                                "monoisotopic_mz": "798.1085",
                                "intensity": "2120.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "16",
                                "monoisotopic_mass": "974.4203",
                                "monoisotopic_mz": "975.4276",
                                "intensity": "2651.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "17",
                                "monoisotopic_mass": "4894.7077",
                                "monoisotopic_mz": "816.7919",
                                "intensity": "4907.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "18",
                                "monoisotopic_mass": "2300.2395",
                                "monoisotopic_mz": "767.7538",
                                "intensity": "3671.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "19",
                                "monoisotopic_mass": "5821.7288",
                                "monoisotopic_mz": "832.6828",
                                "intensity": "2421.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "20",
                                "monoisotopic_mass": "3071.6490",
                                "monoisotopic_mz": "768.9195",
                                "intensity": "5066.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "21",
                                "monoisotopic_mass": "8929.8533",
                                "monoisotopic_mz": "745.1617",
                                "intensity": "3159.11",
                                "charge": "12"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "22",
                                "monoisotopic_mass": "8451.3386",
                                "monoisotopic_mz": "769.3108",
                                "intensity": "1147.54",
                                "charge": "11"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "23",
                                "monoisotopic_mass": "837.4234",
                                "monoisotopic_mz": "838.4307",
                                "intensity": "1247.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "24",
                                "monoisotopic_mass": "5090.3401",
                                "monoisotopic_mz": "849.3973",
                                "intensity": "1026.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "25",
                                "monoisotopic_mass": "8419.9749",
                                "monoisotopic_mz": "766.4595",
                                "intensity": "2740.47",
                                "charge": "11"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "26",
                                "monoisotopic_mass": "8728.8864",
                                "monoisotopic_mz": "728.4145",
                                "intensity": "2363.82",
                                "charge": "12"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "27",
                                "monoisotopic_mass": "902.4889",
                                "monoisotopic_mz": "903.4962",
                                "intensity": "1482.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "28",
                                "monoisotopic_mass": "760.2423",
                                "monoisotopic_mz": "761.2496",
                                "intensity": "1258.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "29",
                                "monoisotopic_mass": "917.4971",
                                "monoisotopic_mz": "918.5044",
                                "intensity": "1032.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "30",
                                "monoisotopic_mass": "4120.1516",
                                "monoisotopic_mz": "825.0376",
                                "intensity": "2450.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "31",
                                "monoisotopic_mass": "932.0874",
                                "monoisotopic_mz": "933.0947",
                                "intensity": "1175.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "32",
                                "monoisotopic_mass": "2401.4186",
                                "monoisotopic_mz": "801.4802",
                                "intensity": "1685.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "33",
                                "monoisotopic_mass": "5581.3871",
                                "monoisotopic_mz": "798.3483",
                                "intensity": "1184.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "34",
                                "monoisotopic_mass": "8463.0343",
                                "monoisotopic_mz": "770.3740",
                                "intensity": "2370.73",
                                "charge": "11"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "35",
                                "monoisotopic_mass": "3972.4090",
                                "monoisotopic_mz": "994.1095",
                                "intensity": "1080.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "36",
                                "monoisotopic_mass": "3246.7801",
                                "monoisotopic_mz": "812.7023",
                                "intensity": "2594.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "37",
                                "monoisotopic_mass": "4511.4971",
                                "monoisotopic_mz": "752.9235",
                                "intensity": "2452.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "38",
                                "monoisotopic_mass": "855.3271",
                                "monoisotopic_mz": "856.3343",
                                "intensity": "1370.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "39",
                                "monoisotopic_mass": "5765.5874",
                                "monoisotopic_mz": "824.6626",
                                "intensity": "2624.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "40",
                                "monoisotopic_mass": "2906.5952",
                                "monoisotopic_mz": "727.6561",
                                "intensity": "2626.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2906.6012",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0060",
                                        "ppm": "-2.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "41",
                                "monoisotopic_mass": "3047.6893",
                                "monoisotopic_mz": "762.9296",
                                "intensity": "2211.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "42",
                                "monoisotopic_mass": "876.4840",
                                "monoisotopic_mz": "877.4913",
                                "intensity": "1515.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "43",
                                "monoisotopic_mass": "4134.1774",
                                "monoisotopic_mz": "827.8428",
                                "intensity": "1020.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "44",
                                "monoisotopic_mass": "3786.5935",
                                "monoisotopic_mz": "947.6557",
                                "intensity": "1100.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "45",
                                "monoisotopic_mass": "6779.8427",
                                "monoisotopic_mz": "969.5562",
                                "intensity": "1068.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "46",
                                "monoisotopic_mass": "2735.4001",
                                "monoisotopic_mz": "912.8073",
                                "intensity": "2267.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "47",
                                "monoisotopic_mass": "8890.4725",
                                "monoisotopic_mz": "809.2320",
                                "intensity": "2187.93",
                                "charge": "11"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "48",
                                "monoisotopic_mass": "992.5447",
                                "monoisotopic_mz": "993.5520",
                                "intensity": "1971.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "49",
                                "monoisotopic_mass": "1340.7580",
                                "monoisotopic_mz": "671.3863",
                                "intensity": "1143.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "50",
                                "monoisotopic_mass": "8696.3280",
                                "monoisotopic_mz": "870.6401",
                                "intensity": "1425.35",
                                "charge": "10"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "51",
                                "monoisotopic_mass": "1455.7809",
                                "monoisotopic_mz": "728.8977",
                                "intensity": "1521.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "52",
                                "monoisotopic_mass": "2905.5960",
                                "monoisotopic_mz": "969.5393",
                                "intensity": "3919.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "53",
                                "monoisotopic_mass": "7516.3608",
                                "monoisotopic_mz": "752.6434",
                                "intensity": "856.67",
                                "charge": "10"
                            },
                            {
                                "spec_id": "128",
                                "peak_id": "54",
                                "monoisotopic_mass": "1497.2458",
                                "monoisotopic_mz": "749.6302",
                                "intensity": "687.86",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "128",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "128",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "128",
                                        "peak_id": "40",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "128",
                                        "peak_id": "4",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "128",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "128",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "128",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "128",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "128",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "81",
                "p_value": "3.49e-07",
                "e_value": "3.49e-07",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "90",
                        "ms1_scans": "200",
                        "ids": "110",
                        "scans": "202",
                        "precursor_mono_mass": "9218.9536",
                        "precursor_charge": "14",
                        "precursor_mz": "659.5040",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "110",
                                "peak_id": "0",
                                "monoisotopic_mass": "2639.4873",
                                "monoisotopic_mz": "660.8791",
                                "intensity": "27785.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5815",
                                "monoisotopic_mz": "784.2709",
                                "intensity": "10746.75",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0028",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5720",
                                "monoisotopic_mz": "672.3747",
                                "intensity": "8564.54",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0067",
                                        "ppm": "-1.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "3",
                                "monoisotopic_mass": "1472.8123",
                                "monoisotopic_mz": "737.4135",
                                "intensity": "5303.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0024",
                                        "ppm": "1.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "4",
                                "monoisotopic_mass": "4566.5198",
                                "monoisotopic_mz": "762.0939",
                                "intensity": "4141.68",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "5",
                                "monoisotopic_mass": "4478.4699",
                                "monoisotopic_mz": "747.4189",
                                "intensity": "5048.71",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "6",
                                "monoisotopic_mass": "4798.6489",
                                "monoisotopic_mz": "800.7821",
                                "intensity": "4065.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0018",
                                        "ppm": "0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "7",
                                "monoisotopic_mass": "4363.4312",
                                "monoisotopic_mz": "728.2458",
                                "intensity": "4033.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "8",
                                "monoisotopic_mass": "2794.5201",
                                "monoisotopic_mz": "932.5140",
                                "intensity": "2884.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "9",
                                "monoisotopic_mass": "2680.4308",
                                "monoisotopic_mz": "894.4842",
                                "intensity": "3328.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "10",
                                "monoisotopic_mass": "2680.5068",
                                "monoisotopic_mz": "671.1340",
                                "intensity": "3484.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "11",
                                "monoisotopic_mass": "1567.5299",
                                "monoisotopic_mz": "784.7722",
                                "intensity": "2801.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "12",
                                "monoisotopic_mass": "3963.2642",
                                "monoisotopic_mz": "661.5513",
                                "intensity": "1774.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "13",
                                "monoisotopic_mass": "1975.0513",
                                "monoisotopic_mz": "659.3577",
                                "intensity": "2480.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "14",
                                "monoisotopic_mass": "4138.1630",
                                "monoisotopic_mz": "1035.5480",
                                "intensity": "2086.13",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0050",
                                        "ppm": "1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "15",
                                "monoisotopic_mass": "698.1252",
                                "monoisotopic_mz": "699.1325",
                                "intensity": "1037.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "16",
                                "monoisotopic_mass": "3225.7690",
                                "monoisotopic_mz": "807.4495",
                                "intensity": "1384.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "17",
                                "monoisotopic_mass": "668.6017",
                                "monoisotopic_mz": "669.6090",
                                "intensity": "888.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "18",
                                "monoisotopic_mass": "2793.5189",
                                "monoisotopic_mz": "699.3870",
                                "intensity": "931.56",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0018",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "19",
                                "monoisotopic_mass": "4682.5560",
                                "monoisotopic_mz": "781.4333",
                                "intensity": "3718.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "20",
                                "monoisotopic_mass": "4680.5997",
                                "monoisotopic_mz": "669.6644",
                                "intensity": "1307.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "21",
                                "monoisotopic_mass": "3950.1051",
                                "monoisotopic_mz": "659.3581",
                                "intensity": "3967.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "22",
                                "monoisotopic_mass": "4495.4855",
                                "monoisotopic_mz": "643.2195",
                                "intensity": "2568.24",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "23",
                                "monoisotopic_mass": "8570.7485",
                                "monoisotopic_mz": "660.2956",
                                "intensity": "2139.68",
                                "charge": "13"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "24",
                                "monoisotopic_mass": "1455.7833",
                                "monoisotopic_mz": "728.8989",
                                "intensity": "587.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "25",
                                "monoisotopic_mass": "742.5381",
                                "monoisotopic_mz": "743.5454",
                                "intensity": "1031.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "26",
                                "monoisotopic_mass": "5268.5031",
                                "monoisotopic_mz": "659.5702",
                                "intensity": "895.96",
                                "charge": "8"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "27",
                                "monoisotopic_mass": "1341.7164",
                                "monoisotopic_mz": "671.8655",
                                "intensity": "590.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "28",
                                "monoisotopic_mass": "2147.1099",
                                "monoisotopic_mz": "716.7106",
                                "intensity": "2614.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "29",
                                "monoisotopic_mass": "1321.7505",
                                "monoisotopic_mz": "661.8825",
                                "intensity": "830.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "30",
                                "monoisotopic_mass": "1034.2866",
                                "monoisotopic_mz": "1035.2938",
                                "intensity": "1302.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "31",
                                "monoisotopic_mass": "1372.1883",
                                "monoisotopic_mz": "687.1014",
                                "intensity": "1425.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "32",
                                "monoisotopic_mass": "1436.1416",
                                "monoisotopic_mz": "719.0781",
                                "intensity": "657.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "33",
                                "monoisotopic_mass": "783.4304",
                                "monoisotopic_mz": "784.4377",
                                "intensity": "1692.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "34",
                                "monoisotopic_mass": "1280.6521",
                                "monoisotopic_mz": "641.3333",
                                "intensity": "591.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "110",
                                "peak_id": "35",
                                "monoisotopic_mass": "9149.5774",
                                "monoisotopic_mz": "654.5485",
                                "intensity": "2034.23",
                                "charge": "14"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "110",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "110",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "110",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "110",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "110",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "110",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "110",
                                        "peak_id": "22",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "110",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "159",
                "p_value": "8.71e-07",
                "e_value": "8.71e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "123",
                        "ms1_scans": "342",
                        "ids": "219",
                        "scans": "344",
                        "precursor_mono_mass": "9218.9823",
                        "precursor_charge": "12",
                        "precursor_mz": "769.2558",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "219",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "44727.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "1",
                                "monoisotopic_mass": "4567.5240",
                                "monoisotopic_mz": "762.2613",
                                "intensity": "7925.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "2",
                                "monoisotopic_mass": "2456.3679",
                                "monoisotopic_mz": "819.7966",
                                "intensity": "8715.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "3",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "21131.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0006",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8100",
                                "monoisotopic_mz": "737.4123",
                                "intensity": "5884.59",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0000",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "5",
                                "monoisotopic_mass": "4682.5523",
                                "monoisotopic_mz": "781.4327",
                                "intensity": "7384.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "6",
                                "monoisotopic_mass": "4642.5558",
                                "monoisotopic_mz": "774.7666",
                                "intensity": "7503.29",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "7",
                                "monoisotopic_mass": "4138.1523",
                                "monoisotopic_mz": "1035.5454",
                                "intensity": "6879.64",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0057",
                                        "ppm": "-1.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "8",
                                "monoisotopic_mass": "4981.7578",
                                "monoisotopic_mz": "831.3002",
                                "intensity": "7911.84",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "9",
                                "monoisotopic_mass": "2793.5147",
                                "monoisotopic_mz": "932.1788",
                                "intensity": "5468.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "10",
                                "monoisotopic_mass": "3226.7656",
                                "monoisotopic_mz": "807.6987",
                                "intensity": "4593.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "11",
                                "monoisotopic_mass": "4495.4866",
                                "monoisotopic_mz": "750.2551",
                                "intensity": "4356.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "12",
                                "monoisotopic_mass": "4665.5883",
                                "monoisotopic_mz": "778.6053",
                                "intensity": "3423.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "13",
                                "monoisotopic_mass": "3046.6557",
                                "monoisotopic_mz": "1016.5592",
                                "intensity": "3284.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "14",
                                "monoisotopic_mass": "3078.9831",
                                "monoisotopic_mz": "770.7531",
                                "intensity": "3314.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "15",
                                "monoisotopic_mass": "727.8920",
                                "monoisotopic_mz": "728.8993",
                                "intensity": "1135.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "16",
                                "monoisotopic_mass": "2299.7299",
                                "monoisotopic_mz": "767.5839",
                                "intensity": "2730.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "17",
                                "monoisotopic_mass": "7303.0095",
                                "monoisotopic_mz": "913.8835",
                                "intensity": "1918.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "18",
                                "monoisotopic_mass": "6692.9325",
                                "monoisotopic_mz": "837.6238",
                                "intensity": "895.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "19",
                                "monoisotopic_mass": "3851.0675",
                                "monoisotopic_mz": "771.2208",
                                "intensity": "3162.72",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3851.0826",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0151",
                                        "ppm": "-3.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "20",
                                "monoisotopic_mass": "761.3587",
                                "monoisotopic_mz": "762.3660",
                                "intensity": "934.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "21",
                                "monoisotopic_mass": "5960.1706",
                                "monoisotopic_mz": "852.4602",
                                "intensity": "1108.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "22",
                                "monoisotopic_mass": "6396.1470",
                                "monoisotopic_mz": "914.7426",
                                "intensity": "1022.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "23",
                                "monoisotopic_mass": "8905.3586",
                                "monoisotopic_mz": "743.1205",
                                "intensity": "1166.98",
                                "charge": "12"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "24",
                                "monoisotopic_mass": "940.1917",
                                "monoisotopic_mz": "941.1990",
                                "intensity": "983.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "25",
                                "monoisotopic_mass": "5489.1191",
                                "monoisotopic_mz": "785.1671",
                                "intensity": "925.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "26",
                                "monoisotopic_mass": "4614.4682",
                                "monoisotopic_mz": "770.0853",
                                "intensity": "974.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "27",
                                "monoisotopic_mass": "1340.7539",
                                "monoisotopic_mz": "671.3842",
                                "intensity": "837.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "28",
                                "monoisotopic_mass": "8127.1564",
                                "monoisotopic_mz": "813.7229",
                                "intensity": "795.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "29",
                                "monoisotopic_mass": "9144.5917",
                                "monoisotopic_mz": "832.3338",
                                "intensity": "1179.94",
                                "charge": "11"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "30",
                                "monoisotopic_mass": "9201.9604",
                                "monoisotopic_mz": "767.8373",
                                "intensity": "976.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "31",
                                "monoisotopic_mass": "2546.7568",
                                "monoisotopic_mz": "849.9262",
                                "intensity": "936.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "32",
                                "monoisotopic_mass": "698.3773",
                                "monoisotopic_mz": "699.3846",
                                "intensity": "1072.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "33",
                                "monoisotopic_mass": "915.4799",
                                "monoisotopic_mz": "916.4872",
                                "intensity": "1169.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "34",
                                "monoisotopic_mass": "6049.1718",
                                "monoisotopic_mz": "757.1538",
                                "intensity": "2392.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "35",
                                "monoisotopic_mass": "2912.9697",
                                "monoisotopic_mz": "729.2497",
                                "intensity": "2050.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "36",
                                "monoisotopic_mass": "5806.7021",
                                "monoisotopic_mz": "830.5362",
                                "intensity": "923.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "37",
                                "monoisotopic_mass": "3998.7543",
                                "monoisotopic_mz": "667.4663",
                                "intensity": "780.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "38",
                                "monoisotopic_mass": "3855.6551",
                                "monoisotopic_mz": "964.9211",
                                "intensity": "929.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "39",
                                "monoisotopic_mass": "8611.0457",
                                "monoisotopic_mz": "1077.3880",
                                "intensity": "813.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "40",
                                "monoisotopic_mass": "1021.5533",
                                "monoisotopic_mz": "1022.5606",
                                "intensity": "705.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "41",
                                "monoisotopic_mass": "5406.6610",
                                "monoisotopic_mz": "902.1174",
                                "intensity": "987.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "42",
                                "monoisotopic_mass": "1441.8437",
                                "monoisotopic_mz": "721.9291",
                                "intensity": "642.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "43",
                                "monoisotopic_mass": "6412.4704",
                                "monoisotopic_mz": "917.0745",
                                "intensity": "2243.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "44",
                                "monoisotopic_mass": "4781.6204",
                                "monoisotopic_mz": "797.9440",
                                "intensity": "2797.07",
                                "charge": "6"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "45",
                                "monoisotopic_mass": "894.1458",
                                "monoisotopic_mz": "895.1531",
                                "intensity": "701.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "46",
                                "monoisotopic_mass": "2321.2555",
                                "monoisotopic_mz": "774.7591",
                                "intensity": "1886.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "47",
                                "monoisotopic_mass": "829.7556",
                                "monoisotopic_mz": "830.7629",
                                "intensity": "1022.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "48",
                                "monoisotopic_mass": "3110.6458",
                                "monoisotopic_mz": "778.6687",
                                "intensity": "2109.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "49",
                                "monoisotopic_mass": "3159.7923",
                                "monoisotopic_mz": "790.9554",
                                "intensity": "1616.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "219",
                                "peak_id": "50",
                                "monoisotopic_mass": "6111.5888",
                                "monoisotopic_mz": "874.0914",
                                "intensity": "2230.65",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "219",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "219",
                                        "peak_id": "19",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "219",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "219",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "219",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "219",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "219",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "219",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "220",
                "p_value": "1.15e-06",
                "e_value": "1.15e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "423",
                        "ms1_scans": "727",
                        "ids": "304",
                        "scans": "729",
                        "precursor_mono_mass": "9218.9752",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1592",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "304",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5800",
                                "monoisotopic_mz": "784.2706",
                                "intensity": "25781.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0013",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "1",
                                "monoisotopic_mass": "4797.6461",
                                "monoisotopic_mz": "800.6150",
                                "intensity": "12072.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "2",
                                "monoisotopic_mass": "4568.5285",
                                "monoisotopic_mz": "762.4287",
                                "intensity": "7844.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "3",
                                "monoisotopic_mass": "4495.4884",
                                "monoisotopic_mz": "750.2554",
                                "intensity": "8650.63",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "4",
                                "monoisotopic_mass": "4682.5534",
                                "monoisotopic_mz": "781.4328",
                                "intensity": "5394.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "5",
                                "monoisotopic_mass": "3226.7690",
                                "monoisotopic_mz": "807.6995",
                                "intensity": "4872.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8112",
                                "monoisotopic_mz": "737.4129",
                                "intensity": "4871.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0013",
                                        "ppm": "0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "7",
                                "monoisotopic_mass": "4642.5573",
                                "monoisotopic_mz": "774.7668",
                                "intensity": "5667.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0001",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "8",
                                "monoisotopic_mass": "4798.6443",
                                "monoisotopic_mz": "686.5279",
                                "intensity": "3791.77",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "9",
                                "monoisotopic_mass": "2696.4250",
                                "monoisotopic_mz": "899.8156",
                                "intensity": "2271.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "10",
                                "monoisotopic_mass": "2792.5019",
                                "monoisotopic_mz": "931.8412",
                                "intensity": "1889.51",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "2792.5176",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0157",
                                        "ppm": "-5.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "11",
                                "monoisotopic_mass": "1340.7552",
                                "monoisotopic_mz": "671.3849",
                                "intensity": "1750.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "12",
                                "monoisotopic_mass": "2181.7188",
                                "monoisotopic_mz": "728.2469",
                                "intensity": "3158.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "13",
                                "monoisotopic_mass": "2809.5109",
                                "monoisotopic_mz": "937.5109",
                                "intensity": "2070.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "14",
                                "monoisotopic_mass": "4154.1459",
                                "monoisotopic_mz": "1039.5437",
                                "intensity": "2220.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "15",
                                "monoisotopic_mass": "4137.1538",
                                "monoisotopic_mz": "1035.2957",
                                "intensity": "795.02",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "4137.1585",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0047",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "16",
                                "monoisotopic_mass": "974.4178",
                                "monoisotopic_mz": "975.4251",
                                "intensity": "1470.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "17",
                                "monoisotopic_mass": "2127.3092",
                                "monoisotopic_mz": "710.1103",
                                "intensity": "1564.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "18",
                                "monoisotopic_mass": "3275.1559",
                                "monoisotopic_mz": "819.7963",
                                "intensity": "1854.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "19",
                                "monoisotopic_mass": "5359.4205",
                                "monoisotopic_mz": "894.2440",
                                "intensity": "866.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "20",
                                "monoisotopic_mass": "1487.6336",
                                "monoisotopic_mz": "744.8241",
                                "intensity": "1533.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "21",
                                "monoisotopic_mass": "1434.9693",
                                "monoisotopic_mz": "718.4919",
                                "intensity": "596.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "22",
                                "monoisotopic_mass": "6746.3546",
                                "monoisotopic_mz": "750.6022",
                                "intensity": "707.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "23",
                                "monoisotopic_mass": "705.7663",
                                "monoisotopic_mz": "706.7736",
                                "intensity": "937.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "24",
                                "monoisotopic_mass": "1473.8129",
                                "monoisotopic_mz": "492.2782",
                                "intensity": "470.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "25",
                                "monoisotopic_mass": "6214.4195",
                                "monoisotopic_mz": "777.8097",
                                "intensity": "1050.38",
                                "charge": "8"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "26",
                                "monoisotopic_mass": "4478.4703",
                                "monoisotopic_mz": "747.4190",
                                "intensity": "2761.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "27",
                                "monoisotopic_mass": "6517.3663",
                                "monoisotopic_mz": "725.1591",
                                "intensity": "1120.51",
                                "charge": "9"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "28",
                                "monoisotopic_mass": "6553.7879",
                                "monoisotopic_mz": "820.2308",
                                "intensity": "1136.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "29",
                                "monoisotopic_mass": "1460.3753",
                                "monoisotopic_mz": "731.1949",
                                "intensity": "744.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "30",
                                "monoisotopic_mass": "2455.8731",
                                "monoisotopic_mz": "819.6317",
                                "intensity": "2419.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "31",
                                "monoisotopic_mass": "1385.4896",
                                "monoisotopic_mz": "693.7521",
                                "intensity": "525.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "32",
                                "monoisotopic_mass": "2107.0914",
                                "monoisotopic_mz": "703.3711",
                                "intensity": "1403.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "33",
                                "monoisotopic_mass": "3915.6663",
                                "monoisotopic_mz": "653.6183",
                                "intensity": "846.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "34",
                                "monoisotopic_mass": "2380.2844",
                                "monoisotopic_mz": "794.4354",
                                "intensity": "783.92",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-9.9945652131e-01",
                                        "theoretical_mass": "2380.2855",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "B00024",
                                        "ion_left_position": "24",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "35",
                                "monoisotopic_mass": "778.4287",
                                "monoisotopic_mz": "779.4359",
                                "intensity": "731.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "304",
                                "peak_id": "36",
                                "monoisotopic_mass": "663.3666",
                                "monoisotopic_mz": "664.3738",
                                "intensity": "1956.36",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.9952",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "24",
                                        "ion_display_position": "24",
                                        "spec_id": "304",
                                        "peak_id": "34",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "304",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "304",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "304",
                                        "peak_id": "8",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "304",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "304",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "304",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "304",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "24",
                            "anno": "-0.9995",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "34",
                "p_value": "8.81e-06",
                "e_value": "8.81e-06",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "69",
                        "ms1_scans": "110",
                        "ids": "42",
                        "scans": "113",
                        "precursor_mono_mass": "9219.9572",
                        "precursor_charge": "12",
                        "precursor_mz": "769.3370",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "42",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5804",
                                "monoisotopic_mz": "784.2707",
                                "intensity": "52709.37",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "1",
                                "monoisotopic_mass": "4798.6485",
                                "monoisotopic_mz": "800.7820",
                                "intensity": "21618.44",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0014",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "2",
                                "monoisotopic_mass": "4910.7327",
                                "monoisotopic_mz": "819.4627",
                                "intensity": "12623.60",
                                "charge": "6"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "3",
                                "monoisotopic_mass": "4981.7662",
                                "monoisotopic_mz": "831.3016",
                                "intensity": "6128.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "4",
                                "monoisotopic_mass": "4642.5588",
                                "monoisotopic_mz": "774.7671",
                                "intensity": "10585.39",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0015",
                                        "ppm": "0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8109",
                                "monoisotopic_mz": "737.4127",
                                "intensity": "5935.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0009",
                                        "ppm": "0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "6",
                                "monoisotopic_mass": "2794.5201",
                                "monoisotopic_mz": "932.5140",
                                "intensity": "6254.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "7",
                                "monoisotopic_mass": "4138.1587",
                                "monoisotopic_mz": "1035.5469",
                                "intensity": "9488.31",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0007",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "8",
                                "monoisotopic_mass": "2341.7801",
                                "monoisotopic_mz": "781.6007",
                                "intensity": "10196.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "9",
                                "monoisotopic_mass": "3226.7688",
                                "monoisotopic_mz": "807.6995",
                                "intensity": "5943.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "10",
                                "monoisotopic_mass": "9182.9321",
                                "monoisotopic_mz": "766.2516",
                                "intensity": "2446.75",
                                "charge": "12"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "11",
                                "monoisotopic_mass": "3851.0657",
                                "monoisotopic_mz": "771.2204",
                                "intensity": "3980.35",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3851.0826",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0170",
                                        "ppm": "-4.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "12",
                                "monoisotopic_mass": "6848.2777",
                                "monoisotopic_mz": "761.9270",
                                "intensity": "4058.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "13",
                                "monoisotopic_mass": "2284.2625",
                                "monoisotopic_mz": "762.4281",
                                "intensity": "6527.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "14",
                                "monoisotopic_mass": "4779.6308",
                                "monoisotopic_mz": "797.6124",
                                "intensity": "1589.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "15",
                                "monoisotopic_mass": "4495.4870",
                                "monoisotopic_mz": "750.2551",
                                "intensity": "3079.40",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "16",
                                "monoisotopic_mass": "1455.7829",
                                "monoisotopic_mz": "728.8987",
                                "intensity": "2185.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "17",
                                "monoisotopic_mass": "3067.3082",
                                "monoisotopic_mz": "767.8343",
                                "intensity": "1766.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "18",
                                "monoisotopic_mass": "7352.7005",
                                "monoisotopic_mz": "817.9740",
                                "intensity": "900.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "19",
                                "monoisotopic_mass": "5525.9487",
                                "monoisotopic_mz": "921.9987",
                                "intensity": "2199.89",
                                "charge": "6"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "20",
                                "monoisotopic_mass": "2608.3944",
                                "monoisotopic_mz": "870.4721",
                                "intensity": "1811.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "21",
                                "monoisotopic_mass": "1680.8827",
                                "monoisotopic_mz": "841.4486",
                                "intensity": "1707.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "22",
                                "monoisotopic_mass": "3398.8480",
                                "monoisotopic_mz": "850.7193",
                                "intensity": "1139.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "23",
                                "monoisotopic_mass": "5675.8802",
                                "monoisotopic_mz": "811.8473",
                                "intensity": "1037.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "24",
                                "monoisotopic_mass": "954.1841",
                                "monoisotopic_mz": "955.1914",
                                "intensity": "1526.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "25",
                                "monoisotopic_mass": "767.8296",
                                "monoisotopic_mz": "768.8369",
                                "intensity": "712.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "26",
                                "monoisotopic_mass": "5822.2955",
                                "monoisotopic_mz": "728.7942",
                                "intensity": "953.52",
                                "charge": "8"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "27",
                                "monoisotopic_mass": "6884.7056",
                                "monoisotopic_mz": "765.9746",
                                "intensity": "1335.91",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "28",
                                "monoisotopic_mass": "4883.2790",
                                "monoisotopic_mz": "977.6631",
                                "intensity": "2270.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "29",
                                "monoisotopic_mass": "2440.9894",
                                "monoisotopic_mz": "814.6704",
                                "intensity": "1017.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "30",
                                "monoisotopic_mass": "6899.2962",
                                "monoisotopic_mz": "767.5957",
                                "intensity": "1011.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "31",
                                "monoisotopic_mass": "3325.8374",
                                "monoisotopic_mz": "832.4666",
                                "intensity": "1672.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "32",
                                "monoisotopic_mass": "5107.4715",
                                "monoisotopic_mz": "852.2525",
                                "intensity": "1498.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "33",
                                "monoisotopic_mass": "992.8803",
                                "monoisotopic_mz": "993.8876",
                                "intensity": "1340.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "34",
                                "monoisotopic_mass": "3142.7855",
                                "monoisotopic_mz": "786.7036",
                                "intensity": "2326.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "35",
                                "monoisotopic_mass": "8812.5683",
                                "monoisotopic_mz": "980.1815",
                                "intensity": "2070.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "36",
                                "monoisotopic_mass": "4130.7004",
                                "monoisotopic_mz": "827.1473",
                                "intensity": "1052.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "37",
                                "monoisotopic_mass": "7588.0140",
                                "monoisotopic_mz": "844.1199",
                                "intensity": "1230.49",
                                "charge": "9"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "38",
                                "monoisotopic_mass": "2068.0755",
                                "monoisotopic_mz": "1035.0450",
                                "intensity": "1487.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "39",
                                "monoisotopic_mass": "6391.1568",
                                "monoisotopic_mz": "799.9019",
                                "intensity": "1989.17",
                                "charge": "8"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "40",
                                "monoisotopic_mass": "7691.7950",
                                "monoisotopic_mz": "770.1868",
                                "intensity": "2876.18",
                                "charge": "10"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "41",
                                "monoisotopic_mass": "865.9374",
                                "monoisotopic_mz": "866.9447",
                                "intensity": "2130.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "42",
                                "monoisotopic_mass": "4077.7086",
                                "monoisotopic_mz": "816.5490",
                                "intensity": "2597.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "43",
                                "monoisotopic_mass": "797.4321",
                                "monoisotopic_mz": "798.4394",
                                "intensity": "1302.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "44",
                                "monoisotopic_mass": "812.5371",
                                "monoisotopic_mz": "813.5443",
                                "intensity": "798.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "42",
                                "peak_id": "45",
                                "monoisotopic_mass": "919.8335",
                                "monoisotopic_mz": "920.8408",
                                "intensity": "772.22",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "42",
                                        "peak_id": "11",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "42",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "42",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "42",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "42",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "42",
                                        "peak_id": "15",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "42",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "158",
                "p_value": "1.72e-05",
                "e_value": "1.72e-05",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "123",
                        "ms1_scans": "342",
                        "ids": "218",
                        "scans": "343",
                        "precursor_mono_mass": "9219.9631",
                        "precursor_charge": "13",
                        "precursor_mz": "710.2352",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "218",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "32065.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "1",
                                "monoisotopic_mass": "4495.4866",
                                "monoisotopic_mz": "750.2551",
                                "intensity": "13475.72",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5259",
                                "monoisotopic_mz": "762.2616",
                                "intensity": "9442.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "3",
                                "monoisotopic_mass": "4682.5472",
                                "monoisotopic_mz": "781.4318",
                                "intensity": "7131.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "4",
                                "monoisotopic_mass": "1472.8095",
                                "monoisotopic_mz": "737.4120",
                                "intensity": "5320.73",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "5",
                                "monoisotopic_mass": "4698.5743",
                                "monoisotopic_mz": "672.2322",
                                "intensity": "14553.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "6",
                                "monoisotopic_mass": "4798.6372",
                                "monoisotopic_mz": "800.7801",
                                "intensity": "10904.76",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0100",
                                        "ppm": "-2.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "7",
                                "monoisotopic_mass": "2793.5139",
                                "monoisotopic_mz": "932.1786",
                                "intensity": "4108.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0032",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "8",
                                "monoisotopic_mass": "4642.5489",
                                "monoisotopic_mz": "774.7654",
                                "intensity": "4543.07",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0084",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "9",
                                "monoisotopic_mass": "4799.6595",
                                "monoisotopic_mz": "686.6729",
                                "intensity": "6361.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "10",
                                "monoisotopic_mass": "4641.5515",
                                "monoisotopic_mz": "664.0861",
                                "intensity": "4215.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "11",
                                "monoisotopic_mass": "1789.8922",
                                "monoisotopic_mz": "895.9534",
                                "intensity": "2888.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "12",
                                "monoisotopic_mass": "4664.5856",
                                "monoisotopic_mz": "778.4382",
                                "intensity": "3960.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "13",
                                "monoisotopic_mass": "4139.1607",
                                "monoisotopic_mz": "1035.7975",
                                "intensity": "4614.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "14",
                                "monoisotopic_mass": "2456.8679",
                                "monoisotopic_mz": "819.9633",
                                "intensity": "2739.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "15",
                                "monoisotopic_mass": "2239.2308",
                                "monoisotopic_mz": "747.4175",
                                "intensity": "2862.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "16",
                                "monoisotopic_mass": "2255.7485",
                                "monoisotopic_mz": "752.9235",
                                "intensity": "874.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "17",
                                "monoisotopic_mass": "7079.2280",
                                "monoisotopic_mz": "787.5882",
                                "intensity": "817.66",
                                "charge": "9"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "18",
                                "monoisotopic_mass": "974.4185",
                                "monoisotopic_mz": "975.4258",
                                "intensity": "1492.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "19",
                                "monoisotopic_mass": "807.4435",
                                "monoisotopic_mz": "808.4508",
                                "intensity": "1055.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "20",
                                "monoisotopic_mass": "4139.5585",
                                "monoisotopic_mz": "828.9190",
                                "intensity": "1215.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "21",
                                "monoisotopic_mass": "2401.8275",
                                "monoisotopic_mz": "801.6164",
                                "intensity": "758.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "22",
                                "monoisotopic_mass": "752.4190",
                                "monoisotopic_mz": "753.4263",
                                "intensity": "944.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "23",
                                "monoisotopic_mass": "2128.3102",
                                "monoisotopic_mz": "710.4440",
                                "intensity": "1683.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "24",
                                "monoisotopic_mass": "1034.7887",
                                "monoisotopic_mz": "1035.7960",
                                "intensity": "609.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "25",
                                "monoisotopic_mass": "5059.6703",
                                "monoisotopic_mz": "844.2857",
                                "intensity": "1113.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "26",
                                "monoisotopic_mass": "707.9252",
                                "monoisotopic_mz": "708.9325",
                                "intensity": "888.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "27",
                                "monoisotopic_mass": "1621.5614",
                                "monoisotopic_mz": "811.7880",
                                "intensity": "1955.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "28",
                                "monoisotopic_mass": "865.6083",
                                "monoisotopic_mz": "866.6156",
                                "intensity": "1062.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "29",
                                "monoisotopic_mass": "8191.0690",
                                "monoisotopic_mz": "683.5964",
                                "intensity": "754.74",
                                "charge": "12"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "30",
                                "monoisotopic_mass": "1454.8067",
                                "monoisotopic_mz": "728.4106",
                                "intensity": "456.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "31",
                                "monoisotopic_mass": "1402.9067",
                                "monoisotopic_mz": "702.4606",
                                "intensity": "628.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "32",
                                "monoisotopic_mass": "1340.7555",
                                "monoisotopic_mz": "671.3850",
                                "intensity": "2207.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "33",
                                "monoisotopic_mass": "657.2965",
                                "monoisotopic_mz": "658.3038",
                                "intensity": "959.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "34",
                                "monoisotopic_mass": "1493.8284",
                                "monoisotopic_mz": "747.9215",
                                "intensity": "310.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "35",
                                "monoisotopic_mass": "3631.0520",
                                "monoisotopic_mz": "727.2177",
                                "intensity": "1035.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "36",
                                "monoisotopic_mass": "2267.4598",
                                "monoisotopic_mz": "756.8272",
                                "intensity": "886.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "37",
                                "monoisotopic_mass": "3263.7788",
                                "monoisotopic_mz": "816.9520",
                                "intensity": "1543.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "38",
                                "monoisotopic_mass": "5623.4446",
                                "monoisotopic_mz": "703.9378",
                                "intensity": "2476.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "39",
                                "monoisotopic_mass": "1439.8247",
                                "monoisotopic_mz": "720.9196",
                                "intensity": "549.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "40",
                                "monoisotopic_mass": "6272.1642",
                                "monoisotopic_mz": "785.0278",
                                "intensity": "1300.49",
                                "charge": "8"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "41",
                                "monoisotopic_mass": "2182.1541",
                                "monoisotopic_mz": "728.3920",
                                "intensity": "1375.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "42",
                                "monoisotopic_mass": "1385.0736",
                                "monoisotopic_mz": "693.5441",
                                "intensity": "1079.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "43",
                                "monoisotopic_mass": "6720.5296",
                                "monoisotopic_mz": "747.7328",
                                "intensity": "1922.56",
                                "charge": "9"
                            },
                            {
                                "spec_id": "218",
                                "peak_id": "44",
                                "monoisotopic_mass": "837.7661",
                                "monoisotopic_mz": "838.7734",
                                "intensity": "1545.74",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "218",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "218",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "218",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "218",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "218",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "218",
                                        "peak_id": "4",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "124",
                "p_value": "1.77e-05",
                "e_value": "1.77e-05",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "110",
                        "ms1_scans": "278",
                        "ids": "169",
                        "scans": "281",
                        "precursor_mono_mass": "9217.9723",
                        "precursor_charge": "12",
                        "precursor_mz": "769.1716",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "169",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5782",
                                "monoisotopic_mz": "784.2703",
                                "intensity": "50826.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "1",
                                "monoisotopic_mass": "4911.7307",
                                "monoisotopic_mz": "819.6291",
                                "intensity": "15284.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6448",
                                "monoisotopic_mz": "800.7814",
                                "intensity": "24043.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "3",
                                "monoisotopic_mass": "2793.5161",
                                "monoisotopic_mz": "932.1793",
                                "intensity": "7812.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "4",
                                "monoisotopic_mass": "4642.5551",
                                "monoisotopic_mz": "774.7665",
                                "intensity": "12696.06",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "5",
                                "monoisotopic_mass": "4567.5185",
                                "monoisotopic_mz": "762.2604",
                                "intensity": "8881.52",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5534",
                                "monoisotopic_mz": "781.4328",
                                "intensity": "11199.18",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "7",
                                "monoisotopic_mass": "4780.6170",
                                "monoisotopic_mz": "797.7768",
                                "intensity": "7319.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "8",
                                "monoisotopic_mass": "4138.1543",
                                "monoisotopic_mz": "1035.5458",
                                "intensity": "6869.90",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0037",
                                        "ppm": "-0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "9",
                                "monoisotopic_mass": "1472.8099",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "4568.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "10",
                                "monoisotopic_mass": "3852.0778",
                                "monoisotopic_mz": "771.4228",
                                "intensity": "4425.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "11",
                                "monoisotopic_mass": "4496.4897",
                                "monoisotopic_mz": "750.4222",
                                "intensity": "6900.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "12",
                                "monoisotopic_mass": "3226.7629",
                                "monoisotopic_mz": "807.6980",
                                "intensity": "4270.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "13",
                                "monoisotopic_mass": "3264.7787",
                                "monoisotopic_mz": "817.2020",
                                "intensity": "3661.60",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3264.7864",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0077",
                                        "ppm": "-2.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "14",
                                "monoisotopic_mass": "783.2635",
                                "monoisotopic_mz": "784.2708",
                                "intensity": "4529.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "15",
                                "monoisotopic_mass": "974.4181",
                                "monoisotopic_mz": "975.4254",
                                "intensity": "2815.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "16",
                                "monoisotopic_mass": "3045.6629",
                                "monoisotopic_mz": "1016.2283",
                                "intensity": "3626.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "17",
                                "monoisotopic_mass": "9087.9266",
                                "monoisotopic_mz": "827.1824",
                                "intensity": "1496.76",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-2.0073765213",
                                        "theoretical_mass": "9086.9468",
                                        "ion_position": "1",
                                        "ion_display_position": "89",
                                        "ion_sort_name": "Y00089",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0226",
                                        "ppm": "-2.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "18",
                                "monoisotopic_mass": "4982.7649",
                                "monoisotopic_mz": "831.4681",
                                "intensity": "7930.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "19",
                                "monoisotopic_mass": "4616.4769",
                                "monoisotopic_mz": "770.4201",
                                "intensity": "1196.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "20",
                                "monoisotopic_mass": "2906.5997",
                                "monoisotopic_mz": "727.6572",
                                "intensity": "1693.66",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2906.6012",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "21",
                                "monoisotopic_mass": "744.3286",
                                "monoisotopic_mz": "745.3359",
                                "intensity": "993.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "22",
                                "monoisotopic_mass": "8789.6129",
                                "monoisotopic_mz": "879.9686",
                                "intensity": "1190.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "23",
                                "monoisotopic_mass": "4893.6853",
                                "monoisotopic_mz": "816.6215",
                                "intensity": "3473.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "24",
                                "monoisotopic_mass": "7549.9505",
                                "monoisotopic_mz": "687.3664",
                                "intensity": "1996.10",
                                "charge": "11"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "25",
                                "monoisotopic_mass": "7230.1932",
                                "monoisotopic_mz": "804.3621",
                                "intensity": "1327.07",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "26",
                                "monoisotopic_mass": "830.4620",
                                "monoisotopic_mz": "831.4692",
                                "intensity": "913.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "27",
                                "monoisotopic_mass": "1819.0715",
                                "monoisotopic_mz": "910.5431",
                                "intensity": "2786.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "28",
                                "monoisotopic_mass": "860.4389",
                                "monoisotopic_mz": "861.4462",
                                "intensity": "1000.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "29",
                                "monoisotopic_mass": "943.4786",
                                "monoisotopic_mz": "944.4858",
                                "intensity": "1165.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "30",
                                "monoisotopic_mass": "9197.5908",
                                "monoisotopic_mz": "767.4732",
                                "intensity": "1226.72",
                                "charge": "12"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "31",
                                "monoisotopic_mass": "2560.2527",
                                "monoisotopic_mz": "854.4249",
                                "intensity": "1090.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "32",
                                "monoisotopic_mass": "7346.6911",
                                "monoisotopic_mz": "919.3437",
                                "intensity": "1362.52",
                                "charge": "8"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "33",
                                "monoisotopic_mass": "5200.5977",
                                "monoisotopic_mz": "743.9498",
                                "intensity": "922.99",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "34",
                                "monoisotopic_mass": "6178.3304",
                                "monoisotopic_mz": "687.4884",
                                "intensity": "2446.59",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "35",
                                "monoisotopic_mass": "5489.9026",
                                "monoisotopic_mz": "687.2451",
                                "intensity": "924.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "36",
                                "monoisotopic_mass": "3619.7701",
                                "monoisotopic_mz": "905.9498",
                                "intensity": "1046.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "37",
                                "monoisotopic_mass": "6053.2453",
                                "monoisotopic_mz": "865.7566",
                                "intensity": "2792.56",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-2.0073765213",
                                        "theoretical_mass": "6054.2486",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "38",
                                "monoisotopic_mass": "3244.7684",
                                "monoisotopic_mz": "812.1994",
                                "intensity": "1715.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "39",
                                "monoisotopic_mass": "5834.9149",
                                "monoisotopic_mz": "834.5665",
                                "intensity": "1306.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "40",
                                "monoisotopic_mass": "925.4992",
                                "monoisotopic_mz": "926.5065",
                                "intensity": "1174.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "41",
                                "monoisotopic_mass": "1350.0555",
                                "monoisotopic_mz": "676.0350",
                                "intensity": "834.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "42",
                                "monoisotopic_mass": "7964.4827",
                                "monoisotopic_mz": "885.9498",
                                "intensity": "1865.66",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "43",
                                "monoisotopic_mass": "5525.5089",
                                "monoisotopic_mz": "790.3657",
                                "intensity": "968.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "44",
                                "monoisotopic_mass": "6470.5184",
                                "monoisotopic_mz": "719.9538",
                                "intensity": "1168.32",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "45",
                                "monoisotopic_mass": "2978.6315",
                                "monoisotopic_mz": "993.8844",
                                "intensity": "2670.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "46",
                                "monoisotopic_mass": "2680.4326",
                                "monoisotopic_mz": "894.4848",
                                "intensity": "3865.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "47",
                                "monoisotopic_mass": "1438.8132",
                                "monoisotopic_mz": "720.4139",
                                "intensity": "511.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "48",
                                "monoisotopic_mass": "3401.9704",
                                "monoisotopic_mz": "851.4999",
                                "intensity": "1625.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "49",
                                "monoisotopic_mass": "5450.6674",
                                "monoisotopic_mz": "779.6740",
                                "intensity": "1790.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "50",
                                "monoisotopic_mass": "1154.6155",
                                "monoisotopic_mz": "1155.6228",
                                "intensity": "1061.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "51",
                                "monoisotopic_mass": "2186.1577",
                                "monoisotopic_mz": "729.7265",
                                "intensity": "763.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "52",
                                "monoisotopic_mass": "5929.7746",
                                "monoisotopic_mz": "848.1179",
                                "intensity": "960.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "53",
                                "monoisotopic_mass": "5334.8974",
                                "monoisotopic_mz": "763.1355",
                                "intensity": "867.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "54",
                                "monoisotopic_mass": "6856.4697",
                                "monoisotopic_mz": "762.8372",
                                "intensity": "2716.95",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "55",
                                "monoisotopic_mass": "7549.8241",
                                "monoisotopic_mz": "839.8766",
                                "intensity": "2582.23",
                                "charge": "9"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "56",
                                "monoisotopic_mass": "9108.5489",
                                "monoisotopic_mz": "829.0572",
                                "intensity": "1942.32",
                                "charge": "11"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "57",
                                "monoisotopic_mass": "847.4983",
                                "monoisotopic_mz": "848.5056",
                                "intensity": "1159.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "58",
                                "monoisotopic_mass": "3816.0174",
                                "monoisotopic_mz": "955.0116",
                                "intensity": "1485.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "59",
                                "monoisotopic_mass": "1396.0165",
                                "monoisotopic_mz": "699.0155",
                                "intensity": "605.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "60",
                                "monoisotopic_mass": "6145.4467",
                                "monoisotopic_mz": "769.1881",
                                "intensity": "1427.36",
                                "charge": "8"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "61",
                                "monoisotopic_mass": "1455.7813",
                                "monoisotopic_mz": "728.8980",
                                "intensity": "1129.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "62",
                                "monoisotopic_mass": "2301.1269",
                                "monoisotopic_mz": "768.0496",
                                "intensity": "1445.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "63",
                                "monoisotopic_mass": "8554.9182",
                                "monoisotopic_mz": "778.7271",
                                "intensity": "8957.99",
                                "charge": "11"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "64",
                                "monoisotopic_mass": "2491.8803",
                                "monoisotopic_mz": "831.6340",
                                "intensity": "2999.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "65",
                                "monoisotopic_mass": "4135.1419",
                                "monoisotopic_mz": "828.0357",
                                "intensity": "2284.59",
                                "charge": "5"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "66",
                                "monoisotopic_mass": "1499.1277",
                                "monoisotopic_mz": "750.5711",
                                "intensity": "492.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "67",
                                "monoisotopic_mass": "889.4689",
                                "monoisotopic_mz": "890.4761",
                                "intensity": "1034.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "68",
                                "monoisotopic_mass": "802.6863",
                                "monoisotopic_mz": "803.6935",
                                "intensity": "781.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "69",
                                "monoisotopic_mass": "8063.1494",
                                "monoisotopic_mz": "807.3222",
                                "intensity": "2414.95",
                                "charge": "10"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "70",
                                "monoisotopic_mass": "761.4110",
                                "monoisotopic_mz": "762.4182",
                                "intensity": "950.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "71",
                                "monoisotopic_mass": "670.3686",
                                "monoisotopic_mz": "671.3758",
                                "intensity": "1240.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "169",
                                "peak_id": "72",
                                "monoisotopic_mass": "1094.5525",
                                "monoisotopic_mz": "1095.5598",
                                "intensity": "831.67",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9217.9873",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "89",
                                        "spec_id": "169",
                                        "peak_id": "17",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "169",
                                        "peak_id": "46",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "169",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "169",
                                        "peak_id": "20",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "169",
                                        "peak_id": "37",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "169",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "169",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "169",
                                        "peak_id": "18",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "169",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "169",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "169",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "169",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "169",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "41",
                            "right_position": "42",
                            "anno": "-2.0074",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "30",
                "p_value": "3.24e-05",
                "e_value": "3.24e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "68",
                        "ms1_scans": "106",
                        "ids": "38",
                        "scans": "108",
                        "precursor_mono_mass": "9218.9443",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1568",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "38",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5778",
                                "monoisotopic_mz": "784.2702",
                                "intensity": "38542.50",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5788",
                                "monoisotopic_mz": "672.3757",
                                "intensity": "10380.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0001",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "2",
                                "monoisotopic_mass": "4567.5291",
                                "monoisotopic_mz": "762.2621",
                                "intensity": "11363.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "3",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "10046.69",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0006",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "4",
                                "monoisotopic_mass": "4495.4882",
                                "monoisotopic_mz": "750.2553",
                                "intensity": "10777.09",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8095",
                                "monoisotopic_mz": "737.4120",
                                "intensity": "10692.18",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "6",
                                "monoisotopic_mass": "4682.5626",
                                "monoisotopic_mz": "781.4344",
                                "intensity": "8006.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "7",
                                "monoisotopic_mass": "2792.5154",
                                "monoisotopic_mz": "931.8457",
                                "intensity": "4930.10",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0004065213",
                                        "theoretical_mass": "2792.5167",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "8",
                                "monoisotopic_mass": "4982.7645",
                                "monoisotopic_mz": "831.4680",
                                "intensity": "6329.21",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4982.7683",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "9",
                                "monoisotopic_mass": "4641.5580",
                                "monoisotopic_mz": "774.6003",
                                "intensity": "5757.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "10",
                                "monoisotopic_mass": "4911.7351",
                                "monoisotopic_mz": "819.6298",
                                "intensity": "4761.10",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0039",
                                        "ppm": "0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "11",
                                "monoisotopic_mass": "2679.4302",
                                "monoisotopic_mz": "670.8648",
                                "intensity": "2989.28",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.0004065213",
                                        "theoretical_mass": "2679.4326",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "12",
                                "monoisotopic_mass": "4256.6353",
                                "monoisotopic_mz": "710.4465",
                                "intensity": "3564.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "13",
                                "monoisotopic_mass": "2332.7960",
                                "monoisotopic_mz": "778.6059",
                                "intensity": "3519.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "14",
                                "monoisotopic_mass": "1340.7556",
                                "monoisotopic_mz": "671.3851",
                                "intensity": "2771.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "15",
                                "monoisotopic_mass": "5669.0841",
                                "monoisotopic_mz": "709.6428",
                                "intensity": "3976.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "16",
                                "monoisotopic_mass": "3226.7700",
                                "monoisotopic_mz": "807.6998",
                                "intensity": "8597.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "17",
                                "monoisotopic_mass": "5060.8293",
                                "monoisotopic_mz": "723.9829",
                                "intensity": "1488.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "18",
                                "monoisotopic_mass": "4924.3840",
                                "monoisotopic_mz": "821.7379",
                                "intensity": "3678.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "19",
                                "monoisotopic_mass": "974.4188",
                                "monoisotopic_mz": "975.4260",
                                "intensity": "3208.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "20",
                                "monoisotopic_mass": "1472.8085",
                                "monoisotopic_mz": "491.9434",
                                "intensity": "1762.31",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "21",
                                "monoisotopic_mass": "1417.8752",
                                "monoisotopic_mz": "709.9449",
                                "intensity": "2152.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "22",
                                "monoisotopic_mass": "4089.0785",
                                "monoisotopic_mz": "818.8230",
                                "intensity": "1891.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "23",
                                "monoisotopic_mass": "4968.1169",
                                "monoisotopic_mz": "710.7383",
                                "intensity": "2839.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "24",
                                "monoisotopic_mass": "1493.1561",
                                "monoisotopic_mz": "747.5853",
                                "intensity": "1858.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "25",
                                "monoisotopic_mass": "4067.2699",
                                "monoisotopic_mz": "814.4613",
                                "intensity": "976.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "26",
                                "monoisotopic_mass": "720.3855",
                                "monoisotopic_mz": "721.3928",
                                "intensity": "994.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "27",
                                "monoisotopic_mass": "3126.7012",
                                "monoisotopic_mz": "782.6826",
                                "intensity": "1679.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "28",
                                "monoisotopic_mass": "603.2615",
                                "monoisotopic_mz": "604.2688",
                                "intensity": "1144.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "29",
                                "monoisotopic_mass": "5954.1725",
                                "monoisotopic_mz": "851.6034",
                                "intensity": "2189.45",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5955.2083",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0334",
                                        "ppm": "-5.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "30",
                                "monoisotopic_mass": "6820.4584",
                                "monoisotopic_mz": "853.5646",
                                "intensity": "1020.71",
                                "charge": "8"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "31",
                                "monoisotopic_mass": "685.9504",
                                "monoisotopic_mz": "686.9577",
                                "intensity": "1571.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "32",
                                "monoisotopic_mass": "781.4288",
                                "monoisotopic_mz": "782.4361",
                                "intensity": "1088.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "33",
                                "monoisotopic_mass": "1454.8121",
                                "monoisotopic_mz": "728.4133",
                                "intensity": "2029.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "34",
                                "monoisotopic_mass": "3325.8342",
                                "monoisotopic_mz": "832.4658",
                                "intensity": "1372.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "35",
                                "monoisotopic_mass": "761.6621",
                                "monoisotopic_mz": "762.6694",
                                "intensity": "983.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "36",
                                "monoisotopic_mass": "8185.1983",
                                "monoisotopic_mz": "745.1162",
                                "intensity": "1310.83",
                                "charge": "11"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "37",
                                "monoisotopic_mass": "7096.6768",
                                "monoisotopic_mz": "710.6750",
                                "intensity": "3298.85",
                                "charge": "10"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "38",
                                "monoisotopic_mass": "802.6887",
                                "monoisotopic_mz": "803.6960",
                                "intensity": "1625.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "39",
                                "monoisotopic_mass": "4153.1493",
                                "monoisotopic_mz": "1039.2946",
                                "intensity": "2516.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "40",
                                "monoisotopic_mass": "1396.7516",
                                "monoisotopic_mz": "699.3831",
                                "intensity": "654.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "41",
                                "monoisotopic_mass": "8677.4865",
                                "monoisotopic_mz": "789.8697",
                                "intensity": "1258.88",
                                "charge": "11"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "42",
                                "monoisotopic_mass": "873.3709",
                                "monoisotopic_mz": "874.3782",
                                "intensity": "1204.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "43",
                                "monoisotopic_mass": "5207.6939",
                                "monoisotopic_mz": "744.9635",
                                "intensity": "2359.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "44",
                                "monoisotopic_mass": "6658.0591",
                                "monoisotopic_mz": "833.2647",
                                "intensity": "967.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "45",
                                "monoisotopic_mass": "5834.0219",
                                "monoisotopic_mz": "834.4390",
                                "intensity": "908.00",
                                "charge": "7"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "46",
                                "monoisotopic_mass": "5983.3759",
                                "monoisotopic_mz": "748.9293",
                                "intensity": "1911.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "47",
                                "monoisotopic_mass": "7055.4450",
                                "monoisotopic_mz": "784.9456",
                                "intensity": "3111.76",
                                "charge": "9"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "48",
                                "monoisotopic_mass": "6105.2075",
                                "monoisotopic_mz": "764.1582",
                                "intensity": "2715.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "49",
                                "monoisotopic_mass": "6815.2865",
                                "monoisotopic_mz": "758.2613",
                                "intensity": "991.19",
                                "charge": "9"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "50",
                                "monoisotopic_mass": "935.3059",
                                "monoisotopic_mz": "936.3132",
                                "intensity": "1348.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "51",
                                "monoisotopic_mass": "3932.7008",
                                "monoisotopic_mz": "787.5474",
                                "intensity": "1731.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "52",
                                "monoisotopic_mass": "4511.4827",
                                "monoisotopic_mz": "752.9211",
                                "intensity": "1198.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "53",
                                "monoisotopic_mass": "2364.5970",
                                "monoisotopic_mz": "789.2063",
                                "intensity": "904.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "54",
                                "monoisotopic_mass": "850.4485",
                                "monoisotopic_mz": "851.4557",
                                "intensity": "1335.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "38",
                                "peak_id": "55",
                                "monoisotopic_mass": "1013.1026",
                                "monoisotopic_mz": "1014.1099",
                                "intensity": "1295.46",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9218.9943",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "38",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "38",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "spec_id": "38",
                                        "peak_id": "29",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "38",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "38",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "38",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "38",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "38",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "38",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "38",
                                            "peak_id": "20",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "38",
                                            "peak_id": "5",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "27",
                            "anno": "-1.0004",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "125",
                "p_value": "3.85e-05",
                "e_value": "3.85e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "111",
                        "ms1_scans": "282",
                        "ids": "170",
                        "scans": "283",
                        "precursor_mono_mass": "9218.9839",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1599",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "170",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5804",
                                "monoisotopic_mz": "784.2707",
                                "intensity": "30121.79",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5796",
                                "monoisotopic_mz": "672.3758",
                                "intensity": "16794.90",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0009",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "14239.08",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0007",
                                        "ppm": "0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "3",
                                "monoisotopic_mass": "4567.5280",
                                "monoisotopic_mz": "762.2619",
                                "intensity": "12499.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "4",
                                "monoisotopic_mass": "4797.6420",
                                "monoisotopic_mz": "686.3847",
                                "intensity": "6799.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "5",
                                "monoisotopic_mass": "2792.5154",
                                "monoisotopic_mz": "931.8457",
                                "intensity": "8004.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "6",
                                "monoisotopic_mass": "4665.5839",
                                "monoisotopic_mz": "778.6046",
                                "intensity": "4772.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "7",
                                "monoisotopic_mass": "1472.8103",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "6217.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0003",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "8",
                                "monoisotopic_mass": "2247.2434",
                                "monoisotopic_mz": "750.0884",
                                "intensity": "10004.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "9",
                                "monoisotopic_mass": "4923.3981",
                                "monoisotopic_mz": "821.5736",
                                "intensity": "10027.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "10",
                                "monoisotopic_mass": "4642.5701",
                                "monoisotopic_mz": "774.7690",
                                "intensity": "8378.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0129",
                                        "ppm": "2.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "11",
                                "monoisotopic_mass": "2069.0792",
                                "monoisotopic_mz": "1035.5469",
                                "intensity": "4067.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "12",
                                "monoisotopic_mass": "4780.6218",
                                "monoisotopic_mz": "797.7776",
                                "intensity": "4848.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "13",
                                "monoisotopic_mass": "4681.5558",
                                "monoisotopic_mz": "781.2666",
                                "intensity": "8283.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "14",
                                "monoisotopic_mass": "974.4194",
                                "monoisotopic_mz": "975.4267",
                                "intensity": "2252.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "15",
                                "monoisotopic_mass": "2810.5187",
                                "monoisotopic_mz": "937.8469",
                                "intensity": "2009.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "16",
                                "monoisotopic_mass": "1340.7559",
                                "monoisotopic_mz": "671.3853",
                                "intensity": "3233.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "17",
                                "monoisotopic_mass": "2792.5095",
                                "monoisotopic_mz": "699.1347",
                                "intensity": "2311.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "18",
                                "monoisotopic_mass": "2678.4257",
                                "monoisotopic_mz": "893.8158",
                                "intensity": "3932.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "19",
                                "monoisotopic_mass": "8174.0332",
                                "monoisotopic_mz": "744.1012",
                                "intensity": "2459.18",
                                "charge": "11"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "20",
                                "monoisotopic_mass": "3264.7882",
                                "monoisotopic_mz": "817.2043",
                                "intensity": "2226.38",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3264.7864",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0018",
                                        "ppm": "0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "21",
                                "monoisotopic_mass": "3046.6570",
                                "monoisotopic_mz": "1016.5596",
                                "intensity": "4302.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "22",
                                "monoisotopic_mass": "760.1890",
                                "monoisotopic_mz": "761.1963",
                                "intensity": "1112.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "23",
                                "monoisotopic_mass": "5204.5745",
                                "monoisotopic_mz": "744.5179",
                                "intensity": "949.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "24",
                                "monoisotopic_mass": "3803.8745",
                                "monoisotopic_mz": "761.7822",
                                "intensity": "935.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "25",
                                "monoisotopic_mass": "744.1041",
                                "monoisotopic_mz": "745.1114",
                                "intensity": "1069.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "26",
                                "monoisotopic_mass": "2114.0317",
                                "monoisotopic_mz": "705.6845",
                                "intensity": "1419.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "27",
                                "monoisotopic_mass": "781.8856",
                                "monoisotopic_mz": "782.8929",
                                "intensity": "1247.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "28",
                                "monoisotopic_mass": "1454.8098",
                                "monoisotopic_mz": "728.4122",
                                "intensity": "2278.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "29",
                                "monoisotopic_mass": "5465.8196",
                                "monoisotopic_mz": "781.8387",
                                "intensity": "934.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "30",
                                "monoisotopic_mass": "1499.1645",
                                "monoisotopic_mz": "750.5896",
                                "intensity": "3097.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "31",
                                "monoisotopic_mass": "3716.3802",
                                "monoisotopic_mz": "744.2833",
                                "intensity": "916.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "32",
                                "monoisotopic_mass": "5665.7287",
                                "monoisotopic_mz": "709.2234",
                                "intensity": "971.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "33",
                                "monoisotopic_mass": "728.3923",
                                "monoisotopic_mz": "729.3996",
                                "intensity": "1595.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "34",
                                "monoisotopic_mass": "8560.6366",
                                "monoisotopic_mz": "857.0709",
                                "intensity": "901.08",
                                "charge": "10",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8561.6297",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "ion_sort_name": "B00084",
                                        "ion_left_position": "84",
                                        "mass_error": "0.0093",
                                        "ppm": "1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "35",
                                "monoisotopic_mass": "1542.1762",
                                "monoisotopic_mz": "772.0954",
                                "intensity": "2017.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "36",
                                "monoisotopic_mass": "6245.6974",
                                "monoisotopic_mz": "781.7194",
                                "intensity": "1322.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "37",
                                "monoisotopic_mass": "809.2857",
                                "monoisotopic_mz": "810.2930",
                                "intensity": "1362.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "38",
                                "monoisotopic_mass": "6991.8221",
                                "monoisotopic_mz": "777.8764",
                                "intensity": "830.35",
                                "charge": "9"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "39",
                                "monoisotopic_mass": "8096.4552",
                                "monoisotopic_mz": "737.0487",
                                "intensity": "1613.83",
                                "charge": "11"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "40",
                                "monoisotopic_mass": "7181.9205",
                                "monoisotopic_mz": "798.9984",
                                "intensity": "849.72",
                                "charge": "9"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "41",
                                "monoisotopic_mass": "1371.7481",
                                "monoisotopic_mz": "686.8813",
                                "intensity": "574.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "42",
                                "monoisotopic_mass": "830.9636",
                                "monoisotopic_mz": "831.9709",
                                "intensity": "1673.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "43",
                                "monoisotopic_mass": "3450.9314",
                                "monoisotopic_mz": "691.1936",
                                "intensity": "1081.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "44",
                                "monoisotopic_mass": "8722.8629",
                                "monoisotopic_mz": "727.9125",
                                "intensity": "3019.23",
                                "charge": "12"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "45",
                                "monoisotopic_mass": "5663.1466",
                                "monoisotopic_mz": "810.0282",
                                "intensity": "963.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "46",
                                "monoisotopic_mass": "8125.6290",
                                "monoisotopic_mz": "739.7008",
                                "intensity": "2621.78",
                                "charge": "11"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "47",
                                "monoisotopic_mass": "992.5438",
                                "monoisotopic_mz": "993.5511",
                                "intensity": "741.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "48",
                                "monoisotopic_mass": "706.6808",
                                "monoisotopic_mz": "707.6880",
                                "intensity": "855.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "49",
                                "monoisotopic_mass": "7066.8271",
                                "monoisotopic_mz": "786.2103",
                                "intensity": "891.61",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7065.8480",
                                        "ion_position": "22",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0233",
                                        "ppm": "-3.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "50",
                                "monoisotopic_mass": "4058.7268",
                                "monoisotopic_mz": "812.7526",
                                "intensity": "1039.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "51",
                                "monoisotopic_mass": "2125.0890",
                                "monoisotopic_mz": "709.3703",
                                "intensity": "1277.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "52",
                                "monoisotopic_mass": "3889.0738",
                                "monoisotopic_mz": "778.8220",
                                "intensity": "906.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "53",
                                "monoisotopic_mass": "3764.1191",
                                "monoisotopic_mz": "753.8311",
                                "intensity": "1339.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "54",
                                "monoisotopic_mass": "936.5035",
                                "monoisotopic_mz": "937.5108",
                                "intensity": "557.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "55",
                                "monoisotopic_mass": "853.4378",
                                "monoisotopic_mz": "854.4451",
                                "intensity": "902.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "170",
                                "peak_id": "56",
                                "monoisotopic_mass": "2161.6964",
                                "monoisotopic_mz": "721.5728",
                                "intensity": "1334.94",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "22",
                                        "ion_display_position": "68",
                                        "spec_id": "170",
                                        "peak_id": "49",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "170",
                                        "peak_id": "20",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "170",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "170",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "170",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "170",
                                        "peak_id": "10",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "170",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "84",
                                        "ion_display_position": "84",
                                        "spec_id": "170",
                                        "peak_id": "34",
                                        "peak_charge": "10"
                                    }
                                }
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "167",
                "p_value": "7.25e-05",
                "e_value": "7.25e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "128",
                        "ms1_scans": "362",
                        "ids": "234",
                        "scans": "364",
                        "precursor_mono_mass": "9219.9773",
                        "precursor_charge": "13",
                        "precursor_mz": "710.2363",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "234",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5771",
                                "monoisotopic_mz": "784.2701",
                                "intensity": "24280.72",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "1",
                                "monoisotopic_mass": "4797.6451",
                                "monoisotopic_mz": "800.6148",
                                "intensity": "10464.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "2",
                                "monoisotopic_mass": "4699.5766",
                                "monoisotopic_mz": "672.3754",
                                "intensity": "12165.71",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "3",
                                "monoisotopic_mass": "1472.8099",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "4689.57",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5240",
                                "monoisotopic_mz": "762.2613",
                                "intensity": "9111.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "5",
                                "monoisotopic_mass": "4642.5595",
                                "monoisotopic_mz": "774.7672",
                                "intensity": "6909.37",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0023",
                                        "ppm": "0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "6",
                                "monoisotopic_mass": "4494.4814",
                                "monoisotopic_mz": "750.0875",
                                "intensity": "5975.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "7",
                                "monoisotopic_mass": "4363.4385",
                                "monoisotopic_mz": "728.2470",
                                "intensity": "4456.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "8",
                                "monoisotopic_mass": "2793.5154",
                                "monoisotopic_mz": "932.1791",
                                "intensity": "6226.03",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "9",
                                "monoisotopic_mass": "4981.7608",
                                "monoisotopic_mz": "831.3007",
                                "intensity": "3877.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "10",
                                "monoisotopic_mass": "4798.6473",
                                "monoisotopic_mz": "686.5283",
                                "intensity": "4809.30",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0002",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "11",
                                "monoisotopic_mass": "4666.5936",
                                "monoisotopic_mz": "778.7729",
                                "intensity": "4787.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "12",
                                "monoisotopic_mass": "2680.4291",
                                "monoisotopic_mz": "894.4836",
                                "intensity": "3000.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0040",
                                        "ppm": "-1.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "13",
                                "monoisotopic_mass": "2793.5023",
                                "monoisotopic_mz": "699.3829",
                                "intensity": "2245.23",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0148",
                                        "ppm": "-5.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "14",
                                "monoisotopic_mass": "4642.5576",
                                "monoisotopic_mz": "664.2298",
                                "intensity": "1265.18",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0004",
                                        "ppm": "0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "15",
                                "monoisotopic_mass": "798.3829",
                                "monoisotopic_mz": "799.3902",
                                "intensity": "1162.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "16",
                                "monoisotopic_mass": "4153.1488",
                                "monoisotopic_mz": "1039.2945",
                                "intensity": "1131.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "17",
                                "monoisotopic_mass": "708.9367",
                                "monoisotopic_mz": "709.9440",
                                "intensity": "1111.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "18",
                                "monoisotopic_mass": "3062.6555",
                                "monoisotopic_mz": "766.6712",
                                "intensity": "1654.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "19",
                                "monoisotopic_mass": "1418.8769",
                                "monoisotopic_mz": "710.4457",
                                "intensity": "2464.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "20",
                                "monoisotopic_mass": "5623.7833",
                                "monoisotopic_mz": "703.9802",
                                "intensity": "812.12",
                                "charge": "8"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "21",
                                "monoisotopic_mass": "669.3664",
                                "monoisotopic_mz": "670.3737",
                                "intensity": "2039.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "22",
                                "monoisotopic_mass": "4910.7268",
                                "monoisotopic_mz": "819.4617",
                                "intensity": "2676.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "23",
                                "monoisotopic_mass": "2182.8196",
                                "monoisotopic_mz": "728.6138",
                                "intensity": "828.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "24",
                                "monoisotopic_mass": "2906.5994",
                                "monoisotopic_mz": "727.6571",
                                "intensity": "2095.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2906.6012",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "25",
                                "monoisotopic_mass": "1493.4926",
                                "monoisotopic_mz": "747.7536",
                                "intensity": "699.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "26",
                                "monoisotopic_mass": "4139.1561",
                                "monoisotopic_mz": "1035.7963",
                                "intensity": "1813.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "27",
                                "monoisotopic_mass": "6064.1976",
                                "monoisotopic_mz": "674.8070",
                                "intensity": "1059.75",
                                "charge": "9"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "28",
                                "monoisotopic_mass": "2114.5669",
                                "monoisotopic_mz": "705.8629",
                                "intensity": "828.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "29",
                                "monoisotopic_mass": "693.2213",
                                "monoisotopic_mz": "694.2286",
                                "intensity": "1011.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "30",
                                "monoisotopic_mass": "6379.0874",
                                "monoisotopic_mz": "709.7948",
                                "intensity": "1804.75",
                                "charge": "9"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "31",
                                "monoisotopic_mass": "5289.1829",
                                "monoisotopic_mz": "756.6048",
                                "intensity": "798.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "32",
                                "monoisotopic_mass": "4783.6280",
                                "monoisotopic_mz": "798.2786",
                                "intensity": "1755.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "33",
                                "monoisotopic_mass": "974.4190",
                                "monoisotopic_mz": "975.4263",
                                "intensity": "1883.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "34",
                                "monoisotopic_mass": "1443.7511",
                                "monoisotopic_mz": "722.8828",
                                "intensity": "533.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "35",
                                "monoisotopic_mass": "4596.0865",
                                "monoisotopic_mz": "657.5911",
                                "intensity": "1152.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "36",
                                "monoisotopic_mass": "4252.4708",
                                "monoisotopic_mz": "709.7524",
                                "intensity": "958.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "37",
                                "monoisotopic_mass": "1152.8824",
                                "monoisotopic_mz": "577.4485",
                                "intensity": "1046.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "38",
                                "monoisotopic_mass": "2834.3543",
                                "monoisotopic_mz": "709.5959",
                                "intensity": "1095.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "39",
                                "monoisotopic_mass": "1397.9799",
                                "monoisotopic_mz": "699.9973",
                                "intensity": "1446.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "40",
                                "monoisotopic_mass": "831.9629",
                                "monoisotopic_mz": "832.9702",
                                "intensity": "391.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "41",
                                "monoisotopic_mass": "1377.6711",
                                "monoisotopic_mz": "689.8428",
                                "intensity": "530.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "42",
                                "monoisotopic_mass": "2223.1636",
                                "monoisotopic_mz": "742.0618",
                                "intensity": "695.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "43",
                                "monoisotopic_mass": "1274.4156",
                                "monoisotopic_mz": "638.2151",
                                "intensity": "623.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "44",
                                "monoisotopic_mass": "1456.7848",
                                "monoisotopic_mz": "729.3997",
                                "intensity": "1995.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "45",
                                "monoisotopic_mass": "2681.5109",
                                "monoisotopic_mz": "671.3850",
                                "intensity": "2166.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "46",
                                "monoisotopic_mass": "4365.4299",
                                "monoisotopic_mz": "624.6401",
                                "intensity": "763.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "47",
                                "monoisotopic_mass": "1015.8865",
                                "monoisotopic_mz": "1016.8938",
                                "intensity": "1116.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "48",
                                "monoisotopic_mass": "5622.2275",
                                "monoisotopic_mz": "804.1826",
                                "intensity": "808.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "49",
                                "monoisotopic_mass": "4553.4699",
                                "monoisotopic_mz": "759.9189",
                                "intensity": "887.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "50",
                                "monoisotopic_mass": "5396.1495",
                                "monoisotopic_mz": "771.8858",
                                "intensity": "750.58",
                                "charge": "7"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "51",
                                "monoisotopic_mass": "1308.1994",
                                "monoisotopic_mz": "655.1070",
                                "intensity": "522.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "52",
                                "monoisotopic_mass": "1087.9304",
                                "monoisotopic_mz": "1088.9376",
                                "intensity": "492.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "53",
                                "monoisotopic_mass": "3493.9680",
                                "monoisotopic_mz": "874.4993",
                                "intensity": "1427.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "54",
                                "monoisotopic_mass": "3520.8687",
                                "monoisotopic_mz": "705.1810",
                                "intensity": "714.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "55",
                                "monoisotopic_mass": "818.4588",
                                "monoisotopic_mz": "819.4661",
                                "intensity": "803.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "56",
                                "monoisotopic_mass": "1037.5260",
                                "monoisotopic_mz": "1038.5333",
                                "intensity": "692.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "57",
                                "monoisotopic_mass": "4170.2692",
                                "monoisotopic_mz": "696.0521",
                                "intensity": "1743.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "234",
                                "peak_id": "58",
                                "monoisotopic_mass": "747.4142",
                                "monoisotopic_mz": "748.4215",
                                "intensity": "1007.41",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "234",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "234",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "28",
                                            "ion_display_position": "28",
                                            "spec_id": "234",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "234",
                                        "peak_id": "24",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "234",
                                        "peak_id": "10",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "234",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "234",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "234",
                                            "peak_id": "14",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "46",
                                            "ion_display_position": "44",
                                            "spec_id": "234",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "234",
                                        "peak_id": "3",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "66",
                "p_value": "1.02e-04",
                "e_value": "1.02e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "83",
                        "ms1_scans": "170",
                        "ids": "87",
                        "scans": "172",
                        "precursor_mono_mass": "9218.9800",
                        "precursor_charge": "13",
                        "precursor_mz": "710.1596",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "87",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5778",
                                "monoisotopic_mz": "784.2702",
                                "intensity": "30599.01",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5783",
                                "monoisotopic_mz": "672.3756",
                                "intensity": "15868.97",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "2",
                                "monoisotopic_mass": "4924.3949",
                                "monoisotopic_mz": "821.7398",
                                "intensity": "11117.52",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "3",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "13106.31",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0006",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "4",
                                "monoisotopic_mass": "4642.5573",
                                "monoisotopic_mz": "774.7668",
                                "intensity": "6412.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0001",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "5",
                                "monoisotopic_mass": "4495.4856",
                                "monoisotopic_mz": "750.2549",
                                "intensity": "10207.23",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "6",
                                "monoisotopic_mass": "4567.5269",
                                "monoisotopic_mz": "762.2618",
                                "intensity": "10510.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "7",
                                "monoisotopic_mass": "2792.5116",
                                "monoisotopic_mz": "931.8445",
                                "intensity": "5626.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "8",
                                "monoisotopic_mass": "3227.7676",
                                "monoisotopic_mz": "807.9492",
                                "intensity": "4595.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "9",
                                "monoisotopic_mass": "4138.1577",
                                "monoisotopic_mz": "1035.5467",
                                "intensity": "5158.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "10",
                                "monoisotopic_mass": "1571.8771",
                                "monoisotopic_mz": "786.9458",
                                "intensity": "2061.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1571.8784",
                                        "ion_position": "75",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "75",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "11",
                                "monoisotopic_mass": "1472.8098",
                                "monoisotopic_mz": "737.4122",
                                "intensity": "6931.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "12",
                                "monoisotopic_mass": "1340.7553",
                                "monoisotopic_mz": "671.3849",
                                "intensity": "2444.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "13",
                                "monoisotopic_mass": "4923.3855",
                                "monoisotopic_mz": "704.3481",
                                "intensity": "3643.98",
                                "charge": "7"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "14",
                                "monoisotopic_mass": "974.4190",
                                "monoisotopic_mz": "975.4263",
                                "intensity": "2965.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "15",
                                "monoisotopic_mass": "4253.6174",
                                "monoisotopic_mz": "709.9435",
                                "intensity": "3864.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "16",
                                "monoisotopic_mass": "4478.4608",
                                "monoisotopic_mz": "747.4174",
                                "intensity": "5757.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "17",
                                "monoisotopic_mass": "1413.6858",
                                "monoisotopic_mz": "707.8502",
                                "intensity": "2105.30",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "18",
                                "monoisotopic_mass": "710.0369",
                                "monoisotopic_mz": "711.0442",
                                "intensity": "1645.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "19",
                                "monoisotopic_mass": "669.0796",
                                "monoisotopic_mz": "670.0869",
                                "intensity": "1208.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "20",
                                "monoisotopic_mass": "544.2122",
                                "monoisotopic_mz": "545.2195",
                                "intensity": "1109.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "21",
                                "monoisotopic_mass": "3128.7056",
                                "monoisotopic_mz": "783.1837",
                                "intensity": "1545.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "22",
                                "monoisotopic_mass": "2834.6768",
                                "monoisotopic_mz": "709.6765",
                                "intensity": "1126.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "23",
                                "monoisotopic_mass": "2340.2733",
                                "monoisotopic_mz": "781.0984",
                                "intensity": "4121.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "24",
                                "monoisotopic_mass": "3327.8384",
                                "monoisotopic_mz": "832.9669",
                                "intensity": "916.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "25",
                                "monoisotopic_mass": "7793.2960",
                                "monoisotopic_mz": "709.4887",
                                "intensity": "2679.58",
                                "charge": "11"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "26",
                                "monoisotopic_mass": "3786.1075",
                                "monoisotopic_mz": "758.2288",
                                "intensity": "929.24",
                                "charge": "5"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "27",
                                "monoisotopic_mass": "7739.3085",
                                "monoisotopic_mz": "774.9381",
                                "intensity": "1882.21",
                                "charge": "10"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "28",
                                "monoisotopic_mass": "9090.9204",
                                "monoisotopic_mz": "827.4546",
                                "intensity": "825.35",
                                "charge": "11"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "29",
                                "monoisotopic_mass": "5524.1033",
                                "monoisotopic_mz": "790.1649",
                                "intensity": "828.78",
                                "charge": "7"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "30",
                                "monoisotopic_mass": "8085.5930",
                                "monoisotopic_mz": "809.5666",
                                "intensity": "1041.18",
                                "charge": "10"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "31",
                                "monoisotopic_mass": "2253.2039",
                                "monoisotopic_mz": "752.0753",
                                "intensity": "2439.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "32",
                                "monoisotopic_mass": "830.9633",
                                "monoisotopic_mz": "831.9706",
                                "intensity": "1032.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "33",
                                "monoisotopic_mass": "2396.6498",
                                "monoisotopic_mz": "799.8905",
                                "intensity": "866.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "34",
                                "monoisotopic_mass": "8051.1272",
                                "monoisotopic_mz": "732.9279",
                                "intensity": "2124.94",
                                "charge": "11"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "35",
                                "monoisotopic_mass": "1452.7971",
                                "monoisotopic_mz": "727.4058",
                                "intensity": "715.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "36",
                                "monoisotopic_mass": "7063.0022",
                                "monoisotopic_mz": "707.3075",
                                "intensity": "966.21",
                                "charge": "10"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "37",
                                "monoisotopic_mass": "807.8794",
                                "monoisotopic_mz": "808.8867",
                                "intensity": "1031.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "38",
                                "monoisotopic_mass": "1488.7849",
                                "monoisotopic_mz": "745.3997",
                                "intensity": "1837.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "39",
                                "monoisotopic_mass": "1327.8790",
                                "monoisotopic_mz": "664.9468",
                                "intensity": "1085.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "40",
                                "monoisotopic_mass": "6100.2799",
                                "monoisotopic_mz": "763.5423",
                                "intensity": "1128.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "41",
                                "monoisotopic_mass": "1399.8609",
                                "monoisotopic_mz": "700.9377",
                                "intensity": "652.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "42",
                                "monoisotopic_mass": "778.2665",
                                "monoisotopic_mz": "779.2738",
                                "intensity": "1166.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "43",
                                "monoisotopic_mass": "864.1825",
                                "monoisotopic_mz": "865.1898",
                                "intensity": "1186.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "44",
                                "monoisotopic_mass": "2742.3614",
                                "monoisotopic_mz": "686.5976",
                                "intensity": "1881.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "45",
                                "monoisotopic_mass": "8730.6823",
                                "monoisotopic_mz": "728.5641",
                                "intensity": "3410.10",
                                "charge": "12"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "46",
                                "monoisotopic_mass": "893.8111",
                                "monoisotopic_mz": "894.8184",
                                "intensity": "1628.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "47",
                                "monoisotopic_mass": "6629.4952",
                                "monoisotopic_mz": "737.6179",
                                "intensity": "2004.18",
                                "charge": "9"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "48",
                                "monoisotopic_mass": "2218.9637",
                                "monoisotopic_mz": "740.6619",
                                "intensity": "2251.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "49",
                                "monoisotopic_mass": "1353.6743",
                                "monoisotopic_mz": "677.8444",
                                "intensity": "642.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "50",
                                "monoisotopic_mass": "2808.5087",
                                "monoisotopic_mz": "937.1769",
                                "intensity": "1605.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "51",
                                "monoisotopic_mass": "1434.4294",
                                "monoisotopic_mz": "718.2220",
                                "intensity": "644.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "52",
                                "monoisotopic_mass": "3946.5022",
                                "monoisotopic_mz": "790.3077",
                                "intensity": "860.70",
                                "charge": "5"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "53",
                                "monoisotopic_mass": "8303.3329",
                                "monoisotopic_mz": "755.8557",
                                "intensity": "2531.45",
                                "charge": "11"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "54",
                                "monoisotopic_mass": "6759.5324",
                                "monoisotopic_mz": "752.0664",
                                "intensity": "2657.26",
                                "charge": "9"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "55",
                                "monoisotopic_mass": "5592.7459",
                                "monoisotopic_mz": "799.9710",
                                "intensity": "2107.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "56",
                                "monoisotopic_mass": "4968.7142",
                                "monoisotopic_mz": "710.8236",
                                "intensity": "3151.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "57",
                                "monoisotopic_mass": "1021.5539",
                                "monoisotopic_mz": "1022.5612",
                                "intensity": "762.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "58",
                                "monoisotopic_mass": "8017.2974",
                                "monoisotopic_mz": "802.7370",
                                "intensity": "3292.84",
                                "charge": "10"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "59",
                                "monoisotopic_mass": "5190.6694",
                                "monoisotopic_mz": "866.1188",
                                "intensity": "1084.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "60",
                                "monoisotopic_mass": "2995.8647",
                                "monoisotopic_mz": "749.9735",
                                "intensity": "1852.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "61",
                                "monoisotopic_mass": "1243.6952",
                                "monoisotopic_mz": "622.8549",
                                "intensity": "587.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "62",
                                "monoisotopic_mass": "1789.8930",
                                "monoisotopic_mz": "895.9538",
                                "intensity": "2946.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "63",
                                "monoisotopic_mass": "879.8646",
                                "monoisotopic_mz": "880.8719",
                                "intensity": "730.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "64",
                                "monoisotopic_mass": "682.4291",
                                "monoisotopic_mz": "683.4364",
                                "intensity": "1165.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "65",
                                "monoisotopic_mass": "1312.7219",
                                "monoisotopic_mz": "657.3682",
                                "intensity": "568.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1312.7173",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0046",
                                        "ppm": "3.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "66",
                                "monoisotopic_mass": "990.5931",
                                "monoisotopic_mz": "496.3038",
                                "intensity": "926.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "67",
                                "monoisotopic_mass": "1641.4360",
                                "monoisotopic_mz": "821.7253",
                                "intensity": "2262.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "68",
                                "monoisotopic_mass": "4199.6785",
                                "monoisotopic_mz": "700.9537",
                                "intensity": "1746.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "87",
                                "peak_id": "69",
                                "monoisotopic_mass": "1284.3056",
                                "monoisotopic_mz": "643.1601",
                                "intensity": "755.31",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "87",
                                        "peak_id": "65",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "87",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "87",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "87",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "87",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "87",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "87",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "75",
                                        "ion_display_position": "15",
                                        "spec_id": "87",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "87",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "35",
                "p_value": "1.46e-04",
                "e_value": "1.46e-04",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "69",
                        "ms1_scans": "110",
                        "ids": "44",
                        "scans": "115",
                        "precursor_mono_mass": "9218.9664",
                        "precursor_charge": "14",
                        "precursor_mz": "659.5049",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "44",
                                "peak_id": "0",
                                "monoisotopic_mass": "4567.5244",
                                "monoisotopic_mz": "762.2613",
                                "intensity": "7430.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "1",
                                "monoisotopic_mass": "2639.4892",
                                "monoisotopic_mz": "660.8796",
                                "intensity": "16499.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "2",
                                "monoisotopic_mass": "4698.5740",
                                "monoisotopic_mz": "784.1029",
                                "intensity": "11693.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "3",
                                "monoisotopic_mass": "4700.5803",
                                "monoisotopic_mz": "672.5187",
                                "intensity": "7409.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "4",
                                "monoisotopic_mass": "2793.5156",
                                "monoisotopic_mz": "932.1791",
                                "intensity": "4948.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "5",
                                "monoisotopic_mass": "1472.8102",
                                "monoisotopic_mz": "737.4124",
                                "intensity": "6074.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0002",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "6",
                                "monoisotopic_mass": "4642.5639",
                                "monoisotopic_mz": "774.7679",
                                "intensity": "4613.37",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0067",
                                        "ppm": "1.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "7",
                                "monoisotopic_mass": "4495.4914",
                                "monoisotopic_mz": "750.2558",
                                "intensity": "7212.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0026",
                                        "ppm": "0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "8",
                                "monoisotopic_mass": "2399.8218",
                                "monoisotopic_mz": "800.9479",
                                "intensity": "3525.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "9",
                                "monoisotopic_mass": "4683.5740",
                                "monoisotopic_mz": "781.6029",
                                "intensity": "4501.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "10",
                                "monoisotopic_mass": "2680.4270",
                                "monoisotopic_mz": "671.1140",
                                "intensity": "2796.44",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0060",
                                        "ppm": "-2.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "11",
                                "monoisotopic_mass": "749.5824",
                                "monoisotopic_mz": "750.5897",
                                "intensity": "3732.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "12",
                                "monoisotopic_mass": "4549.5137",
                                "monoisotopic_mz": "759.2596",
                                "intensity": "1004.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "13",
                                "monoisotopic_mass": "4494.4879",
                                "monoisotopic_mz": "643.0770",
                                "intensity": "1929.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "14",
                                "monoisotopic_mass": "3824.1505",
                                "monoisotopic_mz": "638.3657",
                                "intensity": "867.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "15",
                                "monoisotopic_mass": "3300.0381",
                                "monoisotopic_mz": "661.0149",
                                "intensity": "3068.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "16",
                                "monoisotopic_mass": "797.2699",
                                "monoisotopic_mz": "798.2772",
                                "intensity": "1083.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "17",
                                "monoisotopic_mass": "2179.7101",
                                "monoisotopic_mz": "727.5773",
                                "intensity": "2651.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "18",
                                "monoisotopic_mass": "5893.2152",
                                "monoisotopic_mz": "655.8090",
                                "intensity": "883.02",
                                "charge": "9"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "19",
                                "monoisotopic_mass": "2680.4268",
                                "monoisotopic_mz": "894.4829",
                                "intensity": "1142.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0062",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "20",
                                "monoisotopic_mass": "4477.4541",
                                "monoisotopic_mz": "747.2496",
                                "intensity": "3898.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "21",
                                "monoisotopic_mass": "974.4186",
                                "monoisotopic_mz": "975.4259",
                                "intensity": "1048.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "22",
                                "monoisotopic_mass": "698.6293",
                                "monoisotopic_mz": "699.6366",
                                "intensity": "1635.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "23",
                                "monoisotopic_mass": "1310.7387",
                                "monoisotopic_mz": "656.3766",
                                "intensity": "465.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "24",
                                "monoisotopic_mass": "3903.7328",
                                "monoisotopic_mz": "781.7538",
                                "intensity": "632.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "25",
                                "monoisotopic_mass": "670.3781",
                                "monoisotopic_mz": "671.3854",
                                "intensity": "1407.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "26",
                                "monoisotopic_mass": "1974.0532",
                                "monoisotopic_mz": "659.0250",
                                "intensity": "1304.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "27",
                                "monoisotopic_mass": "3259.7377",
                                "monoisotopic_mz": "652.9548",
                                "intensity": "891.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "28",
                                "monoisotopic_mass": "1454.2176",
                                "monoisotopic_mz": "728.1161",
                                "intensity": "1365.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "29",
                                "monoisotopic_mass": "5484.6859",
                                "monoisotopic_mz": "784.5338",
                                "intensity": "1105.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "30",
                                "monoisotopic_mass": "9140.9906",
                                "monoisotopic_mz": "653.9352",
                                "intensity": "765.59",
                                "charge": "14"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "31",
                                "monoisotopic_mass": "2610.6278",
                                "monoisotopic_mz": "653.6642",
                                "intensity": "1639.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "32",
                                "monoisotopic_mass": "1392.7549",
                                "monoisotopic_mz": "697.3847",
                                "intensity": "465.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "33",
                                "monoisotopic_mass": "4626.5373",
                                "monoisotopic_mz": "661.9412",
                                "intensity": "681.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "34",
                                "monoisotopic_mass": "893.1404",
                                "monoisotopic_mz": "894.1477",
                                "intensity": "447.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "35",
                                "monoisotopic_mass": "774.0986",
                                "monoisotopic_mz": "775.1059",
                                "intensity": "447.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "36",
                                "monoisotopic_mass": "727.4055",
                                "monoisotopic_mz": "728.4128",
                                "intensity": "616.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "37",
                                "monoisotopic_mass": "1379.3789",
                                "monoisotopic_mz": "690.6967",
                                "intensity": "555.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "44",
                                "peak_id": "38",
                                "monoisotopic_mass": "5966.1476",
                                "monoisotopic_mz": "663.9126",
                                "intensity": "2518.68",
                                "charge": "9"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "44",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "27",
                                            "ion_display_position": "27",
                                            "spec_id": "44",
                                            "peak_id": "10",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "44",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "44",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "44",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "44",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "53",
                "p_value": "1.74e-04",
                "e_value": "1.74e-04",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "78",
                        "ms1_scans": "144",
                        "ids": "69",
                        "scans": "149",
                        "precursor_mono_mass": "9219.9550",
                        "precursor_charge": "12",
                        "precursor_mz": "769.3369",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "69",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5804",
                                "monoisotopic_mz": "784.2707",
                                "intensity": "44568.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0017",
                                        "ppm": "0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "1",
                                "monoisotopic_mass": "4797.6443",
                                "monoisotopic_mz": "800.6147",
                                "intensity": "31437.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "2",
                                "monoisotopic_mass": "4682.5530",
                                "monoisotopic_mz": "781.4328",
                                "intensity": "10471.01",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "3",
                                "monoisotopic_mass": "2793.5165",
                                "monoisotopic_mz": "932.1794",
                                "intensity": "7157.67",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "4",
                                "monoisotopic_mass": "4981.7714",
                                "monoisotopic_mz": "831.3025",
                                "intensity": "9076.85",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "5",
                                "monoisotopic_mass": "4138.1597",
                                "monoisotopic_mz": "1035.5472",
                                "intensity": "6607.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4138.1580",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0017",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "6",
                                "monoisotopic_mass": "4495.4885",
                                "monoisotopic_mz": "750.2554",
                                "intensity": "7137.13",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "7",
                                "monoisotopic_mass": "4911.7241",
                                "monoisotopic_mz": "819.6280",
                                "intensity": "11353.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4911.7312",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0071",
                                        "ppm": "-1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "8",
                                "monoisotopic_mass": "4567.5284",
                                "monoisotopic_mz": "762.2620",
                                "intensity": "9277.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "9",
                                "monoisotopic_mass": "4642.5654",
                                "monoisotopic_mz": "774.7682",
                                "intensity": "7670.86",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4642.5572",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0081",
                                        "ppm": "1.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "10",
                                "monoisotopic_mass": "1472.8095",
                                "monoisotopic_mz": "737.4120",
                                "intensity": "7566.02",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "11",
                                "monoisotopic_mass": "6055.2512",
                                "monoisotopic_mz": "866.0432",
                                "intensity": "7407.59",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6056.2560",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "12",
                                "monoisotopic_mass": "3047.6630",
                                "monoisotopic_mz": "1016.8949",
                                "intensity": "1487.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "13",
                                "monoisotopic_mass": "3063.6597",
                                "monoisotopic_mz": "766.9222",
                                "intensity": "1774.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "14",
                                "monoisotopic_mass": "4666.5778",
                                "monoisotopic_mz": "778.7703",
                                "intensity": "5570.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "15",
                                "monoisotopic_mass": "4779.6121",
                                "monoisotopic_mz": "797.6093",
                                "intensity": "4470.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "16",
                                "monoisotopic_mass": "802.4395",
                                "monoisotopic_mz": "803.4468",
                                "intensity": "1224.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "17",
                                "monoisotopic_mass": "767.1640",
                                "monoisotopic_mz": "768.1713",
                                "intensity": "1494.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "18",
                                "monoisotopic_mass": "4716.6246",
                                "monoisotopic_mz": "787.1114",
                                "intensity": "3354.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "19",
                                "monoisotopic_mass": "2906.5999",
                                "monoisotopic_mz": "727.6573",
                                "intensity": "976.36",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2906.6012",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "20",
                                "monoisotopic_mass": "857.0530",
                                "monoisotopic_mz": "858.0602",
                                "intensity": "1175.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "21",
                                "monoisotopic_mass": "7614.0787",
                                "monoisotopic_mz": "952.7671",
                                "intensity": "1143.02",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "22",
                                "monoisotopic_mass": "8755.2313",
                                "monoisotopic_mz": "876.5304",
                                "intensity": "1294.33",
                                "charge": "10"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "23",
                                "monoisotopic_mass": "913.6200",
                                "monoisotopic_mz": "914.6273",
                                "intensity": "1969.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "24",
                                "monoisotopic_mass": "2679.4284",
                                "monoisotopic_mz": "894.1501",
                                "intensity": "2592.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "25",
                                "monoisotopic_mass": "3324.8368",
                                "monoisotopic_mz": "832.2165",
                                "intensity": "910.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "26",
                                "monoisotopic_mass": "3812.0889",
                                "monoisotopic_mz": "763.4251",
                                "intensity": "1086.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "27",
                                "monoisotopic_mass": "5258.8216",
                                "monoisotopic_mz": "877.4775",
                                "intensity": "856.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "28",
                                "monoisotopic_mass": "8802.5303",
                                "monoisotopic_mz": "801.2373",
                                "intensity": "2421.52",
                                "charge": "11"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "29",
                                "monoisotopic_mass": "1454.8099",
                                "monoisotopic_mz": "728.4122",
                                "intensity": "626.91",
                                "charge": "2"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "30",
                                "monoisotopic_mass": "4003.5385",
                                "monoisotopic_mz": "801.7150",
                                "intensity": "910.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "31",
                                "monoisotopic_mass": "5215.7743",
                                "monoisotopic_mz": "870.3030",
                                "intensity": "1004.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "32",
                                "monoisotopic_mass": "2679.4266",
                                "monoisotopic_mz": "670.8639",
                                "intensity": "2708.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "33",
                                "monoisotopic_mass": "2490.2995",
                                "monoisotopic_mz": "831.1071",
                                "intensity": "1076.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "34",
                                "monoisotopic_mass": "7382.8098",
                                "monoisotopic_mz": "1055.6944",
                                "intensity": "1172.29",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "35",
                                "monoisotopic_mass": "9089.7440",
                                "monoisotopic_mz": "909.9817",
                                "intensity": "1142.37",
                                "charge": "10"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "36",
                                "monoisotopic_mass": "834.2135",
                                "monoisotopic_mz": "835.2208",
                                "intensity": "789.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "37",
                                "monoisotopic_mass": "3227.7969",
                                "monoisotopic_mz": "807.9565",
                                "intensity": "4767.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "38",
                                "monoisotopic_mass": "8178.2169",
                                "monoisotopic_mz": "909.6980",
                                "intensity": "829.36",
                                "charge": "9"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "39",
                                "monoisotopic_mass": "730.6040",
                                "monoisotopic_mz": "731.6113",
                                "intensity": "1127.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "40",
                                "monoisotopic_mass": "3262.7856",
                                "monoisotopic_mz": "816.7037",
                                "intensity": "2229.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "41",
                                "monoisotopic_mass": "8949.8619",
                                "monoisotopic_mz": "895.9935",
                                "intensity": "834.75",
                                "charge": "10"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "42",
                                "monoisotopic_mass": "974.4192",
                                "monoisotopic_mz": "975.4265",
                                "intensity": "2103.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "43",
                                "monoisotopic_mass": "7618.9638",
                                "monoisotopic_mz": "847.5588",
                                "intensity": "2407.20",
                                "charge": "9"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "44",
                                "monoisotopic_mass": "6815.4432",
                                "monoisotopic_mz": "852.9377",
                                "intensity": "1111.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "45",
                                "monoisotopic_mass": "6094.0260",
                                "monoisotopic_mz": "762.7605",
                                "intensity": "1060.15",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "46",
                                "monoisotopic_mass": "6164.3691",
                                "monoisotopic_mz": "771.5534",
                                "intensity": "1142.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "47",
                                "monoisotopic_mass": "4947.4293",
                                "monoisotopic_mz": "825.5788",
                                "intensity": "944.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "48",
                                "monoisotopic_mass": "1441.7745",
                                "monoisotopic_mz": "721.8945",
                                "intensity": "556.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "49",
                                "monoisotopic_mass": "1201.5647",
                                "monoisotopic_mz": "601.7896",
                                "intensity": "2193.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "50",
                                "monoisotopic_mass": "884.4954",
                                "monoisotopic_mz": "885.5027",
                                "intensity": "1846.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "51",
                                "monoisotopic_mass": "9139.9499",
                                "monoisotopic_mz": "762.6698",
                                "intensity": "1080.06",
                                "charge": "12"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "52",
                                "monoisotopic_mass": "3082.6826",
                                "monoisotopic_mz": "771.6779",
                                "intensity": "1180.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "53",
                                "monoisotopic_mass": "5854.0714",
                                "monoisotopic_mz": "976.6858",
                                "intensity": "1490.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "54",
                                "monoisotopic_mass": "5443.3081",
                                "monoisotopic_mz": "778.6227",
                                "intensity": "640.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "55",
                                "monoisotopic_mass": "6750.3607",
                                "monoisotopic_mz": "844.8024",
                                "intensity": "922.65",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "56",
                                "monoisotopic_mass": "4418.8800",
                                "monoisotopic_mz": "884.7833",
                                "intensity": "1209.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "57",
                                "monoisotopic_mass": "7355.8988",
                                "monoisotopic_mz": "818.3294",
                                "intensity": "1179.29",
                                "charge": "9"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "58",
                                "monoisotopic_mass": "5853.1305",
                                "monoisotopic_mz": "837.1688",
                                "intensity": "1158.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "59",
                                "monoisotopic_mass": "996.6625",
                                "monoisotopic_mz": "997.6697",
                                "intensity": "1112.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "60",
                                "monoisotopic_mass": "4130.6990",
                                "monoisotopic_mz": "827.1471",
                                "intensity": "2398.91",
                                "charge": "5"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "61",
                                "monoisotopic_mass": "5955.1868",
                                "monoisotopic_mz": "851.7482",
                                "intensity": "2610.47",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5955.2083",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "ion_sort_name": "Y00057",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0215",
                                        "ppm": "-3.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "62",
                                "monoisotopic_mass": "5718.6676",
                                "monoisotopic_mz": "817.9598",
                                "intensity": "678.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "63",
                                "monoisotopic_mass": "7520.8963",
                                "monoisotopic_mz": "836.6624",
                                "intensity": "1068.39",
                                "charge": "9"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "64",
                                "monoisotopic_mass": "8633.5614",
                                "monoisotopic_mz": "864.3634",
                                "intensity": "914.57",
                                "charge": "10"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "65",
                                "monoisotopic_mass": "5489.2383",
                                "monoisotopic_mz": "785.1842",
                                "intensity": "930.07",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "66",
                                "monoisotopic_mass": "3673.4387",
                                "monoisotopic_mz": "919.3669",
                                "intensity": "1048.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "67",
                                "monoisotopic_mass": "2477.7994",
                                "monoisotopic_mz": "826.9404",
                                "intensity": "1044.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "68",
                                "monoisotopic_mass": "3164.5100",
                                "monoisotopic_mz": "792.1348",
                                "intensity": "2529.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "69",
                                "monoisotopic_mass": "5357.1410",
                                "monoisotopic_mz": "766.3131",
                                "intensity": "2852.20",
                                "charge": "7"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "70",
                                "monoisotopic_mass": "816.6976",
                                "monoisotopic_mz": "817.7048",
                                "intensity": "597.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "71",
                                "monoisotopic_mass": "6389.4679",
                                "monoisotopic_mz": "799.6908",
                                "intensity": "1163.29",
                                "charge": "8"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "72",
                                "monoisotopic_mass": "961.9939",
                                "monoisotopic_mz": "963.0012",
                                "intensity": "898.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "69",
                                "peak_id": "73",
                                "monoisotopic_mass": "4966.8633",
                                "monoisotopic_mz": "828.8178",
                                "intensity": "883.49",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "69",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "69",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "69",
                                        "peak_id": "11",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "33",
                                        "ion_display_position": "57",
                                        "spec_id": "69",
                                        "peak_id": "61",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "69",
                                        "peak_id": "5",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "69",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "69",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "69",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "69",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "69",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "108",
                "p_value": "3.43e-04",
                "e_value": "3.43e-04",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "102",
                        "ms1_scans": "248",
                        "ids": "148",
                        "scans": "252",
                        "precursor_mono_mass": "9219.9797",
                        "precursor_charge": "13",
                        "precursor_mz": "710.2365",
                        "feature_inte": "1.7749e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "148",
                                "peak_id": "0",
                                "monoisotopic_mass": "4699.5785",
                                "monoisotopic_mz": "784.2704",
                                "intensity": "39798.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "1",
                                "monoisotopic_mass": "4699.5813",
                                "monoisotopic_mz": "672.3760",
                                "intensity": "17087.77",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4699.5787",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0026",
                                        "ppm": "0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "2",
                                "monoisotopic_mass": "4798.6478",
                                "monoisotopic_mz": "800.7819",
                                "intensity": "16609.05",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4798.6471",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0007",
                                        "ppm": "0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "3",
                                "monoisotopic_mass": "2793.5143",
                                "monoisotopic_mz": "932.1787",
                                "intensity": "9236.06",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2793.5171",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0028",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "4",
                                "monoisotopic_mass": "4567.5255",
                                "monoisotopic_mz": "762.2615",
                                "intensity": "17132.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "5",
                                "monoisotopic_mass": "4681.5544",
                                "monoisotopic_mz": "781.2663",
                                "intensity": "10039.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "6",
                                "monoisotopic_mass": "1472.8115",
                                "monoisotopic_mz": "737.4130",
                                "intensity": "8106.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1472.8100",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0015",
                                        "ppm": "1.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "7",
                                "monoisotopic_mass": "4495.4863",
                                "monoisotopic_mz": "750.2550",
                                "intensity": "12054.18",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4495.4888",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "8",
                                "monoisotopic_mass": "4780.6258",
                                "monoisotopic_mz": "797.7782",
                                "intensity": "4839.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "9",
                                "monoisotopic_mass": "3227.7697",
                                "monoisotopic_mz": "807.9497",
                                "intensity": "5439.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "10",
                                "monoisotopic_mass": "4797.6484",
                                "monoisotopic_mz": "686.3856",
                                "intensity": "7012.94",
                                "charge": "7"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "11",
                                "monoisotopic_mass": "4666.5658",
                                "monoisotopic_mz": "778.7682",
                                "intensity": "6048.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "12",
                                "monoisotopic_mass": "774.0936",
                                "monoisotopic_mz": "775.1008",
                                "intensity": "2992.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "13",
                                "monoisotopic_mass": "4912.7341",
                                "monoisotopic_mz": "819.7963",
                                "intensity": "6739.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "14",
                                "monoisotopic_mass": "2680.4311",
                                "monoisotopic_mz": "671.1151",
                                "intensity": "2015.14",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2680.4330",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "15",
                                "monoisotopic_mass": "4641.5440",
                                "monoisotopic_mz": "774.5979",
                                "intensity": "4721.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "16",
                                "monoisotopic_mass": "4154.1524",
                                "monoisotopic_mz": "1039.5454",
                                "intensity": "2141.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "17",
                                "monoisotopic_mass": "974.4187",
                                "monoisotopic_mz": "975.4260",
                                "intensity": "3296.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "18",
                                "monoisotopic_mass": "4682.5603",
                                "monoisotopic_mz": "669.9445",
                                "intensity": "5041.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "19",
                                "monoisotopic_mass": "1493.1543",
                                "monoisotopic_mz": "747.5844",
                                "intensity": "2510.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "20",
                                "monoisotopic_mass": "4339.7436",
                                "monoisotopic_mz": "724.2979",
                                "intensity": "1077.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "21",
                                "monoisotopic_mass": "744.3304",
                                "monoisotopic_mz": "745.3377",
                                "intensity": "2089.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "22",
                                "monoisotopic_mass": "2834.7104",
                                "monoisotopic_mz": "709.6849",
                                "intensity": "3088.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "23",
                                "monoisotopic_mass": "5712.5400",
                                "monoisotopic_mz": "715.0748",
                                "intensity": "2836.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "24",
                                "monoisotopic_mass": "6796.5560",
                                "monoisotopic_mz": "756.1802",
                                "intensity": "3279.48",
                                "charge": "9"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "25",
                                "monoisotopic_mass": "1340.7564",
                                "monoisotopic_mz": "671.3855",
                                "intensity": "2988.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "26",
                                "monoisotopic_mass": "4140.1659",
                                "monoisotopic_mz": "1036.0488",
                                "intensity": "3015.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "27",
                                "monoisotopic_mass": "2679.4200",
                                "monoisotopic_mz": "894.1473",
                                "intensity": "4480.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "28",
                                "monoisotopic_mass": "5256.2379",
                                "monoisotopic_mz": "751.8984",
                                "intensity": "1003.25",
                                "charge": "7"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "29",
                                "monoisotopic_mass": "8540.2138",
                                "monoisotopic_mz": "712.6918",
                                "intensity": "2421.23",
                                "charge": "12"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "30",
                                "monoisotopic_mass": "1034.5383",
                                "monoisotopic_mz": "1035.5455",
                                "intensity": "1471.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "31",
                                "monoisotopic_mass": "8924.3858",
                                "monoisotopic_mz": "744.7061",
                                "intensity": "1090.99",
                                "charge": "12"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "32",
                                "monoisotopic_mass": "706.8786",
                                "monoisotopic_mz": "707.8859",
                                "intensity": "1230.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "33",
                                "monoisotopic_mass": "1415.1880",
                                "monoisotopic_mz": "708.6013",
                                "intensity": "3075.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "34",
                                "monoisotopic_mass": "4510.5068",
                                "monoisotopic_mz": "752.7584",
                                "intensity": "3549.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "35",
                                "monoisotopic_mass": "7996.4709",
                                "monoisotopic_mz": "727.9592",
                                "intensity": "4001.69",
                                "charge": "11"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "36",
                                "monoisotopic_mass": "719.9123",
                                "monoisotopic_mz": "720.9196",
                                "intensity": "1189.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "37",
                                "monoisotopic_mass": "4873.6751",
                                "monoisotopic_mz": "697.2466",
                                "intensity": "843.99",
                                "charge": "7"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "38",
                                "monoisotopic_mass": "2976.6380",
                                "monoisotopic_mz": "993.2199",
                                "intensity": "2460.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "39",
                                "monoisotopic_mass": "2572.3661",
                                "monoisotopic_mz": "858.4626",
                                "intensity": "1014.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "40",
                                "monoisotopic_mass": "666.5768",
                                "monoisotopic_mz": "667.5841",
                                "intensity": "972.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "41",
                                "monoisotopic_mass": "2128.3160",
                                "monoisotopic_mz": "710.4459",
                                "intensity": "879.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "42",
                                "monoisotopic_mass": "2377.8006",
                                "monoisotopic_mz": "793.6075",
                                "intensity": "1146.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "43",
                                "monoisotopic_mass": "2959.6365",
                                "monoisotopic_mz": "740.9164",
                                "intensity": "1936.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "44",
                                "monoisotopic_mass": "6561.4454",
                                "monoisotopic_mz": "730.0568",
                                "intensity": "1224.45",
                                "charge": "9"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "45",
                                "monoisotopic_mass": "2809.5049",
                                "monoisotopic_mz": "937.5089",
                                "intensity": "2020.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "46",
                                "monoisotopic_mass": "2153.7064",
                                "monoisotopic_mz": "718.9094",
                                "intensity": "1008.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "47",
                                "monoisotopic_mass": "8212.0518",
                                "monoisotopic_mz": "747.5574",
                                "intensity": "3134.34",
                                "charge": "11"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "48",
                                "monoisotopic_mass": "998.5446",
                                "monoisotopic_mz": "999.5519",
                                "intensity": "929.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "49",
                                "monoisotopic_mass": "1604.8763",
                                "monoisotopic_mz": "803.4454",
                                "intensity": "1609.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "50",
                                "monoisotopic_mass": "1455.7824",
                                "monoisotopic_mz": "728.8985",
                                "intensity": "2906.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "51",
                                "monoisotopic_mass": "4232.0310",
                                "monoisotopic_mz": "706.3458",
                                "intensity": "2250.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "52",
                                "monoisotopic_mass": "831.9601",
                                "monoisotopic_mz": "832.9673",
                                "intensity": "1681.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "53",
                                "monoisotopic_mass": "4733.4505",
                                "monoisotopic_mz": "789.9157",
                                "intensity": "1272.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "54",
                                "monoisotopic_mass": "6023.6706",
                                "monoisotopic_mz": "753.9661",
                                "intensity": "1275.74",
                                "charge": "8"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "55",
                                "monoisotopic_mass": "1391.7619",
                                "monoisotopic_mz": "696.8882",
                                "intensity": "540.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "56",
                                "monoisotopic_mass": "1286.5610",
                                "monoisotopic_mz": "644.2878",
                                "intensity": "1214.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "57",
                                "monoisotopic_mass": "5949.1240",
                                "monoisotopic_mz": "744.6478",
                                "intensity": "2117.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "58",
                                "monoisotopic_mass": "9211.6141",
                                "monoisotopic_mz": "709.5930",
                                "intensity": "1215.39",
                                "charge": "13"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "59",
                                "monoisotopic_mass": "1327.0158",
                                "monoisotopic_mz": "664.5152",
                                "intensity": "3466.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "60",
                                "monoisotopic_mass": "6104.0914",
                                "monoisotopic_mz": "764.0187",
                                "intensity": "2004.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "61",
                                "monoisotopic_mass": "2456.3648",
                                "monoisotopic_mz": "819.7955",
                                "intensity": "2160.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "62",
                                "monoisotopic_mass": "3000.0077",
                                "monoisotopic_mz": "751.0092",
                                "intensity": "1544.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "63",
                                "monoisotopic_mass": "3533.8171",
                                "monoisotopic_mz": "884.4615",
                                "intensity": "1744.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "64",
                                "monoisotopic_mass": "800.9645",
                                "monoisotopic_mz": "801.9718",
                                "intensity": "1180.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "65",
                                "monoisotopic_mass": "2187.4344",
                                "monoisotopic_mz": "730.1521",
                                "intensity": "1016.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "66",
                                "monoisotopic_mass": "5581.8848",
                                "monoisotopic_mz": "698.7429",
                                "intensity": "2596.96",
                                "charge": "8"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "67",
                                "monoisotopic_mass": "816.4389",
                                "monoisotopic_mz": "817.4461",
                                "intensity": "856.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "148",
                                "peak_id": "68",
                                "monoisotopic_mass": "864.3379",
                                "monoisotopic_mz": "865.3451",
                                "intensity": "928.62",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "7",
                    "proteoform_id": "9",
                    "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
                    "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
                    "proteoform_mass": "9219.9947",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "A"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "D"
                            },
                            {
                                "position": "15",
                                "acid": "I"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "A"
                            },
                            {
                                "position": "19",
                                "acid": "A"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "G"
                            },
                            {
                                "position": "22",
                                "acid": "R"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "I"
                            },
                            {
                                "position": "28",
                                "acid": "I"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "S"
                            },
                            {
                                "position": "31",
                                "acid": "V"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "D"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "K"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "T"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "K"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "R"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "148",
                                        "peak_id": "14",
 