prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "4",
        "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
        "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
        "proteoform_id": "4",
        "prsm_number": "39",
        "prsm": [
            {
                "prsm_id": "132",
                "p_value": "5.82e-13",
                "e_value": "5.82e-13",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "18",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "114",
                        "ms1_scans": "295",
                        "ids": "180",
                        "scans": "296",
                        "precursor_mono_mass": "9529.1669",
                        "precursor_charge": "13",
                        "precursor_mz": "734.0201",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "180",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6248",
                                "monoisotopic_mz": "797.4447",
                                "intensity": "19888.48",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0039",
                                        "ppm": "0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6906",
                                "monoisotopic_mz": "813.9557",
                                "intensity": "10826.78",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0013",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "2",
                                "monoisotopic_mass": "1429.8293",
                                "monoisotopic_mz": "715.9219",
                                "intensity": "19951.53",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "3",
                                "monoisotopic_mass": "5100.8195",
                                "monoisotopic_mz": "729.6958",
                                "intensity": "9562.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "4",
                                "monoisotopic_mass": "4990.7729",
                                "monoisotopic_mz": "832.8028",
                                "intensity": "7960.63",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "5",
                                "monoisotopic_mass": "4777.6191",
                                "monoisotopic_mz": "683.5243",
                                "intensity": "9859.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "6",
                                "monoisotopic_mass": "3348.7894",
                                "monoisotopic_mz": "838.2046",
                                "intensity": "11266.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "7",
                                "monoisotopic_mass": "4239.2456",
                                "monoisotopic_mz": "1060.8187",
                                "intensity": "5208.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "8",
                                "monoisotopic_mass": "4877.6878",
                                "monoisotopic_mz": "697.8198",
                                "intensity": "11752.21",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "9",
                                "monoisotopic_mass": "2994.6035",
                                "monoisotopic_mz": "749.6582",
                                "intensity": "5440.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "10",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "5593.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "11",
                                "monoisotopic_mass": "1261.7384",
                                "monoisotopic_mz": "631.8765",
                                "intensity": "4077.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "12",
                                "monoisotopic_mass": "1969.1361",
                                "monoisotopic_mz": "985.5753",
                                "intensity": "3048.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "0.0000",
                                        "ppm": "0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "13",
                                "monoisotopic_mass": "2199.1559",
                                "monoisotopic_mz": "734.0593",
                                "intensity": "6597.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "14",
                                "monoisotopic_mass": "3249.7214",
                                "monoisotopic_mz": "813.4376",
                                "intensity": "7588.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "15",
                                "monoisotopic_mass": "1856.0518",
                                "monoisotopic_mz": "929.0332",
                                "intensity": "4135.74",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "16",
                                "monoisotopic_mass": "2287.7687",
                                "monoisotopic_mz": "763.5969",
                                "intensity": "2895.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "17",
                                "monoisotopic_mass": "1461.2838",
                                "monoisotopic_mz": "731.6492",
                                "intensity": "3239.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "18",
                                "monoisotopic_mass": "831.7956",
                                "monoisotopic_mz": "832.8029",
                                "intensity": "1234.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "19",
                                "monoisotopic_mass": "1043.5116",
                                "monoisotopic_mz": "1044.5189",
                                "intensity": "1554.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "20",
                                "monoisotopic_mass": "1015.6017",
                                "monoisotopic_mz": "1016.6090",
                                "intensity": "1032.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "21",
                                "monoisotopic_mass": "9221.5348",
                                "monoisotopic_mz": "923.1608",
                                "intensity": "1238.55",
                                "charge": "10"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "22",
                                "monoisotopic_mass": "3194.7039",
                                "monoisotopic_mz": "799.6833",
                                "intensity": "3972.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "23",
                                "monoisotopic_mass": "807.9402",
                                "monoisotopic_mz": "808.9474",
                                "intensity": "1055.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "24",
                                "monoisotopic_mass": "3268.7805",
                                "monoisotopic_mz": "818.2024",
                                "intensity": "2539.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "25",
                                "monoisotopic_mass": "9421.8085",
                                "monoisotopic_mz": "857.5353",
                                "intensity": "2221.58",
                                "charge": "11"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "26",
                                "monoisotopic_mass": "4240.2420",
                                "monoisotopic_mz": "849.0557",
                                "intensity": "1057.85",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4240.2512",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0093",
                                        "ppm": "-2.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "27",
                                "monoisotopic_mass": "1444.8955",
                                "monoisotopic_mz": "723.4550",
                                "intensity": "714.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "28",
                                "monoisotopic_mass": "879.0491",
                                "monoisotopic_mz": "880.0563",
                                "intensity": "1549.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "29",
                                "monoisotopic_mass": "3634.7522",
                                "monoisotopic_mz": "727.9577",
                                "intensity": "1038.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "30",
                                "monoisotopic_mass": "670.1589",
                                "monoisotopic_mz": "671.1662",
                                "intensity": "1749.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "31",
                                "monoisotopic_mass": "1714.9779",
                                "monoisotopic_mz": "858.4962",
                                "intensity": "1683.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "32",
                                "monoisotopic_mass": "1332.7765",
                                "monoisotopic_mz": "667.3955",
                                "intensity": "3244.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "33",
                                "monoisotopic_mass": "4933.6236",
                                "monoisotopic_mz": "705.8106",
                                "intensity": "1048.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "34",
                                "monoisotopic_mass": "865.9703",
                                "monoisotopic_mz": "866.9775",
                                "intensity": "1614.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "35",
                                "monoisotopic_mass": "5117.8228",
                                "monoisotopic_mz": "853.9777",
                                "intensity": "2188.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0068",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "36",
                                "monoisotopic_mass": "1836.9880",
                                "monoisotopic_mz": "919.5013",
                                "intensity": "1378.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "37",
                                "monoisotopic_mass": "3380.8561",
                                "monoisotopic_mz": "1127.9593",
                                "intensity": "3432.49",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3380.8589",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "38",
                                "monoisotopic_mass": "1114.5497",
                                "monoisotopic_mz": "1115.5570",
                                "intensity": "793.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "39",
                                "monoisotopic_mass": "1283.7258",
                                "monoisotopic_mz": "1284.7330",
                                "intensity": "806.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "40",
                                "monoisotopic_mass": "1015.6011",
                                "monoisotopic_mz": "508.8078",
                                "intensity": "1512.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "41",
                                "monoisotopic_mass": "753.4198",
                                "monoisotopic_mz": "754.4271",
                                "intensity": "1055.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "42",
                                "monoisotopic_mass": "3234.7466",
                                "monoisotopic_mz": "809.6939",
                                "intensity": "2925.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "43",
                                "monoisotopic_mass": "3135.6731",
                                "monoisotopic_mz": "784.9255",
                                "intensity": "2574.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "44",
                                "monoisotopic_mass": "6721.5868",
                                "monoisotopic_mz": "841.2056",
                                "intensity": "2171.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "45",
                                "monoisotopic_mass": "4574.5296",
                                "monoisotopic_mz": "763.4289",
                                "intensity": "2717.92",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4574.5310",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "46",
                                "monoisotopic_mass": "1482.7470",
                                "monoisotopic_mz": "742.3808",
                                "intensity": "750.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "47",
                                "monoisotopic_mass": "3446.8564",
                                "monoisotopic_mz": "862.7214",
                                "intensity": "3596.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "48",
                                "monoisotopic_mass": "1366.3219",
                                "monoisotopic_mz": "684.1682",
                                "intensity": "313.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "49",
                                "monoisotopic_mass": "9384.1967",
                                "monoisotopic_mz": "854.1161",
                                "intensity": "2129.02",
                                "charge": "11",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "9383.0831",
                                        "ion_position": "89",
                                        "ion_display_position": "89",
                                        "ion_sort_name": "B00089",
                                        "ion_left_position": "89",
                                        "mass_error": "0.1112",
                                        "ppm": "11.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "50",
                                "monoisotopic_mass": "2229.4214",
                                "monoisotopic_mz": "744.1477",
                                "intensity": "3131.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "51",
                                "monoisotopic_mass": "1429.8278",
                                "monoisotopic_mz": "1430.8351",
                                "intensity": "1328.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "52",
                                "monoisotopic_mass": "3063.6314",
                                "monoisotopic_mz": "766.9151",
                                "intensity": "1922.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "53",
                                "monoisotopic_mass": "3519.8364",
                                "monoisotopic_mz": "880.9664",
                                "intensity": "1892.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "54",
                                "monoisotopic_mass": "3998.4264",
                                "monoisotopic_mz": "800.6925",
                                "intensity": "2159.64",
                                "charge": "5"
                            },
                            {
                                "spec_id": "180",
                                "peak_id": "55",
                                "monoisotopic_mass": "775.3102",
                                "monoisotopic_mz": "776.3175",
                                "intensity": "705.22",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "180",
                                        "peak_id": "37",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "180",
                                        "peak_id": "26",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "180",
                                        "peak_id": "35",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "180",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "180",
                                            "peak_id": "8",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "180",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "180",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "180",
                                        "peak_id": "45",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "180",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "180",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "180",
                                            "peak_id": "51",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "180",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "180",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "180",
                                        "peak_id": "32",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "180",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "180",
                                            "peak_id": "40",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "180",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "89",
                                        "ion_display_position": "89",
                                        "spec_id": "180",
                                        "peak_id": "49",
                                        "peak_charge": "11"
                                    }
                                }
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "195",
                "p_value": "2.29e-09",
                "e_value": "2.29e-09",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "162",
                        "ms1_scans": "440",
                        "ids": "277",
                        "scans": "441",
                        "precursor_mono_mass": "9528.1687",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9433",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "277",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "715.9217",
                                "intensity": "15181.89",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "1",
                                "monoisotopic_mass": "4778.6255",
                                "monoisotopic_mz": "797.4449",
                                "intensity": "20218.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0046",
                                        "ppm": "0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "2",
                                "monoisotopic_mass": "4876.6868",
                                "monoisotopic_mz": "813.7884",
                                "intensity": "9338.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "3",
                                "monoisotopic_mass": "4990.7711",
                                "monoisotopic_mz": "832.8025",
                                "intensity": "9426.51",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "4",
                                "monoisotopic_mass": "1429.8280",
                                "monoisotopic_mz": "477.6166",
                                "intensity": "5510.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "5",
                                "monoisotopic_mass": "4877.6869",
                                "monoisotopic_mz": "697.8197",
                                "intensity": "5364.61",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "6",
                                "monoisotopic_mass": "3348.7923",
                                "monoisotopic_mz": "838.2054",
                                "intensity": "5919.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "7",
                                "monoisotopic_mass": "1856.0526",
                                "monoisotopic_mz": "929.0336",
                                "intensity": "3299.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0006",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "8",
                                "monoisotopic_mass": "5100.8071",
                                "monoisotopic_mz": "729.6940",
                                "intensity": "7974.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "9",
                                "monoisotopic_mass": "4256.2313",
                                "monoisotopic_mz": "1065.0651",
                                "intensity": "5297.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "10",
                                "monoisotopic_mass": "1785.0114",
                                "monoisotopic_mz": "893.5130",
                                "intensity": "2617.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "11",
                                "monoisotopic_mass": "2993.6028",
                                "monoisotopic_mz": "749.4080",
                                "intensity": "3239.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "12",
                                "monoisotopic_mass": "3135.6806",
                                "monoisotopic_mz": "784.9274",
                                "intensity": "3372.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "13",
                                "monoisotopic_mass": "1261.7396",
                                "monoisotopic_mz": "631.8771",
                                "intensity": "3168.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0001",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "14",
                                "monoisotopic_mass": "3021.6382",
                                "monoisotopic_mz": "756.4168",
                                "intensity": "2133.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "15",
                                "monoisotopic_mass": "1332.7767",
                                "monoisotopic_mz": "667.3956",
                                "intensity": "2311.96",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "0.0001",
                                        "ppm": "0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "16",
                                "monoisotopic_mass": "1404.7408",
                                "monoisotopic_mz": "703.3777",
                                "intensity": "2001.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "17",
                                "monoisotopic_mass": "3063.6367",
                                "monoisotopic_mz": "766.9165",
                                "intensity": "2812.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "18",
                                "monoisotopic_mass": "2682.3909",
                                "monoisotopic_mz": "895.1376",
                                "intensity": "1548.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "19",
                                "monoisotopic_mass": "1488.2979",
                                "monoisotopic_mz": "745.1563",
                                "intensity": "1596.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "20",
                                "monoisotopic_mass": "3446.8593",
                                "monoisotopic_mz": "862.7221",
                                "intensity": "858.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "21",
                                "monoisotopic_mass": "869.4962",
                                "monoisotopic_mz": "870.5035",
                                "intensity": "995.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "22",
                                "monoisotopic_mass": "984.5674",
                                "monoisotopic_mz": "985.5746",
                                "intensity": "1163.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "23",
                                "monoisotopic_mass": "1454.7734",
                                "monoisotopic_mz": "728.3940",
                                "intensity": "691.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "24",
                                "monoisotopic_mass": "3231.7439",
                                "monoisotopic_mz": "808.9432",
                                "intensity": "1620.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "25",
                                "monoisotopic_mass": "3265.7628",
                                "monoisotopic_mz": "1089.5949",
                                "intensity": "1869.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "26",
                                "monoisotopic_mass": "1015.6025",
                                "monoisotopic_mz": "1016.6098",
                                "intensity": "1108.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "27",
                                "monoisotopic_mass": "9249.4895",
                                "monoisotopic_mz": "771.7981",
                                "intensity": "1953.09",
                                "charge": "12"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "28",
                                "monoisotopic_mass": "3193.7257",
                                "monoisotopic_mz": "799.4387",
                                "intensity": "1912.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "29",
                                "monoisotopic_mass": "2266.1890",
                                "monoisotopic_mz": "756.4036",
                                "intensity": "771.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "30",
                                "monoisotopic_mass": "1043.5129",
                                "monoisotopic_mz": "1044.5201",
                                "intensity": "894.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "31",
                                "monoisotopic_mass": "4574.5245",
                                "monoisotopic_mz": "763.4280",
                                "intensity": "2943.42",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4574.5310",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0065",
                                        "ppm": "-1.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "32",
                                "monoisotopic_mass": "1114.5492",
                                "monoisotopic_mz": "1115.5565",
                                "intensity": "544.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "33",
                                "monoisotopic_mass": "811.9372",
                                "monoisotopic_mz": "812.9445",
                                "intensity": "1476.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "34",
                                "monoisotopic_mass": "2905.5644",
                                "monoisotopic_mz": "727.3984",
                                "intensity": "907.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "35",
                                "monoisotopic_mass": "1587.8688",
                                "monoisotopic_mz": "794.9417",
                                "intensity": "2299.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "36",
                                "monoisotopic_mass": "1198.4396",
                                "monoisotopic_mz": "600.2271",
                                "intensity": "856.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "37",
                                "monoisotopic_mass": "761.7555",
                                "monoisotopic_mz": "762.7628",
                                "intensity": "993.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "277",
                                "peak_id": "38",
                                "monoisotopic_mass": "1000.4769",
                                "monoisotopic_mz": "501.2457",
                                "intensity": "1282.00",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "277",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "277",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "277",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "277",
                                        "peak_id": "31",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "277",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "277",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "277",
                                            "peak_id": "4",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "277",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "277",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "277",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "277",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "198",
                "p_value": "1.94e-08",
                "e_value": "1.94e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "184",
                        "ms1_scans": "464",
                        "ids": "280",
                        "scans": "466",
                        "precursor_mono_mass": "9528.1655",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9431",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "280",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6219",
                                "monoisotopic_mz": "797.4443",
                                "intensity": "14355.93",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0010",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8292",
                                "monoisotopic_mz": "715.9219",
                                "intensity": "12910.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "2",
                                "monoisotopic_mass": "4877.6932",
                                "monoisotopic_mz": "813.9561",
                                "intensity": "4841.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0039",
                                        "ppm": "0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8283",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "5791.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "4",
                                "monoisotopic_mass": "4760.5918",
                                "monoisotopic_mz": "794.4392",
                                "intensity": "3630.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "5",
                                "monoisotopic_mass": "4990.7754",
                                "monoisotopic_mz": "832.8032",
                                "intensity": "5322.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0020",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "6",
                                "monoisotopic_mass": "1856.0512",
                                "monoisotopic_mz": "929.0329",
                                "intensity": "4141.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "7",
                                "monoisotopic_mass": "4777.6115",
                                "monoisotopic_mz": "683.5232",
                                "intensity": "4266.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "8",
                                "monoisotopic_mass": "3264.7593",
                                "monoisotopic_mz": "817.1971",
                                "intensity": "2121.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "9",
                                "monoisotopic_mass": "3249.7165",
                                "monoisotopic_mz": "813.4364",
                                "intensity": "4969.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "10",
                                "monoisotopic_mass": "1785.0120",
                                "monoisotopic_mz": "893.5133",
                                "intensity": "2892.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0029",
                                        "ppm": "-1.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "11",
                                "monoisotopic_mass": "4877.6954",
                                "monoisotopic_mz": "697.8209",
                                "intensity": "5168.28",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0061",
                                        "ppm": "1.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "12",
                                "monoisotopic_mass": "3348.7913",
                                "monoisotopic_mz": "838.2051",
                                "intensity": "5702.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "13",
                                "monoisotopic_mass": "1261.7391",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "2928.13",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "14",
                                "monoisotopic_mass": "2559.8946",
                                "monoisotopic_mz": "854.3055",
                                "intensity": "2389.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "15",
                                "monoisotopic_mass": "1497.3030",
                                "monoisotopic_mz": "749.6588",
                                "intensity": "1624.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "16",
                                "monoisotopic_mass": "1332.7755",
                                "monoisotopic_mz": "667.3950",
                                "intensity": "1900.47",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "17",
                                "monoisotopic_mass": "1565.8857",
                                "monoisotopic_mz": "783.9501",
                                "intensity": "2134.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "18",
                                "monoisotopic_mass": "3135.7306",
                                "monoisotopic_mz": "784.9399",
                                "intensity": "1189.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "19",
                                "monoisotopic_mass": "811.4371",
                                "monoisotopic_mz": "812.4444",
                                "intensity": "1038.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "20",
                                "monoisotopic_mass": "2905.5604",
                                "monoisotopic_mz": "727.3974",
                                "intensity": "1033.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "21",
                                "monoisotopic_mass": "713.7809",
                                "monoisotopic_mz": "714.7881",
                                "intensity": "1069.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "22",
                                "monoisotopic_mass": "768.9149",
                                "monoisotopic_mz": "769.9222",
                                "intensity": "1068.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "23",
                                "monoisotopic_mass": "3560.9468",
                                "monoisotopic_mz": "891.2440",
                                "intensity": "1039.79",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "24",
                                "monoisotopic_mass": "797.4396",
                                "monoisotopic_mz": "798.4468",
                                "intensity": "1787.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "25",
                                "monoisotopic_mass": "733.3218",
                                "monoisotopic_mz": "734.3290",
                                "intensity": "968.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "26",
                                "monoisotopic_mass": "2808.4809",
                                "monoisotopic_mz": "703.1275",
                                "intensity": "1803.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "27",
                                "monoisotopic_mass": "8696.9420",
                                "monoisotopic_mz": "791.6384",
                                "intensity": "734.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "28",
                                "monoisotopic_mass": "1015.6025",
                                "monoisotopic_mz": "1016.6097",
                                "intensity": "1395.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "29",
                                "monoisotopic_mass": "9501.5127",
                                "monoisotopic_mz": "731.8929",
                                "intensity": "1945.72",
                                "charge": "13"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "30",
                                "monoisotopic_mass": "1114.5474",
                                "monoisotopic_mz": "1115.5547",
                                "intensity": "512.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "31",
                                "monoisotopic_mass": "984.5683",
                                "monoisotopic_mz": "985.5756",
                                "intensity": "587.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "32",
                                "monoisotopic_mass": "1043.5110",
                                "monoisotopic_mz": "1044.5183",
                                "intensity": "543.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "33",
                                "monoisotopic_mass": "959.9216",
                                "monoisotopic_mz": "960.9288",
                                "intensity": "595.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "34",
                                "monoisotopic_mass": "906.4808",
                                "monoisotopic_mz": "907.4880",
                                "intensity": "540.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "35",
                                "monoisotopic_mass": "1000.4380",
                                "monoisotopic_mz": "501.2263",
                                "intensity": "959.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "36",
                                "monoisotopic_mass": "750.9047",
                                "monoisotopic_mz": "751.9120",
                                "intensity": "552.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "37",
                                "monoisotopic_mass": "697.8143",
                                "monoisotopic_mz": "698.8216",
                                "intensity": "763.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "38",
                                "monoisotopic_mass": "862.2028",
                                "monoisotopic_mz": "863.2101",
                                "intensity": "629.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "280",
                                "peak_id": "39",
                                "monoisotopic_mass": "876.7801",
                                "monoisotopic_mz": "877.7874",
                                "intensity": "707.61",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "280",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "280",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "44",
                                            "ion_display_position": "46",
                                            "spec_id": "280",
                                            "peak_id": "11",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "280",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "280",
                                        "peak_id": "6",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "280",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "280",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "280",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "280",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "280",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "280",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "213",
                "p_value": "7.40e-08",
                "e_value": "7.40e-08",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "351",
                        "ms1_scans": "648",
                        "ids": "296",
                        "scans": "649",
                        "precursor_mono_mass": "9528.1687",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9433",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "296",
                                "peak_id": "0",
                                "monoisotopic_mass": "4877.6895",
                                "monoisotopic_mz": "813.9555",
                                "intensity": "8495.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8290",
                                "monoisotopic_mz": "715.9218",
                                "intensity": "12616.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6196",
                                "monoisotopic_mz": "797.4439",
                                "intensity": "12540.28",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "3",
                                "monoisotopic_mass": "3348.7896",
                                "monoisotopic_mz": "838.2047",
                                "intensity": "9032.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "4",
                                "monoisotopic_mass": "4778.6201",
                                "monoisotopic_mz": "683.6673",
                                "intensity": "8127.26",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "5",
                                "monoisotopic_mass": "5099.8167",
                                "monoisotopic_mz": "729.5525",
                                "intensity": "6127.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "6",
                                "monoisotopic_mass": "3249.7178",
                                "monoisotopic_mz": "813.4367",
                                "intensity": "3544.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "7",
                                "monoisotopic_mass": "2495.8880",
                                "monoisotopic_mz": "832.9700",
                                "intensity": "5288.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "8",
                                "monoisotopic_mass": "1261.7390",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "3048.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "9",
                                "monoisotopic_mass": "3264.7617",
                                "monoisotopic_mz": "817.1977",
                                "intensity": "3643.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "10",
                                "monoisotopic_mass": "1663.9243",
                                "monoisotopic_mz": "832.9694",
                                "intensity": "2662.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "11",
                                "monoisotopic_mass": "2210.3142",
                                "monoisotopic_mz": "737.7787",
                                "intensity": "1594.57",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "12",
                                "monoisotopic_mass": "4255.2422",
                                "monoisotopic_mz": "1064.8178",
                                "intensity": "2045.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "13",
                                "monoisotopic_mass": "748.3991",
                                "monoisotopic_mz": "749.4064",
                                "intensity": "1028.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "14",
                                "monoisotopic_mass": "500.2224",
                                "monoisotopic_mz": "501.2297",
                                "intensity": "1166.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "15",
                                "monoisotopic_mass": "799.1819",
                                "monoisotopic_mz": "800.1892",
                                "intensity": "1487.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "16",
                                "monoisotopic_mass": "1855.0482",
                                "monoisotopic_mz": "928.5314",
                                "intensity": "2092.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "17",
                                "monoisotopic_mass": "1015.6025",
                                "monoisotopic_mz": "1016.6098",
                                "intensity": "1372.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "18",
                                "monoisotopic_mass": "702.8713",
                                "monoisotopic_mz": "703.8785",
                                "intensity": "1277.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "19",
                                "monoisotopic_mass": "4311.2871",
                                "monoisotopic_mz": "1078.8290",
                                "intensity": "1628.76",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4311.2883",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "20",
                                "monoisotopic_mass": "762.9225",
                                "monoisotopic_mz": "763.9298",
                                "intensity": "2770.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "21",
                                "monoisotopic_mass": "4326.2724",
                                "monoisotopic_mz": "1082.5754",
                                "intensity": "878.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "22",
                                "monoisotopic_mass": "1643.9407",
                                "monoisotopic_mz": "822.9776",
                                "intensity": "1578.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "23",
                                "monoisotopic_mass": "859.3915",
                                "monoisotopic_mz": "860.3987",
                                "intensity": "1298.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "24",
                                "monoisotopic_mass": "1114.6700",
                                "monoisotopic_mz": "558.3423",
                                "intensity": "583.00",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "25",
                                "monoisotopic_mass": "6660.5249",
                                "monoisotopic_mz": "833.5729",
                                "intensity": "2280.53",
                                "charge": "8"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "26",
                                "monoisotopic_mass": "1043.5133",
                                "monoisotopic_mz": "1044.5206",
                                "intensity": "1691.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "27",
                                "monoisotopic_mass": "2265.2254",
                                "monoisotopic_mz": "756.0824",
                                "intensity": "1393.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "28",
                                "monoisotopic_mass": "898.4833",
                                "monoisotopic_mz": "899.4905",
                                "intensity": "883.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "29",
                                "monoisotopic_mass": "6257.7187",
                                "monoisotopic_mz": "783.2221",
                                "intensity": "2025.48",
                                "charge": "8"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "30",
                                "monoisotopic_mass": "5826.9766",
                                "monoisotopic_mz": "729.3794",
                                "intensity": "743.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "31",
                                "monoisotopic_mass": "1430.8313",
                                "monoisotopic_mz": "1431.8385",
                                "intensity": "891.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "32",
                                "monoisotopic_mass": "4724.6142",
                                "monoisotopic_mz": "788.4430",
                                "intensity": "1722.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "296",
                                "peak_id": "33",
                                "monoisotopic_mass": "1409.3117",
                                "monoisotopic_mz": "705.6631",
                                "intensity": "918.86",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "296",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "296",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "296",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "296",
                                            "peak_id": "4",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "296",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "spec_id": "296",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "296",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "spec_id": "296",
                                        "peak_id": "24",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "296",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "205",
                "p_value": "8.57e-08",
                "e_value": "8.57e-08",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "294",
                        "ms1_scans": "582",
                        "ids": "287",
                        "scans": "583",
                        "precursor_mono_mass": "9528.1631",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9429",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "287",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8280",
                                "monoisotopic_mz": "715.9213",
                                "intensity": "10036.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "1",
                                "monoisotopic_mass": "4778.6131",
                                "monoisotopic_mz": "797.4428",
                                "intensity": "16110.45",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0078",
                                        "ppm": "-1.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6133",
                                "monoisotopic_mz": "683.6663",
                                "intensity": "6534.19",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "3",
                                "monoisotopic_mass": "4877.6837",
                                "monoisotopic_mz": "813.9546",
                                "intensity": "4973.51",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "4",
                                "monoisotopic_mass": "5101.8167",
                                "monoisotopic_mz": "729.8382",
                                "intensity": "5238.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "5",
                                "monoisotopic_mass": "3348.7879",
                                "monoisotopic_mz": "838.2043",
                                "intensity": "4485.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "6",
                                "monoisotopic_mass": "4256.2411",
                                "monoisotopic_mz": "1065.0675",
                                "intensity": "3338.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "7",
                                "monoisotopic_mass": "1429.8273",
                                "monoisotopic_mz": "477.6164",
                                "intensity": "4159.83",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "8",
                                "monoisotopic_mass": "1663.9253",
                                "monoisotopic_mz": "832.9699",
                                "intensity": "2210.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "9",
                                "monoisotopic_mass": "4721.6039",
                                "monoisotopic_mz": "787.9413",
                                "intensity": "2535.99",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0045",
                                        "ppm": "0.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "10",
                                "monoisotopic_mass": "1857.0552",
                                "monoisotopic_mz": "929.5349",
                                "intensity": "1770.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "11",
                                "monoisotopic_mass": "829.9405",
                                "monoisotopic_mz": "830.9478",
                                "intensity": "1017.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "12",
                                "monoisotopic_mass": "2839.5235",
                                "monoisotopic_mz": "947.5151",
                                "intensity": "761.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "13",
                                "monoisotopic_mass": "3655.0315",
                                "monoisotopic_mz": "732.0136",
                                "intensity": "833.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "14",
                                "monoisotopic_mass": "1015.6013",
                                "monoisotopic_mz": "508.8079",
                                "intensity": "646.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "15",
                                "monoisotopic_mass": "4759.6089",
                                "monoisotopic_mz": "794.2754",
                                "intensity": "1263.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "16",
                                "monoisotopic_mass": "1486.7854",
                                "monoisotopic_mz": "744.4000",
                                "intensity": "596.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "17",
                                "monoisotopic_mass": "3106.6776",
                                "monoisotopic_mz": "777.6767",
                                "intensity": "1465.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "18",
                                "monoisotopic_mass": "3448.8540",
                                "monoisotopic_mz": "863.2208",
                                "intensity": "762.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "19",
                                "monoisotopic_mass": "1713.9764",
                                "monoisotopic_mz": "857.9955",
                                "intensity": "1869.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "20",
                                "monoisotopic_mass": "3020.6345",
                                "monoisotopic_mz": "756.1659",
                                "intensity": "1754.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "21",
                                "monoisotopic_mass": "1261.7400",
                                "monoisotopic_mz": "631.8773",
                                "intensity": "2413.91",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0005",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "22",
                                "monoisotopic_mass": "1015.6012",
                                "monoisotopic_mz": "1016.6085",
                                "intensity": "996.38",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0014",
                                        "ppm": "-1.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "23",
                                "monoisotopic_mass": "4355.3335",
                                "monoisotopic_mz": "726.8962",
                                "intensity": "1022.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "24",
                                "monoisotopic_mass": "3233.7466",
                                "monoisotopic_mz": "809.4439",
                                "intensity": "1032.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "25",
                                "monoisotopic_mass": "1332.7751",
                                "monoisotopic_mz": "667.3948",
                                "intensity": "1547.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "26",
                                "monoisotopic_mass": "4608.5711",
                                "monoisotopic_mz": "769.1025",
                                "intensity": "2618.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "27",
                                "monoisotopic_mass": "873.0862",
                                "monoisotopic_mz": "874.0934",
                                "intensity": "580.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "28",
                                "monoisotopic_mass": "1470.4985",
                                "monoisotopic_mz": "736.2565",
                                "intensity": "506.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "29",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "1430.8357",
                                "intensity": "940.78",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "30",
                                "monoisotopic_mass": "1457.7940",
                                "monoisotopic_mz": "729.9043",
                                "intensity": "1190.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "31",
                                "monoisotopic_mass": "2907.3212",
                                "monoisotopic_mz": "727.8376",
                                "intensity": "1384.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "32",
                                "monoisotopic_mass": "807.6870",
                                "monoisotopic_mz": "808.6943",
                                "intensity": "484.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "33",
                                "monoisotopic_mass": "1280.0945",
                                "monoisotopic_mz": "641.0545",
                                "intensity": "395.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "34",
                                "monoisotopic_mass": "4296.5831",
                                "monoisotopic_mz": "717.1045",
                                "intensity": "1017.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "35",
                                "monoisotopic_mass": "850.4786",
                                "monoisotopic_mz": "851.4859",
                                "intensity": "463.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "36",
                                "monoisotopic_mass": "784.4332",
                                "monoisotopic_mz": "785.4405",
                                "intensity": "787.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "287",
                                "peak_id": "37",
                                "monoisotopic_mass": "1405.7819",
                                "monoisotopic_mz": "703.8982",
                                "intensity": "667.71",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "287",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "287",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "287",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "287",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "287",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "287",
                                            "peak_id": "7",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "287",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "287",
                                            "peak_id": "29",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "287",
                                        "peak_id": "25",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "287",
                                        "peak_id": "21",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "287",
                                            "peak_id": "22",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "287",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "11",
                "p_value": "8.75e-08",
                "e_value": "8.75e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "58",
                        "ms1_scans": "73",
                        "ids": "14",
                        "scans": "74",
                        "precursor_mono_mass": "9528.1520",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9420",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "14",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8297",
                                "monoisotopic_mz": "715.9221",
                                "intensity": "13373.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0004",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "1",
                                "monoisotopic_mass": "5101.8205",
                                "monoisotopic_mz": "729.8388",
                                "intensity": "8905.17",
                                "charge": "7"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6215",
                                "monoisotopic_mz": "797.4442",
                                "intensity": "21236.40",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0006",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "3",
                                "monoisotopic_mass": "4877.6976",
                                "monoisotopic_mz": "813.9569",
                                "intensity": "7813.10",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0083",
                                        "ppm": "1.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "4",
                                "monoisotopic_mass": "2495.3862",
                                "monoisotopic_mz": "832.8027",
                                "intensity": "5175.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "5",
                                "monoisotopic_mass": "1462.9029",
                                "monoisotopic_mz": "732.4587",
                                "intensity": "6112.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "6",
                                "monoisotopic_mass": "1674.8923",
                                "monoisotopic_mz": "838.4534",
                                "intensity": "5125.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "7",
                                "monoisotopic_mass": "1261.7398",
                                "monoisotopic_mz": "631.8772",
                                "intensity": "2376.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0004",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "8",
                                "monoisotopic_mass": "3248.7161",
                                "monoisotopic_mz": "813.1863",
                                "intensity": "4909.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "9",
                                "monoisotopic_mass": "2922.5716",
                                "monoisotopic_mz": "731.6502",
                                "intensity": "3209.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "10",
                                "monoisotopic_mass": "1332.7762",
                                "monoisotopic_mz": "667.3954",
                                "intensity": "2164.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "11",
                                "monoisotopic_mass": "1855.0520",
                                "monoisotopic_mz": "928.5333",
                                "intensity": "2505.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "12",
                                "monoisotopic_mass": "3462.8794",
                                "monoisotopic_mz": "866.7271",
                                "intensity": "3453.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "13",
                                "monoisotopic_mass": "3135.6760",
                                "monoisotopic_mz": "784.9263",
                                "intensity": "2837.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "14",
                                "monoisotopic_mass": "4573.5313",
                                "monoisotopic_mz": "763.2625",
                                "intensity": "933.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "15",
                                "monoisotopic_mass": "2120.1266",
                                "monoisotopic_mz": "1061.0706",
                                "intensity": "3071.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "16",
                                "monoisotopic_mass": "8059.5665",
                                "monoisotopic_mz": "733.6951",
                                "intensity": "1094.15",
                                "charge": "11"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "17",
                                "monoisotopic_mass": "722.4466",
                                "monoisotopic_mz": "723.4539",
                                "intensity": "5068.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "18",
                                "monoisotopic_mass": "1564.0962",
                                "monoisotopic_mz": "783.0554",
                                "intensity": "1617.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "19",
                                "monoisotopic_mass": "793.9335",
                                "monoisotopic_mz": "794.9407",
                                "intensity": "1745.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "20",
                                "monoisotopic_mass": "4990.7772",
                                "monoisotopic_mz": "713.9754",
                                "intensity": "5557.96",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0038",
                                        "ppm": "0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "21",
                                "monoisotopic_mass": "5118.8093",
                                "monoisotopic_mz": "854.1422",
                                "intensity": "3223.95",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0227",
                                        "ppm": "-4.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "22",
                                "monoisotopic_mass": "1015.6029",
                                "monoisotopic_mz": "1016.6102",
                                "intensity": "1295.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0003",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "23",
                                "monoisotopic_mass": "1016.6065",
                                "monoisotopic_mz": "509.3105",
                                "intensity": "1156.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "24",
                                "monoisotopic_mass": "4778.6155",
                                "monoisotopic_mz": "683.6666",
                                "intensity": "5760.84",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0055",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "25",
                                "monoisotopic_mass": "755.9108",
                                "monoisotopic_mz": "756.9180",
                                "intensity": "1471.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "26",
                                "monoisotopic_mass": "3267.7783",
                                "monoisotopic_mz": "817.9519",
                                "intensity": "2382.80",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.7748",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0035",
                                        "ppm": "1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "27",
                                "monoisotopic_mass": "2993.5988",
                                "monoisotopic_mz": "749.4070",
                                "intensity": "1238.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "28",
                                "monoisotopic_mass": "697.3852",
                                "monoisotopic_mz": "698.3925",
                                "intensity": "2076.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "29",
                                "monoisotopic_mass": "1497.3033",
                                "monoisotopic_mz": "749.6589",
                                "intensity": "1489.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "30",
                                "monoisotopic_mass": "882.4923",
                                "monoisotopic_mz": "883.4996",
                                "intensity": "888.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "31",
                                "monoisotopic_mass": "5556.7077",
                                "monoisotopic_mz": "794.8227",
                                "intensity": "2561.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "32",
                                "monoisotopic_mass": "9445.2007",
                                "monoisotopic_mz": "788.1073",
                                "intensity": "2511.10",
                                "charge": "12"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "33",
                                "monoisotopic_mass": "1429.8310",
                                "monoisotopic_mz": "1430.8383",
                                "intensity": "1027.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0016",
                                        "ppm": "1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "34",
                                "monoisotopic_mass": "1395.0594",
                                "monoisotopic_mz": "698.5370",
                                "intensity": "971.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "35",
                                "monoisotopic_mass": "1591.8590",
                                "monoisotopic_mz": "796.9368",
                                "intensity": "3337.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "36",
                                "monoisotopic_mass": "3915.0948",
                                "monoisotopic_mz": "784.0262",
                                "intensity": "704.95",
                                "charge": "5"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "37",
                                "monoisotopic_mass": "1411.8163",
                                "monoisotopic_mz": "706.9154",
                                "intensity": "1999.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "38",
                                "monoisotopic_mass": "4323.4236",
                                "monoisotopic_mz": "865.6920",
                                "intensity": "1500.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "14",
                                "peak_id": "39",
                                "monoisotopic_mass": "812.9036",
                                "monoisotopic_mz": "813.9109",
                                "intensity": "694.54",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "14",
                                        "peak_id": "26",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "14",
                                        "peak_id": "21",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "14",
                                        "peak_id": "20",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "14",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "14",
                                            "peak_id": "24",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "14",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "14",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "14",
                                            "peak_id": "33",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "14",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "14",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "14",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "54",
                "p_value": "1.78e-07",
                "e_value": "1.78e-07",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "78",
                        "ms1_scans": "144",
                        "ids": "70",
                        "scans": "150",
                        "precursor_mono_mass": "9528.1602",
                        "precursor_charge": "12",
                        "precursor_mz": "795.0206",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "70",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6182",
                                "monoisotopic_mz": "797.4436",
                                "intensity": "35696.33",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6921",
                                "monoisotopic_mz": "813.9560",
                                "intensity": "24902.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0028",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "2",
                                "monoisotopic_mass": "4989.7705",
                                "monoisotopic_mz": "832.6357",
                                "intensity": "20374.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8292",
                                "monoisotopic_mz": "715.9219",
                                "intensity": "13681.51",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "4",
                                "monoisotopic_mass": "6147.3219",
                                "monoisotopic_mz": "879.1961",
                                "intensity": "6698.98",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6148.3298",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0056",
                                        "ppm": "-0.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "5",
                                "monoisotopic_mass": "3347.7938",
                                "monoisotopic_mz": "837.9557",
                                "intensity": "7799.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "6",
                                "monoisotopic_mass": "5117.8286",
                                "monoisotopic_mz": "853.9787",
                                "intensity": "8829.20",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5118.8320",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "Y00048",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "7",
                                "monoisotopic_mass": "4574.5278",
                                "monoisotopic_mz": "763.4286",
                                "intensity": "6113.54",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4574.5310",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "Y00043",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "8",
                                "monoisotopic_mass": "1568.9718",
                                "monoisotopic_mz": "785.4932",
                                "intensity": "4474.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "9",
                                "monoisotopic_mass": "3267.7708",
                                "monoisotopic_mz": "1090.2642",
                                "intensity": "5910.61",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.7748",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0040",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "10",
                                "monoisotopic_mass": "1785.0158",
                                "monoisotopic_mz": "893.5152",
                                "intensity": "4666.25",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0009",
                                        "ppm": "0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "11",
                                "monoisotopic_mass": "2210.3142",
                                "monoisotopic_mz": "737.7787",
                                "intensity": "4110.73",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "12",
                                "monoisotopic_mass": "5100.8259",
                                "monoisotopic_mz": "729.6967",
                                "intensity": "3592.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "13",
                                "monoisotopic_mass": "4239.2480",
                                "monoisotopic_mz": "1060.8193",
                                "intensity": "6676.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "14",
                                "monoisotopic_mass": "1586.9808",
                                "monoisotopic_mz": "794.4977",
                                "intensity": "3539.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "15",
                                "monoisotopic_mass": "5904.0172",
                                "monoisotopic_mz": "844.4383",
                                "intensity": "7118.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "16",
                                "monoisotopic_mass": "4721.5963",
                                "monoisotopic_mz": "787.9400",
                                "intensity": "8147.26",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0032",
                                        "ppm": "-0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "17",
                                "monoisotopic_mass": "3447.8563",
                                "monoisotopic_mz": "862.9713",
                                "intensity": "5249.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "18",
                                "monoisotopic_mass": "4311.2807",
                                "monoisotopic_mz": "1078.8275",
                                "intensity": "4131.60",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4311.2883",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "19",
                                "monoisotopic_mass": "2563.1953",
                                "monoisotopic_mz": "855.4057",
                                "intensity": "3379.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "20",
                                "monoisotopic_mass": "1968.1287",
                                "monoisotopic_mz": "985.0716",
                                "intensity": "4192.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "21",
                                "monoisotopic_mass": "2923.5783",
                                "monoisotopic_mz": "731.9018",
                                "intensity": "2876.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "22",
                                "monoisotopic_mass": "1751.9348",
                                "monoisotopic_mz": "876.9747",
                                "intensity": "2929.19",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "23",
                                "monoisotopic_mass": "8004.1366",
                                "monoisotopic_mz": "890.3558",
                                "intensity": "3537.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "24",
                                "monoisotopic_mass": "1638.8572",
                                "monoisotopic_mz": "820.4359",
                                "intensity": "2292.90",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "25",
                                "monoisotopic_mass": "1855.0474",
                                "monoisotopic_mz": "928.5310",
                                "intensity": "4203.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "26",
                                "monoisotopic_mass": "3181.9579",
                                "monoisotopic_mz": "796.4968",
                                "intensity": "2605.90",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "27",
                                "monoisotopic_mass": "1443.0421",
                                "monoisotopic_mz": "722.5283",
                                "intensity": "1659.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "28",
                                "monoisotopic_mass": "3966.9536",
                                "monoisotopic_mz": "794.3980",
                                "intensity": "4959.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "29",
                                "monoisotopic_mass": "1532.7757",
                                "monoisotopic_mz": "767.3951",
                                "intensity": "2932.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "30",
                                "monoisotopic_mass": "8083.4658",
                                "monoisotopic_mz": "899.1701",
                                "intensity": "2874.57",
                                "charge": "9"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "31",
                                "monoisotopic_mass": "7264.6468",
                                "monoisotopic_mz": "909.0881",
                                "intensity": "1279.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "32",
                                "monoisotopic_mass": "6682.5140",
                                "monoisotopic_mz": "955.6521",
                                "intensity": "2116.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "33",
                                "monoisotopic_mass": "858.4427",
                                "monoisotopic_mz": "859.4499",
                                "intensity": "1364.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "34",
                                "monoisotopic_mass": "4404.2852",
                                "monoisotopic_mz": "881.8643",
                                "intensity": "3460.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "35",
                                "monoisotopic_mass": "783.4188",
                                "monoisotopic_mz": "784.4260",
                                "intensity": "1963.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "36",
                                "monoisotopic_mass": "955.1758",
                                "monoisotopic_mz": "956.1831",
                                "intensity": "1205.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "37",
                                "monoisotopic_mass": "879.5396",
                                "monoisotopic_mz": "880.5469",
                                "intensity": "1298.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "38",
                                "monoisotopic_mass": "1008.5285",
                                "monoisotopic_mz": "1009.5358",
                                "intensity": "1830.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "39",
                                "monoisotopic_mass": "2685.5364",
                                "monoisotopic_mz": "896.1861",
                                "intensity": "1619.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "40",
                                "monoisotopic_mass": "2458.9304",
                                "monoisotopic_mz": "820.6507",
                                "intensity": "1661.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "41",
                                "monoisotopic_mass": "5398.7058",
                                "monoisotopic_mz": "900.7916",
                                "intensity": "2642.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "42",
                                "monoisotopic_mass": "8690.7867",
                                "monoisotopic_mz": "966.6502",
                                "intensity": "1294.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "43",
                                "monoisotopic_mass": "3022.6391",
                                "monoisotopic_mz": "1008.5536",
                                "intensity": "2477.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "44",
                                "monoisotopic_mass": "6609.9126",
                                "monoisotopic_mz": "945.2805",
                                "intensity": "4626.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "45",
                                "monoisotopic_mass": "1127.2866",
                                "monoisotopic_mz": "1128.2938",
                                "intensity": "2280.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "46",
                                "monoisotopic_mass": "8997.9223",
                                "monoisotopic_mz": "900.7995",
                                "intensity": "1503.07",
                                "charge": "10"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "47",
                                "monoisotopic_mass": "8289.6038",
                                "monoisotopic_mz": "829.9677",
                                "intensity": "2988.17",
                                "charge": "10"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "48",
                                "monoisotopic_mass": "5701.7486",
                                "monoisotopic_mz": "951.2987",
                                "intensity": "1225.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "49",
                                "monoisotopic_mass": "1925.0051",
                                "monoisotopic_mz": "963.5098",
                                "intensity": "2310.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "50",
                                "monoisotopic_mass": "7740.5369",
                                "monoisotopic_mz": "861.0669",
                                "intensity": "3109.13",
                                "charge": "9"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "51",
                                "monoisotopic_mass": "3196.7347",
                                "monoisotopic_mz": "1066.5855",
                                "intensity": "3464.88",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3196.7377",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "52",
                                "monoisotopic_mass": "801.8856",
                                "monoisotopic_mz": "802.8929",
                                "intensity": "1271.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "53",
                                "monoisotopic_mass": "821.9730",
                                "monoisotopic_mz": "822.9803",
                                "intensity": "2789.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "54",
                                "monoisotopic_mass": "6021.5924",
                                "monoisotopic_mz": "861.2348",
                                "intensity": "2099.13",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "55",
                                "monoisotopic_mass": "8765.8248",
                                "monoisotopic_mz": "974.9878",
                                "intensity": "1214.60",
                                "charge": "9"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "56",
                                "monoisotopic_mass": "5987.1807",
                                "monoisotopic_mz": "998.8707",
                                "intensity": "2380.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "57",
                                "monoisotopic_mass": "5983.8199",
                                "monoisotopic_mz": "855.8387",
                                "intensity": "1307.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "58",
                                "monoisotopic_mass": "5139.6182",
                                "monoisotopic_mz": "857.6103",
                                "intensity": "3212.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "59",
                                "monoisotopic_mass": "754.1083",
                                "monoisotopic_mz": "755.1156",
                                "intensity": "1157.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "60",
                                "monoisotopic_mass": "5652.8096",
                                "monoisotopic_mz": "943.1422",
                                "intensity": "3441.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "61",
                                "monoisotopic_mass": "5488.3721",
                                "monoisotopic_mz": "915.7360",
                                "intensity": "3093.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "62",
                                "monoisotopic_mass": "2631.3597",
                                "monoisotopic_mz": "878.1272",
                                "intensity": "1442.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "63",
                                "monoisotopic_mass": "5547.8090",
                                "monoisotopic_mz": "793.5514",
                                "intensity": "3022.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "64",
                                "monoisotopic_mass": "7583.0917",
                                "monoisotopic_mz": "948.8937",
                                "intensity": "2763.38",
                                "charge": "8"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "65",
                                "monoisotopic_mass": "4857.3291",
                                "monoisotopic_mz": "972.4731",
                                "intensity": "2875.34",
                                "charge": "5"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "66",
                                "monoisotopic_mass": "942.7922",
                                "monoisotopic_mz": "943.7994",
                                "intensity": "906.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "67",
                                "monoisotopic_mass": "970.8334",
                                "monoisotopic_mz": "971.8406",
                                "intensity": "1178.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "68",
                                "monoisotopic_mass": "3181.4820",
                                "monoisotopic_mz": "1061.5013",
                                "intensity": "2378.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "69",
                                "monoisotopic_mass": "1395.8544",
                                "monoisotopic_mz": "466.2921",
                                "intensity": "1319.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "70",
                                "monoisotopic_mass": "6443.5704",
                                "monoisotopic_mz": "806.4536",
                                "intensity": "1508.85",
                                "charge": "8"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "71",
                                "monoisotopic_mass": "5374.2227",
                                "monoisotopic_mz": "896.7111",
                                "intensity": "1401.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "72",
                                "monoisotopic_mass": "2713.7684",
                                "monoisotopic_mz": "905.5967",
                                "intensity": "3443.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "73",
                                "monoisotopic_mass": "5827.4097",
                                "monoisotopic_mz": "972.2422",
                                "intensity": "2107.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "74",
                                "monoisotopic_mass": "4450.5163",
                                "monoisotopic_mz": "891.1105",
                                "intensity": "1593.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "75",
                                "monoisotopic_mass": "9389.6967",
                                "monoisotopic_mz": "854.6161",
                                "intensity": "2202.50",
                                "charge": "11"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "76",
                                "monoisotopic_mass": "1139.6144",
                                "monoisotopic_mz": "1140.6217",
                                "intensity": "1295.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "77",
                                "monoisotopic_mass": "1429.8265",
                                "monoisotopic_mz": "1430.8337",
                                "intensity": "1832.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0029",
                                        "ppm": "-2.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "78",
                                "monoisotopic_mass": "5872.9283",
                                "monoisotopic_mz": "979.8287",
                                "intensity": "2099.26",
                                "charge": "6"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "79",
                                "monoisotopic_mass": "2765.7171",
                                "monoisotopic_mz": "922.9130",
                                "intensity": "3364.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "80",
                                "monoisotopic_mass": "1429.8280",
                                "monoisotopic_mz": "477.6166",
                                "intensity": "1306.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "81",
                                "monoisotopic_mass": "1911.2150",
                                "monoisotopic_mz": "956.6148",
                                "intensity": "2214.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "82",
                                "monoisotopic_mass": "3239.7711",
                                "monoisotopic_mz": "810.9500",
                                "intensity": "1972.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "83",
                                "monoisotopic_mass": "8900.8418",
                                "monoisotopic_mz": "891.0915",
                                "intensity": "1655.62",
                                "charge": "10"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "84",
                                "monoisotopic_mass": "9506.5053",
                                "monoisotopic_mz": "865.2350",
                                "intensity": "2986.24",
                                "charge": "11"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "85",
                                "monoisotopic_mass": "1393.1632",
                                "monoisotopic_mz": "697.5889",
                                "intensity": "2485.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "86",
                                "monoisotopic_mass": "6106.3216",
                                "monoisotopic_mz": "873.3389",
                                "intensity": "2090.77",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "87",
                                "monoisotopic_mass": "6290.5602",
                                "monoisotopic_mz": "787.3273",
                                "intensity": "1230.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "88",
                                "monoisotopic_mass": "1077.8211",
                                "monoisotopic_mz": "1078.8284",
                                "intensity": "879.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "89",
                                "monoisotopic_mass": "4574.4108",
                                "monoisotopic_mz": "915.8894",
                                "intensity": "2877.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "90",
                                "monoisotopic_mass": "3847.4679",
                                "monoisotopic_mz": "962.8742",
                                "intensity": "2576.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "91",
                                "monoisotopic_mass": "6558.5076",
                                "monoisotopic_mz": "937.9369",
                                "intensity": "2320.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "70",
                                "peak_id": "92",
                                "monoisotopic_mass": "1031.7845",
                                "monoisotopic_mz": "1032.7918",
                                "intensity": "1099.00",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "70",
                                        "peak_id": "51",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "70",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "32",
                                        "ion_display_position": "58",
                                        "spec_id": "70",
                                        "peak_id": "4",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "70",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "42",
                                        "ion_display_position": "48",
                                        "spec_id": "70",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "70",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "70",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "70",
                                        "peak_id": "16",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "47",
                                        "ion_display_position": "43",
                                        "spec_id": "70",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "70",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "70",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "70",
                                            "peak_id": "77",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "70",
                                            "peak_id": "80",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "70",
                                            "peak_id": "3",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "196",
                "p_value": "3.24e-07",
                "e_value": "3.24e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "164",
                        "ms1_scans": "443",
                        "ids": "278",
                        "scans": "444",
                        "precursor_mono_mass": "9528.1695",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9434",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "278",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6230",
                                "monoisotopic_mz": "797.4444",
                                "intensity": "19271.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0021",
                                        "ppm": "0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6950",
                                "monoisotopic_mz": "813.9564",
                                "intensity": "10063.05",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0057",
                                        "ppm": "1.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "2",
                                "monoisotopic_mass": "1429.8291",
                                "monoisotopic_mz": "715.9218",
                                "intensity": "14078.78",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "3",
                                "monoisotopic_mass": "4990.7754",
                                "monoisotopic_mz": "832.8032",
                                "intensity": "7280.94",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0020",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "4",
                                "monoisotopic_mass": "4777.6131",
                                "monoisotopic_mz": "683.5234",
                                "intensity": "4183.34",
                                "charge": "7"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "5",
                                "monoisotopic_mass": "1429.8283",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "5167.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "6",
                                "monoisotopic_mass": "3348.7874",
                                "monoisotopic_mz": "838.2041",
                                "intensity": "5810.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "7",
                                "monoisotopic_mass": "3248.7229",
                                "monoisotopic_mz": "813.1880",
                                "intensity": "4793.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "8",
                                "monoisotopic_mass": "4876.6820",
                                "monoisotopic_mz": "697.6761",
                                "intensity": "2758.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "9",
                                "monoisotopic_mass": "1968.1333",
                                "monoisotopic_mz": "985.0739",
                                "intensity": "1637.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "10",
                                "monoisotopic_mass": "1332.7761",
                                "monoisotopic_mz": "667.3953",
                                "intensity": "1752.45",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "11",
                                "monoisotopic_mass": "1856.0504",
                                "monoisotopic_mz": "929.0325",
                                "intensity": "2315.46",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "12",
                                "monoisotopic_mass": "3064.6411",
                                "monoisotopic_mz": "767.1675",
                                "intensity": "2222.74",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "13",
                                "monoisotopic_mass": "2823.6312",
                                "monoisotopic_mz": "706.9151",
                                "intensity": "1581.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "14",
                                "monoisotopic_mass": "821.4690",
                                "monoisotopic_mz": "822.4763",
                                "intensity": "1262.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "15",
                                "monoisotopic_mass": "4721.6047",
                                "monoisotopic_mz": "787.9414",
                                "intensity": "1568.97",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "0.0053",
                                        "ppm": "1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "16",
                                "monoisotopic_mass": "3461.8677",
                                "monoisotopic_mz": "866.4742",
                                "intensity": "1095.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "17",
                                "monoisotopic_mass": "7275.9690",
                                "monoisotopic_mz": "728.6042",
                                "intensity": "931.81",
                                "charge": "10"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "18",
                                "monoisotopic_mass": "726.5455",
                                "monoisotopic_mz": "727.5528",
                                "intensity": "925.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "19",
                                "monoisotopic_mass": "500.2226",
                                "monoisotopic_mz": "501.2298",
                                "intensity": "1132.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "20",
                                "monoisotopic_mass": "3005.7476",
                                "monoisotopic_mz": "752.4442",
                                "intensity": "2006.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "21",
                                "monoisotopic_mass": "1405.2433",
                                "monoisotopic_mz": "703.6289",
                                "intensity": "2145.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "22",
                                "monoisotopic_mass": "798.4229",
                                "monoisotopic_mz": "799.4302",
                                "intensity": "907.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "23",
                                "monoisotopic_mass": "1284.7246",
                                "monoisotopic_mz": "643.3696",
                                "intensity": "665.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "24",
                                "monoisotopic_mass": "9452.0320",
                                "monoisotopic_mz": "728.0867",
                                "intensity": "2014.33",
                                "charge": "13"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "25",
                                "monoisotopic_mass": "3583.4357",
                                "monoisotopic_mz": "717.6944",
                                "intensity": "1428.12",
                                "charge": "5"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "26",
                                "monoisotopic_mass": "3331.7708",
                                "monoisotopic_mz": "833.9500",
                                "intensity": "1848.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "27",
                                "monoisotopic_mass": "2672.7161",
                                "monoisotopic_mz": "891.9127",
                                "intensity": "1241.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "28",
                                "monoisotopic_mass": "1452.7787",
                                "monoisotopic_mz": "727.3966",
                                "intensity": "593.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "29",
                                "monoisotopic_mass": "862.4662",
                                "monoisotopic_mz": "863.4734",
                                "intensity": "1229.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "30",
                                "monoisotopic_mass": "1261.7387",
                                "monoisotopic_mz": "631.8766",
                                "intensity": "2430.61",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "31",
                                "monoisotopic_mass": "1366.1792",
                                "monoisotopic_mz": "684.0969",
                                "intensity": "1312.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "32",
                                "monoisotopic_mass": "1283.7239",
                                "monoisotopic_mz": "1284.7312",
                                "intensity": "629.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "33",
                                "monoisotopic_mass": "1468.2557",
                                "monoisotopic_mz": "735.1351",
                                "intensity": "649.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "34",
                                "monoisotopic_mass": "1491.3840",
                                "monoisotopic_mz": "746.6993",
                                "intensity": "1150.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "35",
                                "monoisotopic_mass": "4179.6835",
                                "monoisotopic_mz": "697.6212",
                                "intensity": "1225.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "278",
                                "peak_id": "36",
                                "monoisotopic_mass": "761.9173",
                                "monoisotopic_mz": "762.9246",
                                "intensity": "930.31",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "278",
                                        "peak_id": "3",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "278",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "278",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "spec_id": "278",
                                        "peak_id": "15",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "278",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "278",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "278",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "278",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "278",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "97",
                "p_value": "5.83e-07",
                "e_value": "5.83e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "98",
                        "ms1_scans": "230",
                        "ids": "131",
                        "scans": "231",
                        "precursor_mono_mass": "9529.1581",
                        "precursor_charge": "14",
                        "precursor_mz": "681.6614",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "131",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8296",
                                "monoisotopic_mz": "715.9221",
                                "intensity": "15036.42",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0002",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "1",
                                "monoisotopic_mass": "5453.7863",
                                "monoisotopic_mz": "682.7306",
                                "intensity": "5543.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6150",
                                "monoisotopic_mz": "683.6666",
                                "intensity": "10216.81",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0059",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "477.6168",
                                "intensity": "10369.41",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "4",
                                "monoisotopic_mass": "3249.7209",
                                "monoisotopic_mz": "813.4375",
                                "intensity": "7842.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "5",
                                "monoisotopic_mass": "3348.7862",
                                "monoisotopic_mz": "838.2038",
                                "intensity": "6714.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "6",
                                "monoisotopic_mass": "5099.8077",
                                "monoisotopic_mz": "729.5512",
                                "intensity": "5328.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "7",
                                "monoisotopic_mass": "1261.7391",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "5134.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "8",
                                "monoisotopic_mass": "1362.8316",
                                "monoisotopic_mz": "682.4231",
                                "intensity": "3770.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "9",
                                "monoisotopic_mass": "1345.8215",
                                "monoisotopic_mz": "673.9180",
                                "intensity": "5156.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "10",
                                "monoisotopic_mass": "4876.6777",
                                "monoisotopic_mz": "697.6755",
                                "intensity": "4738.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "11",
                                "monoisotopic_mass": "1114.6704",
                                "monoisotopic_mz": "558.3425",
                                "intensity": "2096.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "12",
                                "monoisotopic_mass": "1332.7749",
                                "monoisotopic_mz": "667.3947",
                                "intensity": "2729.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0017",
                                        "ppm": "-1.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "13",
                                "monoisotopic_mass": "4090.1595",
                                "monoisotopic_mz": "682.7005",
                                "intensity": "5227.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "14",
                                "monoisotopic_mass": "3460.8750",
                                "monoisotopic_mz": "693.1823",
                                "intensity": "2393.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "15",
                                "monoisotopic_mass": "1730.4321",
                                "monoisotopic_mz": "866.2233",
                                "intensity": "1805.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "16",
                                "monoisotopic_mass": "4238.2447",
                                "monoisotopic_mz": "1060.5684",
                                "intensity": "1266.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "17",
                                "monoisotopic_mass": "5435.7414",
                                "monoisotopic_mz": "680.4749",
                                "intensity": "4721.68",
                                "charge": "8"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "18",
                                "monoisotopic_mass": "4761.6034",
                                "monoisotopic_mz": "681.2363",
                                "intensity": "2230.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "19",
                                "monoisotopic_mass": "3248.7230",
                                "monoisotopic_mz": "650.7519",
                                "intensity": "3693.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "20",
                                "monoisotopic_mass": "2477.7271",
                                "monoisotopic_mz": "826.9163",
                                "intensity": "2271.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "21",
                                "monoisotopic_mass": "1291.7145",
                                "monoisotopic_mz": "431.5788",
                                "intensity": "2040.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "22",
                                "monoisotopic_mass": "869.4967",
                                "monoisotopic_mz": "870.5040",
                                "intensity": "1407.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "23",
                                "monoisotopic_mass": "3572.9178",
                                "monoisotopic_mz": "715.5908",
                                "intensity": "4485.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "24",
                                "monoisotopic_mass": "796.6024",
                                "monoisotopic_mz": "797.6097",
                                "intensity": "1503.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "25",
                                "monoisotopic_mass": "4132.0589",
                                "monoisotopic_mz": "827.4190",
                                "intensity": "1519.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "26",
                                "monoisotopic_mass": "3348.7931",
                                "monoisotopic_mz": "670.7659",
                                "intensity": "4498.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "27",
                                "monoisotopic_mass": "1785.0129",
                                "monoisotopic_mz": "893.5137",
                                "intensity": "1435.77",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "28",
                                "monoisotopic_mass": "743.4544",
                                "monoisotopic_mz": "744.4617",
                                "intensity": "1329.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "743.4542",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "83",
                                        "mass_error": "0.0002",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "29",
                                "monoisotopic_mass": "6636.7728",
                                "monoisotopic_mz": "830.6039",
                                "intensity": "1005.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "30",
                                "monoisotopic_mass": "6924.7534",
                                "monoisotopic_mz": "866.6014",
                                "intensity": "2707.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "31",
                                "monoisotopic_mass": "500.2227",
                                "monoisotopic_mz": "501.2300",
                                "intensity": "1726.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "32",
                                "monoisotopic_mass": "813.6833",
                                "monoisotopic_mz": "814.6906",
                                "intensity": "1036.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "33",
                                "monoisotopic_mass": "3330.7653",
                                "monoisotopic_mz": "833.6986",
                                "intensity": "2317.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "34",
                                "monoisotopic_mass": "928.5287",
                                "monoisotopic_mz": "929.5360",
                                "intensity": "935.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "35",
                                "monoisotopic_mass": "6266.7695",
                                "monoisotopic_mz": "784.3535",
                                "intensity": "2318.35",
                                "charge": "8"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "36",
                                "monoisotopic_mass": "1713.9781",
                                "monoisotopic_mz": "857.9963",
                                "intensity": "1771.60",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "0.0003",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "37",
                                "monoisotopic_mass": "4644.5634",
                                "monoisotopic_mz": "775.1012",
                                "intensity": "1359.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "38",
                                "monoisotopic_mass": "1089.5933",
                                "monoisotopic_mz": "1090.6006",
                                "intensity": "591.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "39",
                                "monoisotopic_mass": "772.4198",
                                "monoisotopic_mz": "773.4271",
                                "intensity": "969.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "40",
                                "monoisotopic_mass": "1015.6022",
                                "monoisotopic_mz": "1016.6095",
                                "intensity": "1684.85",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "41",
                                "monoisotopic_mass": "1488.9153",
                                "monoisotopic_mz": "745.4649",
                                "intensity": "370.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "42",
                                "monoisotopic_mass": "1634.3817",
                                "monoisotopic_mz": "818.1981",
                                "intensity": "1233.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "43",
                                "monoisotopic_mass": "4007.4914",
                                "monoisotopic_mz": "802.5056",
                                "intensity": "933.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "44",
                                "monoisotopic_mass": "2439.3502",
                                "monoisotopic_mz": "814.1240",
                                "intensity": "2883.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "45",
                                "monoisotopic_mass": "4989.7786",
                                "monoisotopic_mz": "832.6370",
                                "intensity": "2502.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "46",
                                "monoisotopic_mass": "2922.5725",
                                "monoisotopic_mz": "731.6504",
                                "intensity": "1934.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "47",
                                "monoisotopic_mass": "2101.0491",
                                "monoisotopic_mz": "701.3570",
                                "intensity": "1415.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "48",
                                "monoisotopic_mass": "1282.7132",
                                "monoisotopic_mz": "642.3639",
                                "intensity": "495.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "49",
                                "monoisotopic_mass": "1283.7250",
                                "monoisotopic_mz": "1284.7323",
                                "intensity": "1100.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "50",
                                "monoisotopic_mass": "2026.2489",
                                "monoisotopic_mz": "676.4236",
                                "intensity": "747.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "51",
                                "monoisotopic_mass": "1395.7764",
                                "monoisotopic_mz": "698.8955",
                                "intensity": "305.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "52",
                                "monoisotopic_mass": "1572.3537",
                                "monoisotopic_mz": "787.1841",
                                "intensity": "1488.01",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "53",
                                "monoisotopic_mass": "3136.6798",
                                "monoisotopic_mz": "628.3432",
                                "intensity": "2001.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "54",
                                "monoisotopic_mass": "9081.3289",
                                "monoisotopic_mz": "826.5826",
                                "intensity": "1090.92",
                                "charge": "11"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "55",
                                "monoisotopic_mass": "1553.6838",
                                "monoisotopic_mz": "777.8492",
                                "intensity": "1483.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "56",
                                "monoisotopic_mass": "4573.5453",
                                "monoisotopic_mz": "763.2648",
                                "intensity": "2962.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "57",
                                "monoisotopic_mass": "1375.7534",
                                "monoisotopic_mz": "688.8840",
                                "intensity": "574.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "131",
                                "peak_id": "58",
                                "monoisotopic_mass": "831.7708",
                                "monoisotopic_mz": "832.7781",
                                "intensity": "603.86",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "131",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "131",
                                        "peak_id": "27",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "131",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "131",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "131",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "131",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "131",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "spec_id": "131",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "131",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "83",
                                        "ion_display_position": "7",
                                        "spec_id": "131",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "3",
                "p_value": "6.63e-07",
                "e_value": "6.63e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "37",
                        "ms1_scans": "41",
                        "ids": "3",
                        "scans": "42",
                        "precursor_mono_mass": "9527.1539",
                        "precursor_charge": "13",
                        "precursor_mz": "733.8653",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "3",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6186",
                                "monoisotopic_mz": "797.4437",
                                "intensity": "19623.04",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8294",
                                "monoisotopic_mz": "715.9220",
                                "intensity": "14716.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0001",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "2",
                                "monoisotopic_mass": "436.1860",
                                "monoisotopic_mz": "437.1932",
                                "intensity": "11716.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "3",
                                "monoisotopic_mass": "5100.8105",
                                "monoisotopic_mz": "729.6945",
                                "intensity": "9539.94",
                                "charge": "7"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "4",
                                "monoisotopic_mass": "4877.6899",
                                "monoisotopic_mz": "697.8201",
                                "intensity": "5662.11",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0006",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "5",
                                "monoisotopic_mass": "3348.7933",
                                "monoisotopic_mz": "838.2056",
                                "intensity": "6560.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "6",
                                "monoisotopic_mass": "4876.6868",
                                "monoisotopic_mz": "813.7884",
                                "intensity": "7526.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "7",
                                "monoisotopic_mass": "4778.6155",
                                "monoisotopic_mz": "683.6666",
                                "intensity": "7276.62",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0055",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "8",
                                "monoisotopic_mass": "4761.6315",
                                "monoisotopic_mz": "794.6125",
                                "intensity": "5777.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "9",
                                "monoisotopic_mass": "4988.7748",
                                "monoisotopic_mz": "832.4697",
                                "intensity": "7097.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "10",
                                "monoisotopic_mass": "1472.8860",
                                "monoisotopic_mz": "737.4503",
                                "intensity": "9308.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "11",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "477.6169",
                                "intensity": "5818.41",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "12",
                                "monoisotopic_mass": "2559.4154",
                                "monoisotopic_mz": "854.1457",
                                "intensity": "5507.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "13",
                                "monoisotopic_mass": "1855.0503",
                                "monoisotopic_mz": "928.5324",
                                "intensity": "2916.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "14",
                                "monoisotopic_mass": "1454.8759",
                                "monoisotopic_mz": "728.4452",
                                "intensity": "7408.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "15",
                                "monoisotopic_mass": "3348.7975",
                                "monoisotopic_mz": "670.7668",
                                "intensity": "2398.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "16",
                                "monoisotopic_mass": "2937.6600",
                                "monoisotopic_mz": "735.4223",
                                "intensity": "2139.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "17",
                                "monoisotopic_mass": "1642.9398",
                                "monoisotopic_mz": "822.4772",
                                "intensity": "1913.44",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1642.9407",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "74",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "18",
                                "monoisotopic_mass": "1497.2998",
                                "monoisotopic_mz": "749.6572",
                                "intensity": "2240.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "19",
                                "monoisotopic_mass": "1261.7400",
                                "monoisotopic_mz": "631.8773",
                                "intensity": "3657.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0005",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "20",
                                "monoisotopic_mass": "2210.3151",
                                "monoisotopic_mz": "737.7790",
                                "intensity": "1597.81",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2210.3151",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "Y00022",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "21",
                                "monoisotopic_mass": "3232.6916",
                                "monoisotopic_mz": "809.1802",
                                "intensity": "3241.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "22",
                                "monoisotopic_mass": "1969.1345",
                                "monoisotopic_mz": "985.5745",
                                "intensity": "2279.87",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "23",
                                "monoisotopic_mass": "3250.7225",
                                "monoisotopic_mz": "813.6879",
                                "intensity": "4203.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "24",
                                "monoisotopic_mass": "3447.8669",
                                "monoisotopic_mz": "862.9740",
                                "intensity": "2907.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "25",
                                "monoisotopic_mass": "930.4298",
                                "monoisotopic_mz": "931.4371",
                                "intensity": "1095.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "26",
                                "monoisotopic_mass": "2199.4319",
                                "monoisotopic_mz": "734.1512",
                                "intensity": "3778.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "27",
                                "monoisotopic_mass": "5099.8136",
                                "monoisotopic_mz": "850.9762",
                                "intensity": "2801.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "28",
                                "monoisotopic_mass": "7753.6831",
                                "monoisotopic_mz": "862.5276",
                                "intensity": "988.31",
                                "charge": "9"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "29",
                                "monoisotopic_mass": "1043.5151",
                                "monoisotopic_mz": "1044.5223",
                                "intensity": "1064.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "30",
                                "monoisotopic_mass": "784.1712",
                                "monoisotopic_mz": "785.1785",
                                "intensity": "1523.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "31",
                                "monoisotopic_mass": "5870.1530",
                                "monoisotopic_mz": "734.7764",
                                "intensity": "1164.44",
                                "charge": "8"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "32",
                                "monoisotopic_mass": "1283.7256",
                                "monoisotopic_mz": "1284.7329",
                                "intensity": "573.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "33",
                                "monoisotopic_mass": "866.4715",
                                "monoisotopic_mz": "867.4788",
                                "intensity": "1129.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "34",
                                "monoisotopic_mass": "893.0088",
                                "monoisotopic_mz": "894.0161",
                                "intensity": "1528.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "35",
                                "monoisotopic_mass": "702.8716",
                                "monoisotopic_mz": "703.8789",
                                "intensity": "949.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "36",
                                "monoisotopic_mass": "8903.3557",
                                "monoisotopic_mz": "810.4032",
                                "intensity": "2010.79",
                                "charge": "11"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "37",
                                "monoisotopic_mass": "1332.7765",
                                "monoisotopic_mz": "667.3955",
                                "intensity": "1451.10",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "38",
                                "monoisotopic_mass": "1429.8310",
                                "monoisotopic_mz": "1430.8383",
                                "intensity": "1819.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0016",
                                        "ppm": "1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "39",
                                "monoisotopic_mass": "1015.6022",
                                "monoisotopic_mz": "1016.6095",
                                "intensity": "701.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "40",
                                "monoisotopic_mass": "5850.2116",
                                "monoisotopic_mz": "732.2837",
                                "intensity": "943.68",
                                "charge": "8"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "41",
                                "monoisotopic_mass": "1386.7633",
                                "monoisotopic_mz": "694.3889",
                                "intensity": "660.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "42",
                                "monoisotopic_mass": "810.9680",
                                "monoisotopic_mz": "811.9752",
                                "intensity": "1064.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "43",
                                "monoisotopic_mass": "3385.8091",
                                "monoisotopic_mz": "847.4595",
                                "intensity": "1711.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "3",
                                "peak_id": "44",
                                "monoisotopic_mass": "853.4626",
                                "monoisotopic_mz": "854.4699",
                                "intensity": "581.71",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9527.4389",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "3",
                                        "peak_id": "4",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "3",
                                            "peak_id": "7",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "3",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "22",
                                        "spec_id": "3",
                                        "peak_id": "20",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "3",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "74",
                                        "ion_display_position": "16",
                                        "spec_id": "3",
                                        "peak_id": "17",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "3",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "3",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "3",
                                            "peak_id": "38",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "3",
                                        "peak_id": "37",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "3",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "spec_id": "3",
                                        "peak_id": "39",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "44",
                            "anno": "-1.7498",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "216",
                "p_value": "7.91e-07",
                "e_value": "7.91e-07",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "379",
                        "ms1_scans": "680",
                        "ids": "300",
                        "scans": "681",
                        "precursor_mono_mass": "9528.1679",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9433",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "300",
                                "peak_id": "0",
                                "monoisotopic_mass": "4778.6219",
                                "monoisotopic_mz": "797.4443",
                                "intensity": "13585.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0010",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8281",
                                "monoisotopic_mz": "715.9213",
                                "intensity": "9777.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "2",
                                "monoisotopic_mass": "4878.6952",
                                "monoisotopic_mz": "814.1231",
                                "intensity": "7377.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "3",
                                "monoisotopic_mass": "3348.7916",
                                "monoisotopic_mz": "838.2052",
                                "intensity": "4733.17",
                                "charge": "4"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "4",
                                "monoisotopic_mass": "4777.6144",
                                "monoisotopic_mz": "683.5236",
                                "intensity": "3618.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "5",
                                "monoisotopic_mass": "1429.8283",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "3454.15",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "6",
                                "monoisotopic_mass": "4990.7678",
                                "monoisotopic_mz": "832.8019",
                                "intensity": "6606.93",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "7",
                                "monoisotopic_mass": "2558.9133",
                                "monoisotopic_mz": "853.9784",
                                "intensity": "4429.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "8",
                                "monoisotopic_mass": "1624.8626",
                                "monoisotopic_mz": "813.4386",
                                "intensity": "1814.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "9",
                                "monoisotopic_mass": "1261.7390",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "1696.37",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "10",
                                "monoisotopic_mass": "7311.9355",
                                "monoisotopic_mz": "732.2008",
                                "intensity": "992.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "11",
                                "monoisotopic_mass": "705.9073",
                                "monoisotopic_mz": "706.9145",
                                "intensity": "1098.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "12",
                                "monoisotopic_mass": "4877.6886",
                                "monoisotopic_mz": "697.8199",
                                "intensity": "2123.86",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "13",
                                "monoisotopic_mass": "1856.0522",
                                "monoisotopic_mz": "929.0334",
                                "intensity": "2128.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0002",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "14",
                                "monoisotopic_mass": "1015.6020",
                                "monoisotopic_mz": "508.8083",
                                "intensity": "1136.20",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "15",
                                "monoisotopic_mass": "1359.7420",
                                "monoisotopic_mz": "680.8783",
                                "intensity": "553.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "16",
                                "monoisotopic_mass": "1015.6024",
                                "monoisotopic_mz": "1016.6097",
                                "intensity": "622.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "17",
                                "monoisotopic_mass": "5100.8016",
                                "monoisotopic_mz": "851.1409",
                                "intensity": "835.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "18",
                                "monoisotopic_mass": "865.9700",
                                "monoisotopic_mz": "866.9772",
                                "intensity": "869.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "19",
                                "monoisotopic_mass": "2186.7764",
                                "monoisotopic_mz": "729.9327",
                                "intensity": "777.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "20",
                                "monoisotopic_mass": "2925.5454",
                                "monoisotopic_mz": "732.3936",
                                "intensity": "709.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "21",
                                "monoisotopic_mass": "1043.5116",
                                "monoisotopic_mz": "1044.5189",
                                "intensity": "598.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "22",
                                "monoisotopic_mass": "3570.9162",
                                "monoisotopic_mz": "715.1905",
                                "intensity": "1104.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "23",
                                "monoisotopic_mass": "1724.9296",
                                "monoisotopic_mz": "863.4721",
                                "intensity": "901.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "24",
                                "monoisotopic_mass": "4451.6810",
                                "monoisotopic_mz": "891.3435",
                                "intensity": "1857.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "25",
                                "monoisotopic_mass": "1429.8274",
                                "monoisotopic_mz": "1430.8347",
                                "intensity": "569.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0019",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "26",
                                "monoisotopic_mass": "1458.2345",
                                "monoisotopic_mz": "730.1245",
                                "intensity": "1828.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "27",
                                "monoisotopic_mass": "4760.5831",
                                "monoisotopic_mz": "794.4378",
                                "intensity": "3350.76",
                                "charge": "6"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "28",
                                "monoisotopic_mass": "1394.4813",
                                "monoisotopic_mz": "698.2479",
                                "intensity": "596.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "29",
                                "monoisotopic_mass": "3446.8663",
                                "monoisotopic_mz": "862.7238",
                                "intensity": "1166.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "30",
                                "monoisotopic_mass": "1496.8003",
                                "monoisotopic_mz": "749.4074",
                                "intensity": "594.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "31",
                                "monoisotopic_mass": "890.1272",
                                "monoisotopic_mz": "891.1345",
                                "intensity": "532.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "300",
                                "peak_id": "32",
                                "monoisotopic_mass": "753.4395",
                                "monoisotopic_mz": "754.4468",
                                "intensity": "818.33",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "300",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "300",
                                        "peak_id": "12",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "300",
                                        "peak_id": "0",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "300",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "300",
                                            "peak_id": "25",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "300",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "300",
                                            "peak_id": "5",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "300",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "300",
                                            "peak_id": "14",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "80",
                                            "ion_display_position": "10",
                                            "spec_id": "300",
                                            "peak_id": "16",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "182",
                "p_value": "8.48e-07",
                "e_value": "8.48e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "135",
                        "ms1_scans": "393",
                        "ids": "258",
                        "scans": "395",
                        "precursor_mono_mass": "9529.1653",
                        "precursor_charge": "13",
                        "precursor_mz": "734.0200",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "258",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8287",
                                "monoisotopic_mz": "715.9216",
                                "intensity": "14650.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "1",
                                "monoisotopic_mass": "4777.6129",
                                "monoisotopic_mz": "797.2761",
                                "intensity": "16261.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "2",
                                "monoisotopic_mass": "4990.7711",
                                "monoisotopic_mz": "832.8025",
                                "intensity": "7430.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "3",
                                "monoisotopic_mass": "1429.8284",
                                "monoisotopic_mz": "477.6167",
                                "intensity": "4462.39",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "4",
                                "monoisotopic_mass": "5099.8090",
                                "monoisotopic_mz": "729.5514",
                                "intensity": "6949.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "5",
                                "monoisotopic_mass": "4779.6255",
                                "monoisotopic_mz": "683.8109",
                                "intensity": "8169.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "6",
                                "monoisotopic_mass": "4876.6846",
                                "monoisotopic_mz": "813.7880",
                                "intensity": "10060.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "7",
                                "monoisotopic_mass": "1785.0129",
                                "monoisotopic_mz": "893.5137",
                                "intensity": "2781.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1785.0149",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "Y00018",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "8",
                                "monoisotopic_mass": "3349.7913",
                                "monoisotopic_mz": "838.4551",
                                "intensity": "5045.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "9",
                                "monoisotopic_mass": "2993.5932",
                                "monoisotopic_mz": "749.4056",
                                "intensity": "2445.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "10",
                                "monoisotopic_mass": "2923.5691",
                                "monoisotopic_mz": "731.8995",
                                "intensity": "2367.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "11",
                                "monoisotopic_mass": "3331.7696",
                                "monoisotopic_mz": "833.9497",
                                "intensity": "3327.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "12",
                                "monoisotopic_mass": "1856.0521",
                                "monoisotopic_mz": "929.0334",
                                "intensity": "2239.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0001",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "13",
                                "monoisotopic_mass": "1713.9786",
                                "monoisotopic_mz": "857.9966",
                                "intensity": "1529.42",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "0.0008",
                                        "ppm": "0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "14",
                                "monoisotopic_mass": "3249.7577",
                                "monoisotopic_mz": "813.4467",
                                "intensity": "4220.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "15",
                                "monoisotopic_mass": "1332.7750",
                                "monoisotopic_mz": "667.3948",
                                "intensity": "1838.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "16",
                                "monoisotopic_mass": "1969.1355",
                                "monoisotopic_mz": "985.5750",
                                "intensity": "2367.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1969.1361",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "17",
                                "monoisotopic_mass": "2809.4844",
                                "monoisotopic_mz": "703.3784",
                                "intensity": "2212.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "18",
                                "monoisotopic_mass": "5100.8031",
                                "monoisotopic_mz": "851.1411",
                                "intensity": "1493.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "19",
                                "monoisotopic_mass": "3021.6296",
                                "monoisotopic_mz": "756.4147",
                                "intensity": "2092.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "20",
                                "monoisotopic_mass": "1261.7391",
                                "monoisotopic_mz": "631.8768",
                                "intensity": "2864.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "21",
                                "monoisotopic_mass": "680.9203",
                                "monoisotopic_mz": "681.9275",
                                "intensity": "3714.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "22",
                                "monoisotopic_mass": "3162.7039",
                                "monoisotopic_mz": "791.6833",
                                "intensity": "1611.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "23",
                                "monoisotopic_mass": "702.3845",
                                "monoisotopic_mz": "703.3917",
                                "intensity": "705.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "24",
                                "monoisotopic_mass": "869.4964",
                                "monoisotopic_mz": "870.5037",
                                "intensity": "1033.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "25",
                                "monoisotopic_mass": "6372.6593",
                                "monoisotopic_mz": "797.5897",
                                "intensity": "1128.32",
                                "charge": "8"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "26",
                                "monoisotopic_mass": "1365.6069",
                                "monoisotopic_mz": "683.8107",
                                "intensity": "2533.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "27",
                                "monoisotopic_mass": "4257.2445",
                                "monoisotopic_mz": "1065.3184",
                                "intensity": "2482.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "28",
                                "monoisotopic_mass": "3447.8596",
                                "monoisotopic_mz": "862.9722",
                                "intensity": "809.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "29",
                                "monoisotopic_mass": "1430.8322",
                                "monoisotopic_mz": "1431.8395",
                                "intensity": "511.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "30",
                                "monoisotopic_mass": "1059.5593",
                                "monoisotopic_mz": "1060.5665",
                                "intensity": "545.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "31",
                                "monoisotopic_mass": "972.4737",
                                "monoisotopic_mz": "973.4810",
                                "intensity": "993.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "32",
                                "monoisotopic_mass": "1486.9063",
                                "monoisotopic_mz": "744.4605",
                                "intensity": "788.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "33",
                                "monoisotopic_mass": "816.6913",
                                "monoisotopic_mz": "817.6986",
                                "intensity": "1268.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "34",
                                "monoisotopic_mass": "1444.7022",
                                "monoisotopic_mz": "723.3584",
                                "intensity": "551.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "35",
                                "monoisotopic_mass": "2183.4931",
                                "monoisotopic_mz": "728.8383",
                                "intensity": "1653.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "36",
                                "monoisotopic_mass": "2160.4242",
                                "monoisotopic_mz": "721.1487",
                                "intensity": "769.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "37",
                                "monoisotopic_mass": "4227.1081",
                                "monoisotopic_mz": "846.4289",
                                "intensity": "838.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "38",
                                "monoisotopic_mass": "773.4184",
                                "monoisotopic_mz": "774.4256",
                                "intensity": "835.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "39",
                                "monoisotopic_mass": "849.6327",
                                "monoisotopic_mz": "850.6400",
                                "intensity": "708.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "258",
                                "peak_id": "40",
                                "monoisotopic_mass": "630.3529",
                                "monoisotopic_mz": "631.3601",
                                "intensity": "724.97",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "258",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "20",
                                        "spec_id": "258",
                                        "peak_id": "16",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "258",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "18",
                                        "spec_id": "258",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "258",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "258",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "258",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "spec_id": "258",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "258",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "204",
                "p_value": "8.78e-07",
                "e_value": "8.78e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "284",
                        "ms1_scans": "571",
                        "ids": "286",
                        "scans": "572",
                        "precursor_mono_mass": "9528.1687",
                        "precursor_charge": "13",
                        "precursor_mz": "733.9433",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "286",
                                "peak_id": "0",
                                "monoisotopic_mass": "1429.8285",
                                "monoisotopic_mz": "715.9215",
                                "intensity": "11257.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "1",
                                "monoisotopic_mass": "4877.6881",
                                "monoisotopic_mz": "813.9553",
                                "intensity": "8744.93",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4877.6893",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "Y00046",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "2",
                                "monoisotopic_mass": "4778.6233",
                                "monoisotopic_mz": "797.4445",
                                "intensity": "14023.73",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0024",
                                        "ppm": "0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "3",
                                "monoisotopic_mass": "5101.8167",
                                "monoisotopic_mz": "729.8382",
                                "intensity": "6320.84",
                                "charge": "7"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "4",
                                "monoisotopic_mass": "4778.6078",
                                "monoisotopic_mz": "683.6655",
                                "intensity": "7733.79",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0131",
                                        "ppm": "-2.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "5",
                                "monoisotopic_mass": "4876.6862",
                                "monoisotopic_mz": "697.6767",
                                "intensity": "5148.37",
                                "charge": "7"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "6",
                                "monoisotopic_mass": "4990.7674",
                                "monoisotopic_mz": "832.8018",
                                "intensity": "4982.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0060",
                                        "ppm": "-1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "7",
                                "monoisotopic_mass": "4761.6139",
                                "monoisotopic_mz": "794.6096",
                                "intensity": "3389.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "8",
                                "monoisotopic_mass": "3348.7847",
                                "monoisotopic_mz": "838.2035",
                                "intensity": "5592.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "9",
                                "monoisotopic_mass": "1429.8270",
                                "monoisotopic_mz": "477.6163",
                                "intensity": "3520.31",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0023",
                                        "ppm": "-1.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "10",
                                "monoisotopic_mass": "1261.7386",
                                "monoisotopic_mz": "631.8766",
                                "intensity": "3015.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "11",
                                "monoisotopic_mass": "3250.7180",
                                "monoisotopic_mz": "813.6868",
                                "intensity": "3052.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "12",
                                "monoisotopic_mass": "3349.7961",
                                "monoisotopic_mz": "670.9665",
                                "intensity": "2475.51",
                                "charge": "5"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "13",
                                "monoisotopic_mass": "1856.0512",
                                "monoisotopic_mz": "929.0329",
                                "intensity": "1650.40",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1856.0520",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "Y00019",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "14",
                                "monoisotopic_mass": "2923.5723",
                                "monoisotopic_mz": "731.9003",
                                "intensity": "2866.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "15",
                                "monoisotopic_mass": "3135.6777",
                                "monoisotopic_mz": "784.9267",
                                "intensity": "2096.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "16",
                                "monoisotopic_mass": "2809.4861",
                                "monoisotopic_mz": "703.3788",
                                "intensity": "913.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "17",
                                "monoisotopic_mass": "666.3883",
                                "monoisotopic_mz": "667.3956",
                                "intensity": "1049.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "18",
                                "monoisotopic_mass": "2550.4057",
                                "monoisotopic_mz": "851.1425",
                                "intensity": "2699.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "19",
                                "monoisotopic_mass": "1713.9754",
                                "monoisotopic_mz": "857.9950",
                                "intensity": "1320.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1713.9778",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "Y00017",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0024",
                                        "ppm": "-1.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "20",
                                "monoisotopic_mass": "4572.5249",
                                "monoisotopic_mz": "763.0948",
                                "intensity": "2188.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "21",
                                "monoisotopic_mass": "808.1758",
                                "monoisotopic_mz": "809.1830",
                                "intensity": "792.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "22",
                                "monoisotopic_mass": "3462.8806",
                                "monoisotopic_mz": "866.7274",
                                "intensity": "1387.59",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "23",
                                "monoisotopic_mass": "783.4109",
                                "monoisotopic_mz": "784.4182",
                                "intensity": "784.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "24",
                                "monoisotopic_mass": "4309.2579",
                                "monoisotopic_mz": "1078.3217",
                                "intensity": "898.55",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "25",
                                "monoisotopic_mass": "859.3917",
                                "monoisotopic_mz": "860.3990",
                                "intensity": "1257.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "26",
                                "monoisotopic_mass": "2199.3845",
                                "monoisotopic_mz": "734.1354",
                                "intensity": "823.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "27",
                                "monoisotopic_mass": "1429.8288",
                                "monoisotopic_mz": "1430.8361",
                                "intensity": "769.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "28",
                                "monoisotopic_mass": "1411.8165",
                                "monoisotopic_mz": "706.9155",
                                "intensity": "660.25",
                                "charge": "2"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "29",
                                "monoisotopic_mass": "3626.9350",
                                "monoisotopic_mz": "907.7410",
                                "intensity": "947.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "30",
                                "monoisotopic_mass": "714.3862",
                                "monoisotopic_mz": "715.3935",
                                "intensity": "1046.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "31",
                                "monoisotopic_mass": "2352.7934",
                                "monoisotopic_mz": "785.2717",
                                "intensity": "542.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "32",
                                "monoisotopic_mass": "892.5062",
                                "monoisotopic_mz": "893.5134",
                                "intensity": "1149.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "33",
                                "monoisotopic_mass": "2180.8901",
                                "monoisotopic_mz": "727.9706",
                                "intensity": "913.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "34",
                                "monoisotopic_mass": "5991.1997",
                                "monoisotopic_mz": "749.9072",
                                "intensity": "1670.96",
                                "charge": "8"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "35",
                                "monoisotopic_mass": "7007.7288",
                                "monoisotopic_mz": "876.9734",
                                "intensity": "738.90",
                                "charge": "8"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "36",
                                "monoisotopic_mass": "2971.8099",
                                "monoisotopic_mz": "743.9597",
                                "intensity": "1819.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "37",
                                "monoisotopic_mass": "1505.3170",
                                "monoisotopic_mz": "753.6658",
                                "intensity": "1418.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "286",
                                "peak_id": "38",
                                "monoisotopic_mass": "1114.6694",
                                "monoisotopic_mz": "558.3420",
                                "intensity": "767.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.47"
                                    }
                                }
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "spec_id": "286",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "44",
                                        "ion_display_position": "46",
                                        "spec_id": "286",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "286",
                                            "peak_id": "4",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "286",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "19",
                                        "spec_id": "286",
                                        "peak_id": "13",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "17",
                                        "spec_id": "286",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "286",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "286",
                                            "peak_id": "0",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "76",
                                            "ion_display_position": "14",
                                            "spec_id": "286",
                                            "peak_id": "27",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "spec_id": "286",
                                        "peak_id": "10",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "spec_id": "286",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "72",
                "p_value": "1.34e-06",
                "e_value": "1.34e-06",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "86",
                        "ms1_scans": "184",
                        "ids": "97",
                        "scans": "185",
                        "precursor_mono_mass": "9529.1653",
                        "precursor_charge": "13",
                        "precursor_mz": "734.0200",
                        "feature_inte": "2.5443e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "97",
                                "peak_id": "0",
                                "monoisotopic_mass": "4777.6155",
                                "monoisotopic_mz": "797.2765",
                                "intensity": "22691.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "1",
                                "monoisotopic_mass": "1429.8290",
                                "monoisotopic_mz": "715.9218",
                                "intensity": "20010.43",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "2",
                                "monoisotopic_mass": "4876.6876",
                                "monoisotopic_mz": "813.7885",
                                "intensity": "14703.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "3",
                                "monoisotopic_mass": "3348.7896",
                                "monoisotopic_mz": "838.2047",
                                "intensity": "12147.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "4",
                                "monoisotopic_mass": "4990.7739",
                                "monoisotopic_mz": "832.8029",
                                "intensity": "8065.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4990.7734",
                                        "ion_position": "43",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "Y00047",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0006",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "5",
                                "monoisotopic_mass": "4778.6159",
                                "monoisotopic_mz": "683.6667",
                                "intensity": "7931.78",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4778.6209",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "Y00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0050",
                                        "ppm": "-1.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "6",
                                "monoisotopic_mass": "5100.8199",
                                "monoisotopic_mz": "729.6958",
                                "intensity": "15633.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "7",
                                "monoisotopic_mass": "3249.7163",
                                "monoisotopic_mz": "813.4363",
                                "intensity": "4968.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "8",
                                "monoisotopic_mass": "4239.2470",
                                "monoisotopic_mz": "1060.8190",
                                "intensity": "4210.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "9",
                                "monoisotopic_mass": "1429.8281",
                                "monoisotopic_mz": "477.6166",
                                "intensity": "9242.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1429.8293",
                                        "ion_position": "76",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "10",
                                "monoisotopic_mass": "1261.7396",
                                "monoisotopic_mz": "631.8771",
                                "intensity": "4449.56",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1261.7395",
                                        "ion_position": "78",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "78",
                                        "mass_error": "0.0001",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "11",
                                "monoisotopic_mass": "2993.6013",
                                "monoisotopic_mz": "749.4076",
                                "intensity": "4207.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "12",
                                "monoisotopic_mass": "1332.7745",
                                "monoisotopic_mz": "667.3945",
                                "intensity": "2831.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1332.7766",
                                        "ion_position": "77",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "13",
                                "monoisotopic_mass": "3446.8599",
                                "monoisotopic_mz": "862.7223",
                                "intensity": "4617.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "14",
                                "monoisotopic_mass": "2199.1505",
                                "monoisotopic_mz": "734.0574",
                                "intensity": "3904.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "15",
                                "monoisotopic_mass": "4573.5266",
                                "monoisotopic_mz": "763.2617",
                                "intensity": "3394.43",
                                "charge": "6"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "16",
                                "monoisotopic_mass": "1786.0173",
                                "monoisotopic_mz": "894.0159",
                                "intensity": "2589.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "17",
                                "monoisotopic_mass": "500.2232",
                                "monoisotopic_mz": "501.2305",
                                "intensity": "1582.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "18",
                                "monoisotopic_mass": "1968.1326",
                                "monoisotopic_mz": "985.0736",
                                "intensity": "2552.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "19",
                                "monoisotopic_mass": "3669.9922",
                                "monoisotopic_mz": "735.0057",
                                "intensity": "1887.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "20",
                                "monoisotopic_mass": "766.4111",
                                "monoisotopic_mz": "767.4183",
                                "intensity": "2077.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "21",
                                "monoisotopic_mass": "2927.8107",
                                "monoisotopic_mz": "732.9599",
                                "intensity": "2178.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "22",
                                "monoisotopic_mass": "4721.5856",
                                "monoisotopic_mz": "787.9382",
                                "intensity": "3307.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4721.5994",
                                        "ion_position": "46",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "Y00044",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0138",
                                        "ppm": "-2.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "23",
                                "monoisotopic_mass": "733.8008",
                                "monoisotopic_mz": "734.8080",
                                "intensity": "1646.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "24",
                                "monoisotopic_mass": "4255.2480",
                                "monoisotopic_mz": "1064.8193",
                                "intensity": "1065.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "25",
                                "monoisotopic_mass": "4762.5931",
                                "monoisotopic_mz": "794.7728",
                                "intensity": "1294.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "26",
                                "monoisotopic_mass": "3267.7705",
                                "monoisotopic_mz": "817.9499",
                                "intensity": "1042.77",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.7748",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0043",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "27",
                                "monoisotopic_mass": "700.3384",
                                "monoisotopic_mz": "701.3456",
                                "intensity": "1284.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "28",
                                "monoisotopic_mass": "5007.1838",
                                "monoisotopic_mz": "716.3193",
                                "intensity": "977.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "29",
                                "monoisotopic_mass": "3348.7899",
                                "monoisotopic_mz": "670.7653",
                                "intensity": "1479.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "30",
                                "monoisotopic_mass": "782.4140",
                                "monoisotopic_mz": "783.4213",
                                "intensity": "958.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "31",
                                "monoisotopic_mass": "6919.7106",
                                "monoisotopic_mz": "769.8640",
                                "intensity": "984.31",
                                "charge": "9"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "32",
                                "monoisotopic_mass": "6220.1377",
                                "monoisotopic_mz": "778.5245",
                                "intensity": "895.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "33",
                                "monoisotopic_mass": "5101.7985",
                                "monoisotopic_mz": "851.3070",
                                "intensity": "3475.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "34",
                                "monoisotopic_mass": "859.3926",
                                "monoisotopic_mz": "860.3998",
                                "intensity": "1952.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "35",
                                "monoisotopic_mass": "1467.8465",
                                "monoisotopic_mz": "734.9305",
                                "intensity": "1129.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "36",
                                "monoisotopic_mass": "930.4284",
                                "monoisotopic_mz": "931.4357",
                                "intensity": "2497.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "37",
                                "monoisotopic_mass": "821.4695",
                                "monoisotopic_mz": "822.4767",
                                "intensity": "2280.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "38",
                                "monoisotopic_mass": "6570.7554",
                                "monoisotopic_mz": "822.3517",
                                "intensity": "2018.64",
                                "charge": "8"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "39",
                                "monoisotopic_mass": "1015.6015",
                                "monoisotopic_mz": "508.8080",
                                "intensity": "1821.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1015.6026",
                                        "ion_position": "80",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0012",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "40",
                                "monoisotopic_mass": "1487.7939",
                                "monoisotopic_mz": "744.9042",
                                "intensity": "1492.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "41",
                                "monoisotopic_mass": "3331.7588",
                                "monoisotopic_mz": "833.9470",
                                "intensity": "1883.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "42",
                                "monoisotopic_mass": "1452.7783",
                                "monoisotopic_mz": "727.3964",
                                "intensity": "577.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "43",
                                "monoisotopic_mass": "1544.8116",
                                "monoisotopic_mz": "773.4131",
                                "intensity": "1570.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "44",
                                "monoisotopic_mass": "6012.1964",
                                "monoisotopic_mz": "859.8925",
                                "intensity": "2466.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "45",
                                "monoisotopic_mass": "674.8005",
                                "monoisotopic_mz": "675.8078",
                                "intensity": "1359.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "46",
                                "monoisotopic_mass": "6695.3767",
                                "monoisotopic_mz": "957.4897",
                                "intensity": "902.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "47",
                                "monoisotopic_mass": "3381.8643",
                                "monoisotopic_mz": "1128.2954",
                                "intensity": "3045.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "48",
                                "monoisotopic_mass": "6223.7493",
                                "monoisotopic_mz": "692.5350",
                                "intensity": "1213.63",
                                "charge": "9"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "49",
                                "monoisotopic_mass": "3634.9394",
                                "monoisotopic_mz": "909.7421",
                                "intensity": "973.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "50",
                                "monoisotopic_mass": "3267.7628",
                                "monoisotopic_mz": "1090.2615",
                                "intensity": "2673.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3267.7748",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0120",
                                        "ppm": "-3.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "51",
                                "monoisotopic_mass": "5573.8526",
                                "monoisotopic_mz": "697.7388",
                                "intensity": "2273.28",
                                "charge": "8"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "52",
                                "monoisotopic_mass": "1114.6699",
                                "monoisotopic_mz": "558.3422",
                                "intensity": "1751.11",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1114.6710",
                                        "ion_position": "79",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "53",
                                "monoisotopic_mass": "6294.4999",
                                "monoisotopic_mz": "787.8198",
                                "intensity": "2121.24",
                                "charge": "8"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "54",
                                "monoisotopic_mass": "9050.4444",
                                "monoisotopic_mz": "755.2110",
                                "intensity": "1869.81",
                                "charge": "12"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "55",
                                "monoisotopic_mass": "3375.6883",
                                "monoisotopic_mz": "844.9294",
                                "intensity": "1861.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "56",
                                "monoisotopic_mass": "9500.5313",
                                "monoisotopic_mz": "864.6919",
                                "intensity": "1064.09",
                                "charge": "11"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "57",
                                "monoisotopic_mass": "1411.8167",
                                "monoisotopic_mz": "706.9157",
                                "intensity": "1503.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "58",
                                "monoisotopic_mass": "5441.2542",
                                "monoisotopic_mz": "681.1640",
                                "intensity": "999.93",
                                "charge": "8"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "59",
                                "monoisotopic_mass": "892.5072",
                                "monoisotopic_mz": "893.5145",
                                "intensity": "2024.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "60",
                                "monoisotopic_mass": "2559.9151",
                                "monoisotopic_mz": "854.3123",
                                "intensity": "2219.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "61",
                                "monoisotopic_mass": "7721.0656",
                                "monoisotopic_mz": "858.9034",
                                "intensity": "1158.88",
                                "charge": "9"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "62",
                                "monoisotopic_mass": "1078.3232",
                                "monoisotopic_mz": "1079.3305",
                                "intensity": "937.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "63",
                                "monoisotopic_mass": "1430.8287",
                                "monoisotopic_mz": "1431.8360",
                                "intensity": "827.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "64",
                                "monoisotopic_mass": "906.4973",
                                "monoisotopic_mz": "907.5046",
                                "intensity": "842.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "65",
                                "monoisotopic_mass": "839.0398",
                                "monoisotopic_mz": "840.0470",
                                "intensity": "757.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "66",
                                "monoisotopic_mass": "2351.5442",
                                "monoisotopic_mz": "784.8554",
                                "intensity": "2403.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "97",
                                "peak_id": "67",
                                "monoisotopic_mass": "1596.8205",
                                "monoisotopic_mz": "799.4175",
                                "intensity": "1700.44",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "4",
                    "proteoform_id": "4",
                    "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
                    "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
                    "proteoform_mass": "9529.1887",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "90",
                        "first_residue_position": "0",
                        "last_residue_position": "89",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "T"
                            },
                            {
                                "position": "4",
                                "acid": "Q"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "I"
                            },
                            {
                                "position": "7",
                                "acid": "D"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "I"
                            },
                            {
                                "position": "10",
                                "acid": "A"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "A"
                            },
                            {
                                "position": "14",
                                "acid": "E"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "S"
                            },
                            {
                                "position": "17",
                                "acid": "K"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "A"
                            },
                            {
                                "position": "21",
                                "acid": "K"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "L"
                            },
                            {
                                "position": "25",
                                "acid": "E"
                            },
                            {
                                "position": "26",
                                "acid": "S"
                            },
                            {
                                "position": "27",
                                "acid": "T"
                            },
                            {
                                "position": "28",
                                "acid": "L"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "I"
                            },
                            {
                                "position": "32",
                                "acid": "T"
                            },
                            {
                                "position": "33",
                                "acid": "E"
                            },
                            {
                                "position": "34",
                                "acid": "S"
                            },
                            {
                                "position": "35",
                                "acid": "L"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "E"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "D"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "V"
                            },
                            {
                                "position": "42",
                                "acid": "Q"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "V"
                            },
                            {
                                "position": "45",
                                "acid": "G"
                            },
                            {
                                "position": "46",
                                "acid": "F"
                            },
                            {
                                "position": "47",
                                "acid": "G"
                            },
                            {
                                "position": "48",
                                "acid": "T"
                            },
                            {
                                "position": "49",
                                "acid": "F"
                            },
                            {
                                "position": "50",
                                "acid": "K"
                            },
                            {
                                "position": "51",
                                "acid": "V"
                            },
                            {
                                "position": "52",
                                "acid": "N"
                            },
                            {
                                "position": "53",
                                "acid": "H"
                            },
                            {
                                "position": "54",
                                "acid": "R"
                            },
                            {
                                "position": "55",
                                "acid": "A"
                            },
                            {
                                "position": "56",
                                "acid": "E"
                            },
                            {
                                "position": "57",
                                "acid": "R"
                            },
                            {
                                "position": "58",
                                "acid": "T"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "R"
                            },
                            {
                                "position": "61",
                                "acid": "N"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "I"
                            },
                            {
                                "position": "71",
                                "acid": "A"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "A"
                            },
                            {
                                "position": "74",
                                "acid": "N"
                            },
                            {
                                "position": "75",
                                "acid": "V"
                            },
                            {
                                "position": "76",
                                "acid": "P"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            },
                            {
                                "position": "78",
                                "acid": "F"
                            },
                            {
                                "position": "79",
                                "acid": "V"
                            },
                            {
                                "position": "80",
                                "acid": "S"
                            },
                            {
                                "position": "81",
                                "acid": "G"
                            },
                            {
                                "position": "82",
                                "acid": "K"
                            },
                            {
                                "position": "83",
                                "acid": "A"
                            },
                            {
                                "position": "84",
                                "acid": "L"
                            },
                            {
                                "position": "85",
                                "acid": "K"
                            },
                            {
                                "position": "86",
                                "acid": "D"
                            },
                            {
                                "position": "87",
                                "acid": "A"
                            },
                            {
                                "position": "88",
                                "acid": "V"
                            },
                            {
                                "position": "89",
                                "acid": "K"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
 