prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "16",
        "sequence_name": "sp|Q46839|GLCA_ECOLI",
        "sequence_description": "Glycolate permease GlcA OS=Escherichia coli (strain K12) OX=83333 GN=glcA PE=1 SV=1",
        "proteoform_id": "23",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "103",
            "p_value": "0.58",
            "e_value": "0.82",
            "fdr": "8.55e-03",
            "matched_fragment_number": "5",
            "matched_peak_number": "5",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "ecoli_2_ms2.msalign",
                    "ms1_ids": "100",
                    "ms1_scans": "239",
                    "ids": "140",
                    "scans": "242",
                    "precursor_mono_mass": "25945.7681",
                    "precursor_charge": "30",
                    "precursor_mz": "865.8662",
                    "feature_inte": "7.4716e+05"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "140",
                            "peak_id": "0",
                            "monoisotopic_mass": "5188.7571",
                            "monoisotopic_mz": "865.8001",
                            "intensity": "45636.88",
                            "charge": "6",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5189.7484",
                                    "ion_position": "198",
                                    "ion_display_position": "48",
                                    "ion_sort_name": "Y00048",
                                    "ion_left_position": "198",
                                    "mass_error": "0.0110",
                                    "ppm": "2.12"
                                }
                            }
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "1",
                            "monoisotopic_mass": "8320.1039",
                            "monoisotopic_mz": "833.0177",
                            "intensity": "14628.06",
                            "charge": "10"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "2",
                            "monoisotopic_mass": "3553.9024",
                            "monoisotopic_mz": "889.4829",
                            "intensity": "5770.12",
                            "charge": "4"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "3",
                            "monoisotopic_mass": "4959.5828",
                            "monoisotopic_mz": "992.9238",
                            "intensity": "4534.33",
                            "charge": "5"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "4",
                            "monoisotopic_mass": "1955.1386",
                            "monoisotopic_mz": "652.7201",
                            "intensity": "3074.90",
                            "charge": "3"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "5",
                            "monoisotopic_mass": "2666.6849",
                            "monoisotopic_mz": "889.9022",
                            "intensity": "2883.54",
                            "charge": "3"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "6",
                            "monoisotopic_mass": "20769.0691",
                            "monoisotopic_mz": "866.3852",
                            "intensity": "1642.75",
                            "charge": "24"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "7",
                            "monoisotopic_mass": "1633.8496",
                            "monoisotopic_mz": "817.9321",
                            "intensity": "2524.71",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "8",
                            "monoisotopic_mass": "18964.7051",
                            "monoisotopic_mz": "863.0393",
                            "intensity": "4898.68",
                            "charge": "22"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "9",
                            "monoisotopic_mass": "7775.1571",
                            "monoisotopic_mz": "864.9136",
                            "intensity": "4723.97",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "10",
                            "monoisotopic_mass": "11385.4377",
                            "monoisotopic_mz": "876.8102",
                            "intensity": "1334.00",
                            "charge": "13"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "11",
                            "monoisotopic_mass": "7957.1202",
                            "monoisotopic_mz": "885.1317",
                            "intensity": "2927.66",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "12",
                            "monoisotopic_mass": "1820.0036",
                            "monoisotopic_mz": "911.0091",
                            "intensity": "1324.19",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "13",
                            "monoisotopic_mass": "8115.4561",
                            "monoisotopic_mz": "1015.4393",
                            "intensity": "851.50",
                            "charge": "8"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "14",
                            "monoisotopic_mass": "5484.8723",
                            "monoisotopic_mz": "1097.9817",
                            "intensity": "1670.31",
                            "charge": "5"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "15",
                            "monoisotopic_mass": "6183.1624",
                            "monoisotopic_mz": "1031.5343",
                            "intensity": "1386.32",
                            "charge": "6"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "16",
                            "monoisotopic_mass": "898.1863",
                            "monoisotopic_mz": "899.1936",
                            "intensity": "1913.79",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "17",
                            "monoisotopic_mass": "11967.9812",
                            "monoisotopic_mz": "998.3390",
                            "intensity": "2024.44",
                            "charge": "12",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "11968.1463",
                                    "ion_position": "132",
                                    "ion_display_position": "114",
                                    "ion_sort_name": "Y00114",
                                    "ion_left_position": "132",
                                    "mass_error": "-0.1651",
                                    "ppm": "-13.79"
                                }
                            }
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "18",
                            "monoisotopic_mass": "1993.2887",
                            "monoisotopic_mz": "997.6516",
                            "intensity": "1331.12",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "19",
                            "monoisotopic_mass": "2138.2235",
                            "monoisotopic_mz": "713.7485",
                            "intensity": "1968.00",
                            "charge": "3"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "20",
                            "monoisotopic_mass": "12495.4315",
                            "monoisotopic_mz": "893.5381",
                            "intensity": "1298.37",
                            "charge": "14"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "21",
                            "monoisotopic_mass": "8638.5656",
                            "monoisotopic_mz": "960.8479",
                            "intensity": "1369.64",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "22",
                            "monoisotopic_mass": "8192.1932",
                            "monoisotopic_mz": "911.2510",
                            "intensity": "976.05",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "23",
                            "monoisotopic_mass": "8118.1845",
                            "monoisotopic_mz": "903.0278",
                            "intensity": "2998.79",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "24",
                            "monoisotopic_mass": "6228.6011",
                            "monoisotopic_mz": "1039.1075",
                            "intensity": "2849.02",
                            "charge": "6"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "25",
                            "monoisotopic_mass": "9382.9728",
                            "monoisotopic_mz": "939.3046",
                            "intensity": "1312.67",
                            "charge": "10"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "26",
                            "monoisotopic_mass": "12174.0803",
                            "monoisotopic_mz": "1015.5140",
                            "intensity": "2003.23",
                            "charge": "12"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "27",
                            "monoisotopic_mass": "3411.4028",
                            "monoisotopic_mz": "853.8580",
                            "intensity": "1095.95",
                            "charge": "4"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "28",
                            "monoisotopic_mass": "25842.1443",
                            "monoisotopic_mz": "892.1157",
                            "intensity": "1842.88",
                            "charge": "29",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "25841.8983",
                                    "ion_position": "245",
                                    "ion_display_position": "245",
                                    "ion_sort_name": "B00245",
                                    "ion_left_position": "245",
                                    "mass_error": "0.2460",
                                    "ppm": "9.52"
                                }
                            }
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "29",
                            "monoisotopic_mass": "855.1476",
                            "monoisotopic_mz": "856.1548",
                            "intensity": "953.58",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "30",
                            "monoisotopic_mass": "12820.3141",
                            "monoisotopic_mz": "855.6949",
                            "intensity": "1965.92",
                            "charge": "15",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "12820.1628",
                                    "ion_position": "120",
                                    "ion_display_position": "120",
                                    "ion_sort_name": "B00120",
                                    "ion_left_position": "120",
                                    "mass_error": "0.1513",
                                    "ppm": "11.80"
                                }
                            }
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "31",
                            "monoisotopic_mass": "1292.0126",
                            "monoisotopic_mz": "1293.0199",
                            "intensity": "698.05",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "32",
                            "monoisotopic_mass": "3553.9076",
                            "monoisotopic_mz": "1185.6431",
                            "intensity": "1664.96",
                            "charge": "3"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "33",
                            "monoisotopic_mass": "20094.4770",
                            "monoisotopic_mz": "914.3926",
                            "intensity": "1791.91",
                            "charge": "22"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "34",
                            "monoisotopic_mass": "10300.8538",
                            "monoisotopic_mz": "937.4485",
                            "intensity": "1758.08",
                            "charge": "11"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "35",
                            "monoisotopic_mass": "5756.8886",
                            "monoisotopic_mz": "960.4887",
                            "intensity": "2352.61",
                            "charge": "6"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "36",
                            "monoisotopic_mass": "16586.1786",
                            "monoisotopic_mz": "922.4616",
                            "intensity": "2382.37",
                            "charge": "18"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "37",
                            "monoisotopic_mass": "1263.6933",
                            "monoisotopic_mz": "632.8539",
                            "intensity": "3170.53",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "38",
                            "monoisotopic_mass": "1044.5503",
                            "monoisotopic_mz": "1045.5576",
                            "intensity": "764.84",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "39",
                            "monoisotopic_mass": "952.4789",
                            "monoisotopic_mz": "953.4861",
                            "intensity": "1634.76",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "40",
                            "monoisotopic_mass": "12689.4662",
                            "monoisotopic_mz": "907.3977",
                            "intensity": "2416.43",
                            "charge": "14"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "41",
                            "monoisotopic_mass": "6983.3345",
                            "monoisotopic_mz": "998.6265",
                            "intensity": "928.23",
                            "charge": "7"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "42",
                            "monoisotopic_mass": "1184.6266",
                            "monoisotopic_mz": "1185.6339",
                            "intensity": "669.98",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "43",
                            "monoisotopic_mass": "4387.9556",
                            "monoisotopic_mz": "1097.9962",
                            "intensity": "930.81",
                            "charge": "4"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "44",
                            "monoisotopic_mass": "4553.3486",
                            "monoisotopic_mz": "1139.3444",
                            "intensity": "928.16",
                            "charge": "4"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "45",
                            "monoisotopic_mass": "1093.4607",
                            "monoisotopic_mz": "1094.4680",
                            "intensity": "784.22",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "46",
                            "monoisotopic_mass": "20423.0189",
                            "monoisotopic_mz": "973.5320",
                            "intensity": "1316.26",
                            "charge": "21",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "20422.8016",
                                    "ion_position": "50",
                                    "ion_display_position": "196",
                                    "ion_sort_name": "Y00196",
                                    "ion_left_position": "50",
                                    "mass_error": "0.2173",
                                    "ppm": "10.64"
                                }
                            }
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "47",
                            "monoisotopic_mass": "2567.4823",
                            "monoisotopic_mz": "856.8347",
                            "intensity": "1253.88",
                            "charge": "3"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "48",
                            "monoisotopic_mass": "9657.8393",
                            "monoisotopic_mz": "1074.1005",
                            "intensity": "1434.18",
                            "charge": "9"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "49",
                            "monoisotopic_mass": "23368.0698",
                            "monoisotopic_mz": "1017.0103",
                            "intensity": "1275.64",
                            "charge": "23"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "50",
                            "monoisotopic_mass": "6483.5141",
                            "monoisotopic_mz": "1081.5930",
                            "intensity": "7341.41",
                            "charge": "6"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "51",
                            "monoisotopic_mass": "3575.8762",
                            "monoisotopic_mz": "894.9763",
                            "intensity": "1399.89",
                            "charge": "4"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "52",
                            "monoisotopic_mass": "2175.4842",
                            "monoisotopic_mz": "1088.7494",
                            "intensity": "1435.45",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "53",
                            "monoisotopic_mass": "1487.7981",
                            "monoisotopic_mz": "744.9063",
                            "intensity": "731.61",
                            "charge": "2"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "54",
                            "monoisotopic_mass": "808.5289",
                            "monoisotopic_mz": "809.5362",
                            "intensity": "1902.07",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "55",
                            "monoisotopic_mass": "834.0181",
                            "monoisotopic_mz": "835.0254",
                            "intensity": "1583.27",
                            "charge": "1"
                        },
                        {
                            "spec_id": "140",
                            "peak_id": "56",
                            "monoisotopic_mass": "1014.3692",
                            "monoisotopic_mz": "1015.3764",
                            "intensity": "924.77",
                            "charge": "1"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "16",
                "proteoform_id": "23",
                "sequence_name": "sp|Q46839|GLCA_ECOLI",
                "sequence_description": "Glycolate permease GlcA OS=Escherichia coli (strain K12) OX=83333 GN=glcA PE=1 SV=1",
                "proteoform_mass": "25946.9409",
                "n_acetylation": "0",
                "unexpected_shift_number": "0",
                "annotation": {
                    "protein_length": "560",
                    "first_residue_position": "314",
                    "last_residue_position": "559",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "V"
                        },
                        {
                            "position": "2",
                            "acid": "T"
                        },
                        {
                            "position": "3",
                            "acid": "W"
                        },
                        {
                            "position": "4",
                            "acid": "T"
                        },
                        {
                            "position": "5",
                            "acid": "Q"
                        },
                        {
                            "position": "6",
                            "acid": "M"
                        },
                        {
                            "position": "7",
                            "acid": "Y"
                        },
                        {
                            "position": "8",
                            "acid": "M"
                        },
                        {
                            "position": "9",
                            "acid": "P"
                        },
                        {
                            "position": "10",
                            "acid": "M"
                        },
                        {
                            "position": "11",
                            "acid": "G"
                        },
                        {
                            "position": "12",
                            "acid": "G"
                        },
                        {
                            "position": "13",
                            "acid": "L"
                        },
                        {
                            "position": "14",
                            "acid": "G"
                        },
                        {
                            "position": "15",
                            "acid": "L"
                        },
                        {
                            "position": "16",
                            "acid": "S"
                        },
                        {
                            "position": "17",
                            "acid": "A"
                        },
                        {
                            "position": "18",
                            "acid": "L"
                        },
                        {
                            "position": "19",
                            "acid": "V"
                        },
                        {
                            "position": "20",
                            "acid": "A"
                        },
                        {
                            "position": "21",
                            "acid": "L"
                        },
                        {
                            "position": "22",
                            "acid": "I"
                        },
                        {
                            "position": "23",
                            "acid": "P"
                        },
                        {
                            "position": "24",
                            "acid": "I"
                        },
                        {
                            "position": "25",
                            "acid": "I"
                        },
                        {
                            "position": "26",
                            "acid": "F"
                        },
                        {
                            "position": "27",
                            "acid": "F"
                        },
                        {
                            "position": "28",
                            "acid": "F"
                        },
                        {
                            "position": "29",
                            "acid": "V"
                        },
                        {
                            "position": "30",
                            "acid": "A"
                        },
                        {
                            "position": "31",
                            "acid": "L"
                        },
                        {
                            "position": "32",
                            "acid": "A"
                        },
                        {
                            "position": "33",
                            "acid": "V"
                        },
                        {
                            "position": "34",
                            "acid": "L"
                        },
                        {
                            "position": "35",
                            "acid": "R"
                        },
                        {
                            "position": "36",
                            "acid": "L"
                        },
                        {
                            "position": "37",
                            "acid": "K"
                        },
                        {
                            "position": "38",
                            "acid": "G"
                        },
                        {
                            "position": "39",
                            "acid": "H"
                        },
                        {
                            "position": "40",
                            "acid": "V"
                        },
                        {
                            "position": "41",
                            "acid": "A"
                        },
                        {
                            "position": "42",
                            "acid": "G"
                        },
                        {
                            "position": "43",
                            "acid": "A"
                        },
                        {
                            "position": "44",
                            "acid": "I"
                        },
                        {
                            "position": "45",
                            "acid": "T"
                        },
                        {
                            "position": "46",
                            "acid": "L"
                        },
                        {
                            "position": "47",
                            "acid": "I"
                        },
                        {
                            "position": "48",
                            "acid": "L"
                        },
                        {
                            "position": "49",
                            "acid": "S"
                        },
                        {
                            "position": "50",
                            "acid": "I"
                        },
                        {
                            "position": "51",
                            "acid": "L"
                        },
                        {
                            "position": "52",
                            "acid": "I"
                        },
                        {
                            "position": "53",
                            "acid": "A"
                        },
                        {
                            "position": "54",
                            "acid": "I"
                        },
                        {
                            "position": "55",
                            "acid": "F"
                        },
                        {
                            "position": "56",
                            "acid": "A"
                        },
                        {
                            "position": "57",
                            "acid": "F"
                        },
                        {
                            "position": "58",
                            "acid": "K"
                        },
                        {
                            "position": "59",
                            "acid": "M"
                        },
                        {
                            "position": "60",
                            "acid": "P"
                        },
                        {
                            "position": "61",
                            "acid": "I"
                        },
                        {
                            "position": "62",
                            "acid": "D"
                        },
                        {
                            "position": "63",
                            "acid": "M"
                        },
                        {
                            "position": "64",
                            "acid": "A"
                        },
                        {
                            "position": "65",
                            "acid": "F"
                        },
                        {
                            "position": "66",
                            "acid": "A"
                        },
                        {
                            "position": "67",
                            "acid": "A"
                        },
                        {
                            "position": "68",
                            "acid": "A"
                        },
                        {
                            "position": "69",
                            "acid": "G"
                        },
                        {
                            "position": "70",
                            "acid": "Y"
                        },
                        {
                            "position": "71",
                            "acid": "G"
                        },
                        {
                            "position": "72",
                            "acid": "F"
                        },
                        {
                            "position": "73",
                            "acid": "I"
                        },
                        {
                            "position": "74",
                            "acid": "Y"
                        },
                        {
                            "position": "75",
                            "acid": "G"
                        },
                        {
                            "position": "76",
                            "acid": "L"
                        },
                        {
                            "position": "77",
                            "acid": "W"
                        },
                        {
                            "position": "78",
                            "acid": "P"
                        },
                        {
                            "position": "79",
                            "acid": "I"
                        },
                        {
                            "position": "80",
                            "acid": "A"
                        },
                        {
                            "position": "81",
                            "acid": "W"
                        },
                        {
                            "position": "82",
                            "acid": "I"
                        },
                        {
                            "position": "83",
                            "acid": "I"
                        },
                        {
                            "position": "84",
                            "acid": "V"
                        },
                        {
                            "position": "85",
                            "acid": "A"
                        },
                        {
                            "position": "86",
                            "acid": "A"
                        },
                        {
                            "position": "87",
                            "acid": "V"
                        },
                        {
                            "position": "88",
                            "acid": "F"
                        },
                        {
                            "position": "89",
                            "acid": "L"
                        },
                        {
                            "position": "90",
                            "acid": "Y"
                        },
                        {
                            "position": "91",
                            "acid": "K"
                        },
                        {
                            "position": "92",
                            "acid": "L"
                        },
                        {
                            "position": "93",
                            "acid": "T"
                        },
                        {
                            "position": "94",
                            "acid": "V"
                        },
                        {
                            "position": "95",
                            "acid": "A"
                        },
                        {
                            "position": "96",
                            "acid": "S"
                        },
                        {
                            "position": "97",
                            "acid": "G"
                        },
                        {
                            "position": "98",
                            "acid": "Q"
                        },
                        {
                            "position": "99",
                            "acid": "F"
                        },
                        {
                            "position": "100",
                            "acid": "D"
                        },
                        {
                            "position": "101",
                            "acid": "I"
                        },
                        {
                            "position": "102",
                            "acid": "I"
                        },
                        {
                            "position": "103",
                            "acid": "R"
                        },
                        {
                            "position": "104",
                            "acid": "S"
                        },
                        {
                            "position": "105",
                            "acid": "S"
                        },
                        {
                            "position": "106",
                            "acid": "V"
                        },
                        {
                            "position": "107",
                            "acid": "I"
                        },
                        {
                            "position": "108",
                            "acid": "S"
                        },
                        {
                            "position": "109",
                            "acid": "I"
                        },
                        {
                            "position": "110",
                            "acid": "T"
                        },
                        {
                            "position": "111",
                            "acid": "D"
                        },
                        {
                            "position": "112",
                            "acid": "D"
                        },
                        {
                            "position": "113",
                            "acid": "Q"
                        },
                        {
                            "position": "114",
                            "acid": "R"
                        },
                        {
                            "position": "115",
                            "acid": "L"
                        },
                        {
                            "position": "116",
                            "acid": "Q"
                        },
                        {
                            "position": "117",
                            "acid": "V"
                        },
                        {
                            "position": "118",
                            "acid": "L"
                        },
                        {
                            "position": "119",
                            "acid": "L"
                        },
                        {
                            "position": "120",
                            "acid": "I"
                        },
                        {
                            "position": "121",
                            "acid": "G"
                        },
                        {
                            "position": "122",
                            "acid": "F"
                        },
                        {
                            "position": "123",
                            "acid": "S"
                        },
                        {
                            "position": "124",
                            "acid": "F"
                        },
                        {
                            "position": "125",
                            "acid": "G"
                        },
                        {
                            "position": "126",
                            "acid": "A"
                        },
                        {
                            "position": "127",
                            "acid": "L"
                        },
                        {
                            "position": "128",
                            "acid": "L"
                        },
                        {
                            "position": "129",
                            "acid": "E"
                        },
                        {
                            "position": "130",
                            "acid": "G"
                        },
                        {
                            "position": "131",
                            "acid": "A"
                        },
                        {
                            "position": "132",
                            "acid": "A"
                        },
                        {
                            "position": "133",
                            "acid": "G"
                        },
                        {
                            "position": "134",
                            "acid": "F"
                        },
                        {
                            "position": "135",
                            "acid": "G"
                        },
                        {
                            "position": "136",
                            "acid": "A"
                        },
                        {
                            "position": "137",
                            "acid": "P"
                        },
                        {
                            "position": "138",
                            "acid": "V"
                        },
                        {
                            "position": "139",
                            "acid": "A"
                        },
                        {
                            "position": "140",
                            "acid": "I"
                        },
                        {
                            "position": "141",
                            "acid": "T"
                        },
                        {
                            "position": "142",
                            "acid": "G"
                        },
                        {
                            "position": "143",
                            "acid": "A"
                        },
                        {
                            "position": "144",
                            "acid": "L"
                        },
                        {
                            "position": "145",
                            "acid": "L"
                        },
                        {
                            "position": "146",
                            "acid": "V"
                        },
                        {
                            "position": "147",
                            "acid": "G"
                        },
                        {
                            "position": "148",
                            "acid": "L"
                        },
                        {
                            "position": "149",
                            "acid": "G"
                        },
                        {
                            "position": "150",
                            "acid": "F"
                        },
                        {
                            "position": "151",
                            "acid": "K"
                        },
                        {
                            "position": "152",
                            "acid": "P"
                        },
                        {
                            "position": "153",
                            "acid": "L"
                        },
                        {
                            "position": "154",
                            "acid": "Y"
                        },
                        {
                            "position": "155",
                            "acid": "A"
                        },
                        {
                            "position": "156",
                            "acid": "A"
                        },
                        {
                            "position": "157",
                            "acid": "G"
                        },
                        {
                            "position": "158",
                            "acid": "L"
                        },
                        {
                            "position": "159",
                            "acid": "C"
                        },
                        {
                            "position": "160",
                            "acid": "L"
                        },
                        {
                            "position": "161",
                            "acid": "I"
                        },
                        {
                            "position": "162",
                            "acid": "A"
                        },
                        {
                            "position": "163",
                            "acid": "N"
                        },
                        {
                            "position": "164",
                            "acid": "T"
                        },
                        {
                            "position": "165",
                            "acid": "A"
                        },
                        {
                            "position": "166",
                            "acid": "P"
                        },
                        {
                            "position": "167",
                            "acid": "V"
                        },
                        {
                            "position": "168",
                            "acid": "A"
                        },
                        {
                            "position": "169",
                            "acid": "F"
                        },
                        {
                            "position": "170",
                            "acid": "G"
                        },
                        {
                            "position": "171",
                            "acid": "A"
                        },
                        {
                            "position": "172",
                            "acid": "L"
                        },
                        {
                            "position": "173",
                            "acid": "G"
                        },
                        {
                            "position": "174",
                            "acid": "V"
                        },
                        {
                            "position": "175",
                            "acid": "P"
                        },
                        {
                            "position": "176",
                            "acid": "I"
                        },
                        {
                            "position": "177",
                            "acid": "L"
                        },
                        {
                            "position": "178",
                            "acid": "V"
                        },
                        {
                            "position": "179",
                            "acid": "A"
                        },
                        {
                            "position": "180",
                            "acid": "G"
                        },
                        {
                            "position": "181",
                            "acid": "Q"
                        },
                        {
                            "position": "182",
                            "acid": "V"
                        },
                        {
                            "position": "183",
                            "acid": "T"
                        },
                        {
                            "position": "184",
                            "acid": "G"
                        },
                        {
                            "position": "185",
                            "acid": "I"
                        },
                        {
                            "position": "186",
                            "acid": "D"
                        },
                        {
                            "position": "187",
                            "acid": "P"
                        },
                        {
                            "position": "188",
                            "acid": "F"
                        },
                        {
                            "position": "189",
                            "acid": "H"
                        },
                        {
                            "position": "190",
                            "acid": "I"
                        },
                        {
                            "position": "191",
                            "acid": "G"
                        },
                        {
                            "position": "192",
                            "acid": "A"
                        },
                        {
                            "position": "193",
                            "acid": "M"
                        },
                        {
                            "position": "194",
                            "acid": "A"
                        },
                        {
                            "position": "195",
                            "acid": "G"
                        },
                        {
                            "position": "196",
                            "acid": "R"
                        },
                        {
                            "position": "197",
                            "acid": "Q"
                        },
                        {
                            "position": "198",
                            "acid": "L"
                        },
                        {
                            "position": "199",
                            "acid": "P"
                        },
                        {
                            "position": "200",
                            "acid": "F"
                        },
                        {
                            "position": "201",
                            "acid": "L"
                        },
                        {
                            "position": "202",
                            "acid": "S"
                        },
                        {
                            "position": "203",
                            "acid": "V"
                        },
                        {
                            "position": "204",
                            "acid": "L"
                        },
                        {
                            "position": "205",
                            "acid": "V"
                        },
                        {
                            "position": "206",
                            "acid": "P"
                        },
                        {
                            "position": "207",
                            "acid": "F"
                        },
                        {
                            "position": "208",
                            "acid": "W"
                        },
                        {
                            "position": "209",
                            "acid": "L"
                        },
                        {
                            "position": "210",
                            "acid": "V"
                        },
                        {
                            "position": "211",
                            "acid": "A"
                        },
                        {
                            "position": "212",
                            "acid": "M"
                        },
                        {
                            "position": "213",
                            "acid": "M"
                        },
                        {
                            "position": "214",
                            "acid": "D"
                        },
                        {
                            "position": "215",
                            "acid": "G"
                        },
                        {
                            "position": "216",
                            "acid": "W"
                        },
                        {
                            "position": "217",
                            "acid": "K"
                        },
                        {
                            "position": "218",
                            "acid": "G"
                        },
                        {
                            "position": "219",
                            "acid": "V"
                        },
                        {
                            "position": "220",
                            "acid": "K"
                        },
                        {
                            "position": "221",
                            "acid": "E"
                        },
                        {
                            "position": "222",
                            "acid": "T"
                        },
                        {
                            "position": "223",
                            "acid": "W"
                        },
                        {
                            "position": "224",
                            "acid": "P"
                        },
                        {
                            "position": "225",
                            "acid": "A"
                        },
                        {
                            "position": "226",
                            "acid": "A"
                        },
                        {
                            "position": "227",
                            "acid": "L"
                        },
                        {
                            "position": "228",
                            "acid": "V"
                        },
                        {
                            "position": "229",
                            "acid": "A"
                        },
                        {
                            "position": "230",
                            "acid": "G"
                        },
                        {
                            "position": "231",
                            "acid": "G"
                        },
                        {
                            "position": "232",
                            "acid": "S"
                        },
                        {
                            "position": "233",
                            "acid": "F"
                        },
                        {
                            "position": "234",
                            "acid": "A"
                        },
                        {
                            "position": "235",
                            "acid": "V"
                        },
                        {
                            "position": "236",
                            "acid": "T"
                        },
                        {
                            "position": "237",
                            "acid": "Q"
                        },
                        {
                            "position": "238",
                            "acid": "F"
                        },
                        {
                            "position": "239",
                            "acid": "F"
                        },
                        {
                            "position": "240",
                            "acid": "T"
                        },
                        {
                            "position": "241",
                            "acid": "S"
                        },
                        {
                            "position": "242",
                            "acid": "N"
                        },
                        {
                            "position": "243",
                            "acid": "Y"
                        },
                        {
                            "position": "244",
                            "acid": "I"
                        },
                        {
                            "position": "245",
                            "acid": "G"
                        },
                        {
                            "position": "246",
                            "acid": "P"
                        },
                        {
                            "position": "247",
                            "acid": "E"
                        },
                        {
                            "position": "248",
                            "acid": "L"
                        },
                        {
                            "position": "249",
                            "acid": "P"
                        },
                        {
                            "position": "250",
                            "acid": "D"
                        },
                        {
                            "position": "251",
                            "acid": "I"
                        },
                        {
                            "position": "252",
                            "acid": "T"
                        },
                        {
                            "position": "253",
                            "acid": "S"
                        },
                        {
                            "position": "254",
                            "acid": "A"
                        },
                        {
                            "position": "255",
                            "acid": "L"
                        },
                        {
                            "position": "256",
                            "acid": "V"
                        },
                        {
                            "position": "257",
                            "acid": "S"
                        },
                        {
                            "position": "258",
                            "acid": "I"
                        },
                        {
                            "position": "259",
                            "acid": "V"
                        },
                        {
                            "position": "260",
                            "acid": "S"
                        },
                        {
                            "position": "261",
                            "acid": "L"
                        },
                        {
                            "position": "262",
                            "acid": "A"
                        },
                        {
                            "position": "263",
                            "acid": "L"
                        },
                        {
                            "position": "264",
                            "acid": "F"
                        },
                        {
                            "position": "265",
                            "acid": "L"
                        },
                        {
                            "position": "266",
                            "acid": "K"
                        },
                        {
                            "position": "267",
                            "acid": "V"
                        },
                        {
                            "position": "268",
                            "acid": "W"
                        },
                        {
                            "position": "269",
                            "acid": "R"
                        },
                        {
                            "position": "270",
                            "acid": "P"
                        },
                        {
                            "position": "271",
                            "acid": "K"
                        },
                        {
                            "position": "272",
                            "acid": "N"
                        },
                        {
                            "position": "273",
                            "acid": "T"
                        },
                        {
                            "position": "274",
                            "acid": "E"
                        },
                        {
                            "position": "275",
                            "acid": "T"
                        },
                        {
                            "position": "276",
                            "acid": "A"
                        },
                        {
                            "position": "277",
                            "acid": "I"
                        },
                        {
                            "position": "278",
                            "acid": "S"
                        },
                        {
                            "position": "279",
                            "acid": "M"
                        },
                        {
                            "position": "280",
                            "acid": "G"
                        },
                        {
                            "position": "281",
                            "acid": "Q"
                        },
                        {
                            "position": "282",
                            "acid": "S"
                        },
                        {
                            "position": "283",
                            "acid": "A"
                        },
                        {
                            "position": "284",
                            "acid": "G"
                        },
                        {
                            "position": "285",
                            "acid": "A"
                        },
                        {
                            "position": "286",
                            "acid": "M"
                        },
                        {
                            "position": "287",
                            "acid": "V"
                        },
                        {
                            "position": "288",
                            "acid": "V"
                        },
                        {
                            "position": "289",
                            "acid": "N"
                        },
                        {
                            "position": "290",
                            "acid": "K"
                        },
                        {
                            "position": "291",
                            "acid": "P"
                        },
                        {
                            "position": "292",
                            "acid": "S"
                        },
                        {
                            "position": "293",
                            "acid": "S"
                        },
                        {
                            "position": "294",
                            "acid": "G"
                        },
                        {
                            "position": "295",
                            "acid": "G"
                        },
                        {
                            "position": "296",
                            "acid": "P"
                        },
                        {
                            "position": "297",
                            "acid": "V"
                        },
                        {
                            "position": "298",
                            "acid": "P"
                        },
                        {
                            "position": "299",
                            "acid": "S"
                        },
                        {
                            "position": "300",
                            "acid": "E"
                        },
                        {
                            "position": "301",
                            "acid": "Y"
                        },
                        {
                            "position": "302",
                            "acid": "S"
                        },
                        {
                            "position": "303",
                            "acid": "L"
                        },
                        {
                            "position": "304",
                            "acid": "G"
                        },
                        {
                            "position": "305",
                            "acid": "Q"
                        },
                        {
                            "position": "306",
                            "acid": "I"
                        },
                        {
                            "position": "307",
                            "acid": "I"
                        },
                        {
                            "position": "308",
                            "acid": "R"
                        },
                        {
                            "position": "309",
                            "acid": "A"
                        },
                        {
                            "position": "310",
                            "acid": "W"
                        },
                        {
                            "position": "311",
                            "acid": "S"
                        },
                        {
                            "position": "312",
                            "acid": "P"
                        },
                        {
                            "position": "313",
                            "acid": "F"
                        },
                        {
                            "position": "314",
                            "acid": "L"
                        },
                        {
                            "position": "315",
                            "acid": "I"
                        },
                        {
                            "position": "316",
                            "acid": "L"
                        },
                        {
                            "position": "317",
                            "acid": "T"
                        },
                        {
                            "position": "318",
                            "acid": "V"
                        },
                        {
                            "position": "319",
                            "acid": "L"
                        },
                        {
                            "position": "320",
                            "acid": "V"
                        },
                        {
                            "position": "321",
                            "acid": "T"
                        },
                        {
                            "position": "322",
                            "acid": "I"
                        },
                        {
                            "position": "323",
                            "acid": "W"
                        },
                        {
                            "position": "324",
                            "acid": "T"
                        },
                        {
                            "position": "325",
                            "acid": "M"
                        },
                        {
                            "position": "326",
                            "acid": "K"
                        },
                        {
                            "position": "327",
                            "acid": "P"
                        },
                        {
                            "position": "328",
                            "acid": "F"
                        },
                        {
                            "position": "329",
                            "acid": "K"
                        },
                        {
                            "position": "330",
                            "acid": "A"
                        },
                        {
                            "position": "331",
                            "acid": "L"
                        },
                        {
                            "position": "332",
                            "acid": "F"
                        },
                        {
                            "position": "333",
                            "acid": "A"
                        },
                        {
                            "position": "334",
                            "acid": "P"
                        },
                        {
                            "position": "335",
                            "acid": "G"
                        },
                        {
                            "position": "336",
                            "acid": "G"
                        },
                        {
                            "position": "337",
                            "acid": "A"
                        },
                        {
                            "position": "338",
                            "acid": "F"
                        },
                        {
                            "position": "339",
                            "acid": "Y"
                        },
                        {
                            "position": "340",
                            "acid": "S"
                        },
                        {
                            "position": "341",
                            "acid": "L"
                        },
                        {
                            "position": "342",
                            "acid": "V"
                        },
                        {
                            "position": "343",
                            "acid": "I"
                        },
                        {
                            "position": "344",
                            "acid": "N"
                        },
                        {
                            "position": "345",
                            "acid": "F"
                        },
                        {
                            "position": "346",
                            "acid": "Q"
                        },
                        {
                            "position": "347",
                            "acid": "I"
                        },
                        {
                            "position": "348",
                            "acid": "P"
                        },
                        {
                            "position": "349",
                            "acid": "H"
                        },
                        {
                            "position": "350",
                            "acid": "L"
                        },
                        {
                            "position": "351",
                            "acid": "H"
                        },
                        {
                            "position": "352",
                            "acid": "Q"
                        },
                        {
                            "position": "353",
                            "acid": "Q"
                        },
                        {
                            "position": "354",
                            "acid": "V"
                        },
                        {
                            "position": "355",
                            "acid": "L"
                        },
                        {
                            "position": "356",
                            "acid": "K"
                        },
                        {
                            "position": "357",
                            "acid": "A"
                        },
                        {
                            "position": "358",
                            "acid": "A"
                        },
                        {
                            "position": "359",
                            "acid": "P"
                        },
                        {
                            "position": "360",
                            "acid": "I"
                        },
                        {
                            "position": "361",
                            "acid": "V"
                        },
                        {
                            "position": "362",
                            "acid": "A"
                        },
                        {
                            "position": "363",
                            "acid": "Q"
                        },
                        {
                            "position": "364",
                            "acid": "P"
                        },
                        {
                            "position": "365",
                            "acid": "T"
                        },
                        {
                            "position": "366",
                            "acid": "P"
                        },
                        {
                            "position": "367",
                            "acid": "M"
                        },
                        {
                            "position": "368",
                            "acid": "D"
                        },
                        {
                            "position": "369",
                            "acid": "A"
                        },
                        {
                            "position": "370",
                            "acid": "V"
                        },
                        {
                            "position": "371",
                            "acid": "F"
                        },
                        {
                            "position": "372",
                            "acid": "K"
                        },
                        {
                            "position": "373",
                            "acid": "F"
                        },
                        {
                            "position": "374",
                            "acid": "D"
                        },
                        {
                            "position": "375",
                            "acid": "P"
                        },
                        {
                            "position": "376",
                            "acid": "L"
                        },
                        {
                            "position": "377",
                            "acid": "S"
                        },
                        {
                            "position": "378",
                            "acid": "A"
                        },
                        {
                            "position": "379",
                            "acid": "G"
                        },
                        {
                            "position": "380",
                            "acid": "G"
                        },
                        {
                            "position": "381",
                            "acid": "T"
                        },
                        {
                            "position": "382",
                            "acid": "A"
                        },
                        {
                            "position": "383",
                            "acid": "I"
                        },
                        {
                            "position": "384",
                            "acid": "F"
                        },
                        {
                            "position": "385",
                            "acid": "I"
                        },
                        {
                            "position": "386",
                            "acid": "A"
                        },
                        {
                            "position": "387",
                            "acid": "A"
                        },
                        {
                            "position": "388",
                            "acid": "I"
                        },
                        {
                            "position": "389",
                            "acid": "I"
                        },
                        {
                            "position": "390",
                            "acid": "S"
                        },
                        {
                            "position": "391",
                            "acid": "I"
                        },
                        {
                            "position": "392",
                            "acid": "F"
                        },
                        {
                            "position": "393",
                            "acid": "I"
                        },
                        {
                            "position": "394",
                            "acid": "L"
                        },
                        {
                            "position": "395",
                            "acid": "G"
                        },
                        {
                            "position": "396",
                            "acid": "V"
                        },
                        {
                            "position": "397",
                            "acid": "G"
                        },
                        {
                            "position": "398",
                            "acid": "I"
                        },
                        {
                            "position": "399",
                            "acid": "K"
                        },
                        {
                            "position": "400",
                            "acid": "K"
                        },
                        {
                            "position": "401",
                            "acid": "G"
                        },
                        {
                            "position": "402",
                            "acid": "I"
                        },
                        {
                            "position": "403",
                            "acid": "G"
                        },
                        {
                            "position": "404",
                            "acid": "V"
                        },
                        {
                            "position": "405",
                            "acid": "F"
                        },
                        {
                            "position": "406",
                            "acid": "A"
                        },
                        {
                            "position": "407",
                            "acid": "E"
                        },
                        {
                            "position": "408",
                            "acid": "T"
                        },
                        {
                            "position": "409",
                            "acid": "L"
                        },
                        {
                            "position": "410",
                            "acid": "I"
                        },
                        {
                            "position": "411",
                            "acid": "S"
                        },
                        {
                            "position": "412",
                            "acid": "L"
                        },
                        {
                            "position": "413",
                            "acid": "K"
                        },
                        {
                            "position": "414",
                            "acid": "W"
                        },
                        {
                            "position": "415",
                            "acid": "P"
                        },
                        {
                            "position": "416",
                            "acid": "I"
                        },
                        {
                            "position": "417",
                            "acid": "L"
                        },
                        {
                            "position": "418",
                            "acid": "S"
                        },
                        {
                            "position": "419",
                            "acid": "I"
                        },
                        {
                            "position": "420",
                            "acid": "G"
                        },
                        {
                            "position": "421",
                            "acid": "M"
                        },
                        {
                            "position": "422",
                            "acid": "V"
                        },
                        {
                            "position": "423",
                            "acid": "L"
                        },
                        {
                            "position": "424",
                            "acid": "A"
                        },
                        {
                            "position": "425",
                            "acid": "F"
                        },
                        {
                            "position": "426",
                            "acid": "A"
                        },
                        {
                            "position": "427",
                            "acid": "F"
                        },
                        {
                            "position": "428",
                            "acid": "V"
                        },
                        {
                            "position": "429",
                            "acid": "T"
                        },
                        {
                            "position": "430",
                            "acid": "N"
                        },
                        {
                            "position": "431",
                            "acid": "Y"
                        },
                        {
                            "position": "432",
                            "acid": "S"
                        },
                        {
                            "position": "433",
                            "acid": "G"
                        },
                        {
                            "position": "434",
                            "acid": "M"
                        },
                        {
                            "position": "435",
                            "acid": "S"
                        },
                        {
                            "position": "436",
                            "acid": "T"
                        },
                        {
                            "position": "437",
                            "acid": "T"
                        },
                        {
                            "position": "438",
                            "acid": "L"
                        },
                        {
                            "position": "439",
                            "acid": "A"
                        },
                        {
                            "position": "440",
                            "acid": "L"
                        },
                        {
                            "position": "441",
                            "acid": "V"
                        },
                        {
                            "position": "442",
                            "acid": "L"
                        },
                        {
                            "position": "443",
                            "acid": "A"
                        },
                        {
                            "position": "444",
                            "acid": "G"
                        },
                        {
                            "position": "445",
                            "acid": "T"
                        },
                        {
                            "position": "446",
                            "acid": "G"
                        },
                        {
                            "position": "447",
                            "acid": "V"
                        },
                        {
                            "position": "448",
                            "acid": "M"
                        },
                        {
                            "position": "449",
                            "acid": "F"
                        },
                        {
                            "position": "450",
                            "acid": "P"
                        },
                        {
                            "position": "451",
                            "acid": "F"
                        },
                        {
                            "position": "452",
                            "acid": "F"
                        },
                        {
                            "position": "453",
                            "acid": "S"
                        },
                        {
                            "position": "454",
                            "acid": "P"
                        },
                        {
                            "position": "455",
                            "acid": "F"
                        },
                        {
                            "position": "456",
                            "acid": "L"
                        },
                        {
                            "position": "457",
                            "acid": "G"
                        },
                        {
                            "position": "458",
                            "acid": "W"
                        },
                        {
                            "position": "459",
                            "acid": "L"
                        },
                        {
                            "position": "460",
                            "acid": "G"
                        },
                        {
                            "position": "461",
                            "acid": "V"
                        },
                        {
                            "position": "462",
                            "acid": "F"
                        },
                        {
                            "position": "463",
                            "acid": "L"
                        },
                        {
                            "position": "464",
                            "acid": "T"
                        },
                        {
                            "position": "465",
                            "acid": "G"
                        },
                        {
                            "position": "466",
                            "acid": "S"
                        },
                        {
                            "position": "467",
                            "acid": "D"
                        },
                        {
                            "position": "468",
                            "acid": "T"
                        },
                        {
                            "position": "469",
                            "acid": "S"
                        },
                        {
                            "position": "470",
                            "acid": "S"
                        },
                        {
                            "position": "471",
                            "acid": "N"
                        },
                        {
                            "position": "472",
                            "acid": "A"
                        },
                        {
                            "position": "473",
                            "acid": "L"
                        },
                        {
                            "position": "474",
                            "acid": "F"
                        },
                        {
                            "position": "475",
                            "acid": "G"
                        },
                        {
                            "position": "476",
                            "acid": "S"
                        },
                        {
                            "position": "477",
                            "acid": "L"
                        },
                        {
                            "position": "478",
                            "acid": "Q"
                        },
                        {
                            "position": "479",
                            "acid": "S"
                        },
                        {
                            "position": "480",
                            "acid": "T"
                        },
                        {
                            "position": "481",
                            "acid": "T"
                        },
                        {
                            "position": "482",
                            "acid": "A"
                        },
                        {
                            "position": "483",
                            "acid": "Q"
                        },
                        {
                            "position": "484",
                            "acid": "Q"
                        },
                        {
                            "position": "485",
                            "acid": "I"
                        },
                        {
                            "position": "486",
                            "acid": "N"
                        },
                        {
                            "position": "487",
                            "acid": "V"
                        },
                        {
                            "position": "488",
                            "acid": "S"
                        },
                        {
                            "position": "489",
                            "acid": "D"
                        },
                        {
                            "position": "490",
                            "acid": "T"
                        },
                        {
                            "position": "491",
                            "acid": "L"
                        },
                        {
                            "position": "492",
                            "acid": "L"
                        },
                        {
                            "position": "493",
                            "acid": "V"
                        },
                        {
                            "position": "494",
                            "acid": "A"
                        },
                        {
                            "position": "495",
                            "acid": "A"
                        },
                        {
                            "position": "496",
                            "acid": "N"
                        },
                        {
                            "position": "497",
                            "acid": "T"
                        },
                        {
                            "position": "498",
                            "acid": "S"
                        },
                        {
                            "position": "499",
                            "acid": "G"
                        },
                        {
                            "position": "500",
                            "acid": "G"
                        },
                        {
                            "position": "501",
                            "acid": "V"
                        },
                        {
                            "position": "502",
                            "acid": "T"
                        },
                        {
                            "position": "503",
                            "acid": "G"
                        },
                        {
                            "position": "504",
                            "acid": "K"
                        },
                        {
                            "position": "505",
                            "acid": "M"
                        },
                        {
                            "position": "506",
                            "acid": "I"
                        },
                        {
                            "position": "507",
                            "acid": "S"
                        },
                        {
                            "position": "508",
                            "acid": "P"
                        },
                        {
                            "position": "509",
                            "acid": "Q"
                        },
                        {
                            "position": "510",
                            "acid": "S"
                        },
                        {
                            "position": "511",
                            "acid": "I"
                        },
                        {
                            "position": "512",
                            "acid": "A"
                        },
                        {
                            "position": "513",
                            "acid": "V"
                        },
                        {
                            "position": "514",
                            "acid": "A"
                        },
                        {
                            "position": "515",
                            "acid": "C"
                        },
                        {
                            "position": "516",
                            "acid": "A"
                        },
                        {
                            "position": "517",
                            "acid": "A"
                        },
                        {
                            "position": "518",
                            "acid": "T"
                        },
                        {
                            "position": "519",
                            "acid": "G"
                        },
                        {
                            "position": "520",
                            "acid": "M"
                        },
                        {
                            "position": "521",
                            "acid": "V"
                        },
                        {
                            "position": "522",
                            "acid": "G"
                        },
                        {
                            "position": "523",
                            "acid": "R"
                        },
                        {
                            "position": "524",
                            "acid": "E"
                        },
                        {
                            "position": "525",
                            "acid": "S"
                        },
                        {
                            "position": "526",
                            "acid": "E"
                        },
                        {
                            "position": "527",
                            "acid": "L"
                        },
                        {
                            "position": "528",
                            "acid": "F"
                        },
                        {
                            "position": "529",
                            "acid": "R"
                        },
                        {
                            "position": "530",
                            "acid": "Y"
                        },
                        {
                            "position": "531",
                            "acid": "T"
                        },
                        {
                            "position": "532",
                            "acid": "V"
                        },
                        {
                            "position": "533",
                            "acid": "K"
                        },
                        {
                            "position": "534",
                            "acid": "H"
                        },
                        {
                            "position": "535",
                            "acid": "S"
                        },
                        {
                            "position": "536",
                            "acid": "L"
                        },
                        {
                            "position": "537",
                            "acid": "I"
                        },
                        {
                            "position": "538",
                            "acid": "F"
                        },
                        {
                            "position": "539",
                            "acid": "A"
                        },
                        {
                            "position": "540",
                            "acid": "S"
                        },
                        {
                            "position": "541",
                            "acid": "V"
                        },
                        {
                            "position": "542",
                            "acid": "I"
                        },
                        {
                            "position": "543",
                            "acid": "G"
                        },
                        {
                            "position": "544",
                            "acid": "I"
                        },
                        {
                            "position": "545",
                            "acid": "I"
                        },
                        {
                            "position": "546",
                            "acid": "T"
                        },
                        {
                            "position": "547",
                            "acid": "L"
                        },
                        {
                            "position": "548",
                            "acid": "L"
                        },
                        {
                            "position": "549",
                            "acid": "Q"
                        },
                        {
                            "position": "550",
                            "acid": "A"
                        },
                        {
                            "position": "551",
                            "acid": "Y"
                        },
                        {
                            "position": "552",
                            "acid": "V"
                        },
                        {
                            "position": "553",
                            "acid": "F"
                        },
                        {
                            "position": "554",
                            "acid": "T"
                        },
                        {
                            "position": "555",
                            "acid": "G"
                        },
                        {
                            "position": "556",
                            "acid": "M"
                        },
                        {
                            "position": "557",
                            "acid": "L"
                        },
                        {
                            "position": "558",
                            "acid": "V"
                        },
                        {
                            "position": "559",
                            "acid": "S"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "140",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "141",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "142",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "143",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "144",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "145",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "146",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "147",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "148",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "149",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "150",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "151",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "152",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "153",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "154",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "155",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "156",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "157",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "158",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "159",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "160",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "161",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "162",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "163",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "164",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "165",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "166",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "167",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "168",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "169",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "170",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "171",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "172",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "173",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "174",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "175",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "176",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "177",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "178",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "179",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "180",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "181",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "182",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "183",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "184",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "185",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "186",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "187",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "188",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "189",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "190",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "191",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "192",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "193",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "194",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "195",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "196",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "197",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "198",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "199",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "200",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "201",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "202",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "203",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "204",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "205",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "206",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "207",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "208",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "209",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "210",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "211",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "212",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "213",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "214",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "215",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "216",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "217",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "218",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "219",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "220",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "221",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "222",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "223",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "224",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "225",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "226",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "227",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "228",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "229",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "230",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "231",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "232",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "233",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "234",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "235",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "236",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "237",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "238",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "239",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "240",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "241",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "242",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "243",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "244",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "245",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "246",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "247",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "248",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "249",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "250",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "251",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "252",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "253",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "254",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "255",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "256",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "257",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "258",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "259",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "260",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "261",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "262",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "263",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "264",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "265",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "266",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "267",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "268",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "269",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "270",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "271",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "272",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "273",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "274",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "275",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "276",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "277",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "278",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "279",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "280",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "281",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "282",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "283",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "284",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "285",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "286",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "287",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "288",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "289",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "290",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "291",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "292",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "293",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "294",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "295",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "296",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "297",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "298",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "299",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "300",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "301",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "302",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "303",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "304",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "305",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "306",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "307",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "308",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "309",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "310",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "311",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "312",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "313",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "314",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "315",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "316",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "317",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "318",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "319",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "320",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "321",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "322",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "323",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "324",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "325",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "326",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "327",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "328",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "329",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "330",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "331",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "332",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "333",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "334",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "335",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "336",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "337",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "338",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "339",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "340",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "341",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "342",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "343",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "344",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "345",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "346",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "347",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "348",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "349",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "350",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "351",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "352",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "353",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "354",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "355",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "356",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "357",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "358",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "359",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "360",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "361",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "362",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "363",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "364",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "50",
                                    "ion_display_position": "196",
                                    "spec_id": "140",
                                    "peak_id": "46",
                                    "peak_charge": "21"
                                }
                            }
                        },
                        {
                            "position": "365",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "366",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "367",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "368",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "369",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "370",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "371",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "372",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "373",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "374",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "375",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "376",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "377",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "378",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "379",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "380",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "381",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "382",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "383",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "384",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "385",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "386",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "387",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "388",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "389",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "390",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "391",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "392",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "393",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "394",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "395",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "396",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "397",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "398",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "399",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "400",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "401",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "402",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "403",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "404",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "405",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "406",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "407",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "408",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "409",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "410",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "411",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "412",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "413",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "414",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "415",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "416",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "417",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "418",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "419",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "420",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "421",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "422",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "423",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "424",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "425",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "426",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "427",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "428",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "429",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "430",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "431",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "432",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "433",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "434",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "120",
                                    "ion_display_position": "120",
                                    "spec_id": "140",
                                    "peak_id": "30",
                                    "peak_charge": "15"
                                }
                            }
                        },
                        {
                            "position": "435",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "436",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "437",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "438",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "439",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "440",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "441",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "442",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "443",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "444",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "445",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "446",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "132",
                                    "ion_display_position": "114",
                                    "spec_id": "140",
                                    "peak_id": "17",
                                    "peak_charge": "12"
                                }
                            }
                        },
                        {
                            "position": "447",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "448",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "449",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "450",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "451",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "452",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "453",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "454",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "455",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "456",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "457",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "458",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "459",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "460",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "461",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "462",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "463",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "464",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "465",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "466",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "467",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "468",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "469",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "470",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "471",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "472",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "473",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "474",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "475",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "476",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "477",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "478",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "479",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "480",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "481",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "482",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "483",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "484",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "485",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "486",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "487",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "488",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "489",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "490",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "491",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "492",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "493",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "494",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "495",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "496",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "497",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "498",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "499",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "500",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "501",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "502",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "503",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "504",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "505",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "506",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "507",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "508",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "509",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "510",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "511",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "512",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "198",
                                    "ion_display_position": "48",
                                    "spec_id": "140",
                                    "peak_id": "0",
                                    "peak_charge": "6"
                                }
                            }
                        },
                        {
                            "position": "513",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "514",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "515",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "516",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "517",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "518",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "519",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "520",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "521",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "522",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "523",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "524",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "525",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "526",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "527",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "528",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "529",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "530",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "531",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "532",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "533",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "534",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "535",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "536",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "537",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "538",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "539",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "540",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "541",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "542",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "543",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "544",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "545",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "546",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "547",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "548",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "549",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "550",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "551",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "552",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "553",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "554",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "555",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "556",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "557",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "558",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "559",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "245",
                                    "ion_display_position": "245",
                                    "spec_id": "140",
                                    "peak_id": "28",
                                    "peak_charge": "29"
                                }
                            }
                        },
                        {
                            "position": "560",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Fixed",
                        "ptm": {
                            "abbreviation": "Carbamidomethylation",
                            "unimod": "-1",
                            "mono_mass": "57.0214640000"
                        },
                        "occurence": {
                            "left_pos": "515",
                            "right_pos": "516",
                            "anno": "C"
                        }
                    }
                }
            }
        }
    }
}
