prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "14",
        "sequence_name": "sp|P0A8J2|DNAT_ECOLI",
        "sequence_description": "Primosomal protein 1 OS=Escherichia coli (strain K12) OX=83333 GN=dnaT PE=1 SV=2",
        "proteoform_id": "20",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "131",
            "p_value": "0.16",
            "e_value": "0.18",
            "fdr": "4.31e-03",
            "matched_fragment_number": "5",
            "matched_peak_number": "5",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "ecoli_2_ms2.msalign",
                    "ms1_ids": "113",
                    "ms1_scans": "291",
                    "ids": "179",
                    "scans": "294",
                    "precursor_mono_mass": "9112.7048",
                    "precursor_charge": "11",
                    "precursor_mz": "829.4350",
                    "feature_inte": "4.5700e+07"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "179",
                            "peak_id": "0",
                            "monoisotopic_mass": "2767.3974",
                            "monoisotopic_mz": "923.4731",
                            "intensity": "5485.48",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "1",
                            "monoisotopic_mass": "2453.1908",
                            "monoisotopic_mz": "818.7375",
                            "intensity": "4335.67",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "2",
                            "monoisotopic_mass": "5133.5475",
                            "monoisotopic_mz": "856.5985",
                            "intensity": "4351.25",
                            "charge": "6"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "3",
                            "monoisotopic_mass": "2825.2384",
                            "monoisotopic_mz": "942.7534",
                            "intensity": "2516.96",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "4",
                            "monoisotopic_mass": "2031.0799",
                            "monoisotopic_mz": "1016.5472",
                            "intensity": "3336.28",
                            "charge": "2"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "5",
                            "monoisotopic_mass": "4245.2325",
                            "monoisotopic_mz": "850.0538",
                            "intensity": "1069.08",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "6",
                            "monoisotopic_mass": "5197.8288",
                            "monoisotopic_mz": "867.3121",
                            "intensity": "998.03",
                            "charge": "6"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "7",
                            "monoisotopic_mass": "889.4396",
                            "monoisotopic_mz": "890.4469",
                            "intensity": "1535.70",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "8",
                            "monoisotopic_mass": "7668.9776",
                            "monoisotopic_mz": "959.6295",
                            "intensity": "940.79",
                            "charge": "8"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "9",
                            "monoisotopic_mass": "4116.2114",
                            "monoisotopic_mz": "824.2496",
                            "intensity": "1044.73",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "10",
                            "monoisotopic_mass": "827.4300",
                            "monoisotopic_mz": "828.4373",
                            "intensity": "1590.56",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "11",
                            "monoisotopic_mass": "909.9258",
                            "monoisotopic_mz": "910.9331",
                            "intensity": "1334.55",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "12",
                            "monoisotopic_mass": "2454.1940",
                            "monoisotopic_mz": "1228.1043",
                            "intensity": "1724.46",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2454.2101",
                                    "ion_position": "64",
                                    "ion_display_position": "23",
                                    "ion_sort_name": "Y00023",
                                    "ion_left_position": "64",
                                    "mass_error": "-0.0161",
                                    "ppm": "-6.57"
                                }
                            }
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "13",
                            "monoisotopic_mass": "2844.8147",
                            "monoisotopic_mz": "949.2789",
                            "intensity": "1158.12",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "14",
                            "monoisotopic_mass": "7974.2128",
                            "monoisotopic_mz": "887.0309",
                            "intensity": "1296.44",
                            "charge": "9"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "15",
                            "monoisotopic_mass": "3786.3900",
                            "monoisotopic_mz": "947.6048",
                            "intensity": "1048.85",
                            "charge": "4"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "16",
                            "monoisotopic_mass": "7947.1493",
                            "monoisotopic_mz": "994.4009",
                            "intensity": "3286.23",
                            "charge": "8",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "7947.1487",
                                    "ion_position": "75",
                                    "ion_display_position": "75",
                                    "ion_sort_name": "B00075",
                                    "ion_left_position": "75",
                                    "mass_error": "0.0006",
                                    "ppm": "0.07"
                                }
                            }
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "17",
                            "monoisotopic_mass": "873.5822",
                            "monoisotopic_mz": "874.5895",
                            "intensity": "1221.82",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "18",
                            "monoisotopic_mass": "947.6405",
                            "monoisotopic_mz": "948.6478",
                            "intensity": "1904.07",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "19",
                            "monoisotopic_mass": "5150.7341",
                            "monoisotopic_mz": "859.4630",
                            "intensity": "2715.57",
                            "charge": "6",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5150.7305",
                                    "ion_position": "50",
                                    "ion_display_position": "50",
                                    "ion_sort_name": "B00050",
                                    "ion_left_position": "50",
                                    "mass_error": "0.0035",
                                    "ppm": "0.69"
                                }
                            }
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "20",
                            "monoisotopic_mass": "7355.4526",
                            "monoisotopic_mz": "920.4389",
                            "intensity": "2427.98",
                            "charge": "8"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "21",
                            "monoisotopic_mass": "6834.7692",
                            "monoisotopic_mz": "977.4029",
                            "intensity": "2891.32",
                            "charge": "7"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "22",
                            "monoisotopic_mass": "922.9726",
                            "monoisotopic_mz": "923.9799",
                            "intensity": "1135.22",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "23",
                            "monoisotopic_mass": "845.3742",
                            "monoisotopic_mz": "846.3815",
                            "intensity": "2216.03",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "24",
                            "monoisotopic_mass": "1012.6233",
                            "monoisotopic_mz": "1013.6306",
                            "intensity": "1884.19",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "25",
                            "monoisotopic_mass": "2651.3788",
                            "monoisotopic_mz": "884.8002",
                            "intensity": "2379.40",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "26",
                            "monoisotopic_mass": "4511.3592",
                            "monoisotopic_mz": "903.2791",
                            "intensity": "2204.59",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "27",
                            "monoisotopic_mass": "5337.9089",
                            "monoisotopic_mz": "890.6588",
                            "intensity": "1055.35",
                            "charge": "6"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "28",
                            "monoisotopic_mass": "4616.0360",
                            "monoisotopic_mz": "924.2145",
                            "intensity": "1874.71",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "29",
                            "monoisotopic_mass": "3501.8233",
                            "monoisotopic_mz": "876.4631",
                            "intensity": "1176.06",
                            "charge": "4"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "30",
                            "monoisotopic_mass": "5290.7190",
                            "monoisotopic_mz": "882.7938",
                            "intensity": "950.62",
                            "charge": "6",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "5289.7748",
                                    "ion_position": "37",
                                    "ion_display_position": "50",
                                    "ion_sort_name": "Y00050",
                                    "ion_left_position": "37",
                                    "mass_error": "-0.0582",
                                    "ppm": "-11.00"
                                }
                            }
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "31",
                            "monoisotopic_mass": "1087.8869",
                            "monoisotopic_mz": "1088.8942",
                            "intensity": "746.46",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "32",
                            "monoisotopic_mass": "987.3427",
                            "monoisotopic_mz": "988.3500",
                            "intensity": "846.81",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "33",
                            "monoisotopic_mass": "7455.0627",
                            "monoisotopic_mz": "829.3476",
                            "intensity": "2989.29",
                            "charge": "9"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "34",
                            "monoisotopic_mass": "2620.4030",
                            "monoisotopic_mz": "874.4750",
                            "intensity": "1067.84",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "35",
                            "monoisotopic_mass": "2871.4743",
                            "monoisotopic_mz": "958.1654",
                            "intensity": "1683.34",
                            "charge": "3"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "36",
                            "monoisotopic_mass": "1779.5525",
                            "monoisotopic_mz": "890.7835",
                            "intensity": "2963.32",
                            "charge": "2"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "37",
                            "monoisotopic_mass": "3566.7810",
                            "monoisotopic_mz": "892.7025",
                            "intensity": "1538.51",
                            "charge": "4"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "38",
                            "monoisotopic_mass": "5153.7441",
                            "monoisotopic_mz": "1031.7561",
                            "intensity": "1712.26",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "39",
                            "monoisotopic_mass": "6633.1880",
                            "monoisotopic_mz": "830.1558",
                            "intensity": "2354.16",
                            "charge": "8"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "40",
                            "monoisotopic_mass": "3292.7688",
                            "monoisotopic_mz": "824.1995",
                            "intensity": "2581.25",
                            "charge": "4"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "41",
                            "monoisotopic_mass": "7348.7686",
                            "monoisotopic_mz": "1050.8314",
                            "intensity": "2085.59",
                            "charge": "7"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "42",
                            "monoisotopic_mass": "1051.5554",
                            "monoisotopic_mz": "1052.5627",
                            "intensity": "1050.24",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "43",
                            "monoisotopic_mass": "4351.1794",
                            "monoisotopic_mz": "871.2432",
                            "intensity": "2373.46",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "44",
                            "monoisotopic_mass": "4486.8597",
                            "monoisotopic_mz": "898.3792",
                            "intensity": "3286.91",
                            "charge": "5"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "45",
                            "monoisotopic_mass": "6930.6324",
                            "monoisotopic_mz": "991.0976",
                            "intensity": "3793.26",
                            "charge": "7",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6930.6634",
                                    "ion_position": "20",
                                    "ion_display_position": "67",
                                    "ion_sort_name": "Y00067",
                                    "ion_left_position": "20",
                                    "mass_error": "-0.0310",
                                    "ppm": "-4.48"
                                }
                            }
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "46",
                            "monoisotopic_mass": "6204.4152",
                            "monoisotopic_mz": "887.3523",
                            "intensity": "1970.19",
                            "charge": "7"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "47",
                            "monoisotopic_mass": "1112.5739",
                            "monoisotopic_mz": "1113.5812",
                            "intensity": "810.07",
                            "charge": "1"
                        },
                        {
                            "spec_id": "179",
                            "peak_id": "48",
                            "monoisotopic_mass": "1029.5571",
                            "monoisotopic_mz": "1030.5644",
                            "intensity": "1120.35",
                            "charge": "1"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "14",
                "proteoform_id": "20",
                "sequence_name": "sp|P0A8J2|DNAT_ECOLI",
                "sequence_description": "Primosomal protein 1 OS=Escherichia coli (strain K12) OX=83333 GN=dnaT PE=1 SV=2",
                "proteoform_mass": "9111.7812",
                "n_acetylation": "1",
                "unexpected_shift_number": "0",
                "annotation": {
                    "protein_length": "179",
                    "first_residue_position": "1",
                    "last_residue_position": "87",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "S"
                        },
                        {
                            "position": "2",
                            "acid": "S"
                        },
                        {
                            "position": "3",
                            "acid": "R"
                        },
                        {
                            "position": "4",
                            "acid": "V"
                        },
                        {
                            "position": "5",
                            "acid": "L"
                        },
                        {
                            "position": "6",
                            "acid": "T"
                        },
                        {
                            "position": "7",
                            "acid": "P"
                        },
                        {
                            "position": "8",
                            "acid": "D"
                        },
                        {
                            "position": "9",
                            "acid": "V"
                        },
                        {
                            "position": "10",
                            "acid": "V"
                        },
                        {
                            "position": "11",
                            "acid": "G"
                        },
                        {
                            "position": "12",
                            "acid": "I"
                        },
                        {
                            "position": "13",
                            "acid": "D"
                        },
                        {
                            "position": "14",
                            "acid": "A"
                        },
                        {
                            "position": "15",
                            "acid": "L"
                        },
                        {
                            "position": "16",
                            "acid": "V"
                        },
                        {
                            "position": "17",
                            "acid": "H"
                        },
                        {
                            "position": "18",
                            "acid": "D"
                        },
                        {
                            "position": "19",
                            "acid": "H"
                        },
                        {
                            "position": "20",
                            "acid": "Q"
                        },
                        {
                            "position": "21",
                            "acid": "T"
                        },
                        {
                            "position": "22",
                            "acid": "V"
                        },
                        {
                            "position": "23",
                            "acid": "L"
                        },
                        {
                            "position": "24",
                            "acid": "A"
                        },
                        {
                            "position": "25",
                            "acid": "K"
                        },
                        {
                            "position": "26",
                            "acid": "A"
                        },
                        {
                            "position": "27",
                            "acid": "E"
                        },
                        {
                            "position": "28",
                            "acid": "G"
                        },
                        {
                            "position": "29",
                            "acid": "G"
                        },
                        {
                            "position": "30",
                            "acid": "V"
                        },
                        {
                            "position": "31",
                            "acid": "V"
                        },
                        {
                            "position": "32",
                            "acid": "A"
                        },
                        {
                            "position": "33",
                            "acid": "V"
                        },
                        {
                            "position": "34",
                            "acid": "F"
                        },
                        {
                            "position": "35",
                            "acid": "A"
                        },
                        {
                            "position": "36",
                            "acid": "N"
                        },
                        {
                            "position": "37",
                            "acid": "N"
                        },
                        {
                            "position": "38",
                            "acid": "A"
                        },
                        {
                            "position": "39",
                            "acid": "P"
                        },
                        {
                            "position": "40",
                            "acid": "A"
                        },
                        {
                            "position": "41",
                            "acid": "F"
                        },
                        {
                            "position": "42",
                            "acid": "Y"
                        },
                        {
                            "position": "43",
                            "acid": "A"
                        },
                        {
                            "position": "44",
                            "acid": "V"
                        },
                        {
                            "position": "45",
                            "acid": "T"
                        },
                        {
                            "position": "46",
                            "acid": "P"
                        },
                        {
                            "position": "47",
                            "acid": "A"
                        },
                        {
                            "position": "48",
                            "acid": "R"
                        },
                        {
                            "position": "49",
                            "acid": "L"
                        },
                        {
                            "position": "50",
                            "acid": "A"
                        },
                        {
                            "position": "51",
                            "acid": "E"
                        },
                        {
                            "position": "52",
                            "acid": "L"
                        },
                        {
                            "position": "53",
                            "acid": "L"
                        },
                        {
                            "position": "54",
                            "acid": "A"
                        },
                        {
                            "position": "55",
                            "acid": "L"
                        },
                        {
                            "position": "56",
                            "acid": "E"
                        },
                        {
                            "position": "57",
                            "acid": "E"
                        },
                        {
                            "position": "58",
                            "acid": "K"
                        },
                        {
                            "position": "59",
                            "acid": "L"
                        },
                        {
                            "position": "60",
                            "acid": "A"
                        },
                        {
                            "position": "61",
                            "acid": "R"
                        },
                        {
                            "position": "62",
                            "acid": "P"
                        },
                        {
                            "position": "63",
                            "acid": "G"
                        },
                        {
                            "position": "64",
                            "acid": "S"
                        },
                        {
                            "position": "65",
                            "acid": "D"
                        },
                        {
                            "position": "66",
                            "acid": "V"
                        },
                        {
                            "position": "67",
                            "acid": "A"
                        },
                        {
                            "position": "68",
                            "acid": "L"
                        },
                        {
                            "position": "69",
                            "acid": "D"
                        },
                        {
                            "position": "70",
                            "acid": "D"
                        },
                        {
                            "position": "71",
                            "acid": "Q"
                        },
                        {
                            "position": "72",
                            "acid": "L"
                        },
                        {
                            "position": "73",
                            "acid": "Y"
                        },
                        {
                            "position": "74",
                            "acid": "Q"
                        },
                        {
                            "position": "75",
                            "acid": "E"
                        },
                        {
                            "position": "76",
                            "acid": "P"
                        },
                        {
                            "position": "77",
                            "acid": "Q"
                        },
                        {
                            "position": "78",
                            "acid": "A"
                        },
                        {
                            "position": "79",
                            "acid": "A"
                        },
                        {
                            "position": "80",
                            "acid": "P"
                        },
                        {
                            "position": "81",
                            "acid": "V"
                        },
                        {
                            "position": "82",
                            "acid": "A"
                        },
                        {
                            "position": "83",
                            "acid": "V"
                        },
                        {
                            "position": "84",
                            "acid": "P"
                        },
                        {
                            "position": "85",
                            "acid": "M"
                        },
                        {
                            "position": "86",
                            "acid": "G"
                        },
                        {
                            "position": "87",
                            "acid": "K"
                        },
                        {
                            "position": "88",
                            "acid": "F"
                        },
                        {
                            "position": "89",
                            "acid": "A"
                        },
                        {
                            "position": "90",
                            "acid": "M"
                        },
                        {
                            "position": "91",
                            "acid": "Y"
                        },
                        {
                            "position": "92",
                            "acid": "P"
                        },
                        {
                            "position": "93",
                            "acid": "D"
                        },
                        {
                            "position": "94",
                            "acid": "W"
                        },
                        {
                            "position": "95",
                            "acid": "Q"
                        },
                        {
                            "position": "96",
                            "acid": "P"
                        },
                        {
                            "position": "97",
                            "acid": "D"
                        },
                        {
                            "position": "98",
                            "acid": "A"
                        },
                        {
                            "position": "99",
                            "acid": "D"
                        },
                        {
                            "position": "100",
                            "acid": "F"
                        },
                        {
                            "position": "101",
                            "acid": "I"
                        },
                        {
                            "position": "102",
                            "acid": "R"
                        },
                        {
                            "position": "103",
                            "acid": "L"
                        },
                        {
                            "position": "104",
                            "acid": "A"
                        },
                        {
                            "position": "105",
                            "acid": "A"
                        },
                        {
                            "position": "106",
                            "acid": "L"
                        },
                        {
                            "position": "107",
                            "acid": "W"
                        },
                        {
                            "position": "108",
                            "acid": "G"
                        },
                        {
                            "position": "109",
                            "acid": "V"
                        },
                        {
                            "position": "110",
                            "acid": "A"
                        },
                        {
                            "position": "111",
                            "acid": "L"
                        },
                        {
                            "position": "112",
                            "acid": "R"
                        },
                        {
                            "position": "113",
                            "acid": "E"
                        },
                        {
                            "position": "114",
                            "acid": "P"
                        },
                        {
                            "position": "115",
                            "acid": "V"
                        },
                        {
                            "position": "116",
                            "acid": "T"
                        },
                        {
                            "position": "117",
                            "acid": "T"
                        },
                        {
                            "position": "118",
                            "acid": "E"
                        },
                        {
                            "position": "119",
                            "acid": "E"
                        },
                        {
                            "position": "120",
                            "acid": "L"
                        },
                        {
                            "position": "121",
                            "acid": "A"
                        },
                        {
                            "position": "122",
                            "acid": "S"
                        },
                        {
                            "position": "123",
                            "acid": "F"
                        },
                        {
                            "position": "124",
                            "acid": "I"
                        },
                        {
                            "position": "125",
                            "acid": "A"
                        },
                        {
                            "position": "126",
                            "acid": "Y"
                        },
                        {
                            "position": "127",
                            "acid": "W"
                        },
                        {
                            "position": "128",
                            "acid": "Q"
                        },
                        {
                            "position": "129",
                            "acid": "A"
                        },
                        {
                            "position": "130",
                            "acid": "E"
                        },
                        {
                            "position": "131",
                            "acid": "G"
                        },
                        {
                            "position": "132",
                            "acid": "K"
                        },
                        {
                            "position": "133",
                            "acid": "V"
                        },
                        {
                            "position": "134",
                            "acid": "F"
                        },
                        {
                            "position": "135",
                            "acid": "H"
                        },
                        {
                            "position": "136",
                            "acid": "H"
                        },
                        {
                            "position": "137",
                            "acid": "V"
                        },
                        {
                            "position": "138",
                            "acid": "Q"
                        },
                        {
                            "position": "139",
                            "acid": "W"
                        },
                        {
                            "position": "140",
                            "acid": "Q"
                        },
                        {
                            "position": "141",
                            "acid": "Q"
                        },
                        {
                            "position": "142",
                            "acid": "K"
                        },
                        {
                            "position": "143",
                            "acid": "L"
                        },
                        {
                            "position": "144",
                            "acid": "A"
                        },
                        {
                            "position": "145",
                            "acid": "R"
                        },
                        {
                            "position": "146",
                            "acid": "S"
                        },
                        {
                            "position": "147",
                            "acid": "L"
                        },
                        {
                            "position": "148",
                            "acid": "Q"
                        },
                        {
                            "position": "149",
                            "acid": "I"
                        },
                        {
                            "position": "150",
                            "acid": "G"
                        },
                        {
                            "position": "151",
                            "acid": "R"
                        },
                        {
                            "position": "152",
                            "acid": "A"
                        },
                        {
                            "position": "153",
                            "acid": "S"
                        },
                        {
                            "position": "154",
                            "acid": "N"
                        },
                        {
                            "position": "155",
                            "acid": "G"
                        },
                        {
                            "position": "156",
                            "acid": "G"
                        },
                        {
                            "position": "157",
                            "acid": "L"
                        },
                        {
                            "position": "158",
                            "acid": "P"
                        },
                        {
                            "position": "159",
                            "acid": "K"
                        },
                        {
                            "position": "160",
                            "acid": "R"
                        },
                        {
                            "position": "161",
                            "acid": "D"
                        },
                        {
                            "position": "162",
                            "acid": "V"
                        },
                        {
                            "position": "163",
                            "acid": "N"
                        },
                        {
                            "position": "164",
                            "acid": "T"
                        },
                        {
                            "position": "165",
                            "acid": "V"
                        },
                        {
                            "position": "166",
                            "acid": "S"
                        },
                        {
                            "position": "167",
                            "acid": "E"
                        },
                        {
                            "position": "168",
                            "acid": "P"
                        },
                        {
                            "position": "169",
                            "acid": "D"
                        },
                        {
                            "position": "170",
                            "acid": "S"
                        },
                        {
                            "position": "171",
                            "acid": "Q"
                        },
                        {
                            "position": "172",
                            "acid": "I"
                        },
                        {
                            "position": "173",
                            "acid": "P"
                        },
                        {
                            "position": "174",
                            "acid": "P"
                        },
                        {
                            "position": "175",
                            "acid": "G"
                        },
                        {
                            "position": "176",
                            "acid": "F"
                        },
                        {
                            "position": "177",
                            "acid": "R"
                        },
                        {
                            "position": "178",
                            "acid": "G"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "20",
                                    "ion_display_position": "67",
                                    "spec_id": "179",
                                    "peak_id": "45",
                                    "peak_charge": "7"
                                }
                            }
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "37",
                                    "ion_display_position": "50",
                                    "spec_id": "179",
                                    "peak_id": "30",
                                    "peak_charge": "6"
                                }
                            }
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "50",
                                    "ion_display_position": "50",
                                    "spec_id": "179",
                                    "peak_id": "19",
                                    "peak_charge": "6"
                                }
                            }
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "64",
                                    "ion_display_position": "23",
                                    "spec_id": "179",
                                    "peak_id": "12",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "75",
                                    "ion_display_position": "75",
                                    "spec_id": "179",
                                    "peak_id": "16",
                                    "peak_charge": "8"
                                }
                            }
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "111",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "112",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "113",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "114",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "115",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "116",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "117",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "118",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "119",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "120",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "121",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "122",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "123",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "124",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "125",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "126",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "127",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "128",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "129",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "130",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "131",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "132",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "133",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "134",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "135",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "136",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "137",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "138",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "139",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "140",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "141",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "142",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "143",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "144",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "145",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "146",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "147",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "148",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "149",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "150",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "151",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "152",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "153",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "154",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "155",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "156",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "157",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "158",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "159",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "160",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "161",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "162",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "163",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "164",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "165",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "166",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "167",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "168",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "169",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "170",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "171",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "172",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "173",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "174",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "175",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "176",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "177",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "178",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "179",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Protein variable",
                        "ptm": {
                            "abbreviation": "Acetyl",
                            "unimod": "1",
                            "mono_mass": "42.0105650000"
                        },
                        "occurence": {
                            "left_pos": "1",
                            "right_pos": "2",
                            "anno": "S"
                        }
                    }
                }
            }
        }
    }
}
