prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "2",
        "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
        "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
        "proteoform_id": "2",
        "prsm_number": "13",
        "prsm": [
            {
                "prsm_id": "146",
                "p_value": "2.16e-14",
                "e_value": "2.17e-14",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "20",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "119",
                        "ms1_scans": "322",
                        "ids": "203",
                        "scans": "324",
                        "precursor_mono_mass": "7266.7080",
                        "precursor_charge": "7",
                        "precursor_mz": "1039.1084",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "203",
                                "peak_id": "0",
                                "monoisotopic_mass": "6963.5359",
                                "monoisotopic_mz": "995.7981",
                                "intensity": "24257.35",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0054",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "1",
                                "monoisotopic_mass": "5188.7568",
                                "monoisotopic_mz": "1038.7586",
                                "intensity": "24832.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "2",
                                "monoisotopic_mass": "6412.2307",
                                "monoisotopic_mz": "1283.4534",
                                "intensity": "11629.33",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0038",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "3",
                                "monoisotopic_mass": "5279.7083",
                                "monoisotopic_mz": "1056.9489",
                                "intensity": "16047.42",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0043",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "4",
                                "monoisotopic_mass": "5408.7407",
                                "monoisotopic_mz": "1082.7554",
                                "intensity": "10490.13",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0144",
                                        "ppm": "-2.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "5",
                                "monoisotopic_mass": "6962.5388",
                                "monoisotopic_mz": "1161.4304",
                                "intensity": "8471.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "6",
                                "monoisotopic_mass": "5685.8392",
                                "monoisotopic_mz": "1138.1751",
                                "intensity": "10446.97",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0293",
                                        "ppm": "-5.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "7",
                                "monoisotopic_mass": "4882.5269",
                                "monoisotopic_mz": "1221.6390",
                                "intensity": "5289.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4882.5235",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0034",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "8",
                                "monoisotopic_mass": "2377.2401",
                                "monoisotopic_mz": "1189.6273",
                                "intensity": "3642.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "9",
                                "monoisotopic_mass": "3114.5521",
                                "monoisotopic_mz": "1039.1913",
                                "intensity": "4876.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "10",
                                "monoisotopic_mass": "5067.6022",
                                "monoisotopic_mz": "1014.5277",
                                "intensity": "4434.85",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "11",
                                "monoisotopic_mass": "2549.3494",
                                "monoisotopic_mz": "1275.6820",
                                "intensity": "3315.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0063",
                                        "ppm": "2.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "12",
                                "monoisotopic_mass": "5799.9473",
                                "monoisotopic_mz": "1160.9967",
                                "intensity": "2072.09",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5798.9526",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "B00053",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "13",
                                "monoisotopic_mass": "3723.9217",
                                "monoisotopic_mz": "931.9877",
                                "intensity": "3604.60",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3723.9202",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0015",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "14",
                                "monoisotopic_mass": "6043.0384",
                                "monoisotopic_mz": "1209.6150",
                                "intensity": "4097.68",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6042.0381",
                                        "ion_position": "55",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "B00055",
                                        "ion_left_position": "55",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "15",
                                "monoisotopic_mass": "4160.0420",
                                "monoisotopic_mz": "1041.0178",
                                "intensity": "4939.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "16",
                                "monoisotopic_mass": "3965.0531",
                                "monoisotopic_mz": "992.2705",
                                "intensity": "4285.35",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0097",
                                        "ppm": "-2.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "17",
                                "monoisotopic_mass": "6580.3213",
                                "monoisotopic_mz": "1097.7275",
                                "intensity": "1250.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6580.3244",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "B00061",
                                        "ion_left_position": "61",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "18",
                                "monoisotopic_mass": "3554.8978",
                                "monoisotopic_mz": "1185.9732",
                                "intensity": "6346.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "19",
                                "monoisotopic_mass": "2266.2240",
                                "monoisotopic_mz": "756.4153",
                                "intensity": "1069.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "20",
                                "monoisotopic_mass": "7049.5491",
                                "monoisotopic_mz": "1008.0857",
                                "intensity": "1570.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "21",
                                "monoisotopic_mass": "7063.5734",
                                "monoisotopic_mz": "1010.0892",
                                "intensity": "3999.06",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7064.5890",
                                        "ion_position": "66",
                                        "ion_display_position": "66",
                                        "ion_sort_name": "B00066",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0132",
                                        "ppm": "-1.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "22",
                                "monoisotopic_mass": "2076.3038",
                                "monoisotopic_mz": "1039.1592",
                                "intensity": "5036.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "23",
                                "monoisotopic_mass": "6412.2288",
                                "monoisotopic_mz": "1069.7121",
                                "intensity": "4233.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0057",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "24",
                                "monoisotopic_mass": "960.0035",
                                "monoisotopic_mz": "961.0108",
                                "intensity": "1436.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "25",
                                "monoisotopic_mass": "821.9558",
                                "monoisotopic_mz": "822.9631",
                                "intensity": "1197.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "26",
                                "monoisotopic_mass": "5408.7527",
                                "monoisotopic_mz": "902.4661",
                                "intensity": "838.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "27",
                                "monoisotopic_mass": "5047.5827",
                                "monoisotopic_mz": "1010.5238",
                                "intensity": "859.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "28",
                                "monoisotopic_mass": "4682.4240",
                                "monoisotopic_mz": "1171.6133",
                                "intensity": "1161.42",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4682.4438",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0198",
                                        "ppm": "-4.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "29",
                                "monoisotopic_mass": "5164.6198",
                                "monoisotopic_mz": "1033.9312",
                                "intensity": "3352.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "30",
                                "monoisotopic_mass": "1240.6432",
                                "monoisotopic_mz": "1241.6505",
                                "intensity": "692.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "31",
                                "monoisotopic_mass": "1069.5390",
                                "monoisotopic_mz": "1070.5463",
                                "intensity": "2562.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "32",
                                "monoisotopic_mass": "1133.9706",
                                "monoisotopic_mz": "1134.9779",
                                "intensity": "1259.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "33",
                                "monoisotopic_mass": "1103.9133",
                                "monoisotopic_mz": "1104.9205",
                                "intensity": "660.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "34",
                                "monoisotopic_mass": "2261.6918",
                                "monoisotopic_mz": "1131.8532",
                                "intensity": "998.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "35",
                                "monoisotopic_mass": "1120.4654",
                                "monoisotopic_mz": "1121.4727",
                                "intensity": "2016.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "36",
                                "monoisotopic_mass": "977.1052",
                                "monoisotopic_mz": "978.1125",
                                "intensity": "1887.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "37",
                                "monoisotopic_mass": "1056.1423",
                                "monoisotopic_mz": "1057.1495",
                                "intensity": "3504.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "38",
                                "monoisotopic_mass": "3868.5845",
                                "monoisotopic_mz": "968.1534",
                                "intensity": "1517.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "39",
                                "monoisotopic_mass": "4816.5778",
                                "monoisotopic_mz": "964.3228",
                                "intensity": "2203.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "40",
                                "monoisotopic_mass": "5941.4207",
                                "monoisotopic_mz": "1189.2914",
                                "intensity": "1190.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "41",
                                "monoisotopic_mass": "1147.1895",
                                "monoisotopic_mz": "1148.1968",
                                "intensity": "723.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "42",
                                "monoisotopic_mass": "4384.8355",
                                "monoisotopic_mz": "1097.2162",
                                "intensity": "710.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "43",
                                "monoisotopic_mass": "4319.7455",
                                "monoisotopic_mz": "1080.9436",
                                "intensity": "2516.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "44",
                                "monoisotopic_mass": "3031.5052",
                                "monoisotopic_mz": "1011.5090",
                                "intensity": "2025.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "45",
                                "monoisotopic_mass": "2194.1083",
                                "monoisotopic_mz": "1098.0614",
                                "intensity": "3356.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "46",
                                "monoisotopic_mass": "1379.3710",
                                "monoisotopic_mz": "1380.3783",
                                "intensity": "1124.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "47",
                                "monoisotopic_mass": "4143.9146",
                                "monoisotopic_mz": "1036.9859",
                                "intensity": "2597.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "48",
                                "monoisotopic_mass": "1291.6714",
                                "monoisotopic_mz": "1292.6787",
                                "intensity": "610.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "49",
                                "monoisotopic_mass": "3244.1070",
                                "monoisotopic_mz": "1082.3763",
                                "intensity": "1486.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "50",
                                "monoisotopic_mass": "1254.6281",
                                "monoisotopic_mz": "1255.6354",
                                "intensity": "693.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "51",
                                "monoisotopic_mass": "6827.7366",
                                "monoisotopic_mz": "1138.9634",
                                "intensity": "947.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "52",
                                "monoisotopic_mass": "6081.9952",
                                "monoisotopic_mz": "1014.6731",
                                "intensity": "2598.83",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6081.0185",
                                        "ion_position": "10",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "10",
                                        "mass_error": "-0.0256",
                                        "ppm": "-4.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "53",
                                "monoisotopic_mass": "1223.2936",
                                "monoisotopic_mz": "1224.3009",
                                "intensity": "730.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "54",
                                "monoisotopic_mass": "6023.9310",
                                "monoisotopic_mz": "1004.9958",
                                "intensity": "1309.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "55",
                                "monoisotopic_mass": "1336.6540",
                                "monoisotopic_mz": "1337.6613",
                                "intensity": "789.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "56",
                                "monoisotopic_mass": "5107.9267",
                                "monoisotopic_mz": "1022.5926",
                                "intensity": "1112.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "203",
                                "peak_id": "57",
                                "monoisotopic_mass": "4272.0742",
                                "monoisotopic_mz": "1069.0258",
                                "intensity": "904.71",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "10",
                                        "ion_display_position": "58",
                                        "spec_id": "203",
                                        "peak_id": "52",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "203",
                                        "peak_id": "19",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "203",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "203",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "203",
                                        "peak_id": "16",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "203",
                                        "peak_id": "28",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "203",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "203",
                                        "peak_id": "10",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "203",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "50",
                                            "ion_display_position": "50",
                                            "spec_id": "203",
                                            "peak_id": "4",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "50",
                                            "ion_display_position": "50",
                                            "spec_id": "203",
                                            "peak_id": "26",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "203",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "spec_id": "203",
                                        "peak_id": "12",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "55",
                                        "ion_display_position": "55",
                                        "spec_id": "203",
                                        "peak_id": "14",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "203",
                                            "peak_id": "23",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "203",
                                            "peak_id": "2",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "spec_id": "203",
                                        "peak_id": "17",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "203",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "203",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "66",
                                        "ion_display_position": "66",
                                        "spec_id": "203",
                                        "peak_id": "21",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "39",
                "p_value": "8.03e-12",
                "e_value": "8.03e-12",
                "fdr": "0",
                "matched_fragment_number": "13",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "70",
                        "ms1_scans": "116",
                        "ids": "48",
                        "scans": "120",
                        "precursor_mono_mass": "7265.6988",
                        "precursor_charge": "7",
                        "precursor_mz": "1038.9643",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "48",
                                "peak_id": "0",
                                "monoisotopic_mass": "5188.7635",
                                "monoisotopic_mz": "1038.7600",
                                "intensity": "18404.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "1",
                                "monoisotopic_mass": "5280.7154",
                                "monoisotopic_mz": "1057.1504",
                                "intensity": "16297.08",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0005",
                                        "ppm": "0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "2",
                                "monoisotopic_mass": "6963.5385",
                                "monoisotopic_mz": "995.7985",
                                "intensity": "26599.94",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "3",
                                "monoisotopic_mass": "6411.2034",
                                "monoisotopic_mz": "1069.5412",
                                "intensity": "5719.38",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0288",
                                        "ppm": "-4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "4",
                                "monoisotopic_mass": "5408.7389",
                                "monoisotopic_mz": "1082.7551",
                                "intensity": "7691.21",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0163",
                                        "ppm": "-3.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "5",
                                "monoisotopic_mass": "6413.2298",
                                "monoisotopic_mz": "1283.6532",
                                "intensity": "12169.50",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6412.2345",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "B00059",
                                            "ion_left_position": "59",
                                            "mass_error": "-0.0071",
                                            "ppm": "-1.10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6414.1662",
                                            "ion_position": "8",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "Y00060",
                                            "ion_left_position": "8",
                                            "mass_error": "0.0660",
                                            "ppm": "10.28"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "6",
                                "monoisotopic_mass": "6963.5389",
                                "monoisotopic_mz": "1161.5971",
                                "intensity": "7010.17",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "7",
                                "monoisotopic_mass": "3114.5478",
                                "monoisotopic_mz": "1039.1899",
                                "intensity": "7795.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "8",
                                "monoisotopic_mass": "5685.8613",
                                "monoisotopic_mz": "1138.1795",
                                "intensity": "9470.52",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0072",
                                        "ppm": "-1.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "9",
                                "monoisotopic_mass": "4160.0390",
                                "monoisotopic_mz": "1041.0170",
                                "intensity": "5710.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "10",
                                "monoisotopic_mass": "3554.9066",
                                "monoisotopic_mz": "1185.9762",
                                "intensity": "5470.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "11",
                                "monoisotopic_mass": "6944.5397",
                                "monoisotopic_mz": "993.0844",
                                "intensity": "4639.89",
                                "charge": "7"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "12",
                                "monoisotopic_mass": "6652.3630",
                                "monoisotopic_mz": "1331.4799",
                                "intensity": "2812.78",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6651.3615",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "B00062",
                                        "ion_left_position": "62",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "13",
                                "monoisotopic_mass": "5067.5919",
                                "monoisotopic_mz": "1014.5257",
                                "intensity": "4493.81",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0116",
                                        "ppm": "-2.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "14",
                                "monoisotopic_mass": "5281.7108",
                                "monoisotopic_mz": "1321.4350",
                                "intensity": "3445.40",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0064",
                                        "ppm": "-1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "15",
                                "monoisotopic_mass": "4753.4766",
                                "monoisotopic_mz": "1189.3764",
                                "intensity": "2989.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4753.4809",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0044",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "16",
                                "monoisotopic_mass": "5280.7196",
                                "monoisotopic_mz": "881.1272",
                                "intensity": "1115.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0047",
                                        "ppm": "0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "17",
                                "monoisotopic_mass": "3965.0635",
                                "monoisotopic_mz": "992.2731",
                                "intensity": "6461.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0007",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "18",
                                "monoisotopic_mass": "2266.2284",
                                "monoisotopic_mz": "1134.1215",
                                "intensity": "1565.73",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0022",
                                        "ppm": "0.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "19",
                                "monoisotopic_mass": "1014.5244",
                                "monoisotopic_mz": "1015.5317",
                                "intensity": "1177.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "20",
                                "monoisotopic_mass": "3809.0103",
                                "monoisotopic_mz": "953.2598",
                                "intensity": "1048.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "21",
                                "monoisotopic_mass": "6770.3503",
                                "monoisotopic_mz": "968.2002",
                                "intensity": "873.40",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6769.3882",
                                        "ion_position": "5",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "5",
                                        "mass_error": "-0.0403",
                                        "ppm": "-5.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "22",
                                "monoisotopic_mass": "968.2551",
                                "monoisotopic_mz": "969.2624",
                                "intensity": "2896.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "23",
                                "monoisotopic_mass": "6581.3316",
                                "monoisotopic_mz": "1097.8959",
                                "intensity": "921.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6580.3244",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "B00061",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0048",
                                        "ppm": "0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "24",
                                "monoisotopic_mass": "4814.9654",
                                "monoisotopic_mz": "964.0004",
                                "intensity": "2530.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "25",
                                "monoisotopic_mass": "2548.3219",
                                "monoisotopic_mz": "1275.1682",
                                "intensity": "2642.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "26",
                                "monoisotopic_mass": "6826.2337",
                                "monoisotopic_mz": "1138.7129",
                                "intensity": "2108.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "27",
                                "monoisotopic_mass": "947.4009",
                                "monoisotopic_mz": "948.4081",
                                "intensity": "4217.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "28",
                                "monoisotopic_mass": "2110.2995",
                                "monoisotopic_mz": "1056.1570",
                                "intensity": "1406.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "29",
                                "monoisotopic_mass": "5803.1294",
                                "monoisotopic_mz": "1161.6332",
                                "intensity": "2340.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "30",
                                "monoisotopic_mass": "1050.5649",
                                "monoisotopic_mz": "1051.5721",
                                "intensity": "703.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "31",
                                "monoisotopic_mass": "4380.6298",
                                "monoisotopic_mz": "1096.1647",
                                "intensity": "1911.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "32",
                                "monoisotopic_mass": "2971.2396",
                                "monoisotopic_mz": "991.4205",
                                "intensity": "2389.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "33",
                                "monoisotopic_mass": "1267.9042",
                                "monoisotopic_mz": "1268.9115",
                                "intensity": "1122.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "34",
                                "monoisotopic_mass": "1152.7091",
                                "monoisotopic_mz": "1153.7164",
                                "intensity": "1231.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "35",
                                "monoisotopic_mass": "1084.9123",
                                "monoisotopic_mz": "1085.9196",
                                "intensity": "686.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "36",
                                "monoisotopic_mass": "4134.5899",
                                "monoisotopic_mz": "1034.6548",
                                "intensity": "3209.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "37",
                                "monoisotopic_mass": "1115.5672",
                                "monoisotopic_mz": "1116.5745",
                                "intensity": "881.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "38",
                                "monoisotopic_mass": "930.4699",
                                "monoisotopic_mz": "931.4772",
                                "intensity": "2854.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "39",
                                "monoisotopic_mass": "883.4357",
                                "monoisotopic_mz": "884.4430",
                                "intensity": "831.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "40",
                                "monoisotopic_mass": "1238.6194",
                                "monoisotopic_mz": "1239.6267",
                                "intensity": "709.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "41",
                                "monoisotopic_mass": "1102.9722",
                                "monoisotopic_mz": "1103.9795",
                                "intensity": "863.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "48",
                                "peak_id": "42",
                                "monoisotopic_mass": "6061.0351",
                                "monoisotopic_mz": "1011.1798",
                                "intensity": "2375.02",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "5",
                                        "ion_display_position": "63",
                                        "spec_id": "48",
                                        "peak_id": "21",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "60",
                                        "spec_id": "48",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "48",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "48",
                                        "peak_id": "17",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "48",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "48",
                                        "peak_id": "13",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "48",
                                            "peak_id": "14",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "48",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "48",
                                            "peak_id": "16",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "48",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "48",
                                        "peak_id": "8",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "48",
                                            "peak_id": "3",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "spec_id": "48",
                                            "peak_id": "5",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "spec_id": "48",
                                        "peak_id": "23",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "spec_id": "48",
                                        "peak_id": "12",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "48",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "48",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "74",
                "p_value": "1.91e-11",
                "e_value": "1.91e-11",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "14",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "86",
                        "ms1_scans": "184",
                        "ids": "101",
                        "scans": "189",
                        "precursor_mono_mass": "7266.6883",
                        "precursor_charge": "7",
                        "precursor_mz": "1039.1056",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "101",
                                "peak_id": "0",
                                "monoisotopic_mass": "6963.5402",
                                "monoisotopic_mz": "995.7987",
                                "intensity": "15769.78",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "1",
                                "monoisotopic_mass": "5280.7079",
                                "monoisotopic_mz": "1057.1489",
                                "intensity": "10868.31",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0070",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "2",
                                "monoisotopic_mass": "5188.7569",
                                "monoisotopic_mz": "1038.7587",
                                "intensity": "16437.34",
                                "charge": "5"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "3",
                                "monoisotopic_mass": "5685.8598",
                                "monoisotopic_mz": "1138.1792",
                                "intensity": "7976.98",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0087",
                                        "ppm": "-1.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "4",
                                "monoisotopic_mass": "4159.5426",
                                "monoisotopic_mz": "1040.8929",
                                "intensity": "17346.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "5",
                                "monoisotopic_mass": "6412.2423",
                                "monoisotopic_mz": "1283.4557",
                                "intensity": "11588.63",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0077",
                                        "ppm": "1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "6",
                                "monoisotopic_mass": "5409.7510",
                                "monoisotopic_mz": "1082.9575",
                                "intensity": "10085.92",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0065",
                                        "ppm": "-1.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "7",
                                "monoisotopic_mass": "3553.9007",
                                "monoisotopic_mz": "1185.6408",
                                "intensity": "6180.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "8",
                                "monoisotopic_mass": "2266.2262",
                                "monoisotopic_mz": "1134.1204",
                                "intensity": "3714.62",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "9",
                                "monoisotopic_mass": "4340.2125",
                                "monoisotopic_mz": "1086.0604",
                                "intensity": "4065.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4340.2171",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0046",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "10",
                                "monoisotopic_mass": "3965.0618",
                                "monoisotopic_mz": "992.2727",
                                "intensity": "7758.52",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "11",
                                "monoisotopic_mass": "994.9338",
                                "monoisotopic_mz": "995.9411",
                                "intensity": "4119.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "12",
                                "monoisotopic_mass": "1643.9159",
                                "monoisotopic_mz": "822.9652",
                                "intensity": "3084.81",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0011",
                                        "ppm": "0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "13",
                                "monoisotopic_mass": "5280.7013",
                                "monoisotopic_mz": "1321.1826",
                                "intensity": "4859.35",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0136",
                                        "ppm": "-2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "14",
                                "monoisotopic_mass": "5556.8068",
                                "monoisotopic_mz": "1112.3686",
                                "intensity": "5491.48",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5556.8259",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0191",
                                        "ppm": "-3.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "15",
                                "monoisotopic_mass": "2549.3397",
                                "monoisotopic_mz": "1275.6771",
                                "intensity": "3308.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "-0.0033",
                                        "ppm": "-1.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "16",
                                "monoisotopic_mass": "3114.5558",
                                "monoisotopic_mz": "1039.1925",
                                "intensity": "5644.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "17",
                                "monoisotopic_mass": "4754.4790",
                                "monoisotopic_mz": "1189.6270",
                                "intensity": "3397.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "18",
                                "monoisotopic_mass": "3098.3763",
                                "monoisotopic_mz": "1033.7994",
                                "intensity": "3949.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "19",
                                "monoisotopic_mass": "1052.9371",
                                "monoisotopic_mz": "1053.9443",
                                "intensity": "1106.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "20",
                                "monoisotopic_mass": "1295.9105",
                                "monoisotopic_mz": "1296.9177",
                                "intensity": "1750.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "21",
                                "monoisotopic_mass": "6963.5389",
                                "monoisotopic_mz": "1161.5971",
                                "intensity": "6214.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "22",
                                "monoisotopic_mass": "5066.5873",
                                "monoisotopic_mz": "1014.3247",
                                "intensity": "4783.54",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0139",
                                        "ppm": "-2.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "23",
                                "monoisotopic_mass": "3206.1100",
                                "monoisotopic_mz": "1069.7106",
                                "intensity": "1905.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "24",
                                "monoisotopic_mass": "4881.4952",
                                "monoisotopic_mz": "1221.3811",
                                "intensity": "3740.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "25",
                                "monoisotopic_mass": "4690.2334",
                                "monoisotopic_mz": "1173.5656",
                                "intensity": "2227.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "26",
                                "monoisotopic_mass": "2217.1229",
                                "monoisotopic_mz": "1109.5687",
                                "intensity": "1134.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "27",
                                "monoisotopic_mass": "1170.6100",
                                "monoisotopic_mz": "1171.6173",
                                "intensity": "2475.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "28",
                                "monoisotopic_mass": "4529.6301",
                                "monoisotopic_mz": "1133.4148",
                                "intensity": "1775.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "29",
                                "monoisotopic_mass": "1271.2461",
                                "monoisotopic_mz": "1272.2534",
                                "intensity": "735.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "30",
                                "monoisotopic_mass": "1128.9607",
                                "monoisotopic_mz": "1129.9680",
                                "intensity": "661.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "31",
                                "monoisotopic_mass": "1079.7488",
                                "monoisotopic_mz": "1080.7561",
                                "intensity": "1890.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "32",
                                "monoisotopic_mass": "950.8960",
                                "monoisotopic_mz": "951.9033",
                                "intensity": "725.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "33",
                                "monoisotopic_mass": "4447.6450",
                                "monoisotopic_mz": "1112.9185",
                                "intensity": "1843.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "34",
                                "monoisotopic_mass": "2111.2607",
                                "monoisotopic_mz": "1056.6376",
                                "intensity": "3108.35",
                                "charge": "2"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "35",
                                "monoisotopic_mass": "1243.6159",
                                "monoisotopic_mz": "1244.6232",
                                "intensity": "1265.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "36",
                                "monoisotopic_mass": "1149.7377",
                                "monoisotopic_mz": "1150.7450",
                                "intensity": "1217.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "37",
                                "monoisotopic_mass": "1210.6092",
                                "monoisotopic_mz": "1211.6165",
                                "intensity": "1160.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "38",
                                "monoisotopic_mass": "1353.1855",
                                "monoisotopic_mz": "1354.1927",
                                "intensity": "1092.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "39",
                                "monoisotopic_mass": "6805.5944",
                                "monoisotopic_mz": "1135.2730",
                                "intensity": "3177.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "40",
                                "monoisotopic_mass": "4378.7031",
                                "monoisotopic_mz": "1095.6830",
                                "intensity": "924.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "41",
                                "monoisotopic_mass": "1380.9562",
                                "monoisotopic_mz": "1381.9635",
                                "intensity": "622.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "101",
                                "peak_id": "42",
                                "monoisotopic_mass": "1093.5555",
                                "monoisotopic_mz": "1094.5627",
                                "intensity": "713.61",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "101",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "101",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "101",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "101",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "101",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "101",
                                        "peak_id": "22",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "101",
                                            "peak_id": "13",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "101",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "101",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "101",
                                        "peak_id": "14",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "101",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "101",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "101",
                                            "peak_id": "21",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "101",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "109",
                "p_value": "2.89e-11",
                "e_value": "2.89e-11",
                "fdr": "0",
                "matched_fragment_number": "14",
                "matched_peak_number": "17",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "103",
                        "ms1_scans": "254",
                        "ids": "150",
                        "scans": "255",
                        "precursor_mono_mass": "7267.7010",
                        "precursor_charge": "8",
                        "precursor_mz": "909.4699",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "150",
                                "peak_id": "0",
                                "monoisotopic_mass": "5280.7115",
                                "monoisotopic_mz": "881.1259",
                                "intensity": "17058.64",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "1",
                                "monoisotopic_mass": "5280.7081",
                                "monoisotopic_mz": "1057.1489",
                                "intensity": "13006.89",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0068",
                                        "ppm": "-1.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "2",
                                "monoisotopic_mass": "3634.4856",
                                "monoisotopic_mz": "909.6287",
                                "intensity": "20477.79",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "3",
                                "monoisotopic_mass": "5181.6389",
                                "monoisotopic_mz": "1037.3350",
                                "intensity": "16001.01",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "4",
                                "monoisotopic_mass": "4090.0972",
                                "monoisotopic_mz": "1023.5316",
                                "intensity": "14684.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "5",
                                "monoisotopic_mass": "5182.6373",
                                "monoisotopic_mz": "864.7802",
                                "intensity": "10547.43",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0115",
                                        "ppm": "-2.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "6",
                                "monoisotopic_mass": "1816.9952",
                                "monoisotopic_mz": "909.5049",
                                "intensity": "12615.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "7",
                                "monoisotopic_mass": "3838.0093",
                                "monoisotopic_mz": "960.5096",
                                "intensity": "4672.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0563",
                                "monoisotopic_mz": "992.2713",
                                "intensity": "8780.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0066",
                                        "ppm": "-1.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "9",
                                "monoisotopic_mass": "5163.6257",
                                "monoisotopic_mz": "1033.7324",
                                "intensity": "6987.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "10",
                                "monoisotopic_mass": "5685.8624",
                                "monoisotopic_mz": "1138.1798",
                                "intensity": "6264.92",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0061",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "11",
                                "monoisotopic_mass": "5069.5994",
                                "monoisotopic_mz": "1014.9272",
                                "intensity": "5959.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "12",
                                "monoisotopic_mass": "6964.5491",
                                "monoisotopic_mz": "871.5759",
                                "intensity": "5893.90",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "0.0054",
                                        "ppm": "0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "13",
                                "monoisotopic_mass": "4753.4829",
                                "monoisotopic_mz": "1189.3780",
                                "intensity": "5089.49",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4753.4809",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0020",
                                        "ppm": "0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "14",
                                "monoisotopic_mass": "3704.9110",
                                "monoisotopic_mz": "927.2350",
                                "intensity": "4185.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "15",
                                "monoisotopic_mass": "3966.0642",
                                "monoisotopic_mz": "794.2201",
                                "intensity": "5464.67",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "16",
                                "monoisotopic_mass": "4136.1318",
                                "monoisotopic_mz": "1035.0402",
                                "intensity": "3563.17",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.1272",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0046",
                                        "ppm": "1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "17",
                                "monoisotopic_mass": "4882.5114",
                                "monoisotopic_mz": "1221.6351",
                                "intensity": "4569.07",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4882.5235",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0121",
                                        "ppm": "-2.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "18",
                                "monoisotopic_mass": "4882.5110",
                                "monoisotopic_mz": "977.5095",
                                "intensity": "3810.28",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4882.5235",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0125",
                                        "ppm": "-2.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "19",
                                "monoisotopic_mass": "909.7094",
                                "monoisotopic_mz": "910.7167",
                                "intensity": "3613.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "20",
                                "monoisotopic_mass": "2266.2271",
                                "monoisotopic_mz": "1134.1208",
                                "intensity": "3274.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0008",
                                        "ppm": "0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "21",
                                "monoisotopic_mass": "4193.1620",
                                "monoisotopic_mz": "1049.2978",
                                "intensity": "2895.32",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4193.1487",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0133",
                                        "ppm": "3.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "22",
                                "monoisotopic_mass": "5068.6113",
                                "monoisotopic_mz": "845.7758",
                                "intensity": "1536.86",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0054",
                                        "ppm": "1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "23",
                                "monoisotopic_mass": "1782.9220",
                                "monoisotopic_mz": "892.4683",
                                "intensity": "2567.23",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "24",
                                "monoisotopic_mass": "4849.5319",
                                "monoisotopic_mz": "809.2626",
                                "intensity": "2635.19",
                                "charge": "6"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "25",
                                "monoisotopic_mass": "6711.5124",
                                "monoisotopic_mz": "959.7948",
                                "intensity": "1459.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "26",
                                "monoisotopic_mass": "4521.3415",
                                "monoisotopic_mz": "905.2756",
                                "intensity": "2587.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "27",
                                "monoisotopic_mass": "7263.3835",
                                "monoisotopic_mz": "908.9302",
                                "intensity": "2627.59",
                                "charge": "8"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "28",
                                "monoisotopic_mass": "2966.5229",
                                "monoisotopic_mz": "989.8482",
                                "intensity": "1916.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "29",
                                "monoisotopic_mass": "3717.9552",
                                "monoisotopic_mz": "930.4961",
                                "intensity": "945.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "30",
                                "monoisotopic_mass": "4754.4860",
                                "monoisotopic_mz": "951.9045",
                                "intensity": "2526.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "31",
                                "monoisotopic_mass": "853.8260",
                                "monoisotopic_mz": "854.8333",
                                "intensity": "1321.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "32",
                                "monoisotopic_mass": "967.5001",
                                "monoisotopic_mz": "968.5074",
                                "intensity": "1213.28",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "33",
                                "monoisotopic_mass": "1861.9598",
                                "monoisotopic_mz": "931.9872",
                                "intensity": "2307.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "34",
                                "monoisotopic_mass": "5046.5893",
                                "monoisotopic_mz": "842.1055",
                                "intensity": "1222.53",
                                "charge": "6"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "35",
                                "monoisotopic_mass": "1011.4327",
                                "monoisotopic_mz": "1012.4399",
                                "intensity": "1783.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "36",
                                "monoisotopic_mass": "1061.5489",
                                "monoisotopic_mz": "1062.5562",
                                "intensity": "1333.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "37",
                                "monoisotopic_mass": "1170.8646",
                                "monoisotopic_mz": "1171.8718",
                                "intensity": "1302.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "38",
                                "monoisotopic_mass": "1084.2396",
                                "monoisotopic_mz": "1085.2468",
                                "intensity": "784.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "39",
                                "monoisotopic_mass": "946.9268",
                                "monoisotopic_mz": "947.9341",
                                "intensity": "2631.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "40",
                                "monoisotopic_mass": "1988.2794",
                                "monoisotopic_mz": "995.1470",
                                "intensity": "1967.77",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "41",
                                "monoisotopic_mass": "1643.9148",
                                "monoisotopic_mz": "822.9647",
                                "intensity": "3058.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1643.9148",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "0.0000",
                                        "ppm": "0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "42",
                                "monoisotopic_mass": "6772.4126",
                                "monoisotopic_mz": "968.4948",
                                "intensity": "1351.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "43",
                                "monoisotopic_mass": "5515.4824",
                                "monoisotopic_mz": "920.2543",
                                "intensity": "1024.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "44",
                                "monoisotopic_mass": "2042.4852",
                                "monoisotopic_mz": "1022.2499",
                                "intensity": "1173.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "45",
                                "monoisotopic_mass": "3780.4969",
                                "monoisotopic_mz": "946.1315",
                                "intensity": "1057.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "46",
                                "monoisotopic_mass": "6412.2308",
                                "monoisotopic_mz": "1283.4534",
                                "intensity": "3403.77",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "-0.0037",
                                        "ppm": "-0.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "47",
                                "monoisotopic_mass": "6652.6295",
                                "monoisotopic_mz": "951.3829",
                                "intensity": "2259.25",
                                "charge": "7"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "48",
                                "monoisotopic_mass": "933.0342",
                                "monoisotopic_mz": "934.0415",
                                "intensity": "1274.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "49",
                                "monoisotopic_mass": "3186.6863",
                                "monoisotopic_mz": "797.6788",
                                "intensity": "1938.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "50",
                                "monoisotopic_mass": "3902.7474",
                                "monoisotopic_mz": "976.6941",
                                "intensity": "1956.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "51",
                                "monoisotopic_mass": "2550.3455",
                                "monoisotopic_mz": "1276.1800",
                                "intensity": "1510.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "52",
                                "monoisotopic_mass": "1117.5718",
                                "monoisotopic_mz": "1118.5791",
                                "intensity": "1400.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "53",
                                "monoisotopic_mass": "4190.1255",
                                "monoisotopic_mz": "839.0324",
                                "intensity": "2027.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "54",
                                "monoisotopic_mass": "5143.6451",
                                "monoisotopic_mz": "1029.7363",
                                "intensity": "1031.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "55",
                                "monoisotopic_mass": "2926.5182",
                                "monoisotopic_mz": "976.5133",
                                "intensity": "1274.65",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2926.5037",
                                        "ion_position": "40",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "40",
                                        "mass_error": "0.0146",
                                        "ppm": "4.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "56",
                                "monoisotopic_mass": "5054.5635",
                                "monoisotopic_mz": "1011.9200",
                                "intensity": "1760.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "57",
                                "monoisotopic_mass": "6539.1943",
                                "monoisotopic_mz": "935.1779",
                                "intensity": "3036.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "58",
                                "monoisotopic_mass": "4845.4059",
                                "monoisotopic_mz": "970.0885",
                                "intensity": "2788.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "59",
                                "monoisotopic_mass": "1974.5908",
                                "monoisotopic_mz": "988.3027",
                                "intensity": "1578.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "60",
                                "monoisotopic_mass": "1688.8968",
                                "monoisotopic_mz": "845.4557",
                                "intensity": "3057.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "61",
                                "monoisotopic_mass": "1146.6574",
                                "monoisotopic_mz": "1147.6647",
                                "intensity": "855.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "150",
                                "peak_id": "62",
                                "monoisotopic_mass": "3610.4702",
                                "monoisotopic_mz": "903.6248",
                                "intensity": "1512.98",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "150",
                                        "peak_id": "41",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "150",
                                        "peak_id": "20",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "150",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "150",
                                        "peak_id": "16",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "150",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "40",
                                        "ion_display_position": "28",
                                        "spec_id": "150",
                                        "peak_id": "55",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "150",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "150",
                                            "peak_id": "18",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "150",
                                            "peak_id": "17",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "150",
                                        "peak_id": "22",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "150",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "150",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "150",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "150",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "150",
                                        "peak_id": "10",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "150",
                                        "peak_id": "46",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "spec_id": "150",
                                        "peak_id": "12",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "22",
                "p_value": "9.09e-11",
                "e_value": "9.09e-11",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "63",
                        "ms1_scans": "89",
                        "ids": "27",
                        "scans": "92",
                        "precursor_mono_mass": "7267.6795",
                        "precursor_charge": "7",
                        "precursor_mz": "1039.2472",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "27",
                                "peak_id": "0",
                                "monoisotopic_mass": "6963.5394",
                                "monoisotopic_mz": "995.7986",
                                "intensity": "18506.65",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "1",
                                "monoisotopic_mass": "5189.7518",
                                "monoisotopic_mz": "1038.9576",
                                "intensity": "19437.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "2",
                                "monoisotopic_mass": "5280.7056",
                                "monoisotopic_mz": "1057.1484",
                                "intensity": "10874.13",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0093",
                                        "ppm": "-1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "3",
                                "monoisotopic_mass": "6963.5331",
                                "monoisotopic_mz": "1161.5961",
                                "intensity": "7092.19",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0082",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "4",
                                "monoisotopic_mass": "5685.8484",
                                "monoisotopic_mz": "1138.1769",
                                "intensity": "6462.60",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0201",
                                        "ppm": "-3.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "5",
                                "monoisotopic_mass": "5410.7417",
                                "monoisotopic_mz": "1083.1556",
                                "intensity": "9152.48",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0181",
                                        "ppm": "-3.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "6",
                                "monoisotopic_mass": "3114.5521",
                                "monoisotopic_mz": "1039.1913",
                                "intensity": "4484.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "7",
                                "monoisotopic_mass": "3207.6115",
                                "monoisotopic_mz": "1070.2111",
                                "intensity": "3653.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "8",
                                "monoisotopic_mass": "2549.3454",
                                "monoisotopic_mz": "1275.6800",
                                "intensity": "3133.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0023",
                                        "ppm": "0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "9",
                                "monoisotopic_mass": "3965.0608",
                                "monoisotopic_mz": "992.2725",
                                "intensity": "4392.95",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "10",
                                "monoisotopic_mass": "4159.5430",
                                "monoisotopic_mz": "1040.8930",
                                "intensity": "13840.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "11",
                                "monoisotopic_mass": "1185.3017",
                                "monoisotopic_mz": "1186.3090",
                                "intensity": "2350.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "12",
                                "monoisotopic_mass": "2640.3527",
                                "monoisotopic_mz": "1321.1836",
                                "intensity": "4548.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "13",
                                "monoisotopic_mass": "5068.5894",
                                "monoisotopic_mz": "1268.1546",
                                "intensity": "1142.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0165",
                                        "ppm": "-3.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "14",
                                "monoisotopic_mass": "3693.7958",
                                "monoisotopic_mz": "1232.2725",
                                "intensity": "2406.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "15",
                                "monoisotopic_mass": "3723.9157",
                                "monoisotopic_mz": "931.9862",
                                "intensity": "2587.21",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3723.9202",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0045",
                                        "ppm": "-1.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "16",
                                "monoisotopic_mass": "1238.0325",
                                "monoisotopic_mz": "1239.0398",
                                "intensity": "1439.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "17",
                                "monoisotopic_mass": "1331.4744",
                                "monoisotopic_mz": "1332.4817",
                                "intensity": "688.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "18",
                                "monoisotopic_mass": "1036.7593",
                                "monoisotopic_mz": "1037.7666",
                                "intensity": "750.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "19",
                                "monoisotopic_mass": "1112.6435",
                                "monoisotopic_mz": "1113.6508",
                                "intensity": "701.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "20",
                                "monoisotopic_mass": "4534.4434",
                                "monoisotopic_mz": "1134.6181",
                                "intensity": "3534.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "21",
                                "monoisotopic_mass": "6228.1445",
                                "monoisotopic_mz": "1246.6362",
                                "intensity": "2465.28",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6227.1181",
                                            "ion_position": "57",
                                            "ion_display_position": "57",
                                            "ion_sort_name": "B00057",
                                            "ion_left_position": "57",
                                            "mass_error": "0.0241",
                                            "ppm": "3.87"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6228.0869",
                                            "ion_position": "9",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "Y00059",
                                            "ion_left_position": "9",
                                            "mass_error": "0.0576",
                                            "ppm": "9.25"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "22",
                                "monoisotopic_mass": "1368.7024",
                                "monoisotopic_mz": "1369.7097",
                                "intensity": "674.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "23",
                                "monoisotopic_mass": "1301.9275",
                                "monoisotopic_mz": "1302.9348",
                                "intensity": "727.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "24",
                                "monoisotopic_mass": "4225.4376",
                                "monoisotopic_mz": "1057.3667",
                                "intensity": "1708.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "27",
                                "peak_id": "25",
                                "monoisotopic_mass": "2269.6246",
                                "monoisotopic_mz": "1135.8196",
                                "intensity": "1482.17",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "59",
                                        "spec_id": "27",
                                        "peak_id": "21",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "27",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "27",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "27",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "27",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "27",
                                        "peak_id": "2",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "27",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "27",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "57",
                                        "ion_display_position": "57",
                                        "spec_id": "27",
                                        "peak_id": "21",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "27",
                                            "peak_id": "3",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "65",
                                            "ion_display_position": "65",
                                            "spec_id": "27",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "170",
                "p_value": "6.37e-10",
                "e_value": "6.37e-10",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "130",
                        "ms1_scans": "369",
                        "ids": "239",
                        "scans": "371",
                        "precursor_mono_mass": "7266.6975",
                        "precursor_charge": "8",
                        "precursor_mz": "909.3445",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "239",
                                "peak_id": "0",
                                "monoisotopic_mass": "5280.7053",
                                "monoisotopic_mz": "881.1248",
                                "intensity": "9911.02",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0096",
                                        "ppm": "-1.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "1",
                                "monoisotopic_mass": "5180.6312",
                                "monoisotopic_mz": "864.4458",
                                "intensity": "9622.86",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0129",
                                        "ppm": "-2.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "2",
                                "monoisotopic_mass": "3634.9871",
                                "monoisotopic_mz": "909.7541",
                                "intensity": "7167.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "3",
                                "monoisotopic_mass": "5280.6995",
                                "monoisotopic_mz": "1057.1472",
                                "intensity": "8546.20",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0154",
                                        "ppm": "-2.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "4",
                                "monoisotopic_mass": "5408.7401",
                                "monoisotopic_mz": "1082.7553",
                                "intensity": "5697.31",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0150",
                                        "ppm": "-2.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "5",
                                "monoisotopic_mass": "5181.6334",
                                "monoisotopic_mz": "1037.3339",
                                "intensity": "9697.50",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0131",
                                        "ppm": "-2.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "6",
                                "monoisotopic_mass": "5067.5971",
                                "monoisotopic_mz": "1014.5267",
                                "intensity": "5415.30",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0064",
                                        "ppm": "-1.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "7",
                                "monoisotopic_mass": "3837.0020",
                                "monoisotopic_mz": "960.2578",
                                "intensity": "3559.55",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3837.0043",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0567",
                                "monoisotopic_mz": "992.2714",
                                "intensity": "6553.31",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0062",
                                        "ppm": "-1.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "9",
                                "monoisotopic_mass": "4341.2132",
                                "monoisotopic_mz": "1086.3106",
                                "intensity": "2926.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "10",
                                "monoisotopic_mass": "3704.9070",
                                "monoisotopic_mz": "927.2340",
                                "intensity": "3326.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "11",
                                "monoisotopic_mass": "2266.2260",
                                "monoisotopic_mz": "1134.1203",
                                "intensity": "3063.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "12",
                                "monoisotopic_mass": "4136.1064",
                                "monoisotopic_mz": "1035.0339",
                                "intensity": "1342.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.1272",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "-0.0208",
                                        "ppm": "-5.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "13",
                                "monoisotopic_mass": "1033.5300",
                                "monoisotopic_mz": "1034.5372",
                                "intensity": "1383.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "14",
                                "monoisotopic_mass": "4695.1406",
                                "monoisotopic_mz": "940.0354",
                                "intensity": "2073.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "15",
                                "monoisotopic_mass": "905.4640",
                                "monoisotopic_mz": "906.4713",
                                "intensity": "1058.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "16",
                                "monoisotopic_mass": "1782.9262",
                                "monoisotopic_mz": "892.4704",
                                "intensity": "1074.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "17",
                                "monoisotopic_mass": "3566.8549",
                                "monoisotopic_mz": "892.7210",
                                "intensity": "1028.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "18",
                                "monoisotopic_mass": "3723.9203",
                                "monoisotopic_mz": "931.9874",
                                "intensity": "1772.22",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3723.9202",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "19",
                                "monoisotopic_mass": "921.7867",
                                "monoisotopic_mz": "922.7939",
                                "intensity": "909.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "20",
                                "monoisotopic_mass": "7234.2108",
                                "monoisotopic_mz": "1034.4660",
                                "intensity": "3188.12",
                                "charge": "7"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "21",
                                "monoisotopic_mass": "840.2962",
                                "monoisotopic_mz": "841.3035",
                                "intensity": "1002.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "22",
                                "monoisotopic_mass": "5686.9133",
                                "monoisotopic_mz": "948.8262",
                                "intensity": "874.57",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "0.0425",
                                        "ppm": "7.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "23",
                                "monoisotopic_mass": "951.4966",
                                "monoisotopic_mz": "952.5038",
                                "intensity": "1645.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "24",
                                "monoisotopic_mass": "1006.3828",
                                "monoisotopic_mz": "1007.3901",
                                "intensity": "997.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "25",
                                "monoisotopic_mass": "4753.4888",
                                "monoisotopic_mz": "1189.3795",
                                "intensity": "3542.66",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4753.4809",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0078",
                                        "ppm": "1.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "26",
                                "monoisotopic_mass": "5451.7155",
                                "monoisotopic_mz": "909.6265",
                                "intensity": "3308.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "27",
                                "monoisotopic_mass": "2980.4433",
                                "monoisotopic_mz": "994.4884",
                                "intensity": "1537.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "28",
                                "monoisotopic_mass": "1169.6029",
                                "monoisotopic_mz": "1170.6102",
                                "intensity": "783.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "29",
                                "monoisotopic_mass": "4545.8862",
                                "monoisotopic_mz": "910.1845",
                                "intensity": "864.72",
                                "charge": "5"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "30",
                                "monoisotopic_mass": "2284.1701",
                                "monoisotopic_mz": "1143.0924",
                                "intensity": "1494.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "239",
                                "peak_id": "31",
                                "monoisotopic_mass": "2929.7114",
                                "monoisotopic_mz": "977.5778",
                                "intensity": "2206.30",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "239",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "239",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "239",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "239",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "239",
                                        "peak_id": "12",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "239",
                                        "peak_id": "25",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "239",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "239",
                                            "peak_id": "5",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "239",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "239",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "239",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "239",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "239",
                                        "peak_id": "22",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "176",
                "p_value": "2.36e-08",
                "e_value": "2.36e-08",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "132",
                        "ms1_scans": "380",
                        "ids": "249",
                        "scans": "383",
                        "precursor_mono_mass": "7266.7071",
                        "precursor_charge": "7",
                        "precursor_mz": "1039.1083",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "249",
                                "peak_id": "0",
                                "monoisotopic_mass": "6963.5368",
                                "monoisotopic_mz": "995.7982",
                                "intensity": "16296.98",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0045",
                                        "ppm": "-0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "1",
                                "monoisotopic_mass": "5188.7439",
                                "monoisotopic_mz": "1038.7561",
                                "intensity": "19742.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "2",
                                "monoisotopic_mass": "6412.2441",
                                "monoisotopic_mz": "1283.4561",
                                "intensity": "7277.74",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6412.2345",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0096",
                                        "ppm": "1.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "3",
                                "monoisotopic_mass": "5281.7163",
                                "monoisotopic_mz": "1057.3505",
                                "intensity": "9400.64",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "4",
                                "monoisotopic_mass": "3114.5467",
                                "monoisotopic_mz": "1039.1895",
                                "intensity": "5314.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "5",
                                "monoisotopic_mass": "3964.0609",
                                "monoisotopic_mz": "992.0225",
                                "intensity": "4133.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "6",
                                "monoisotopic_mass": "4881.5201",
                                "monoisotopic_mz": "1221.3873",
                                "intensity": "3172.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "7",
                                "monoisotopic_mass": "5281.7076",
                                "monoisotopic_mz": "881.2919",
                                "intensity": "1677.78",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0096",
                                        "ppm": "-1.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "8",
                                "monoisotopic_mass": "5408.7547",
                                "monoisotopic_mz": "1082.7582",
                                "intensity": "9319.09",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "9",
                                "monoisotopic_mass": "3554.8971",
                                "monoisotopic_mz": "1185.9730",
                                "intensity": "4199.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "10",
                                "monoisotopic_mass": "3836.9975",
                                "monoisotopic_mz": "960.2566",
                                "intensity": "2900.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3837.0043",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0068",
                                        "ppm": "-1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "11",
                                "monoisotopic_mass": "2266.2228",
                                "monoisotopic_mz": "1134.1187",
                                "intensity": "2800.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "12",
                                "monoisotopic_mass": "1039.5132",
                                "monoisotopic_mz": "1040.5205",
                                "intensity": "1214.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "13",
                                "monoisotopic_mass": "2639.8549",
                                "monoisotopic_mz": "1320.9347",
                                "intensity": "2137.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "14",
                                "monoisotopic_mass": "5686.8690",
                                "monoisotopic_mz": "1138.3811",
                                "intensity": "3415.05",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "15",
                                "monoisotopic_mass": "6216.3199",
                                "monoisotopic_mz": "1037.0606",
                                "intensity": "2526.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "16",
                                "monoisotopic_mass": "4136.1782",
                                "monoisotopic_mz": "1035.0518",
                                "intensity": "2946.39",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.1272",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0510",
                                        "ppm": "12.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "17",
                                "monoisotopic_mass": "6945.5147",
                                "monoisotopic_mz": "993.2237",
                                "intensity": "1069.06",
                                "charge": "7"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "18",
                                "monoisotopic_mass": "5067.5953",
                                "monoisotopic_mz": "1267.9061",
                                "intensity": "1850.57",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0082",
                                        "ppm": "-1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "19",
                                "monoisotopic_mass": "4681.4303",
                                "monoisotopic_mz": "1171.3649",
                                "intensity": "1128.79",
                                "charge": "4"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "20",
                                "monoisotopic_mass": "1138.4175",
                                "monoisotopic_mz": "1139.4248",
                                "intensity": "1572.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "21",
                                "monoisotopic_mass": "6826.2285",
                                "monoisotopic_mz": "1138.7120",
                                "intensity": "3130.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "22",
                                "monoisotopic_mass": "1174.5992",
                                "monoisotopic_mz": "1175.6064",
                                "intensity": "667.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "23",
                                "monoisotopic_mass": "880.4516",
                                "monoisotopic_mz": "881.4589",
                                "intensity": "1108.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "24",
                                "monoisotopic_mass": "1161.4246",
                                "monoisotopic_mz": "1162.4319",
                                "intensity": "1400.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "25",
                                "monoisotopic_mass": "1056.3400",
                                "monoisotopic_mz": "1057.3473",
                                "intensity": "1282.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "26",
                                "monoisotopic_mass": "3205.6211",
                                "monoisotopic_mz": "1069.5477",
                                "intensity": "3885.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "27",
                                "monoisotopic_mass": "1320.6781",
                                "monoisotopic_mz": "1321.6854",
                                "intensity": "1180.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "28",
                                "monoisotopic_mass": "5632.7778",
                                "monoisotopic_mz": "1127.5628",
                                "intensity": "2004.98",
                                "charge": "5"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "29",
                                "monoisotopic_mass": "1120.3970",
                                "monoisotopic_mz": "1121.4043",
                                "intensity": "571.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "30",
                                "monoisotopic_mass": "1257.1193",
                                "monoisotopic_mz": "1258.1266",
                                "intensity": "597.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "31",
                                "monoisotopic_mass": "1201.5954",
                                "monoisotopic_mz": "1202.6027",
                                "intensity": "1044.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "249",
                                "peak_id": "32",
                                "monoisotopic_mass": "1014.9220",
                                "monoisotopic_mz": "1015.9293",
                                "intensity": "955.43",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "249",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "249",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "249",
                                        "peak_id": "16",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "249",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "249",
                                            "peak_id": "7",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "249",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "249",
                                        "peak_id": "8",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "249",
                                        "peak_id": "14",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "249",
                                        "peak_id": "2",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "spec_id": "249",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "116",
                "p_value": "2.44e-08",
                "e_value": "2.44e-08",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "106",
                        "ms1_scans": "266",
                        "ids": "160",
                        "scans": "268",
                        "precursor_mono_mass": "7266.6986",
                        "precursor_charge": "7",
                        "precursor_mz": "1039.1071",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "160",
                                "peak_id": "0",
                                "monoisotopic_mass": "6963.5436",
                                "monoisotopic_mz": "995.7992",
                                "intensity": "26731.02",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "0.0023",
                                        "ppm": "0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "1",
                                "monoisotopic_mass": "5188.7594",
                                "monoisotopic_mz": "1038.7591",
                                "intensity": "18725.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "2",
                                "monoisotopic_mass": "5280.7143",
                                "monoisotopic_mz": "1057.1501",
                                "intensity": "14628.18",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "3",
                                "monoisotopic_mass": "4159.5426",
                                "monoisotopic_mz": "1040.8929",
                                "intensity": "26331.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "4",
                                "monoisotopic_mass": "6413.2189",
                                "monoisotopic_mz": "1283.6510",
                                "intensity": "8368.11",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6412.2345",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "B00059",
                                            "ion_left_position": "59",
                                            "mass_error": "-0.0180",
                                            "ppm": "-2.81"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6414.1662",
                                            "ion_position": "8",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "Y00060",
                                            "ion_left_position": "8",
                                            "mass_error": "0.0550",
                                            "ppm": "8.57"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "5",
                                "monoisotopic_mass": "5685.8574",
                                "monoisotopic_mz": "1138.1787",
                                "intensity": "10978.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0111",
                                        "ppm": "-1.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "6",
                                "monoisotopic_mass": "3965.0605",
                                "monoisotopic_mz": "992.2724",
                                "intensity": "5639.45",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "7",
                                "monoisotopic_mass": "2321.8446",
                                "monoisotopic_mz": "1161.9296",
                                "intensity": "4283.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "8",
                                "monoisotopic_mass": "3114.5503",
                                "monoisotopic_mz": "1039.1907",
                                "intensity": "4277.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "9",
                                "monoisotopic_mass": "4755.4780",
                                "monoisotopic_mz": "1189.8768",
                                "intensity": "3058.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "10",
                                "monoisotopic_mass": "5068.6013",
                                "monoisotopic_mz": "1014.7275",
                                "intensity": "3531.87",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "11",
                                "monoisotopic_mass": "6396.1777",
                                "monoisotopic_mz": "1067.0369",
                                "intensity": "4587.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "12",
                                "monoisotopic_mass": "2080.0183",
                                "monoisotopic_mz": "1041.0165",
                                "intensity": "18436.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "13",
                                "monoisotopic_mass": "2705.3804",
                                "monoisotopic_mz": "1353.6975",
                                "intensity": "2779.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "14",
                                "monoisotopic_mass": "2549.3419",
                                "monoisotopic_mz": "1275.6782",
                                "intensity": "3238.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "15",
                                "monoisotopic_mass": "2170.0900",
                                "monoisotopic_mz": "1086.0523",
                                "intensity": "1775.49",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "16",
                                "monoisotopic_mass": "5666.8438",
                                "monoisotopic_mz": "1134.3760",
                                "intensity": "1068.59",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "17",
                                "monoisotopic_mass": "1170.8555",
                                "monoisotopic_mz": "1171.8628",
                                "intensity": "1780.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "18",
                                "monoisotopic_mass": "2266.2240",
                                "monoisotopic_mz": "1134.1193",
                                "intensity": "1539.57",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "19",
                                "monoisotopic_mass": "4535.4619",
                                "monoisotopic_mz": "1134.8728",
                                "intensity": "2327.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "20",
                                "monoisotopic_mass": "3206.6132",
                                "monoisotopic_mz": "1069.8784",
                                "intensity": "7552.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "21",
                                "monoisotopic_mass": "4882.5129",
                                "monoisotopic_mz": "1221.6355",
                                "intensity": "3201.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4882.5235",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0106",
                                        "ppm": "-2.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "22",
                                "monoisotopic_mass": "872.7831",
                                "monoisotopic_mz": "873.7904",
                                "intensity": "940.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "23",
                                "monoisotopic_mass": "6981.5360",
                                "monoisotopic_mz": "1164.5966",
                                "intensity": "2804.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "24",
                                "monoisotopic_mass": "992.2702",
                                "monoisotopic_mz": "993.2774",
                                "intensity": "462.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "25",
                                "monoisotopic_mass": "5279.7194",
                                "monoisotopic_mz": "880.9605",
                                "intensity": "3533.79",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0069",
                                        "ppm": "1.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "26",
                                "monoisotopic_mass": "5164.6004",
                                "monoisotopic_mz": "1033.9274",
                                "intensity": "1998.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "27",
                                "monoisotopic_mass": "947.6889",
                                "monoisotopic_mz": "948.6962",
                                "intensity": "1243.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "28",
                                "monoisotopic_mass": "1025.0325",
                                "monoisotopic_mz": "1026.0398",
                                "intensity": "1294.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "29",
                                "monoisotopic_mass": "4275.0158",
                                "monoisotopic_mz": "856.0104",
                                "intensity": "1196.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "30",
                                "monoisotopic_mass": "1004.5040",
                                "monoisotopic_mz": "1005.5113",
                                "intensity": "1670.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "31",
                                "monoisotopic_mass": "6947.5073",
                                "monoisotopic_mz": "993.5083",
                                "intensity": "3545.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "32",
                                "monoisotopic_mass": "821.9560",
                                "monoisotopic_mz": "822.9633",
                                "intensity": "1605.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "33",
                                "monoisotopic_mass": "961.6146",
                                "monoisotopic_mz": "962.6219",
                                "intensity": "1531.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "34",
                                "monoisotopic_mass": "6438.7271",
                                "monoisotopic_mz": "1288.7527",
                                "intensity": "1258.93",
                                "charge": "5"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "35",
                                "monoisotopic_mass": "1218.5939",
                                "monoisotopic_mz": "1219.6012",
                                "intensity": "1337.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "36",
                                "monoisotopic_mass": "2195.2858",
                                "monoisotopic_mz": "1098.6502",
                                "intensity": "1112.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "37",
                                "monoisotopic_mass": "1117.3293",
                                "monoisotopic_mz": "1118.3365",
                                "intensity": "807.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "38",
                                "monoisotopic_mass": "5065.6093",
                                "monoisotopic_mz": "1267.4096",
                                "intensity": "3210.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "39",
                                "monoisotopic_mass": "1236.0158",
                                "monoisotopic_mz": "1237.0231",
                                "intensity": "879.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "40",
                                "monoisotopic_mass": "5455.2161",
                                "monoisotopic_mz": "910.2100",
                                "intensity": "1066.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "41",
                                "monoisotopic_mass": "1320.6849",
                                "monoisotopic_mz": "1321.6921",
                                "intensity": "705.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "42",
                                "monoisotopic_mass": "3020.5541",
                                "monoisotopic_mz": "1007.8586",
                                "intensity": "3355.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "43",
                                "monoisotopic_mass": "1188.6169",
                                "monoisotopic_mz": "1189.6241",
                                "intensity": "794.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "44",
                                "monoisotopic_mass": "1254.1488",
                                "monoisotopic_mz": "1255.1560",
                                "intensity": "846.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "45",
                                "monoisotopic_mass": "4290.8448",
                                "monoisotopic_mz": "1073.7185",
                                "intensity": "1970.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "160",
                                "peak_id": "46",
                                "monoisotopic_mass": "4865.4297",
                                "monoisotopic_mz": "1217.3647",
                                "intensity": "1783.93",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "8",
                                        "ion_display_position": "60",
                                        "spec_id": "160",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "160",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "160",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "160",
                                        "peak_id": "6",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "160",
                                        "peak_id": "21",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "160",
                                        "peak_id": "10",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "160",
                                            "peak_id": "2",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "160",
                                            "peak_id": "25",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "160",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "160",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "spec_id": "160",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "79",
                "p_value": "1.25e-05",
                "e_value": "1.25e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "89",
                        "ms1_scans": "197",
                        "ids": "108",
                        "scans": "199",
                        "precursor_mono_mass": "7266.6907",
                        "precursor_charge": "8",
                        "precursor_mz": "909.3436",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "108",
                                "peak_id": "0",
                                "monoisotopic_mass": "5280.7087",
                                "monoisotopic_mz": "1057.1490",
                                "intensity": "10777.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0062",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "1",
                                "monoisotopic_mass": "3633.9887",
                                "monoisotopic_mz": "909.5044",
                                "intensity": "28587.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "2",
                                "monoisotopic_mass": "5181.6395",
                                "monoisotopic_mz": "1037.3352",
                                "intensity": "9897.02",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0070",
                                        "ppm": "-1.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "3",
                                "monoisotopic_mass": "4090.6029",
                                "monoisotopic_mz": "1023.6580",
                                "intensity": "10360.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "4",
                                "monoisotopic_mass": "5408.7499",
                                "monoisotopic_mz": "1082.7572",
                                "intensity": "7883.10",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0053",
                                        "ppm": "-0.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "5",
                                "monoisotopic_mass": "5181.6449",
                                "monoisotopic_mz": "864.6148",
                                "intensity": "5838.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "6",
                                "monoisotopic_mass": "1816.7462",
                                "monoisotopic_mz": "909.3804",
                                "intensity": "10256.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "7",
                                "monoisotopic_mass": "5281.7183",
                                "monoisotopic_mz": "881.2937",
                                "intensity": "8184.36",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0010",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0693",
                                "monoisotopic_mz": "992.2746",
                                "intensity": "4612.84",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0064",
                                        "ppm": "1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "9",
                                "monoisotopic_mass": "5685.8648",
                                "monoisotopic_mz": "1138.1802",
                                "intensity": "7634.77",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0037",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "10",
                                "monoisotopic_mass": "5452.8101",
                                "monoisotopic_mz": "909.8090",
                                "intensity": "31235.35",
                                "charge": "6"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "11",
                                "monoisotopic_mass": "2726.7405",
                                "monoisotopic_mz": "909.9208",
                                "intensity": "6684.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "12",
                                "monoisotopic_mass": "3964.0666",
                                "monoisotopic_mz": "793.8206",
                                "intensity": "4416.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "13",
                                "monoisotopic_mass": "4339.2164",
                                "monoisotopic_mz": "1085.8114",
                                "intensity": "4275.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "14",
                                "monoisotopic_mass": "2839.7804",
                                "monoisotopic_mz": "947.6008",
                                "intensity": "4509.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "15",
                                "monoisotopic_mass": "5262.6995",
                                "monoisotopic_mz": "1053.5472",
                                "intensity": "3283.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "16",
                                "monoisotopic_mass": "2265.2265",
                                "monoisotopic_mz": "1133.6206",
                                "intensity": "3098.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "17",
                                "monoisotopic_mass": "6592.4467",
                                "monoisotopic_mz": "942.7854",
                                "intensity": "3440.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "18",
                                "monoisotopic_mass": "2534.3027",
                                "monoisotopic_mz": "845.7748",
                                "intensity": "3849.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "19",
                                "monoisotopic_mass": "3837.0024",
                                "monoisotopic_mz": "960.2579",
                                "intensity": "3524.46",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3837.0043",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "20",
                                "monoisotopic_mass": "6396.3423",
                                "monoisotopic_mz": "914.7705",
                                "intensity": "3808.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "21",
                                "monoisotopic_mass": "947.4901",
                                "monoisotopic_mz": "948.4974",
                                "intensity": "2221.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "22",
                                "monoisotopic_mass": "2266.2240",
                                "monoisotopic_mz": "756.4153",
                                "intensity": "2769.19",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "23",
                                "monoisotopic_mass": "905.7605",
                                "monoisotopic_mz": "906.7678",
                                "intensity": "1398.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "24",
                                "monoisotopic_mass": "7250.9730",
                                "monoisotopic_mz": "907.3789",
                                "intensity": "3096.39",
                                "charge": "8"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "25",
                                "monoisotopic_mass": "1022.7785",
                                "monoisotopic_mz": "1023.7858",
                                "intensity": "2301.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "26",
                                "monoisotopic_mass": "4134.1197",
                                "monoisotopic_mz": "1034.5372",
                                "intensity": "1895.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "27",
                                "monoisotopic_mass": "4545.4751",
                                "monoisotopic_mz": "910.1023",
                                "intensity": "2473.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "28",
                                "monoisotopic_mass": "6360.2008",
                                "monoisotopic_mz": "1061.0407",
                                "intensity": "3229.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "29",
                                "monoisotopic_mass": "5814.0156",
                                "monoisotopic_mz": "970.0099",
                                "intensity": "1096.92",
                                "charge": "6"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "30",
                                "monoisotopic_mass": "2165.1798",
                                "monoisotopic_mz": "1083.5972",
                                "intensity": "2119.66",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2165.1786",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0012",
                                        "ppm": "0.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "31",
                                "monoisotopic_mass": "4462.7795",
                                "monoisotopic_mz": "893.5632",
                                "intensity": "1369.48",
                                "charge": "5"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "32",
                                "monoisotopic_mass": "6195.2106",
                                "monoisotopic_mz": "886.0374",
                                "intensity": "1273.91",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "33",
                                "monoisotopic_mass": "1068.7050",
                                "monoisotopic_mz": "1069.7123",
                                "intensity": "1176.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "34",
                                "monoisotopic_mass": "880.9551",
                                "monoisotopic_mz": "881.9624",
                                "intensity": "2172.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "35",
                                "monoisotopic_mass": "6122.4516",
                                "monoisotopic_mz": "1021.4159",
                                "intensity": "1720.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "36",
                                "monoisotopic_mass": "1004.1398",
                                "monoisotopic_mz": "1005.1470",
                                "intensity": "1490.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "37",
                                "monoisotopic_mass": "2875.7924",
                                "monoisotopic_mz": "959.6047",
                                "intensity": "1983.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "38",
                                "monoisotopic_mass": "852.4385",
                                "monoisotopic_mz": "853.4458",
                                "intensity": "1647.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "39",
                                "monoisotopic_mass": "933.9134",
                                "monoisotopic_mz": "934.9207",
                                "intensity": "1573.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "40",
                                "monoisotopic_mass": "987.3838",
                                "monoisotopic_mz": "988.3911",
                                "intensity": "1416.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "41",
                                "monoisotopic_mass": "4275.4888",
                                "monoisotopic_mz": "1069.8795",
                                "intensity": "1926.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "42",
                                "monoisotopic_mass": "6936.6805",
                                "monoisotopic_mz": "868.0923",
                                "intensity": "2379.57",
                                "charge": "8"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "43",
                                "monoisotopic_mass": "5847.7733",
                                "monoisotopic_mz": "836.4035",
                                "intensity": "2937.35",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "44",
                                "monoisotopic_mass": "3417.7738",
                                "monoisotopic_mz": "1140.2652",
                                "intensity": "1637.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "45",
                                "monoisotopic_mass": "893.4651",
                                "monoisotopic_mz": "894.4723",
                                "intensity": "1589.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "46",
                                "monoisotopic_mass": "3119.6158",
                                "monoisotopic_mz": "1040.8792",
                                "intensity": "1869.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "47",
                                "monoisotopic_mass": "3346.7493",
                                "monoisotopic_mz": "837.6946",
                                "intensity": "1835.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "48",
                                "monoisotopic_mass": "3652.8833",
                                "monoisotopic_mz": "731.5839",
                                "intensity": "1639.26",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3652.8831",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0003",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "49",
                                "monoisotopic_mass": "6825.5580",
                                "monoisotopic_mz": "854.2020",
                                "intensity": "2541.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "50",
                                "monoisotopic_mass": "4200.7618",
                                "monoisotopic_mz": "1051.1977",
                                "intensity": "981.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "51",
                                "monoisotopic_mass": "4694.4680",
                                "monoisotopic_mz": "939.9009",
                                "intensity": "1403.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "52",
                                "monoisotopic_mass": "960.3499",
                                "monoisotopic_mz": "961.3572",
                                "intensity": "1647.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "53",
                                "monoisotopic_mass": "6307.3571",
                                "monoisotopic_mz": "902.0583",
                                "intensity": "2756.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "54",
                                "monoisotopic_mass": "3587.8121",
                                "monoisotopic_mz": "897.9603",
                                "intensity": "1587.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "55",
                                "monoisotopic_mass": "1235.1109",
                                "monoisotopic_mz": "1236.1182",
                                "intensity": "753.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "56",
                                "monoisotopic_mass": "7168.6004",
                                "monoisotopic_mz": "897.0823",
                                "intensity": "1055.04",
                                "charge": "8"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "57",
                                "monoisotopic_mass": "7025.8540",
                                "monoisotopic_mz": "1004.7007",
                                "intensity": "2323.30",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "58",
                                "monoisotopic_mass": "7214.7549",
                                "monoisotopic_mz": "1031.6865",
                                "intensity": "1063.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "59",
                                "monoisotopic_mass": "3061.3317",
                                "monoisotopic_mz": "1021.4512",
                                "intensity": "2938.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "60",
                                "monoisotopic_mass": "2236.5341",
                                "monoisotopic_mz": "1119.2743",
                                "intensity": "1131.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "61",
                                "monoisotopic_mass": "6615.2727",
                                "monoisotopic_mz": "946.0462",
                                "intensity": "3238.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "62",
                                "monoisotopic_mass": "1035.9885",
                                "monoisotopic_mz": "1036.9957",
                                "intensity": "1499.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "63",
                                "monoisotopic_mass": "1276.1770",
                                "monoisotopic_mz": "1277.1842",
                                "intensity": "826.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "64",
                                "monoisotopic_mass": "3207.6074",
                                "monoisotopic_mz": "1070.2098",
                                "intensity": "2183.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "65",
                                "monoisotopic_mass": "4261.2221",
                                "monoisotopic_mz": "1066.3128",
                                "intensity": "3478.07",
                                "charge": "4"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "66",
                                "monoisotopic_mass": "3089.5601",
                                "monoisotopic_mz": "1030.8606",
                                "intensity": "2559.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "108",
                                "peak_id": "67",
                                "monoisotopic_mass": "1178.2024",
                                "monoisotopic_mz": "1179.2096",
                                "intensity": "960.76",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "spec_id": "108",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "spec_id": "108",
                                        "peak_id": "22",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "108",
                                        "peak_id": "48",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "108",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "108",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "108",
                                            "peak_id": "2",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "108",
                                            "peak_id": "5",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "108",
                                            "peak_id": "0",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "108",
                                            "peak_id": "7",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "108",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "108",
                                        "peak_id": "9",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "138",
                "p_value": "1.46e-05",
                "e_value": "1.46e-05",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "117",
                        "ms1_scans": "310",
                        "ids": "192",
                        "scans": "311",
                        "precursor_mono_mass": "7266.7044",
                        "precursor_charge": "8",
                        "precursor_mz": "909.3453",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "192",
                                "peak_id": "0",
                                "monoisotopic_mass": "5181.6407",
                                "monoisotopic_mz": "1037.3354",
                                "intensity": "12910.60",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0058",
                                        "ppm": "-1.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "1",
                                "monoisotopic_mass": "5181.6398",
                                "monoisotopic_mz": "864.6139",
                                "intensity": "9666.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0067",
                                        "ppm": "-1.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "2",
                                "monoisotopic_mass": "3634.4908",
                                "monoisotopic_mz": "909.6300",
                                "intensity": "14122.62",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "3",
                                "monoisotopic_mass": "5409.7498",
                                "monoisotopic_mz": "1082.9572",
                                "intensity": "6111.61",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0077",
                                        "ppm": "-1.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "4",
                                "monoisotopic_mass": "5280.7185",
                                "monoisotopic_mz": "881.1270",
                                "intensity": "14130.04",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0036",
                                        "ppm": "0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "5",
                                "monoisotopic_mass": "4089.6023",
                                "monoisotopic_mz": "1023.4078",
                                "intensity": "14448.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "6",
                                "monoisotopic_mass": "5280.7109",
                                "monoisotopic_mz": "1057.1495",
                                "intensity": "10734.12",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0040",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "7",
                                "monoisotopic_mass": "3704.9032",
                                "monoisotopic_mz": "927.2331",
                                "intensity": "4450.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0522",
                                "monoisotopic_mz": "992.2703",
                                "intensity": "5922.36",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0107",
                                        "ppm": "-2.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "9",
                                "monoisotopic_mass": "2266.2231",
                                "monoisotopic_mz": "756.4150",
                                "intensity": "3139.72",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "-0.0032",
                                        "ppm": "-1.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "10",
                                "monoisotopic_mass": "4956.5599",
                                "monoisotopic_mz": "992.3193",
                                "intensity": "3745.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "11",
                                "monoisotopic_mass": "4883.5260",
                                "monoisotopic_mz": "977.7125",
                                "intensity": "4950.43",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "12",
                                "monoisotopic_mass": "3839.0078",
                                "monoisotopic_mz": "960.7592",
                                "intensity": "4600.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "13",
                                "monoisotopic_mass": "4752.4770",
                                "monoisotopic_mz": "951.5027",
                                "intensity": "3730.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "14",
                                "monoisotopic_mass": "3482.2723",
                                "monoisotopic_mz": "871.5753",
                                "intensity": "3886.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "15",
                                "monoisotopic_mass": "908.7471",
                                "monoisotopic_mz": "909.7544",
                                "intensity": "1794.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "16",
                                "monoisotopic_mass": "5049.5801",
                                "monoisotopic_mz": "842.6040",
                                "intensity": "3586.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "17",
                                "monoisotopic_mass": "2266.2277",
                                "monoisotopic_mz": "1134.1211",
                                "intensity": "3519.21",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2266.2263",
                                        "ion_position": "20",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "B00020",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0014",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "18",
                                "monoisotopic_mass": "4546.4996",
                                "monoisotopic_mz": "910.3072",
                                "intensity": "4298.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "19",
                                "monoisotopic_mass": "5025.4362",
                                "monoisotopic_mz": "1006.0945",
                                "intensity": "1225.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "20",
                                "monoisotopic_mass": "5164.6076",
                                "monoisotopic_mz": "1033.9288",
                                "intensity": "1019.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "21",
                                "monoisotopic_mass": "1075.7135",
                                "monoisotopic_mz": "1076.7208",
                                "intensity": "1338.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "22",
                                "monoisotopic_mass": "7258.8391",
                                "monoisotopic_mz": "908.3622",
                                "intensity": "5158.73",
                                "charge": "8"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "23",
                                "monoisotopic_mass": "869.8170",
                                "monoisotopic_mz": "870.8243",
                                "intensity": "1026.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "24",
                                "monoisotopic_mass": "4865.5017",
                                "monoisotopic_mz": "974.1076",
                                "intensity": "2590.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "25",
                                "monoisotopic_mass": "6944.5174",
                                "monoisotopic_mz": "869.0720",
                                "intensity": "1081.85",
                                "charge": "8"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "26",
                                "monoisotopic_mass": "6228.0902",
                                "monoisotopic_mz": "1246.6253",
                                "intensity": "2449.84",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6227.1181",
                                            "ion_position": "57",
                                            "ion_display_position": "57",
                                            "ion_sort_name": "B00057",
                                            "ion_left_position": "57",
                                            "mass_error": "-0.0302",
                                            "ppm": "-4.86"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6228.0869",
                                            "ion_position": "9",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "Y00059",
                                            "ion_left_position": "9",
                                            "mass_error": "0.0033",
                                            "ppm": "0.53"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "27",
                                "monoisotopic_mass": "4681.4317",
                                "monoisotopic_mz": "1171.3652",
                                "intensity": "2247.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "28",
                                "monoisotopic_mass": "5673.7781",
                                "monoisotopic_mz": "946.6370",
                                "intensity": "1091.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "29",
                                "monoisotopic_mass": "2549.3441",
                                "monoisotopic_mz": "1275.6793",
                                "intensity": "2586.32",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2549.3431",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "B00023",
                                        "ion_left_position": "23",
                                        "mass_error": "0.0011",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "30",
                                "monoisotopic_mass": "2840.4514",
                                "monoisotopic_mz": "947.8244",
                                "intensity": "3741.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "31",
                                "monoisotopic_mass": "5147.6264",
                                "monoisotopic_mz": "858.9450",
                                "intensity": "2788.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "32",
                                "monoisotopic_mass": "982.1365",
                                "monoisotopic_mz": "983.1438",
                                "intensity": "1251.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "33",
                                "monoisotopic_mass": "2321.1530",
                                "monoisotopic_mz": "1161.5838",
                                "intensity": "1022.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "34",
                                "monoisotopic_mass": "945.4809",
                                "monoisotopic_mz": "946.4882",
                                "intensity": "1119.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "35",
                                "monoisotopic_mass": "963.0414",
                                "monoisotopic_mz": "964.0486",
                                "intensity": "1191.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "36",
                                "monoisotopic_mass": "931.2313",
                                "monoisotopic_mz": "932.2386",
                                "intensity": "2780.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "37",
                                "monoisotopic_mass": "6712.5101",
                                "monoisotopic_mz": "840.0710",
                                "intensity": "999.72",
                                "charge": "8"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "38",
                                "monoisotopic_mass": "882.4648",
                                "monoisotopic_mz": "883.4720",
                                "intensity": "1242.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "39",
                                "monoisotopic_mass": "6316.0524",
                                "monoisotopic_mz": "903.3005",
                                "intensity": "1310.10",
                                "charge": "7"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "40",
                                "monoisotopic_mass": "4938.5495",
                                "monoisotopic_mz": "988.7172",
                                "intensity": "3179.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "41",
                                "monoisotopic_mass": "5084.2127",
                                "monoisotopic_mz": "1017.8498",
                                "intensity": "1113.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "42",
                                "monoisotopic_mass": "4553.3365",
                                "monoisotopic_mz": "1139.3414",
                                "intensity": "1095.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "43",
                                "monoisotopic_mass": "1173.6054",
                                "monoisotopic_mz": "1174.6127",
                                "intensity": "1408.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "44",
                                "monoisotopic_mass": "1039.5381",
                                "monoisotopic_mz": "1040.5454",
                                "intensity": "1724.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "45",
                                "monoisotopic_mass": "995.3633",
                                "monoisotopic_mz": "996.3705",
                                "intensity": "1532.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "46",
                                "monoisotopic_mass": "6986.1368",
                                "monoisotopic_mz": "999.0268",
                                "intensity": "1048.94",
                                "charge": "7"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "47",
                                "monoisotopic_mass": "4780.8594",
                                "monoisotopic_mz": "797.8172",
                                "intensity": "2763.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "48",
                                "monoisotopic_mass": "5102.6847",
                                "monoisotopic_mz": "851.4547",
                                "intensity": "2203.41",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "49",
                                "monoisotopic_mass": "1139.9283",
                                "monoisotopic_mz": "1140.9355",
                                "intensity": "817.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "50",
                                "monoisotopic_mass": "5581.2637",
                                "monoisotopic_mz": "931.2179",
                                "intensity": "1088.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "51",
                                "monoisotopic_mass": "5480.2452",
                                "monoisotopic_mz": "914.3815",
                                "intensity": "2223.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "52",
                                "monoisotopic_mass": "2444.2679",
                                "monoisotopic_mz": "1223.1412",
                                "intensity": "1315.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "53",
                                "monoisotopic_mass": "3756.5386",
                                "monoisotopic_mz": "940.1419",
                                "intensity": "1024.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "54",
                                "monoisotopic_mass": "1944.9984",
                                "monoisotopic_mz": "973.5065",
                                "intensity": "1206.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "55",
                                "monoisotopic_mass": "1009.4217",
                                "monoisotopic_mz": "1010.4290",
                                "intensity": "782.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "56",
                                "monoisotopic_mass": "1093.6572",
                                "monoisotopic_mz": "1094.6645",
                                "intensity": "937.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "192",
                                "peak_id": "57",
                                "monoisotopic_mass": "1483.1594",
                                "monoisotopic_mz": "742.5870",
                                "intensity": "865.23",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "9",
                                        "ion_display_position": "59",
                                        "spec_id": "192",
                                        "peak_id": "26",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "192",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "20",
                                            "ion_display_position": "20",
                                            "spec_id": "192",
                                            "peak_id": "17",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "23",
                                        "ion_display_position": "23",
                                        "spec_id": "192",
                                        "peak_id": "29",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "192",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "192",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "192",
                                            "peak_id": "0",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "192",
                                            "peak_id": "6",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "192",
                                            "peak_id": "4",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "192",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "57",
                                        "ion_display_position": "57",
                                        "spec_id": "192",
                                        "peak_id": "26",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "47",
                "p_value": "4.26e-05",
                "e_value": "4.26e-05",
                "fdr": "0",
                "matched_fragment_number": "7",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "76",
                        "ms1_scans": "138",
                        "ids": "61",
                        "scans": "139",
                        "precursor_mono_mass": "7267.6961",
                        "precursor_charge": "8",
                        "precursor_mz": "909.4693",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "61",
                                "peak_id": "0",
                                "monoisotopic_mass": "5181.6425",
                                "monoisotopic_mz": "1037.3358",
                                "intensity": "8899.91",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0040",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "1",
                                "monoisotopic_mass": "5280.7050",
                                "monoisotopic_mz": "1057.1483",
                                "intensity": "10059.58",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0099",
                                        "ppm": "-1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "2",
                                "monoisotopic_mass": "5280.7115",
                                "monoisotopic_mz": "881.1259",
                                "intensity": "10934.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0034",
                                        "ppm": "-0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "3",
                                "monoisotopic_mass": "3634.9869",
                                "monoisotopic_mz": "909.7540",
                                "intensity": "29330.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "4",
                                "monoisotopic_mass": "5685.8665",
                                "monoisotopic_mz": "1138.1806",
                                "intensity": "4530.02",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5685.8685",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "B00052",
                                        "ion_left_position": "52",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "5",
                                "monoisotopic_mass": "4089.5938",
                                "monoisotopic_mz": "1023.4057",
                                "intensity": "9956.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "6",
                                "monoisotopic_mass": "2726.4015",
                                "monoisotopic_mz": "909.8078",
                                "intensity": "12029.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "7",
                                "monoisotopic_mass": "2045.5519",
                                "monoisotopic_mz": "1023.7832",
                                "intensity": "7662.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0679",
                                "monoisotopic_mz": "992.2742",
                                "intensity": "4225.54",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0051",
                                        "ppm": "1.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "9",
                                "monoisotopic_mass": "4544.8902",
                                "monoisotopic_mz": "909.9853",
                                "intensity": "5946.82",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "10",
                                "monoisotopic_mass": "1033.5248",
                                "monoisotopic_mz": "1034.5321",
                                "intensity": "2652.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "11",
                                "monoisotopic_mass": "4881.5323",
                                "monoisotopic_mz": "977.3137",
                                "intensity": "3370.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "12",
                                "monoisotopic_mass": "3838.0066",
                                "monoisotopic_mz": "960.5089",
                                "intensity": "4019.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "13",
                                "monoisotopic_mass": "6364.5559",
                                "monoisotopic_mz": "910.2296",
                                "intensity": "7208.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "14",
                                "monoisotopic_mass": "908.6214",
                                "monoisotopic_mz": "909.6287",
                                "intensity": "2553.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "15",
                                "monoisotopic_mass": "2137.4175",
                                "monoisotopic_mz": "1069.7160",
                                "intensity": "2532.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "16",
                                "monoisotopic_mass": "4192.1460",
                                "monoisotopic_mz": "1049.0438",
                                "intensity": "1223.20",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "17",
                                "monoisotopic_mass": "2010.5382",
                                "monoisotopic_mz": "1006.2764",
                                "intensity": "2240.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "18",
                                "monoisotopic_mass": "858.1970",
                                "monoisotopic_mz": "859.2043",
                                "intensity": "1323.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "19",
                                "monoisotopic_mass": "4506.4063",
                                "monoisotopic_mz": "902.2885",
                                "intensity": "2751.36",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "20",
                                "monoisotopic_mass": "4882.5266",
                                "monoisotopic_mz": "1221.6389",
                                "intensity": "1225.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4882.5235",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0031",
                                        "ppm": "0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "21",
                                "monoisotopic_mass": "1046.9015",
                                "monoisotopic_mz": "1047.9088",
                                "intensity": "1314.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "22",
                                "monoisotopic_mass": "1879.3665",
                                "monoisotopic_mz": "940.6905",
                                "intensity": "1137.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "23",
                                "monoisotopic_mass": "5050.5809",
                                "monoisotopic_mz": "842.7708",
                                "intensity": "2743.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "24",
                                "monoisotopic_mass": "942.4950",
                                "monoisotopic_mz": "943.5023",
                                "intensity": "1071.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "25",
                                "monoisotopic_mass": "985.5738",
                                "monoisotopic_mz": "986.5811",
                                "intensity": "1239.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "26",
                                "monoisotopic_mass": "1000.4896",
                                "monoisotopic_mz": "1001.4968",
                                "intensity": "2016.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "27",
                                "monoisotopic_mass": "1808.8359",
                                "monoisotopic_mz": "905.4252",
                                "intensity": "2090.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "28",
                                "monoisotopic_mass": "4954.9106",
                                "monoisotopic_mz": "991.9894",
                                "intensity": "1331.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "29",
                                "monoisotopic_mass": "958.4939",
                                "monoisotopic_mz": "959.5012",
                                "intensity": "1275.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "30",
                                "monoisotopic_mass": "7184.8163",
                                "monoisotopic_mz": "899.1093",
                                "intensity": "1371.60",
                                "charge": "8"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "31",
                                "monoisotopic_mass": "3255.6357",
                                "monoisotopic_mz": "1086.2192",
                                "intensity": "1609.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "32",
                                "monoisotopic_mass": "4969.0136",
                                "monoisotopic_mz": "994.8100",
                                "intensity": "1397.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "33",
                                "monoisotopic_mass": "813.1658",
                                "monoisotopic_mz": "814.1731",
                                "intensity": "965.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "34",
                                "monoisotopic_mass": "6962.5208",
                                "monoisotopic_mz": "995.6531",
                                "intensity": "3448.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6963.5413",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "ion_sort_name": "B00065",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0181",
                                        "ppm": "-2.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "35",
                                "monoisotopic_mass": "3195.6258",
                                "monoisotopic_mz": "1066.2159",
                                "intensity": "4238.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "36",
                                "monoisotopic_mass": "5507.0985",
                                "monoisotopic_mz": "1102.4270",
                                "intensity": "2574.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "37",
                                "monoisotopic_mass": "3737.9174",
                                "monoisotopic_mz": "935.4866",
                                "intensity": "964.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "38",
                                "monoisotopic_mass": "883.4670",
                                "monoisotopic_mz": "884.4743",
                                "intensity": "1057.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "39",
                                "monoisotopic_mass": "5409.7646",
                                "monoisotopic_mz": "1082.9602",
                                "intensity": "5126.13",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0071",
                                        "ppm": "1.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "40",
                                "monoisotopic_mass": "6197.1627",
                                "monoisotopic_mz": "1033.8677",
                                "intensity": "1992.18",
                                "charge": "6"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "41",
                                "monoisotopic_mass": "5425.0070",
                                "monoisotopic_mz": "905.1751",
                                "intensity": "1585.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "42",
                                "monoisotopic_mass": "1097.9882",
                                "monoisotopic_mz": "1098.9955",
                                "intensity": "781.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "43",
                                "monoisotopic_mass": "5001.3657",
                                "monoisotopic_mz": "1001.2804",
                                "intensity": "2460.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "44",
                                "monoisotopic_mass": "6003.6000",
                                "monoisotopic_mz": "1001.6073",
                                "intensity": "2531.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "45",
                                "monoisotopic_mass": "6136.9722",
                                "monoisotopic_mz": "1023.8360",
                                "intensity": "2585.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "46",
                                "monoisotopic_mass": "1189.6241",
                                "monoisotopic_mz": "1190.6314",
                                "intensity": "925.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "47",
                                "monoisotopic_mass": "1220.6280",
                                "monoisotopic_mz": "1221.6353",
                                "intensity": "801.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "48",
                                "monoisotopic_mass": "1241.8353",
                                "monoisotopic_mz": "1242.8425",
                                "intensity": "769.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "49",
                                "monoisotopic_mass": "4032.0540",
                                "monoisotopic_mz": "1009.0208",
                                "intensity": "1709.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "50",
                                "monoisotopic_mass": "2741.1530",
                                "monoisotopic_mz": "914.7250",
                                "intensity": "2180.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "51",
                                "monoisotopic_mass": "4048.0903",
                                "monoisotopic_mz": "1013.0299",
                                "intensity": "2290.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "52",
                                "monoisotopic_mass": "2792.7101",
                                "monoisotopic_mz": "931.9106",
                                "intensity": "2136.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "53",
                                "monoisotopic_mass": "2981.9662",
                                "monoisotopic_mz": "994.9960",
                                "intensity": "2404.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "61",
                                "peak_id": "54",
                                "monoisotopic_mass": "4263.3846",
                                "monoisotopic_mz": "1066.8534",
                                "intensity": "1755.52",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "61",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "61",
                                        "peak_id": "20",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "61",
                                        "peak_id": "0",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "61",
                                            "peak_id": "1",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "61",
                                            "peak_id": "2",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "61",
                                        "peak_id": "39",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "52",
                                        "ion_display_position": "52",
                                        "spec_id": "61",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "65",
                                        "ion_display_position": "65",
                                        "spec_id": "61",
                                        "peak_id": "34",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "95",
                "p_value": "3.96e-03",
                "e_value": "3.97e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "5",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "97",
                        "ms1_scans": "227",
                        "ids": "129",
                        "scans": "228",
                        "precursor_mono_mass": "7265.6902",
                        "precursor_charge": "9",
                        "precursor_mz": "808.3062",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "129",
                                "peak_id": "0",
                                "monoisotopic_mass": "7250.9696",
                                "monoisotopic_mz": "806.6706",
                                "intensity": "28127.95",
                                "charge": "9"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "1",
                                "monoisotopic_mass": "5252.9443",
                                "monoisotopic_mz": "876.4980",
                                "intensity": "19136.28",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "2",
                                "monoisotopic_mass": "5139.8617",
                                "monoisotopic_mz": "857.6509",
                                "intensity": "16145.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "3",
                                "monoisotopic_mass": "5383.9958",
                                "monoisotopic_mz": "898.3399",
                                "intensity": "9642.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "4",
                                "monoisotopic_mass": "5164.6150",
                                "monoisotopic_mz": "861.7764",
                                "intensity": "5798.08",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "5",
                                "monoisotopic_mass": "5484.0358",
                                "monoisotopic_mz": "915.0132",
                                "intensity": "12356.49",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "6",
                                "monoisotopic_mass": "5280.7106",
                                "monoisotopic_mz": "755.3945",
                                "intensity": "8872.45",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0043",
                                        "ppm": "-0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "7",
                                "monoisotopic_mass": "5598.0904",
                                "monoisotopic_mz": "934.0223",
                                "intensity": "8727.06",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "8",
                                "monoisotopic_mass": "3965.0659",
                                "monoisotopic_mz": "992.2738",
                                "intensity": "3857.44",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3965.0628",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0031",
                                        "ppm": "0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "9",
                                "monoisotopic_mass": "3340.8375",
                                "monoisotopic_mz": "836.2166",
                                "intensity": "4056.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "10",
                                "monoisotopic_mass": "5026.7677",
                                "monoisotopic_mz": "838.8019",
                                "intensity": "11073.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "11",
                                "monoisotopic_mass": "808.1108",
                                "monoisotopic_mz": "809.1180",
                                "intensity": "3370.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "12",
                                "monoisotopic_mass": "4195.1635",
                                "monoisotopic_mz": "840.0400",
                                "intensity": "4439.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "13",
                                "monoisotopic_mass": "2423.6561",
                                "monoisotopic_mz": "808.8926",
                                "intensity": "4190.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "14",
                                "monoisotopic_mass": "7232.9547",
                                "monoisotopic_mz": "804.6689",
                                "intensity": "5266.62",
                                "charge": "9"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "15",
                                "monoisotopic_mass": "1747.9531",
                                "monoisotopic_mz": "874.9838",
                                "intensity": "2569.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "16",
                                "monoisotopic_mass": "1860.6908",
                                "monoisotopic_mz": "931.3527",
                                "intensity": "3872.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "17",
                                "monoisotopic_mass": "5066.6007",
                                "monoisotopic_mz": "1014.3274",
                                "intensity": "3314.74",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "18",
                                "monoisotopic_mass": "2640.8560",
                                "monoisotopic_mz": "881.2926",
                                "intensity": "2545.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "19",
                                "monoisotopic_mass": "3169.0142",
                                "monoisotopic_mz": "793.2608",
                                "intensity": "3247.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "20",
                                "monoisotopic_mass": "5406.9469",
                                "monoisotopic_mz": "902.1651",
                                "intensity": "890.65",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "21",
                                "monoisotopic_mass": "5835.1990",
                                "monoisotopic_mz": "834.6071",
                                "intensity": "2110.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "22",
                                "monoisotopic_mass": "5650.8646",
                                "monoisotopic_mz": "808.2736",
                                "intensity": "3843.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "23",
                                "monoisotopic_mass": "3836.0039",
                                "monoisotopic_mz": "960.0083",
                                "intensity": "2483.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "24",
                                "monoisotopic_mass": "4362.9429",
                                "monoisotopic_mz": "873.5959",
                                "intensity": "2364.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "25",
                                "monoisotopic_mass": "2265.2268",
                                "monoisotopic_mz": "1133.6207",
                                "intensity": "2529.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "26",
                                "monoisotopic_mass": "3955.0970",
                                "monoisotopic_mz": "792.0267",
                                "intensity": "2450.75",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "27",
                                "monoisotopic_mass": "3568.8906",
                                "monoisotopic_mz": "893.2299",
                                "intensity": "3745.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "28",
                                "monoisotopic_mass": "4007.2038",
                                "monoisotopic_mz": "802.4480",
                                "intensity": "2568.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "29",
                                "monoisotopic_mass": "6456.8661",
                                "monoisotopic_mz": "808.1155",
                                "intensity": "2813.09",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "30",
                                "monoisotopic_mass": "1613.6803",
                                "monoisotopic_mz": "807.8474",
                                "intensity": "3056.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "31",
                                "monoisotopic_mass": "873.4501",
                                "monoisotopic_mz": "874.4573",
                                "intensity": "1114.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "32",
                                "monoisotopic_mass": "4867.5539",
                                "monoisotopic_mz": "812.2663",
                                "intensity": "1399.11",
                                "charge": "6"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "33",
                                "monoisotopic_mass": "7115.8791",
                                "monoisotopic_mz": "791.6605",
                                "intensity": "887.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "34",
                                "monoisotopic_mass": "740.3779",
                                "monoisotopic_mz": "741.3851",
                                "intensity": "1097.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "35",
                                "monoisotopic_mass": "894.6637",
                                "monoisotopic_mz": "895.6710",
                                "intensity": "1364.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "36",
                                "monoisotopic_mass": "7214.0109",
                                "monoisotopic_mz": "902.7586",
                                "intensity": "1006.40",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "37",
                                "monoisotopic_mass": "820.3513",
                                "monoisotopic_mz": "821.3586",
                                "intensity": "1159.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "38",
                                "monoisotopic_mass": "2656.8691",
                                "monoisotopic_mz": "886.6303",
                                "intensity": "3056.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "39",
                                "monoisotopic_mass": "4423.7702",
                                "monoisotopic_mz": "885.7613",
                                "intensity": "1155.77",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "40",
                                "monoisotopic_mass": "6661.1400",
                                "monoisotopic_mz": "833.6498",
                                "intensity": "1123.29",
                                "charge": "8"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "41",
                                "monoisotopic_mass": "4522.4975",
                                "monoisotopic_mz": "905.5068",
                                "intensity": "2002.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "42",
                                "monoisotopic_mass": "5709.9860",
                                "monoisotopic_mz": "816.7196",
                                "intensity": "2048.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "43",
                                "monoisotopic_mass": "5182.6241",
                                "monoisotopic_mz": "1037.5321",
                                "intensity": "4815.02",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0247",
                                        "ppm": "-4.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "44",
                                "monoisotopic_mass": "1760.9066",
                                "monoisotopic_mz": "881.4606",
                                "intensity": "4687.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "45",
                                "monoisotopic_mass": "4665.4659",
                                "monoisotopic_mz": "934.1005",
                                "intensity": "2020.50",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "46",
                                "monoisotopic_mass": "4167.1357",
                                "monoisotopic_mz": "834.4344",
                                "intensity": "2285.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "47",
                                "monoisotopic_mass": "5616.4999",
                                "monoisotopic_mz": "803.3644",
                                "intensity": "1966.42",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "48",
                                "monoisotopic_mass": "5635.7256",
                                "monoisotopic_mz": "806.1109",
                                "intensity": "3701.64",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "49",
                                "monoisotopic_mass": "912.6766",
                                "monoisotopic_mz": "913.6839",
                                "intensity": "955.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "50",
                                "monoisotopic_mass": "4440.0964",
                                "monoisotopic_mz": "889.0266",
                                "intensity": "1971.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "51",
                                "monoisotopic_mass": "3730.7156",
                                "monoisotopic_mz": "933.6862",
                                "intensity": "901.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "52",
                                "monoisotopic_mass": "5753.2054",
                                "monoisotopic_mz": "822.8938",
                                "intensity": "2759.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "53",
                                "monoisotopic_mass": "4290.1849",
                                "monoisotopic_mz": "859.0443",
                                "intensity": "2564.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "54",
                                "monoisotopic_mass": "1794.3272",
                                "monoisotopic_mz": "898.1709",
                                "intensity": "1337.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "55",
                                "monoisotopic_mass": "955.2063",
                                "monoisotopic_mz": "956.2136",
                                "intensity": "1001.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "56",
                                "monoisotopic_mass": "1085.8065",
                                "monoisotopic_mz": "1086.8137",
                                "intensity": "667.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "57",
                                "monoisotopic_mass": "1030.9228",
                                "monoisotopic_mz": "1031.9301",
                                "intensity": "1069.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "58",
                                "monoisotopic_mass": "4136.1525",
                                "monoisotopic_mz": "828.2378",
                                "intensity": "2131.66",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.1272",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0253",
                                        "ppm": "6.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "59",
                                "monoisotopic_mass": "4396.3754",
                                "monoisotopic_mz": "880.2824",
                                "intensity": "2786.23",
                                "charge": "5"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "60",
                                "monoisotopic_mass": "976.6713",
                                "monoisotopic_mz": "977.6786",
                                "intensity": "807.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "129",
                                "peak_id": "61",
                                "monoisotopic_mass": "4535.7507",
                                "monoisotopic_mz": "908.1574",
                                "intensity": "1976.50",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "129",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "129",
                                        "peak_id": "58",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "129",
                                        "peak_id": "17",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "129",
                                        "peak_id": "43",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "129",
                                        "peak_id": "6",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "17",
                "p_value": "4.15e-03",
                "e_value": "4.16e-03",
                "fdr": "0",
                "matched_fragment_number": "5",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "62",
                        "ms1_scans": "83",
                        "ids": "20",
                        "scans": "84",
                        "precursor_mono_mass": "7266.6858",
                        "precursor_charge": "8",
                        "precursor_mz": "909.3430",
                        "feature_inte": "5.5445e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "20",
                                "peak_id": "0",
                                "monoisotopic_mass": "5180.6418",
                                "monoisotopic_mz": "864.4476",
                                "intensity": "9708.97",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "1",
                                "monoisotopic_mass": "3634.9917",
                                "monoisotopic_mz": "909.7552",
                                "intensity": "15894.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "2",
                                "monoisotopic_mass": "5181.6443",
                                "monoisotopic_mz": "1037.3361",
                                "intensity": "9323.18",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5181.6465",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "3",
                                "monoisotopic_mass": "5279.7187",
                                "monoisotopic_mz": "1056.9510",
                                "intensity": "8903.47",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0061",
                                        "ppm": "1.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "4",
                                "monoisotopic_mass": "5280.7229",
                                "monoisotopic_mz": "881.1278",
                                "intensity": "10509.27",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5280.7149",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "0.0080",
                                        "ppm": "1.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "5",
                                "monoisotopic_mass": "4089.6016",
                                "monoisotopic_mz": "1023.4077",
                                "intensity": "12501.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "6",
                                "monoisotopic_mass": "5409.7475",
                                "monoisotopic_mz": "1082.9568",
                                "intensity": "5261.28",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5409.7575",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0100",
                                        "ppm": "-1.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "7",
                                "monoisotopic_mass": "5066.5914",
                                "monoisotopic_mz": "1014.3256",
                                "intensity": "6134.29",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5067.6036",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0098",
                                        "ppm": "-1.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "8",
                                "monoisotopic_mass": "5164.6291",
                                "monoisotopic_mz": "1033.9331",
                                "intensity": "5638.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "9",
                                "monoisotopic_mass": "2726.7432",
                                "monoisotopic_mz": "909.9217",
                                "intensity": "8785.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "10",
                                "monoisotopic_mass": "4883.5313",
                                "monoisotopic_mz": "1221.8901",
                                "intensity": "5092.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "11",
                                "monoisotopic_mass": "1816.7453",
                                "monoisotopic_mz": "909.3800",
                                "intensity": "6248.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "12",
                                "monoisotopic_mass": "5164.6197",
                                "monoisotopic_mz": "861.7772",
                                "intensity": "6998.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "13",
                                "monoisotopic_mass": "5455.9434",
                                "monoisotopic_mz": "910.3312",
                                "intensity": "6004.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "14",
                                "monoisotopic_mass": "2377.2386",
                                "monoisotopic_mz": "1189.6266",
                                "intensity": "2621.03",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "15",
                                "monoisotopic_mass": "3705.9043",
                                "monoisotopic_mz": "742.1881",
                                "intensity": "2739.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "16",
                                "monoisotopic_mass": "5260.7074",
                                "monoisotopic_mz": "1053.1488",
                                "intensity": "2541.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "17",
                                "monoisotopic_mass": "5262.7020",
                                "monoisotopic_mz": "878.1243",
                                "intensity": "2205.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "18",
                                "monoisotopic_mass": "1862.4597",
                                "monoisotopic_mz": "932.2371",
                                "intensity": "2320.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "19",
                                "monoisotopic_mass": "1982.5239",
                                "monoisotopic_mz": "992.2692",
                                "intensity": "3200.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "20",
                                "monoisotopic_mass": "4939.5353",
                                "monoisotopic_mz": "988.9143",
                                "intensity": "2330.91",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4939.5450",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0097",
                                        "ppm": "-1.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "21",
                                "monoisotopic_mass": "5601.8652",
                                "monoisotopic_mz": "934.6515",
                                "intensity": "1133.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "22",
                                "monoisotopic_mass": "3735.3396",
                                "monoisotopic_mz": "934.8422",
                                "intensity": "1515.92",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "23",
                                "monoisotopic_mass": "5846.4945",
                                "monoisotopic_mz": "975.4230",
                                "intensity": "1346.54",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "24",
                                "monoisotopic_mass": "4854.5518",
                                "monoisotopic_mz": "971.9176",
                                "intensity": "2122.93",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "25",
                                "monoisotopic_mass": "996.4455",
                                "monoisotopic_mz": "997.4528",
                                "intensity": "1494.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "26",
                                "monoisotopic_mass": "6078.3009",
                                "monoisotopic_mz": "1014.0574",
                                "intensity": "2066.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "27",
                                "monoisotopic_mass": "879.6996",
                                "monoisotopic_mz": "880.7069",
                                "intensity": "1352.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "28",
                                "monoisotopic_mass": "2263.0458",
                                "monoisotopic_mz": "1132.5302",
                                "intensity": "1788.02",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "29",
                                "monoisotopic_mass": "2961.9103",
                                "monoisotopic_mz": "988.3107",
                                "intensity": "2329.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "30",
                                "monoisotopic_mass": "1025.5258",
                                "monoisotopic_mz": "1026.5331",
                                "intensity": "1147.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "31",
                                "monoisotopic_mass": "1742.1379",
                                "monoisotopic_mz": "872.0762",
                                "intensity": "1824.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "32",
                                "monoisotopic_mass": "3931.3386",
                                "monoisotopic_mz": "983.8419",
                                "intensity": "1948.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "33",
                                "monoisotopic_mass": "2890.4022",
                                "monoisotopic_mz": "964.4747",
                                "intensity": "2140.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "34",
                                "monoisotopic_mass": "4252.9663",
                                "monoisotopic_mz": "851.6005",
                                "intensity": "1036.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "35",
                                "monoisotopic_mass": "4973.3886",
                                "monoisotopic_mz": "995.6850",
                                "intensity": "1045.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "36",
                                "monoisotopic_mass": "1776.8959",
                                "monoisotopic_mz": "889.4552",
                                "intensity": "1752.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "37",
                                "monoisotopic_mass": "3598.3357",
                                "monoisotopic_mz": "900.5912",
                                "intensity": "1105.46",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "38",
                                "monoisotopic_mass": "3206.1562",
                                "monoisotopic_mz": "1069.7260",
                                "intensity": "2487.25",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "39",
                                "monoisotopic_mass": "7252.0629",
                                "monoisotopic_mz": "907.5151",
                                "intensity": "3991.03",
                                "charge": "8"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "40",
                                "monoisotopic_mass": "1137.5740",
                                "monoisotopic_mz": "1138.5813",
                                "intensity": "1752.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "41",
                                "monoisotopic_mass": "3062.0511",
                                "monoisotopic_mz": "1021.6910",
                                "intensity": "1523.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "42",
                                "monoisotopic_mass": "2758.5100",
                                "monoisotopic_mz": "920.5106",
                                "intensity": "1038.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "43",
                                "monoisotopic_mass": "5895.9590",
                                "monoisotopic_mz": "983.6671",
                                "intensity": "2044.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "44",
                                "monoisotopic_mass": "4260.1581",
                                "monoisotopic_mz": "1066.0468",
                                "intensity": "3186.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "45",
                                "monoisotopic_mass": "973.8984",
                                "monoisotopic_mz": "974.9057",
                                "intensity": "1031.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "46",
                                "monoisotopic_mass": "1274.6708",
                                "monoisotopic_mz": "1275.6781",
                                "intensity": "2269.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "47",
                                "monoisotopic_mass": "793.4156",
                                "monoisotopic_mz": "794.4229",
                                "intensity": "892.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "48",
                                "monoisotopic_mass": "951.2949",
                                "monoisotopic_mz": "952.3022",
                                "intensity": "1411.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "49",
                                "monoisotopic_mass": "6720.0313",
                                "monoisotopic_mz": "961.0117",
                                "intensity": "2252.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "50",
                                "monoisotopic_mass": "4290.5064",
                                "monoisotopic_mz": "1073.6339",
                                "intensity": "1620.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "51",
                                "monoisotopic_mass": "1188.3702",
                                "monoisotopic_mz": "1189.3774",
                                "intensity": "704.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "52",
                                "monoisotopic_mass": "1792.1464",
                                "monoisotopic_mz": "897.0805",
                                "intensity": "1976.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "53",
                                "monoisotopic_mass": "3788.9132",
                                "monoisotopic_mz": "948.2356",
                                "intensity": "1007.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "54",
                                "monoisotopic_mass": "1100.5750",
                                "monoisotopic_mz": "1101.5823",
                                "intensity": "875.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "55",
                                "monoisotopic_mass": "2068.3075",
                                "monoisotopic_mz": "1035.1610",
                                "intensity": "1209.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "56",
                                "monoisotopic_mass": "1040.5466",
                                "monoisotopic_mz": "1041.5539",
                                "intensity": "1094.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "57",
                                "monoisotopic_mass": "2164.1153",
                                "monoisotopic_mz": "1083.0649",
                                "intensity": "2034.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "20",
                                "peak_id": "58",
                                "monoisotopic_mass": "2739.1638",
                                "monoisotopic_mz": "914.0619",
                                "intensity": "1756.01",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "2",
                    "proteoform_id": "2",
                    "sequence_name": "sp|P0A9Y6|CSPC_ECOLI",
                    "sequence_description": "Cold shock-like protein CspC OS=Escherichia coli (strain K12) OX=83333 GN=cspC PE=1 SV=2",
                    "proteoform_mass": "7266.7207",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "69",
                        "first_residue_position": "1",
                        "last_residue_position": "68",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "A"
                            },
                            {
                                "position": "2",
                                "acid": "K"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "K"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "Q"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "W"
                            },
                            {
                                "position": "10",
                                "acid": "F"
                            },
                            {
                                "position": "11",
                                "acid": "N"
                            },
                            {
                                "position": "12",
                                "acid": "E"
                            },
                            {
                                "position": "13",
                                "acid": "S"
                            },
                            {
                                "position": "14",
                                "acid": "K"
                            },
                            {
                                "position": "15",
                                "acid": "G"
                            },
                            {
                                "position": "16",
                                "acid": "F"
                            },
                            {
                                "position": "17",
                                "acid": "G"
                            },
                            {
                                "position": "18",
                                "acid": "F"
                            },
                            {
                                "position": "19",
                                "acid": "I"
                            },
                            {
                                "position": "20",
                                "acid": "T"
                            },
                            {
                                "position": "21",
                                "acid": "P"
                            },
                            {
                                "position": "22",
                                "acid": "A"
                            },
                            {
                                "position": "23",
                                "acid": "D"
                            },
                            {
                                "position": "24",
                                "acid": "G"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "K"
                            },
                            {
                                "position": "27",
                                "acid": "D"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "F"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "H"
                            },
                            {
                                "position": "32",
                                "acid": "F"
                            },
                            {
                                "position": "33",
                                "acid": "S"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "I"
                            },
                            {
                                "position": "36",
                                "acid": "Q"
                            },
                            {
                                "position": "37",
                                "acid": "G"
                            },
                            {
                                "position": "38",
                                "acid": "N"
                            },
                            {
                                "position": "39",
                                "acid": "G"
                            },
                            {
                                "position": "40",
                                "acid": "F"
                            },
                            {
                                "position": "41",
                                "acid": "K"
                            },
                            {
                                "position": "42",
                                "acid": "T"
                            },
                            {
                                "position": "43",
                                "acid": "L"
                            },
                            {
                                "position": "44",
                                "acid": "A"
                            },
                            {
                                "position": "45",
                                "acid": "E"
                            },
                            {
                                "position": "46",
                                "acid": "G"
                            },
                            {
                                "position": "47",
                                "acid": "Q"
                            },
                            {
                                "position": "48",
                                "acid": "N"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "E"
                            },
                            {
                                "position": "51",
                                "acid": "F"
                            },
                            {
                                "position": "52",
                                "acid": "E"
                            },
                            {
                                "position": "53",
                                "acid": "I"
                            },
                            {
                                "position": "54",
                                "acid": "Q"
                            },
                            {
                                "position": "55",
                                "acid": "D"
                            },
                            {
                                "position": "56",
                                "acid": "G"
                            },
                            {
                                "position": "57",
                                "acid": "Q"
                            },
                            {
                                "position": "58",
                                "acid": "K"
                            },
                            {
                                "position": "59",
                                "acid": "G"
                            },
                            {
                                "position": "60",
                                "acid": "P"
                            },
                            {
                                "position": "61",
                                "acid": "A"
                            },
                            {
                                "position": "62",
                                "acid": "A"
                            },
                            {
                                "position": "63",
                                "acid": "V"
                            },
                            {
                                "position": "64",
                                "acid": "N"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "T"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "I"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "20",
                                        "peak_id": "20",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "20",
                                        "peak_id": "7",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "20",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "48",
                                            "ion_display_position": "48",
                                            "spec_id": "20",
                                            "peak_id": "2",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "20",
                                            "peak_id": "3",
                                            "peak_charge": "5"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "49",
                                            "ion_display_position": "49",
                                            "spec_id": "20",
                                            "peak_id": "4",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "20",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
