prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "0",
        "sequence_name": "sp|P0AES9|HDEA_ECOLI",
        "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
        "proteoform_id": "15",
        "prsm_number": "1",
        "prsm": {
            "prsm_id": "184",
            "p_value": "9.57e-05",
            "e_value": "9.57e-05",
            "fdr": "0",
            "matched_fragment_number": "10",
            "matched_peak_number": "12",
            "ms": {
                "ms_header": {
                    "spectrum_file_name": "ecoli_2_ms2.msalign",
                    "ms1_ids": "137",
                    "ms1_scans": "397",
                    "ids": "261",
                    "scans": "400",
                    "precursor_mono_mass": "9880.8381",
                    "precursor_charge": "11",
                    "precursor_mz": "899.2653",
                    "feature_inte": "2.8144e+07"
                },
                "peaks": {
                    "peak": [
                        {
                            "spec_id": "261",
                            "peak_id": "0",
                            "monoisotopic_mass": "3534.7937",
                            "monoisotopic_mz": "884.7057",
                            "intensity": "16259.30",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "1",
                            "monoisotopic_mass": "3518.8035",
                            "monoisotopic_mz": "880.7082",
                            "intensity": "17975.33",
                            "charge": "4",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3518.8014",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "ion_sort_name": "Y00030",
                                    "ion_left_position": "59",
                                    "mass_error": "0.0021",
                                    "ppm": "0.59"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "2",
                            "monoisotopic_mass": "3619.8492",
                            "monoisotopic_mz": "905.9696",
                            "intensity": "11836.22",
                            "charge": "4",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3619.8491",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "ion_sort_name": "Y00031",
                                    "ion_left_position": "58",
                                    "mass_error": "0.0000",
                                    "ppm": "0.01"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "3",
                            "monoisotopic_mass": "3518.8011",
                            "monoisotopic_mz": "1173.9410",
                            "intensity": "11342.93",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3518.8014",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "ion_sort_name": "Y00030",
                                    "ion_left_position": "59",
                                    "mass_error": "-0.0003",
                                    "ppm": "-0.08"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "4",
                            "monoisotopic_mass": "3635.8416",
                            "monoisotopic_mz": "909.9677",
                            "intensity": "11359.77",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "5",
                            "monoisotopic_mass": "3534.7906",
                            "monoisotopic_mz": "1179.2708",
                            "intensity": "9869.13",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "6",
                            "monoisotopic_mass": "3619.8523",
                            "monoisotopic_mz": "1207.6247",
                            "intensity": "7378.45",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3619.8491",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "ion_sort_name": "Y00031",
                                    "ion_left_position": "58",
                                    "mass_error": "0.0032",
                                    "ppm": "0.88"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "7",
                            "monoisotopic_mass": "2559.1953",
                            "monoisotopic_mz": "854.0724",
                            "intensity": "6341.03",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "8",
                            "monoisotopic_mass": "3635.8400",
                            "monoisotopic_mz": "1212.9539",
                            "intensity": "6467.98",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "9",
                            "monoisotopic_mass": "2579.2875",
                            "monoisotopic_mz": "1290.6510",
                            "intensity": "6347.50",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "10",
                            "monoisotopic_mass": "2375.0772",
                            "monoisotopic_mz": "792.6997",
                            "intensity": "3820.14",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "11",
                            "monoisotopic_mass": "3889.9826",
                            "monoisotopic_mz": "973.5029",
                            "intensity": "3431.60",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "12",
                            "monoisotopic_mass": "2295.1349",
                            "monoisotopic_mz": "1148.5747",
                            "intensity": "4562.49",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "13",
                            "monoisotopic_mass": "3237.6251",
                            "monoisotopic_mz": "1080.2156",
                            "intensity": "3070.63",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3237.6275",
                                    "ion_position": "62",
                                    "ion_display_position": "27",
                                    "ion_sort_name": "Y00027",
                                    "ion_left_position": "62",
                                    "mass_error": "-0.0024",
                                    "ppm": "-0.75"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "14",
                            "monoisotopic_mass": "2229.0120",
                            "monoisotopic_mz": "744.0113",
                            "intensity": "4926.00",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2229.0120",
                                    "ion_position": "20",
                                    "ion_display_position": "20",
                                    "ion_sort_name": "B00020",
                                    "ion_left_position": "20",
                                    "mass_error": "-0.0000",
                                    "ppm": "-0.01"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "15",
                            "monoisotopic_mass": "2394.2034",
                            "monoisotopic_mz": "1198.1090",
                            "intensity": "3719.89",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "16",
                            "monoisotopic_mass": "2489.1624",
                            "monoisotopic_mz": "830.7281",
                            "intensity": "2720.37",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2489.1645",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "ion_sort_name": "B00022",
                                    "ion_left_position": "22",
                                    "mass_error": "-0.0021",
                                    "ppm": "-0.85"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "17",
                            "monoisotopic_mass": "2775.2979",
                            "monoisotopic_mz": "926.1066",
                            "intensity": "3188.24",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "18",
                            "monoisotopic_mass": "1926.9293",
                            "monoisotopic_mz": "964.4719",
                            "intensity": "2176.32",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "19",
                            "monoisotopic_mass": "2522.2643",
                            "monoisotopic_mz": "1262.1394",
                            "intensity": "4123.08",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "20",
                            "monoisotopic_mass": "770.3558",
                            "monoisotopic_mz": "771.3630",
                            "intensity": "4390.43",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "770.3559",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "ion_sort_name": "B00008",
                                    "ion_left_position": "8",
                                    "mass_error": "-0.0001",
                                    "ppm": "-0.16"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "21",
                            "monoisotopic_mass": "2294.1347",
                            "monoisotopic_mz": "765.7189",
                            "intensity": "2480.54",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "22",
                            "monoisotopic_mass": "3350.7192",
                            "monoisotopic_mz": "1117.9137",
                            "intensity": "2671.21",
                            "charge": "3",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "3350.7116",
                                    "ion_position": "61",
                                    "ion_display_position": "28",
                                    "ion_sort_name": "Y00028",
                                    "ion_left_position": "61",
                                    "mass_error": "0.0076",
                                    "ppm": "2.28"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "23",
                            "monoisotopic_mass": "655.3288",
                            "monoisotopic_mz": "656.3361",
                            "intensity": "1137.81",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "655.3289",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "ion_sort_name": "B00007",
                                    "ion_left_position": "7",
                                    "mass_error": "-0.0001",
                                    "ppm": "-0.15"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "24",
                            "monoisotopic_mass": "2579.2868",
                            "monoisotopic_mz": "860.7695",
                            "intensity": "3027.34",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "25",
                            "monoisotopic_mass": "3602.8469",
                            "monoisotopic_mz": "1201.9562",
                            "intensity": "1296.13",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "26",
                            "monoisotopic_mass": "955.4914",
                            "monoisotopic_mz": "956.4987",
                            "intensity": "1856.80",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "27",
                            "monoisotopic_mass": "979.8196",
                            "monoisotopic_mz": "980.8268",
                            "intensity": "1190.70",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "28",
                            "monoisotopic_mass": "3254.6246",
                            "monoisotopic_mz": "1085.8821",
                            "intensity": "1650.06",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "29",
                            "monoisotopic_mass": "3905.9840",
                            "monoisotopic_mz": "977.5033",
                            "intensity": "949.08",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "30",
                            "monoisotopic_mass": "843.4125",
                            "monoisotopic_mz": "844.4198",
                            "intensity": "979.46",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "31",
                            "monoisotopic_mass": "1858.9541",
                            "monoisotopic_mz": "930.4843",
                            "intensity": "1683.94",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "32",
                            "monoisotopic_mass": "1346.6847",
                            "monoisotopic_mz": "1347.6920",
                            "intensity": "1210.32",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "33",
                            "monoisotopic_mass": "2560.1989",
                            "monoisotopic_mz": "1281.1067",
                            "intensity": "2030.00",
                            "charge": "2",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "2560.2016",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "ion_sort_name": "B00023",
                                    "ion_left_position": "23",
                                    "mass_error": "-0.0028",
                                    "ppm": "-1.08"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "34",
                            "monoisotopic_mass": "2973.3520",
                            "monoisotopic_mz": "992.1246",
                            "intensity": "1820.99",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "35",
                            "monoisotopic_mass": "1825.9170",
                            "monoisotopic_mz": "913.9658",
                            "intensity": "1213.43",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "36",
                            "monoisotopic_mass": "2450.2979",
                            "monoisotopic_mz": "817.7732",
                            "intensity": "1077.81",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "37",
                            "monoisotopic_mass": "1083.5001",
                            "monoisotopic_mz": "1084.5073",
                            "intensity": "1331.74",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "38",
                            "monoisotopic_mass": "3468.7918",
                            "monoisotopic_mz": "1157.2712",
                            "intensity": "1564.92",
                            "charge": "3"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "39",
                            "monoisotopic_mass": "938.2283",
                            "monoisotopic_mz": "939.2356",
                            "intensity": "1788.02",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "40",
                            "monoisotopic_mass": "8799.4367",
                            "monoisotopic_mz": "1100.9369",
                            "intensity": "2441.67",
                            "charge": "8"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "41",
                            "monoisotopic_mass": "3536.7910",
                            "monoisotopic_mz": "708.3655",
                            "intensity": "1627.32",
                            "charge": "5"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "42",
                            "monoisotopic_mass": "3502.7958",
                            "monoisotopic_mz": "876.7062",
                            "intensity": "3089.82",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "43",
                            "monoisotopic_mass": "9459.2221",
                            "monoisotopic_mz": "946.9295",
                            "intensity": "1173.29",
                            "charge": "10"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "44",
                            "monoisotopic_mass": "1296.6596",
                            "monoisotopic_mz": "1297.6669",
                            "intensity": "1127.03",
                            "charge": "1"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "45",
                            "monoisotopic_mass": "1248.6169",
                            "monoisotopic_mz": "1249.6241",
                            "intensity": "770.14",
                            "charge": "1",
                            "matched_ions_num": "1",
                            "matched_ions": {
                                "matched_ion": {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "1248.6173",
                                    "ion_position": "79",
                                    "ion_display_position": "10",
                                    "ion_sort_name": "Y00010",
                                    "ion_left_position": "79",
                                    "mass_error": "-0.0004",
                                    "ppm": "-0.34"
                                }
                            }
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "46",
                            "monoisotopic_mass": "1810.9150",
                            "monoisotopic_mz": "906.4648",
                            "intensity": "1557.33",
                            "charge": "2"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "47",
                            "monoisotopic_mass": "3591.7980",
                            "monoisotopic_mz": "898.9568",
                            "intensity": "1736.13",
                            "charge": "4"
                        },
                        {
                            "spec_id": "261",
                            "peak_id": "48",
                            "monoisotopic_mass": "1059.4866",
                            "monoisotopic_mz": "1060.4939",
                            "intensity": "1094.20",
                            "charge": "1"
                        }
                    ]
                }
            },
            "annotated_protein": {
                "sequence_id": "0",
                "proteoform_id": "15",
                "sequence_name": "sp|P0AES9|HDEA_ECOLI",
                "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
                "proteoform_mass": "9881.1331",
                "n_acetylation": "0",
                "unexpected_shift_number": "1",
                "annotation": {
                    "protein_length": "110",
                    "first_residue_position": "21",
                    "last_residue_position": "109",
                    "residue": [
                        {
                            "position": "0",
                            "acid": "M"
                        },
                        {
                            "position": "1",
                            "acid": "K"
                        },
                        {
                            "position": "2",
                            "acid": "K"
                        },
                        {
                            "position": "3",
                            "acid": "V"
                        },
                        {
                            "position": "4",
                            "acid": "L"
                        },
                        {
                            "position": "5",
                            "acid": "G"
                        },
                        {
                            "position": "6",
                            "acid": "V"
                        },
                        {
                            "position": "7",
                            "acid": "I"
                        },
                        {
                            "position": "8",
                            "acid": "L"
                        },
                        {
                            "position": "9",
                            "acid": "G"
                        },
                        {
                            "position": "10",
                            "acid": "G"
                        },
                        {
                            "position": "11",
                            "acid": "L"
                        },
                        {
                            "position": "12",
                            "acid": "L"
                        },
                        {
                            "position": "13",
                            "acid": "L"
                        },
                        {
                            "position": "14",
                            "acid": "L"
                        },
                        {
                            "position": "15",
                            "acid": "P"
                        },
                        {
                            "position": "16",
                            "acid": "V"
                        },
                        {
                            "position": "17",
                            "acid": "V"
                        },
                        {
                            "position": "18",
                            "acid": "S"
                        },
                        {
                            "position": "19",
                            "acid": "N"
                        },
                        {
                            "position": "20",
                            "acid": "A"
                        },
                        {
                            "position": "21",
                            "acid": "A"
                        },
                        {
                            "position": "22",
                            "acid": "D"
                        },
                        {
                            "position": "23",
                            "acid": "A"
                        },
                        {
                            "position": "24",
                            "acid": "Q"
                        },
                        {
                            "position": "25",
                            "acid": "K"
                        },
                        {
                            "position": "26",
                            "acid": "A"
                        },
                        {
                            "position": "27",
                            "acid": "A"
                        },
                        {
                            "position": "28",
                            "acid": "D"
                        },
                        {
                            "position": "29",
                            "acid": "N"
                        },
                        {
                            "position": "30",
                            "acid": "K"
                        },
                        {
                            "position": "31",
                            "acid": "K"
                        },
                        {
                            "position": "32",
                            "acid": "P"
                        },
                        {
                            "position": "33",
                            "acid": "V"
                        },
                        {
                            "position": "34",
                            "acid": "N"
                        },
                        {
                            "position": "35",
                            "acid": "S"
                        },
                        {
                            "position": "36",
                            "acid": "W"
                        },
                        {
                            "position": "37",
                            "acid": "T"
                        },
                        {
                            "position": "38",
                            "acid": "C"
                        },
                        {
                            "position": "39",
                            "acid": "E"
                        },
                        {
                            "position": "40",
                            "acid": "D"
                        },
                        {
                            "position": "41",
                            "acid": "F"
                        },
                        {
                            "position": "42",
                            "acid": "L"
                        },
                        {
                            "position": "43",
                            "acid": "A"
                        },
                        {
                            "position": "44",
                            "acid": "V"
                        },
                        {
                            "position": "45",
                            "acid": "D"
                        },
                        {
                            "position": "46",
                            "acid": "E"
                        },
                        {
                            "position": "47",
                            "acid": "S"
                        },
                        {
                            "position": "48",
                            "acid": "F"
                        },
                        {
                            "position": "49",
                            "acid": "Q"
                        },
                        {
                            "position": "50",
                            "acid": "P"
                        },
                        {
                            "position": "51",
                            "acid": "T"
                        },
                        {
                            "position": "52",
                            "acid": "A"
                        },
                        {
                            "position": "53",
                            "acid": "V"
                        },
                        {
                            "position": "54",
                            "acid": "G"
                        },
                        {
                            "position": "55",
                            "acid": "F"
                        },
                        {
                            "position": "56",
                            "acid": "A"
                        },
                        {
                            "position": "57",
                            "acid": "E"
                        },
                        {
                            "position": "58",
                            "acid": "A"
                        },
                        {
                            "position": "59",
                            "acid": "L"
                        },
                        {
                            "position": "60",
                            "acid": "N"
                        },
                        {
                            "position": "61",
                            "acid": "N"
                        },
                        {
                            "position": "62",
                            "acid": "K"
                        },
                        {
                            "position": "63",
                            "acid": "D"
                        },
                        {
                            "position": "64",
                            "acid": "K"
                        },
                        {
                            "position": "65",
                            "acid": "P"
                        },
                        {
                            "position": "66",
                            "acid": "E"
                        },
                        {
                            "position": "67",
                            "acid": "D"
                        },
                        {
                            "position": "68",
                            "acid": "A"
                        },
                        {
                            "position": "69",
                            "acid": "V"
                        },
                        {
                            "position": "70",
                            "acid": "L"
                        },
                        {
                            "position": "71",
                            "acid": "D"
                        },
                        {
                            "position": "72",
                            "acid": "V"
                        },
                        {
                            "position": "73",
                            "acid": "Q"
                        },
                        {
                            "position": "74",
                            "acid": "G"
                        },
                        {
                            "position": "75",
                            "acid": "I"
                        },
                        {
                            "position": "76",
                            "acid": "A"
                        },
                        {
                            "position": "77",
                            "acid": "T"
                        },
                        {
                            "position": "78",
                            "acid": "V"
                        },
                        {
                            "position": "79",
                            "acid": "T"
                        },
                        {
                            "position": "80",
                            "acid": "P"
                        },
                        {
                            "position": "81",
                            "acid": "A"
                        },
                        {
                            "position": "82",
                            "acid": "I"
                        },
                        {
                            "position": "83",
                            "acid": "V"
                        },
                        {
                            "position": "84",
                            "acid": "Q"
                        },
                        {
                            "position": "85",
                            "acid": "A"
                        },
                        {
                            "position": "86",
                            "acid": "C"
                        },
                        {
                            "position": "87",
                            "acid": "T"
                        },
                        {
                            "position": "88",
                            "acid": "Q"
                        },
                        {
                            "position": "89",
                            "acid": "D"
                        },
                        {
                            "position": "90",
                            "acid": "K"
                        },
                        {
                            "position": "91",
                            "acid": "Q"
                        },
                        {
                            "position": "92",
                            "acid": "A"
                        },
                        {
                            "position": "93",
                            "acid": "N"
                        },
                        {
                            "position": "94",
                            "acid": "F"
                        },
                        {
                            "position": "95",
                            "acid": "K"
                        },
                        {
                            "position": "96",
                            "acid": "D"
                        },
                        {
                            "position": "97",
                            "acid": "K"
                        },
                        {
                            "position": "98",
                            "acid": "V"
                        },
                        {
                            "position": "99",
                            "acid": "K"
                        },
                        {
                            "position": "100",
                            "acid": "G"
                        },
                        {
                            "position": "101",
                            "acid": "E"
                        },
                        {
                            "position": "102",
                            "acid": "W"
                        },
                        {
                            "position": "103",
                            "acid": "D"
                        },
                        {
                            "position": "104",
                            "acid": "K"
                        },
                        {
                            "position": "105",
                            "acid": "I"
                        },
                        {
                            "position": "106",
                            "acid": "K"
                        },
                        {
                            "position": "107",
                            "acid": "K"
                        },
                        {
                            "position": "108",
                            "acid": "D"
                        },
                        {
                            "position": "109",
                            "acid": "M"
                        }
                    ],
                    "cleavage": [
                        {
                            "position": "0",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "1",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "2",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "3",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "4",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "5",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "6",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "7",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "8",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "9",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "10",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "11",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "12",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "13",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "14",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "15",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "16",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "17",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "18",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "19",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "20",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "21",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "22",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "23",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "24",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "25",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "26",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "27",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "28",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "7",
                                    "ion_display_position": "7",
                                    "spec_id": "261",
                                    "peak_id": "23",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "29",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "8",
                                    "ion_display_position": "8",
                                    "spec_id": "261",
                                    "peak_id": "20",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "30",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "31",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "32",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "33",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "34",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "35",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "36",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "37",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "38",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "39",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "40",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "41",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "20",
                                    "ion_display_position": "20",
                                    "spec_id": "261",
                                    "peak_id": "14",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "42",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "43",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "22",
                                    "ion_display_position": "22",
                                    "spec_id": "261",
                                    "peak_id": "16",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "44",
                            "exist_n_ion": "1",
                            "exist_c_ion": "0",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "B",
                                    "ion_position": "23",
                                    "ion_display_position": "23",
                                    "spec_id": "261",
                                    "peak_id": "33",
                                    "peak_charge": "2"
                                }
                            }
                        },
                        {
                            "position": "45",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "46",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "47",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "48",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "49",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "50",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "51",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "52",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "53",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "54",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "55",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "56",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "57",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "58",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "59",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "60",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "61",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "62",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "63",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "64",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "65",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "66",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "67",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "68",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "69",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "70",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "71",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "72",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "73",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "74",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "75",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "76",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "77",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "78",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "79",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "31",
                                        "spec_id": "261",
                                        "peak_id": "2",
                                        "peak_charge": "4"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "58",
                                        "ion_display_position": "31",
                                        "spec_id": "261",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "80",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": [
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "30",
                                        "spec_id": "261",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    },
                                    {
                                        "ion_type": "Y",
                                        "ion_position": "59",
                                        "ion_display_position": "30",
                                        "spec_id": "261",
                                        "peak_id": "1",
                                        "peak_charge": "4"
                                    }
                                ]
                            }
                        },
                        {
                            "position": "81",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "82",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "61",
                                    "ion_display_position": "28",
                                    "spec_id": "261",
                                    "peak_id": "22",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "83",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "62",
                                    "ion_display_position": "27",
                                    "spec_id": "261",
                                    "peak_id": "13",
                                    "peak_charge": "3"
                                }
                            }
                        },
                        {
                            "position": "84",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "85",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "86",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "87",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "88",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "89",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "90",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "91",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "92",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "93",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "94",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "95",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "96",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "97",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "98",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "99",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "100",
                            "exist_n_ion": "0",
                            "exist_c_ion": "1",
                            "matched_peaks": {
                                "matched_peak": {
                                    "ion_type": "Y",
                                    "ion_position": "79",
                                    "ion_display_position": "10",
                                    "spec_id": "261",
                                    "peak_id": "45",
                                    "peak_charge": "1"
                                }
                            }
                        },
                        {
                            "position": "101",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "102",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "103",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "104",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "105",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "106",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "107",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "108",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "109",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        },
                        {
                            "position": "110",
                            "exist_n_ion": "0",
                            "exist_c_ion": "0",
                            "matched_peaks": null
                        }
                    ],
                    "ptm": {
                        "ptm_type": "Fixed",
                        "ptm": {
                            "abbreviation": "Carbamidomethylation",
                            "unimod": "-1",
                            "mono_mass": "57.0214640000"
                        },
                        "occurence": [
                            {
                                "left_pos": "38",
                                "right_pos": "39",
                                "anno": "C"
                            },
                            {
                                "left_pos": "86",
                                "right_pos": "87",
                                "anno": "C"
                            }
                        ]
                    },
                    "mass_shift": {
                        "id": "0",
                        "left_position": "44",
                        "right_position": "79",
                        "anno": "32.2614",
                        "shift_type": "unexpected"
                    }
                }
            }
        }
    }
}
