prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "8",
        "sequence_name": "sp|P0ADE6|KBP_ECOLI",
        "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
        "proteoform_id": "11",
        "prsm_number": "13",
        "prsm": [
            {
                "prsm_id": "120",
                "p_value": "1.15e-07",
                "e_value": "1.15e-07",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "109",
                        "ms1_scans": "274",
                        "ids": "165",
                        "scans": "276",
                        "precursor_mono_mass": "15921.2126",
                        "precursor_charge": "18",
                        "precursor_mz": "885.5191",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "165",
                                "peak_id": "0",
                                "monoisotopic_mass": "6428.3464",
                                "monoisotopic_mz": "919.3425",
                                "intensity": "14814.98",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0128",
                                        "ppm": "1.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "1",
                                "monoisotopic_mass": "6429.3378",
                                "monoisotopic_mz": "1072.5636",
                                "intensity": "13605.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0019",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "2",
                                "monoisotopic_mass": "4361.2173",
                                "monoisotopic_mz": "873.2507",
                                "intensity": "8754.90",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "3",
                                "monoisotopic_mass": "8006.1416",
                                "monoisotopic_mz": "890.5786",
                                "intensity": "11332.56",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8007.1407",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0033",
                                        "ppm": "0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "4",
                                "monoisotopic_mass": "7545.8794",
                                "monoisotopic_mz": "1078.9900",
                                "intensity": "9888.91",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0048",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "5",
                                "monoisotopic_mass": "5640.8696",
                                "monoisotopic_mz": "941.1522",
                                "intensity": "5963.70",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5640.8601",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "0.0095",
                                        "ppm": "1.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "6",
                                "monoisotopic_mass": "1136.6176",
                                "monoisotopic_mz": "1137.6249",
                                "intensity": "4401.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0014",
                                        "ppm": "-1.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "7",
                                "monoisotopic_mass": "2136.1086",
                                "monoisotopic_mz": "1069.0616",
                                "intensity": "4717.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "8",
                                "monoisotopic_mass": "3130.6186",
                                "monoisotopic_mz": "1044.5468",
                                "intensity": "4576.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "9",
                                "monoisotopic_mass": "1721.8736",
                                "monoisotopic_mz": "861.9441",
                                "intensity": "2287.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "10",
                                "monoisotopic_mass": "933.6277",
                                "monoisotopic_mz": "934.6350",
                                "intensity": "2180.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "11",
                                "monoisotopic_mass": "4090.0602",
                                "monoisotopic_mz": "819.0193",
                                "intensity": "3165.56",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4090.0661",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "-0.0058",
                                        "ppm": "-1.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "12",
                                "monoisotopic_mass": "3490.1732",
                                "monoisotopic_mz": "873.5506",
                                "intensity": "3096.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "13",
                                "monoisotopic_mass": "5342.7239",
                                "monoisotopic_mz": "1069.5520",
                                "intensity": "2918.92",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5341.7120",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "0.0095",
                                        "ppm": "1.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "14",
                                "monoisotopic_mass": "1755.8963",
                                "monoisotopic_mz": "878.9554",
                                "intensity": "2497.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "15",
                                "monoisotopic_mass": "6511.3315",
                                "monoisotopic_mz": "1086.2292",
                                "intensity": "1408.93",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "16",
                                "monoisotopic_mass": "6771.9618",
                                "monoisotopic_mz": "968.4304",
                                "intensity": "1369.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "17",
                                "monoisotopic_mass": "919.4781",
                                "monoisotopic_mz": "920.4854",
                                "intensity": "2686.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "18",
                                "monoisotopic_mass": "1065.5425",
                                "monoisotopic_mz": "1066.5498",
                                "intensity": "1695.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "19",
                                "monoisotopic_mass": "13242.5038",
                                "monoisotopic_mz": "946.9004",
                                "intensity": "1725.23",
                                "charge": "14"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "20",
                                "monoisotopic_mass": "14943.6477",
                                "monoisotopic_mz": "1068.4107",
                                "intensity": "3317.20",
                                "charge": "14"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "21",
                                "monoisotopic_mass": "6332.6827",
                                "monoisotopic_mz": "1056.4544",
                                "intensity": "2065.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "22",
                                "monoisotopic_mass": "841.4271",
                                "monoisotopic_mz": "842.4343",
                                "intensity": "1114.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "23",
                                "monoisotopic_mass": "7396.7542",
                                "monoisotopic_mz": "1057.6865",
                                "intensity": "1410.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "24",
                                "monoisotopic_mass": "755.4169",
                                "monoisotopic_mz": "756.4241",
                                "intensity": "3648.73",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "142",
                                        "mass_error": "-0.0009",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "25",
                                "monoisotopic_mass": "886.4561",
                                "monoisotopic_mz": "887.4634",
                                "intensity": "1754.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "26",
                                "monoisotopic_mass": "2745.0302",
                                "monoisotopic_mz": "916.0173",
                                "intensity": "3423.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "27",
                                "monoisotopic_mass": "6459.3021",
                                "monoisotopic_mz": "808.4200",
                                "intensity": "1064.10",
                                "charge": "8"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "28",
                                "monoisotopic_mass": "1154.6236",
                                "monoisotopic_mz": "1155.6309",
                                "intensity": "1163.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "29",
                                "monoisotopic_mass": "5240.2683",
                                "monoisotopic_mz": "874.3853",
                                "intensity": "1014.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "30",
                                "monoisotopic_mass": "6581.3811",
                                "monoisotopic_mz": "1097.9041",
                                "intensity": "1066.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "31",
                                "monoisotopic_mass": "6883.5302",
                                "monoisotopic_mz": "861.4486",
                                "intensity": "3466.60",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6884.4646",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "B00064",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0680",
                                        "ppm": "9.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "32",
                                "monoisotopic_mass": "854.4856",
                                "monoisotopic_mz": "855.4929",
                                "intensity": "1187.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "854.4862",
                                        "ion_position": "141",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "141",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "33",
                                "monoisotopic_mass": "5556.9316",
                                "monoisotopic_mz": "927.1625",
                                "intensity": "1122.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "34",
                                "monoisotopic_mass": "955.5054",
                                "monoisotopic_mz": "956.5127",
                                "intensity": "1378.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "35",
                                "monoisotopic_mass": "1084.7284",
                                "monoisotopic_mz": "1085.7357",
                                "intensity": "1078.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "36",
                                "monoisotopic_mass": "8870.5648",
                                "monoisotopic_mz": "1109.8279",
                                "intensity": "1159.44",
                                "charge": "8"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "37",
                                "monoisotopic_mass": "974.2483",
                                "monoisotopic_mz": "975.2556",
                                "intensity": "1284.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "38",
                                "monoisotopic_mass": "5485.3780",
                                "monoisotopic_mz": "915.2369",
                                "intensity": "1054.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "39",
                                "monoisotopic_mass": "9007.4042",
                                "monoisotopic_mz": "1001.8300",
                                "intensity": "2441.63",
                                "charge": "9"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "40",
                                "monoisotopic_mass": "15887.1415",
                                "monoisotopic_mz": "883.6262",
                                "intensity": "1363.46",
                                "charge": "18"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "41",
                                "monoisotopic_mass": "826.4164",
                                "monoisotopic_mz": "827.4237",
                                "intensity": "1025.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "42",
                                "monoisotopic_mass": "11078.0520",
                                "monoisotopic_mz": "853.1651",
                                "intensity": "2511.76",
                                "charge": "13"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "43",
                                "monoisotopic_mass": "7424.7529",
                                "monoisotopic_mz": "929.1014",
                                "intensity": "3082.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "44",
                                "monoisotopic_mass": "6088.0549",
                                "monoisotopic_mz": "1015.6831",
                                "intensity": "2833.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "45",
                                "monoisotopic_mass": "12742.0554",
                                "monoisotopic_mz": "850.4776",
                                "intensity": "1408.69",
                                "charge": "15"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "46",
                                "monoisotopic_mass": "1020.3082",
                                "monoisotopic_mz": "1021.3155",
                                "intensity": "808.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "47",
                                "monoisotopic_mass": "4424.2395",
                                "monoisotopic_mz": "885.8552",
                                "intensity": "2981.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "48",
                                "monoisotopic_mass": "10567.1475",
                                "monoisotopic_mz": "881.6029",
                                "intensity": "2627.76",
                                "charge": "12"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "49",
                                "monoisotopic_mass": "5544.7691",
                                "monoisotopic_mz": "1109.9611",
                                "intensity": "2077.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "50",
                                "monoisotopic_mass": "6179.1777",
                                "monoisotopic_mz": "883.7470",
                                "intensity": "1164.54",
                                "charge": "7"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "51",
                                "monoisotopic_mass": "3266.6964",
                                "monoisotopic_mz": "1089.9061",
                                "intensity": "831.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "165",
                                "peak_id": "52",
                                "monoisotopic_mass": "8027.4119",
                                "monoisotopic_mz": "892.9419",
                                "intensity": "1516.52",
                                "charge": "9"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "165",
                                        "peak_id": "11",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "165",
                                        "peak_id": "2",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "165",
                                        "peak_id": "13",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "165",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "64",
                                        "ion_display_position": "64",
                                        "spec_id": "165",
                                        "peak_id": "31",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "spec_id": "165",
                                        "peak_id": "3",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "spec_id": "165",
                                        "peak_id": "4",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "165",
                                            "peak_id": "1",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "165",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "spec_id": "165",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "141",
                                        "ion_display_position": "7",
                                        "spec_id": "165",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "spec_id": "165",
                                        "peak_id": "24",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "105",
                "p_value": "2.37e-07",
                "e_value": "2.37e-07",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "102",
                        "ms1_scans": "248",
                        "ids": "145",
                        "scans": "249",
                        "precursor_mono_mass": "15921.2011",
                        "precursor_charge": "17",
                        "precursor_mz": "937.5485",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "145",
                                "peak_id": "0",
                                "monoisotopic_mass": "7543.8739",
                                "monoisotopic_mz": "1078.7035",
                                "intensity": "13720.88",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0056",
                                        "ppm": "-0.74"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "1",
                                "monoisotopic_mass": "4361.2194",
                                "monoisotopic_mz": "873.2512",
                                "intensity": "7990.82",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0002",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "2",
                                "monoisotopic_mass": "3738.9340",
                                "monoisotopic_mz": "935.7408",
                                "intensity": "8862.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "3",
                                "monoisotopic_mass": "1136.6189",
                                "monoisotopic_mz": "1137.6262",
                                "intensity": "5459.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "4",
                                "monoisotopic_mass": "6429.3376",
                                "monoisotopic_mz": "1286.8748",
                                "intensity": "7974.34",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0017",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "5",
                                "monoisotopic_mass": "8007.1434",
                                "monoisotopic_mz": "890.6899",
                                "intensity": "13034.12",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8007.1407",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0027",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "6",
                                "monoisotopic_mass": "6882.4510",
                                "monoisotopic_mz": "861.3137",
                                "intensity": "5299.89",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "7",
                                "monoisotopic_mass": "1065.5457",
                                "monoisotopic_mz": "1066.5530",
                                "intensity": "3248.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "8",
                                "monoisotopic_mass": "6543.5616",
                                "monoisotopic_mz": "935.8018",
                                "intensity": "14985.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "9",
                                "monoisotopic_mass": "920.4758",
                                "monoisotopic_mz": "921.4831",
                                "intensity": "3063.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "920.4756",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0002",
                                        "ppm": "0.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "10",
                                "monoisotopic_mass": "4360.2139",
                                "monoisotopic_mz": "1091.0608",
                                "intensity": "6196.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "11",
                                "monoisotopic_mass": "1742.4587",
                                "monoisotopic_mz": "872.2366",
                                "intensity": "2595.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "12",
                                "monoisotopic_mass": "2582.9778",
                                "monoisotopic_mz": "861.9999",
                                "intensity": "3668.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "13",
                                "monoisotopic_mass": "4051.0883",
                                "monoisotopic_mz": "1013.7793",
                                "intensity": "3407.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "14",
                                "monoisotopic_mass": "7473.8607",
                                "monoisotopic_mz": "1246.6507",
                                "intensity": "2205.39",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0160",
                                        "ppm": "2.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "15",
                                "monoisotopic_mass": "4530.0463",
                                "monoisotopic_mz": "907.0165",
                                "intensity": "834.05",
                                "charge": "5"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "16",
                                "monoisotopic_mass": "10937.6840",
                                "monoisotopic_mz": "912.4809",
                                "intensity": "1249.72",
                                "charge": "12"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "17",
                                "monoisotopic_mass": "5176.7119",
                                "monoisotopic_mz": "1036.3497",
                                "intensity": "959.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "18",
                                "monoisotopic_mass": "905.8007",
                                "monoisotopic_mz": "906.8079",
                                "intensity": "1180.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "19",
                                "monoisotopic_mass": "13790.7567",
                                "monoisotopic_mz": "920.3911",
                                "intensity": "1177.18",
                                "charge": "15"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "20",
                                "monoisotopic_mass": "2232.7360",
                                "monoisotopic_mz": "1117.3753",
                                "intensity": "881.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "21",
                                "monoisotopic_mass": "8735.6053",
                                "monoisotopic_mz": "874.5678",
                                "intensity": "5056.26",
                                "charge": "10"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "22",
                                "monoisotopic_mass": "2045.5475",
                                "monoisotopic_mz": "1023.7810",
                                "intensity": "2234.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "23",
                                "monoisotopic_mass": "3872.9998",
                                "monoisotopic_mz": "969.2572",
                                "intensity": "1032.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "24",
                                "monoisotopic_mass": "7277.9086",
                                "monoisotopic_mz": "1040.7085",
                                "intensity": "736.33",
                                "charge": "7"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "25",
                                "monoisotopic_mass": "15589.2036",
                                "monoisotopic_mz": "1040.2875",
                                "intensity": "1241.39",
                                "charge": "15"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "26",
                                "monoisotopic_mass": "2123.0753",
                                "monoisotopic_mz": "1062.5449",
                                "intensity": "4856.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "27",
                                "monoisotopic_mass": "9692.3432",
                                "monoisotopic_mz": "1212.5502",
                                "intensity": "1150.58",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "28",
                                "monoisotopic_mass": "1039.5650",
                                "monoisotopic_mz": "1040.5723",
                                "intensity": "1184.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1039.5662",
                                        "ion_position": "139",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "139",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "29",
                                "monoisotopic_mass": "2602.6629",
                                "monoisotopic_mz": "868.5616",
                                "intensity": "2418.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "30",
                                "monoisotopic_mass": "8941.8744",
                                "monoisotopic_mz": "895.1947",
                                "intensity": "957.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "31",
                                "monoisotopic_mass": "1087.7214",
                                "monoisotopic_mz": "1088.7286",
                                "intensity": "1257.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "32",
                                "monoisotopic_mass": "8960.1218",
                                "monoisotopic_mz": "996.5764",
                                "intensity": "1964.97",
                                "charge": "9"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "33",
                                "monoisotopic_mass": "966.5103",
                                "monoisotopic_mz": "967.5176",
                                "intensity": "1407.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "34",
                                "monoisotopic_mass": "755.4180",
                                "monoisotopic_mz": "756.4252",
                                "intensity": "2245.72",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "142",
                                        "mass_error": "0.0002",
                                        "ppm": "0.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "35",
                                "monoisotopic_mass": "1001.3944",
                                "monoisotopic_mz": "1002.4017",
                                "intensity": "1585.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "36",
                                "monoisotopic_mass": "12044.4109",
                                "monoisotopic_mz": "1004.7082",
                                "intensity": "1701.49",
                                "charge": "12"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "37",
                                "monoisotopic_mass": "5640.8605",
                                "monoisotopic_mz": "941.1507",
                                "intensity": "2822.14",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5640.8601",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "0.0004",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "38",
                                "monoisotopic_mass": "6274.1922",
                                "monoisotopic_mz": "1046.7060",
                                "intensity": "2948.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "39",
                                "monoisotopic_mass": "6310.3188",
                                "monoisotopic_mz": "1052.7271",
                                "intensity": "1163.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "40",
                                "monoisotopic_mass": "7776.3173",
                                "monoisotopic_mz": "973.0469",
                                "intensity": "2452.62",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "41",
                                "monoisotopic_mass": "2135.7712",
                                "monoisotopic_mz": "1068.8929",
                                "intensity": "2508.69",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "42",
                                "monoisotopic_mass": "8932.9593",
                                "monoisotopic_mz": "1117.6272",
                                "intensity": "1235.72",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "43",
                                "monoisotopic_mass": "8365.9290",
                                "monoisotopic_mz": "1046.7484",
                                "intensity": "1172.78",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "44",
                                "monoisotopic_mass": "950.4880",
                                "monoisotopic_mz": "951.4952",
                                "intensity": "1076.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "45",
                                "monoisotopic_mass": "888.3479",
                                "monoisotopic_mz": "889.3552",
                                "intensity": "1729.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "46",
                                "monoisotopic_mass": "10427.2072",
                                "monoisotopic_mz": "1043.7280",
                                "intensity": "1218.20",
                                "charge": "10"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "47",
                                "monoisotopic_mass": "3471.1041",
                                "monoisotopic_mz": "1158.0420",
                                "intensity": "1041.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "48",
                                "monoisotopic_mass": "1246.8127",
                                "monoisotopic_mz": "1247.8199",
                                "intensity": "1175.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "49",
                                "monoisotopic_mass": "3763.4393",
                                "monoisotopic_mz": "941.8671",
                                "intensity": "1022.29",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "50",
                                "monoisotopic_mass": "7210.3244",
                                "monoisotopic_mz": "1031.0536",
                                "intensity": "1992.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "51",
                                "monoisotopic_mass": "1299.6827",
                                "monoisotopic_mz": "1300.6899",
                                "intensity": "1215.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1299.6823",
                                        "ion_position": "137",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "137",
                                        "mass_error": "0.0003",
                                        "ppm": "0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "52",
                                "monoisotopic_mass": "2728.4031",
                                "monoisotopic_mz": "910.4750",
                                "intensity": "4403.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "53",
                                "monoisotopic_mass": "1118.1648",
                                "monoisotopic_mz": "1119.1721",
                                "intensity": "733.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "54",
                                "monoisotopic_mass": "7890.0157",
                                "monoisotopic_mz": "877.6757",
                                "intensity": "2777.63",
                                "charge": "9"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "55",
                                "monoisotopic_mass": "8425.1361",
                                "monoisotopic_mz": "937.1335",
                                "intensity": "2366.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "56",
                                "monoisotopic_mass": "7679.9845",
                                "monoisotopic_mz": "961.0053",
                                "intensity": "1211.80",
                                "charge": "8"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "57",
                                "monoisotopic_mass": "8217.3751",
                                "monoisotopic_mz": "914.0490",
                                "intensity": "2994.63",
                                "charge": "9"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "58",
                                "monoisotopic_mass": "4022.1048",
                                "monoisotopic_mz": "1006.5335",
                                "intensity": "2287.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "59",
                                "monoisotopic_mass": "3215.6781",
                                "monoisotopic_mz": "1072.9000",
                                "intensity": "2403.94",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "60",
                                "monoisotopic_mass": "4514.8970",
                                "monoisotopic_mz": "1129.7315",
                                "intensity": "969.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "61",
                                "monoisotopic_mass": "1175.9917",
                                "monoisotopic_mz": "1176.9990",
                                "intensity": "693.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "62",
                                "monoisotopic_mass": "3255.1948",
                                "monoisotopic_mz": "1086.0722",
                                "intensity": "2175.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "63",
                                "monoisotopic_mass": "2001.1678",
                                "monoisotopic_mz": "1001.5912",
                                "intensity": "1895.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "64",
                                "monoisotopic_mass": "2083.7474",
                                "monoisotopic_mz": "1042.8810",
                                "intensity": "1856.96",
                                "charge": "2"
                            },
                            {
                                "spec_id": "145",
                                "peak_id": "65",
                                "monoisotopic_mass": "2170.7979",
                                "monoisotopic_mz": "1086.4062",
                                "intensity": "1459.24",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "145",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "145",
                                        "peak_id": "1",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "145",
                                        "peak_id": "37",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "spec_id": "145",
                                        "peak_id": "5",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "spec_id": "145",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "spec_id": "145",
                                        "peak_id": "14",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "spec_id": "145",
                                        "peak_id": "4",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "137",
                                        "ion_display_position": "11",
                                        "spec_id": "145",
                                        "peak_id": "51",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "spec_id": "145",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "139",
                                        "ion_display_position": "9",
                                        "spec_id": "145",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "spec_id": "145",
                                        "peak_id": "34",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "63",
                "p_value": "8.06e-07",
                "e_value": "8.06e-07",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "82",
                        "ms1_scans": "166",
                        "ids": "84",
                        "scans": "168",
                        "precursor_mono_mass": "15921.2082",
                        "precursor_charge": "18",
                        "precursor_mz": "885.5188",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "84",
                                "peak_id": "0",
                                "monoisotopic_mass": "4360.2096",
                                "monoisotopic_mz": "873.0492",
                                "intensity": "6732.73",
                                "charge": "5"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "1",
                                "monoisotopic_mass": "8006.1206",
                                "monoisotopic_mz": "890.5762",
                                "intensity": "9430.52",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8007.1407",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "-0.0177",
                                        "ppm": "-2.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "2",
                                "monoisotopic_mass": "2309.2462",
                                "monoisotopic_mz": "1155.6304",
                                "intensity": "3018.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2309.2454",
                                        "ion_position": "128",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "128",
                                        "mass_error": "0.0009",
                                        "ppm": "0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "3",
                                "monoisotopic_mass": "4361.2235",
                                "monoisotopic_mz": "1091.3132",
                                "intensity": "7224.44",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0042",
                                        "ppm": "0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "4",
                                "monoisotopic_mass": "1136.6191",
                                "monoisotopic_mz": "1137.6263",
                                "intensity": "4790.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "0.0001",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "5",
                                "monoisotopic_mass": "6411.3140",
                                "monoisotopic_mz": "1069.5596",
                                "intensity": "7528.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "6",
                                "monoisotopic_mass": "7543.8747",
                                "monoisotopic_mz": "1078.7037",
                                "intensity": "11740.74",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0047",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "7",
                                "monoisotopic_mass": "2087.0800",
                                "monoisotopic_mz": "1044.5473",
                                "intensity": "2874.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "8",
                                "monoisotopic_mass": "755.4183",
                                "monoisotopic_mz": "756.4256",
                                "intensity": "2871.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "142",
                                        "mass_error": "0.0005",
                                        "ppm": "0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "9",
                                "monoisotopic_mass": "883.9496",
                                "monoisotopic_mz": "884.9569",
                                "intensity": "2721.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "10",
                                "monoisotopic_mass": "3819.9990",
                                "monoisotopic_mz": "956.0070",
                                "intensity": "4607.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "11",
                                "monoisotopic_mass": "7890.0539",
                                "monoisotopic_mz": "877.6799",
                                "intensity": "1391.85",
                                "charge": "9"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "12",
                                "monoisotopic_mass": "3314.3400",
                                "monoisotopic_mz": "1105.7873",
                                "intensity": "1511.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "13",
                                "monoisotopic_mass": "6626.3637",
                                "monoisotopic_mz": "947.6307",
                                "intensity": "1462.80",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6627.3634",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "B00062",
                                        "ion_left_position": "62",
                                        "mass_error": "0.0026",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "14",
                                "monoisotopic_mass": "14039.9490",
                                "monoisotopic_mz": "878.5041",
                                "intensity": "1433.52",
                                "charge": "16"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "15",
                                "monoisotopic_mass": "8853.4242",
                                "monoisotopic_mz": "886.3497",
                                "intensity": "2219.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "16",
                                "monoisotopic_mass": "901.9587",
                                "monoisotopic_mz": "902.9660",
                                "intensity": "1292.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "17",
                                "monoisotopic_mass": "6199.5805",
                                "monoisotopic_mz": "886.6616",
                                "intensity": "1488.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "18",
                                "monoisotopic_mass": "8046.1400",
                                "monoisotopic_mz": "895.0228",
                                "intensity": "881.20",
                                "charge": "9"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "19",
                                "monoisotopic_mass": "920.4747",
                                "monoisotopic_mz": "921.4819",
                                "intensity": "1790.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "920.4756",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0009",
                                        "ppm": "-1.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "20",
                                "monoisotopic_mass": "818.4142",
                                "monoisotopic_mz": "819.4215",
                                "intensity": "1249.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "21",
                                "monoisotopic_mass": "4706.9196",
                                "monoisotopic_mz": "942.3912",
                                "intensity": "2320.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "22",
                                "monoisotopic_mass": "1928.9730",
                                "monoisotopic_mz": "965.4938",
                                "intensity": "1905.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "23",
                                "monoisotopic_mass": "7515.9659",
                                "monoisotopic_mz": "836.1146",
                                "intensity": "2604.06",
                                "charge": "9"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "24",
                                "monoisotopic_mass": "3531.6077",
                                "monoisotopic_mz": "883.9092",
                                "intensity": "1220.93",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "25",
                                "monoisotopic_mass": "11908.1972",
                                "monoisotopic_mz": "917.0224",
                                "intensity": "2436.67",
                                "charge": "13"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "26",
                                "monoisotopic_mass": "12566.9403",
                                "monoisotopic_mz": "1048.2523",
                                "intensity": "2803.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "27",
                                "monoisotopic_mass": "937.6315",
                                "monoisotopic_mz": "938.6388",
                                "intensity": "1231.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "28",
                                "monoisotopic_mass": "6566.4180",
                                "monoisotopic_mz": "939.0670",
                                "intensity": "2399.09",
                                "charge": "7"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "29",
                                "monoisotopic_mass": "8389.4451",
                                "monoisotopic_mz": "933.1678",
                                "intensity": "2483.43",
                                "charge": "9"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "30",
                                "monoisotopic_mass": "997.0542",
                                "monoisotopic_mz": "998.0615",
                                "intensity": "1185.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "31",
                                "monoisotopic_mass": "4151.1220",
                                "monoisotopic_mz": "1038.7878",
                                "intensity": "1071.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "32",
                                "monoisotopic_mass": "3997.3326",
                                "monoisotopic_mz": "1000.3404",
                                "intensity": "2031.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "33",
                                "monoisotopic_mass": "8546.4408",
                                "monoisotopic_mz": "1069.3124",
                                "intensity": "2163.81",
                                "charge": "8"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "34",
                                "monoisotopic_mass": "9330.8209",
                                "monoisotopic_mz": "934.0894",
                                "intensity": "2772.64",
                                "charge": "10"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "35",
                                "monoisotopic_mass": "853.5486",
                                "monoisotopic_mz": "854.5558",
                                "intensity": "1339.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "36",
                                "monoisotopic_mass": "834.6512",
                                "monoisotopic_mz": "835.6585",
                                "intensity": "1234.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "37",
                                "monoisotopic_mass": "979.5114",
                                "monoisotopic_mz": "980.5187",
                                "intensity": "1649.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "38",
                                "monoisotopic_mass": "4419.2361",
                                "monoisotopic_mz": "884.8545",
                                "intensity": "2782.65",
                                "charge": "5"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "39",
                                "monoisotopic_mass": "1077.3409",
                                "monoisotopic_mz": "1078.3481",
                                "intensity": "826.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "40",
                                "monoisotopic_mass": "7963.0850",
                                "monoisotopic_mz": "885.7945",
                                "intensity": "1419.00",
                                "charge": "9"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "41",
                                "monoisotopic_mass": "1015.1934",
                                "monoisotopic_mz": "1016.2006",
                                "intensity": "1895.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "42",
                                "monoisotopic_mass": "1047.5419",
                                "monoisotopic_mz": "1048.5492",
                                "intensity": "2011.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "43",
                                "monoisotopic_mass": "6258.2730",
                                "monoisotopic_mz": "1044.0528",
                                "intensity": "2795.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "44",
                                "monoisotopic_mass": "1853.6689",
                                "monoisotopic_mz": "927.8417",
                                "intensity": "1672.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "45",
                                "monoisotopic_mass": "3954.1458",
                                "monoisotopic_mz": "989.5437",
                                "intensity": "1219.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "46",
                                "monoisotopic_mass": "1064.5390",
                                "monoisotopic_mz": "1065.5463",
                                "intensity": "1458.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "47",
                                "monoisotopic_mass": "4132.2474",
                                "monoisotopic_mz": "827.4568",
                                "intensity": "1922.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "48",
                                "monoisotopic_mass": "1101.3367",
                                "monoisotopic_mz": "1102.3440",
                                "intensity": "1132.81",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "49",
                                "monoisotopic_mass": "5525.8147",
                                "monoisotopic_mz": "1106.1702",
                                "intensity": "1976.34",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5525.8332",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0185",
                                        "ppm": "-3.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "50",
                                "monoisotopic_mass": "15377.4442",
                                "monoisotopic_mz": "905.5628",
                                "intensity": "1024.56",
                                "charge": "17"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "51",
                                "monoisotopic_mass": "5873.0855",
                                "monoisotopic_mz": "979.8549",
                                "intensity": "2356.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5874.0707",
                                        "ion_position": "96",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "96",
                                        "mass_error": "0.0172",
                                        "ppm": "2.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "52",
                                "monoisotopic_mass": "1790.5967",
                                "monoisotopic_mz": "896.3056",
                                "intensity": "1840.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "53",
                                "monoisotopic_mass": "1346.9323",
                                "monoisotopic_mz": "1347.9396",
                                "intensity": "1349.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "54",
                                "monoisotopic_mass": "4060.4124",
                                "monoisotopic_mz": "1016.1104",
                                "intensity": "1822.49",
                                "charge": "4"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "55",
                                "monoisotopic_mass": "5371.8915",
                                "monoisotopic_mz": "896.3225",
                                "intensity": "1119.20",
                                "charge": "6"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "56",
                                "monoisotopic_mass": "6174.2277",
                                "monoisotopic_mz": "883.0398",
                                "intensity": "1098.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "57",
                                "monoisotopic_mass": "4190.1707",
                                "monoisotopic_mz": "839.0414",
                                "intensity": "2930.02",
                                "charge": "5"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "58",
                                "monoisotopic_mass": "2024.0275",
                                "monoisotopic_mz": "1013.0210",
                                "intensity": "2162.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "84",
                                "peak_id": "59",
                                "monoisotopic_mass": "2049.4322",
                                "monoisotopic_mz": "1025.7234",
                                "intensity": "1604.85",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "84",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "84",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "84",
                                        "peak_id": "49",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "62",
                                        "ion_display_position": "62",
                                        "spec_id": "84",
                                        "peak_id": "13",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "spec_id": "84",
                                        "peak_id": "1",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "spec_id": "84",
                                        "peak_id": "6",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "96",
                                        "ion_display_position": "52",
                                        "spec_id": "84",
                                        "peak_id": "51",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "128",
                                        "ion_display_position": "20",
                                        "spec_id": "84",
                                        "peak_id": "2",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "spec_id": "84",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "spec_id": "84",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "154",
                "p_value": "6.59e-05",
                "e_value": "6.59e-05",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "122",
                        "ms1_scans": "336",
                        "ids": "214",
                        "scans": "338",
                        "precursor_mono_mass": "15920.2217",
                        "precursor_charge": "18",
                        "precursor_mz": "885.4640",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "214",
                                "peak_id": "0",
                                "monoisotopic_mass": "6429.3433",
                                "monoisotopic_mz": "1072.5645",
                                "intensity": "15095.11",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0074",
                                        "ppm": "1.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "1",
                                "monoisotopic_mass": "6428.3438",
                                "monoisotopic_mz": "919.3421",
                                "intensity": "6634.85",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6427.2473",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "B00060",
                                            "ion_left_position": "60",
                                            "mass_error": "0.0942",
                                            "ppm": "14.65"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6429.3359",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "ion_sort_name": "Y00058",
                                            "ion_left_position": "90",
                                            "mass_error": "0.0102",
                                            "ppm": "1.59"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "2",
                                "monoisotopic_mass": "4361.2136",
                                "monoisotopic_mz": "873.2500",
                                "intensity": "9491.96",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "3",
                                "monoisotopic_mass": "2137.1112",
                                "monoisotopic_mz": "1069.5629",
                                "intensity": "4274.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "4",
                                "monoisotopic_mass": "1136.6195",
                                "monoisotopic_mz": "1137.6268",
                                "intensity": "4562.90",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "0.0005",
                                        "ppm": "0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "5",
                                "monoisotopic_mass": "4360.2173",
                                "monoisotopic_mz": "1091.0616",
                                "intensity": "5375.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "6",
                                "monoisotopic_mass": "3535.7941",
                                "monoisotopic_mz": "884.9558",
                                "intensity": "5081.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "7",
                                "monoisotopic_mass": "7062.6479",
                                "monoisotopic_mz": "883.8383",
                                "intensity": "2676.87",
                                "charge": "8"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "8",
                                "monoisotopic_mass": "5873.0642",
                                "monoisotopic_mz": "979.8513",
                                "intensity": "2663.20",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5874.0707",
                                        "ion_position": "96",
                                        "ion_display_position": "52",
                                        "ion_sort_name": "Y00052",
                                        "ion_left_position": "96",
                                        "mass_error": "-0.0041",
                                        "ppm": "-0.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "9",
                                "monoisotopic_mass": "4574.2466",
                                "monoisotopic_mz": "915.8566",
                                "intensity": "3242.20",
                                "charge": "5"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "10",
                                "monoisotopic_mass": "2669.7112",
                                "monoisotopic_mz": "890.9110",
                                "intensity": "2677.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "11",
                                "monoisotopic_mass": "3055.8577",
                                "monoisotopic_mz": "1019.6265",
                                "intensity": "2559.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "12",
                                "monoisotopic_mass": "3761.9085",
                                "monoisotopic_mz": "941.4844",
                                "intensity": "3168.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "13",
                                "monoisotopic_mass": "11428.8397",
                                "monoisotopic_mz": "953.4106",
                                "intensity": "2434.03",
                                "charge": "12",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-1.9123669624",
                                        "theoretical_mass": "11428.9692",
                                        "ion_position": "109",
                                        "ion_display_position": "109",
                                        "ion_sort_name": "B00109",
                                        "ion_left_position": "109",
                                        "mass_error": "-0.1295",
                                        "ppm": "-11.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "14",
                                "monoisotopic_mass": "3012.6170",
                                "monoisotopic_mz": "1005.2129",
                                "intensity": "2481.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "15",
                                "monoisotopic_mass": "2202.4296",
                                "monoisotopic_mz": "1102.2221",
                                "intensity": "1059.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "16",
                                "monoisotopic_mass": "980.4864",
                                "monoisotopic_mz": "981.4937",
                                "intensity": "1314.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "17",
                                "monoisotopic_mass": "2081.0686",
                                "monoisotopic_mz": "1041.5416",
                                "intensity": "1888.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "18",
                                "monoisotopic_mass": "2308.2436",
                                "monoisotopic_mz": "1155.1291",
                                "intensity": "987.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "19",
                                "monoisotopic_mass": "914.2219",
                                "monoisotopic_mz": "915.2291",
                                "intensity": "988.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "20",
                                "monoisotopic_mass": "9793.4042",
                                "monoisotopic_mz": "980.3477",
                                "intensity": "999.01",
                                "charge": "10"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "21",
                                "monoisotopic_mass": "1780.8990",
                                "monoisotopic_mz": "891.4568",
                                "intensity": "1209.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "22",
                                "monoisotopic_mass": "938.9865",
                                "monoisotopic_mz": "939.9938",
                                "intensity": "1381.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "23",
                                "monoisotopic_mass": "8849.8181",
                                "monoisotopic_mz": "885.9891",
                                "intensity": "826.46",
                                "charge": "10"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "24",
                                "monoisotopic_mass": "6089.1594",
                                "monoisotopic_mz": "1015.8672",
                                "intensity": "2910.78",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6089.1613",
                                        "ion_position": "94",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "94",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "25",
                                "monoisotopic_mass": "6428.3450",
                                "monoisotopic_mz": "1286.6763",
                                "intensity": "1218.06",
                                "charge": "5",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6427.2473",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "B00060",
                                            "ion_left_position": "60",
                                            "mass_error": "0.0954",
                                            "ppm": "14.84"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6429.3359",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "ion_sort_name": "Y00058",
                                            "ion_left_position": "90",
                                            "mass_error": "0.0114",
                                            "ppm": "1.78"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "26",
                                "monoisotopic_mass": "9337.8381",
                                "monoisotopic_mz": "1038.5448",
                                "intensity": "1320.58",
                                "charge": "9"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "27",
                                "monoisotopic_mass": "4090.0760",
                                "monoisotopic_mz": "819.0225",
                                "intensity": "1156.52",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4090.0661",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0099",
                                        "ppm": "2.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "28",
                                "monoisotopic_mass": "4415.3601",
                                "monoisotopic_mz": "884.0793",
                                "intensity": "2622.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "29",
                                "monoisotopic_mass": "5393.7677",
                                "monoisotopic_mz": "899.9686",
                                "intensity": "686.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "30",
                                "monoisotopic_mass": "871.2291",
                                "monoisotopic_mz": "872.2363",
                                "intensity": "1593.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "31",
                                "monoisotopic_mass": "8782.4013",
                                "monoisotopic_mz": "976.8296",
                                "intensity": "1277.38",
                                "charge": "9"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "32",
                                "monoisotopic_mass": "1000.5133",
                                "monoisotopic_mz": "1001.5206",
                                "intensity": "1354.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "33",
                                "monoisotopic_mass": "3710.9766",
                                "monoisotopic_mz": "928.7514",
                                "intensity": "905.66",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "34",
                                "monoisotopic_mass": "1100.8935",
                                "monoisotopic_mz": "1101.9008",
                                "intensity": "2165.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "35",
                                "monoisotopic_mass": "5211.6085",
                                "monoisotopic_mz": "1043.3290",
                                "intensity": "1099.25",
                                "charge": "5"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "36",
                                "monoisotopic_mass": "6371.2432",
                                "monoisotopic_mz": "911.1849",
                                "intensity": "1230.34",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6370.2258",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "ion_sort_name": "B00059",
                                        "ion_left_position": "59",
                                        "mass_error": "0.0150",
                                        "ppm": "2.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "37",
                                "monoisotopic_mass": "1073.2625",
                                "monoisotopic_mz": "1074.2698",
                                "intensity": "1072.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "38",
                                "monoisotopic_mass": "1027.0355",
                                "monoisotopic_mz": "1028.0427",
                                "intensity": "688.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "39",
                                "monoisotopic_mass": "4212.4940",
                                "monoisotopic_mz": "843.5061",
                                "intensity": "1915.84",
                                "charge": "5"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "40",
                                "monoisotopic_mass": "6295.4020",
                                "monoisotopic_mz": "900.3504",
                                "intensity": "1984.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "41",
                                "monoisotopic_mass": "755.4197",
                                "monoisotopic_mz": "756.4270",
                                "intensity": "1802.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "142",
                                        "mass_error": "0.0019",
                                        "ppm": "2.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "42",
                                "monoisotopic_mass": "953.3060",
                                "monoisotopic_mz": "954.3133",
                                "intensity": "999.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "43",
                                "monoisotopic_mass": "887.4756",
                                "monoisotopic_mz": "888.4829",
                                "intensity": "1658.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "44",
                                "monoisotopic_mass": "12399.5243",
                                "monoisotopic_mz": "954.8168",
                                "intensity": "1118.17",
                                "charge": "13"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "45",
                                "monoisotopic_mass": "7758.9186",
                                "monoisotopic_mz": "863.1093",
                                "intensity": "1204.97",
                                "charge": "9"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "46",
                                "monoisotopic_mass": "2795.9946",
                                "monoisotopic_mz": "933.0055",
                                "intensity": "1087.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "47",
                                "monoisotopic_mass": "8756.2303",
                                "monoisotopic_mz": "876.6303",
                                "intensity": "886.03",
                                "charge": "10"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "48",
                                "monoisotopic_mass": "5462.8917",
                                "monoisotopic_mz": "1093.5856",
                                "intensity": "928.00",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5462.8912",
                                        "ion_position": "99",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "99",
                                        "mass_error": "0.0005",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "49",
                                "monoisotopic_mass": "845.4248",
                                "monoisotopic_mz": "846.4321",
                                "intensity": "1248.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "50",
                                "monoisotopic_mass": "1121.2409",
                                "monoisotopic_mz": "1122.2482",
                                "intensity": "733.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "51",
                                "monoisotopic_mass": "2695.0715",
                                "monoisotopic_mz": "899.3644",
                                "intensity": "2034.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "52",
                                "monoisotopic_mass": "7022.5827",
                                "monoisotopic_mz": "878.8301",
                                "intensity": "2313.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "53",
                                "monoisotopic_mass": "8271.1614",
                                "monoisotopic_mz": "1034.9025",
                                "intensity": "1223.81",
                                "charge": "8"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "54",
                                "monoisotopic_mass": "14020.0743",
                                "monoisotopic_mz": "935.6789",
                                "intensity": "1166.13",
                                "charge": "15"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "55",
                                "monoisotopic_mass": "1925.7410",
                                "monoisotopic_mz": "963.8778",
                                "intensity": "1353.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "56",
                                "monoisotopic_mass": "14139.3220",
                                "monoisotopic_mz": "884.7149",
                                "intensity": "2449.34",
                                "charge": "16"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "57",
                                "monoisotopic_mass": "3852.5199",
                                "monoisotopic_mz": "964.1372",
                                "intensity": "831.60",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "58",
                                "monoisotopic_mass": "9112.0076",
                                "monoisotopic_mz": "1013.4526",
                                "intensity": "1205.87",
                                "charge": "9"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "59",
                                "monoisotopic_mass": "2631.6972",
                                "monoisotopic_mz": "878.2397",
                                "intensity": "1003.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "60",
                                "monoisotopic_mass": "6323.8006",
                                "monoisotopic_mz": "904.4074",
                                "intensity": "1744.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "61",
                                "monoisotopic_mass": "965.4911",
                                "monoisotopic_mz": "966.4984",
                                "intensity": "1114.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "62",
                                "monoisotopic_mass": "15490.1156",
                                "monoisotopic_mz": "861.5693",
                                "intensity": "1227.48",
                                "charge": "18",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-1.9123669624",
                                        "theoretical_mass": "15489.1148",
                                        "ion_position": "4",
                                        "ion_display_position": "144",
                                        "ion_sort_name": "Y00144",
                                        "ion_left_position": "4",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "63",
                                "monoisotopic_mass": "1720.8668",
                                "monoisotopic_mz": "861.4407",
                                "intensity": "2145.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "64",
                                "monoisotopic_mass": "3272.6710",
                                "monoisotopic_mz": "1091.8976",
                                "intensity": "2240.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "65",
                                "monoisotopic_mass": "5569.7555",
                                "monoisotopic_mz": "929.2999",
                                "intensity": "2076.42",
                                "charge": "6"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "66",
                                "monoisotopic_mass": "7421.6256",
                                "monoisotopic_mz": "928.7105",
                                "intensity": "813.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "67",
                                "monoisotopic_mass": "2611.3421",
                                "monoisotopic_mz": "871.4546",
                                "intensity": "2785.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "68",
                                "monoisotopic_mass": "9264.7987",
                                "monoisotopic_mz": "843.2617",
                                "intensity": "942.67",
                                "charge": "11"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "69",
                                "monoisotopic_mass": "6583.9573",
                                "monoisotopic_mz": "941.5726",
                                "intensity": "2631.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "70",
                                "monoisotopic_mass": "2582.3490",
                                "monoisotopic_mz": "861.7903",
                                "intensity": "997.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "71",
                                "monoisotopic_mass": "3875.5063",
                                "monoisotopic_mz": "969.8838",
                                "intensity": "1010.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "72",
                                "monoisotopic_mass": "2746.8630",
                                "monoisotopic_mz": "916.6283",
                                "intensity": "1107.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "73",
                                "monoisotopic_mass": "6184.2720",
                                "monoisotopic_mz": "1031.7193",
                                "intensity": "2272.74",
                                "charge": "6"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "74",
                                "monoisotopic_mass": "900.8075",
                                "monoisotopic_mz": "901.8148",
                                "intensity": "1331.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "75",
                                "monoisotopic_mass": "8305.9949",
                                "monoisotopic_mz": "923.8956",
                                "intensity": "1271.27",
                                "charge": "9"
                            },
                            {
                                "spec_id": "214",
                                "peak_id": "76",
                                "monoisotopic_mass": "810.1196",
                                "monoisotopic_mz": "811.1269",
                                "intensity": "874.06",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15920.3317",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "144",
                                        "spec_id": "214",
                                        "peak_id": "62",
                                        "peak_charge": "18"
                                    }
                                }
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "214",
                                        "peak_id": "27",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "214",
                                        "peak_id": "2",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "214",
                                        "peak_id": "36",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "214",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "spec_id": "214",
                                            "peak_id": "25",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "214",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "214",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "214",
                                            "peak_id": "25",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "94",
                                        "ion_display_position": "54",
                                        "spec_id": "214",
                                        "peak_id": "24",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "96",
                                        "ion_display_position": "52",
                                        "spec_id": "214",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "99",
                                        "ion_display_position": "49",
                                        "spec_id": "214",
                                        "peak_id": "48",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "109",
                                        "ion_display_position": "109",
                                        "spec_id": "214",
                                        "peak_id": "13",
                                        "peak_charge": "12"
                                    }
                                }
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "spec_id": "214",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "spec_id": "214",
                                        "peak_id": "41",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "61",
                            "right_position": "91",
                            "anno": "-1.9124",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "136",
                "p_value": "8.86e-05",
                "e_value": "8.86e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "116",
                        "ms1_scans": "304",
                        "ids": "187",
                        "scans": "305",
                        "precursor_mono_mass": "15922.2107",
                        "precursor_charge": "17",
                        "precursor_mz": "937.6079",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "187",
                                "peak_id": "0",
                                "monoisotopic_mass": "7478.8876",
                                "monoisotopic_mz": "935.8682",
                                "intensity": "22307.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "1",
                                "monoisotopic_mass": "7543.8765",
                                "monoisotopic_mz": "1078.7039",
                                "intensity": "13705.45",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "2",
                                "monoisotopic_mass": "7473.8414",
                                "monoisotopic_mz": "1068.6989",
                                "intensity": "8471.03",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0033",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "3",
                                "monoisotopic_mass": "4361.2226",
                                "monoisotopic_mz": "873.2518",
                                "intensity": "6529.67",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "0.0034",
                                        "ppm": "0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "4",
                                "monoisotopic_mass": "6430.3529",
                                "monoisotopic_mz": "1072.7328",
                                "intensity": "7757.71",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0146",
                                        "ppm": "2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "5",
                                "monoisotopic_mass": "1136.6191",
                                "monoisotopic_mz": "1137.6263",
                                "intensity": "5065.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "0.0001",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "6",
                                "monoisotopic_mass": "13368.7871",
                                "monoisotopic_mz": "1029.3755",
                                "intensity": "2286.04",
                                "charge": "13"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "7",
                                "monoisotopic_mass": "2310.2452",
                                "monoisotopic_mz": "1156.1299",
                                "intensity": "1660.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "8",
                                "monoisotopic_mass": "6540.3445",
                                "monoisotopic_mz": "1091.0647",
                                "intensity": "1548.19",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6540.3314",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "ion_sort_name": "B00061",
                                        "ion_left_position": "61",
                                        "mass_error": "0.0132",
                                        "ppm": "2.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "9",
                                "monoisotopic_mass": "4574.3136",
                                "monoisotopic_mz": "915.8700",
                                "intensity": "2254.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "10",
                                "monoisotopic_mass": "4554.3668",
                                "monoisotopic_mz": "1139.5990",
                                "intensity": "2885.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "11",
                                "monoisotopic_mass": "5639.8633",
                                "monoisotopic_mz": "940.9845",
                                "intensity": "4440.54",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5640.8601",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "0.0055",
                                        "ppm": "0.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "12",
                                "monoisotopic_mass": "986.4931",
                                "monoisotopic_mz": "987.5004",
                                "intensity": "1246.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "13",
                                "monoisotopic_mass": "13008.6363",
                                "monoisotopic_mz": "1001.6716",
                                "intensity": "3170.04",
                                "charge": "13"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "14",
                                "monoisotopic_mass": "15851.8680",
                                "monoisotopic_mz": "933.4701",
                                "intensity": "1217.81",
                                "charge": "17"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "15",
                                "monoisotopic_mass": "2172.1119",
                                "monoisotopic_mz": "1087.0633",
                                "intensity": "1076.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "16",
                                "monoisotopic_mass": "15904.1264",
                                "monoisotopic_mz": "936.5441",
                                "intensity": "1223.64",
                                "charge": "17"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "17",
                                "monoisotopic_mass": "7791.0523",
                                "monoisotopic_mz": "866.6798",
                                "intensity": "1167.36",
                                "charge": "9"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "18",
                                "monoisotopic_mass": "958.7352",
                                "monoisotopic_mz": "959.7424",
                                "intensity": "2121.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "19",
                                "monoisotopic_mass": "14011.3960",
                                "monoisotopic_mz": "935.1003",
                                "intensity": "1382.15",
                                "charge": "15"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "20",
                                "monoisotopic_mass": "7631.6934",
                                "monoisotopic_mz": "1091.2492",
                                "intensity": "1409.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "21",
                                "monoisotopic_mass": "4843.5794",
                                "monoisotopic_mz": "969.7232",
                                "intensity": "3074.37",
                                "charge": "5"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "22",
                                "monoisotopic_mass": "9401.4472",
                                "monoisotopic_mz": "941.1520",
                                "intensity": "2445.45",
                                "charge": "10"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "23",
                                "monoisotopic_mass": "6082.1135",
                                "monoisotopic_mz": "869.8806",
                                "intensity": "2273.31",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "24",
                                "monoisotopic_mass": "1176.7803",
                                "monoisotopic_mz": "1177.7876",
                                "intensity": "974.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "25",
                                "monoisotopic_mass": "7875.0241",
                                "monoisotopic_mz": "876.0099",
                                "intensity": "1269.96",
                                "charge": "9"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "26",
                                "monoisotopic_mass": "5611.1567",
                                "monoisotopic_mz": "936.2001",
                                "intensity": "849.00",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "27",
                                "monoisotopic_mass": "909.2986",
                                "monoisotopic_mz": "910.3058",
                                "intensity": "1795.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "28",
                                "monoisotopic_mass": "2748.5374",
                                "monoisotopic_mz": "917.1864",
                                "intensity": "2176.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "29",
                                "monoisotopic_mass": "7649.8509",
                                "monoisotopic_mz": "850.9907",
                                "intensity": "948.69",
                                "charge": "9"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "30",
                                "monoisotopic_mass": "8119.2189",
                                "monoisotopic_mz": "903.1427",
                                "intensity": "1683.99",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8120.2247",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0035",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "31",
                                "monoisotopic_mass": "10994.1310",
                                "monoisotopic_mz": "917.1849",
                                "intensity": "1271.18",
                                "charge": "12"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "32",
                                "monoisotopic_mass": "755.4177",
                                "monoisotopic_mz": "756.4250",
                                "intensity": "2001.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "142",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "33",
                                "monoisotopic_mass": "9163.6026",
                                "monoisotopic_mz": "1019.1853",
                                "intensity": "1038.65",
                                "charge": "9"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "34",
                                "monoisotopic_mass": "6412.3079",
                                "monoisotopic_mz": "1069.7253",
                                "intensity": "4257.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "35",
                                "monoisotopic_mass": "888.4560",
                                "monoisotopic_mz": "889.4633",
                                "intensity": "1823.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "36",
                                "monoisotopic_mass": "7597.1105",
                                "monoisotopic_mz": "1086.3088",
                                "intensity": "2090.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "37",
                                "monoisotopic_mass": "15305.4358",
                                "monoisotopic_mz": "1021.3697",
                                "intensity": "914.37",
                                "charge": "15"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "38",
                                "monoisotopic_mass": "1015.3628",
                                "monoisotopic_mz": "1016.3701",
                                "intensity": "1295.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "39",
                                "monoisotopic_mass": "11129.4543",
                                "monoisotopic_mz": "928.4618",
                                "intensity": "1631.29",
                                "charge": "12"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "40",
                                "monoisotopic_mass": "11200.7911",
                                "monoisotopic_mz": "1019.2610",
                                "intensity": "1026.60",
                                "charge": "11"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "41",
                                "monoisotopic_mass": "6073.1025",
                                "monoisotopic_mz": "1013.1910",
                                "intensity": "2606.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "42",
                                "monoisotopic_mass": "7004.0136",
                                "monoisotopic_mz": "1001.5807",
                                "intensity": "2379.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "43",
                                "monoisotopic_mass": "4665.4334",
                                "monoisotopic_mz": "934.0940",
                                "intensity": "2134.90",
                                "charge": "5"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "44",
                                "monoisotopic_mass": "8317.1341",
                                "monoisotopic_mz": "1040.6490",
                                "intensity": "1314.91",
                                "charge": "8"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "45",
                                "monoisotopic_mass": "1041.5331",
                                "monoisotopic_mz": "1042.5404",
                                "intensity": "1597.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "46",
                                "monoisotopic_mass": "1136.6184",
                                "monoisotopic_mz": "569.3165",
                                "intensity": "743.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "47",
                                "monoisotopic_mass": "1029.3598",
                                "monoisotopic_mz": "1030.3671",
                                "intensity": "1066.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "48",
                                "monoisotopic_mass": "3046.0880",
                                "monoisotopic_mz": "1016.3699",
                                "intensity": "1406.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "49",
                                "monoisotopic_mass": "11927.7027",
                                "monoisotopic_mz": "1085.3439",
                                "intensity": "917.17",
                                "charge": "11"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "50",
                                "monoisotopic_mass": "4513.0160",
                                "monoisotopic_mz": "903.6105",
                                "intensity": "1775.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "51",
                                "monoisotopic_mass": "2117.4027",
                                "monoisotopic_mz": "1059.7086",
                                "intensity": "2001.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "52",
                                "monoisotopic_mass": "2228.8070",
                                "monoisotopic_mz": "1115.4108",
                                "intensity": "1620.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "53",
                                "monoisotopic_mass": "12613.6765",
                                "monoisotopic_mz": "841.9190",
                                "intensity": "1428.77",
                                "charge": "15"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "54",
                                "monoisotopic_mass": "1737.8855",
                                "monoisotopic_mz": "869.9500",
                                "intensity": "1052.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "55",
                                "monoisotopic_mass": "1839.9252",
                                "monoisotopic_mz": "920.9699",
                                "intensity": "1584.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "56",
                                "monoisotopic_mass": "4303.6290",
                                "monoisotopic_mz": "1076.9145",
                                "intensity": "1682.96",
                                "charge": "4"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "57",
                                "monoisotopic_mass": "11147.5407",
                                "monoisotopic_mz": "929.9690",
                                "intensity": "1342.20",
                                "charge": "12"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "58",
                                "monoisotopic_mass": "859.9233",
                                "monoisotopic_mz": "860.9306",
                                "intensity": "2188.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "187",
                                "peak_id": "59",
                                "monoisotopic_mass": "1056.1170",
                                "monoisotopic_mz": "1057.1243",
                                "intensity": "851.42",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "187",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "187",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "61",
                                        "ion_display_position": "61",
                                        "spec_id": "187",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "spec_id": "187",
                                        "peak_id": "30",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "spec_id": "187",
                                        "peak_id": "1",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "spec_id": "187",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "spec_id": "187",
                                        "peak_id": "4",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "138",
                                            "ion_display_position": "10",
                                            "spec_id": "187",
                                            "peak_id": "46",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "138",
                                            "ion_display_position": "10",
                                            "spec_id": "187",
                                            "peak_id": "5",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "142",
                                        "ion_display_position": "6",
                                        "spec_id": "187",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "91",
                "p_value": "1.16e-04",
                "e_value": "1.16e-04",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "95",
                        "ms1_scans": "220",
                        "ids": "125",
                        "scans": "222",
                        "precursor_mono_mass": "15921.2115",
                        "precursor_charge": "18",
                        "precursor_mz": "885.5190",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "125",
                                "peak_id": "0",
                                "monoisotopic_mass": "7544.8881",
                                "monoisotopic_mz": "1078.8484",
                                "intensity": "10872.68",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "80",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0063",
                                        "ppm": "0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "1",
                                "monoisotopic_mass": "4360.2157",
                                "monoisotopic_mz": "873.0504",
                                "intensity": "10266.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "2",
                                "monoisotopic_mass": "6429.3346",
                                "monoisotopic_mz": "919.4836",
                                "intensity": "11804.13",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6428.2499",
                                            "ion_position": "59",
                                            "ion_display_position": "59",
                                            "ion_sort_name": "B00059",
                                            "ion_left_position": "59",
                                            "mass_error": "0.0823",
                                            "ppm": "12.80"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6429.3359",
                                            "ion_position": "91",
                                            "ion_display_position": "58",
                                            "ion_sort_name": "Y00058",
                                            "ion_left_position": "91",
                                            "mass_error": "-0.0013",
                                            "ppm": "-0.21"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "3",
                                "monoisotopic_mass": "6429.3510",
                                "monoisotopic_mz": "1072.5658",
                                "intensity": "12574.02",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "91",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "91",
                                        "mass_error": "0.0150",
                                        "ppm": "2.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "4",
                                "monoisotopic_mass": "7991.1209",
                                "monoisotopic_mz": "888.9096",
                                "intensity": "7030.45",
                                "charge": "9"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "5",
                                "monoisotopic_mass": "7472.8134",
                                "monoisotopic_mz": "1068.5521",
                                "intensity": "10017.92",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "81",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0289",
                                        "ppm": "-3.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "6",
                                "monoisotopic_mass": "6160.1823",
                                "monoisotopic_mz": "1027.7043",
                                "intensity": "5009.49",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6160.1984",
                                        "ion_position": "94",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "Y00055",
                                        "ion_left_position": "94",
                                        "mass_error": "-0.0161",
                                        "ppm": "-2.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "7",
                                "monoisotopic_mass": "2180.1055",
                                "monoisotopic_mz": "1091.0600",
                                "intensity": "3428.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "8",
                                "monoisotopic_mass": "1136.6197",
                                "monoisotopic_mz": "1137.6270",
                                "intensity": "5746.39",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "139",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "139",
                                        "mass_error": "0.0007",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "9",
                                "monoisotopic_mass": "6411.3118",
                                "monoisotopic_mz": "1069.5592",
                                "intensity": "6059.17",
                                "charge": "6"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "10",
                                "monoisotopic_mass": "8009.1455",
                                "monoisotopic_mz": "890.9123",
                                "intensity": "3538.40",
                                "charge": "9",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8009.1273",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "ion_sort_name": "B00074",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0182",
                                        "ppm": "2.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "11",
                                "monoisotopic_mass": "7285.7264",
                                "monoisotopic_mz": "1041.8253",
                                "intensity": "4354.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "12",
                                "monoisotopic_mass": "2657.3499",
                                "monoisotopic_mz": "886.7906",
                                "intensity": "2110.27",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "13",
                                "monoisotopic_mass": "1063.5481",
                                "monoisotopic_mz": "1064.5554",
                                "intensity": "1881.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "14",
                                "monoisotopic_mass": "3130.6237",
                                "monoisotopic_mz": "1044.5485",
                                "intensity": "3851.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "15",
                                "monoisotopic_mass": "6267.9928",
                                "monoisotopic_mz": "896.4348",
                                "intensity": "1506.85",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "16",
                                "monoisotopic_mass": "2005.3097",
                                "monoisotopic_mz": "1003.6621",
                                "intensity": "1959.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "17",
                                "monoisotopic_mass": "5233.7127",
                                "monoisotopic_mz": "1047.7498",
                                "intensity": "1133.76",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "18",
                                "monoisotopic_mass": "1719.8630",
                                "monoisotopic_mz": "860.9388",
                                "intensity": "2172.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "19",
                                "monoisotopic_mass": "4273.2188",
                                "monoisotopic_mz": "1069.3120",
                                "intensity": "946.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "20",
                                "monoisotopic_mass": "1959.0198",
                                "monoisotopic_mz": "980.5172",
                                "intensity": "2023.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "21",
                                "monoisotopic_mass": "3761.9077",
                                "monoisotopic_mz": "941.4842",
                                "intensity": "1000.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "22",
                                "monoisotopic_mass": "4191.1177",
                                "monoisotopic_mz": "839.2308",
                                "intensity": "2862.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "23",
                                "monoisotopic_mass": "6584.9789",
                                "monoisotopic_mz": "941.7185",
                                "intensity": "3326.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "24",
                                "monoisotopic_mass": "4571.2917",
                                "monoisotopic_mz": "915.2656",
                                "intensity": "1865.54",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "25",
                                "monoisotopic_mass": "967.8404",
                                "monoisotopic_mz": "968.8477",
                                "intensity": "1179.21",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "26",
                                "monoisotopic_mass": "6089.1144",
                                "monoisotopic_mz": "1015.8597",
                                "intensity": "3358.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6089.1613",
                                        "ion_position": "95",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "Y00054",
                                        "ion_left_position": "95",
                                        "mass_error": "-0.0469",
                                        "ppm": "-7.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "27",
                                "monoisotopic_mass": "13611.5394",
                                "monoisotopic_mz": "908.4432",
                                "intensity": "987.25",
                                "charge": "15",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-173.6085470509",
                                        "theoretical_mass": "13612.4412",
                                        "ion_position": "129",
                                        "ion_display_position": "129",
                                        "ion_sort_name": "B00129",
                                        "ion_left_position": "129",
                                        "mass_error": "0.1005",
                                        "ppm": "7.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "28",
                                "monoisotopic_mass": "11884.8605",
                                "monoisotopic_mz": "991.4123",
                                "intensity": "975.45",
                                "charge": "12"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "29",
                                "monoisotopic_mass": "8343.3808",
                                "monoisotopic_mz": "928.0496",
                                "intensity": "1249.65",
                                "charge": "9"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "30",
                                "monoisotopic_mass": "13025.5496",
                                "monoisotopic_mz": "1002.9726",
                                "intensity": "1350.19",
                                "charge": "13"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "31",
                                "monoisotopic_mass": "6520.3143",
                                "monoisotopic_mz": "1087.7263",
                                "intensity": "1093.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "32",
                                "monoisotopic_mass": "918.2201",
                                "monoisotopic_mz": "919.2274",
                                "intensity": "1075.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "33",
                                "monoisotopic_mass": "755.4175",
                                "monoisotopic_mz": "756.4248",
                                "intensity": "3083.80",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "143",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "143",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "34",
                                "monoisotopic_mass": "5385.7080",
                                "monoisotopic_mz": "1078.1489",
                                "intensity": "3457.48",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5386.7045",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "ion_sort_name": "B00048",
                                        "ion_left_position": "48",
                                        "mass_error": "0.0059",
                                        "ppm": "1.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "35",
                                "monoisotopic_mass": "7620.6056",
                                "monoisotopic_mz": "953.5830",
                                "intensity": "1466.04",
                                "charge": "8"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "36",
                                "monoisotopic_mass": "4973.6337",
                                "monoisotopic_mz": "995.7340",
                                "intensity": "2364.15",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "37",
                                "monoisotopic_mass": "6868.4528",
                                "monoisotopic_mz": "982.2148",
                                "intensity": "1135.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "38",
                                "monoisotopic_mass": "936.9815",
                                "monoisotopic_mz": "937.9888",
                                "intensity": "1389.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "39",
                                "monoisotopic_mass": "7590.3103",
                                "monoisotopic_mz": "1085.3373",
                                "intensity": "1413.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "40",
                                "monoisotopic_mass": "8701.7346",
                                "monoisotopic_mz": "871.1807",
                                "intensity": "1017.58",
                                "charge": "10"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "41",
                                "monoisotopic_mass": "1022.5115",
                                "monoisotopic_mz": "1023.5188",
                                "intensity": "1174.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "42",
                                "monoisotopic_mass": "980.6370",
                                "monoisotopic_mz": "981.6443",
                                "intensity": "1068.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "43",
                                "monoisotopic_mass": "12526.5019",
                                "monoisotopic_mz": "1044.8824",
                                "intensity": "1182.94",
                                "charge": "12"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "44",
                                "monoisotopic_mass": "7306.5589",
                                "monoisotopic_mz": "1044.8014",
                                "intensity": "2334.76",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "45",
                                "monoisotopic_mass": "3262.1667",
                                "monoisotopic_mz": "1088.3962",
                                "intensity": "1097.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "46",
                                "monoisotopic_mass": "6505.2979",
                                "monoisotopic_mz": "930.3355",
                                "intensity": "2164.39",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "47",
                                "monoisotopic_mass": "11507.9375",
                                "monoisotopic_mz": "886.2332",
                                "intensity": "1211.88",
                                "charge": "13"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "48",
                                "monoisotopic_mass": "824.2108",
                                "monoisotopic_mz": "825.2181",
                                "intensity": "1374.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "49",
                                "monoisotopic_mass": "2096.0667",
                                "monoisotopic_mz": "1049.0406",
                                "intensity": "855.12",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "50",
                                "monoisotopic_mass": "3031.7125",
                                "monoisotopic_mz": "1011.5781",
                                "intensity": "3299.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "51",
                                "monoisotopic_mass": "1767.8872",
                                "monoisotopic_mz": "884.9509",
                                "intensity": "4108.38",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "52",
                                "monoisotopic_mass": "15819.6453",
                                "monoisotopic_mz": "931.5746",
                                "intensity": "1397.30",
                                "charge": "17"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "53",
                                "monoisotopic_mass": "9614.6076",
                                "monoisotopic_mz": "962.4680",
                                "intensity": "1431.05",
                                "charge": "10"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "54",
                                "monoisotopic_mass": "3303.6518",
                                "monoisotopic_mz": "1102.2246",
                                "intensity": "2926.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "55",
                                "monoisotopic_mass": "1136.6185",
                                "monoisotopic_mz": "569.3165",
                                "intensity": "1926.08",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "139",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "139",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "56",
                                "monoisotopic_mass": "1842.9498",
                                "monoisotopic_mz": "922.4822",
                                "intensity": "1478.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "57",
                                "monoisotopic_mass": "1155.1243",
                                "monoisotopic_mz": "1156.1316",
                                "intensity": "1980.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "58",
                                "monoisotopic_mass": "3603.8482",
                                "monoisotopic_mz": "901.9693",
                                "intensity": "1166.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "59",
                                "monoisotopic_mass": "5491.5160",
                                "monoisotopic_mz": "916.2599",
                                "intensity": "1800.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "60",
                                "monoisotopic_mass": "1036.5325",
                                "monoisotopic_mz": "1037.5398",
                                "intensity": "1421.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "61",
                                "monoisotopic_mass": "11484.1108",
                                "monoisotopic_mz": "884.4004",
                                "intensity": "1315.83",
                                "charge": "13"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "62",
                                "monoisotopic_mass": "6230.4490",
                                "monoisotopic_mz": "891.0714",
                                "intensity": "2411.65",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "63",
                                "monoisotopic_mass": "4200.8721",
                                "monoisotopic_mz": "1051.2253",
                                "intensity": "2183.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "64",
                                "monoisotopic_mass": "15045.8355",
                                "monoisotopic_mz": "1004.0630",
                                "intensity": "1129.20",
                                "charge": "15"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "65",
                                "monoisotopic_mass": "1104.5574",
                                "monoisotopic_mz": "1105.5647",
                                "intensity": "845.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "66",
                                "monoisotopic_mass": "4637.9797",
                                "monoisotopic_mz": "928.6032",
                                "intensity": "4227.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "67",
                                "monoisotopic_mass": "4358.6097",
                                "monoisotopic_mz": "1090.6597",
                                "intensity": "2668.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "68",
                                "monoisotopic_mass": "3517.5335",
                                "monoisotopic_mz": "880.3907",
                                "intensity": "1272.76",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "69",
                                "monoisotopic_mass": "5870.9138",
                                "monoisotopic_mz": "839.7092",
                                "intensity": "3047.48",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5870.9326",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "B00053",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0189",
                                        "ppm": "-3.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "70",
                                "monoisotopic_mass": "7660.7491",
                                "monoisotopic_mz": "958.6009",
                                "intensity": "1388.01",
                                "charge": "8"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "71",
                                "monoisotopic_mass": "1899.9950",
                                "monoisotopic_mz": "951.0048",
                                "intensity": "2025.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "72",
                                "monoisotopic_mass": "4687.1731",
                                "monoisotopic_mz": "938.4419",
                                "intensity": "2592.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "73",
                                "monoisotopic_mass": "6450.7538",
                                "monoisotopic_mz": "922.5435",
                                "intensity": "1327.04",
                                "charge": "7"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "74",
                                "monoisotopic_mass": "4104.0489",
                                "monoisotopic_mz": "1027.0195",
                                "intensity": "1520.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "75",
                                "monoisotopic_mass": "1185.7972",
                                "monoisotopic_mz": "1186.8044",
                                "intensity": "1209.94",
                                "charge": "1"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "76",
                                "monoisotopic_mass": "2885.1137",
                                "monoisotopic_mz": "962.7118",
                                "intensity": "1365.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "125",
                                "peak_id": "77",
                                "monoisotopic_mass": "1994.0446",
                                "monoisotopic_mz": "998.0296",
                                "intensity": "1443.36",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15921.6865",
                    "n_acetylation": "1",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "0",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "48",
                                        "ion_display_position": "48",
                                        "spec_id": "125",
                                        "peak_id": "34",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "spec_id": "125",
                                        "peak_id": "69",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "59",
                                        "ion_display_position": "59",
                                        "spec_id": "125",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "spec_id": "125",
                                        "peak_id": "10",
                                        "peak_charge": "9"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "69",
                                        "spec_id": "125",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "81",
                                        "ion_display_position": "68",
                                        "spec_id": "125",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "91",
                                            "ion_display_position": "58",
                                            "spec_id": "125",
                                            "peak_id": "2",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "91",
                                            "ion_display_position": "58",
                                            "spec_id": "125",
                                            "peak_id": "3",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "94",
                                        "ion_display_position": "55",
                                        "spec_id": "125",
                                        "peak_id": "6",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "95",
                                        "ion_display_position": "54",
                                        "spec_id": "125",
                                        "peak_id": "26",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "129",
                                        "ion_display_position": "129",
                                        "spec_id": "125",
                                        "peak_id": "27",
                                        "peak_charge": "15"
                                    }
                                }
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "139",
                                            "ion_display_position": "10",
                                            "spec_id": "125",
                                            "peak_id": "55",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "139",
                                            "ion_display_position": "10",
                                            "spec_id": "125",
                                            "peak_id": "8",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "143",
                                        "ion_display_position": "6",
                                        "spec_id": "125",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Protein variable",
                            "ptm": {
                                "abbreviation": "Acetyl",
                                "unimod": "1",
                                "mono_mass": "42.0105650000"
                            },
                            "occurence": {
                                "left_pos": "0",
                                "right_pos": "1",
                                "anno": "M"
                            }
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "74",
                            "right_position": "80",
                            "anno": "-173.6085",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "76",
                "p_value": "1.56e-04",
                "e_value": "1.56e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "88",
                        "ms1_scans": "192",
                        "ids": "104",
                        "scans": "194",
                        "precursor_mono_mass": "15921.2032",
                        "precursor_charge": "17",
                        "precursor_mz": "937.5486",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "104",
                                "peak_id": "0",
                                "monoisotopic_mass": "7544.8651",
                                "monoisotopic_mz": "1078.8451",
                                "intensity": "16129.23",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0167",
                                        "ppm": "-2.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "1",
                                "monoisotopic_mass": "7474.8429",
                                "monoisotopic_mz": "1068.8420",
                                "intensity": "9580.59",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0041",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "2",
                                "monoisotopic_mass": "4360.2145",
                                "monoisotopic_mz": "873.0502",
                                "intensity": "7723.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "3",
                                "monoisotopic_mass": "7478.8696",
                                "monoisotopic_mz": "935.8660",
                                "intensity": "15409.17",
                                "charge": "8"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "4",
                                "monoisotopic_mass": "6429.3382",
                                "monoisotopic_mz": "1286.8749",
                                "intensity": "8284.05",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "90",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "90",
                                        "mass_error": "0.0023",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "5",
                                "monoisotopic_mass": "6428.2938",
                                "monoisotopic_mz": "919.3350",
                                "intensity": "6244.65",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6427.2473",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "B00060",
                                            "ion_left_position": "60",
                                            "mass_error": "0.0442",
                                            "ppm": "6.87"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6429.3359",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "ion_sort_name": "Y00058",
                                            "ion_left_position": "90",
                                            "mass_error": "-0.0398",
                                            "ppm": "-6.18"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "6",
                                "monoisotopic_mass": "5455.7912",
                                "monoisotopic_mz": "1092.1655",
                                "intensity": "2181.17",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5454.7961",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "B00049",
                                        "ion_left_position": "49",
                                        "mass_error": "-0.0072",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "7",
                                "monoisotopic_mass": "7527.8599",
                                "monoisotopic_mz": "1076.4158",
                                "intensity": "4990.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "8",
                                "monoisotopic_mass": "14969.7597",
                                "monoisotopic_mz": "936.6173",
                                "intensity": "2657.64",
                                "charge": "16"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "9",
                                "monoisotopic_mass": "1246.6427",
                                "monoisotopic_mz": "1247.6500",
                                "intensity": "2447.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "10",
                                "monoisotopic_mass": "2129.6000",
                                "monoisotopic_mz": "1065.8073",
                                "intensity": "1902.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "11",
                                "monoisotopic_mass": "3131.6257",
                                "monoisotopic_mz": "1044.8825",
                                "intensity": "2925.75",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "12",
                                "monoisotopic_mass": "1136.6169",
                                "monoisotopic_mz": "1137.6241",
                                "intensity": "4546.12",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "13",
                                "monoisotopic_mass": "13631.4190",
                                "monoisotopic_mz": "974.6801",
                                "intensity": "1272.25",
                                "charge": "14"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "14",
                                "monoisotopic_mass": "2024.0522",
                                "monoisotopic_mz": "1013.0334",
                                "intensity": "3332.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "15",
                                "monoisotopic_mass": "4190.1107",
                                "monoisotopic_mz": "839.0294",
                                "intensity": "2569.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "16",
                                "monoisotopic_mass": "920.4774",
                                "monoisotopic_mz": "921.4847",
                                "intensity": "1478.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "920.4756",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "0.0018",
                                        "ppm": "1.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "17",
                                "monoisotopic_mass": "5853.5239",
                                "monoisotopic_mz": "976.5946",
                                "intensity": "1549.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "18",
                                "monoisotopic_mass": "5524.8562",
                                "monoisotopic_mz": "921.8166",
                                "intensity": "882.61",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5525.8332",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "ion_sort_name": "B00050",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0254",
                                        "ppm": "4.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "19",
                                "monoisotopic_mass": "1055.5243",
                                "monoisotopic_mz": "1056.5316",
                                "intensity": "1176.51",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "20",
                                "monoisotopic_mass": "2809.5774",
                                "monoisotopic_mz": "937.5331",
                                "intensity": "2033.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "21",
                                "monoisotopic_mass": "3752.9942",
                                "monoisotopic_mz": "939.2558",
                                "intensity": "965.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "22",
                                "monoisotopic_mass": "7649.7292",
                                "monoisotopic_mz": "1093.8257",
                                "intensity": "1331.27",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "23",
                                "monoisotopic_mass": "1072.5554",
                                "monoisotopic_mz": "1073.5626",
                                "intensity": "1371.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "24",
                                "monoisotopic_mass": "1088.5643",
                                "monoisotopic_mz": "1089.5715",
                                "intensity": "1112.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "25",
                                "monoisotopic_mass": "6368.2204",
                                "monoisotopic_mz": "1062.3774",
                                "intensity": "1283.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "26",
                                "monoisotopic_mass": "989.9325",
                                "monoisotopic_mz": "990.9398",
                                "intensity": "1296.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "27",
                                "monoisotopic_mass": "9034.4619",
                                "monoisotopic_mz": "1004.8364",
                                "intensity": "2291.09",
                                "charge": "9"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "28",
                                "monoisotopic_mass": "7143.8205",
                                "monoisotopic_mz": "893.9848",
                                "intensity": "2502.24",
                                "charge": "8"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "29",
                                "monoisotopic_mass": "5004.9851",
                                "monoisotopic_mz": "1002.0043",
                                "intensity": "1051.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "30",
                                "monoisotopic_mass": "5993.6915",
                                "monoisotopic_mz": "999.9559",
                                "intensity": "2034.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "31",
                                "monoisotopic_mass": "1173.1253",
                                "monoisotopic_mz": "1174.1326",
                                "intensity": "1632.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "32",
                                "monoisotopic_mass": "1919.9916",
                                "monoisotopic_mz": "961.0031",
                                "intensity": "2104.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "33",
                                "monoisotopic_mass": "1119.9732",
                                "monoisotopic_mz": "1120.9805",
                                "intensity": "1630.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "34",
                                "monoisotopic_mass": "6495.3286",
                                "monoisotopic_mz": "928.9114",
                                "intensity": "1268.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "35",
                                "monoisotopic_mass": "1031.4116",
                                "monoisotopic_mz": "1032.4188",
                                "intensity": "1151.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "36",
                                "monoisotopic_mass": "1136.6174",
                                "monoisotopic_mz": "569.3160",
                                "intensity": "824.28",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0016",
                                        "ppm": "-1.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "37",
                                "monoisotopic_mass": "9025.1374",
                                "monoisotopic_mz": "903.5210",
                                "intensity": "2637.07",
                                "charge": "10"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "38",
                                "monoisotopic_mass": "876.2334",
                                "monoisotopic_mz": "877.2407",
                                "intensity": "1340.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "39",
                                "monoisotopic_mass": "6469.0974",
                                "monoisotopic_mz": "925.1640",
                                "intensity": "978.41",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "40",
                                "monoisotopic_mass": "4245.0786",
                                "monoisotopic_mz": "1062.2769",
                                "intensity": "2129.27",
                                "charge": "4"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "41",
                                "monoisotopic_mass": "900.6916",
                                "monoisotopic_mz": "901.6989",
                                "intensity": "2006.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "42",
                                "monoisotopic_mass": "1952.7550",
                                "monoisotopic_mz": "977.3848",
                                "intensity": "1695.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "43",
                                "monoisotopic_mass": "1154.6237",
                                "monoisotopic_mz": "1155.6310",
                                "intensity": "2632.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "44",
                                "monoisotopic_mass": "6616.1931",
                                "monoisotopic_mz": "946.1777",
                                "intensity": "1266.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "45",
                                "monoisotopic_mass": "3206.2565",
                                "monoisotopic_mz": "1069.7594",
                                "intensity": "1813.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "46",
                                "monoisotopic_mass": "12140.3116",
                                "monoisotopic_mz": "1012.6999",
                                "intensity": "893.33",
                                "charge": "12"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "47",
                                "monoisotopic_mass": "12357.1297",
                                "monoisotopic_mz": "1236.7202",
                                "intensity": "1271.23",
                                "charge": "10"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "48",
                                "monoisotopic_mass": "8262.2817",
                                "monoisotopic_mz": "919.0386",
                                "intensity": "2628.38",
                                "charge": "9"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "49",
                                "monoisotopic_mass": "5337.7536",
                                "monoisotopic_mz": "890.6329",
                                "intensity": "1164.44",
                                "charge": "6"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "50",
                                "monoisotopic_mass": "5048.5722",
                                "monoisotopic_mz": "1010.7217",
                                "intensity": "1808.62",
                                "charge": "5"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "51",
                                "monoisotopic_mass": "9605.4686",
                                "monoisotopic_mz": "1068.2816",
                                "intensity": "1297.58",
                                "charge": "9"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "52",
                                "monoisotopic_mass": "2919.7485",
                                "monoisotopic_mz": "974.2568",
                                "intensity": "1765.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "53",
                                "monoisotopic_mass": "1189.0086",
                                "monoisotopic_mz": "1190.0159",
                                "intensity": "727.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "54",
                                "monoisotopic_mass": "1259.3198",
                                "monoisotopic_mz": "1260.3270",
                                "intensity": "773.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "55",
                                "monoisotopic_mass": "9545.7304",
                                "monoisotopic_mz": "868.8009",
                                "intensity": "1401.47",
                                "charge": "11"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "56",
                                "monoisotopic_mass": "7104.6477",
                                "monoisotopic_mz": "889.0882",
                                "intensity": "2394.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "57",
                                "monoisotopic_mass": "6351.0285",
                                "monoisotopic_mz": "908.2971",
                                "intensity": "998.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "58",
                                "monoisotopic_mass": "3450.7815",
                                "monoisotopic_mz": "1151.2678",
                                "intensity": "2376.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "59",
                                "monoisotopic_mass": "1015.4976",
                                "monoisotopic_mz": "1016.5049",
                                "intensity": "909.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "60",
                                "monoisotopic_mass": "1273.6332",
                                "monoisotopic_mz": "1274.6405",
                                "intensity": "684.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "61",
                                "monoisotopic_mass": "1102.2907",
                                "monoisotopic_mz": "1103.2980",
                                "intensity": "953.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "62",
                                "monoisotopic_mass": "2879.5352",
                                "monoisotopic_mz": "960.8524",
                                "intensity": "1606.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "104",
                                "peak_id": "63",
                                "monoisotopic_mass": "861.4352",
                                "monoisotopic_mz": "862.4425",
                                "intensity": "971.55",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "104",
                                        "peak_id": "16",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "49",
                                        "ion_display_position": "49",
                                        "spec_id": "104",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "50",
                                        "ion_display_position": "50",
                                        "spec_id": "104",
                                        "peak_id": "18",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "spec_id": "104",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "spec_id": "104",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "spec_id": "104",
                                        "peak_id": "1",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "104",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "spec_id": "104",
                                            "peak_id": "4",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "138",
                                            "ion_display_position": "10",
                                            "spec_id": "104",
                                            "peak_id": "12",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "138",
                                            "ion_display_position": "10",
                                            "spec_id": "104",
                                            "peak_id": "36",
                                            "peak_charge": "2"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "45",
                "p_value": "5.68e-04",
                "e_value": "5.68e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "75",
                        "ms1_scans": "133",
                        "ids": "59",
                        "scans": "136",
                        "precursor_mono_mass": "15921.1970",
                        "precursor_charge": "17",
                        "precursor_mz": "937.5483",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "59",
                                "peak_id": "0",
                                "monoisotopic_mass": "7478.8823",
                                "monoisotopic_mz": "935.8676",
                                "intensity": "15783.98",
                                "charge": "8"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "1",
                                "monoisotopic_mass": "6429.3400",
                                "monoisotopic_mz": "1072.5639",
                                "intensity": "7153.33",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6429.3359",
                                        "ion_position": "91",
                                        "ion_display_position": "58",
                                        "ion_sort_name": "Y00058",
                                        "ion_left_position": "91",
                                        "mass_error": "0.0040",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "2",
                                "monoisotopic_mass": "7544.8825",
                                "monoisotopic_mz": "1258.4877",
                                "intensity": "6084.44",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "80",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0007",
                                        "ppm": "0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "3",
                                "monoisotopic_mass": "4360.2101",
                                "monoisotopic_mz": "873.0493",
                                "intensity": "9169.01",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-132.0275620509",
                                        "theoretical_mass": "4360.2322",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "B00040",
                                        "ion_left_position": "40",
                                        "mass_error": "-0.0221",
                                        "ppm": "-5.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "4",
                                "monoisotopic_mass": "1136.6188",
                                "monoisotopic_mz": "1137.6261",
                                "intensity": "4933.33",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "139",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "139",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "5",
                                "monoisotopic_mass": "7473.8491",
                                "monoisotopic_mz": "1068.7000",
                                "intensity": "4997.93",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "81",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0044",
                                        "ppm": "0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "6",
                                "monoisotopic_mass": "7285.7426",
                                "monoisotopic_mz": "1041.8277",
                                "intensity": "3779.26",
                                "charge": "7"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "7",
                                "monoisotopic_mass": "2136.1008",
                                "monoisotopic_mz": "1069.0577",
                                "intensity": "3448.57",
                                "charge": "2"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "8",
                                "monoisotopic_mass": "6544.5558",
                                "monoisotopic_mz": "935.9438",
                                "intensity": "4373.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "9",
                                "monoisotopic_mass": "1909.4658",
                                "monoisotopic_mz": "955.7402",
                                "intensity": "1494.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "10",
                                "monoisotopic_mass": "7473.8592",
                                "monoisotopic_mz": "1246.6505",
                                "intensity": "2452.49",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "81",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "81",
                                        "mass_error": "0.0145",
                                        "ppm": "1.94"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "11",
                                "monoisotopic_mass": "969.9005",
                                "monoisotopic_mz": "970.9078",
                                "intensity": "1325.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "12",
                                "monoisotopic_mass": "755.4176",
                                "monoisotopic_mz": "756.4249",
                                "intensity": "1755.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "755.4178",
                                        "ion_position": "143",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "143",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "13",
                                "monoisotopic_mass": "2032.0428",
                                "monoisotopic_mz": "1017.0287",
                                "intensity": "1854.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "14",
                                "monoisotopic_mass": "1746.1343",
                                "monoisotopic_mz": "874.0744",
                                "intensity": "1800.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "15",
                                "monoisotopic_mass": "8919.3474",
                                "monoisotopic_mz": "1115.9257",
                                "intensity": "1113.95",
                                "charge": "8"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "16",
                                "monoisotopic_mass": "8729.5839",
                                "monoisotopic_mz": "873.9657",
                                "intensity": "1213.68",
                                "charge": "10"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "17",
                                "monoisotopic_mass": "2180.1118",
                                "monoisotopic_mz": "1091.0632",
                                "intensity": "2031.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "18",
                                "monoisotopic_mass": "1047.5453",
                                "monoisotopic_mz": "1048.5526",
                                "intensity": "1251.95",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-132.0275620509",
                                        "theoretical_mass": "1047.5471",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "19",
                                "monoisotopic_mass": "4681.2820",
                                "monoisotopic_mz": "937.2637",
                                "intensity": "1670.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "20",
                                "monoisotopic_mass": "1012.7184",
                                "monoisotopic_mz": "1013.7256",
                                "intensity": "1079.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "21",
                                "monoisotopic_mass": "3716.9223",
                                "monoisotopic_mz": "930.2378",
                                "intensity": "4469.78",
                                "charge": "4"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "22",
                                "monoisotopic_mass": "848.9339",
                                "monoisotopic_mz": "849.9412",
                                "intensity": "1025.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "23",
                                "monoisotopic_mass": "937.2355",
                                "monoisotopic_mz": "938.2428",
                                "intensity": "1218.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "24",
                                "monoisotopic_mass": "8210.2530",
                                "monoisotopic_mz": "822.0326",
                                "intensity": "1764.58",
                                "charge": "10"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "25",
                                "monoisotopic_mass": "3763.4485",
                                "monoisotopic_mz": "941.8694",
                                "intensity": "1149.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "26",
                                "monoisotopic_mass": "919.4775",
                                "monoisotopic_mz": "920.4848",
                                "intensity": "1493.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-132.0275620509",
                                        "theoretical_mass": "919.4885",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0110",
                                        "ppm": "-11.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "27",
                                "monoisotopic_mass": "8603.2382",
                                "monoisotopic_mz": "956.9226",
                                "intensity": "884.22",
                                "charge": "9"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "28",
                                "monoisotopic_mass": "7619.6263",
                                "monoisotopic_mz": "1089.5253",
                                "intensity": "2203.14",
                                "charge": "7"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "29",
                                "monoisotopic_mass": "7279.8215",
                                "monoisotopic_mz": "910.9850",
                                "intensity": "2767.68",
                                "charge": "8"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "30",
                                "monoisotopic_mass": "14039.8365",
                                "monoisotopic_mz": "936.9964",
                                "intensity": "3306.53",
                                "charge": "15"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "31",
                                "monoisotopic_mass": "3801.9261",
                                "monoisotopic_mz": "951.4888",
                                "intensity": "1501.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "32",
                                "monoisotopic_mass": "994.2132",
                                "monoisotopic_mz": "995.2205",
                                "intensity": "1509.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "33",
                                "monoisotopic_mass": "882.6144",
                                "monoisotopic_mz": "883.6217",
                                "intensity": "1569.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "34",
                                "monoisotopic_mass": "11143.6213",
                                "monoisotopic_mz": "1014.0638",
                                "intensity": "2136.28",
                                "charge": "11"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "35",
                                "monoisotopic_mass": "5893.0062",
                                "monoisotopic_mz": "983.1750",
                                "intensity": "2500.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "36",
                                "monoisotopic_mass": "861.5485",
                                "monoisotopic_mz": "862.5557",
                                "intensity": "2105.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "37",
                                "monoisotopic_mass": "1026.0609",
                                "monoisotopic_mz": "1027.0681",
                                "intensity": "865.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "38",
                                "monoisotopic_mass": "4364.1835",
                                "monoisotopic_mz": "1092.0531",
                                "intensity": "1826.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "39",
                                "monoisotopic_mass": "899.5924",
                                "monoisotopic_mz": "900.5996",
                                "intensity": "1066.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "59",
                                "peak_id": "40",
                                "monoisotopic_mass": "6409.1907",
                                "monoisotopic_mz": "1069.2057",
                                "intensity": "1925.15",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15921.2570",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "0",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "59",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "59",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "40",
                                        "ion_display_position": "40",
                                        "spec_id": "59",
                                        "peak_id": "3",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "69",
                                        "spec_id": "59",
                                        "peak_id": "2",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "68",
                                            "spec_id": "59",
                                            "peak_id": "5",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "81",
                                            "ion_display_position": "68",
                                            "spec_id": "59",
                                            "peak_id": "10",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "91",
                                        "ion_display_position": "58",
                                        "spec_id": "59",
                                        "peak_id": "1",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "139",
                                        "ion_display_position": "10",
                                        "spec_id": "59",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "143",
                                        "ion_display_position": "6",
                                        "spec_id": "59",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "9",
                            "anno": "-132.0276",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "152",
                "p_value": "6.88e-04",
                "e_value": "6.88e-04",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "121",
                        "ms1_scans": "331",
                        "ids": "211",
                        "scans": "334",
                        "precursor_mono_mass": "15921.2302",
                        "precursor_charge": "16",
                        "precursor_mz": "996.0842",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "211",
                                "peak_id": "0",
                                "monoisotopic_mass": "7543.8765",
                                "monoisotopic_mz": "1258.3200",
                                "intensity": "7053.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "1",
                                "monoisotopic_mass": "7544.8762",
                                "monoisotopic_mz": "1078.8467",
                                "intensity": "5954.11",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "-0.0057",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "2",
                                "monoisotopic_mass": "7474.8344",
                                "monoisotopic_mz": "1068.8408",
                                "intensity": "4230.56",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0127",
                                        "ppm": "-1.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "3",
                                "monoisotopic_mass": "14487.2245",
                                "monoisotopic_mz": "966.8222",
                                "intensity": "1426.40",
                                "charge": "15"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "4",
                                "monoisotopic_mass": "973.7545",
                                "monoisotopic_mz": "974.7618",
                                "intensity": "1690.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "5",
                                "monoisotopic_mass": "3616.8080",
                                "monoisotopic_mz": "905.2093",
                                "intensity": "868.39",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "6",
                                "monoisotopic_mass": "8314.3412",
                                "monoisotopic_mz": "924.8230",
                                "intensity": "1138.28",
                                "charge": "9"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "7",
                                "monoisotopic_mass": "7800.0061",
                                "monoisotopic_mz": "1115.2939",
                                "intensity": "855.48",
                                "charge": "7"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "8",
                                "monoisotopic_mass": "5897.0561",
                                "monoisotopic_mz": "983.8500",
                                "intensity": "1026.88",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5897.0137",
                                        "ion_position": "54",
                                        "ion_display_position": "54",
                                        "ion_sort_name": "B00054",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0424",
                                        "ppm": "7.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "9",
                                "monoisotopic_mass": "12763.4863",
                                "monoisotopic_mz": "1064.6311",
                                "intensity": "818.31",
                                "charge": "12"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "10",
                                "monoisotopic_mass": "6125.2777",
                                "monoisotopic_mz": "1021.8869",
                                "intensity": "1892.94",
                                "charge": "6"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "11",
                                "monoisotopic_mass": "2982.5341",
                                "monoisotopic_mz": "995.1853",
                                "intensity": "2485.23",
                                "charge": "3"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "12",
                                "monoisotopic_mass": "1090.3876",
                                "monoisotopic_mz": "1091.3949",
                                "intensity": "1158.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "13",
                                "monoisotopic_mass": "4492.3674",
                                "monoisotopic_mz": "1124.0991",
                                "intensity": "1146.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "14",
                                "monoisotopic_mass": "3195.9510",
                                "monoisotopic_mz": "1066.3243",
                                "intensity": "1893.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "15",
                                "monoisotopic_mass": "3934.1212",
                                "monoisotopic_mz": "984.5376",
                                "intensity": "964.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "16",
                                "monoisotopic_mass": "4361.2079",
                                "monoisotopic_mz": "1091.3092",
                                "intensity": "3055.41",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0114",
                                        "ppm": "-2.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "17",
                                "monoisotopic_mass": "7195.3845",
                                "monoisotopic_mz": "900.4303",
                                "intensity": "867.74",
                                "charge": "8"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "18",
                                "monoisotopic_mass": "1810.9274",
                                "monoisotopic_mz": "906.4710",
                                "intensity": "1386.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "19",
                                "monoisotopic_mass": "11424.6985",
                                "monoisotopic_mz": "1039.6162",
                                "intensity": "852.57",
                                "charge": "11"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "20",
                                "monoisotopic_mass": "3215.6469",
                                "monoisotopic_mz": "1072.8896",
                                "intensity": "2504.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "21",
                                "monoisotopic_mass": "1041.3901",
                                "monoisotopic_mz": "1042.3973",
                                "intensity": "687.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "22",
                                "monoisotopic_mass": "2819.9276",
                                "monoisotopic_mz": "940.9831",
                                "intensity": "2281.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "23",
                                "monoisotopic_mass": "9101.4698",
                                "monoisotopic_mz": "1138.6910",
                                "intensity": "1368.55",
                                "charge": "8"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "24",
                                "monoisotopic_mass": "2137.1001",
                                "monoisotopic_mz": "1069.5573",
                                "intensity": "2520.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "25",
                                "monoisotopic_mass": "4362.2239",
                                "monoisotopic_mz": "873.4521",
                                "intensity": "2832.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "26",
                                "monoisotopic_mass": "902.0276",
                                "monoisotopic_mz": "903.0348",
                                "intensity": "1090.96",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "27",
                                "monoisotopic_mass": "5997.0544",
                                "monoisotopic_mz": "1000.5163",
                                "intensity": "927.81",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5998.0613",
                                        "ion_position": "55",
                                        "ion_display_position": "55",
                                        "ion_sort_name": "B00055",
                                        "ion_left_position": "55",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "28",
                                "monoisotopic_mass": "2033.0445",
                                "monoisotopic_mz": "1017.5295",
                                "intensity": "1197.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "29",
                                "monoisotopic_mass": "6796.1201",
                                "monoisotopic_mz": "1133.6940",
                                "intensity": "2228.50",
                                "charge": "6"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "30",
                                "monoisotopic_mass": "1203.9103",
                                "monoisotopic_mz": "1204.9176",
                                "intensity": "691.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "31",
                                "monoisotopic_mass": "1136.6175",
                                "monoisotopic_mz": "1137.6248",
                                "intensity": "1709.61",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "32",
                                "monoisotopic_mass": "1953.0015",
                                "monoisotopic_mz": "977.5080",
                                "intensity": "1618.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "33",
                                "monoisotopic_mass": "10663.4746",
                                "monoisotopic_mz": "1067.3547",
                                "intensity": "2033.07",
                                "charge": "10"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "34",
                                "monoisotopic_mass": "2002.0349",
                                "monoisotopic_mz": "1002.0247",
                                "intensity": "2198.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "35",
                                "monoisotopic_mass": "1878.6151",
                                "monoisotopic_mz": "940.3148",
                                "intensity": "906.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "36",
                                "monoisotopic_mass": "7550.5116",
                                "monoisotopic_mz": "944.8212",
                                "intensity": "2933.08",
                                "charge": "8"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "37",
                                "monoisotopic_mass": "1290.1452",
                                "monoisotopic_mz": "1291.1525",
                                "intensity": "600.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "38",
                                "monoisotopic_mass": "1190.1025",
                                "monoisotopic_mz": "1191.1097",
                                "intensity": "719.04",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "39",
                                "monoisotopic_mass": "3717.8495",
                                "monoisotopic_mz": "930.4696",
                                "intensity": "990.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "40",
                                "monoisotopic_mass": "8036.2249",
                                "monoisotopic_mz": "1005.5354",
                                "intensity": "1178.77",
                                "charge": "8"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "41",
                                "monoisotopic_mass": "3987.0316",
                                "monoisotopic_mz": "997.7652",
                                "intensity": "2940.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "42",
                                "monoisotopic_mass": "1027.2362",
                                "monoisotopic_mz": "1028.2435",
                                "intensity": "933.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "43",
                                "monoisotopic_mass": "1151.0773",
                                "monoisotopic_mz": "1152.0846",
                                "intensity": "746.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "44",
                                "monoisotopic_mass": "4967.1153",
                                "monoisotopic_mz": "1242.7861",
                                "intensity": "1695.04",
                                "charge": "4"
                            },
                            {
                                "spec_id": "211",
                                "peak_id": "45",
                                "monoisotopic_mass": "890.3429",
                                "monoisotopic_mz": "891.3502",
                                "intensity": "950.03",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "211",
                                        "peak_id": "16",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "54",
                                        "ion_display_position": "54",
                                        "spec_id": "211",
                                        "peak_id": "8",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "55",
                                        "ion_display_position": "55",
                                        "spec_id": "211",
                                        "peak_id": "27",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "79",
                                            "ion_display_position": "69",
                                            "spec_id": "211",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "79",
                                            "ion_display_position": "69",
                                            "spec_id": "211",
                                            "peak_id": "0",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "spec_id": "211",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "spec_id": "211",
                                        "peak_id": "31",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "32",
                "p_value": "9.08e-04",
                "e_value": "9.08e-04",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "7",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "69",
                        "ms1_scans": "110",
                        "ids": "40",
                        "scans": "111",
                        "precursor_mono_mass": "15922.2091",
                        "precursor_charge": "18",
                        "precursor_mz": "885.5744",
                        "feature_inte": "1.8031e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "40",
                                "peak_id": "0",
                                "monoisotopic_mass": "7544.8847",
                                "monoisotopic_mz": "1078.8479",
                                "intensity": "16001.64",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7544.8818",
                                        "ion_position": "79",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "Y00069",
                                        "ion_left_position": "79",
                                        "mass_error": "0.0029",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "1",
                                "monoisotopic_mass": "4361.2161",
                                "monoisotopic_mz": "873.2505",
                                "intensity": "12410.18",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4361.2193",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0032",
                                        "ppm": "-0.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "2",
                                "monoisotopic_mass": "6428.3179",
                                "monoisotopic_mz": "1072.3936",
                                "intensity": "8621.10",
                                "charge": "6",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6427.2473",
                                            "ion_position": "60",
                                            "ion_display_position": "60",
                                            "ion_sort_name": "B00060",
                                            "ion_left_position": "60",
                                            "mass_error": "0.0682",
                                            "ppm": "10.61"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "6429.3359",
                                            "ion_position": "90",
                                            "ion_display_position": "58",
                                            "ion_sort_name": "Y00058",
                                            "ion_left_position": "90",
                                            "mass_error": "-0.0157",
                                            "ppm": "-2.45"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "3",
                                "monoisotopic_mass": "2137.1146",
                                "monoisotopic_mz": "1069.5646",
                                "intensity": "3837.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "4",
                                "monoisotopic_mass": "1136.6188",
                                "monoisotopic_mz": "1137.6261",
                                "intensity": "3908.37",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1136.6190",
                                        "ion_position": "138",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "138",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "5",
                                "monoisotopic_mass": "3130.6226",
                                "monoisotopic_mz": "1044.5481",
                                "intensity": "5305.62",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "6",
                                "monoisotopic_mass": "4359.2198",
                                "monoisotopic_mz": "1090.8122",
                                "intensity": "7763.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "7",
                                "monoisotopic_mass": "2669.3767",
                                "monoisotopic_mz": "890.7995",
                                "intensity": "2703.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "8",
                                "monoisotopic_mass": "3442.7329",
                                "monoisotopic_mz": "861.6905",
                                "intensity": "2830.37",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "9",
                                "monoisotopic_mass": "2309.2443",
                                "monoisotopic_mz": "1155.6294",
                                "intensity": "3951.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2309.2454",
                                        "ion_position": "128",
                                        "ion_display_position": "20",
                                        "ion_sort_name": "Y00020",
                                        "ion_left_position": "128",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "10",
                                "monoisotopic_mass": "2719.8841",
                                "monoisotopic_mz": "907.6353",
                                "intensity": "1923.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "11",
                                "monoisotopic_mass": "8893.9549",
                                "monoisotopic_mz": "890.4028",
                                "intensity": "3381.19",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "12",
                                "monoisotopic_mass": "7472.8493",
                                "monoisotopic_mz": "1068.5572",
                                "intensity": "3716.89",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7473.8447",
                                        "ion_position": "80",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "Y00068",
                                        "ion_left_position": "80",
                                        "mass_error": "0.0070",
                                        "ppm": "0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "13",
                                "monoisotopic_mass": "8117.2102",
                                "monoisotopic_mz": "812.7283",
                                "intensity": "965.78",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "14",
                                "monoisotopic_mass": "2025.0516",
                                "monoisotopic_mz": "1013.5331",
                                "intensity": "2931.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "15",
                                "monoisotopic_mass": "883.4432",
                                "monoisotopic_mz": "884.4504",
                                "intensity": "1097.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "16",
                                "monoisotopic_mass": "962.4839",
                                "monoisotopic_mz": "963.4912",
                                "intensity": "1636.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "17",
                                "monoisotopic_mass": "12994.6144",
                                "monoisotopic_mz": "929.1940",
                                "intensity": "2293.98",
                                "charge": "14"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "18",
                                "monoisotopic_mass": "909.4645",
                                "monoisotopic_mz": "910.4718",
                                "intensity": "1419.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "19",
                                "monoisotopic_mass": "13945.6437",
                                "monoisotopic_mz": "930.7169",
                                "intensity": "1317.44",
                                "charge": "15"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "20",
                                "monoisotopic_mass": "5251.6527",
                                "monoisotopic_mz": "876.2827",
                                "intensity": "939.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "21",
                                "monoisotopic_mass": "7576.8578",
                                "monoisotopic_mz": "948.1145",
                                "intensity": "791.63",
                                "charge": "8"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "22",
                                "monoisotopic_mass": "8941.8936",
                                "monoisotopic_mz": "994.5510",
                                "intensity": "1354.78",
                                "charge": "9"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "23",
                                "monoisotopic_mass": "944.4795",
                                "monoisotopic_mz": "945.4868",
                                "intensity": "1614.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "24",
                                "monoisotopic_mass": "8164.2636",
                                "monoisotopic_mz": "908.1477",
                                "intensity": "1356.13",
                                "charge": "9"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "25",
                                "monoisotopic_mass": "15101.3979",
                                "monoisotopic_mz": "944.8446",
                                "intensity": "882.68",
                                "charge": "16"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "26",
                                "monoisotopic_mass": "8592.6030",
                                "monoisotopic_mz": "860.2676",
                                "intensity": "2554.38",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "27",
                                "monoisotopic_mass": "6333.1307",
                                "monoisotopic_mz": "905.7402",
                                "intensity": "1367.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "28",
                                "monoisotopic_mass": "979.8457",
                                "monoisotopic_mz": "980.8530",
                                "intensity": "1326.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "29",
                                "monoisotopic_mass": "3207.8773",
                                "monoisotopic_mz": "1070.2997",
                                "intensity": "2047.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "30",
                                "monoisotopic_mass": "7117.8337",
                                "monoisotopic_mz": "890.7365",
                                "intensity": "1002.50",
                                "charge": "8"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "31",
                                "monoisotopic_mass": "6695.2699",
                                "monoisotopic_mz": "957.4744",
                                "intensity": "979.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "32",
                                "monoisotopic_mass": "854.4847",
                                "monoisotopic_mz": "855.4920",
                                "intensity": "1169.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "854.4862",
                                        "ion_position": "141",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "141",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "33",
                                "monoisotopic_mass": "2592.3755",
                                "monoisotopic_mz": "865.1324",
                                "intensity": "2823.79",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "34",
                                "monoisotopic_mass": "4199.2114",
                                "monoisotopic_mz": "1050.8101",
                                "intensity": "2848.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "35",
                                "monoisotopic_mass": "8883.1363",
                                "monoisotopic_mz": "808.5651",
                                "intensity": "1362.16",
                                "charge": "11"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "36",
                                "monoisotopic_mass": "6847.4208",
                                "monoisotopic_mz": "856.9349",
                                "intensity": "912.44",
                                "charge": "8"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "37",
                                "monoisotopic_mass": "7645.9918",
                                "monoisotopic_mz": "956.7563",
                                "intensity": "933.79",
                                "charge": "8"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "38",
                                "monoisotopic_mass": "9403.1480",
                                "monoisotopic_mz": "855.8389",
                                "intensity": "1296.92",
                                "charge": "11"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "39",
                                "monoisotopic_mass": "3930.9429",
                                "monoisotopic_mz": "983.7430",
                                "intensity": "1187.01",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "40",
                                "monoisotopic_mass": "4190.0880",
                                "monoisotopic_mz": "839.0249",
                                "intensity": "2109.92",
                                "charge": "5"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "41",
                                "monoisotopic_mass": "9513.8004",
                                "monoisotopic_mz": "952.3873",
                                "intensity": "1233.70",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "42",
                                "monoisotopic_mass": "6625.3373",
                                "monoisotopic_mz": "947.4840",
                                "intensity": "805.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "43",
                                "monoisotopic_mass": "14116.6184",
                                "monoisotopic_mz": "942.1152",
                                "intensity": "1379.42",
                                "charge": "15"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "44",
                                "monoisotopic_mass": "6126.3428",
                                "monoisotopic_mz": "876.1991",
                                "intensity": "1089.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "45",
                                "monoisotopic_mass": "1718.8624",
                                "monoisotopic_mz": "860.4385",
                                "intensity": "1586.27",
                                "charge": "2"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "46",
                                "monoisotopic_mass": "4682.8641",
                                "monoisotopic_mz": "937.5801",
                                "intensity": "2741.52",
                                "charge": "5"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "47",
                                "monoisotopic_mass": "7426.7744",
                                "monoisotopic_mz": "929.3541",
                                "intensity": "1487.87",
                                "charge": "8"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "48",
                                "monoisotopic_mass": "1838.9716",
                                "monoisotopic_mz": "920.4931",
                                "intensity": "1622.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "49",
                                "monoisotopic_mass": "831.7559",
                                "monoisotopic_mz": "832.7632",
                                "intensity": "1186.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "50",
                                "monoisotopic_mass": "2604.8032",
                                "monoisotopic_mz": "869.2750",
                                "intensity": "1084.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "51",
                                "monoisotopic_mass": "7969.0737",
                                "monoisotopic_mz": "886.4599",
                                "intensity": "2819.61",
                                "charge": "9"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "52",
                                "monoisotopic_mass": "4346.4045",
                                "monoisotopic_mz": "870.2882",
                                "intensity": "786.13",
                                "charge": "5"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "53",
                                "monoisotopic_mass": "994.7127",
                                "monoisotopic_mz": "995.7200",
                                "intensity": "738.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "54",
                                "monoisotopic_mass": "3750.4137",
                                "monoisotopic_mz": "938.6107",
                                "intensity": "945.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "55",
                                "monoisotopic_mass": "8874.0083",
                                "monoisotopic_mz": "888.4081",
                                "intensity": "3493.67",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "56",
                                "monoisotopic_mass": "12255.4408",
                                "monoisotopic_mz": "1115.1383",
                                "intensity": "1285.49",
                                "charge": "11"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "57",
                                "monoisotopic_mass": "8766.3054",
                                "monoisotopic_mz": "877.6378",
                                "intensity": "3043.93",
                                "charge": "10"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "58",
                                "monoisotopic_mass": "1089.0643",
                                "monoisotopic_mz": "1090.0715",
                                "intensity": "1323.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "59",
                                "monoisotopic_mass": "1039.2477",
                                "monoisotopic_mz": "1040.2550",
                                "intensity": "1593.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "60",
                                "monoisotopic_mass": "6410.2346",
                                "monoisotopic_mz": "916.7551",
                                "intensity": "4199.48",
                                "charge": "7"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "61",
                                "monoisotopic_mass": "1011.8472",
                                "monoisotopic_mz": "1012.8544",
                                "intensity": "766.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "62",
                                "monoisotopic_mass": "12462.1892",
                                "monoisotopic_mz": "891.1636",
                                "intensity": "1287.93",
                                "charge": "14"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "63",
                                "monoisotopic_mass": "2863.5001",
                                "monoisotopic_mz": "955.5073",
                                "intensity": "4522.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "64",
                                "monoisotopic_mass": "4417.0657",
                                "monoisotopic_mz": "884.4204",
                                "intensity": "1584.87",
                                "charge": "5"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "65",
                                "monoisotopic_mass": "10835.5728",
                                "monoisotopic_mz": "903.9717",
                                "intensity": "2236.19",
                                "charge": "12"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "66",
                                "monoisotopic_mass": "5053.5982",
                                "monoisotopic_mz": "843.2736",
                                "intensity": "1003.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "67",
                                "monoisotopic_mass": "12072.2014",
                                "monoisotopic_mz": "929.6382",
                                "intensity": "889.28",
                                "charge": "13"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "68",
                                "monoisotopic_mass": "3544.6095",
                                "monoisotopic_mz": "887.1597",
                                "intensity": "1014.65",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "69",
                                "monoisotopic_mass": "4174.0933",
                                "monoisotopic_mz": "1044.5306",
                                "intensity": "755.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "70",
                                "monoisotopic_mass": "2831.8967",
                                "monoisotopic_mz": "944.9728",
                                "intensity": "2367.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "71",
                                "monoisotopic_mass": "5393.2741",
                                "monoisotopic_mz": "1079.6621",
                                "intensity": "885.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "72",
                                "monoisotopic_mass": "1243.6439",
                                "monoisotopic_mz": "1244.6512",
                                "intensity": "983.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "73",
                                "monoisotopic_mass": "868.1428",
                                "monoisotopic_mz": "869.1501",
                                "intensity": "1025.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "40",
                                "peak_id": "74",
                                "monoisotopic_mass": "8861.7177",
                                "monoisotopic_mz": "887.1790",
                                "intensity": "1119.92",
                                "charge": "10"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "8",
                    "proteoform_id": "11",
                    "sequence_name": "sp|P0ADE6|KBP_ECOLI",
                    "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
                    "proteoform_mass": "15922.2440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "149",
                        "first_residue_position": "1",
                        "last_residue_position": "148",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "G"
                            },
                            {
                                "position": "2",
                                "acid": "L"
                            },
                            {
                                "position": "3",
                                "acid": "F"
                            },
                            {
                                "position": "4",
                                "acid": "N"
                            },
                            {
                                "position": "5",
                                "acid": "F"
                            },
                            {
                                "position": "6",
                                "acid": "V"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "D"
                            },
                            {
                                "position": "9",
                                "acid": "A"
                            },
                            {
                                "position": "10",
                                "acid": "G"
                            },
                            {
                                "position": "11",
                                "acid": "E"
                            },
                            {
                                "position": "12",
                                "acid": "K"
                            },
                            {
                                "position": "13",
                                "acid": "L"
                            },
                            {
                                "position": "14",
                                "acid": "W"
                            },
                            {
                                "position": "15",
                                "acid": "D"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "T"
                            },
                            {
                                "position": "19",
                                "acid": "G"
                            },
                            {
                                "position": "20",
                                "acid": "Q"
                            },
                            {
                                "position": "21",
                                "acid": "H"
                            },
                            {
                                "position": "22",
                                "acid": "D"
                            },
                            {
                                "position": "23",
                                "acid": "K"
                            },
                            {
                                "position": "24",
                                "acid": "D"
                            },
                            {
                                "position": "25",
                                "acid": "D"
                            },
                            {
                                "position": "26",
                                "acid": "Q"
                            },
                            {
                                "position": "27",
                                "acid": "A"
                            },
                            {
                                "position": "28",
                                "acid": "K"
                            },
                            {
                                "position": "29",
                                "acid": "K"
                            },
                            {
                                "position": "30",
                                "acid": "V"
                            },
                            {
                                "position": "31",
                                "acid": "Q"
                            },
                            {
                                "position": "32",
                                "acid": "E"
                            },
                            {
                                "position": "33",
                                "acid": "H"
                            },
                            {
                                "position": "34",
                                "acid": "L"
                            },
                            {
                                "position": "35",
                                "acid": "N"
                            },
                            {
                                "position": "36",
                                "acid": "K"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "G"
                            },
                            {
                                "position": "39",
                                "acid": "I"
                            },
                            {
                                "position": "40",
                                "acid": "P"
                            },
                            {
                                "position": "41",
                                "acid": "D"
                            },
                            {
                                "position": "42",
                                "acid": "A"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "K"
                            },
                            {
                                "position": "45",
                                "acid": "V"
                            },
                            {
                                "position": "46",
                                "acid": "N"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "I"
                            },
                            {
                                "position": "50",
                                "acid": "A"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "K"
                            },
                            {
                                "position": "54",
                                "acid": "A"
                            },
                            {
                                "position": "55",
                                "acid": "T"
                            },
                            {
                                "position": "56",
                                "acid": "V"
                            },
                            {
                                "position": "57",
                                "acid": "T"
                            },
                            {
                                "position": "58",
                                "acid": "G"
                            },
                            {
                                "position": "59",
                                "acid": "D"
                            },
                            {
                                "position": "60",
                                "acid": "G"
                            },
                            {
                                "position": "61",
                                "acid": "L"
                            },
                            {
                                "position": "62",
                                "acid": "S"
                            },
                            {
                                "position": "63",
                                "acid": "Q"
                            },
                            {
                                "position": "64",
                                "acid": "E"
                            },
                            {
                                "position": "65",
                                "acid": "A"
                            },
                            {
                                "position": "66",
                                "acid": "K"
                            },
                            {
                                "position": "67",
                                "acid": "E"
                            },
                            {
                                "position": "68",
                                "acid": "K"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "L"
                            },
                            {
                                "position": "71",
                                "acid": "V"
                            },
                            {
                                "position": "72",
                                "acid": "A"
                            },
                            {
                                "position": "73",
                                "acid": "V"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "N"
                            },
                            {
                                "position": "76",
                                "acid": "I"
                            },
                            {
                                "position": "77",
                                "acid": "S"
                            },
                            {
                                "position": "78",
                                "acid": "G"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "A"
                            },
                            {
                                "position": "81",
                                "acid": "S"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "D"
                            },
                            {
                                "position": "84",
                                "acid": "D"
                            },
                            {
                                "position": "85",
                                "acid": "Q"
                            },
                            {
                                "position": "86",
                                "acid": "V"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "T"
                            },
                            {
                                "position": "89",
                                "acid": "A"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "P"
                            },
                            {
                                "position": "92",
                                "acid": "A"
                            },
                            {
                                "position": "93",
                                "acid": "T"
                            },
                            {
                                "position": "94",
                                "acid": "A"
                            },
                            {
                                "position": "95",
                                "acid": "S"
                            },
                            {
                                "position": "96",
                                "acid": "Q"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "Y"
                            },
                            {
                                "position": "99",
                                "acid": "T"
                            },
                            {
                                "position": "100",
                                "acid": "V"
                            },
                            {
                                "position": "101",
                                "acid": "K"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "G"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "T"
                            },
                            {
                                "position": "106",
                                "acid": "L"
                            },
                            {
                                "position": "107",
                                "acid": "S"
                            },
                            {
                                "position": "108",
                                "acid": "A"
                            },
                            {
                                "position": "109",
                                "acid": "I"
                            },
                            {
                                "position": "110",
                                "acid": "S"
                            },
                            {
                                "position": "111",
                                "acid": "K"
                            },
                            {
                                "position": "112",
                                "acid": "Q"
                            },
                            {
                                "position": "113",
                                "acid": "V"
                            },
                            {
                                "position": "114",
                                "acid": "Y"
                            },
                            {
                                "position": "115",
                                "acid": "G"
                            },
                            {
                                "position": "116",
                                "acid": "N"
                            },
                            {
                                "position": "117",
                                "acid": "A"
                            },
                            {
                                "position": "118",
                                "acid": "N"
                            },
                            {
                                "position": "119",
                                "acid": "L"
                            },
                            {
                                "position": "120",
                                "acid": "Y"
                            },
                            {
                                "position": "121",
                                "acid": "N"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "I"
                            },
                            {
                                "position": "124",
                                "acid": "F"
                            },
                            {
                                "position": "125",
                                "acid": "E"
                            },
                            {
                                "position": "126",
                                "acid": "A"
                            },
                            {
                                "position": "127",
                                "acid": "N"
                            },
                            {
                                "position": "128",
                                "acid": "K"
                            },
                            {
                                "position": "129",
                                "acid": "P"
                            },
                            {
                                "position": "130",
                                "acid": "M"
                            },
                            {
                                "position": "131",
                                "acid": "L"
                            },
                            {
                                "position": "132",
                                "acid": "K"
                            },
                            {
                                "position": "133",
                                "acid": "S"
                            },
                            {
                                "position": "134",
                                "acid": "P"
                            },
                            {
                                "position": "135",
                                "acid": "D"
                            },
                            {
                                "position": "136",
                                "acid": "K"
                            },
                            {
                                "position": "137",
                                "acid": "I"
                            },
                            {
                                "position": "138",
                                "acid": "Y"
                            },
                            {
                                "position": "139",
                                "acid": "P"
                            },
                            {
                                "position": "140",
                                "acid": "G"
                            },
                            {
                                "position": "141",
                                "acid": "Q"
                            },
                            {
                                "position": "142",
                                "acid": "V"
                            },
                            {
                                "position": "143",
                                "acid": "L"
                            },
                            {
                                "position": "144",
                                "acid": "R"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "P"
                            },
                            {
                                "position": "147",
                                "acid": "E"
                            },
                            {
                                "position": "148",
                                "acid": "E"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                  