prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "1",
        "sequence_name": "sp|P0A6A8|ACP_ECOLI",
        "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
        "proteoform_id": "1",
        "prsm_number": "17",
        "prsm": [
            {
                "prsm_id": "168",
                "p_value": "4.93e-15",
                "e_value": "4.93e-15",
                "fdr": "0",
                "matched_fragment_number": "16",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "128",
                        "ms1_scans": "362",
                        "ids": "235",
                        "scans": "365",
                        "precursor_mono_mass": "8899.2790",
                        "precursor_charge": "8",
                        "precursor_mz": "1113.4172",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "235",
                                "peak_id": "0",
                                "monoisotopic_mass": "2512.2074",
                                "monoisotopic_mz": "1257.1110",
                                "intensity": "9139.03",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "1",
                                "monoisotopic_mass": "3583.8746",
                                "monoisotopic_mz": "1195.6322",
                                "intensity": "8477.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3583.8734",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0013",
                                        "ppm": "0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "2",
                                "monoisotopic_mass": "3470.7902",
                                "monoisotopic_mz": "1157.9373",
                                "intensity": "6878.88",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0009",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "3",
                                "monoisotopic_mass": "3127.6508",
                                "monoisotopic_mz": "1043.5575",
                                "intensity": "4677.33",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "4",
                                "monoisotopic_mass": "916.4040",
                                "monoisotopic_mz": "917.4113",
                                "intensity": "6897.77",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0001",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "5",
                                "monoisotopic_mass": "3226.7215",
                                "monoisotopic_mz": "1076.5811",
                                "intensity": "3897.75",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3226.7198",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0017",
                                        "ppm": "0.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "6",
                                "monoisotopic_mass": "2962.5669",
                                "monoisotopic_mz": "988.5296",
                                "intensity": "4101.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "7",
                                "monoisotopic_mass": "1029.4883",
                                "monoisotopic_mz": "1030.4956",
                                "intensity": "3879.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0003",
                                        "ppm": "0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "8",
                                "monoisotopic_mass": "2625.2904",
                                "monoisotopic_mz": "1313.6525",
                                "intensity": "2681.76",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2625.2923",
                                        "ion_position": "53",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0018",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "9",
                                "monoisotopic_mass": "3355.7582",
                                "monoisotopic_mz": "1119.5933",
                                "intensity": "3030.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3355.7623",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0041",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "10",
                                "monoisotopic_mass": "801.3774",
                                "monoisotopic_mz": "802.3846",
                                "intensity": "2762.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "0.0004",
                                        "ppm": "0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "11",
                                "monoisotopic_mass": "3640.8963",
                                "monoisotopic_mz": "1214.6394",
                                "intensity": "3099.58",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3640.8948",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "0.0014",
                                        "ppm": "0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "12",
                                "monoisotopic_mass": "1100.5239",
                                "monoisotopic_mz": "1101.5311",
                                "intensity": "3103.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "13",
                                "monoisotopic_mass": "2893.5485",
                                "monoisotopic_mz": "965.5234",
                                "intensity": "3200.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "14",
                                "monoisotopic_mass": "1275.9874",
                                "monoisotopic_mz": "1276.9946",
                                "intensity": "2086.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "15",
                                "monoisotopic_mass": "4964.4570",
                                "monoisotopic_mz": "1242.1215",
                                "intensity": "3041.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "16",
                                "monoisotopic_mass": "3108.6382",
                                "monoisotopic_mz": "1037.2200",
                                "intensity": "1963.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "17",
                                "monoisotopic_mass": "2225.8202",
                                "monoisotopic_mz": "1113.9174",
                                "intensity": "2994.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "18",
                                "monoisotopic_mass": "638.3135",
                                "monoisotopic_mz": "639.3208",
                                "intensity": "1298.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "638.3137",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "19",
                                "monoisotopic_mass": "525.2291",
                                "monoisotopic_mz": "526.2364",
                                "intensity": "2756.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "20",
                                "monoisotopic_mass": "4965.4558",
                                "monoisotopic_mz": "1656.1592",
                                "intensity": "2693.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "21",
                                "monoisotopic_mass": "2332.6591",
                                "monoisotopic_mz": "1167.3368",
                                "intensity": "2321.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "22",
                                "monoisotopic_mass": "8209.7162",
                                "monoisotopic_mz": "1173.8239",
                                "intensity": "1295.46",
                                "charge": "7"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "23",
                                "monoisotopic_mass": "4452.2302",
                                "monoisotopic_mz": "1114.0648",
                                "intensity": "2723.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "24",
                                "monoisotopic_mass": "4762.3868",
                                "monoisotopic_mz": "1191.6040",
                                "intensity": "2669.69",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "25",
                                "monoisotopic_mass": "2204.9293",
                                "monoisotopic_mz": "1103.4719",
                                "intensity": "953.98",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "26",
                                "monoisotopic_mass": "4698.2115",
                                "monoisotopic_mz": "1175.5602",
                                "intensity": "1802.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "27",
                                "monoisotopic_mass": "1237.3116",
                                "monoisotopic_mz": "1238.3188",
                                "intensity": "2693.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "28",
                                "monoisotopic_mass": "940.0367",
                                "monoisotopic_mz": "941.0440",
                                "intensity": "1278.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "29",
                                "monoisotopic_mass": "953.1231",
                                "monoisotopic_mz": "954.1304",
                                "intensity": "1767.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "30",
                                "monoisotopic_mass": "1071.6442",
                                "monoisotopic_mz": "1072.6515",
                                "intensity": "1883.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "31",
                                "monoisotopic_mass": "2299.6974",
                                "monoisotopic_mz": "1150.8560",
                                "intensity": "1634.76",
                                "charge": "2"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "32",
                                "monoisotopic_mass": "1398.6894",
                                "monoisotopic_mz": "1399.6967",
                                "intensity": "1280.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1398.6892",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "64",
                                        "mass_error": "0.0002",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "33",
                                "monoisotopic_mass": "6676.8006",
                                "monoisotopic_mz": "1113.8074",
                                "intensity": "4004.36",
                                "charge": "6"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "34",
                                "monoisotopic_mass": "1012.4674",
                                "monoisotopic_mz": "1013.4747",
                                "intensity": "733.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "35",
                                "monoisotopic_mass": "1436.0699",
                                "monoisotopic_mz": "1437.0771",
                                "intensity": "615.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "235",
                                "peak_id": "36",
                                "monoisotopic_mass": "1141.8338",
                                "monoisotopic_mz": "1142.8411",
                                "intensity": "799.38",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5441",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "235",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "235",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "235",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "235",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "235",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "235",
                                        "peak_id": "1",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "235",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "53",
                                        "ion_display_position": "24",
                                        "spec_id": "235",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "235",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "64",
                                        "ion_display_position": "13",
                                        "spec_id": "235",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "235",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "235",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "235",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "235",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "spec_id": "235",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "spec_id": "235",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "34",
                            "right_position": "54",
                            "anno": "396.3637",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "38",
                "p_value": "1.86e-11",
                "e_value": "1.86e-11",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "70",
                        "ms1_scans": "116",
                        "ids": "47",
                        "scans": "119",
                        "precursor_mono_mass": "8899.2566",
                        "precursor_charge": "8",
                        "precursor_mz": "1113.4144",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "47",
                                "peak_id": "0",
                                "monoisotopic_mass": "2512.2096",
                                "monoisotopic_mz": "1257.1121",
                                "intensity": "8556.00",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0014",
                                        "ppm": "0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "1",
                                "monoisotopic_mass": "3340.4184",
                                "monoisotopic_mz": "1114.4801",
                                "intensity": "25236.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "2",
                                "monoisotopic_mass": "3583.8713",
                                "monoisotopic_mz": "1195.6311",
                                "intensity": "7669.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3583.8734",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "3",
                                "monoisotopic_mass": "3470.7935",
                                "monoisotopic_mz": "1157.9384",
                                "intensity": "7615.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0042",
                                        "ppm": "1.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "4",
                                "monoisotopic_mass": "916.4035",
                                "monoisotopic_mz": "917.4108",
                                "intensity": "6117.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "5",
                                "monoisotopic_mass": "1029.4888",
                                "monoisotopic_mz": "1030.4961",
                                "intensity": "3706.27",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0008",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "6",
                                "monoisotopic_mass": "801.3768",
                                "monoisotopic_mz": "802.3840",
                                "intensity": "2812.69",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "7",
                                "monoisotopic_mass": "3640.8926",
                                "monoisotopic_mz": "1214.6381",
                                "intensity": "4365.24",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3640.8948",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0022",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "8",
                                "monoisotopic_mass": "1074.8920",
                                "monoisotopic_mz": "1075.8993",
                                "intensity": "5989.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "9",
                                "monoisotopic_mass": "2894.5517",
                                "monoisotopic_mz": "965.8579",
                                "intensity": "3058.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "10",
                                "monoisotopic_mass": "1113.0308",
                                "monoisotopic_mz": "1114.0381",
                                "intensity": "11913.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "11",
                                "monoisotopic_mass": "6686.5271",
                                "monoisotopic_mz": "1115.4285",
                                "intensity": "1083.72",
                                "charge": "6"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "12",
                                "monoisotopic_mass": "638.3134",
                                "monoisotopic_mz": "639.3207",
                                "intensity": "2443.44",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "638.3137",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "13",
                                "monoisotopic_mass": "2961.5642",
                                "monoisotopic_mz": "988.1954",
                                "intensity": "1786.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "14",
                                "monoisotopic_mass": "3226.7222",
                                "monoisotopic_mz": "1076.5814",
                                "intensity": "4512.41",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3226.7198",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0025",
                                        "ppm": "0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "15",
                                "monoisotopic_mass": "1212.5868",
                                "monoisotopic_mz": "1213.5941",
                                "intensity": "753.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "16",
                                "monoisotopic_mass": "6668.8245",
                                "monoisotopic_mz": "1112.4780",
                                "intensity": "2729.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "17",
                                "monoisotopic_mass": "1171.5632",
                                "monoisotopic_mz": "1172.5704",
                                "intensity": "1445.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "0.0009",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "18",
                                "monoisotopic_mass": "1258.1075",
                                "monoisotopic_mz": "1259.1147",
                                "intensity": "705.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "19",
                                "monoisotopic_mass": "1097.2220",
                                "monoisotopic_mz": "1098.2292",
                                "intensity": "1016.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "20",
                                "monoisotopic_mass": "1299.6237",
                                "monoisotopic_mz": "1300.6310",
                                "intensity": "1502.55",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1299.6208",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "65",
                                        "mass_error": "0.0029",
                                        "ppm": "2.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "21",
                                "monoisotopic_mass": "1318.1164",
                                "monoisotopic_mz": "1319.1237",
                                "intensity": "1368.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "22",
                                "monoisotopic_mass": "1282.5940",
                                "monoisotopic_mz": "1283.6013",
                                "intensity": "1404.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "47",
                                "peak_id": "23",
                                "monoisotopic_mass": "1348.6955",
                                "monoisotopic_mz": "1349.7028",
                                "intensity": "1212.73",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5216",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "47",
                                        "peak_id": "14",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "47",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "47",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "47",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "47",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "spec_id": "47",
                                        "peak_id": "20",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "47",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "47",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "47",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "47",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "spec_id": "47",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "34",
                            "right_position": "55",
                            "anno": "396.3412",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "183",
                "p_value": "4.61e-10",
                "e_value": "4.61e-10",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "137",
                        "ms1_scans": "397",
                        "ids": "259",
                        "scans": "398",
                        "precursor_mono_mass": "8899.2693",
                        "precursor_charge": "9",
                        "precursor_mz": "989.8150",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "259",
                                "peak_id": "0",
                                "monoisotopic_mass": "3518.7982",
                                "monoisotopic_mz": "1173.9400",
                                "intensity": "6746.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "1",
                                "monoisotopic_mass": "2893.5520",
                                "monoisotopic_mz": "724.3953",
                                "intensity": "5245.76",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0011",
                                        "ppm": "0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "2",
                                "monoisotopic_mass": "3518.7978",
                                "monoisotopic_mz": "880.7067",
                                "intensity": "4541.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "3",
                                "monoisotopic_mass": "1029.4880",
                                "monoisotopic_mz": "1030.4952",
                                "intensity": "3278.94",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "4",
                                "monoisotopic_mass": "3470.7921",
                                "monoisotopic_mz": "1157.9380",
                                "intensity": "7059.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0028",
                                        "ppm": "0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "5",
                                "monoisotopic_mass": "916.4041",
                                "monoisotopic_mz": "917.4114",
                                "intensity": "5030.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0002",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "6",
                                "monoisotopic_mass": "2493.3804",
                                "monoisotopic_mz": "832.1341",
                                "intensity": "4096.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2493.3803",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0002",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "7",
                                "monoisotopic_mass": "3619.8515",
                                "monoisotopic_mz": "1207.6245",
                                "intensity": "2750.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "8",
                                "monoisotopic_mass": "2962.5695",
                                "monoisotopic_mz": "988.5304",
                                "intensity": "3177.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "9",
                                "monoisotopic_mass": "1880.0699",
                                "monoisotopic_mz": "941.0422",
                                "intensity": "2266.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1880.0731",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0033",
                                        "ppm": "-1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "10",
                                "monoisotopic_mass": "2893.5536",
                                "monoisotopic_mz": "965.5251",
                                "intensity": "4515.21",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0027",
                                        "ppm": "0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "11",
                                "monoisotopic_mass": "2512.2077",
                                "monoisotopic_mz": "1257.1111",
                                "intensity": "4008.71",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "12",
                                "monoisotopic_mass": "2980.5811",
                                "monoisotopic_mz": "994.5343",
                                "intensity": "3956.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2980.5829",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0019",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "13",
                                "monoisotopic_mass": "2579.2869",
                                "monoisotopic_mz": "1290.6507",
                                "intensity": "3018.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "14",
                                "monoisotopic_mass": "1767.3970",
                                "monoisotopic_mz": "884.7058",
                                "intensity": "1852.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "15",
                                "monoisotopic_mass": "801.3774",
                                "monoisotopic_mz": "802.3846",
                                "intensity": "2659.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "0.0004",
                                        "ppm": "0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "16",
                                "monoisotopic_mass": "724.3905",
                                "monoisotopic_mz": "725.3978",
                                "intensity": "1087.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "17",
                                "monoisotopic_mass": "988.5041",
                                "monoisotopic_mz": "989.5114",
                                "intensity": "1183.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "18",
                                "monoisotopic_mass": "8297.4632",
                                "monoisotopic_mz": "1038.1902",
                                "intensity": "823.48",
                                "charge": "8"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "19",
                                "monoisotopic_mass": "1945.9926",
                                "monoisotopic_mz": "974.0036",
                                "intensity": "2323.60",
                                "charge": "2"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "20",
                                "monoisotopic_mass": "2523.2666",
                                "monoisotopic_mz": "1262.6406",
                                "intensity": "1912.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "21",
                                "monoisotopic_mass": "1088.2085",
                                "monoisotopic_mz": "1089.2158",
                                "intensity": "1296.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "22",
                                "monoisotopic_mass": "3109.6299",
                                "monoisotopic_mz": "1037.5506",
                                "intensity": "3319.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "23",
                                "monoisotopic_mass": "3820.9662",
                                "monoisotopic_mz": "1274.6627",
                                "intensity": "2628.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "24",
                                "monoisotopic_mass": "3127.6556",
                                "monoisotopic_mz": "1043.5591",
                                "intensity": "3224.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0043",
                                        "ppm": "1.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "25",
                                "monoisotopic_mass": "1297.3338",
                                "monoisotopic_mz": "1298.3411",
                                "intensity": "1267.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "26",
                                "monoisotopic_mass": "901.9642",
                                "monoisotopic_mz": "902.9715",
                                "intensity": "1031.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "27",
                                "monoisotopic_mass": "1076.2277",
                                "monoisotopic_mz": "1077.2350",
                                "intensity": "1579.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "28",
                                "monoisotopic_mass": "1189.6077",
                                "monoisotopic_mz": "1190.6150",
                                "intensity": "949.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "259",
                                "peak_id": "29",
                                "monoisotopic_mass": "1017.9119",
                                "monoisotopic_mz": "1018.9192",
                                "intensity": "980.11",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5343",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "259",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "259",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "259",
                                            "peak_id": "1",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "259",
                                            "peak_id": "10",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "259",
                                        "peak_id": "12",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "259",
                                        "peak_id": "24",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "259",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "259",
                                        "peak_id": "11",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "259",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "259",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "259",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "55",
                            "anno": "396.3539",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "194",
                "p_value": "5.50e-10",
                "e_value": "5.50e-10",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "154",
                        "ms1_scans": "431",
                        "ids": "276",
                        "scans": "432",
                        "precursor_mono_mass": "8899.2803",
                        "precursor_charge": "9",
                        "precursor_mz": "989.8162",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "276",
                                "peak_id": "0",
                                "monoisotopic_mass": "3470.7883",
                                "monoisotopic_mz": "1157.9367",
                                "intensity": "5742.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "1",
                                "monoisotopic_mass": "3127.6563",
                                "monoisotopic_mz": "1043.5594",
                                "intensity": "4685.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "0.0050",
                                        "ppm": "1.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "2",
                                "monoisotopic_mass": "2893.5527",
                                "monoisotopic_mz": "724.3955",
                                "intensity": "3921.95",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0018",
                                        "ppm": "0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "3",
                                "monoisotopic_mass": "916.4042",
                                "monoisotopic_mz": "917.4115",
                                "intensity": "5294.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0003",
                                        "ppm": "0.32"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "4",
                                "monoisotopic_mass": "3517.8047",
                                "monoisotopic_mz": "1173.6088",
                                "intensity": "4594.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "5",
                                "monoisotopic_mass": "2963.5768",
                                "monoisotopic_mz": "988.8662",
                                "intensity": "4815.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "6",
                                "monoisotopic_mass": "2979.5824",
                                "monoisotopic_mz": "994.2014",
                                "intensity": "3081.81",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "7",
                                "monoisotopic_mass": "801.3766",
                                "monoisotopic_mz": "802.3838",
                                "intensity": "2739.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "8",
                                "monoisotopic_mass": "2493.3746",
                                "monoisotopic_mz": "832.1321",
                                "intensity": "4470.40",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2493.3803",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0057",
                                        "ppm": "-2.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "9",
                                "monoisotopic_mass": "2822.5146",
                                "monoisotopic_mz": "706.6359",
                                "intensity": "1726.08",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2822.5138",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0009",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "10",
                                "monoisotopic_mass": "2821.5107",
                                "monoisotopic_mz": "941.5108",
                                "intensity": "1276.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "11",
                                "monoisotopic_mass": "964.5173",
                                "monoisotopic_mz": "965.5245",
                                "intensity": "1097.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "12",
                                "monoisotopic_mass": "1059.8885",
                                "monoisotopic_mz": "1060.8958",
                                "intensity": "1269.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "13",
                                "monoisotopic_mass": "7238.6762",
                                "monoisotopic_mz": "905.8418",
                                "intensity": "2734.37",
                                "charge": "8"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "14",
                                "monoisotopic_mass": "525.2297",
                                "monoisotopic_mz": "526.2369",
                                "intensity": "1924.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0001",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "15",
                                "monoisotopic_mass": "5129.6034",
                                "monoisotopic_mz": "1283.4081",
                                "intensity": "770.79",
                                "charge": "4"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "16",
                                "monoisotopic_mass": "1256.1058",
                                "monoisotopic_mz": "1257.1130",
                                "intensity": "715.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "17",
                                "monoisotopic_mass": "1177.9260",
                                "monoisotopic_mz": "1178.9332",
                                "intensity": "520.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "18",
                                "monoisotopic_mass": "1880.0734",
                                "monoisotopic_mz": "941.0440",
                                "intensity": "1676.16",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1880.0731",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0003",
                                        "ppm": "0.15"
                                    }
                                }
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "19",
                                "monoisotopic_mass": "1282.5975",
                                "monoisotopic_mz": "1283.6047",
                                "intensity": "482.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "20",
                                "monoisotopic_mass": "1118.9219",
                                "monoisotopic_mz": "1119.9292",
                                "intensity": "1409.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "21",
                                "monoisotopic_mass": "990.3572",
                                "monoisotopic_mz": "991.3645",
                                "intensity": "1109.33",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "22",
                                "monoisotopic_mass": "1212.5872",
                                "monoisotopic_mz": "1213.5945",
                                "intensity": "1270.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "23",
                                "monoisotopic_mass": "1297.6678",
                                "monoisotopic_mz": "1298.6750",
                                "intensity": "502.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "276",
                                "peak_id": "24",
                                "monoisotopic_mass": "1045.9506",
                                "monoisotopic_mz": "1046.9579",
                                "intensity": "901.94",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5453",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "276",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "276",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "276",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "276",
                                        "peak_id": "2",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "276",
                                        "peak_id": "1",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "276",
                                        "peak_id": "0",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "276",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "276",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "spec_id": "276",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "70",
                            "anno": "396.3649",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "69",
                "p_value": "4.77e-09",
                "e_value": "4.77e-09",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "84",
                        "ms1_scans": "175",
                        "ids": "92",
                        "scans": "178",
                        "precursor_mono_mass": "8901.2712",
                        "precursor_charge": "8",
                        "precursor_mz": "1113.6662",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "92",
                                "peak_id": "0",
                                "monoisotopic_mass": "3340.0826",
                                "monoisotopic_mz": "1114.3681",
                                "intensity": "20718.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "1",
                                "monoisotopic_mass": "3583.8735",
                                "monoisotopic_mz": "1195.6318",
                                "intensity": "10723.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3583.8734",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "0.0002",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "2",
                                "monoisotopic_mass": "2511.2043",
                                "monoisotopic_mz": "1256.6094",
                                "intensity": "8213.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "3",
                                "monoisotopic_mass": "3470.7876",
                                "monoisotopic_mz": "1157.9365",
                                "intensity": "6083.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "4",
                                "monoisotopic_mass": "916.4029",
                                "monoisotopic_mz": "917.4102",
                                "intensity": "6762.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0010",
                                        "ppm": "-1.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "5",
                                "monoisotopic_mass": "3355.7560",
                                "monoisotopic_mz": "1119.5926",
                                "intensity": "3270.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3355.7623",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0063",
                                        "ppm": "-1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "6",
                                "monoisotopic_mass": "2893.5501",
                                "monoisotopic_mz": "965.5240",
                                "intensity": "5674.46",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "7",
                                "monoisotopic_mass": "3711.9269",
                                "monoisotopic_mz": "1238.3162",
                                "intensity": "3620.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3711.9319",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0051",
                                        "ppm": "-1.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "8",
                                "monoisotopic_mass": "1029.4869",
                                "monoisotopic_mz": "1030.4941",
                                "intensity": "4754.85",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "9",
                                "monoisotopic_mass": "3226.7281",
                                "monoisotopic_mz": "1076.5833",
                                "intensity": "4152.01",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3226.7198",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0083",
                                        "ppm": "2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "10",
                                "monoisotopic_mass": "1282.5923",
                                "monoisotopic_mz": "1283.5996",
                                "intensity": "1845.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "11",
                                "monoisotopic_mass": "2962.5690",
                                "monoisotopic_mz": "988.5303",
                                "intensity": "2845.03",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "12",
                                "monoisotopic_mass": "1100.5232",
                                "monoisotopic_mz": "1101.5305",
                                "intensity": "3091.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0019",
                                        "ppm": "-1.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "13",
                                "monoisotopic_mass": "3109.6494",
                                "monoisotopic_mz": "1037.5571",
                                "intensity": "1484.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "14",
                                "monoisotopic_mass": "6553.1843",
                                "monoisotopic_mz": "1093.2047",
                                "intensity": "1110.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "15",
                                "monoisotopic_mass": "4046.9001",
                                "monoisotopic_mz": "1012.7323",
                                "intensity": "1045.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "16",
                                "monoisotopic_mass": "5248.5558",
                                "monoisotopic_mz": "1313.1462",
                                "intensity": "3048.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "17",
                                "monoisotopic_mass": "1264.9741",
                                "monoisotopic_mz": "1265.9813",
                                "intensity": "623.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "18",
                                "monoisotopic_mass": "1400.1154",
                                "monoisotopic_mz": "1401.1227",
                                "intensity": "1914.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "19",
                                "monoisotopic_mass": "1299.6187",
                                "monoisotopic_mz": "1300.6260",
                                "intensity": "1311.08",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1299.6208",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0021",
                                        "ppm": "-1.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "20",
                                "monoisotopic_mass": "1482.7277",
                                "monoisotopic_mz": "1483.7350",
                                "intensity": "742.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "21",
                                "monoisotopic_mass": "1361.2293",
                                "monoisotopic_mz": "1362.2366",
                                "intensity": "1270.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "22",
                                "monoisotopic_mass": "1171.5613",
                                "monoisotopic_mz": "1172.5686",
                                "intensity": "2589.10",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "23",
                                "monoisotopic_mass": "1191.2065",
                                "monoisotopic_mz": "1192.2137",
                                "intensity": "673.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "24",
                                "monoisotopic_mass": "6785.4535",
                                "monoisotopic_mz": "1131.9162",
                                "intensity": "930.27",
                                "charge": "6"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "25",
                                "monoisotopic_mass": "1247.0961",
                                "monoisotopic_mz": "1248.1034",
                                "intensity": "1446.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "26",
                                "monoisotopic_mass": "3440.4631",
                                "monoisotopic_mz": "1147.8283",
                                "intensity": "2399.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "27",
                                "monoisotopic_mass": "5555.6183",
                                "monoisotopic_mz": "1112.1309",
                                "intensity": "1055.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "28",
                                "monoisotopic_mass": "4008.0714",
                                "monoisotopic_mz": "1337.0311",
                                "intensity": "3238.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "29",
                                "monoisotopic_mass": "1421.7019",
                                "monoisotopic_mz": "1422.7092",
                                "intensity": "662.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "30",
                                "monoisotopic_mass": "3418.5652",
                                "monoisotopic_mz": "1140.5290",
                                "intensity": "1426.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "31",
                                "monoisotopic_mass": "6218.2328",
                                "monoisotopic_mz": "1244.6538",
                                "intensity": "1886.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "32",
                                "monoisotopic_mass": "1326.6668",
                                "monoisotopic_mz": "1327.6741",
                                "intensity": "711.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "33",
                                "monoisotopic_mass": "2243.3220",
                                "monoisotopic_mz": "1122.6683",
                                "intensity": "2015.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "34",
                                "monoisotopic_mass": "2336.3362",
                                "monoisotopic_mz": "1169.1754",
                                "intensity": "1651.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "35",
                                "monoisotopic_mass": "4452.1807",
                                "monoisotopic_mz": "1114.0524",
                                "intensity": "11684.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "36",
                                "monoisotopic_mass": "1067.4431",
                                "monoisotopic_mz": "1068.4503",
                                "intensity": "763.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "92",
                                "peak_id": "37",
                                "monoisotopic_mass": "5865.0373",
                                "monoisotopic_mz": "1174.0147",
                                "intensity": "2591.25",
                                "charge": "5"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8901.5362",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "92",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "92",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "92",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "92",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "92",
                                        "peak_id": "1",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "92",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "spec_id": "92",
                                        "peak_id": "19",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "92",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "92",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "92",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "92",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "35",
                            "right_position": "66",
                            "anno": "398.3559",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "126",
                "p_value": "1.39e-08",
                "e_value": "1.39e-08",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "111",
                        "ms1_scans": "282",
                        "ids": "171",
                        "scans": "284",
                        "precursor_mono_mass": "8901.2537",
                        "precursor_charge": "8",
                        "precursor_mz": "1113.6640",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "171",
                                "peak_id": "0",
                                "monoisotopic_mass": "2512.2089",
                                "monoisotopic_mz": "1257.1117",
                                "intensity": "9228.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0007",
                                        "ppm": "0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "1",
                                "monoisotopic_mass": "3340.4162",
                                "monoisotopic_mz": "1114.4793",
                                "intensity": "32685.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "2",
                                "monoisotopic_mass": "3470.7982",
                                "monoisotopic_mz": "1157.9400",
                                "intensity": "5531.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0089",
                                        "ppm": "2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "3",
                                "monoisotopic_mass": "3226.7142",
                                "monoisotopic_mz": "1076.5787",
                                "intensity": "6244.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3226.7198",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "4",
                                "monoisotopic_mass": "3711.9305",
                                "monoisotopic_mz": "1238.3175",
                                "intensity": "3110.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3711.9319",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "5",
                                "monoisotopic_mass": "3583.8728",
                                "monoisotopic_mz": "1195.6316",
                                "intensity": "7020.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3583.8734",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "6",
                                "monoisotopic_mass": "3641.8956",
                                "monoisotopic_mz": "1214.9725",
                                "intensity": "4271.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "7",
                                "monoisotopic_mass": "801.3762",
                                "monoisotopic_mz": "802.3835",
                                "intensity": "2951.62",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "8",
                                "monoisotopic_mass": "3126.6459",
                                "monoisotopic_mz": "1043.2226",
                                "intensity": "3585.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "9",
                                "monoisotopic_mass": "2893.5551",
                                "monoisotopic_mz": "965.5256",
                                "intensity": "4075.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0042",
                                        "ppm": "1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "10",
                                "monoisotopic_mass": "916.4040",
                                "monoisotopic_mz": "917.4113",
                                "intensity": "5177.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0001",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "11",
                                "monoisotopic_mass": "3356.7620",
                                "monoisotopic_mz": "1119.9280",
                                "intensity": "4160.02",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "12",
                                "monoisotopic_mass": "1112.9196",
                                "monoisotopic_mz": "1113.9269",
                                "intensity": "10645.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "13",
                                "monoisotopic_mass": "1027.1311",
                                "monoisotopic_mz": "1028.1384",
                                "intensity": "5008.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "14",
                                "monoisotopic_mass": "1880.0738",
                                "monoisotopic_mz": "941.0442",
                                "intensity": "2367.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1880.0731",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0006",
                                        "ppm": "0.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "15",
                                "monoisotopic_mass": "3108.6360",
                                "monoisotopic_mz": "1037.2193",
                                "intensity": "2071.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "16",
                                "monoisotopic_mass": "1171.5628",
                                "monoisotopic_mz": "1172.5701",
                                "intensity": "1582.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "0.0006",
                                        "ppm": "0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "17",
                                "monoisotopic_mass": "4211.0763",
                                "monoisotopic_mz": "1053.7763",
                                "intensity": "2370.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "18",
                                "monoisotopic_mass": "4224.0798",
                                "monoisotopic_mz": "1409.0339",
                                "intensity": "2793.36",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "19",
                                "monoisotopic_mass": "1213.6294",
                                "monoisotopic_mz": "1214.6367",
                                "intensity": "2919.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "20",
                                "monoisotopic_mass": "4455.9938",
                                "monoisotopic_mz": "1115.0057",
                                "intensity": "2280.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "21",
                                "monoisotopic_mass": "1313.6510",
                                "monoisotopic_mz": "1314.6583",
                                "intensity": "701.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "22",
                                "monoisotopic_mass": "8036.2415",
                                "monoisotopic_mz": "1149.0418",
                                "intensity": "3322.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "23",
                                "monoisotopic_mass": "1299.6205",
                                "monoisotopic_mz": "1300.6278",
                                "intensity": "894.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1299.6208",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "Y00012",
                                        "ion_left_position": "65",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "24",
                                "monoisotopic_mass": "987.5235",
                                "monoisotopic_mz": "988.5308",
                                "intensity": "1313.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "25",
                                "monoisotopic_mass": "2058.9734",
                                "monoisotopic_mz": "1030.4940",
                                "intensity": "5021.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "26",
                                "monoisotopic_mass": "6275.2704",
                                "monoisotopic_mz": "1256.0614",
                                "intensity": "2489.94",
                                "charge": "5"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "27",
                                "monoisotopic_mass": "7600.7358",
                                "monoisotopic_mz": "1267.7966",
                                "intensity": "1285.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "28",
                                "monoisotopic_mass": "1137.5646",
                                "monoisotopic_mz": "1138.5719",
                                "intensity": "1225.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "29",
                                "monoisotopic_mass": "5479.8120",
                                "monoisotopic_mz": "1096.9697",
                                "intensity": "3948.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "30",
                                "monoisotopic_mass": "5767.0078",
                                "monoisotopic_mz": "1154.4088",
                                "intensity": "2259.45",
                                "charge": "5"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "31",
                                "monoisotopic_mass": "2344.5909",
                                "monoisotopic_mz": "1173.3027",
                                "intensity": "1611.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "32",
                                "monoisotopic_mass": "2979.5842",
                                "monoisotopic_mz": "994.2020",
                                "intensity": "1995.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "33",
                                "monoisotopic_mass": "2363.7892",
                                "monoisotopic_mz": "1182.9019",
                                "intensity": "1172.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "34",
                                "monoisotopic_mass": "1195.6293",
                                "monoisotopic_mz": "1196.6366",
                                "intensity": "1453.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "35",
                                "monoisotopic_mass": "1407.7654",
                                "monoisotopic_mz": "1408.7727",
                                "intensity": "814.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "36",
                                "monoisotopic_mass": "5558.2292",
                                "monoisotopic_mz": "1112.6531",
                                "intensity": "2496.27",
                                "charge": "5"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "37",
                                "monoisotopic_mass": "1276.9939",
                                "monoisotopic_mz": "1278.0011",
                                "intensity": "890.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "171",
                                "peak_id": "38",
                                "monoisotopic_mass": "3399.1597",
                                "monoisotopic_mz": "1134.0605",
                                "intensity": "1502.86",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8901.5187",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "171",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "171",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "171",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "171",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "171",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "171",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "171",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "65",
                                        "ion_display_position": "12",
                                        "spec_id": "171",
                                        "peak_id": "23",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "171",
                                        "peak_id": "16",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "171",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "171",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "35",
                            "right_position": "55",
                            "anno": "398.3383",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "197",
                "p_value": "1.51e-08",
                "e_value": "1.51e-08",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "184",
                        "ms1_scans": "464",
                        "ids": "279",
                        "scans": "465",
                        "precursor_mono_mass": "8900.2663",
                        "precursor_charge": "9",
                        "precursor_mz": "989.9258",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "279",
                                "peak_id": "0",
                                "monoisotopic_mass": "916.4035",
                                "monoisotopic_mz": "917.4108",
                                "intensity": "3269.24",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "1",
                                "monoisotopic_mass": "2512.2117",
                                "monoisotopic_mz": "1257.1131",
                                "intensity": "4160.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0035",
                                        "ppm": "1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "2",
                                "monoisotopic_mass": "2893.5515",
                                "monoisotopic_mz": "724.3952",
                                "intensity": "4636.27",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0006",
                                        "ppm": "0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "3",
                                "monoisotopic_mass": "2980.5816",
                                "monoisotopic_mz": "994.5345",
                                "intensity": "2083.35",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2980.5829",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "4",
                                "monoisotopic_mass": "3127.6479",
                                "monoisotopic_mz": "1043.5566",
                                "intensity": "3771.14",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "5",
                                "monoisotopic_mass": "2894.5517",
                                "monoisotopic_mz": "965.8579",
                                "intensity": "2728.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "6",
                                "monoisotopic_mass": "2962.5701",
                                "monoisotopic_mz": "988.5306",
                                "intensity": "2612.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "7",
                                "monoisotopic_mass": "1029.4871",
                                "monoisotopic_mz": "1030.4944",
                                "intensity": "1864.74",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "8",
                                "monoisotopic_mass": "801.3766",
                                "monoisotopic_mz": "802.3839",
                                "intensity": "2706.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "9",
                                "monoisotopic_mass": "963.5027",
                                "monoisotopic_mz": "964.5100",
                                "intensity": "1127.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "10",
                                "monoisotopic_mass": "1084.8031",
                                "monoisotopic_mz": "1085.8104",
                                "intensity": "632.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "11",
                                "monoisotopic_mass": "638.3126",
                                "monoisotopic_mz": "639.3199",
                                "intensity": "990.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "638.3137",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0010",
                                        "ppm": "-1.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "12",
                                "monoisotopic_mass": "4956.4268",
                                "monoisotopic_mz": "992.2926",
                                "intensity": "1987.03",
                                "charge": "5"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "13",
                                "monoisotopic_mass": "3977.4553",
                                "monoisotopic_mz": "995.3711",
                                "intensity": "1732.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "14",
                                "monoisotopic_mass": "1212.9462",
                                "monoisotopic_mz": "1213.9535",
                                "intensity": "622.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "15",
                                "monoisotopic_mass": "1044.5213",
                                "monoisotopic_mz": "1045.5286",
                                "intensity": "412.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "279",
                                "peak_id": "16",
                                "monoisotopic_mass": "939.0504",
                                "monoisotopic_mz": "940.0576",
                                "intensity": "871.72",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5313",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "279",
                                        "peak_id": "2",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "279",
                                        "peak_id": "3",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "279",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "279",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "279",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "279",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "279",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "6",
                                        "spec_id": "279",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "29",
                            "right_position": "55",
                            "anno": "397.3509",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "160",
                "p_value": "2.72e-08",
                "e_value": "2.72e-08",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "11",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "124",
                        "ms1_scans": "345",
                        "ids": "220",
                        "scans": "346",
                        "precursor_mono_mass": "8899.2561",
                        "precursor_charge": "9",
                        "precursor_mz": "989.8135",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "220",
                                "peak_id": "0",
                                "monoisotopic_mass": "3469.7904",
                                "monoisotopic_mz": "1157.6041",
                                "intensity": "6384.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "1",
                                "monoisotopic_mass": "2893.5518",
                                "monoisotopic_mz": "724.3952",
                                "intensity": "7753.88",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0009",
                                        "ppm": "0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "2",
                                "monoisotopic_mass": "3519.8029",
                                "monoisotopic_mz": "880.9580",
                                "intensity": "9348.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "3",
                                "monoisotopic_mass": "3619.8472",
                                "monoisotopic_mz": "1207.6230",
                                "intensity": "4568.76",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "4",
                                "monoisotopic_mass": "2961.5732",
                                "monoisotopic_mz": "988.1983",
                                "intensity": "5511.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "5",
                                "monoisotopic_mass": "2512.2086",
                                "monoisotopic_mz": "1257.1116",
                                "intensity": "4128.55",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0004",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "6",
                                "monoisotopic_mass": "3620.8528",
                                "monoisotopic_mz": "906.2205",
                                "intensity": "5202.36",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "7",
                                "monoisotopic_mass": "3517.8006",
                                "monoisotopic_mz": "1173.6075",
                                "intensity": "5923.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "8",
                                "monoisotopic_mass": "2492.3817",
                                "monoisotopic_mz": "831.8012",
                                "intensity": "4028.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "9",
                                "monoisotopic_mass": "2893.5510",
                                "monoisotopic_mz": "965.5243",
                                "intensity": "5168.78",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0001",
                                        "ppm": "0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "10",
                                "monoisotopic_mass": "916.4037",
                                "monoisotopic_mz": "917.4109",
                                "intensity": "3774.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "11",
                                "monoisotopic_mass": "1029.4869",
                                "monoisotopic_mz": "1030.4941",
                                "intensity": "2944.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.10"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "12",
                                "monoisotopic_mass": "2579.2836",
                                "monoisotopic_mz": "1290.6491",
                                "intensity": "3185.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "13",
                                "monoisotopic_mass": "3583.8706",
                                "monoisotopic_mz": "1195.6308",
                                "intensity": "3876.24",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3583.8734",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "14",
                                "monoisotopic_mass": "1880.0718",
                                "monoisotopic_mz": "941.0432",
                                "intensity": "2352.31",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1880.0731",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "15",
                                "monoisotopic_mass": "525.2291",
                                "monoisotopic_mz": "526.2364",
                                "intensity": "1775.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "16",
                                "monoisotopic_mass": "2980.5849",
                                "monoisotopic_mz": "994.5356",
                                "intensity": "3058.84",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2980.5829",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "B00027",
                                        "ion_left_position": "27",
                                        "mass_error": "0.0019",
                                        "ppm": "0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "17",
                                "monoisotopic_mass": "3532.7841",
                                "monoisotopic_mz": "884.2033",
                                "intensity": "2298.41",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "18",
                                "monoisotopic_mass": "1945.0026",
                                "monoisotopic_mz": "973.5086",
                                "intensity": "1192.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "19",
                                "monoisotopic_mass": "3867.9995",
                                "monoisotopic_mz": "968.0072",
                                "intensity": "980.73",
                                "charge": "4"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "20",
                                "monoisotopic_mass": "5689.7813",
                                "monoisotopic_mz": "1138.9635",
                                "intensity": "1029.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "21",
                                "monoisotopic_mass": "770.3563",
                                "monoisotopic_mz": "771.3635",
                                "intensity": "1021.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "22",
                                "monoisotopic_mass": "964.5189",
                                "monoisotopic_mz": "965.5261",
                                "intensity": "939.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "23",
                                "monoisotopic_mass": "1076.2403",
                                "monoisotopic_mz": "1077.2476",
                                "intensity": "1687.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "24",
                                "monoisotopic_mass": "7917.1175",
                                "monoisotopic_mz": "990.6470",
                                "intensity": "1263.97",
                                "charge": "8"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "25",
                                "monoisotopic_mass": "1010.7080",
                                "monoisotopic_mz": "1011.7153",
                                "intensity": "1005.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "26",
                                "monoisotopic_mass": "801.3757",
                                "monoisotopic_mz": "802.3830",
                                "intensity": "2639.84",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "27",
                                "monoisotopic_mass": "1190.7581",
                                "monoisotopic_mz": "1191.7654",
                                "intensity": "996.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "28",
                                "monoisotopic_mass": "853.3992",
                                "monoisotopic_mz": "854.4065",
                                "intensity": "1283.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "29",
                                "monoisotopic_mass": "6515.0887",
                                "monoisotopic_mz": "931.7342",
                                "intensity": "1091.61",
                                "charge": "7"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "30",
                                "monoisotopic_mass": "2932.9127",
                                "monoisotopic_mz": "978.6448",
                                "intensity": "3032.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "31",
                                "monoisotopic_mass": "1261.1305",
                                "monoisotopic_mz": "1262.1378",
                                "intensity": "1626.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "32",
                                "monoisotopic_mass": "1100.5236",
                                "monoisotopic_mz": "1101.5309",
                                "intensity": "1734.30",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "33",
                                "monoisotopic_mass": "1043.2200",
                                "monoisotopic_mz": "1044.2273",
                                "intensity": "1899.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "34",
                                "monoisotopic_mass": "1117.9048",
                                "monoisotopic_mz": "1118.9121",
                                "intensity": "603.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "35",
                                "monoisotopic_mass": "6712.5322",
                                "monoisotopic_mz": "1119.7626",
                                "intensity": "4102.08",
                                "charge": "6"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "36",
                                "monoisotopic_mass": "1298.0015",
                                "monoisotopic_mz": "1299.0088",
                                "intensity": "1143.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "37",
                                "monoisotopic_mass": "1238.6160",
                                "monoisotopic_mz": "1239.6233",
                                "intensity": "1296.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "38",
                                "monoisotopic_mass": "989.5059",
                                "monoisotopic_mz": "990.5131",
                                "intensity": "673.37",
                                "charge": "1"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "39",
                                "monoisotopic_mass": "1821.5887",
                                "monoisotopic_mz": "911.8016",
                                "intensity": "1336.44",
                                "charge": "2"
                            },
                            {
                                "spec_id": "220",
                                "peak_id": "40",
                                "monoisotopic_mass": "2084.0569",
                                "monoisotopic_mz": "1043.0357",
                                "intensity": "1908.10",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5211",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "220",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "220",
                                            "peak_id": "9",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "220",
                                            "peak_id": "1",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "27",
                                        "ion_display_position": "27",
                                        "spec_id": "220",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "220",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "220",
                                        "peak_id": "5",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "220",
                                        "peak_id": "32",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "220",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "220",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "220",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "spec_id": "220",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "33",
                            "right_position": "55",
                            "anno": "396.3407",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "190",
                "p_value": "1.20e-07",
                "e_value": "1.20e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "147",
                        "ms1_scans": "418",
                        "ids": "271",
                        "scans": "420",
                        "precursor_mono_mass": "8899.2755",
                        "precursor_charge": "6",
                        "precursor_mz": "1484.2199",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "271",
                                "peak_id": "0",
                                "monoisotopic_mass": "916.4034",
                                "monoisotopic_mz": "917.4107",
                                "intensity": "5907.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "1",
                                "monoisotopic_mass": "2512.2055",
                                "monoisotopic_mz": "1257.1100",
                                "intensity": "7331.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "55",
                                        "mass_error": "-0.0027",
                                        "ppm": "-1.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "2",
                                "monoisotopic_mass": "801.3768",
                                "monoisotopic_mz": "802.3840",
                                "intensity": "3303.29",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "3",
                                "monoisotopic_mass": "1100.5248",
                                "monoisotopic_mz": "1101.5321",
                                "intensity": "3202.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "4",
                                "monoisotopic_mass": "1171.5610",
                                "monoisotopic_mz": "1172.5682",
                                "intensity": "2159.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "5",
                                "monoisotopic_mass": "1029.4877",
                                "monoisotopic_mz": "1030.4950",
                                "intensity": "3468.15",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "6",
                                "monoisotopic_mass": "638.3135",
                                "monoisotopic_mz": "639.3207",
                                "intensity": "1122.46",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "638.3137",
                                        "ion_position": "72",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "7",
                                "monoisotopic_mass": "525.2292",
                                "monoisotopic_mz": "526.2364",
                                "intensity": "2243.27",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "8",
                                "monoisotopic_mass": "2625.2912",
                                "monoisotopic_mz": "1313.6529",
                                "intensity": "1892.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2625.2923",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "9",
                                "monoisotopic_mass": "5859.8526",
                                "monoisotopic_mz": "1954.2915",
                                "intensity": "642.50",
                                "charge": "3"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "10",
                                "monoisotopic_mass": "1247.5918",
                                "monoisotopic_mz": "1248.5991",
                                "intensity": "607.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "271",
                                "peak_id": "11",
                                "monoisotopic_mass": "5955.8145",
                                "monoisotopic_mz": "1986.2788",
                                "intensity": "914.39",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5405",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "0",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "spec_id": "271",
                                        "peak_id": "8",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "spec_id": "271",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "spec_id": "271",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "spec_id": "271",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "spec_id": "271",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "spec_id": "271",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "spec_id": "271",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "6",
                                        "spec_id": "271",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "spec_id": "271",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "54",
                            "anno": "265.3197",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "123",
                "p_value": "1.39e-07",
                "e_value": "1.39e-07",
                "fdr": "0",
                "matched_fragment_number": "10",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "110",
                        "ms1_scans": "278",
                        "ids": "168",
                        "scans": "280",
                        "precursor_mono_mass": "8899.2907",
                        "precursor_charge": "9",
                        "precursor_mz": "989.8174",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "168",
                                "peak_id": "0",
                                "monoisotopic_mass": "3518.8015",
                                "monoisotopic_mz": "1173.9411",
                                "intensity": "9057.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "1",
                                "monoisotopic_mass": "2962.5693",
                                "monoisotopic_mz": "988.5304",
                                "intensity": "6084.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "2",
                                "monoisotopic_mass": "3619.8489",
                                "monoisotopic_mz": "905.9695",
                                "intensity": "6945.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "3",
                                "monoisotopic_mass": "3519.8011",
                                "monoisotopic_mz": "880.9575",
                                "intensity": "6461.80",
                                "charge": "4"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "4",
                                "monoisotopic_mass": "3470.7858",
                                "monoisotopic_mz": "1157.9359",
                                "intensity": "6050.70",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "5",
                                "monoisotopic_mass": "2511.2046",
                                "monoisotopic_mz": "1256.6096",
                                "intensity": "4560.09",
                                "charge": "2"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "6",
                                "monoisotopic_mass": "2893.5496",
                                "monoisotopic_mz": "724.3947",
                                "intensity": "4358.82",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "7",
                                "monoisotopic_mass": "1029.4877",
                                "monoisotopic_mz": "1030.4950",
                                "intensity": "4050.28",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0003",
                                        "ppm": "-0.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "8",
                                "monoisotopic_mass": "3619.8508",
                                "monoisotopic_mz": "1207.6242",
                                "intensity": "6010.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "9",
                                "monoisotopic_mass": "3127.6508",
                                "monoisotopic_mz": "1043.5576",
                                "intensity": "4222.57",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "10",
                                "monoisotopic_mass": "3227.7169",
                                "monoisotopic_mz": "1076.9129",
                                "intensity": "2562.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "11",
                                "monoisotopic_mass": "916.4040",
                                "monoisotopic_mz": "917.4113",
                                "intensity": "5256.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0001",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "12",
                                "monoisotopic_mass": "3956.3039",
                                "monoisotopic_mz": "990.0832",
                                "intensity": "3149.87",
                                "charge": "4"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "13",
                                "monoisotopic_mass": "2493.3837",
                                "monoisotopic_mz": "832.1352",
                                "intensity": "4109.98",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2493.3803",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0034",
                                        "ppm": "1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "14",
                                "monoisotopic_mass": "1100.5253",
                                "monoisotopic_mz": "1101.5326",
                                "intensity": "1798.54",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "0.0002",
                                        "ppm": "0.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "15",
                                "monoisotopic_mass": "2581.2960",
                                "monoisotopic_mz": "1291.6553",
                                "intensity": "2809.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "16",
                                "monoisotopic_mass": "3888.9920",
                                "monoisotopic_mz": "1297.3379",
                                "intensity": "1058.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "17",
                                "monoisotopic_mass": "2560.1956",
                                "monoisotopic_mz": "854.4058",
                                "intensity": "2432.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "18",
                                "monoisotopic_mass": "6920.1500",
                                "monoisotopic_mz": "989.6001",
                                "intensity": "917.87",
                                "charge": "7"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "19",
                                "monoisotopic_mass": "4948.0996",
                                "monoisotopic_mz": "990.6272",
                                "intensity": "1024.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "20",
                                "monoisotopic_mass": "6867.9575",
                                "monoisotopic_mz": "1145.6669",
                                "intensity": "1060.13",
                                "charge": "6"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "21",
                                "monoisotopic_mass": "2822.5143",
                                "monoisotopic_mz": "941.8454",
                                "intensity": "2424.25",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2822.5138",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0006",
                                        "ppm": "0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "22",
                                "monoisotopic_mass": "5724.8113",
                                "monoisotopic_mz": "1145.9695",
                                "intensity": "1008.18",
                                "charge": "5"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "23",
                                "monoisotopic_mass": "3357.7567",
                                "monoisotopic_mz": "1120.2595",
                                "intensity": "2137.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "24",
                                "monoisotopic_mass": "7910.9154",
                                "monoisotopic_mz": "989.8717",
                                "intensity": "4116.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "25",
                                "monoisotopic_mass": "987.8907",
                                "monoisotopic_mz": "988.8979",
                                "intensity": "1164.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "26",
                                "monoisotopic_mass": "1171.5603",
                                "monoisotopic_mz": "1172.5676",
                                "intensity": "801.17",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "66",
                                        "mass_error": "-0.0019",
                                        "ppm": "-1.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "27",
                                "monoisotopic_mass": "933.3776",
                                "monoisotopic_mz": "934.3848",
                                "intensity": "1074.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "28",
                                "monoisotopic_mass": "2021.5458",
                                "monoisotopic_mz": "1011.7802",
                                "intensity": "1643.47",
                                "charge": "2"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "29",
                                "monoisotopic_mass": "801.3769",
                                "monoisotopic_mz": "802.3842",
                                "intensity": "1959.19",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "30",
                                "monoisotopic_mass": "3344.6254",
                                "monoisotopic_mz": "1115.8824",
                                "intensity": "1159.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "31",
                                "monoisotopic_mass": "1062.2023",
                                "monoisotopic_mz": "1063.2096",
                                "intensity": "1100.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "32",
                                "monoisotopic_mass": "1189.4402",
                                "monoisotopic_mz": "1190.4475",
                                "intensity": "827.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "33",
                                "monoisotopic_mass": "1118.5868",
                                "monoisotopic_mz": "1119.5941",
                                "intensity": "1422.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "34",
                                "monoisotopic_mass": "1347.3689",
                                "monoisotopic_mz": "1348.3762",
                                "intensity": "790.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "35",
                                "monoisotopic_mass": "4103.1505",
                                "monoisotopic_mz": "1026.7949",
                                "intensity": "2228.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "36",
                                "monoisotopic_mass": "1928.7089",
                                "monoisotopic_mz": "965.3617",
                                "intensity": "3348.04",
                                "charge": "2"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "37",
                                "monoisotopic_mass": "4062.0253",
                                "monoisotopic_mz": "1016.5136",
                                "intensity": "2596.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "38",
                                "monoisotopic_mass": "5601.3293",
                                "monoisotopic_mz": "1121.2731",
                                "intensity": "2228.60",
                                "charge": "5"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "39",
                                "monoisotopic_mass": "1262.1270",
                                "monoisotopic_mz": "1263.1343",
                                "intensity": "967.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "40",
                                "monoisotopic_mass": "2095.0679",
                                "monoisotopic_mz": "1048.5412",
                                "intensity": "1429.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "168",
                                "peak_id": "41",
                                "monoisotopic_mass": "3265.5545",
                                "monoisotopic_mz": "1089.5254",
                                "intensity": "2065.90",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5557",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "168",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "168",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "spec_id": "168",
                                        "peak_id": "6",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "168",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "168",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "66",
                                        "ion_display_position": "11",
                                        "spec_id": "168",
                                        "peak_id": "26",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "168",
                                        "peak_id": "14",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "168",
                                        "peak_id": "7",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "168",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "168",
                                        "peak_id": "29",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "67",
                            "anno": "396.3753",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "174",
                "p_value": "2.31e-07",
                "e_value": "2.31e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "131",
                        "ms1_scans": "375",
                        "ids": "245",
                        "scans": "378",
                        "precursor_mono_mass": "8900.2790",
                        "precursor_charge": "6",
                        "precursor_mz": "1484.3871",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "245",
                                "peak_id": "0",
                                "monoisotopic_mass": "2512.2047",
                                "monoisotopic_mz": "1257.1096",
                                "intensity": "6483.73",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "55",
                                        "mass_error": "-0.0035",
                                        "ppm": "-1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "1",
                                "monoisotopic_mass": "1029.4871",
                                "monoisotopic_mz": "1030.4944",
                                "intensity": "3214.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "2",
                                "monoisotopic_mass": "916.4031",
                                "monoisotopic_mz": "917.4104",
                                "intensity": "5072.92",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "3",
                                "monoisotopic_mass": "525.2292",
                                "monoisotopic_mz": "526.2364",
                                "intensity": "2534.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "4",
                                "monoisotopic_mass": "1100.5249",
                                "monoisotopic_mz": "1101.5322",
                                "intensity": "2252.22",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "5",
                                "monoisotopic_mass": "1171.5608",
                                "monoisotopic_mz": "1172.5681",
                                "intensity": "1783.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0014",
                                        "ppm": "-1.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "6",
                                "monoisotopic_mass": "2857.9731",
                                "monoisotopic_mz": "1429.9938",
                                "intensity": "2267.80",
                                "charge": "2"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "7",
                                "monoisotopic_mass": "7144.9386",
                                "monoisotopic_mz": "1429.9950",
                                "intensity": "2843.49",
                                "charge": "5"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "8",
                                "monoisotopic_mass": "801.3764",
                                "monoisotopic_mz": "802.3837",
                                "intensity": "3172.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "9",
                                "monoisotopic_mass": "2625.2902",
                                "monoisotopic_mz": "1313.6524",
                                "intensity": "1899.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2625.2923",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0021",
                                        "ppm": "-0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "10",
                                "monoisotopic_mass": "638.3127",
                                "monoisotopic_mz": "639.3200",
                                "intensity": "1451.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "638.3137",
                                        "ion_position": "72",
                                        "ion_display_position": "6",
                                        "ion_sort_name": "Y00006",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0009",
                                        "ppm": "-1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "11",
                                "monoisotopic_mass": "4441.7062",
                                "monoisotopic_mz": "1481.5760",
                                "intensity": "2489.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "12",
                                "monoisotopic_mass": "1248.0928",
                                "monoisotopic_mz": "1249.1001",
                                "intensity": "1195.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "13",
                                "monoisotopic_mass": "1482.7177",
                                "monoisotopic_mz": "1483.7250",
                                "intensity": "565.38",
                                "charge": "1"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "14",
                                "monoisotopic_mass": "5715.4925",
                                "monoisotopic_mz": "1429.8804",
                                "intensity": "1633.50",
                                "charge": "4"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "15",
                                "monoisotopic_mass": "1340.6454",
                                "monoisotopic_mz": "1341.6527",
                                "intensity": "555.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "16",
                                "monoisotopic_mass": "1300.6221",
                                "monoisotopic_mz": "1301.6294",
                                "intensity": "705.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "17",
                                "monoisotopic_mass": "1428.6924",
                                "monoisotopic_mz": "1429.6997",
                                "intensity": "1790.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "245",
                                "peak_id": "18",
                                "monoisotopic_mass": "899.3758",
                                "monoisotopic_mz": "900.3831",
                                "intensity": "797.96",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5440",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "0",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "spec_id": "245",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "spec_id": "245",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "spec_id": "245",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "spec_id": "245",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "spec_id": "245",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "spec_id": "245",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "spec_id": "245",
                                        "peak_id": "8",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "6",
                                        "spec_id": "245",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "spec_id": "245",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "54",
                            "anno": "266.3231",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "144",
                "p_value": "2.93e-07",
                "e_value": "2.93e-07",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "8",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "118",
                        "ms1_scans": "318",
                        "ids": "201",
                        "scans": "321",
                        "precursor_mono_mass": "8899.2887",
                        "precursor_charge": "6",
                        "precursor_mz": "1484.2221",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "201",
                                "peak_id": "0",
                                "monoisotopic_mass": "2511.2038",
                                "monoisotopic_mz": "1256.6092",
                                "intensity": "6999.64",
                                "charge": "2"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "1",
                                "monoisotopic_mass": "916.4034",
                                "monoisotopic_mz": "917.4107",
                                "intensity": "5107.68",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "2",
                                "monoisotopic_mass": "801.3771",
                                "monoisotopic_mz": "802.3844",
                                "intensity": "3117.63",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "71",
                                        "mass_error": "0.0001",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "3",
                                "monoisotopic_mass": "1100.5242",
                                "monoisotopic_mz": "1101.5315",
                                "intensity": "4283.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "4",
                                "monoisotopic_mass": "1029.4881",
                                "monoisotopic_mz": "1030.4954",
                                "intensity": "3821.58",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0001",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "5",
                                "monoisotopic_mass": "525.2294",
                                "monoisotopic_mz": "526.2366",
                                "intensity": "2313.26",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "6",
                                "monoisotopic_mass": "1171.5611",
                                "monoisotopic_mz": "1172.5684",
                                "intensity": "1983.37",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "7",
                                "monoisotopic_mass": "2625.2924",
                                "monoisotopic_mz": "1313.6535",
                                "intensity": "871.63",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2625.2923",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "ion_sort_name": "Y00024",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0001",
                                        "ppm": "0.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "8",
                                "monoisotopic_mass": "1194.9594",
                                "monoisotopic_mz": "1195.9667",
                                "intensity": "626.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "9",
                                "monoisotopic_mass": "2970.4065",
                                "monoisotopic_mz": "1486.2105",
                                "intensity": "1549.01",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2970.4095",
                                        "ion_position": "51",
                                        "ion_display_position": "27",
                                        "ion_sort_name": "Y00027",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0030",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "10",
                                "monoisotopic_mass": "2495.1810",
                                "monoisotopic_mz": "1248.5978",
                                "intensity": "1394.59",
                                "charge": "2"
                            },
                            {
                                "spec_id": "201",
                                "peak_id": "11",
                                "monoisotopic_mass": "1282.5950",
                                "monoisotopic_mz": "1283.6023",
                                "intensity": "1077.83",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8899.5537",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "0",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "51",
                                        "ion_display_position": "27",
                                        "spec_id": "201",
                                        "peak_id": "9",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "24",
                                        "spec_id": "201",
                                        "peak_id": "7",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "spec_id": "201",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "spec_id": "201",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "spec_id": "201",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "spec_id": "201",
                                        "peak_id": "1",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "spec_id": "201",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "spec_id": "201",
                                        "peak_id": "5",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "51",
                            "anno": "265.3329",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "93",
                "p_value": "7.04e-07",
                "e_value": "7.04e-07",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "96",
                        "ms1_scans": "223",
                        "ids": "127",
                        "scans": "225",
                        "precursor_mono_mass": "8900.2449",
                        "precursor_charge": "9",
                        "precursor_mz": "989.9234",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "127",
                                "peak_id": "0",
                                "monoisotopic_mass": "3518.8004",
                                "monoisotopic_mz": "1173.9407",
                                "intensity": "6919.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "1",
                                "monoisotopic_mass": "3619.8490",
                                "monoisotopic_mz": "1207.6236",
                                "intensity": "5184.84",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "2",
                                "monoisotopic_mass": "2893.5512",
                                "monoisotopic_mz": "965.5243",
                                "intensity": "4145.53",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0003",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "3",
                                "monoisotopic_mass": "2962.5691",
                                "monoisotopic_mz": "988.5303",
                                "intensity": "4453.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "4",
                                "monoisotopic_mass": "3518.8025",
                                "monoisotopic_mz": "880.7079",
                                "intensity": "6677.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "5",
                                "monoisotopic_mass": "3620.8554",
                                "monoisotopic_mz": "906.2211",
                                "intensity": "5190.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "6",
                                "monoisotopic_mass": "3470.7982",
                                "monoisotopic_mz": "1157.9400",
                                "intensity": "6132.95",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0089",
                                        "ppm": "2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "7",
                                "monoisotopic_mass": "2893.5517",
                                "monoisotopic_mz": "724.3952",
                                "intensity": "4421.67",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0008",
                                        "ppm": "0.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "8",
                                "monoisotopic_mass": "2579.2819",
                                "monoisotopic_mz": "1290.6482",
                                "intensity": "3513.62",
                                "charge": "2"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "9",
                                "monoisotopic_mass": "916.4039",
                                "monoisotopic_mz": "917.4111",
                                "intensity": "5218.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "10",
                                "monoisotopic_mass": "3109.6384",
                                "monoisotopic_mz": "1037.5534",
                                "intensity": "4077.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "11",
                                "monoisotopic_mass": "1029.4887",
                                "monoisotopic_mz": "1030.4960",
                                "intensity": "3201.79",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0007",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "12",
                                "monoisotopic_mass": "2512.2086",
                                "monoisotopic_mz": "1257.1116",
                                "intensity": "4905.84",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0004",
                                        "ppm": "0.17"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "13",
                                "monoisotopic_mass": "2979.5795",
                                "monoisotopic_mz": "994.2004",
                                "intensity": "2339.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "14",
                                "monoisotopic_mass": "2492.3768",
                                "monoisotopic_mz": "831.7995",
                                "intensity": "3145.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "15",
                                "monoisotopic_mass": "3355.7652",
                                "monoisotopic_mz": "1119.5957",
                                "intensity": "3017.86",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3355.7623",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0028",
                                        "ppm": "0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "16",
                                "monoisotopic_mass": "3127.6464",
                                "monoisotopic_mz": "1043.5561",
                                "intensity": "3185.34",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0049",
                                        "ppm": "-1.57"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "17",
                                "monoisotopic_mass": "6254.5318",
                                "monoisotopic_mz": "1043.4292",
                                "intensity": "1335.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "18",
                                "monoisotopic_mass": "525.2297",
                                "monoisotopic_mz": "526.2369",
                                "intensity": "2506.20",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0001",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "19",
                                "monoisotopic_mass": "1075.9078",
                                "monoisotopic_mz": "1076.9150",
                                "intensity": "1053.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "20",
                                "monoisotopic_mass": "5397.3561",
                                "monoisotopic_mz": "1080.4785",
                                "intensity": "782.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "21",
                                "monoisotopic_mass": "1327.9695",
                                "monoisotopic_mz": "1328.9768",
                                "intensity": "990.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "22",
                                "monoisotopic_mass": "1308.0451",
                                "monoisotopic_mz": "1309.0524",
                                "intensity": "938.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "23",
                                "monoisotopic_mass": "4112.1792",
                                "monoisotopic_mz": "1029.0521",
                                "intensity": "1155.09",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "24",
                                "monoisotopic_mass": "2314.3087",
                                "monoisotopic_mz": "1158.1616",
                                "intensity": "1048.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "25",
                                "monoisotopic_mass": "770.3564",
                                "monoisotopic_mz": "771.3637",
                                "intensity": "1960.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "26",
                                "monoisotopic_mass": "5186.9044",
                                "monoisotopic_mz": "865.4913",
                                "intensity": "958.28",
                                "charge": "6"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "27",
                                "monoisotopic_mass": "4168.1929",
                                "monoisotopic_mz": "1043.0555",
                                "intensity": "2170.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "28",
                                "monoisotopic_mass": "801.3764",
                                "monoisotopic_mz": "802.3837",
                                "intensity": "1757.40",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "29",
                                "monoisotopic_mass": "8551.9950",
                                "monoisotopic_mz": "1070.0066",
                                "intensity": "981.18",
                                "charge": "8"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "30",
                                "monoisotopic_mass": "1102.9140",
                                "monoisotopic_mz": "1103.9213",
                                "intensity": "1123.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "31",
                                "monoisotopic_mass": "1016.2617",
                                "monoisotopic_mz": "1017.2690",
                                "intensity": "1515.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "32",
                                "monoisotopic_mass": "940.5586",
                                "monoisotopic_mz": "941.5659",
                                "intensity": "1577.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "33",
                                "monoisotopic_mass": "4703.9664",
                                "monoisotopic_mz": "1176.9989",
                                "intensity": "2102.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "34",
                                "monoisotopic_mass": "1119.5059",
                                "monoisotopic_mz": "1120.5132",
                                "intensity": "1154.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "35",
                                "monoisotopic_mass": "1001.5176",
                                "monoisotopic_mz": "1002.5248",
                                "intensity": "1018.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "36",
                                "monoisotopic_mass": "4427.2794",
                                "monoisotopic_mz": "1107.8271",
                                "intensity": "1081.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "37",
                                "monoisotopic_mass": "2357.8461",
                                "monoisotopic_mz": "1179.9303",
                                "intensity": "1059.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "38",
                                "monoisotopic_mass": "1063.7182",
                                "monoisotopic_mz": "1064.7255",
                                "intensity": "1157.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "39",
                                "monoisotopic_mass": "5062.7889",
                                "monoisotopic_mz": "1013.5651",
                                "intensity": "2388.43",
                                "charge": "5"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "40",
                                "monoisotopic_mass": "4388.2652",
                                "monoisotopic_mz": "1098.0736",
                                "intensity": "2039.79",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "41",
                                "monoisotopic_mass": "7552.7640",
                                "monoisotopic_mz": "1079.9736",
                                "intensity": "2211.44",
                                "charge": "7"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "42",
                                "monoisotopic_mass": "7666.9244",
                                "monoisotopic_mz": "959.3728",
                                "intensity": "1297.66",
                                "charge": "8"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "43",
                                "monoisotopic_mass": "5922.2764",
                                "monoisotopic_mz": "988.0533",
                                "intensity": "2292.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "44",
                                "monoisotopic_mass": "3274.3506",
                                "monoisotopic_mz": "1092.4575",
                                "intensity": "2079.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "45",
                                "monoisotopic_mass": "1262.1359",
                                "monoisotopic_mz": "1263.1432",
                                "intensity": "936.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "46",
                                "monoisotopic_mass": "1051.4544",
                                "monoisotopic_mz": "1052.4617",
                                "intensity": "1698.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "47",
                                "monoisotopic_mass": "968.5670",
                                "monoisotopic_mz": "969.5743",
                                "intensity": "933.36",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "48",
                                "monoisotopic_mass": "3872.0033",
                                "monoisotopic_mz": "969.0081",
                                "intensity": "1892.86",
                                "charge": "4"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "49",
                                "monoisotopic_mass": "884.4434",
                                "monoisotopic_mz": "885.4507",
                                "intensity": "944.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "127",
                                "peak_id": "50",
                                "monoisotopic_mass": "3191.4126",
                                "monoisotopic_mz": "798.8604",
                                "intensity": "2607.95",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5099",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "127",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "127",
                                            "peak_id": "7",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "127",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "127",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "127",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "127",
                                        "peak_id": "12",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "127",
                                        "peak_id": "11",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "127",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "127",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "spec_id": "127",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "55",
                            "anno": "397.3295",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "20",
                "p_value": "1.25e-06",
                "e_value": "1.25e-06",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "63",
                        "ms1_scans": "89",
                        "ids": "25",
                        "scans": "90",
                        "precursor_mono_mass": "8900.2498",
                        "precursor_charge": "9",
                        "precursor_mz": "989.9239",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "25",
                                "peak_id": "0",
                                "monoisotopic_mass": "2512.2125",
                                "monoisotopic_mz": "1257.1135",
                                "intensity": "5109.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "0.0043",
                                        "ppm": "1.73"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "1",
                                "monoisotopic_mass": "3619.8476",
                                "monoisotopic_mz": "905.9692",
                                "intensity": "6142.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "2",
                                "monoisotopic_mass": "3127.6505",
                                "monoisotopic_mz": "1043.5574",
                                "intensity": "6028.09",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3127.6513",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "B00028",
                                        "ion_left_position": "28",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "3",
                                "monoisotopic_mass": "3518.8018",
                                "monoisotopic_mz": "880.7077",
                                "intensity": "5941.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "4",
                                "monoisotopic_mass": "3470.7935",
                                "monoisotopic_mz": "1157.9384",
                                "intensity": "3595.21",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3470.7893",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0042",
                                        "ppm": "1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "5",
                                "monoisotopic_mass": "3518.8011",
                                "monoisotopic_mz": "1173.9410",
                                "intensity": "4646.88",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "6",
                                "monoisotopic_mass": "3619.8468",
                                "monoisotopic_mz": "1207.6229",
                                "intensity": "4400.69",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "7",
                                "monoisotopic_mass": "3226.7123",
                                "monoisotopic_mz": "1076.5780",
                                "intensity": "3130.30",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3226.7198",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "-0.0075",
                                        "ppm": "-2.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "8",
                                "monoisotopic_mass": "2893.5466",
                                "monoisotopic_mz": "965.5228",
                                "intensity": "3050.20",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0043",
                                        "ppm": "-1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "9",
                                "monoisotopic_mass": "916.4040",
                                "monoisotopic_mz": "917.4113",
                                "intensity": "4634.56",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0001",
                                        "ppm": "0.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "10",
                                "monoisotopic_mass": "1029.4899",
                                "monoisotopic_mz": "1030.4972",
                                "intensity": "2692.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0019",
                                        "ppm": "1.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "11",
                                "monoisotopic_mass": "2893.5536",
                                "monoisotopic_mz": "724.3957",
                                "intensity": "5524.24",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "0.0027",
                                        "ppm": "0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "12",
                                "monoisotopic_mass": "2979.5826",
                                "monoisotopic_mz": "994.2015",
                                "intensity": "2544.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "13",
                                "monoisotopic_mass": "989.7421",
                                "monoisotopic_mz": "990.7494",
                                "intensity": "1433.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "14",
                                "monoisotopic_mass": "1015.8995",
                                "monoisotopic_mz": "1016.9068",
                                "intensity": "1183.44",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "15",
                                "monoisotopic_mass": "801.3771",
                                "monoisotopic_mz": "802.3843",
                                "intensity": "2695.01",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "70",
                                        "mass_error": "0.0001",
                                        "ppm": "0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "16",
                                "monoisotopic_mass": "6464.2455",
                                "monoisotopic_mz": "1078.3815",
                                "intensity": "1704.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "17",
                                "monoisotopic_mass": "1100.5201",
                                "monoisotopic_mz": "1101.5273",
                                "intensity": "773.35",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0050",
                                        "ppm": "-4.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "18",
                                "monoisotopic_mass": "6450.8911",
                                "monoisotopic_mz": "1076.1558",
                                "intensity": "1095.69",
                                "charge": "6"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "19",
                                "monoisotopic_mass": "1139.4660",
                                "monoisotopic_mz": "1140.4733",
                                "intensity": "1235.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "20",
                                "monoisotopic_mass": "3108.6368",
                                "monoisotopic_mz": "1037.2195",
                                "intensity": "2149.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "21",
                                "monoisotopic_mass": "4388.1114",
                                "monoisotopic_mz": "1098.0351",
                                "intensity": "1430.77",
                                "charge": "4"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "22",
                                "monoisotopic_mass": "7862.4242",
                                "monoisotopic_mz": "1124.2107",
                                "intensity": "1061.43",
                                "charge": "7"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "23",
                                "monoisotopic_mass": "3309.7141",
                                "monoisotopic_mz": "1104.2453",
                                "intensity": "1817.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "24",
                                "monoisotopic_mass": "831.4614",
                                "monoisotopic_mz": "832.4686",
                                "intensity": "1752.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "25",
                                "monoisotopic_mass": "6927.2657",
                                "monoisotopic_mz": "1155.5516",
                                "intensity": "978.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "26",
                                "monoisotopic_mass": "5456.8617",
                                "monoisotopic_mz": "1092.3796",
                                "intensity": "1050.46",
                                "charge": "5"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "27",
                                "monoisotopic_mass": "5502.7049",
                                "monoisotopic_mz": "1101.5483",
                                "intensity": "1431.55",
                                "charge": "5"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "28",
                                "monoisotopic_mass": "1798.7348",
                                "monoisotopic_mz": "900.3747",
                                "intensity": "1291.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "29",
                                "monoisotopic_mass": "6228.0466",
                                "monoisotopic_mz": "1039.0150",
                                "intensity": "1086.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "30",
                                "monoisotopic_mass": "1979.3259",
                                "monoisotopic_mz": "990.6702",
                                "intensity": "1393.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "31",
                                "monoisotopic_mass": "1084.4655",
                                "monoisotopic_mz": "1085.4728",
                                "intensity": "734.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "32",
                                "monoisotopic_mass": "1208.6235",
                                "monoisotopic_mz": "1209.6307",
                                "intensity": "1034.48",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "33",
                                "monoisotopic_mass": "2136.6803",
                                "monoisotopic_mz": "1069.3474",
                                "intensity": "1000.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "34",
                                "monoisotopic_mass": "5981.5230",
                                "monoisotopic_mz": "997.9278",
                                "intensity": "2293.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "35",
                                "monoisotopic_mass": "1157.5668",
                                "monoisotopic_mz": "1158.5741",
                                "intensity": "678.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "36",
                                "monoisotopic_mass": "3639.8891",
                                "monoisotopic_mz": "1214.3037",
                                "intensity": "1711.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "37",
                                "monoisotopic_mass": "1066.6371",
                                "monoisotopic_mz": "1067.6444",
                                "intensity": "733.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "38",
                                "monoisotopic_mass": "1296.6507",
                                "monoisotopic_mz": "1297.6580",
                                "intensity": "578.59",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "39",
                                "monoisotopic_mass": "1190.5885",
                                "monoisotopic_mz": "1191.5958",
                                "intensity": "832.12",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "40",
                                "monoisotopic_mass": "1249.0949",
                                "monoisotopic_mz": "1250.1022",
                                "intensity": "1095.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "25",
                                "peak_id": "41",
                                "monoisotopic_mass": "966.5038",
                                "monoisotopic_mz": "967.5111",
                                "intensity": "1200.79",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5148",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "25",
                                            "peak_id": "8",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "25",
                                            "peak_id": "11",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "28",
                                        "ion_display_position": "28",
                                        "spec_id": "25",
                                        "peak_id": "2",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "25",
                                        "peak_id": "7",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "25",
                                        "peak_id": "4",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "25",
                                        "peak_id": "0",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "25",
                                        "peak_id": "17",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "25",
                                        "peak_id": "10",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "25",
                                        "peak_id": "9",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "7",
                                        "spec_id": "25",
                                        "peak_id": "15",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "55",
                            "anno": "397.3344",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "55",
                "p_value": "1.51e-06",
                "e_value": "1.51e-06",
                "fdr": "0",
                "matched_fragment_number": "8",
                "matched_peak_number": "9",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "79",
                        "ms1_scans": "152",
                        "ids": "72",
                        "scans": "153",
                        "precursor_mono_mass": "8900.2361",
                        "precursor_charge": "9",
                        "precursor_mz": "989.9224",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "72",
                                "peak_id": "0",
                                "monoisotopic_mass": "2893.5500",
                                "monoisotopic_mz": "724.3948",
                                "intensity": "6383.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "1",
                                "monoisotopic_mass": "3518.8011",
                                "monoisotopic_mz": "1173.9410",
                                "intensity": "8066.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "2",
                                "monoisotopic_mass": "3519.7950",
                                "monoisotopic_mz": "880.9560",
                                "intensity": "6405.03",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "3",
                                "monoisotopic_mass": "3534.7972",
                                "monoisotopic_mz": "884.7066",
                                "intensity": "5176.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "4",
                                "monoisotopic_mass": "916.4035",
                                "monoisotopic_mz": "917.4108",
                                "intensity": "4964.38",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "5",
                                "monoisotopic_mass": "3619.8439",
                                "monoisotopic_mz": "1207.6219",
                                "intensity": "3800.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "6",
                                "monoisotopic_mass": "6940.5746",
                                "monoisotopic_mz": "1157.7697",
                                "intensity": "4570.09",
                                "charge": "6"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "7",
                                "monoisotopic_mass": "3634.8404",
                                "monoisotopic_mz": "909.7174",
                                "intensity": "3140.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "8",
                                "monoisotopic_mass": "3619.8414",
                                "monoisotopic_mz": "905.9676",
                                "intensity": "5147.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "9",
                                "monoisotopic_mass": "3225.7170",
                                "monoisotopic_mz": "1076.2463",
                                "intensity": "2894.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "10",
                                "monoisotopic_mass": "3890.9992",
                                "monoisotopic_mz": "1298.0070",
                                "intensity": "5098.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "11",
                                "monoisotopic_mass": "2893.5494",
                                "monoisotopic_mz": "965.5237",
                                "intensity": "3666.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2893.5509",
                                        "ion_position": "26",
                                        "ion_display_position": "26",
                                        "ion_sort_name": "B00026",
                                        "ion_left_position": "26",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "12",
                                "monoisotopic_mass": "3354.7562",
                                "monoisotopic_mz": "1119.2594",
                                "intensity": "2764.78",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "13",
                                "monoisotopic_mass": "1029.4887",
                                "monoisotopic_mz": "1030.4960",
                                "intensity": "2090.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0007",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "14",
                                "monoisotopic_mass": "2962.5756",
                                "monoisotopic_mz": "988.5325",
                                "intensity": "4670.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "15",
                                "monoisotopic_mass": "2512.2074",
                                "monoisotopic_mz": "1257.1110",
                                "intensity": "4848.58",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "16",
                                "monoisotopic_mass": "2580.2896",
                                "monoisotopic_mz": "1291.1521",
                                "intensity": "2656.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "17",
                                "monoisotopic_mass": "2394.3131",
                                "monoisotopic_mz": "799.1116",
                                "intensity": "1785.52",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2394.3118",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "ion_sort_name": "B00021",
                                        "ion_left_position": "21",
                                        "mass_error": "0.0012",
                                        "ppm": "0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "18",
                                "monoisotopic_mass": "2493.3815",
                                "monoisotopic_mz": "832.1345",
                                "intensity": "2622.00",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2493.3803",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0013",
                                        "ppm": "0.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "19",
                                "monoisotopic_mass": "2560.2026",
                                "monoisotopic_mz": "854.4081",
                                "intensity": "3385.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "20",
                                "monoisotopic_mass": "2979.5780",
                                "monoisotopic_mz": "994.1999",
                                "intensity": "2145.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "21",
                                "monoisotopic_mass": "2294.1335",
                                "monoisotopic_mz": "1148.0740",
                                "intensity": "2408.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "22",
                                "monoisotopic_mass": "525.2292",
                                "monoisotopic_mz": "526.2364",
                                "intensity": "1755.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "23",
                                "monoisotopic_mass": "2313.5163",
                                "monoisotopic_mz": "1157.7654",
                                "intensity": "3212.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "24",
                                "monoisotopic_mass": "974.2488",
                                "monoisotopic_mz": "975.2560",
                                "intensity": "1033.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "25",
                                "monoisotopic_mass": "7490.7450",
                                "monoisotopic_mz": "1071.1137",
                                "intensity": "2255.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "26",
                                "monoisotopic_mass": "5628.2385",
                                "monoisotopic_mz": "1126.6550",
                                "intensity": "1021.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "27",
                                "monoisotopic_mass": "1078.4721",
                                "monoisotopic_mz": "1079.4794",
                                "intensity": "1235.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "28",
                                "monoisotopic_mass": "1100.5249",
                                "monoisotopic_mz": "1101.5322",
                                "intensity": "1706.10",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "29",
                                "monoisotopic_mass": "1156.9292",
                                "monoisotopic_mz": "1157.9365",
                                "intensity": "671.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "30",
                                "monoisotopic_mass": "1012.3647",
                                "monoisotopic_mz": "1013.3719",
                                "intensity": "1050.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "31",
                                "monoisotopic_mass": "6531.5665",
                                "monoisotopic_mz": "1089.6017",
                                "intensity": "2496.34",
                                "charge": "6"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "32",
                                "monoisotopic_mass": "7822.3067",
                                "monoisotopic_mz": "1118.4797",
                                "intensity": "1214.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "33",
                                "monoisotopic_mass": "1234.3973",
                                "monoisotopic_mz": "1235.4045",
                                "intensity": "1190.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "34",
                                "monoisotopic_mass": "1124.6725",
                                "monoisotopic_mz": "1125.6798",
                                "intensity": "713.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "35",
                                "monoisotopic_mass": "5701.4262",
                                "monoisotopic_mz": "1141.2925",
                                "intensity": "1806.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "72",
                                "peak_id": "36",
                                "monoisotopic_mass": "8403.4134",
                                "monoisotopic_mz": "934.7199",
                                "intensity": "1424.18",
                                "charge": "9"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5011",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "1",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "21",
                                        "ion_display_position": "21",
                                        "spec_id": "72",
                                        "peak_id": "17",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "72",
                                        "peak_id": "18",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "72",
                                            "peak_id": "11",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "26",
                                            "ion_display_position": "26",
                                            "spec_id": "72",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "23",
                                        "spec_id": "72",
                                        "peak_id": "15",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "10",
                                        "spec_id": "72",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "9",
                                        "spec_id": "72",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "8",
                                        "spec_id": "72",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "72",
                                        "ion_display_position": "5",
                                        "spec_id": "72",
                                        "peak_id": "22",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "27",
                            "right_position": "55",
                            "anno": "397.3207",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "80",
                "p_value": "3.90e-05",
                "e_value": "3.90e-05",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "90",
                        "ms1_scans": "200",
                        "ids": "109",
                        "scans": "201",
                        "precursor_mono_mass": "8900.2511",
                        "precursor_charge": "6",
                        "precursor_mz": "1484.3825",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "109",
                                "peak_id": "0",
                                "monoisotopic_mass": "916.4031",
                                "monoisotopic_mz": "917.4104",
                                "intensity": "5470.98",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "1",
                                "monoisotopic_mass": "2512.2067",
                                "monoisotopic_mz": "1257.1106",
                                "intensity": "6034.38",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2512.2082",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "ion_sort_name": "Y00023",
                                        "ion_left_position": "55",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "2",
                                "monoisotopic_mass": "1029.4876",
                                "monoisotopic_mz": "1030.4949",
                                "intensity": "4027.07",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "3",
                                "monoisotopic_mass": "1100.5263",
                                "monoisotopic_mz": "1101.5336",
                                "intensity": "3426.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0012",
                                        "ppm": "1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "4",
                                "monoisotopic_mass": "1171.5623",
                                "monoisotopic_mz": "1172.5696",
                                "intensity": "2107.13",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "67",
                                        "mass_error": "0.0001",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "5",
                                "monoisotopic_mass": "2495.1886",
                                "monoisotopic_mz": "1248.6016",
                                "intensity": "965.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "6",
                                "monoisotopic_mass": "801.3763",
                                "monoisotopic_mz": "802.3836",
                                "intensity": "2943.04",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.82"
                                    }
                                }
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "7",
                                "monoisotopic_mass": "5971.9596",
                                "monoisotopic_mz": "1991.6605",
                                "intensity": "988.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "8",
                                "monoisotopic_mass": "1313.1452",
                                "monoisotopic_mz": "1314.1525",
                                "intensity": "900.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "109",
                                "peak_id": "9",
                                "monoisotopic_mass": "1282.6113",
                                "monoisotopic_mz": "1283.6186",
                                "intensity": "776.54",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5161",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "0",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "55",
                                        "ion_display_position": "23",
                                        "spec_id": "109",
                                        "peak_id": "1",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "spec_id": "109",
                                        "peak_id": "4",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "spec_id": "109",
                                        "peak_id": "3",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "spec_id": "109",
                                        "peak_id": "2",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "spec_id": "109",
                                        "peak_id": "0",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "spec_id": "109",
                                        "peak_id": "6",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "mass_shift": {
                            "id": "0",
                            "left_position": "0",
                            "right_position": "55",
                            "anno": "266.2953",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "111",
                "p_value": "7.39e-05",
                "e_value": "7.39e-05",
                "fdr": "0",
                "matched_fragment_number": "6",
                "matched_peak_number": "6",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "103",
                        "ms1_scans": "254",
                        "ids": "153",
                        "scans": "258",
                        "precursor_mono_mass": "8900.2607",
                        "precursor_charge": "6",
                        "precursor_mz": "1484.3841",
                        "feature_inte": "1.0800e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "153",
                                "peak_id": "0",
                                "monoisotopic_mass": "916.4039",
                                "monoisotopic_mz": "917.4111",
                                "intensity": "6256.50",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "916.4039",
                                        "ion_position": "70",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "70",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "1",
                                "monoisotopic_mass": "2511.2051",
                                "monoisotopic_mz": "1256.6098",
                                "intensity": "5926.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "2",
                                "monoisotopic_mass": "1029.4867",
                                "monoisotopic_mz": "1030.4940",
                                "intensity": "4885.54",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1029.4880",
                                        "ion_position": "69",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0013",
                                        "ppm": "-1.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "3",
                                "monoisotopic_mass": "1100.5240",
                                "monoisotopic_mz": "1101.5312",
                                "intensity": "3249.65",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1100.5251",
                                        "ion_position": "68",
                                        "ion_display_position": "10",
                                        "ion_sort_name": "Y00010",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0011",
                                        "ppm": "-1.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "4",
                                "monoisotopic_mass": "1171.5611",
                                "monoisotopic_mz": "1172.5684",
                                "intensity": "2096.83",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1171.5622",
                                        "ion_position": "67",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "Y00011",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "5",
                                "monoisotopic_mass": "801.3766",
                                "monoisotopic_mz": "802.3839",
                                "intensity": "4576.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "801.3770",
                                        "ion_position": "71",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "6",
                                "monoisotopic_mass": "525.2294",
                                "monoisotopic_mz": "526.2366",
                                "intensity": "3750.45",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "525.2296",
                                        "ion_position": "73",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "7",
                                "monoisotopic_mass": "1212.5867",
                                "monoisotopic_mz": "1213.5940",
                                "intensity": "1158.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "8",
                                "monoisotopic_mass": "1484.6148",
                                "monoisotopic_mz": "1485.6221",
                                "intensity": "611.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "9",
                                "monoisotopic_mass": "1282.5934",
                                "monoisotopic_mz": "1283.6007",
                                "intensity": "1561.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "10",
                                "monoisotopic_mass": "3584.8741",
                                "monoisotopic_mz": "1195.9653",
                                "intensity": "1249.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "153",
                                "peak_id": "11",
                                "monoisotopic_mass": "1247.5895",
                                "monoisotopic_mz": "1248.5968",
                                "intensity": "647.43",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "1",
                    "proteoform_id": "1",
                    "sequence_name": "sp|P0A6A8|ACP_ECOLI",
                    "sequence_description": "Acyl carrier protein OS=Escherichia coli (strain K12) OX=83333 GN=acpP PE=1 SV=2",
                    "proteoform_mass": "8900.5256",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "78",
                        "first_residue_position": "0",
                        "last_residue_position": "77",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "S"
                            },
                            {
                                "position": "2",
                                "acid": "T"
                            },
                            {
                                "position": "3",
                                "acid": "I"
                            },
                            {
                                "position": "4",
                                "acid": "E"
                            },
                            {
                                "position": "5",
                                "acid": "E"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "V"
                            },
                            {
                                "position": "8",
                                "acid": "K"
                            },
                            {
                                "position": "9",
                                "acid": "K"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "I"
                            },
                            {
                                "position": "12",
                                "acid": "G"
                            },
                            {
                                "position": "13",
                                "acid": "E"
                            },
                            {
                                "position": "14",
                                "acid": "Q"
                            },
                            {
                                "position": "15",
                                "acid": "L"
                            },
                            {
                                "position": "16",
                                "acid": "G"
                            },
                            {
                                "position": "17",
                                "acid": "V"
                            },
                            {
                                "position": "18",
                                "acid": "K"
                            },
                            {
                                "position": "19",
                                "acid": "Q"
                            },
                            {
                                "position": "20",
                                "acid": "E"
                            },
                            {
                                "position": "21",
                                "acid": "E"
                            },
                            {
                                "position": "22",
                                "acid": "V"
                            },
                            {
                                "position": "23",
                                "acid": "T"
                            },
                            {
                                "position": "24",
                                "acid": "N"
                            },
                            {
                                "position": "25",
                                "acid": "N"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "S"
                            },
                            {
                                "position": "28",
                                "acid": "F"
                            },
                            {
                                "position": "29",
                                "acid": "V"
                            },
                            {
                                "position": "30",
                                "acid": "E"
                            },
                            {
                                "position": "31",
                                "acid": "D"
                            },
                            {
                                "position": "32",
                                "acid": "L"
                            },
                            {
                                "position": "33",
                                "acid": "G"
                            },
                            {
                                "position": "34",
                                "acid": "A"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "S"
                            },
                            {
                                "position": "37",
                                "acid": "L"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "T"
                            },
                            {
                                "position": "40",
                                "acid": "V"
                            },
                            {
                                "position": "41",
                                "acid": "E"
                            },
                            {
                                "position": "42",
                                "acid": "L"
                            },
                            {
                                "position": "43",
                                "acid": "V"
                            },
                            {
                                "position": "44",
                                "acid": "M"
                            },
                            {
                                "position": "45",
                                "acid": "A"
                            },
                            {
                                "position": "46",
                                "acid": "L"
                            },
                            {
                                "position": "47",
                                "acid": "E"
                            },
                            {
                                "position": "48",
                                "acid": "E"
                            },
                            {
                                "position": "49",
                                "acid": "E"
                            },
                            {
                                "position": "50",
                                "acid": "F"
                            },
                            {
                                "position": "51",
                                "acid": "D"
                            },
                            {
                                "position": "52",
                                "acid": "T"
                            },
                            {
                                "position": "53",
                                "acid": "E"
                            },
                            {
                                "position": "54",
                                "acid": "I"
                            },
                            {
                                "position": "55",
                                "acid": "P"
                            },
                            {
                                "position": "56",
                                "acid": "D"
                            },
                            {
                                "position": "57",
                                "acid": "E"
                            },
                            {
                                "position": "58",
                                "acid": "E"
                            },
                            {
                                "position": "59",
                                "acid": "A"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "I"
                            },
                            {
                                "position": "63",
                                "acid": "T"
                            },
                            {
                                "position": "64",
                                "acid": "T"
                            },
                            {
                                "position": "65",
                                "acid": "V"
                            },
                            {
                                "position": "66",
                                "acid": "Q"
                            },
                            {
                                "position": "67",
                                "acid": "A"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "I"
                            },
                            {
                                "position": "70",
                                "acid": "D"
                            },
                            {
                                "position": "71",
                                "acid": "Y"
                            },
                            {
                                "position": "72",
                                "acid": "I"
                            },
                            {
                                "position": "73",
                                "acid": "N"
                            },
                            {
                                "position": "74",
                                "acid": "G"
                            },
                            {
                                "position": "75",
                                "acid": "H"
                            },
                            {
                                "position": "76",
                                "acid": "Q"
                            },
                            {
                                "position": "77",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
   