prsm_data =
{
    "prsm": {
        "prsm_id": "90",
        "p_value": "1.16e-04",
        "e_value": "1.16e-04",
        "fdr": "0",
        "matched_fragment_number": "12",
        "matched_peak_number": "13",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "95",
                "ms1_scans": "220",
                "ids": "125",
                "scans": "222",
                "precursor_mono_mass": "15921.2115",
                "precursor_charge": "18",
                "precursor_mz": "885.5190",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "125",
                        "peak_id": "0",
                        "monoisotopic_mass": "7544.8881",
                        "monoisotopic_mz": "1078.8484",
                        "intensity": "10872.68",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7544.8818",
                                "ion_position": "80",
                                "ion_display_position": "69",
                                "ion_sort_name": "Y00069",
                                "ion_left_position": "80",
                                "mass_error": "0.0063",
                                "ppm": "0.84"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "1",
                        "monoisotopic_mass": "4360.2157",
                        "monoisotopic_mz": "873.0504",
                        "intensity": "10266.44",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "2",
                        "monoisotopic_mass": "6429.3346",
                        "monoisotopic_mz": "919.4836",
                        "intensity": "11804.13",
                        "charge": "7",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6428.2499",
                                    "ion_position": "59",
                                    "ion_display_position": "59",
                                    "ion_sort_name": "B00059",
                                    "ion_left_position": "59",
                                    "mass_error": "0.0823",
                                    "ppm": "12.80"
                                },
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "6429.3359",
                                    "ion_position": "91",
                                    "ion_display_position": "58",
                                    "ion_sort_name": "Y00058",
                                    "ion_left_position": "91",
                                    "mass_error": "-0.0013",
                                    "ppm": "-0.21"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "3",
                        "monoisotopic_mass": "6429.3510",
                        "monoisotopic_mz": "1072.5658",
                        "intensity": "12574.02",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6429.3359",
                                "ion_position": "91",
                                "ion_display_position": "58",
                                "ion_sort_name": "Y00058",
                                "ion_left_position": "91",
                                "mass_error": "0.0150",
                                "ppm": "2.34"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "4",
                        "monoisotopic_mass": "7991.1209",
                        "monoisotopic_mz": "888.9096",
                        "intensity": "7030.45",
                        "charge": "9"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "5",
                        "monoisotopic_mass": "7472.8134",
                        "monoisotopic_mz": "1068.5521",
                        "intensity": "10017.92",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7473.8447",
                                "ion_position": "81",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "81",
                                "mass_error": "-0.0289",
                                "ppm": "-3.87"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "6",
                        "monoisotopic_mass": "6160.1823",
                        "monoisotopic_mz": "1027.7043",
                        "intensity": "5009.49",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6160.1984",
                                "ion_position": "94",
                                "ion_display_position": "55",
                                "ion_sort_name": "Y00055",
                                "ion_left_position": "94",
                                "mass_error": "-0.0161",
                                "ppm": "-2.61"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "7",
                        "monoisotopic_mass": "2180.1055",
                        "monoisotopic_mz": "1091.0600",
                        "intensity": "3428.75",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "8",
                        "monoisotopic_mass": "1136.6197",
                        "monoisotopic_mz": "1137.6270",
                        "intensity": "5746.39",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "139",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "139",
                                "mass_error": "0.0007",
                                "ppm": "0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "9",
                        "monoisotopic_mass": "6411.3118",
                        "monoisotopic_mz": "1069.5592",
                        "intensity": "6059.17",
                        "charge": "6"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "10",
                        "monoisotopic_mass": "8009.1455",
                        "monoisotopic_mz": "890.9123",
                        "intensity": "3538.40",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8009.1273",
                                "ion_position": "74",
                                "ion_display_position": "74",
                                "ion_sort_name": "B00074",
                                "ion_left_position": "74",
                                "mass_error": "0.0182",
                                "ppm": "2.27"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "11",
                        "monoisotopic_mass": "7285.7264",
                        "monoisotopic_mz": "1041.8253",
                        "intensity": "4354.75",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "12",
                        "monoisotopic_mass": "2657.3499",
                        "monoisotopic_mz": "886.7906",
                        "intensity": "2110.27",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "13",
                        "monoisotopic_mass": "1063.5481",
                        "monoisotopic_mz": "1064.5554",
                        "intensity": "1881.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "14",
                        "monoisotopic_mass": "3130.6237",
                        "monoisotopic_mz": "1044.5485",
                        "intensity": "3851.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "15",
                        "monoisotopic_mass": "6267.9928",
                        "monoisotopic_mz": "896.4348",
                        "intensity": "1506.85",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "16",
                        "monoisotopic_mass": "2005.3097",
                        "monoisotopic_mz": "1003.6621",
                        "intensity": "1959.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "17",
                        "monoisotopic_mass": "5233.7127",
                        "monoisotopic_mz": "1047.7498",
                        "intensity": "1133.76",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "18",
                        "monoisotopic_mass": "1719.8630",
                        "monoisotopic_mz": "860.9388",
                        "intensity": "2172.08",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "19",
                        "monoisotopic_mass": "4273.2188",
                        "monoisotopic_mz": "1069.3120",
                        "intensity": "946.73",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "20",
                        "monoisotopic_mass": "1959.0198",
                        "monoisotopic_mz": "980.5172",
                        "intensity": "2023.05",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "21",
                        "monoisotopic_mass": "3761.9077",
                        "monoisotopic_mz": "941.4842",
                        "intensity": "1000.94",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "22",
                        "monoisotopic_mass": "4191.1177",
                        "monoisotopic_mz": "839.2308",
                        "intensity": "2862.19",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "23",
                        "monoisotopic_mass": "6584.9789",
                        "monoisotopic_mz": "941.7185",
                        "intensity": "3326.39",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "24",
                        "monoisotopic_mass": "4571.2917",
                        "monoisotopic_mz": "915.2656",
                        "intensity": "1865.54",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "25",
                        "monoisotopic_mass": "967.8404",
                        "monoisotopic_mz": "968.8477",
                        "intensity": "1179.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "26",
                        "monoisotopic_mass": "6089.1144",
                        "monoisotopic_mz": "1015.8597",
                        "intensity": "3358.87",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6089.1613",
                                "ion_position": "95",
                                "ion_display_position": "54",
                                "ion_sort_name": "Y00054",
                                "ion_left_position": "95",
                                "mass_error": "-0.0469",
                                "ppm": "-7.70"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "27",
                        "monoisotopic_mass": "13611.5394",
                        "monoisotopic_mz": "908.4432",
                        "intensity": "987.25",
                        "charge": "15",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "-173.6085470509",
                                "theoretical_mass": "13612.4412",
                                "ion_position": "129",
                                "ion_display_position": "129",
                                "ion_sort_name": "B00129",
                                "ion_left_position": "129",
                                "mass_error": "0.1005",
                                "ppm": "7.38"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "28",
                        "monoisotopic_mass": "11884.8605",
                        "monoisotopic_mz": "991.4123",
                        "intensity": "975.45",
                        "charge": "12"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "29",
                        "monoisotopic_mass": "8343.3808",
                        "monoisotopic_mz": "928.0496",
                        "intensity": "1249.65",
                        "charge": "9"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "30",
                        "monoisotopic_mass": "13025.5496",
                        "monoisotopic_mz": "1002.9726",
                        "intensity": "1350.19",
                        "charge": "13"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "31",
                        "monoisotopic_mass": "6520.3143",
                        "monoisotopic_mz": "1087.7263",
                        "intensity": "1093.24",
                        "charge": "6"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "32",
                        "monoisotopic_mass": "918.2201",
                        "monoisotopic_mz": "919.2274",
                        "intensity": "1075.46",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "33",
                        "monoisotopic_mass": "755.4175",
                        "monoisotopic_mz": "756.4248",
                        "intensity": "3083.80",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "143",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "143",
                                "mass_error": "-0.0003",
                                "ppm": "-0.34"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "34",
                        "monoisotopic_mass": "5385.7080",
                        "monoisotopic_mz": "1078.1489",
                        "intensity": "3457.48",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5386.7045",
                                "ion_position": "48",
                                "ion_display_position": "48",
                                "ion_sort_name": "B00048",
                                "ion_left_position": "48",
                                "mass_error": "0.0059",
                                "ppm": "1.10"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "35",
                        "monoisotopic_mass": "7620.6056",
                        "monoisotopic_mz": "953.5830",
                        "intensity": "1466.04",
                        "charge": "8"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "36",
                        "monoisotopic_mass": "4973.6337",
                        "monoisotopic_mz": "995.7340",
                        "intensity": "2364.15",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "37",
                        "monoisotopic_mass": "6868.4528",
                        "monoisotopic_mz": "982.2148",
                        "intensity": "1135.49",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "38",
                        "monoisotopic_mass": "936.9815",
                        "monoisotopic_mz": "937.9888",
                        "intensity": "1389.37",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "39",
                        "monoisotopic_mass": "7590.3103",
                        "monoisotopic_mz": "1085.3373",
                        "intensity": "1413.43",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "40",
                        "monoisotopic_mass": "8701.7346",
                        "monoisotopic_mz": "871.1807",
                        "intensity": "1017.58",
                        "charge": "10"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "41",
                        "monoisotopic_mass": "1022.5115",
                        "monoisotopic_mz": "1023.5188",
                        "intensity": "1174.65",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "42",
                        "monoisotopic_mass": "980.6370",
                        "monoisotopic_mz": "981.6443",
                        "intensity": "1068.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "43",
                        "monoisotopic_mass": "12526.5019",
                        "monoisotopic_mz": "1044.8824",
                        "intensity": "1182.94",
                        "charge": "12"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "44",
                        "monoisotopic_mass": "7306.5589",
                        "monoisotopic_mz": "1044.8014",
                        "intensity": "2334.76",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "45",
                        "monoisotopic_mass": "3262.1667",
                        "monoisotopic_mz": "1088.3962",
                        "intensity": "1097.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "46",
                        "monoisotopic_mass": "6505.2979",
                        "monoisotopic_mz": "930.3355",
                        "intensity": "2164.39",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "47",
                        "monoisotopic_mass": "11507.9375",
                        "monoisotopic_mz": "886.2332",
                        "intensity": "1211.88",
                        "charge": "13"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "48",
                        "monoisotopic_mass": "824.2108",
                        "monoisotopic_mz": "825.2181",
                        "intensity": "1374.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "49",
                        "monoisotopic_mass": "2096.0667",
                        "monoisotopic_mz": "1049.0406",
                        "intensity": "855.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "50",
                        "monoisotopic_mass": "3031.7125",
                        "monoisotopic_mz": "1011.5781",
                        "intensity": "3299.91",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "51",
                        "monoisotopic_mass": "1767.8872",
                        "monoisotopic_mz": "884.9509",
                        "intensity": "4108.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "52",
                        "monoisotopic_mass": "15819.6453",
                        "monoisotopic_mz": "931.5746",
                        "intensity": "1397.30",
                        "charge": "17"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "53",
                        "monoisotopic_mass": "9614.6076",
                        "monoisotopic_mz": "962.4680",
                        "intensity": "1431.05",
                        "charge": "10"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "54",
                        "monoisotopic_mass": "3303.6518",
                        "monoisotopic_mz": "1102.2246",
                        "intensity": "2926.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "55",
                        "monoisotopic_mass": "1136.6185",
                        "monoisotopic_mz": "569.3165",
                        "intensity": "1926.08",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "139",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "139",
                                "mass_error": "-0.0005",
                                "ppm": "-0.45"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "56",
                        "monoisotopic_mass": "1842.9498",
                        "monoisotopic_mz": "922.4822",
                        "intensity": "1478.48",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "57",
                        "monoisotopic_mass": "1155.1243",
                        "monoisotopic_mz": "1156.1316",
                        "intensity": "1980.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "58",
                        "monoisotopic_mass": "3603.8482",
                        "monoisotopic_mz": "901.9693",
                        "intensity": "1166.09",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "59",
                        "monoisotopic_mass": "5491.5160",
                        "monoisotopic_mz": "916.2599",
                        "intensity": "1800.32",
                        "charge": "6"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "60",
                        "monoisotopic_mass": "1036.5325",
                        "monoisotopic_mz": "1037.5398",
                        "intensity": "1421.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "61",
                        "monoisotopic_mass": "11484.1108",
                        "monoisotopic_mz": "884.4004",
                        "intensity": "1315.83",
                        "charge": "13"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "62",
                        "monoisotopic_mass": "6230.4490",
                        "monoisotopic_mz": "891.0714",
                        "intensity": "2411.65",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "63",
                        "monoisotopic_mass": "4200.8721",
                        "monoisotopic_mz": "1051.2253",
                        "intensity": "2183.69",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "64",
                        "monoisotopic_mass": "15045.8355",
                        "monoisotopic_mz": "1004.0630",
                        "intensity": "1129.20",
                        "charge": "15"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "65",
                        "monoisotopic_mass": "1104.5574",
                        "monoisotopic_mz": "1105.5647",
                        "intensity": "845.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "66",
                        "monoisotopic_mass": "4637.9797",
                        "monoisotopic_mz": "928.6032",
                        "intensity": "4227.94",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "67",
                        "monoisotopic_mass": "4358.6097",
                        "monoisotopic_mz": "1090.6597",
                        "intensity": "2668.98",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "68",
                        "monoisotopic_mass": "3517.5335",
                        "monoisotopic_mz": "880.3907",
                        "intensity": "1272.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "69",
                        "monoisotopic_mass": "5870.9138",
                        "monoisotopic_mz": "839.7092",
                        "intensity": "3047.48",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5870.9326",
                                "ion_position": "53",
                                "ion_display_position": "53",
                                "ion_sort_name": "B00053",
                                "ion_left_position": "53",
                                "mass_error": "-0.0189",
                                "ppm": "-3.21"
                            }
                        }
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "70",
                        "monoisotopic_mass": "7660.7491",
                        "monoisotopic_mz": "958.6009",
                        "intensity": "1388.01",
                        "charge": "8"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "71",
                        "monoisotopic_mass": "1899.9950",
                        "monoisotopic_mz": "951.0048",
                        "intensity": "2025.97",
                        "charge": "2"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "72",
                        "monoisotopic_mass": "4687.1731",
                        "monoisotopic_mz": "938.4419",
                        "intensity": "2592.29",
                        "charge": "5"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "73",
                        "monoisotopic_mass": "6450.7538",
                        "monoisotopic_mz": "922.5435",
                        "intensity": "1327.04",
                        "charge": "7"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "74",
                        "monoisotopic_mass": "4104.0489",
                        "monoisotopic_mz": "1027.0195",
                        "intensity": "1520.01",
                        "charge": "4"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "75",
                        "monoisotopic_mass": "1185.7972",
                        "monoisotopic_mz": "1186.8044",
                        "intensity": "1209.94",
                        "charge": "1"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "76",
                        "monoisotopic_mass": "2885.1137",
                        "monoisotopic_mz": "962.7118",
                        "intensity": "1365.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "125",
                        "peak_id": "77",
                        "monoisotopic_mass": "1994.0446",
                        "monoisotopic_mz": "998.0296",
                        "intensity": "1443.36",
                        "charge": "2"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15921.6865",
            "n_acetylation": "1",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "0",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "48",
                                "ion_display_position": "48",
                                "spec_id": "125",
                                "peak_id": "34",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "53",
                                "ion_display_position": "53",
                                "spec_id": "125",
                                "peak_id": "69",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "59",
                                "ion_display_position": "59",
                                "spec_id": "125",
                                "peak_id": "2",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "74",
                                "ion_display_position": "74",
                                "spec_id": "125",
                                "peak_id": "10",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "80",
                                "ion_display_position": "69",
                                "spec_id": "125",
                                "peak_id": "0",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "81",
                                "ion_display_position": "68",
                                "spec_id": "125",
                                "peak_id": "5",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "91",
                                    "ion_display_position": "58",
                                    "spec_id": "125",
                                    "peak_id": "2",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "91",
                                    "ion_display_position": "58",
                                    "spec_id": "125",
                                    "peak_id": "3",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "94",
                                "ion_display_position": "55",
                                "spec_id": "125",
                                "peak_id": "6",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "95",
                                "ion_display_position": "54",
                                "spec_id": "125",
                                "peak_id": "26",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "129",
                                "ion_display_position": "129",
                                "spec_id": "125",
                                "peak_id": "27",
                                "peak_charge": "15"
                            }
                        }
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "139",
                                    "ion_display_position": "10",
                                    "spec_id": "125",
                                    "peak_id": "55",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "139",
                                    "ion_display_position": "10",
                                    "spec_id": "125",
                                    "peak_id": "8",
                                    "peak_charge": "1"
                                }
                            ]
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "143",
                                "ion_display_position": "6",
                                "spec_id": "125",
                                "peak_id": "33",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Protein variable",
                    "ptm": {
                        "abbreviation": "Acetyl",
                        "unimod": "1",
                        "mono_mass": "42.0105650000"
                    },
                    "occurence": {
                        "left_pos": "0",
                        "right_pos": "1",
                        "anno": "M"
                    }
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "74",
                    "right_position": "80",
                    "anno": "-173.6085",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
