prsm_data =
{
    "prsm": {
        "prsm_id": "89",
        "p_value": "0.04",
        "e_value": "0.04",
        "fdr": "4.41e-03",
        "matched_fragment_number": "9",
        "matched_peak_number": "9",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "95",
                "ms1_scans": "220",
                "ids": "124",
                "scans": "221",
                "precursor_mono_mass": "9173.4087",
                "precursor_charge": "10",
                "precursor_mz": "918.3481",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "124",
                        "peak_id": "0",
                        "monoisotopic_mass": "6913.4837",
                        "monoisotopic_mz": "988.6478",
                        "intensity": "9104.00",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "1",
                        "monoisotopic_mass": "3121.6027",
                        "monoisotopic_mz": "1561.8086",
                        "intensity": "6891.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "2",
                        "monoisotopic_mass": "6913.4845",
                        "monoisotopic_mz": "1153.2547",
                        "intensity": "9028.26",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "3",
                        "monoisotopic_mass": "3921.9437",
                        "monoisotopic_mz": "1308.3218",
                        "intensity": "5741.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "4",
                        "monoisotopic_mass": "720.3443",
                        "monoisotopic_mz": "721.3516",
                        "intensity": "7593.14",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "5",
                        "monoisotopic_mass": "7799.8301",
                        "monoisotopic_mz": "1115.2687",
                        "intensity": "4898.94",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "6",
                        "monoisotopic_mass": "3463.7967",
                        "monoisotopic_mz": "1155.6062",
                        "intensity": "6747.59",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3463.7922",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "50",
                                "mass_error": "0.0044",
                                "ppm": "1.28"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "7",
                        "monoisotopic_mass": "3008.5131",
                        "monoisotopic_mz": "1505.2638",
                        "intensity": "4957.63",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "8",
                        "monoisotopic_mass": "3007.5082",
                        "monoisotopic_mz": "1003.5100",
                        "intensity": "5533.15",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "9",
                        "monoisotopic_mass": "8832.2131",
                        "monoisotopic_mz": "1105.0339",
                        "intensity": "10706.23",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0324",
                                "ppm": "-3.67"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "10",
                        "monoisotopic_mass": "4036.0345",
                        "monoisotopic_mz": "1346.3521",
                        "intensity": "5057.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "11",
                        "monoisotopic_mass": "3972.8100",
                        "monoisotopic_mz": "1325.2773",
                        "intensity": "6177.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "12",
                        "monoisotopic_mass": "8812.2240",
                        "monoisotopic_mz": "1102.5353",
                        "intensity": "8590.55",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "13",
                        "monoisotopic_mass": "1364.5322",
                        "monoisotopic_mz": "683.2734",
                        "intensity": "4801.88",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1364.5337",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "ion_sort_name": "B00012",
                                "ion_left_position": "12",
                                "mass_error": "-0.0015",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "14",
                        "monoisotopic_mass": "947.4020",
                        "monoisotopic_mz": "948.4093",
                        "intensity": "4777.10",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "947.4018",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "0.0002",
                                "ppm": "0.19"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "15",
                        "monoisotopic_mass": "821.3919",
                        "monoisotopic_mz": "822.3992",
                        "intensity": "4928.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "16",
                        "monoisotopic_mass": "4019.0234",
                        "monoisotopic_mz": "1005.7631",
                        "intensity": "3756.77",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "17",
                        "monoisotopic_mass": "3792.9481",
                        "monoisotopic_mz": "1265.3233",
                        "intensity": "8229.06",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "18",
                        "monoisotopic_mass": "4777.2028",
                        "monoisotopic_mz": "1195.3080",
                        "intensity": "9927.83",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "19",
                        "monoisotopic_mass": "5944.0191",
                        "monoisotopic_mz": "1189.8111",
                        "intensity": "5242.92",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "20",
                        "monoisotopic_mass": "6288.1668",
                        "monoisotopic_mz": "1258.6406",
                        "intensity": "4392.44",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "21",
                        "monoisotopic_mass": "2608.2685",
                        "monoisotopic_mz": "1305.1415",
                        "intensity": "4927.91",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "22",
                        "monoisotopic_mass": "3954.8045",
                        "monoisotopic_mz": "1319.2754",
                        "intensity": "4752.19",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "23",
                        "monoisotopic_mass": "4018.0151",
                        "monoisotopic_mz": "1340.3456",
                        "intensity": "3923.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "24",
                        "monoisotopic_mass": "2169.0370",
                        "monoisotopic_mz": "1085.5258",
                        "intensity": "3561.90",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "25",
                        "monoisotopic_mass": "6893.4725",
                        "monoisotopic_mz": "1149.9194",
                        "intensity": "6422.38",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "26",
                        "monoisotopic_mass": "5830.9308",
                        "monoisotopic_mz": "972.8291",
                        "intensity": "4209.42",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "27",
                        "monoisotopic_mass": "3122.6125",
                        "monoisotopic_mz": "1041.8781",
                        "intensity": "5252.52",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "28",
                        "monoisotopic_mass": "6258.0024",
                        "monoisotopic_mz": "1044.0077",
                        "intensity": "4296.88",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "29",
                        "monoisotopic_mass": "1107.4323",
                        "monoisotopic_mz": "1108.4396",
                        "intensity": "2683.25",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1107.4325",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "ion_sort_name": "B00010",
                                "ion_left_position": "10",
                                "mass_error": "-0.0002",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "30",
                        "monoisotopic_mass": "8515.0922",
                        "monoisotopic_mz": "1065.3938",
                        "intensity": "3433.42",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8515.1412",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "ion_sort_name": "B00073",
                                "ion_left_position": "73",
                                "mass_error": "-0.0490",
                                "ppm": "-5.75"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "31",
                        "monoisotopic_mass": "2772.3388",
                        "monoisotopic_mz": "1387.1767",
                        "intensity": "2947.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "32",
                        "monoisotopic_mass": "4136.8831",
                        "monoisotopic_mz": "1379.9683",
                        "intensity": "3172.44",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "0.0051",
                                "ppm": "1.23"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "33",
                        "monoisotopic_mass": "3659.8106",
                        "monoisotopic_mz": "1220.9442",
                        "intensity": "4071.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "34",
                        "monoisotopic_mass": "7703.7878",
                        "monoisotopic_mz": "1101.5484",
                        "intensity": "4276.14",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "35",
                        "monoisotopic_mass": "4974.6448",
                        "monoisotopic_mz": "995.9362",
                        "intensity": "1473.51",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "36",
                        "monoisotopic_mass": "8268.1421",
                        "monoisotopic_mz": "1034.5250",
                        "intensity": "2645.29",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "37",
                        "monoisotopic_mass": "1063.0160",
                        "monoisotopic_mz": "1064.0233",
                        "intensity": "2629.14",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "38",
                        "monoisotopic_mass": "2520.2487",
                        "monoisotopic_mz": "1261.1316",
                        "intensity": "3574.22",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "39",
                        "monoisotopic_mass": "2462.2118",
                        "monoisotopic_mz": "1232.1132",
                        "intensity": "3520.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "40",
                        "monoisotopic_mass": "2483.2295",
                        "monoisotopic_mz": "1242.6220",
                        "intensity": "2249.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "41",
                        "monoisotopic_mass": "4579.7367",
                        "monoisotopic_mz": "916.9546",
                        "intensity": "4849.39",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "42",
                        "monoisotopic_mass": "3679.8651",
                        "monoisotopic_mz": "1227.6290",
                        "intensity": "5172.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "43",
                        "monoisotopic_mass": "8627.1316",
                        "monoisotopic_mz": "1079.3987",
                        "intensity": "5817.98",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "44",
                        "monoisotopic_mass": "7092.5267",
                        "monoisotopic_mz": "1014.2254",
                        "intensity": "3614.08",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "45",
                        "monoisotopic_mass": "991.0060",
                        "monoisotopic_mz": "992.0132",
                        "intensity": "2179.86",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "46",
                        "monoisotopic_mass": "3905.9667",
                        "monoisotopic_mz": "1302.9962",
                        "intensity": "3195.07",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "47",
                        "monoisotopic_mass": "934.4761",
                        "monoisotopic_mz": "935.4833",
                        "intensity": "3617.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "48",
                        "monoisotopic_mass": "1194.2986",
                        "monoisotopic_mz": "1195.3059",
                        "intensity": "1993.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "49",
                        "monoisotopic_mass": "3577.8215",
                        "monoisotopic_mz": "1193.6145",
                        "intensity": "3491.38",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "50",
                        "monoisotopic_mass": "1379.3603",
                        "monoisotopic_mz": "1380.3676",
                        "intensity": "2180.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "51",
                        "monoisotopic_mass": "2007.9849",
                        "monoisotopic_mz": "1004.9997",
                        "intensity": "2383.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "52",
                        "monoisotopic_mass": "918.4884",
                        "monoisotopic_mz": "919.4957",
                        "intensity": "5681.47",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "53",
                        "monoisotopic_mass": "1856.9497",
                        "monoisotopic_mz": "929.4821",
                        "intensity": "2336.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "54",
                        "monoisotopic_mass": "8611.1166",
                        "monoisotopic_mz": "1077.3969",
                        "intensity": "1548.52",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "55",
                        "monoisotopic_mass": "771.4122",
                        "monoisotopic_mz": "772.4194",
                        "intensity": "2034.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "56",
                        "monoisotopic_mass": "3093.5709",
                        "monoisotopic_mz": "1032.1976",
                        "intensity": "1497.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "57",
                        "monoisotopic_mass": "2750.2948",
                        "monoisotopic_mz": "917.7722",
                        "intensity": "2943.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "58",
                        "monoisotopic_mass": "1089.3869",
                        "monoisotopic_mz": "1090.3942",
                        "intensity": "2007.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "59",
                        "monoisotopic_mass": "6897.4692",
                        "monoisotopic_mz": "986.3600",
                        "intensity": "3692.73",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "60",
                        "monoisotopic_mass": "1005.4515",
                        "monoisotopic_mz": "1006.4587",
                        "intensity": "2992.40",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "61",
                        "monoisotopic_mass": "7646.7522",
                        "monoisotopic_mz": "1093.4004",
                        "intensity": "4342.47",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "62",
                        "monoisotopic_mass": "5499.8686",
                        "monoisotopic_mz": "1100.9810",
                        "intensity": "1182.67",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "63",
                        "monoisotopic_mass": "4363.0692",
                        "monoisotopic_mz": "1091.7746",
                        "intensity": "2898.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "64",
                        "monoisotopic_mass": "6974.3085",
                        "monoisotopic_mz": "997.3371",
                        "intensity": "3119.54",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "65",
                        "monoisotopic_mass": "960.1577",
                        "monoisotopic_mz": "961.1650",
                        "intensity": "1816.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "66",
                        "monoisotopic_mass": "3103.5732",
                        "monoisotopic_mz": "1552.7939",
                        "intensity": "1427.92",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "67",
                        "monoisotopic_mass": "2247.5277",
                        "monoisotopic_mz": "1124.7711",
                        "intensity": "1924.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "68",
                        "monoisotopic_mass": "3657.3858",
                        "monoisotopic_mz": "915.3537",
                        "intensity": "1013.30",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "69",
                        "monoisotopic_mass": "3506.2860",
                        "monoisotopic_mz": "877.5788",
                        "intensity": "1098.90",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "70",
                        "monoisotopic_mass": "7540.1448",
                        "monoisotopic_mz": "1078.1708",
                        "intensity": "1493.01",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "71",
                        "monoisotopic_mass": "2034.9755",
                        "monoisotopic_mz": "1018.4950",
                        "intensity": "2068.90",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "72",
                        "monoisotopic_mass": "7012.5585",
                        "monoisotopic_mz": "1002.8014",
                        "intensity": "1122.88",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "73",
                        "monoisotopic_mass": "2532.2499",
                        "monoisotopic_mz": "1267.1322",
                        "intensity": "3134.73",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "74",
                        "monoisotopic_mass": "658.3280",
                        "monoisotopic_mz": "659.3353",
                        "intensity": "1824.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "75",
                        "monoisotopic_mass": "621.2754",
                        "monoisotopic_mz": "622.2827",
                        "intensity": "1456.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "76",
                        "monoisotopic_mass": "846.3542",
                        "monoisotopic_mz": "847.3614",
                        "intensity": "3405.09",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "846.3542",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0000",
                                "ppm": "0.00"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "77",
                        "monoisotopic_mass": "1140.4147",
                        "monoisotopic_mz": "1141.4220",
                        "intensity": "1936.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "78",
                        "monoisotopic_mass": "3229.6578",
                        "monoisotopic_mz": "1077.5599",
                        "intensity": "2151.20",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "79",
                        "monoisotopic_mass": "3206.6117",
                        "monoisotopic_mz": "1069.8778",
                        "intensity": "3732.36",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "80",
                        "monoisotopic_mass": "6083.0502",
                        "monoisotopic_mz": "1014.8490",
                        "intensity": "1306.88",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "81",
                        "monoisotopic_mass": "8740.0756",
                        "monoisotopic_mz": "1093.5167",
                        "intensity": "901.91",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "82",
                        "monoisotopic_mass": "4222.7778",
                        "monoisotopic_mz": "1056.7017",
                        "intensity": "3420.45",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "83",
                        "monoisotopic_mass": "1030.8739",
                        "monoisotopic_mz": "1031.8812",
                        "intensity": "1162.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "84",
                        "monoisotopic_mass": "5237.2219",
                        "monoisotopic_mz": "1048.4517",
                        "intensity": "3176.35",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "85",
                        "monoisotopic_mass": "1050.4102",
                        "monoisotopic_mz": "1051.4175",
                        "intensity": "1694.87",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "86",
                        "monoisotopic_mass": "1266.2917",
                        "monoisotopic_mz": "1267.2989",
                        "intensity": "1438.31",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "87",
                        "monoisotopic_mass": "2625.2746",
                        "monoisotopic_mz": "1313.6446",
                        "intensity": "1245.52",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "88",
                        "monoisotopic_mass": "6335.1239",
                        "monoisotopic_mz": "1268.0321",
                        "intensity": "3447.34",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "89",
                        "monoisotopic_mass": "4533.6437",
                        "monoisotopic_mz": "1134.4182",
                        "intensity": "1091.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "90",
                        "monoisotopic_mass": "3347.7448",
                        "monoisotopic_mz": "1116.9222",
                        "intensity": "2767.00",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "91",
                        "monoisotopic_mass": "803.3815",
                        "monoisotopic_mz": "804.3888",
                        "intensity": "2716.33",
                        "charge": "1"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "92",
                        "monoisotopic_mass": "3023.5299",
                        "monoisotopic_mz": "1008.8506",
                        "intensity": "2729.62",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "93",
                        "monoisotopic_mass": "1235.4905",
                        "monoisotopic_mz": "618.7525",
                        "intensity": "789.62",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1235.4911",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "-0.0006",
                                "ppm": "-0.50"
                            }
                        }
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "94",
                        "monoisotopic_mass": "8923.2101",
                        "monoisotopic_mz": "1116.4085",
                        "intensity": "637.23",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "95",
                        "monoisotopic_mass": "2948.0489",
                        "monoisotopic_mz": "983.6902",
                        "intensity": "1927.10",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "96",
                        "monoisotopic_mass": "5379.8436",
                        "monoisotopic_mz": "1076.9760",
                        "intensity": "778.30",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "97",
                        "monoisotopic_mass": "1346.5217",
                        "monoisotopic_mz": "674.2681",
                        "intensity": "1395.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "98",
                        "monoisotopic_mass": "2727.4183",
                        "monoisotopic_mz": "910.1467",
                        "intensity": "2036.26",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "99",
                        "monoisotopic_mass": "7688.8051",
                        "monoisotopic_mz": "1099.4080",
                        "intensity": "3243.13",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "100",
                        "monoisotopic_mass": "2108.0648",
                        "monoisotopic_mz": "1055.0397",
                        "intensity": "1701.68",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "101",
                        "monoisotopic_mass": "6991.5124",
                        "monoisotopic_mz": "999.7948",
                        "intensity": "1058.06",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "102",
                        "monoisotopic_mass": "5573.7639",
                        "monoisotopic_mz": "1115.7600",
                        "intensity": "3102.47",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "103",
                        "monoisotopic_mass": "6318.1170",
                        "monoisotopic_mz": "1054.0268",
                        "intensity": "2754.20",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "104",
                        "monoisotopic_mass": "2294.4020",
                        "monoisotopic_mz": "1148.2083",
                        "intensity": "983.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "105",
                        "monoisotopic_mass": "4590.7937",
                        "monoisotopic_mz": "919.1660",
                        "intensity": "3894.10",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "106",
                        "monoisotopic_mass": "2970.5225",
                        "monoisotopic_mz": "991.1814",
                        "intensity": "2592.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "107",
                        "monoisotopic_mass": "6205.1395",
                        "monoisotopic_mz": "1035.1972",
                        "intensity": "1643.24",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "108",
                        "monoisotopic_mass": "7745.7040",
                        "monoisotopic_mz": "969.2203",
                        "intensity": "2458.22",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "109",
                        "monoisotopic_mass": "5154.6996",
                        "monoisotopic_mz": "1031.9472",
                        "intensity": "2447.19",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "110",
                        "monoisotopic_mass": "7332.5658",
                        "monoisotopic_mz": "917.5780",
                        "intensity": "3047.93",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "111",
                        "monoisotopic_mass": "4035.0621",
                        "monoisotopic_mz": "1009.7728",
                        "intensity": "2554.17",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "112",
                        "monoisotopic_mass": "7796.9082",
                        "monoisotopic_mz": "975.6208",
                        "intensity": "948.72",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "113",
                        "monoisotopic_mass": "4911.0898",
                        "monoisotopic_mz": "983.2252",
                        "intensity": "985.79",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "114",
                        "monoisotopic_mass": "3303.4899",
                        "monoisotopic_mz": "1102.1706",
                        "intensity": "2533.63",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "115",
                        "monoisotopic_mass": "6382.2522",
                        "monoisotopic_mz": "1064.7160",
                        "intensity": "2894.88",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "116",
                        "monoisotopic_mass": "4197.4873",
                        "monoisotopic_mz": "1050.3791",
                        "intensity": "2435.73",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "117",
                        "monoisotopic_mass": "8685.6418",
                        "monoisotopic_mz": "966.0786",
                        "intensity": "967.08",
                        "charge": "9"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "118",
                        "monoisotopic_mass": "7338.4651",
                        "monoisotopic_mz": "1224.0848",
                        "intensity": "1454.24",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "119",
                        "monoisotopic_mass": "7527.3121",
                        "monoisotopic_mz": "1076.3376",
                        "intensity": "1018.39",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "120",
                        "monoisotopic_mass": "5554.9544",
                        "monoisotopic_mz": "926.8330",
                        "intensity": "1035.22",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "121",
                        "monoisotopic_mass": "4674.0378",
                        "monoisotopic_mz": "1169.5167",
                        "intensity": "1368.50",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "122",
                        "monoisotopic_mass": "7446.0577",
                        "monoisotopic_mz": "931.7645",
                        "intensity": "1495.26",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "123",
                        "monoisotopic_mass": "7777.1160",
                        "monoisotopic_mz": "1112.0238",
                        "intensity": "1279.89",
                        "charge": "7"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "124",
                        "monoisotopic_mass": "3933.6825",
                        "monoisotopic_mz": "984.4279",
                        "intensity": "3011.13",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "125",
                        "monoisotopic_mass": "8069.2230",
                        "monoisotopic_mz": "1009.6602",
                        "intensity": "1182.66",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "126",
                        "monoisotopic_mass": "5688.0531",
                        "monoisotopic_mz": "1138.6179",
                        "intensity": "2374.33",
                        "charge": "5"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "127",
                        "monoisotopic_mass": "2047.0426",
                        "monoisotopic_mz": "1024.5286",
                        "intensity": "1210.58",
                        "charge": "2"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "128",
                        "monoisotopic_mass": "6457.8361",
                        "monoisotopic_mz": "1077.3133",
                        "intensity": "2160.56",
                        "charge": "6"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "129",
                        "monoisotopic_mass": "7854.9403",
                        "monoisotopic_mz": "982.8748",
                        "intensity": "2429.44",
                        "charge": "8"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "130",
                        "monoisotopic_mass": "3784.8344",
                        "monoisotopic_mz": "947.2159",
                        "intensity": "2265.12",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "131",
                        "monoisotopic_mass": "3674.9301",
                        "monoisotopic_mz": "919.7398",
                        "intensity": "5272.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "132",
                        "monoisotopic_mass": "3854.9895",
                        "monoisotopic_mz": "964.7547",
                        "intensity": "2532.59",
                        "charge": "4"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "133",
                        "monoisotopic_mass": "3180.9627",
                        "monoisotopic_mz": "1061.3282",
                        "intensity": "2002.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "124",
                        "peak_id": "134",
                        "monoisotopic_mass": "3258.7005",
                        "monoisotopic_mz": "1087.2408",
                        "intensity": "1800.06",
                        "charge": "3"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "124",
                                "peak_id": "76",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "124",
                                "peak_id": "14",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "10",
                                "ion_display_position": "10",
                                "spec_id": "124",
                                "peak_id": "29",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "124",
                                "peak_id": "93",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "spec_id": "124",
                                "peak_id": "13",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "124",
                                "peak_id": "32",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "spec_id": "124",
                                "peak_id": "6",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "73",
                                "ion_display_position": "73",
                                "spec_id": "124",
                                "peak_id": "30",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "spec_id": "124",
                                "peak_id": "9",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
