prsm_data =
{
    "prsm": {
        "prsm_id": "85",
        "p_value": "1.75e-09",
        "e_value": "1.75e-09",
        "fdr": "0",
        "matched_fragment_number": "17",
        "matched_peak_number": "20",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "93",
                "ms1_scans": "212",
                "ids": "119",
                "scans": "214",
                "precursor_mono_mass": "8320.0703",
                "precursor_charge": "10",
                "precursor_mz": "833.0143",
                "feature_inte": "1.2232e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "119",
                        "peak_id": "0",
                        "monoisotopic_mass": "4160.5467",
                        "monoisotopic_mz": "833.1166",
                        "intensity": "67479.98",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "1",
                        "monoisotopic_mass": "8302.0831",
                        "monoisotopic_mz": "831.2156",
                        "intensity": "39229.98",
                        "charge": "10"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "2",
                        "monoisotopic_mass": "4628.2789",
                        "monoisotopic_mz": "926.6631",
                        "intensity": "22616.66",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4628.2797",
                                "ion_position": "32",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "32",
                                "mass_error": "-0.0008",
                                "ppm": "-0.17"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "3",
                        "monoisotopic_mass": "4741.3636",
                        "monoisotopic_mz": "949.2800",
                        "intensity": "39010.92",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4741.3637",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "31",
                                "mass_error": "-0.0002",
                                "ppm": "-0.03"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "4",
                        "monoisotopic_mass": "5942.0338",
                        "monoisotopic_mz": "991.3462",
                        "intensity": "19549.35",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "5",
                        "monoisotopic_mass": "4499.2359",
                        "monoisotopic_mz": "900.8545",
                        "intensity": "16704.82",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4499.2371",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "33",
                                "mass_error": "-0.0012",
                                "ppm": "-0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "6",
                        "monoisotopic_mass": "7478.8711",
                        "monoisotopic_mz": "831.9930",
                        "intensity": "19680.16",
                        "charge": "9"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "7",
                        "monoisotopic_mass": "4853.4414",
                        "monoisotopic_mz": "971.6956",
                        "intensity": "14493.55",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "8",
                        "monoisotopic_mass": "8189.0529",
                        "monoisotopic_mz": "910.9020",
                        "intensity": "16008.34",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8189.0519",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "ion_sort_name": "Y00068",
                                "ion_left_position": "1",
                                "mass_error": "0.0010",
                                "ppm": "0.12"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "9",
                        "monoisotopic_mass": "1338.6102",
                        "monoisotopic_mz": "670.3124",
                        "intensity": "12507.62",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1338.6106",
                                "ion_position": "60",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "60",
                                "mass_error": "-0.0004",
                                "ppm": "-0.28"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "10",
                        "monoisotopic_mass": "7944.9081",
                        "monoisotopic_mz": "883.7748",
                        "intensity": "10876.51",
                        "charge": "9"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "11",
                        "monoisotopic_mass": "1664.2181",
                        "monoisotopic_mz": "833.1163",
                        "intensity": "45567.56",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "12",
                        "monoisotopic_mass": "8075.0059",
                        "monoisotopic_mz": "898.2302",
                        "intensity": "17079.62",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8075.0090",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "ion_sort_name": "Y00067",
                                "ion_left_position": "2",
                                "mass_error": "-0.0030",
                                "ppm": "-0.38"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "13",
                        "monoisotopic_mass": "6981.4750",
                        "monoisotopic_mz": "873.6917",
                        "intensity": "17864.92",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6981.4818",
                                "ion_position": "60",
                                "ion_display_position": "60",
                                "ion_sort_name": "B00060",
                                "ion_left_position": "60",
                                "mass_error": "-0.0068",
                                "ppm": "-0.97"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "14",
                        "monoisotopic_mass": "6083.0474",
                        "monoisotopic_mz": "870.0141",
                        "intensity": "7759.26",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6083.0422",
                                "ion_position": "52",
                                "ion_display_position": "52",
                                "ion_sort_name": "B00052",
                                "ion_left_position": "52",
                                "mass_error": "0.0052",
                                "ppm": "0.86"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "15",
                        "monoisotopic_mass": "8285.0488",
                        "monoisotopic_mz": "829.5122",
                        "intensity": "15174.66",
                        "charge": "10"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "16",
                        "monoisotopic_mass": "4741.3657",
                        "monoisotopic_mz": "791.2349",
                        "intensity": "10742.00",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4741.3637",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "31",
                                "mass_error": "0.0020",
                                "ppm": "0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "17",
                        "monoisotopic_mass": "3465.6448",
                        "monoisotopic_mz": "867.4185",
                        "intensity": "4964.27",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3465.6446",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "ion_sort_name": "B00030",
                                "ion_left_position": "30",
                                "mass_error": "0.0003",
                                "ppm": "0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "18",
                        "monoisotopic_mass": "4955.5044",
                        "monoisotopic_mz": "992.1082",
                        "intensity": "11303.44",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4955.4955",
                                "ion_position": "29",
                                "ion_display_position": "40",
                                "ion_sort_name": "Y00040",
                                "ion_left_position": "29",
                                "mass_error": "0.0089",
                                "ppm": "1.80"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "19",
                        "monoisotopic_mass": "3447.6319",
                        "monoisotopic_mz": "862.9153",
                        "intensity": "8151.56",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "20",
                        "monoisotopic_mass": "1023.4878",
                        "monoisotopic_mz": "512.7512",
                        "intensity": "5686.49",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1023.4887",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "62",
                                "mass_error": "-0.0009",
                                "ppm": "-0.87"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "21",
                        "monoisotopic_mass": "4955.4852",
                        "monoisotopic_mz": "826.9215",
                        "intensity": "5219.12",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4955.4955",
                                "ion_position": "29",
                                "ion_display_position": "40",
                                "ion_sort_name": "Y00040",
                                "ion_left_position": "29",
                                "mass_error": "-0.0103",
                                "ppm": "-2.09"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "22",
                        "monoisotopic_mass": "2495.9271",
                        "monoisotopic_mz": "832.9830",
                        "intensity": "1785.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "23",
                        "monoisotopic_mass": "8074.0102",
                        "monoisotopic_mz": "808.4083",
                        "intensity": "5199.51",
                        "charge": "10",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8075.0090",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "ion_sort_name": "Y00067",
                                "ion_left_position": "2",
                                "mass_error": "0.0036",
                                "ppm": "0.44"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "24",
                        "monoisotopic_mass": "827.7074",
                        "monoisotopic_mz": "828.7147",
                        "intensity": "2786.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "25",
                        "monoisotopic_mass": "1780.8181",
                        "monoisotopic_mz": "891.4163",
                        "intensity": "2760.20",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1780.8169",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "ion_sort_name": "Y00013",
                                "ion_left_position": "56",
                                "mass_error": "0.0012",
                                "ppm": "0.68"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "26",
                        "monoisotopic_mass": "7828.8823",
                        "monoisotopic_mz": "870.8831",
                        "intensity": "1688.03",
                        "charge": "9"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "27",
                        "monoisotopic_mass": "3516.5762",
                        "monoisotopic_mz": "880.1513",
                        "intensity": "2860.18",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "28",
                        "monoisotopic_mass": "4099.5102",
                        "monoisotopic_mz": "820.9093",
                        "intensity": "1068.37",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "29",
                        "monoisotopic_mass": "523.2538",
                        "monoisotopic_mz": "524.2611",
                        "intensity": "2261.14",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "523.2544",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "ion_sort_name": "Y00003",
                                "ion_left_position": "66",
                                "mass_error": "-0.0005",
                                "ppm": "-1.00"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "30",
                        "monoisotopic_mass": "3702.7761",
                        "monoisotopic_mz": "926.7013",
                        "intensity": "3076.23",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3702.7816",
                                "ion_position": "40",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "40",
                                "mass_error": "-0.0055",
                                "ppm": "-1.48"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "31",
                        "monoisotopic_mass": "6040.0973",
                        "monoisotopic_mz": "1007.6902",
                        "intensity": "4160.42",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "32",
                        "monoisotopic_mass": "2427.2211",
                        "monoisotopic_mz": "810.0810",
                        "intensity": "4530.31",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "33",
                        "monoisotopic_mass": "4975.5953",
                        "monoisotopic_mz": "830.2732",
                        "intensity": "1386.31",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "34",
                        "monoisotopic_mass": "1804.9109",
                        "monoisotopic_mz": "903.4627",
                        "intensity": "2162.22",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "35",
                        "monoisotopic_mass": "1819.6820",
                        "monoisotopic_mz": "910.8483",
                        "intensity": "2533.41",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "36",
                        "monoisotopic_mass": "2823.8812",
                        "monoisotopic_mz": "942.3010",
                        "intensity": "4102.75",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "37",
                        "monoisotopic_mass": "4122.5273",
                        "monoisotopic_mz": "825.5127",
                        "intensity": "3176.07",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "38",
                        "monoisotopic_mass": "856.3160",
                        "monoisotopic_mz": "857.3232",
                        "intensity": "1343.38",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "39",
                        "monoisotopic_mass": "1610.3867",
                        "monoisotopic_mz": "806.2006",
                        "intensity": "1612.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "40",
                        "monoisotopic_mass": "7641.1851",
                        "monoisotopic_mz": "956.1554",
                        "intensity": "1234.34",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "41",
                        "monoisotopic_mass": "6171.4078",
                        "monoisotopic_mz": "1029.5752",
                        "intensity": "1239.83",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "42",
                        "monoisotopic_mass": "761.8541",
                        "monoisotopic_mz": "762.8614",
                        "intensity": "4115.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "43",
                        "monoisotopic_mass": "613.3146",
                        "monoisotopic_mz": "614.3219",
                        "intensity": "1460.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "44",
                        "monoisotopic_mass": "5926.0421",
                        "monoisotopic_mz": "988.6810",
                        "intensity": "2512.78",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "45",
                        "monoisotopic_mass": "5003.5774",
                        "monoisotopic_mz": "834.9368",
                        "intensity": "1164.91",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "46",
                        "monoisotopic_mass": "6944.4383",
                        "monoisotopic_mz": "869.0621",
                        "intensity": "976.33",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "47",
                        "monoisotopic_mass": "1872.9857",
                        "monoisotopic_mz": "937.5001",
                        "intensity": "1043.63",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "48",
                        "monoisotopic_mass": "911.4440",
                        "monoisotopic_mz": "912.4513",
                        "intensity": "1868.13",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "49",
                        "monoisotopic_mass": "5715.3518",
                        "monoisotopic_mz": "953.5659",
                        "intensity": "1134.73",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "50",
                        "monoisotopic_mass": "1844.5531",
                        "monoisotopic_mz": "923.2838",
                        "intensity": "1309.74",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "51",
                        "monoisotopic_mass": "977.0173",
                        "monoisotopic_mz": "978.0246",
                        "intensity": "1711.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "52",
                        "monoisotopic_mass": "5755.9573",
                        "monoisotopic_mz": "823.2869",
                        "intensity": "3367.49",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "53",
                        "monoisotopic_mass": "6375.9301",
                        "monoisotopic_mz": "911.8544",
                        "intensity": "1312.40",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "54",
                        "monoisotopic_mass": "4050.3897",
                        "monoisotopic_mz": "1013.6047",
                        "intensity": "1071.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "55",
                        "monoisotopic_mass": "3104.4057",
                        "monoisotopic_mz": "777.1087",
                        "intensity": "2853.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "56",
                        "monoisotopic_mass": "3581.3232",
                        "monoisotopic_mz": "896.3381",
                        "intensity": "2904.88",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "57",
                        "monoisotopic_mass": "7293.0178",
                        "monoisotopic_mz": "912.6345",
                        "intensity": "2325.70",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "58",
                        "monoisotopic_mass": "801.2804",
                        "monoisotopic_mz": "802.2877",
                        "intensity": "1227.66",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "59",
                        "monoisotopic_mass": "7928.9904",
                        "monoisotopic_mz": "882.0062",
                        "intensity": "1636.47",
                        "charge": "9"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "60",
                        "monoisotopic_mass": "1436.7662",
                        "monoisotopic_mz": "479.9294",
                        "intensity": "1383.63",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "61",
                        "monoisotopic_mass": "5706.9803",
                        "monoisotopic_mz": "816.2902",
                        "intensity": "1620.38",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "62",
                        "monoisotopic_mass": "7038.4438",
                        "monoisotopic_mz": "880.8127",
                        "intensity": "3022.27",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "63",
                        "monoisotopic_mass": "6229.9368",
                        "monoisotopic_mz": "890.9982",
                        "intensity": "1697.14",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "64",
                        "monoisotopic_mass": "6861.1601",
                        "monoisotopic_mz": "858.6523",
                        "intensity": "954.54",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "65",
                        "monoisotopic_mass": "7701.8549",
                        "monoisotopic_mz": "963.7391",
                        "intensity": "3212.42",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7702.8445",
                                "ion_position": "5",
                                "ion_display_position": "64",
                                "ion_sort_name": "Y00064",
                                "ion_left_position": "5",
                                "mass_error": "0.0128",
                                "ppm": "1.66"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "66",
                        "monoisotopic_mass": "2809.5102",
                        "monoisotopic_mz": "937.5107",
                        "intensity": "1731.10",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "67",
                        "monoisotopic_mass": "6502.1556",
                        "monoisotopic_mz": "813.7767",
                        "intensity": "3381.12",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6501.2088",
                                "ion_position": "16",
                                "ion_display_position": "53",
                                "ion_sort_name": "Y00053",
                                "ion_left_position": "16",
                                "mass_error": "-0.0556",
                                "ppm": "-8.55"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "68",
                        "monoisotopic_mass": "6343.7512",
                        "monoisotopic_mz": "907.2575",
                        "intensity": "1272.13",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "69",
                        "monoisotopic_mass": "6399.1420",
                        "monoisotopic_mz": "915.1704",
                        "intensity": "3385.63",
                        "charge": "7"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "70",
                        "monoisotopic_mass": "3197.1431",
                        "monoisotopic_mz": "800.2931",
                        "intensity": "2028.73",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "71",
                        "monoisotopic_mass": "6730.1899",
                        "monoisotopic_mz": "842.2810",
                        "intensity": "1347.59",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "72",
                        "monoisotopic_mass": "4007.1159",
                        "monoisotopic_mz": "802.4305",
                        "intensity": "961.46",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "73",
                        "monoisotopic_mass": "2599.6161",
                        "monoisotopic_mz": "867.5460",
                        "intensity": "2638.94",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "74",
                        "monoisotopic_mass": "6664.9663",
                        "monoisotopic_mz": "834.1281",
                        "intensity": "2378.16",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "75",
                        "monoisotopic_mass": "5409.9041",
                        "monoisotopic_mz": "902.6580",
                        "intensity": "960.94",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "76",
                        "monoisotopic_mass": "3965.5112",
                        "monoisotopic_mz": "794.1095",
                        "intensity": "936.36",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "77",
                        "monoisotopic_mass": "7422.8607",
                        "monoisotopic_mz": "825.7696",
                        "intensity": "1020.10",
                        "charge": "9"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "78",
                        "monoisotopic_mass": "4808.6962",
                        "monoisotopic_mz": "962.7465",
                        "intensity": "1342.64",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "79",
                        "monoisotopic_mass": "1908.9153",
                        "monoisotopic_mz": "955.4649",
                        "intensity": "1211.76",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1908.9119",
                                "ion_position": "55",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "55",
                                "mass_error": "0.0034",
                                "ppm": "1.78"
                            }
                        }
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "80",
                        "monoisotopic_mass": "3376.7747",
                        "monoisotopic_mz": "845.2010",
                        "intensity": "2101.27",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "81",
                        "monoisotopic_mass": "1022.0678",
                        "monoisotopic_mz": "1023.0751",
                        "intensity": "843.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "82",
                        "monoisotopic_mass": "2858.2589",
                        "monoisotopic_mz": "953.7602",
                        "intensity": "1162.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "83",
                        "monoisotopic_mass": "4937.7378",
                        "monoisotopic_mz": "823.9636",
                        "intensity": "1161.26",
                        "charge": "6"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "84",
                        "monoisotopic_mass": "3426.2730",
                        "monoisotopic_mz": "857.5755",
                        "intensity": "860.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "85",
                        "monoisotopic_mass": "1090.2946",
                        "monoisotopic_mz": "1091.3019",
                        "intensity": "834.22",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "86",
                        "monoisotopic_mass": "1441.9731",
                        "monoisotopic_mz": "721.9938",
                        "intensity": "794.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "87",
                        "monoisotopic_mass": "1480.3167",
                        "monoisotopic_mz": "741.1657",
                        "intensity": "891.03",
                        "charge": "2"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "88",
                        "monoisotopic_mass": "840.7956",
                        "monoisotopic_mz": "841.8029",
                        "intensity": "1263.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "89",
                        "monoisotopic_mass": "3290.8009",
                        "monoisotopic_mz": "823.7075",
                        "intensity": "1890.74",
                        "charge": "4"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "90",
                        "monoisotopic_mass": "1062.6390",
                        "monoisotopic_mz": "1063.6463",
                        "intensity": "1162.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "91",
                        "monoisotopic_mass": "4433.6718",
                        "monoisotopic_mz": "887.7416",
                        "intensity": "2247.24",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "92",
                        "monoisotopic_mass": "7198.6452",
                        "monoisotopic_mz": "900.8379",
                        "intensity": "2544.43",
                        "charge": "8"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "93",
                        "monoisotopic_mass": "990.4914",
                        "monoisotopic_mz": "991.4987",
                        "intensity": "3313.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "94",
                        "monoisotopic_mass": "4464.4407",
                        "monoisotopic_mz": "893.8954",
                        "intensity": "2672.22",
                        "charge": "5"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "95",
                        "monoisotopic_mass": "2776.7754",
                        "monoisotopic_mz": "926.5991",
                        "intensity": "1607.41",
                        "charge": "3"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "96",
                        "monoisotopic_mass": "1042.6632",
                        "monoisotopic_mz": "1043.6704",
                        "intensity": "913.48",
                        "charge": "1"
                    },
                    {
                        "spec_id": "119",
                        "peak_id": "97",
                        "monoisotopic_mass": "1006.3422",
                        "monoisotopic_mz": "1007.3495",
                        "intensity": "977.26",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P68206|YJBJ_ECOLI",
            "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
            "proteoform_mass": "8320.0923",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "69",
                "first_residue_position": "0",
                "last_residue_position": "68",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "D"
                    },
                    {
                        "position": "4",
                        "acid": "E"
                    },
                    {
                        "position": "5",
                        "acid": "A"
                    },
                    {
                        "position": "6",
                        "acid": "G"
                    },
                    {
                        "position": "7",
                        "acid": "G"
                    },
                    {
                        "position": "8",
                        "acid": "N"
                    },
                    {
                        "position": "9",
                        "acid": "W"
                    },
                    {
                        "position": "10",
                        "acid": "K"
                    },
                    {
                        "position": "11",
                        "acid": "Q"
                    },
                    {
                        "position": "12",
                        "acid": "F"
                    },
                    {
                        "position": "13",
                        "acid": "K"
                    },
                    {
                        "position": "14",
                        "acid": "G"
                    },
                    {
                        "position": "15",
                        "acid": "K"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "E"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "W"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "K"
                    },
                    {
                        "position": "23",
                        "acid": "L"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "D"
                    },
                    {
                        "position": "27",
                        "acid": "D"
                    },
                    {
                        "position": "28",
                        "acid": "M"
                    },
                    {
                        "position": "29",
                        "acid": "T"
                    },
                    {
                        "position": "30",
                        "acid": "I"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "G"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "R"
                    },
                    {
                        "position": "36",
                        "acid": "D"
                    },
                    {
                        "position": "37",
                        "acid": "Q"
                    },
                    {
                        "position": "38",
                        "acid": "L"
                    },
                    {
                        "position": "39",
                        "acid": "V"
                    },
                    {
                        "position": "40",
                        "acid": "G"
                    },
                    {
                        "position": "41",
                        "acid": "K"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "Q"
                    },
                    {
                        "position": "44",
                        "acid": "E"
                    },
                    {
                        "position": "45",
                        "acid": "R"
                    },
                    {
                        "position": "46",
                        "acid": "Y"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "Y"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "Q"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "E"
                    },
                    {
                        "position": "55",
                        "acid": "K"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "V"
                    },
                    {
                        "position": "58",
                        "acid": "V"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "W"
                    },
                    {
                        "position": "61",
                        "acid": "E"
                    },
                    {
                        "position": "62",
                        "acid": "T"
                    },
                    {
                        "position": "63",
                        "acid": "R"
                    },
                    {
                        "position": "64",
                        "acid": "N"
                    },
                    {
                        "position": "65",
                        "acid": "E"
                    },
                    {
                        "position": "66",
                        "acid": "Y"
                    },
                    {
                        "position": "67",
                        "acid": "R"
                    },
                    {
                        "position": "68",
                        "acid": "W"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "1",
                                "ion_display_position": "68",
                                "spec_id": "119",
                                "peak_id": "8",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "2",
                                    "ion_display_position": "67",
                                    "spec_id": "119",
                                    "peak_id": "12",
                                    "peak_charge": "9"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "2",
                                    "ion_display_position": "67",
                                    "spec_id": "119",
                                    "peak_id": "23",
                                    "peak_charge": "10"
                                }
                            ]
                        }
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "5",
                                "ion_display_position": "64",
                                "spec_id": "119",
                                "peak_id": "65",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "16",
                                "ion_display_position": "53",
                                "spec_id": "119",
                                "peak_id": "67",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "29",
                                    "ion_display_position": "40",
                                    "spec_id": "119",
                                    "peak_id": "21",
                                    "peak_charge": "6"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "29",
                                    "ion_display_position": "40",
                                    "spec_id": "119",
                                    "peak_id": "18",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "30",
                                "ion_display_position": "30",
                                "spec_id": "119",
                                "peak_id": "17",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "31",
                                    "ion_display_position": "38",
                                    "spec_id": "119",
                                    "peak_id": "3",
                                    "peak_charge": "5"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "31",
                                    "ion_display_position": "38",
                                    "spec_id": "119",
                                    "peak_id": "16",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "32",
                                "ion_display_position": "37",
                                "spec_id": "119",
                                "peak_id": "2",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "spec_id": "119",
                                "peak_id": "5",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "40",
                                "ion_display_position": "29",
                                "spec_id": "119",
                                "peak_id": "30",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "52",
                                "ion_display_position": "52",
                                "spec_id": "119",
                                "peak_id": "14",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "55",
                                "ion_display_position": "14",
                                "spec_id": "119",
                                "peak_id": "79",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "13",
                                "spec_id": "119",
                                "peak_id": "25",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "60",
                                    "ion_display_position": "9",
                                    "spec_id": "119",
                                    "peak_id": "9",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "spec_id": "119",
                                    "peak_id": "13",
                                    "peak_charge": "8"
                                }
                            ]
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "spec_id": "119",
                                "peak_id": "20",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "spec_id": "119",
                                "peak_id": "29",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
