prsm_data =
{
    "prsm": {
        "prsm_id": "77",
        "p_value": "5.62e-06",
        "e_value": "5.62e-06",
        "fdr": "0",
        "matched_fragment_number": "13",
        "matched_peak_number": "15",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "89",
                "ms1_scans": "197",
                "ids": "107",
                "scans": "198",
                "precursor_mono_mass": "9173.4147",
                "precursor_charge": "8",
                "precursor_mz": "1147.6841",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "107",
                        "peak_id": "0",
                        "monoisotopic_mass": "8944.3221",
                        "monoisotopic_mz": "1278.7676",
                        "intensity": "414746.05",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0051",
                                "ppm": "-0.57"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "1",
                        "monoisotopic_mass": "8927.3091",
                        "monoisotopic_mz": "1276.3372",
                        "intensity": "94331.23",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "2",
                        "monoisotopic_mass": "8831.2489",
                        "monoisotopic_mz": "1262.6143",
                        "intensity": "26685.75",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "0.0058",
                                "ppm": "0.65"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "3",
                        "monoisotopic_mass": "8958.3135",
                        "monoisotopic_mz": "1280.7664",
                        "intensity": "26221.34",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "4",
                        "monoisotopic_mass": "4494.0411",
                        "monoisotopic_mz": "1124.5176",
                        "intensity": "13537.75",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4494.0429",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0018",
                                "ppm": "-0.40"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "5",
                        "monoisotopic_mass": "3973.8138",
                        "monoisotopic_mz": "1325.6119",
                        "intensity": "12817.89",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "-0.0010",
                                "ppm": "-0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "6",
                        "monoisotopic_mass": "3121.6063",
                        "monoisotopic_mz": "1561.8104",
                        "intensity": "14364.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "7",
                        "monoisotopic_mass": "8897.3345",
                        "monoisotopic_mz": "1272.0551",
                        "intensity": "16947.77",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "8",
                        "monoisotopic_mass": "8716.2266",
                        "monoisotopic_mz": "1246.1825",
                        "intensity": "9096.77",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8716.2161",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "ion_sort_name": "B00075",
                                "ion_left_position": "75",
                                "mass_error": "0.0104",
                                "ppm": "1.19"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "9",
                        "monoisotopic_mass": "4136.8828",
                        "monoisotopic_mz": "1379.9682",
                        "intensity": "10817.53",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "0.0047",
                                "ppm": "1.13"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "10",
                        "monoisotopic_mass": "4250.1737",
                        "monoisotopic_mz": "1417.7319",
                        "intensity": "10061.88",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "11",
                        "monoisotopic_mass": "3954.8008",
                        "monoisotopic_mz": "1319.2742",
                        "intensity": "8022.31",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "12",
                        "monoisotopic_mass": "8943.3191",
                        "monoisotopic_mz": "1118.9222",
                        "intensity": "14366.60",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0057",
                                "ppm": "-0.64"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "13",
                        "monoisotopic_mass": "5366.4409",
                        "monoisotopic_mz": "1342.6175",
                        "intensity": "11186.75",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5367.4509",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "ion_sort_name": "B00047",
                                "ion_left_position": "47",
                                "mass_error": "-0.0076",
                                "ppm": "-1.42"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "14",
                        "monoisotopic_mass": "8814.2297",
                        "monoisotopic_mz": "1102.7860",
                        "intensity": "7166.20",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "15",
                        "monoisotopic_mass": "8813.2336",
                        "monoisotopic_mz": "1260.0407",
                        "intensity": "15883.81",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "16",
                        "monoisotopic_mass": "8830.2171",
                        "monoisotopic_mz": "1104.7844",
                        "intensity": "7188.79",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0236",
                                "ppm": "-2.67"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "17",
                        "monoisotopic_mass": "4450.2697",
                        "monoisotopic_mz": "1484.4305",
                        "intensity": "5952.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "18",
                        "monoisotopic_mass": "4586.2003",
                        "monoisotopic_mz": "1147.5573",
                        "intensity": "6587.13",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "19",
                        "monoisotopic_mass": "8443.0984",
                        "monoisotopic_mz": "1207.1642",
                        "intensity": "5540.99",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8444.1041",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "ion_sort_name": "B00072",
                                "ion_left_position": "72",
                                "mass_error": "-0.0033",
                                "ppm": "-0.39"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "20",
                        "monoisotopic_mass": "3792.9451",
                        "monoisotopic_mz": "1265.3223",
                        "intensity": "4318.08",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "21",
                        "monoisotopic_mass": "4036.0381",
                        "monoisotopic_mz": "1346.3533",
                        "intensity": "6481.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "22",
                        "monoisotopic_mass": "1739.7122",
                        "monoisotopic_mz": "1740.7195",
                        "intensity": "2863.04",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1739.7131",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "ion_sort_name": "B00015",
                                "ion_left_position": "15",
                                "mass_error": "-0.0009",
                                "ppm": "-0.50"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "23",
                        "monoisotopic_mass": "3643.6530",
                        "monoisotopic_mz": "1215.5583",
                        "intensity": "4112.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "24",
                        "monoisotopic_mass": "2761.2676",
                        "monoisotopic_mz": "1381.6411",
                        "intensity": "2694.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "25",
                        "monoisotopic_mass": "3121.6050",
                        "monoisotopic_mz": "1041.5423",
                        "intensity": "3398.38",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "26",
                        "monoisotopic_mass": "2401.5358",
                        "monoisotopic_mz": "1201.7752",
                        "intensity": "5562.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "27",
                        "monoisotopic_mass": "5565.7709",
                        "monoisotopic_mz": "1392.4500",
                        "intensity": "6462.87",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "28",
                        "monoisotopic_mass": "2609.2674",
                        "monoisotopic_mz": "1305.6410",
                        "intensity": "2971.46",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "29",
                        "monoisotopic_mass": "4172.0134",
                        "monoisotopic_mz": "1391.6784",
                        "intensity": "5105.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "30",
                        "monoisotopic_mass": "4149.1157",
                        "monoisotopic_mz": "1384.0458",
                        "intensity": "5662.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "31",
                        "monoisotopic_mass": "8011.3399",
                        "monoisotopic_mz": "1145.4844",
                        "intensity": "9167.83",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "32",
                        "monoisotopic_mass": "8203.0084",
                        "monoisotopic_mz": "1172.8656",
                        "intensity": "3090.21",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8202.0026",
                                "ion_position": "70",
                                "ion_display_position": "70",
                                "ion_sort_name": "B00070",
                                "ion_left_position": "70",
                                "mass_error": "0.0035",
                                "ppm": "0.43"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "33",
                        "monoisotopic_mass": "8927.2628",
                        "monoisotopic_mz": "1116.9151",
                        "intensity": "10319.43",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "34",
                        "monoisotopic_mass": "2294.3602",
                        "monoisotopic_mz": "1148.1874",
                        "intensity": "4647.53",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "35",
                        "monoisotopic_mass": "2227.0719",
                        "monoisotopic_mz": "1114.5432",
                        "intensity": "3131.32",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "36",
                        "monoisotopic_mass": "720.3439",
                        "monoisotopic_mz": "721.3512",
                        "intensity": "2102.25",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "37",
                        "monoisotopic_mass": "1230.0283",
                        "monoisotopic_mz": "1231.0355",
                        "intensity": "2115.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "38",
                        "monoisotopic_mass": "3857.7227",
                        "monoisotopic_mz": "1286.9149",
                        "intensity": "1248.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "39",
                        "monoisotopic_mass": "8894.2494",
                        "monoisotopic_mz": "1112.7884",
                        "intensity": "1126.29",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "40",
                        "monoisotopic_mass": "1216.7331",
                        "monoisotopic_mz": "1217.7404",
                        "intensity": "1223.75",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "41",
                        "monoisotopic_mass": "1153.9883",
                        "monoisotopic_mz": "1154.9956",
                        "intensity": "1932.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "42",
                        "monoisotopic_mass": "3135.4343",
                        "monoisotopic_mz": "1046.1520",
                        "intensity": "2269.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "43",
                        "monoisotopic_mass": "4779.2011",
                        "monoisotopic_mz": "1195.8076",
                        "intensity": "1610.70",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "44",
                        "monoisotopic_mass": "1372.3392",
                        "monoisotopic_mz": "1373.3464",
                        "intensity": "2621.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "45",
                        "monoisotopic_mass": "6315.1700",
                        "monoisotopic_mz": "1264.0413",
                        "intensity": "1299.44",
                        "charge": "5"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "46",
                        "monoisotopic_mass": "2189.4938",
                        "monoisotopic_mz": "1095.7542",
                        "intensity": "4122.71",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "47",
                        "monoisotopic_mass": "1102.5328",
                        "monoisotopic_mz": "1103.5400",
                        "intensity": "2192.69",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "48",
                        "monoisotopic_mass": "1131.0486",
                        "monoisotopic_mz": "1132.0559",
                        "intensity": "1758.35",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "49",
                        "monoisotopic_mass": "3434.8953",
                        "monoisotopic_mz": "1145.9724",
                        "intensity": "2966.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "50",
                        "monoisotopic_mass": "2516.2655",
                        "monoisotopic_mz": "1259.1400",
                        "intensity": "2842.80",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "51",
                        "monoisotopic_mass": "8078.8763",
                        "monoisotopic_mz": "1155.1325",
                        "intensity": "1090.89",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "52",
                        "monoisotopic_mass": "3820.5600",
                        "monoisotopic_mz": "1274.5273",
                        "intensity": "8786.91",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "53",
                        "monoisotopic_mass": "7210.1644",
                        "monoisotopic_mz": "1202.7013",
                        "intensity": "1262.16",
                        "charge": "6"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "54",
                        "monoisotopic_mass": "1067.5042",
                        "monoisotopic_mz": "1068.5115",
                        "intensity": "706.32",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "55",
                        "monoisotopic_mass": "5993.9873",
                        "monoisotopic_mz": "1499.5041",
                        "intensity": "2337.77",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "56",
                        "monoisotopic_mass": "7582.7820",
                        "monoisotopic_mz": "1264.8043",
                        "intensity": "2941.54",
                        "charge": "6"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "57",
                        "monoisotopic_mass": "1115.1642",
                        "monoisotopic_mz": "1116.1715",
                        "intensity": "785.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "58",
                        "monoisotopic_mass": "3486.7237",
                        "monoisotopic_mz": "1163.2485",
                        "intensity": "1360.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "59",
                        "monoisotopic_mass": "7684.8676",
                        "monoisotopic_mz": "1098.8455",
                        "intensity": "1232.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "60",
                        "monoisotopic_mass": "9042.3996",
                        "monoisotopic_mz": "1131.3072",
                        "intensity": "3879.08",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "9041.3799",
                                "ion_position": "78",
                                "ion_display_position": "78",
                                "ion_sort_name": "B00078",
                                "ion_left_position": "78",
                                "mass_error": "0.0173",
                                "ppm": "1.91"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "61",
                        "monoisotopic_mass": "9159.3972",
                        "monoisotopic_mz": "1145.9319",
                        "intensity": "3645.82",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "62",
                        "monoisotopic_mass": "1419.7138",
                        "monoisotopic_mz": "1420.7211",
                        "intensity": "2902.98",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "63",
                        "monoisotopic_mass": "1192.2967",
                        "monoisotopic_mz": "1193.3040",
                        "intensity": "799.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "64",
                        "monoisotopic_mass": "8767.0734",
                        "monoisotopic_mz": "1096.8915",
                        "intensity": "682.18",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "65",
                        "monoisotopic_mass": "8037.6685",
                        "monoisotopic_mz": "1149.2456",
                        "intensity": "1245.51",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "66",
                        "monoisotopic_mass": "4653.3849",
                        "monoisotopic_mz": "1164.3535",
                        "intensity": "1171.33",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "67",
                        "monoisotopic_mass": "8855.3172",
                        "monoisotopic_mz": "1107.9219",
                        "intensity": "909.83",
                        "charge": "8"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "68",
                        "monoisotopic_mass": "4507.1909",
                        "monoisotopic_mz": "1127.8050",
                        "intensity": "2518.81",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "69",
                        "monoisotopic_mass": "1298.9789",
                        "monoisotopic_mz": "1299.9862",
                        "intensity": "646.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "70",
                        "monoisotopic_mass": "1172.1446",
                        "monoisotopic_mz": "1173.1519",
                        "intensity": "1360.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "71",
                        "monoisotopic_mass": "1349.8329",
                        "monoisotopic_mz": "1350.8402",
                        "intensity": "766.81",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "72",
                        "monoisotopic_mass": "4923.8776",
                        "monoisotopic_mz": "1231.9767",
                        "intensity": "1672.14",
                        "charge": "4"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "73",
                        "monoisotopic_mass": "1336.3447",
                        "monoisotopic_mz": "1337.3519",
                        "intensity": "710.46",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "74",
                        "monoisotopic_mass": "1450.4116",
                        "monoisotopic_mz": "1451.4188",
                        "intensity": "2547.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "75",
                        "monoisotopic_mass": "5022.3354",
                        "monoisotopic_mz": "1256.5911",
                        "intensity": "957.55",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5022.3337",
                                "ion_position": "44",
                                "ion_display_position": "44",
                                "ion_sort_name": "B00044",
                                "ion_left_position": "44",
                                "mass_error": "0.0017",
                                "ppm": "0.35"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "76",
                        "monoisotopic_mass": "1242.8835",
                        "monoisotopic_mz": "1243.8907",
                        "intensity": "1769.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "77",
                        "monoisotopic_mass": "5932.7631",
                        "monoisotopic_mz": "1187.5599",
                        "intensity": "2312.41",
                        "charge": "5"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "78",
                        "monoisotopic_mass": "5380.9844",
                        "monoisotopic_mz": "1077.2041",
                        "intensity": "1357.11",
                        "charge": "5"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "79",
                        "monoisotopic_mass": "2537.0723",
                        "monoisotopic_mz": "1269.5434",
                        "intensity": "1920.67",
                        "charge": "2"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "80",
                        "monoisotopic_mass": "7872.0749",
                        "monoisotopic_mz": "1125.5894",
                        "intensity": "2622.82",
                        "charge": "7"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "81",
                        "monoisotopic_mass": "1464.5296",
                        "monoisotopic_mz": "1465.5369",
                        "intensity": "844.92",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "82",
                        "monoisotopic_mass": "3874.7574",
                        "monoisotopic_mz": "1292.5931",
                        "intensity": "2161.05",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3874.7463",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "ion_sort_name": "B00033",
                                "ion_left_position": "33",
                                "mass_error": "0.0111",
                                "ppm": "2.86"
                            }
                        }
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "83",
                        "monoisotopic_mass": "1387.6882",
                        "monoisotopic_mz": "1388.6954",
                        "intensity": "875.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "107",
                        "peak_id": "84",
                        "monoisotopic_mass": "4376.5912",
                        "monoisotopic_mz": "1095.1551",
                        "intensity": "2232.57",
                        "charge": "4"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "spec_id": "107",
                                "peak_id": "22",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "spec_id": "107",
                                "peak_id": "82",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "107",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "107",
                                "peak_id": "9",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "107",
                                "peak_id": "4",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "44",
                                "ion_display_position": "44",
                                "spec_id": "107",
                                "peak_id": "75",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "spec_id": "107",
                                "peak_id": "13",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "70",
                                "ion_display_position": "70",
                                "spec_id": "107",
                                "peak_id": "32",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "spec_id": "107",
                                "peak_id": "19",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "spec_id": "107",
                                "peak_id": "8",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "107",
                                    "peak_id": "16",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "107",
                                    "peak_id": "2",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "77",
                                    "ion_display_position": "77",
                                    "spec_id": "107",
                                    "peak_id": "12",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "77",
                                    "ion_display_position": "77",
                                    "spec_id": "107",
                                    "peak_id": "0",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "78",
                                "ion_display_position": "78",
                                "spec_id": "107",
                                "peak_id": "60",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
