prsm_data =
{
    "prsm": {
        "prsm_id": "59",
        "p_value": "5.74e-04",
        "e_value": "5.75e-04",
        "fdr": "0",
        "matched_fragment_number": "9",
        "matched_peak_number": "11",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "81",
                "ms1_scans": "161",
                "ids": "80",
                "scans": "163",
                "precursor_mono_mass": "9173.4057",
                "precursor_charge": "10",
                "precursor_mz": "918.3478",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "80",
                        "peak_id": "0",
                        "monoisotopic_mass": "3792.9536",
                        "monoisotopic_mz": "1265.3251",
                        "intensity": "6306.80",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "1",
                        "monoisotopic_mass": "6914.4872",
                        "monoisotopic_mz": "1153.4218",
                        "intensity": "9481.03",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "2",
                        "monoisotopic_mass": "7328.7512",
                        "monoisotopic_mz": "917.1012",
                        "intensity": "9848.12",
                        "charge": "8"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "3",
                        "monoisotopic_mass": "4777.1969",
                        "monoisotopic_mz": "1195.3065",
                        "intensity": "6361.30",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "4",
                        "monoisotopic_mass": "8831.2175",
                        "monoisotopic_mz": "1104.9095",
                        "intensity": "8871.22",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0255",
                                "ppm": "-2.89"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "5",
                        "monoisotopic_mass": "720.3442",
                        "monoisotopic_mz": "721.3514",
                        "intensity": "4935.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "6",
                        "monoisotopic_mass": "3121.6005",
                        "monoisotopic_mz": "1561.8075",
                        "intensity": "5829.23",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "7",
                        "monoisotopic_mass": "7319.6424",
                        "monoisotopic_mz": "1220.9477",
                        "intensity": "6588.78",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7320.6363",
                                "ion_position": "16",
                                "ion_display_position": "63",
                                "ion_sort_name": "Y00063",
                                "ion_left_position": "16",
                                "mass_error": "0.0085",
                                "ppm": "1.16"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "8",
                        "monoisotopic_mass": "7319.6293",
                        "monoisotopic_mz": "1046.6686",
                        "intensity": "3799.87",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7320.6363",
                                "ion_position": "16",
                                "ion_display_position": "63",
                                "ion_sort_name": "Y00063",
                                "ion_left_position": "16",
                                "mass_error": "-0.0047",
                                "ppm": "-0.64"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "9",
                        "monoisotopic_mass": "3007.5148",
                        "monoisotopic_mz": "1003.5122",
                        "intensity": "4354.20",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "10",
                        "monoisotopic_mass": "2203.0541",
                        "monoisotopic_mz": "1102.5343",
                        "intensity": "5490.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "11",
                        "monoisotopic_mass": "1364.5339",
                        "monoisotopic_mz": "683.2742",
                        "intensity": "4352.02",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1364.5337",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "ion_sort_name": "B00012",
                                "ion_left_position": "12",
                                "mass_error": "0.0002",
                                "ppm": "0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "12",
                        "monoisotopic_mass": "4036.0334",
                        "monoisotopic_mz": "1346.3517",
                        "intensity": "5591.20",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "13",
                        "monoisotopic_mass": "947.4011",
                        "monoisotopic_mz": "948.4083",
                        "intensity": "4194.18",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "947.4018",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "-0.0008",
                                "ppm": "-0.84"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "14",
                        "monoisotopic_mass": "3973.8167",
                        "monoisotopic_mz": "1325.6129",
                        "intensity": "4404.10",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "0.0020",
                                "ppm": "0.50"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "15",
                        "monoisotopic_mass": "1101.3991",
                        "monoisotopic_mz": "1102.4064",
                        "intensity": "3400.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "16",
                        "monoisotopic_mass": "3921.9748",
                        "monoisotopic_mz": "1308.3322",
                        "intensity": "4223.64",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "17",
                        "monoisotopic_mass": "846.3550",
                        "monoisotopic_mz": "847.3623",
                        "intensity": "3541.31",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "846.3542",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "0.0009",
                                "ppm": "1.02"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "18",
                        "monoisotopic_mass": "3104.5773",
                        "monoisotopic_mz": "1553.2959",
                        "intensity": "2607.86",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "19",
                        "monoisotopic_mass": "3774.9221",
                        "monoisotopic_mz": "1259.3146",
                        "intensity": "2744.61",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "20",
                        "monoisotopic_mass": "3463.7915",
                        "monoisotopic_mz": "1155.6044",
                        "intensity": "3142.83",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3463.7922",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "50",
                                "mass_error": "-0.0008",
                                "ppm": "-0.22"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "21",
                        "monoisotopic_mass": "2609.2733",
                        "monoisotopic_mz": "1305.6439",
                        "intensity": "3709.40",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "22",
                        "monoisotopic_mass": "4136.8787",
                        "monoisotopic_mz": "1379.9668",
                        "intensity": "4653.98",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "0.0006",
                                "ppm": "0.15"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "23",
                        "monoisotopic_mass": "3463.7918",
                        "monoisotopic_mz": "866.9552",
                        "intensity": "1972.32",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3463.7922",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "50",
                                "mass_error": "-0.0004",
                                "ppm": "-0.13"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "24",
                        "monoisotopic_mass": "2916.9750",
                        "monoisotopic_mz": "973.3323",
                        "intensity": "2956.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "25",
                        "monoisotopic_mass": "1244.6171",
                        "monoisotopic_mz": "1245.6244",
                        "intensity": "2058.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "26",
                        "monoisotopic_mass": "3791.9583",
                        "monoisotopic_mz": "948.9968",
                        "intensity": "3435.23",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "27",
                        "monoisotopic_mass": "2234.8068",
                        "monoisotopic_mz": "1118.4107",
                        "intensity": "1940.72",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "28",
                        "monoisotopic_mass": "4250.0472",
                        "monoisotopic_mz": "1063.5191",
                        "intensity": "3377.18",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "29",
                        "monoisotopic_mass": "1068.5286",
                        "monoisotopic_mz": "1069.5359",
                        "intensity": "1219.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "30",
                        "monoisotopic_mass": "557.2804",
                        "monoisotopic_mz": "558.2877",
                        "intensity": "2270.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "31",
                        "monoisotopic_mass": "2129.0282",
                        "monoisotopic_mz": "1065.5214",
                        "intensity": "3486.38",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "32",
                        "monoisotopic_mass": "5828.9306",
                        "monoisotopic_mz": "972.4957",
                        "intensity": "943.35",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "33",
                        "monoisotopic_mass": "3121.6266",
                        "monoisotopic_mz": "1041.5495",
                        "intensity": "3566.30",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "34",
                        "monoisotopic_mass": "3677.8636",
                        "monoisotopic_mz": "920.4732",
                        "intensity": "1534.40",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "35",
                        "monoisotopic_mass": "7594.7144",
                        "monoisotopic_mz": "1085.9665",
                        "intensity": "4144.36",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "36",
                        "monoisotopic_mass": "3921.9396",
                        "monoisotopic_mz": "981.4922",
                        "intensity": "886.48",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "37",
                        "monoisotopic_mass": "7463.9686",
                        "monoisotopic_mz": "1067.2885",
                        "intensity": "1123.71",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "38",
                        "monoisotopic_mass": "2941.4778",
                        "monoisotopic_mz": "981.4999",
                        "intensity": "2047.11",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "39",
                        "monoisotopic_mass": "6700.4209",
                        "monoisotopic_mz": "1117.7441",
                        "intensity": "6088.11",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "40",
                        "monoisotopic_mass": "2706.0515",
                        "monoisotopic_mz": "903.0245",
                        "intensity": "1136.63",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "41",
                        "monoisotopic_mass": "3905.6870",
                        "monoisotopic_mz": "977.4290",
                        "intensity": "1875.06",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "42",
                        "monoisotopic_mass": "3263.6180",
                        "monoisotopic_mz": "1088.8799",
                        "intensity": "2700.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "43",
                        "monoisotopic_mass": "930.3741",
                        "monoisotopic_mz": "931.3813",
                        "intensity": "1669.44",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "44",
                        "monoisotopic_mass": "995.9331",
                        "monoisotopic_mz": "996.9404",
                        "intensity": "1794.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "45",
                        "monoisotopic_mass": "917.0293",
                        "monoisotopic_mz": "918.0366",
                        "intensity": "1220.57",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "46",
                        "monoisotopic_mass": "821.3927",
                        "monoisotopic_mz": "822.4000",
                        "intensity": "2974.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "47",
                        "monoisotopic_mass": "2483.2357",
                        "monoisotopic_mz": "1242.6251",
                        "intensity": "1610.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "48",
                        "monoisotopic_mass": "6200.1077",
                        "monoisotopic_mz": "1034.3586",
                        "intensity": "1417.70",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "49",
                        "monoisotopic_mass": "979.6919",
                        "monoisotopic_mz": "980.6992",
                        "intensity": "1304.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "50",
                        "monoisotopic_mass": "7549.8516",
                        "monoisotopic_mz": "944.7387",
                        "intensity": "995.89",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7548.7473",
                                "ion_position": "14",
                                "ion_display_position": "65",
                                "ion_sort_name": "Y00065",
                                "ion_left_position": "14",
                                "mass_error": "0.1019",
                                "ppm": "13.50"
                            }
                        }
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "51",
                        "monoisotopic_mass": "7801.8476",
                        "monoisotopic_mz": "1115.5569",
                        "intensity": "3970.48",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "52",
                        "monoisotopic_mass": "6046.0616",
                        "monoisotopic_mz": "864.7304",
                        "intensity": "1027.18",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "53",
                        "monoisotopic_mass": "1800.4779",
                        "monoisotopic_mz": "901.2462",
                        "intensity": "1781.66",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "54",
                        "monoisotopic_mass": "1386.1695",
                        "monoisotopic_mz": "1387.1768",
                        "intensity": "718.43",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "55",
                        "monoisotopic_mass": "3103.5706",
                        "monoisotopic_mz": "1035.5308",
                        "intensity": "1729.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "56",
                        "monoisotopic_mass": "2592.2742",
                        "monoisotopic_mz": "1297.1444",
                        "intensity": "1382.05",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "57",
                        "monoisotopic_mass": "1154.9322",
                        "monoisotopic_mz": "1155.9395",
                        "intensity": "3042.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "58",
                        "monoisotopic_mass": "1347.5047",
                        "monoisotopic_mz": "674.7596",
                        "intensity": "678.28",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "59",
                        "monoisotopic_mass": "1008.5105",
                        "monoisotopic_mz": "1009.5178",
                        "intensity": "1472.79",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "60",
                        "monoisotopic_mass": "1046.6653",
                        "monoisotopic_mz": "1047.6726",
                        "intensity": "1443.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "61",
                        "monoisotopic_mass": "5589.5988",
                        "monoisotopic_mz": "1118.9270",
                        "intensity": "1091.65",
                        "charge": "5"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "62",
                        "monoisotopic_mass": "1192.6296",
                        "monoisotopic_mz": "1193.6368",
                        "intensity": "884.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "63",
                        "monoisotopic_mass": "8889.6480",
                        "monoisotopic_mz": "988.7459",
                        "intensity": "893.47",
                        "charge": "9"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "64",
                        "monoisotopic_mass": "4514.2140",
                        "monoisotopic_mz": "903.8501",
                        "intensity": "1438.24",
                        "charge": "5"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "65",
                        "monoisotopic_mass": "803.3813",
                        "monoisotopic_mz": "804.3886",
                        "intensity": "1751.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "66",
                        "monoisotopic_mass": "7349.8871",
                        "monoisotopic_mz": "1050.9912",
                        "intensity": "2327.89",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "67",
                        "monoisotopic_mass": "1115.8966",
                        "monoisotopic_mz": "1116.9039",
                        "intensity": "1925.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "68",
                        "monoisotopic_mass": "8215.3956",
                        "monoisotopic_mz": "913.8290",
                        "intensity": "1000.97",
                        "charge": "9"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "69",
                        "monoisotopic_mass": "1998.2977",
                        "monoisotopic_mz": "1000.1561",
                        "intensity": "1728.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "70",
                        "monoisotopic_mass": "8599.1801",
                        "monoisotopic_mz": "1075.9048",
                        "intensity": "989.75",
                        "charge": "8"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "71",
                        "monoisotopic_mass": "1224.9631",
                        "monoisotopic_mz": "1225.9703",
                        "intensity": "834.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "72",
                        "monoisotopic_mass": "6359.6157",
                        "monoisotopic_mz": "909.5238",
                        "intensity": "1268.47",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "73",
                        "monoisotopic_mass": "7564.7543",
                        "monoisotopic_mz": "1081.6865",
                        "intensity": "6341.43",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "74",
                        "monoisotopic_mass": "7091.4111",
                        "monoisotopic_mz": "1014.0660",
                        "intensity": "3127.31",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "75",
                        "monoisotopic_mass": "8252.8518",
                        "monoisotopic_mz": "917.9908",
                        "intensity": "2983.09",
                        "charge": "9"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "76",
                        "monoisotopic_mass": "3224.3712",
                        "monoisotopic_mz": "1075.7977",
                        "intensity": "2422.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "77",
                        "monoisotopic_mass": "6915.4844",
                        "monoisotopic_mz": "988.9336",
                        "intensity": "3371.65",
                        "charge": "7"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "78",
                        "monoisotopic_mass": "1175.9185",
                        "monoisotopic_mz": "1176.9258",
                        "intensity": "909.36",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "79",
                        "monoisotopic_mass": "1209.6164",
                        "monoisotopic_mz": "1210.6237",
                        "intensity": "784.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "80",
                        "monoisotopic_mass": "6021.9234",
                        "monoisotopic_mz": "1004.6612",
                        "intensity": "2366.61",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "81",
                        "monoisotopic_mass": "6071.0356",
                        "monoisotopic_mz": "1012.8465",
                        "intensity": "1990.49",
                        "charge": "6"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "82",
                        "monoisotopic_mass": "4018.9830",
                        "monoisotopic_mz": "1340.6683",
                        "intensity": "1872.57",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "83",
                        "monoisotopic_mass": "8400.1428",
                        "monoisotopic_mz": "1051.0251",
                        "intensity": "809.75",
                        "charge": "8"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "84",
                        "monoisotopic_mass": "4265.5455",
                        "monoisotopic_mz": "1067.3936",
                        "intensity": "863.41",
                        "charge": "4"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "85",
                        "monoisotopic_mass": "3954.8002",
                        "monoisotopic_mz": "1319.2740",
                        "intensity": "2360.38",
                        "charge": "3"
                    },
                    {
                        "spec_id": "80",
                        "peak_id": "86",
                        "monoisotopic_mass": "1141.5641",
                        "monoisotopic_mz": "1142.5714",
                        "intensity": "856.82",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "80",
                                "peak_id": "17",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "80",
                                "peak_id": "13",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "spec_id": "80",
                                "peak_id": "11",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "14",
                                "ion_display_position": "65",
                                "spec_id": "80",
                                "peak_id": "50",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "16",
                                    "ion_display_position": "63",
                                    "spec_id": "80",
                                    "peak_id": "8",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "16",
                                    "ion_display_position": "63",
                                    "spec_id": "80",
                                    "peak_id": "7",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "80",
                                "peak_id": "14",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "80",
                                "peak_id": "22",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "50",
                                    "ion_display_position": "29",
                                    "spec_id": "80",
                                    "peak_id": "20",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "50",
                                    "ion_display_position": "29",
                                    "spec_id": "80",
                                    "peak_id": "23",
                                    "peak_charge": "4"
                                }
                            ]
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "spec_id": "80",
                                "peak_id": "4",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
