prsm_data =
{
    "prsm": {
        "prsm_id": "57",
        "p_value": "2.80e-05",
        "e_value": "2.80e-05",
        "fdr": "0",
        "matched_fragment_number": "10",
        "matched_peak_number": "10",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "80",
                "ms1_scans": "156",
                "ids": "76",
                "scans": "158",
                "precursor_mono_mass": "8320.0703",
                "precursor_charge": "10",
                "precursor_mz": "833.0143",
                "feature_inte": "1.2232e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "76",
                        "peak_id": "0",
                        "monoisotopic_mass": "4160.0454",
                        "monoisotopic_mz": "833.0164",
                        "intensity": "81735.65",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "1",
                        "monoisotopic_mass": "8302.0782",
                        "monoisotopic_mz": "831.2151",
                        "intensity": "33968.95",
                        "charge": "10"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "2",
                        "monoisotopic_mass": "4627.2773",
                        "monoisotopic_mz": "926.4627",
                        "intensity": "18961.18",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "3",
                        "monoisotopic_mass": "7477.8747",
                        "monoisotopic_mz": "831.8822",
                        "intensity": "27718.36",
                        "charge": "9"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "4",
                        "monoisotopic_mass": "5942.0349",
                        "monoisotopic_mz": "991.3464",
                        "intensity": "21752.12",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "5",
                        "monoisotopic_mass": "4741.3659",
                        "monoisotopic_mz": "949.2805",
                        "intensity": "27394.17",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4741.3637",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "ion_sort_name": "Y00038",
                                "ion_left_position": "31",
                                "mass_error": "0.0021",
                                "ppm": "0.45"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "6",
                        "monoisotopic_mass": "4499.2396",
                        "monoisotopic_mz": "900.8552",
                        "intensity": "14135.55",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4499.2371",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "33",
                                "mass_error": "0.0025",
                                "ppm": "0.56"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "7",
                        "monoisotopic_mass": "4853.4520",
                        "monoisotopic_mz": "971.6977",
                        "intensity": "14835.50",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "8",
                        "monoisotopic_mass": "8074.0074",
                        "monoisotopic_mz": "898.1192",
                        "intensity": "13120.88",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8075.0090",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "ion_sort_name": "Y00067",
                                "ion_left_position": "2",
                                "mass_error": "0.0008",
                                "ppm": "0.10"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "9",
                        "monoisotopic_mass": "832.1099",
                        "monoisotopic_mz": "833.1172",
                        "intensity": "11084.03",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "10",
                        "monoisotopic_mass": "6981.4863",
                        "monoisotopic_mz": "873.6931",
                        "intensity": "10561.71",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6981.4818",
                                "ion_position": "60",
                                "ion_display_position": "60",
                                "ion_sort_name": "B00060",
                                "ion_left_position": "60",
                                "mass_error": "0.0045",
                                "ppm": "0.64"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "11",
                        "monoisotopic_mass": "7945.9117",
                        "monoisotopic_mz": "883.8864",
                        "intensity": "10848.78",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7946.9140",
                                "ion_position": "3",
                                "ion_display_position": "66",
                                "ion_sort_name": "Y00066",
                                "ion_left_position": "3",
                                "mass_error": "0.0000",
                                "ppm": "0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "12",
                        "monoisotopic_mass": "1338.6098",
                        "monoisotopic_mz": "670.3122",
                        "intensity": "9724.08",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1338.6106",
                                "ion_position": "60",
                                "ion_display_position": "9",
                                "ion_sort_name": "Y00009",
                                "ion_left_position": "60",
                                "mass_error": "-0.0007",
                                "ppm": "-0.54"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "13",
                        "monoisotopic_mass": "8284.0699",
                        "monoisotopic_mz": "829.4143",
                        "intensity": "12120.00",
                        "charge": "10"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "14",
                        "monoisotopic_mass": "3329.0376",
                        "monoisotopic_mz": "833.2667",
                        "intensity": "85892.91",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "15",
                        "monoisotopic_mass": "4139.0362",
                        "monoisotopic_mz": "828.8145",
                        "intensity": "6145.14",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "16",
                        "monoisotopic_mass": "5589.8660",
                        "monoisotopic_mz": "932.6516",
                        "intensity": "7206.79",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "17",
                        "monoisotopic_mass": "4740.3642",
                        "monoisotopic_mz": "791.0680",
                        "intensity": "6068.03",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "18",
                        "monoisotopic_mass": "1023.4881",
                        "monoisotopic_mz": "512.7513",
                        "intensity": "3608.07",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1023.4887",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "62",
                                "mass_error": "-0.0005",
                                "ppm": "-0.52"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "19",
                        "monoisotopic_mass": "5128.6855",
                        "monoisotopic_mz": "1026.7444",
                        "intensity": "3074.71",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "20",
                        "monoisotopic_mass": "1618.8159",
                        "monoisotopic_mz": "810.4152",
                        "intensity": "3495.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "21",
                        "monoisotopic_mass": "1738.8724",
                        "monoisotopic_mz": "870.4435",
                        "intensity": "2406.96",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "22",
                        "monoisotopic_mass": "4066.5053",
                        "monoisotopic_mz": "814.3083",
                        "intensity": "3553.48",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "23",
                        "monoisotopic_mass": "5446.6955",
                        "monoisotopic_mz": "908.7899",
                        "intensity": "2213.04",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "24",
                        "monoisotopic_mass": "3446.6337",
                        "monoisotopic_mz": "862.6657",
                        "intensity": "4196.88",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "25",
                        "monoisotopic_mass": "2642.6255",
                        "monoisotopic_mz": "881.8824",
                        "intensity": "3801.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "26",
                        "monoisotopic_mass": "2707.7455",
                        "monoisotopic_mz": "903.5891",
                        "intensity": "2610.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "27",
                        "monoisotopic_mass": "2736.3512",
                        "monoisotopic_mz": "913.1243",
                        "intensity": "2654.85",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "28",
                        "monoisotopic_mass": "3233.5674",
                        "monoisotopic_mz": "809.3991",
                        "intensity": "5854.68",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3233.5564",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "0.0110",
                                "ppm": "3.39"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "29",
                        "monoisotopic_mass": "4475.1038",
                        "monoisotopic_mz": "746.8579",
                        "intensity": "2353.06",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "30",
                        "monoisotopic_mass": "3269.6386",
                        "monoisotopic_mz": "818.4169",
                        "intensity": "3777.70",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "31",
                        "monoisotopic_mass": "862.1600",
                        "monoisotopic_mz": "863.1672",
                        "intensity": "3249.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "32",
                        "monoisotopic_mass": "7069.5330",
                        "monoisotopic_mz": "884.6989",
                        "intensity": "1115.25",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "33",
                        "monoisotopic_mass": "7627.7975",
                        "monoisotopic_mz": "954.4820",
                        "intensity": "1304.60",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "34",
                        "monoisotopic_mass": "1987.7296",
                        "monoisotopic_mz": "994.8721",
                        "intensity": "2014.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "35",
                        "monoisotopic_mass": "4037.0157",
                        "monoisotopic_mz": "808.4104",
                        "intensity": "1388.04",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "36",
                        "monoisotopic_mass": "1801.6199",
                        "monoisotopic_mz": "901.8172",
                        "intensity": "1893.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "37",
                        "monoisotopic_mass": "1000.0091",
                        "monoisotopic_mz": "1001.0164",
                        "intensity": "1141.76",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "38",
                        "monoisotopic_mass": "1825.9505",
                        "monoisotopic_mz": "913.9825",
                        "intensity": "1980.05",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "39",
                        "monoisotopic_mass": "4293.3746",
                        "monoisotopic_mz": "859.6822",
                        "intensity": "1015.67",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "40",
                        "monoisotopic_mass": "885.6125",
                        "monoisotopic_mz": "886.6197",
                        "intensity": "1061.68",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "41",
                        "monoisotopic_mass": "6725.6201",
                        "monoisotopic_mz": "961.8102",
                        "intensity": "2215.24",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "42",
                        "monoisotopic_mass": "523.2540",
                        "monoisotopic_mz": "524.2612",
                        "intensity": "1902.95",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "523.2544",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "ion_sort_name": "Y00003",
                                "ion_left_position": "66",
                                "mass_error": "-0.0004",
                                "ppm": "-0.77"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "43",
                        "monoisotopic_mass": "2654.7800",
                        "monoisotopic_mz": "885.9339",
                        "intensity": "2456.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "44",
                        "monoisotopic_mass": "693.3278",
                        "monoisotopic_mz": "694.3351",
                        "intensity": "1193.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "45",
                        "monoisotopic_mass": "6699.4598",
                        "monoisotopic_mz": "838.4397",
                        "intensity": "1041.99",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "46",
                        "monoisotopic_mass": "6587.2134",
                        "monoisotopic_mz": "942.0378",
                        "intensity": "1255.43",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "47",
                        "monoisotopic_mass": "5360.8993",
                        "monoisotopic_mz": "894.4905",
                        "intensity": "1267.11",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "48",
                        "monoisotopic_mass": "4375.1936",
                        "monoisotopic_mz": "876.0460",
                        "intensity": "1746.89",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "49",
                        "monoisotopic_mass": "6607.0918",
                        "monoisotopic_mz": "826.8938",
                        "intensity": "2025.10",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "50",
                        "monoisotopic_mass": "6103.9876",
                        "monoisotopic_mz": "1018.3385",
                        "intensity": "1281.51",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "51",
                        "monoisotopic_mass": "955.4741",
                        "monoisotopic_mz": "956.4814",
                        "intensity": "1124.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "52",
                        "monoisotopic_mass": "6679.4165",
                        "monoisotopic_mz": "955.2096",
                        "intensity": "967.86",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "53",
                        "monoisotopic_mass": "2470.2458",
                        "monoisotopic_mz": "824.4225",
                        "intensity": "1656.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "54",
                        "monoisotopic_mass": "1766.8722",
                        "monoisotopic_mz": "884.4434",
                        "intensity": "4022.15",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "55",
                        "monoisotopic_mass": "6814.5511",
                        "monoisotopic_mz": "852.8262",
                        "intensity": "1322.32",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "56",
                        "monoisotopic_mass": "1779.8156",
                        "monoisotopic_mz": "890.9151",
                        "intensity": "1900.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "57",
                        "monoisotopic_mass": "2572.9414",
                        "monoisotopic_mz": "858.6544",
                        "intensity": "1121.05",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "58",
                        "monoisotopic_mass": "3308.8185",
                        "monoisotopic_mz": "828.2119",
                        "intensity": "2267.73",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "59",
                        "monoisotopic_mass": "988.0035",
                        "monoisotopic_mz": "989.0108",
                        "intensity": "1043.62",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "60",
                        "monoisotopic_mass": "3656.9206",
                        "monoisotopic_mz": "915.2374",
                        "intensity": "929.80",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "61",
                        "monoisotopic_mass": "6538.2702",
                        "monoisotopic_mz": "935.0459",
                        "intensity": "2034.91",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6539.2754",
                                "ion_position": "56",
                                "ion_display_position": "56",
                                "ion_sort_name": "B00056",
                                "ion_left_position": "56",
                                "mass_error": "-0.0029",
                                "ppm": "-0.45"
                            }
                        }
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "62",
                        "monoisotopic_mass": "4098.1048",
                        "monoisotopic_mz": "820.6282",
                        "intensity": "1064.83",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "63",
                        "monoisotopic_mass": "806.3009",
                        "monoisotopic_mz": "807.3082",
                        "intensity": "1511.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "64",
                        "monoisotopic_mass": "1077.0993",
                        "monoisotopic_mz": "1078.1066",
                        "intensity": "877.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "65",
                        "monoisotopic_mass": "8223.3863",
                        "monoisotopic_mz": "914.7169",
                        "intensity": "908.11",
                        "charge": "9"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "66",
                        "monoisotopic_mass": "6233.2488",
                        "monoisotopic_mz": "891.4714",
                        "intensity": "2874.05",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "67",
                        "monoisotopic_mass": "3292.2036",
                        "monoisotopic_mz": "824.0582",
                        "intensity": "1686.57",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "68",
                        "monoisotopic_mass": "4658.4096",
                        "monoisotopic_mz": "932.6892",
                        "intensity": "1127.47",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "69",
                        "monoisotopic_mass": "4610.2578",
                        "monoisotopic_mz": "923.0588",
                        "intensity": "2907.12",
                        "charge": "5"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "70",
                        "monoisotopic_mass": "1897.5271",
                        "monoisotopic_mz": "949.7709",
                        "intensity": "2367.65",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "71",
                        "monoisotopic_mass": "7500.3706",
                        "monoisotopic_mz": "834.3818",
                        "intensity": "3582.10",
                        "charge": "9"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "72",
                        "monoisotopic_mass": "5716.0711",
                        "monoisotopic_mz": "953.6858",
                        "intensity": "2065.64",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "73",
                        "monoisotopic_mass": "6961.9350",
                        "monoisotopic_mz": "995.5694",
                        "intensity": "2224.98",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "74",
                        "monoisotopic_mass": "5777.7917",
                        "monoisotopic_mz": "826.4061",
                        "intensity": "2641.69",
                        "charge": "7"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "75",
                        "monoisotopic_mass": "7887.8852",
                        "monoisotopic_mz": "877.4390",
                        "intensity": "1171.33",
                        "charge": "9"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "76",
                        "monoisotopic_mass": "1639.2170",
                        "monoisotopic_mz": "820.6158",
                        "intensity": "3184.93",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "77",
                        "monoisotopic_mass": "1135.2829",
                        "monoisotopic_mz": "1136.2902",
                        "intensity": "734.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "78",
                        "monoisotopic_mass": "2765.3294",
                        "monoisotopic_mz": "922.7837",
                        "intensity": "2092.76",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "79",
                        "monoisotopic_mass": "4954.4939",
                        "monoisotopic_mz": "826.7563",
                        "intensity": "4043.96",
                        "charge": "6"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "80",
                        "monoisotopic_mass": "1857.6163",
                        "monoisotopic_mz": "929.8154",
                        "intensity": "1595.01",
                        "charge": "2"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "81",
                        "monoisotopic_mass": "3749.8719",
                        "monoisotopic_mz": "938.4752",
                        "intensity": "998.75",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "82",
                        "monoisotopic_mass": "2982.5417",
                        "monoisotopic_mz": "995.1879",
                        "intensity": "3061.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "83",
                        "monoisotopic_mass": "2419.2311",
                        "monoisotopic_mz": "807.4176",
                        "intensity": "1031.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "84",
                        "monoisotopic_mass": "1046.0955",
                        "monoisotopic_mz": "1047.1028",
                        "intensity": "810.47",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "85",
                        "monoisotopic_mass": "3391.3346",
                        "monoisotopic_mz": "848.8409",
                        "intensity": "2303.27",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "86",
                        "monoisotopic_mass": "6845.6444",
                        "monoisotopic_mz": "856.7128",
                        "intensity": "3313.68",
                        "charge": "8"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "87",
                        "monoisotopic_mass": "790.5575",
                        "monoisotopic_mz": "791.5648",
                        "intensity": "745.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "88",
                        "monoisotopic_mass": "3843.4325",
                        "monoisotopic_mz": "961.8654",
                        "intensity": "1224.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "89",
                        "monoisotopic_mass": "1013.5004",
                        "monoisotopic_mz": "1014.5077",
                        "intensity": "1272.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "90",
                        "monoisotopic_mass": "3512.2676",
                        "monoisotopic_mz": "879.0742",
                        "intensity": "1814.59",
                        "charge": "4"
                    },
                    {
                        "spec_id": "76",
                        "peak_id": "91",
                        "monoisotopic_mass": "1025.8341",
                        "monoisotopic_mz": "1026.8413",
                        "intensity": "928.25",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "3",
            "proteoform_id": "3",
            "sequence_name": "sp|P68206|YJBJ_ECOLI",
            "sequence_description": "UPF0337 protein YjbJ OS=Escherichia coli (strain K12) OX=83333 GN=yjbJ PE=1 SV=1",
            "proteoform_mass": "8320.0923",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "69",
                "first_residue_position": "0",
                "last_residue_position": "68",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "D"
                    },
                    {
                        "position": "4",
                        "acid": "E"
                    },
                    {
                        "position": "5",
                        "acid": "A"
                    },
                    {
                        "position": "6",
                        "acid": "G"
                    },
                    {
                        "position": "7",
                        "acid": "G"
                    },
                    {
                        "position": "8",
                        "acid": "N"
                    },
                    {
                        "position": "9",
                        "acid": "W"
                    },
                    {
                        "position": "10",
                        "acid": "K"
                    },
                    {
                        "position": "11",
                        "acid": "Q"
                    },
                    {
                        "position": "12",
                        "acid": "F"
                    },
                    {
                        "position": "13",
                        "acid": "K"
                    },
                    {
                        "position": "14",
                        "acid": "G"
                    },
                    {
                        "position": "15",
                        "acid": "K"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "E"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "W"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "K"
                    },
                    {
                        "position": "23",
                        "acid": "L"
                    },
                    {
                        "position": "24",
                        "acid": "T"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "D"
                    },
                    {
                        "position": "27",
                        "acid": "D"
                    },
                    {
                        "position": "28",
                        "acid": "M"
                    },
                    {
                        "position": "29",
                        "acid": "T"
                    },
                    {
                        "position": "30",
                        "acid": "I"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "G"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "R"
                    },
                    {
                        "position": "36",
                        "acid": "D"
                    },
                    {
                        "position": "37",
                        "acid": "Q"
                    },
                    {
                        "position": "38",
                        "acid": "L"
                    },
                    {
                        "position": "39",
                        "acid": "V"
                    },
                    {
                        "position": "40",
                        "acid": "G"
                    },
                    {
                        "position": "41",
                        "acid": "K"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "Q"
                    },
                    {
                        "position": "44",
                        "acid": "E"
                    },
                    {
                        "position": "45",
                        "acid": "R"
                    },
                    {
                        "position": "46",
                        "acid": "Y"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "Y"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "Q"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "E"
                    },
                    {
                        "position": "55",
                        "acid": "K"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "V"
                    },
                    {
                        "position": "58",
                        "acid": "V"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "W"
                    },
                    {
                        "position": "61",
                        "acid": "E"
                    },
                    {
                        "position": "62",
                        "acid": "T"
                    },
                    {
                        "position": "63",
                        "acid": "R"
                    },
                    {
                        "position": "64",
                        "acid": "N"
                    },
                    {
                        "position": "65",
                        "acid": "E"
                    },
                    {
                        "position": "66",
                        "acid": "Y"
                    },
                    {
                        "position": "67",
                        "acid": "R"
                    },
                    {
                        "position": "68",
                        "acid": "W"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "2",
                                "ion_display_position": "67",
                                "spec_id": "76",
                                "peak_id": "8",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "3",
                                "ion_display_position": "66",
                                "spec_id": "76",
                                "peak_id": "11",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "spec_id": "76",
                                "peak_id": "28",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "31",
                                "ion_display_position": "38",
                                "spec_id": "76",
                                "peak_id": "5",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "33",
                                "ion_display_position": "36",
                                "spec_id": "76",
                                "peak_id": "6",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "56",
                                "ion_display_position": "56",
                                "spec_id": "76",
                                "peak_id": "61",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "60",
                                    "ion_display_position": "9",
                                    "spec_id": "76",
                                    "peak_id": "12",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "60",
                                    "ion_display_position": "60",
                                    "spec_id": "76",
                                    "peak_id": "10",
                                    "peak_charge": "8"
                                }
                            ]
                        }
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "62",
                                "ion_display_position": "7",
                                "spec_id": "76",
                                "peak_id": "18",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "66",
                                "ion_display_position": "3",
                                "spec_id": "76",
                                "peak_id": "42",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
