prsm_data =
{
    "prsm": {
        "prsm_id": "29",
        "p_value": "2.54e-06",
        "e_value": "2.54e-06",
        "fdr": "0",
        "matched_fragment_number": "15",
        "matched_peak_number": "16",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "68",
                "ms1_scans": "106",
                "ids": "37",
                "scans": "107",
                "precursor_mono_mass": "9173.3946",
                "precursor_charge": "9",
                "precursor_mz": "1020.2733",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "37",
                        "peak_id": "0",
                        "monoisotopic_mass": "8831.2309",
                        "monoisotopic_mz": "1262.6117",
                        "intensity": "36268.84",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0122",
                                "ppm": "-1.38"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "1",
                        "monoisotopic_mass": "8831.2459",
                        "monoisotopic_mz": "1104.9130",
                        "intensity": "42377.65",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "0.0028",
                                "ppm": "0.31"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "2",
                        "monoisotopic_mass": "8814.2351",
                        "monoisotopic_mz": "1102.7867",
                        "intensity": "15001.67",
                        "charge": "8"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "3",
                        "monoisotopic_mass": "7579.7856",
                        "monoisotopic_mz": "1264.3049",
                        "intensity": "25707.31",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "4",
                        "monoisotopic_mass": "8926.3079",
                        "monoisotopic_mz": "1116.7958",
                        "intensity": "18403.70",
                        "charge": "8"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "5",
                        "monoisotopic_mass": "7708.8292",
                        "monoisotopic_mz": "1285.8121",
                        "intensity": "15224.22",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "6",
                        "monoisotopic_mass": "8814.2009",
                        "monoisotopic_mz": "1260.1788",
                        "intensity": "13411.27",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "7",
                        "monoisotopic_mass": "8943.3109",
                        "monoisotopic_mz": "1118.9211",
                        "intensity": "21267.36",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0139",
                                "ppm": "-1.56"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "8",
                        "monoisotopic_mass": "8911.2869",
                        "monoisotopic_mz": "1114.9181",
                        "intensity": "15019.24",
                        "charge": "8"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "9",
                        "monoisotopic_mass": "8760.2491",
                        "monoisotopic_mz": "1252.4714",
                        "intensity": "14753.11",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "10",
                        "monoisotopic_mass": "3973.8153",
                        "monoisotopic_mz": "1325.6124",
                        "intensity": "16954.22",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "0.0005",
                                "ppm": "0.13"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "11",
                        "monoisotopic_mass": "8742.2347",
                        "monoisotopic_mz": "1249.8979",
                        "intensity": "10564.10",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "12",
                        "monoisotopic_mass": "4776.1929",
                        "monoisotopic_mz": "1195.0555",
                        "intensity": "12177.84",
                        "charge": "4"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "13",
                        "monoisotopic_mass": "3121.5980",
                        "monoisotopic_mz": "1561.8063",
                        "intensity": "11318.00",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "14",
                        "monoisotopic_mass": "7561.7685",
                        "monoisotopic_mz": "1261.3020",
                        "intensity": "10267.38",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "15",
                        "monoisotopic_mass": "8630.2126",
                        "monoisotopic_mz": "1233.8948",
                        "intensity": "19139.51",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "16",
                        "monoisotopic_mass": "5150.3692",
                        "monoisotopic_mz": "1031.0811",
                        "intensity": "7851.16",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5151.3763",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "B00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0047",
                                "ppm": "-0.92"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "17",
                        "monoisotopic_mass": "5367.4555",
                        "monoisotopic_mz": "1342.8712",
                        "intensity": "7781.13",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5367.4509",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "ion_sort_name": "B00047",
                                "ion_left_position": "47",
                                "mass_error": "0.0047",
                                "ppm": "0.87"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "18",
                        "monoisotopic_mass": "3018.4835",
                        "monoisotopic_mz": "1007.1684",
                        "intensity": "8701.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "19",
                        "monoisotopic_mass": "4035.0380",
                        "monoisotopic_mz": "1346.0199",
                        "intensity": "9820.52",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "20",
                        "monoisotopic_mass": "4249.1612",
                        "monoisotopic_mz": "1417.3943",
                        "intensity": "6301.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "21",
                        "monoisotopic_mass": "7431.7208",
                        "monoisotopic_mz": "1239.6274",
                        "intensity": "13241.88",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "22",
                        "monoisotopic_mass": "3691.9043",
                        "monoisotopic_mz": "1231.6420",
                        "intensity": "6020.48",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "23",
                        "monoisotopic_mass": "4019.0104",
                        "monoisotopic_mz": "1340.6774",
                        "intensity": "4997.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "24",
                        "monoisotopic_mass": "7661.7271",
                        "monoisotopic_mz": "1095.5397",
                        "intensity": "7538.16",
                        "charge": "7",
                        "matched_ions_num": "2",
                        "matched_ions": {
                            "matched_ion": [
                                {
                                    "ion_type": "Y",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "7661.8314",
                                    "ion_position": "13",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "Y00066",
                                    "ion_left_position": "13",
                                    "mass_error": "-0.1043",
                                    "ppm": "-13.61"
                                },
                                {
                                    "ion_type": "B",
                                    "match_shift": "0.0000000000",
                                    "theoretical_mass": "7662.7282",
                                    "ion_position": "66",
                                    "ion_display_position": "66",
                                    "ion_sort_name": "B00066",
                                    "ion_left_position": "66",
                                    "mass_error": "0.0013",
                                    "ppm": "0.16"
                                }
                            ]
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "25",
                        "monoisotopic_mass": "8725.2440",
                        "monoisotopic_mz": "1247.4707",
                        "intensity": "9691.50",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "26",
                        "monoisotopic_mass": "3955.8116",
                        "monoisotopic_mz": "1319.6111",
                        "intensity": "7236.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "27",
                        "monoisotopic_mass": "4137.8847",
                        "monoisotopic_mz": "1380.3022",
                        "intensity": "8990.09",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "28",
                        "monoisotopic_mass": "3846.9085",
                        "monoisotopic_mz": "1283.3101",
                        "intensity": "4532.74",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "29",
                        "monoisotopic_mass": "2494.1067",
                        "monoisotopic_mz": "1248.0606",
                        "intensity": "4072.87",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "30",
                        "monoisotopic_mass": "1364.5318",
                        "monoisotopic_mz": "683.2732",
                        "intensity": "4186.15",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1364.5337",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "ion_sort_name": "B00012",
                                "ion_left_position": "12",
                                "mass_error": "-0.0018",
                                "ppm": "-1.35"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "31",
                        "monoisotopic_mass": "720.3439",
                        "monoisotopic_mz": "721.3512",
                        "intensity": "5083.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "32",
                        "monoisotopic_mass": "1112.4106",
                        "monoisotopic_mz": "1113.4178",
                        "intensity": "3231.47",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "33",
                        "monoisotopic_mass": "8540.1499",
                        "monoisotopic_mz": "1221.0287",
                        "intensity": "4735.62",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "34",
                        "monoisotopic_mass": "821.3919",
                        "monoisotopic_mz": "822.3992",
                        "intensity": "3419.23",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "35",
                        "monoisotopic_mass": "3874.7439",
                        "monoisotopic_mz": "1292.5886",
                        "intensity": "4827.58",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3874.7463",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "ion_sort_name": "B00033",
                                "ion_left_position": "33",
                                "mass_error": "-0.0025",
                                "ppm": "-0.63"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "36",
                        "monoisotopic_mass": "3921.9598",
                        "monoisotopic_mz": "1308.3272",
                        "intensity": "4862.44",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "37",
                        "monoisotopic_mass": "3463.7846",
                        "monoisotopic_mz": "1155.6021",
                        "intensity": "6336.74",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3463.7922",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "ion_sort_name": "Y00029",
                                "ion_left_position": "50",
                                "mass_error": "-0.0077",
                                "ppm": "-2.21"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "38",
                        "monoisotopic_mass": "1217.5867",
                        "monoisotopic_mz": "1218.5940",
                        "intensity": "4837.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "39",
                        "monoisotopic_mass": "2247.0211",
                        "monoisotopic_mz": "1124.5178",
                        "intensity": "8646.63",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "40",
                        "monoisotopic_mass": "3772.6911",
                        "monoisotopic_mz": "1258.5710",
                        "intensity": "4096.30",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "41",
                        "monoisotopic_mass": "1249.1764",
                        "monoisotopic_mz": "1250.1837",
                        "intensity": "3483.64",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "42",
                        "monoisotopic_mass": "3122.6023",
                        "monoisotopic_mz": "1041.8747",
                        "intensity": "3118.49",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "43",
                        "monoisotopic_mass": "3602.7982",
                        "monoisotopic_mz": "1201.9400",
                        "intensity": "5991.64",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "44",
                        "monoisotopic_mass": "2199.8046",
                        "monoisotopic_mz": "1100.9096",
                        "intensity": "4126.24",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "45",
                        "monoisotopic_mass": "947.4018",
                        "monoisotopic_mz": "948.4091",
                        "intensity": "3311.06",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "947.4018",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "ion_sort_name": "B00009",
                                "ion_left_position": "9",
                                "mass_error": "-0.0000",
                                "ppm": "-0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "46",
                        "monoisotopic_mass": "3904.9471",
                        "monoisotopic_mz": "1302.6563",
                        "intensity": "4979.39",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "47",
                        "monoisotopic_mass": "4438.1207",
                        "monoisotopic_mz": "1110.5375",
                        "intensity": "4339.53",
                        "charge": "4"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "48",
                        "monoisotopic_mass": "8593.1250",
                        "monoisotopic_mz": "1228.5966",
                        "intensity": "3214.73",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "49",
                        "monoisotopic_mass": "870.4181",
                        "monoisotopic_mz": "871.4254",
                        "intensity": "2422.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "50",
                        "monoisotopic_mass": "8073.9852",
                        "monoisotopic_mz": "1154.4337",
                        "intensity": "9782.95",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8073.9076",
                                "ion_position": "69",
                                "ion_display_position": "69",
                                "ion_sort_name": "B00069",
                                "ion_left_position": "69",
                                "mass_error": "0.0776",
                                "ppm": "9.61"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "51",
                        "monoisotopic_mass": "3008.5164",
                        "monoisotopic_mz": "1505.2655",
                        "intensity": "3907.45",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "52",
                        "monoisotopic_mass": "1262.7501",
                        "monoisotopic_mz": "1263.7574",
                        "intensity": "5173.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "53",
                        "monoisotopic_mass": "2762.2750",
                        "monoisotopic_mz": "1382.1448",
                        "intensity": "5098.41",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2762.2714",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0037",
                                "ppm": "1.33"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "54",
                        "monoisotopic_mass": "8782.2216",
                        "monoisotopic_mz": "1255.6104",
                        "intensity": "4323.56",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "55",
                        "monoisotopic_mass": "4892.2765",
                        "monoisotopic_mz": "1224.0764",
                        "intensity": "2714.81",
                        "charge": "4"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "56",
                        "monoisotopic_mass": "1305.6415",
                        "monoisotopic_mz": "1306.6488",
                        "intensity": "2451.65",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "57",
                        "monoisotopic_mass": "7819.8798",
                        "monoisotopic_mz": "1304.3206",
                        "intensity": "9448.99",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "58",
                        "monoisotopic_mass": "5587.2483",
                        "monoisotopic_mz": "1118.4569",
                        "intensity": "4016.96",
                        "charge": "5"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "59",
                        "monoisotopic_mass": "1192.2920",
                        "monoisotopic_mz": "1193.2993",
                        "intensity": "2373.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "60",
                        "monoisotopic_mass": "7449.6761",
                        "monoisotopic_mz": "1242.6200",
                        "intensity": "2675.16",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "61",
                        "monoisotopic_mass": "658.3276",
                        "monoisotopic_mz": "659.3349",
                        "intensity": "1424.86",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "62",
                        "monoisotopic_mass": "7302.6062",
                        "monoisotopic_mz": "1218.1083",
                        "intensity": "1474.64",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "63",
                        "monoisotopic_mass": "3058.8180",
                        "monoisotopic_mz": "1020.6133",
                        "intensity": "2742.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "64",
                        "monoisotopic_mass": "1132.5522",
                        "monoisotopic_mz": "1133.5594",
                        "intensity": "1278.72",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "65",
                        "monoisotopic_mass": "803.3813",
                        "monoisotopic_mz": "804.3886",
                        "intensity": "1141.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "66",
                        "monoisotopic_mass": "2440.2161",
                        "monoisotopic_mz": "1221.1153",
                        "intensity": "2470.08",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "67",
                        "monoisotopic_mass": "8282.7724",
                        "monoisotopic_mz": "1381.4693",
                        "intensity": "1317.08",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "68",
                        "monoisotopic_mass": "3659.3218",
                        "monoisotopic_mz": "1220.7812",
                        "intensity": "4437.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "69",
                        "monoisotopic_mass": "3103.5785",
                        "monoisotopic_mz": "1552.7965",
                        "intensity": "3117.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "70",
                        "monoisotopic_mass": "1231.6001",
                        "monoisotopic_mz": "1232.6074",
                        "intensity": "4311.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "71",
                        "monoisotopic_mass": "5152.3605",
                        "monoisotopic_mz": "1289.0974",
                        "intensity": "5004.68",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5151.3763",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "B00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0181",
                                "ppm": "-3.52"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "72",
                        "monoisotopic_mass": "8649.1823",
                        "monoisotopic_mz": "1236.6047",
                        "intensity": "3297.40",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "73",
                        "monoisotopic_mass": "846.3537",
                        "monoisotopic_mz": "847.3610",
                        "intensity": "2870.44",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "846.3542",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0004",
                                "ppm": "-0.49"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "74",
                        "monoisotopic_mass": "5385.6745",
                        "monoisotopic_mz": "1078.1422",
                        "intensity": "1057.96",
                        "charge": "5"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "75",
                        "monoisotopic_mass": "4678.3499",
                        "monoisotopic_mz": "1560.4572",
                        "intensity": "2434.12",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "76",
                        "monoisotopic_mass": "1005.4506",
                        "monoisotopic_mz": "1006.4578",
                        "intensity": "1892.70",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "77",
                        "monoisotopic_mass": "1411.7153",
                        "monoisotopic_mz": "1412.7225",
                        "intensity": "799.26",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "78",
                        "monoisotopic_mass": "454.1803",
                        "monoisotopic_mz": "455.1876",
                        "intensity": "1583.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "79",
                        "monoisotopic_mass": "2453.6471",
                        "monoisotopic_mz": "1227.8308",
                        "intensity": "1395.78",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "80",
                        "monoisotopic_mass": "7840.7996",
                        "monoisotopic_mz": "1121.1215",
                        "intensity": "3270.82",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "81",
                        "monoisotopic_mass": "1739.7158",
                        "monoisotopic_mz": "870.8652",
                        "intensity": "2145.05",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1739.7131",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "ion_sort_name": "B00015",
                                "ion_left_position": "15",
                                "mass_error": "0.0027",
                                "ppm": "1.55"
                            }
                        }
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "82",
                        "monoisotopic_mass": "8989.9067",
                        "monoisotopic_mz": "1285.2797",
                        "intensity": "2380.83",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "83",
                        "monoisotopic_mass": "2146.7829",
                        "monoisotopic_mz": "1074.3987",
                        "intensity": "1254.55",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "84",
                        "monoisotopic_mass": "934.4750",
                        "monoisotopic_mz": "935.4823",
                        "intensity": "1880.16",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "85",
                        "monoisotopic_mass": "1965.8393",
                        "monoisotopic_mz": "1966.8466",
                        "intensity": "2693.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "86",
                        "monoisotopic_mass": "7031.1004",
                        "monoisotopic_mz": "1172.8573",
                        "intensity": "1300.78",
                        "charge": "6"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "87",
                        "monoisotopic_mass": "1475.1764",
                        "monoisotopic_mz": "1476.1837",
                        "intensity": "772.98",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "88",
                        "monoisotopic_mass": "1061.5152",
                        "monoisotopic_mz": "1062.5225",
                        "intensity": "1535.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "89",
                        "monoisotopic_mass": "2184.7998",
                        "monoisotopic_mz": "1093.4072",
                        "intensity": "1611.21",
                        "charge": "2"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "90",
                        "monoisotopic_mass": "1148.8420",
                        "monoisotopic_mz": "1149.8492",
                        "intensity": "1717.88",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "91",
                        "monoisotopic_mass": "9058.4524",
                        "monoisotopic_mz": "1133.3138",
                        "intensity": "1423.26",
                        "charge": "8"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "92",
                        "monoisotopic_mass": "5478.2634",
                        "monoisotopic_mz": "1096.6600",
                        "intensity": "2703.49",
                        "charge": "5"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "93",
                        "monoisotopic_mass": "8208.8779",
                        "monoisotopic_mz": "1173.7041",
                        "intensity": "1347.93",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "94",
                        "monoisotopic_mass": "1428.4131",
                        "monoisotopic_mz": "1429.4204",
                        "intensity": "792.32",
                        "charge": "1"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "95",
                        "monoisotopic_mass": "8706.3067",
                        "monoisotopic_mz": "1244.7654",
                        "intensity": "4563.93",
                        "charge": "7"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "96",
                        "monoisotopic_mass": "4909.5964",
                        "monoisotopic_mz": "1228.4064",
                        "intensity": "1518.54",
                        "charge": "4"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "97",
                        "monoisotopic_mass": "3446.8111",
                        "monoisotopic_mz": "1149.9443",
                        "intensity": "1616.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "37",
                        "peak_id": "98",
                        "monoisotopic_mass": "4357.6558",
                        "monoisotopic_mz": "1090.4212",
                        "intensity": "2125.67",
                        "charge": "4"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "37",
                                "peak_id": "73",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "9",
                                "ion_display_position": "9",
                                "spec_id": "37",
                                "peak_id": "45",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "12",
                                "ion_display_position": "12",
                                "spec_id": "37",
                                "peak_id": "30",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "13",
                                "ion_display_position": "66",
                                "spec_id": "37",
                                "peak_id": "24",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "15",
                                "ion_display_position": "15",
                                "spec_id": "37",
                                "peak_id": "81",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "37",
                                "peak_id": "53",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "33",
                                "ion_display_position": "33",
                                "spec_id": "37",
                                "peak_id": "35",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "37",
                                "peak_id": "10",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "37",
                                    "peak_id": "71",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "37",
                                    "peak_id": "16",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "spec_id": "37",
                                "peak_id": "17",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "50",
                                "ion_display_position": "29",
                                "spec_id": "37",
                                "peak_id": "37",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "66",
                                "ion_display_position": "66",
                                "spec_id": "37",
                                "peak_id": "24",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "69",
                                "ion_display_position": "69",
                                "spec_id": "37",
                                "peak_id": "50",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "37",
                                    "peak_id": "0",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "37",
                                    "peak_id": "1",
                                    "peak_charge": "8"
                                }
                            ]
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "spec_id": "37",
                                "peak_id": "7",
                                "peak_charge": "8"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
