prsm_data =
{
    "prsm": {
        "prsm_id": "19",
        "p_value": "3.77e-05",
        "e_value": "3.77e-05",
        "fdr": "0",
        "matched_fragment_number": "9",
        "matched_peak_number": "11",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "62",
                "ms1_scans": "83",
                "ids": "23",
                "scans": "87",
                "precursor_mono_mass": "9173.3825",
                "precursor_charge": "8",
                "precursor_mz": "1147.6801",
                "feature_inte": "3.1002e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "23",
                        "peak_id": "0",
                        "monoisotopic_mass": "8944.3272",
                        "monoisotopic_mz": "1278.7683",
                        "intensity": "310912.92",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "0.0001",
                                "ppm": "0.01"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "1",
                        "monoisotopic_mass": "8926.3119",
                        "monoisotopic_mz": "1276.1947",
                        "intensity": "75931.89",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "2",
                        "monoisotopic_mass": "8958.3144",
                        "monoisotopic_mz": "1280.7665",
                        "intensity": "19275.77",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "3",
                        "monoisotopic_mass": "8831.2472",
                        "monoisotopic_mz": "1262.6140",
                        "intensity": "30174.93",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "0.0041",
                                "ppm": "0.46"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "4",
                        "monoisotopic_mass": "8899.2998",
                        "monoisotopic_mz": "1272.3358",
                        "intensity": "13880.72",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "5",
                        "monoisotopic_mass": "4136.8809",
                        "monoisotopic_mz": "1379.9676",
                        "intensity": "9183.40",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4136.8781",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "ion_sort_name": "B00035",
                                "ion_left_position": "35",
                                "mass_error": "0.0029",
                                "ppm": "0.69"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "6",
                        "monoisotopic_mass": "3121.6019",
                        "monoisotopic_mz": "1561.8082",
                        "intensity": "12053.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "7",
                        "monoisotopic_mass": "3973.8087",
                        "monoisotopic_mz": "1325.6102",
                        "intensity": "11680.71",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3973.8147",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "ion_sort_name": "B00034",
                                "ion_left_position": "34",
                                "mass_error": "-0.0061",
                                "ppm": "-1.52"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "8",
                        "monoisotopic_mass": "4250.1672",
                        "monoisotopic_mz": "1417.7297",
                        "intensity": "11752.72",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "9",
                        "monoisotopic_mass": "4494.0397",
                        "monoisotopic_mz": "1124.5172",
                        "intensity": "14363.45",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4494.0429",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0032",
                                "ppm": "-0.72"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "10",
                        "monoisotopic_mass": "1278.7609",
                        "monoisotopic_mz": "1279.7682",
                        "intensity": "39837.63",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "11",
                        "monoisotopic_mass": "8832.2361",
                        "monoisotopic_mz": "1105.0368",
                        "intensity": "8156.12",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8831.2431",
                                "ion_position": "76",
                                "ion_display_position": "76",
                                "ion_sort_name": "B00076",
                                "ion_left_position": "76",
                                "mass_error": "-0.0093",
                                "ppm": "-1.06"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "12",
                        "monoisotopic_mass": "8813.2362",
                        "monoisotopic_mz": "1260.0410",
                        "intensity": "11184.17",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "13",
                        "monoisotopic_mass": "3955.8003",
                        "monoisotopic_mz": "1319.6074",
                        "intensity": "5506.65",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "14",
                        "monoisotopic_mass": "4036.0104",
                        "monoisotopic_mz": "1346.3441",
                        "intensity": "5748.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "15",
                        "monoisotopic_mass": "5564.7588",
                        "monoisotopic_mz": "1392.1970",
                        "intensity": "6462.61",
                        "charge": "4"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "16",
                        "monoisotopic_mass": "4348.2381",
                        "monoisotopic_mz": "1450.4200",
                        "intensity": "3660.54",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "17",
                        "monoisotopic_mass": "4457.1593",
                        "monoisotopic_mz": "1115.2971",
                        "intensity": "2936.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "18",
                        "monoisotopic_mass": "5368.4384",
                        "monoisotopic_mz": "1343.1169",
                        "intensity": "7363.18",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5367.4509",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "ion_sort_name": "B00047",
                                "ion_left_position": "47",
                                "mass_error": "-0.0149",
                                "ppm": "-2.77"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "19",
                        "monoisotopic_mass": "1560.1180",
                        "monoisotopic_mz": "1561.1252",
                        "intensity": "2350.84",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "20",
                        "monoisotopic_mass": "8714.2160",
                        "monoisotopic_mz": "1245.8953",
                        "intensity": "4765.73",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "21",
                        "monoisotopic_mass": "2762.2682",
                        "monoisotopic_mz": "1382.1414",
                        "intensity": "4575.51",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2762.2714",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "-0.0032",
                                "ppm": "-1.15"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "22",
                        "monoisotopic_mass": "7824.8192",
                        "monoisotopic_mz": "1305.1438",
                        "intensity": "4497.23",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "7825.7915",
                                "ion_position": "67",
                                "ion_display_position": "67",
                                "ion_sort_name": "B00067",
                                "ion_left_position": "67",
                                "mass_error": "0.0300",
                                "ppm": "3.84"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "23",
                        "monoisotopic_mass": "3645.6526",
                        "monoisotopic_mz": "1216.2248",
                        "intensity": "2867.41",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "24",
                        "monoisotopic_mass": "8945.3048",
                        "monoisotopic_mz": "1119.1704",
                        "intensity": "2176.61",
                        "charge": "8",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8944.3272",
                                "ion_position": "77",
                                "ion_display_position": "77",
                                "ion_sort_name": "B00077",
                                "ion_left_position": "77",
                                "mass_error": "-0.0247",
                                "ppm": "-2.76"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "25",
                        "monoisotopic_mass": "1233.6017",
                        "monoisotopic_mz": "1234.6090",
                        "intensity": "3234.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "26",
                        "monoisotopic_mass": "7928.8080",
                        "monoisotopic_mz": "1133.6941",
                        "intensity": "3322.48",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "27",
                        "monoisotopic_mass": "4150.1180",
                        "monoisotopic_mz": "1384.3799",
                        "intensity": "4219.80",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "28",
                        "monoisotopic_mass": "8077.9040",
                        "monoisotopic_mz": "1154.9936",
                        "intensity": "3751.80",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "29",
                        "monoisotopic_mass": "1304.6313",
                        "monoisotopic_mz": "1305.6385",
                        "intensity": "2614.56",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "30",
                        "monoisotopic_mass": "6961.4686",
                        "monoisotopic_mz": "1393.3010",
                        "intensity": "1219.08",
                        "charge": "5"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "31",
                        "monoisotopic_mass": "8926.2941",
                        "monoisotopic_mz": "1116.7940",
                        "intensity": "3178.49",
                        "charge": "8"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "32",
                        "monoisotopic_mass": "3794.9622",
                        "monoisotopic_mz": "1265.9947",
                        "intensity": "912.58",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "33",
                        "monoisotopic_mass": "2831.4105",
                        "monoisotopic_mz": "1416.7125",
                        "intensity": "4658.25",
                        "charge": "2"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "34",
                        "monoisotopic_mass": "1192.6271",
                        "monoisotopic_mz": "1193.6344",
                        "intensity": "2752.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "35",
                        "monoisotopic_mass": "3772.6944",
                        "monoisotopic_mz": "1258.5721",
                        "intensity": "2377.62",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "36",
                        "monoisotopic_mass": "8013.0864",
                        "monoisotopic_mz": "1145.7339",
                        "intensity": "2246.11",
                        "charge": "7"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "37",
                        "monoisotopic_mass": "8859.1984",
                        "monoisotopic_mz": "1266.6071",
                        "intensity": "1733.57",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8859.3108",
                                "ion_position": "3",
                                "ion_display_position": "76",
                                "ion_sort_name": "Y00076",
                                "ion_left_position": "3",
                                "mass_error": "-0.1124",
                                "ppm": "-12.69"
                            }
                        }
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "38",
                        "monoisotopic_mass": "1341.3547",
                        "monoisotopic_mz": "1342.3619",
                        "intensity": "1291.91",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "39",
                        "monoisotopic_mass": "1291.5774",
                        "monoisotopic_mz": "1292.5847",
                        "intensity": "1185.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "40",
                        "monoisotopic_mass": "4450.2782",
                        "monoisotopic_mz": "1484.4333",
                        "intensity": "3954.97",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "41",
                        "monoisotopic_mass": "1057.8118",
                        "monoisotopic_mz": "1058.8191",
                        "intensity": "1070.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "42",
                        "monoisotopic_mass": "1144.9305",
                        "monoisotopic_mz": "1145.9377",
                        "intensity": "774.05",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "43",
                        "monoisotopic_mass": "1132.1224",
                        "monoisotopic_mz": "1133.1296",
                        "intensity": "1959.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "44",
                        "monoisotopic_mass": "1116.6672",
                        "monoisotopic_mz": "1117.6744",
                        "intensity": "1990.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "45",
                        "monoisotopic_mass": "2338.5702",
                        "monoisotopic_mz": "1170.2924",
                        "intensity": "1212.39",
                        "charge": "2"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "46",
                        "monoisotopic_mass": "3122.6026",
                        "monoisotopic_mz": "1041.8748",
                        "intensity": "2986.27",
                        "charge": "3"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "47",
                        "monoisotopic_mass": "4695.1567",
                        "monoisotopic_mz": "1174.7965",
                        "intensity": "3222.57",
                        "charge": "4"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "48",
                        "monoisotopic_mass": "2517.7709",
                        "monoisotopic_mz": "1259.8927",
                        "intensity": "4253.16",
                        "charge": "2"
                    },
                    {
                        "spec_id": "23",
                        "peak_id": "49",
                        "monoisotopic_mass": "981.5112",
                        "monoisotopic_mz": "982.5184",
                        "intensity": "1024.91",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "5",
            "proteoform_id": "7",
            "sequence_name": "sp|P0AET2|HDEB_ECOLI",
            "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
            "proteoform_mass": "9173.4334",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "108",
                "first_residue_position": "29",
                "last_residue_position": "107",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "I"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "S"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "R"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "A"
                    },
                    {
                        "position": "9",
                        "acid": "F"
                    },
                    {
                        "position": "10",
                        "acid": "I"
                    },
                    {
                        "position": "11",
                        "acid": "F"
                    },
                    {
                        "position": "12",
                        "acid": "M"
                    },
                    {
                        "position": "13",
                        "acid": "G"
                    },
                    {
                        "position": "14",
                        "acid": "A"
                    },
                    {
                        "position": "15",
                        "acid": "V"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "A"
                    },
                    {
                        "position": "18",
                        "acid": "L"
                    },
                    {
                        "position": "19",
                        "acid": "S"
                    },
                    {
                        "position": "20",
                        "acid": "L"
                    },
                    {
                        "position": "21",
                        "acid": "V"
                    },
                    {
                        "position": "22",
                        "acid": "N"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "S"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "L"
                    },
                    {
                        "position": "28",
                        "acid": "A"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "N"
                    },
                    {
                        "position": "31",
                        "acid": "E"
                    },
                    {
                        "position": "32",
                        "acid": "S"
                    },
                    {
                        "position": "33",
                        "acid": "A"
                    },
                    {
                        "position": "34",
                        "acid": "K"
                    },
                    {
                        "position": "35",
                        "acid": "D"
                    },
                    {
                        "position": "36",
                        "acid": "M"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "Q"
                    },
                    {
                        "position": "40",
                        "acid": "E"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "I"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "L"
                    },
                    {
                        "position": "45",
                        "acid": "N"
                    },
                    {
                        "position": "46",
                        "acid": "P"
                    },
                    {
                        "position": "47",
                        "acid": "K"
                    },
                    {
                        "position": "48",
                        "acid": "A"
                    },
                    {
                        "position": "49",
                        "acid": "M"
                    },
                    {
                        "position": "50",
                        "acid": "T"
                    },
                    {
                        "position": "51",
                        "acid": "P"
                    },
                    {
                        "position": "52",
                        "acid": "V"
                    },
                    {
                        "position": "53",
                        "acid": "A"
                    },
                    {
                        "position": "54",
                        "acid": "W"
                    },
                    {
                        "position": "55",
                        "acid": "W"
                    },
                    {
                        "position": "56",
                        "acid": "M"
                    },
                    {
                        "position": "57",
                        "acid": "L"
                    },
                    {
                        "position": "58",
                        "acid": "H"
                    },
                    {
                        "position": "59",
                        "acid": "E"
                    },
                    {
                        "position": "60",
                        "acid": "E"
                    },
                    {
                        "position": "61",
                        "acid": "T"
                    },
                    {
                        "position": "62",
                        "acid": "V"
                    },
                    {
                        "position": "63",
                        "acid": "Y"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "G"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "T"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "T"
                    },
                    {
                        "position": "71",
                        "acid": "L"
                    },
                    {
                        "position": "72",
                        "acid": "N"
                    },
                    {
                        "position": "73",
                        "acid": "E"
                    },
                    {
                        "position": "74",
                        "acid": "T"
                    },
                    {
                        "position": "75",
                        "acid": "D"
                    },
                    {
                        "position": "76",
                        "acid": "L"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "Q"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "K"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "I"
                    },
                    {
                        "position": "84",
                        "acid": "E"
                    },
                    {
                        "position": "85",
                        "acid": "Y"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "K"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    },
                    {
                        "position": "90",
                        "acid": "P"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "K"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "L"
                    },
                    {
                        "position": "95",
                        "acid": "Y"
                    },
                    {
                        "position": "96",
                        "acid": "T"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "K"
                    },
                    {
                        "position": "99",
                        "acid": "N"
                    },
                    {
                        "position": "100",
                        "acid": "Q"
                    },
                    {
                        "position": "101",
                        "acid": "A"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "N"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "L"
                    },
                    {
                        "position": "106",
                        "acid": "P"
                    },
                    {
                        "position": "107",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "3",
                                "ion_display_position": "76",
                                "spec_id": "23",
                                "peak_id": "37",
                                "peak_charge": "7"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "23",
                                "peak_id": "21",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "34",
                                "ion_display_position": "34",
                                "spec_id": "23",
                                "peak_id": "7",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "35",
                                "ion_display_position": "35",
                                "spec_id": "23",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "23",
                                "peak_id": "9",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "47",
                                "ion_display_position": "47",
                                "spec_id": "23",
                                "peak_id": "18",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "67",
                                "ion_display_position": "67",
                                "spec_id": "23",
                                "peak_id": "22",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "23",
                                    "peak_id": "11",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "76",
                                    "ion_display_position": "76",
                                    "spec_id": "23",
                                    "peak_id": "3",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "77",
                                    "ion_display_position": "77",
                                    "spec_id": "23",
                                    "peak_id": "24",
                                    "peak_charge": "8"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "77",
                                    "ion_display_position": "77",
                                    "spec_id": "23",
                                    "peak_id": "0",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
