prsm_data =
{
    "prsm": {
        "prsm_id": "177",
        "p_value": "0.01",
        "e_value": "0.01",
        "fdr": "0",
        "matched_fragment_number": "5",
        "matched_peak_number": "7",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "134",
                "ms1_scans": "388",
                "ids": "255",
                "scans": "391",
                "precursor_mono_mass": "9528.1756",
                "precursor_charge": "12",
                "precursor_mz": "795.0219",
                "feature_inte": "2.5443e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "255",
                        "peak_id": "0",
                        "monoisotopic_mass": "4778.6208",
                        "monoisotopic_mz": "797.4441",
                        "intensity": "20107.62",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4778.6209",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0001",
                                "ppm": "-0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "1",
                        "monoisotopic_mass": "2384.2184",
                        "monoisotopic_mz": "795.7468",
                        "intensity": "14254.65",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "2",
                        "monoisotopic_mass": "4990.7754",
                        "monoisotopic_mz": "832.8032",
                        "intensity": "10350.53",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4990.7734",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "ion_sort_name": "Y00047",
                                "ion_left_position": "43",
                                "mass_error": "0.0020",
                                "ppm": "0.41"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "3",
                        "monoisotopic_mass": "4876.6872",
                        "monoisotopic_mz": "813.7885",
                        "intensity": "9329.31",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "4",
                        "monoisotopic_mass": "1429.8294",
                        "monoisotopic_mz": "715.9220",
                        "intensity": "7160.81",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "0.0001",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "5",
                        "monoisotopic_mass": "5099.8138",
                        "monoisotopic_mz": "729.5521",
                        "intensity": "5919.41",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "6",
                        "monoisotopic_mass": "5116.8314",
                        "monoisotopic_mz": "853.8125",
                        "intensity": "5408.45",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "7",
                        "monoisotopic_mass": "2809.4895",
                        "monoisotopic_mz": "703.3796",
                        "intensity": "3572.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "8",
                        "monoisotopic_mass": "1585.9714",
                        "monoisotopic_mz": "793.9930",
                        "intensity": "2564.30",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "9",
                        "monoisotopic_mass": "4255.2437",
                        "monoisotopic_mz": "1064.8182",
                        "intensity": "2109.32",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "10",
                        "monoisotopic_mass": "4239.2323",
                        "monoisotopic_mz": "1060.8154",
                        "intensity": "2561.76",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "11",
                        "monoisotopic_mass": "1857.0534",
                        "monoisotopic_mz": "929.5340",
                        "intensity": "2271.87",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "12",
                        "monoisotopic_mass": "4699.5734",
                        "monoisotopic_mz": "784.2695",
                        "intensity": "4936.93",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "13",
                        "monoisotopic_mass": "784.9877",
                        "monoisotopic_mz": "785.9950",
                        "intensity": "1351.00",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "14",
                        "monoisotopic_mass": "1969.1400",
                        "monoisotopic_mz": "985.5773",
                        "intensity": "804.82",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1969.1361",
                                "ion_position": "70",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "70",
                                "mass_error": "0.0039",
                                "ppm": "1.99"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "15",
                        "monoisotopic_mass": "2657.9554",
                        "monoisotopic_mz": "886.9924",
                        "intensity": "967.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "16",
                        "monoisotopic_mass": "5549.0437",
                        "monoisotopic_mz": "793.7278",
                        "intensity": "689.03",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "17",
                        "monoisotopic_mass": "2209.3153",
                        "monoisotopic_mz": "737.4457",
                        "intensity": "2621.92",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "18",
                        "monoisotopic_mass": "7704.9051",
                        "monoisotopic_mz": "771.4978",
                        "intensity": "1141.04",
                        "charge": "10"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "19",
                        "monoisotopic_mass": "7261.5725",
                        "monoisotopic_mz": "908.7038",
                        "intensity": "833.80",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "20",
                        "monoisotopic_mass": "6343.3282",
                        "monoisotopic_mz": "793.9233",
                        "intensity": "925.43",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "21",
                        "monoisotopic_mass": "730.8920",
                        "monoisotopic_mz": "731.8993",
                        "intensity": "1309.61",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "22",
                        "monoisotopic_mass": "4197.0192",
                        "monoisotopic_mz": "840.4111",
                        "intensity": "1294.14",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "23",
                        "monoisotopic_mass": "943.3009",
                        "monoisotopic_mz": "944.3082",
                        "intensity": "1631.39",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "24",
                        "monoisotopic_mass": "3628.4231",
                        "monoisotopic_mz": "908.1131",
                        "intensity": "846.84",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "25",
                        "monoisotopic_mass": "5916.0870",
                        "monoisotopic_mz": "987.0218",
                        "intensity": "1278.04",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "26",
                        "monoisotopic_mass": "2495.6519",
                        "monoisotopic_mz": "832.8912",
                        "intensity": "708.80",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "27",
                        "monoisotopic_mass": "7630.1376",
                        "monoisotopic_mz": "954.7745",
                        "intensity": "1435.23",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "28",
                        "monoisotopic_mass": "1807.9815",
                        "monoisotopic_mz": "904.9980",
                        "intensity": "1355.36",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "29",
                        "monoisotopic_mass": "5049.0075",
                        "monoisotopic_mz": "1010.8088",
                        "intensity": "1093.08",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "30",
                        "monoisotopic_mass": "4477.2177",
                        "monoisotopic_mz": "896.4508",
                        "intensity": "1944.30",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "31",
                        "monoisotopic_mass": "984.5674",
                        "monoisotopic_mz": "985.5747",
                        "intensity": "1215.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "32",
                        "monoisotopic_mass": "3460.9998",
                        "monoisotopic_mz": "866.2572",
                        "intensity": "816.85",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "33",
                        "monoisotopic_mass": "2398.8183",
                        "monoisotopic_mz": "800.6134",
                        "intensity": "2043.53",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "34",
                        "monoisotopic_mass": "3390.7013",
                        "monoisotopic_mz": "848.6826",
                        "intensity": "2328.51",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "35",
                        "monoisotopic_mass": "8710.0488",
                        "monoisotopic_mz": "792.8299",
                        "intensity": "711.98",
                        "charge": "11"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "36",
                        "monoisotopic_mass": "967.4937",
                        "monoisotopic_mz": "968.5010",
                        "intensity": "1174.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "37",
                        "monoisotopic_mass": "3873.9989",
                        "monoisotopic_mz": "775.8071",
                        "intensity": "807.27",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "38",
                        "monoisotopic_mass": "2352.4544",
                        "monoisotopic_mz": "785.1587",
                        "intensity": "746.62",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "39",
                        "monoisotopic_mass": "7143.9814",
                        "monoisotopic_mz": "794.7830",
                        "intensity": "4530.24",
                        "charge": "9"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "40",
                        "monoisotopic_mass": "5904.9918",
                        "monoisotopic_mz": "844.5775",
                        "intensity": "2008.32",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "41",
                        "monoisotopic_mass": "860.1551",
                        "monoisotopic_mz": "861.1624",
                        "intensity": "972.11",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "42",
                        "monoisotopic_mass": "1567.9605",
                        "monoisotopic_mz": "784.9875",
                        "intensity": "1681.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "43",
                        "monoisotopic_mass": "5871.8352",
                        "monoisotopic_mz": "979.6465",
                        "intensity": "1087.08",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "44",
                        "monoisotopic_mass": "5657.1770",
                        "monoisotopic_mz": "943.8701",
                        "intensity": "899.33",
                        "charge": "6"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "45",
                        "monoisotopic_mass": "815.8463",
                        "monoisotopic_mz": "816.8536",
                        "intensity": "986.74",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "46",
                        "monoisotopic_mass": "3265.4682",
                        "monoisotopic_mz": "817.3743",
                        "intensity": "2613.63",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "47",
                        "monoisotopic_mass": "7505.1398",
                        "monoisotopic_mz": "939.1497",
                        "intensity": "1187.27",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "48",
                        "monoisotopic_mass": "3916.3704",
                        "monoisotopic_mz": "784.2814",
                        "intensity": "782.30",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "49",
                        "monoisotopic_mass": "3348.7847",
                        "monoisotopic_mz": "838.2035",
                        "intensity": "958.64",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "50",
                        "monoisotopic_mass": "7693.9757",
                        "monoisotopic_mz": "962.7542",
                        "intensity": "1064.36",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "51",
                        "monoisotopic_mass": "6160.2863",
                        "monoisotopic_mz": "771.0431",
                        "intensity": "1154.00",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "52",
                        "monoisotopic_mass": "6142.1235",
                        "monoisotopic_mz": "878.4535",
                        "intensity": "1381.30",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "53",
                        "monoisotopic_mass": "902.4619",
                        "monoisotopic_mz": "903.4692",
                        "intensity": "1016.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "54",
                        "monoisotopic_mass": "755.4086",
                        "monoisotopic_mz": "756.4158",
                        "intensity": "1064.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "55",
                        "monoisotopic_mass": "930.4662",
                        "monoisotopic_mz": "931.4734",
                        "intensity": "1561.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "56",
                        "monoisotopic_mass": "829.2729",
                        "monoisotopic_mz": "830.2801",
                        "intensity": "1352.01",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "57",
                        "monoisotopic_mass": "876.4697",
                        "monoisotopic_mz": "877.4769",
                        "intensity": "1329.73",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "58",
                        "monoisotopic_mass": "1429.8278",
                        "monoisotopic_mz": "477.6165",
                        "intensity": "1132.24",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0015",
                                "ppm": "-1.07"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "59",
                        "monoisotopic_mass": "5418.7106",
                        "monoisotopic_mz": "775.1088",
                        "intensity": "2211.38",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "60",
                        "monoisotopic_mass": "4728.6388",
                        "monoisotopic_mz": "946.7350",
                        "intensity": "1868.33",
                        "charge": "5"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "61",
                        "monoisotopic_mass": "3413.9700",
                        "monoisotopic_mz": "854.4998",
                        "intensity": "1988.62",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "62",
                        "monoisotopic_mass": "1461.2532",
                        "monoisotopic_mz": "731.6339",
                        "intensity": "664.79",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "63",
                        "monoisotopic_mass": "1429.8284",
                        "monoisotopic_mz": "1430.8357",
                        "intensity": "1625.35",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1429.8293",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0009",
                                "ppm": "-0.64"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "64",
                        "monoisotopic_mass": "5569.5225",
                        "monoisotopic_mz": "796.6533",
                        "intensity": "832.53",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "65",
                        "monoisotopic_mass": "7479.0571",
                        "monoisotopic_mz": "832.0136",
                        "intensity": "960.15",
                        "charge": "9"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "66",
                        "monoisotopic_mass": "6259.8534",
                        "monoisotopic_mz": "895.2720",
                        "intensity": "1719.57",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "67",
                        "monoisotopic_mass": "2776.3937",
                        "monoisotopic_mz": "926.4718",
                        "intensity": "1054.83",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "68",
                        "monoisotopic_mass": "9257.3188",
                        "monoisotopic_mz": "926.7392",
                        "intensity": "2588.66",
                        "charge": "10"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "69",
                        "monoisotopic_mass": "4311.2509",
                        "monoisotopic_mz": "863.2575",
                        "intensity": "1871.22",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4311.2883",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "-0.0375",
                                "ppm": "-8.69"
                            }
                        }
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "70",
                        "monoisotopic_mass": "2699.7712",
                        "monoisotopic_mz": "900.9310",
                        "intensity": "3040.95",
                        "charge": "3"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "71",
                        "monoisotopic_mass": "1474.0389",
                        "monoisotopic_mz": "738.0267",
                        "intensity": "696.56",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "72",
                        "monoisotopic_mass": "9405.0800",
                        "monoisotopic_mz": "784.7639",
                        "intensity": "927.94",
                        "charge": "12"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "73",
                        "monoisotopic_mass": "3235.2822",
                        "monoisotopic_mz": "809.8278",
                        "intensity": "820.12",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "74",
                        "monoisotopic_mass": "9508.1128",
                        "monoisotopic_mz": "793.3500",
                        "intensity": "1811.40",
                        "charge": "12"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "75",
                        "monoisotopic_mass": "3907.0201",
                        "monoisotopic_mz": "977.7623",
                        "intensity": "1547.47",
                        "charge": "4"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "76",
                        "monoisotopic_mass": "7552.5455",
                        "monoisotopic_mz": "945.0755",
                        "intensity": "1064.33",
                        "charge": "8"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "77",
                        "monoisotopic_mass": "1064.0618",
                        "monoisotopic_mz": "1065.0691",
                        "intensity": "805.65",
                        "charge": "1"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "78",
                        "monoisotopic_mass": "5973.6913",
                        "monoisotopic_mz": "854.3917",
                        "intensity": "1462.31",
                        "charge": "7"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "79",
                        "monoisotopic_mass": "1637.8861",
                        "monoisotopic_mz": "819.9503",
                        "intensity": "1723.78",
                        "charge": "2"
                    },
                    {
                        "spec_id": "255",
                        "peak_id": "80",
                        "monoisotopic_mass": "3615.5219",
                        "monoisotopic_mz": "904.8878",
                        "intensity": "941.94",
                        "charge": "4"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "4",
            "proteoform_id": "4",
            "sequence_name": "sp|P0ACF0|DBHA_ECOLI",
            "sequence_description": "DNA-binding protein HU-alpha OS=Escherichia coli (strain K12) OX=83333 GN=hupA PE=1 SV=1",
            "proteoform_mass": "9529.1887",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "T"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "V"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "E"
                    },
                    {
                        "position": "15",
                        "acid": "L"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "Q"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "K"
                    },
                    {
                        "position": "22",
                        "acid": "A"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "E"
                    },
                    {
                        "position": "26",
                        "acid": "S"
                    },
                    {
                        "position": "27",
                        "acid": "T"
                    },
                    {
                        "position": "28",
                        "acid": "L"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "A"
                    },
                    {
                        "position": "31",
                        "acid": "I"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "A"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "Q"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "K"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "N"
                    },
                    {
                        "position": "53",
                        "acid": "H"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "E"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "K"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "N"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "A"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "V"
                    },
                    {
                        "position": "80",
                        "acid": "S"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "K"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "255",
                                "peak_id": "69",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "spec_id": "255",
                                "peak_id": "2",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "spec_id": "255",
                                "peak_id": "0",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "70",
                                "ion_display_position": "20",
                                "spec_id": "255",
                                "peak_id": "14",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "255",
                                    "peak_id": "58",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "255",
                                    "peak_id": "63",
                                    "peak_charge": "1"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "76",
                                    "ion_display_position": "14",
                                    "spec_id": "255",
                                    "peak_id": "4",
                                    "peak_charge": "2"
                                }
                            ]
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
