prsm_data =
{
    "prsm": {
        "prsm_id": "15",
        "p_value": "3.30e-14",
        "e_value": "3.30e-14",
        "fdr": "0",
        "matched_fragment_number": "19",
        "matched_peak_number": "21",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "60",
                "ms1_scans": "77",
                "ids": "18",
                "scans": "80",
                "precursor_mono_mass": "9848.8263",
                "precursor_charge": "9",
                "precursor_mz": "1095.3213",
                "feature_inte": "1.3385e+09"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "18",
                        "peak_id": "0",
                        "monoisotopic_mass": "3518.8008",
                        "monoisotopic_mz": "1173.9409",
                        "intensity": "34804.40",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0006",
                                "ppm": "-0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "1",
                        "monoisotopic_mass": "3619.8490",
                        "monoisotopic_mz": "1207.6236",
                        "intensity": "29032.93",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0001",
                                "ppm": "-0.04"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "2",
                        "monoisotopic_mass": "3891.0040",
                        "monoisotopic_mz": "1298.0086",
                        "intensity": "30512.37",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3891.0023",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "ion_sort_name": "Y00034",
                                "ion_left_position": "55",
                                "mass_error": "0.0017",
                                "ppm": "0.43"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "3",
                        "monoisotopic_mass": "3819.9660",
                        "monoisotopic_mz": "1274.3293",
                        "intensity": "24966.26",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3819.9652",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "ion_sort_name": "Y00033",
                                "ion_left_position": "56",
                                "mass_error": "0.0008",
                                "ppm": "0.22"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "4",
                        "monoisotopic_mass": "6583.3754",
                        "monoisotopic_mz": "1317.6824",
                        "intensity": "28234.38",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6583.3731",
                                "ion_position": "29",
                                "ion_display_position": "60",
                                "ion_sort_name": "Y00060",
                                "ion_left_position": "29",
                                "mass_error": "0.0023",
                                "ppm": "0.35"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "5",
                        "monoisotopic_mass": "4061.1086",
                        "monoisotopic_mz": "1354.7101",
                        "intensity": "15128.03",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4061.1078",
                                "ion_position": "53",
                                "ion_display_position": "36",
                                "ion_sort_name": "Y00036",
                                "ion_left_position": "53",
                                "mass_error": "0.0007",
                                "ppm": "0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "6",
                        "monoisotopic_mass": "6565.3674",
                        "monoisotopic_mz": "1314.0808",
                        "intensity": "13150.23",
                        "charge": "5"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "7",
                        "monoisotopic_mass": "2522.2665",
                        "monoisotopic_mz": "1262.1405",
                        "intensity": "8490.92",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "8",
                        "monoisotopic_mass": "2560.2022",
                        "monoisotopic_mz": "854.4080",
                        "intensity": "8626.13",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "0.0006",
                                "ppm": "0.22"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "9",
                        "monoisotopic_mass": "4043.1020",
                        "monoisotopic_mz": "1348.7079",
                        "intensity": "7440.07",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "10",
                        "monoisotopic_mass": "3872.9909",
                        "monoisotopic_mz": "1292.0042",
                        "intensity": "10521.37",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "11",
                        "monoisotopic_mass": "3265.5036",
                        "monoisotopic_mz": "1089.5085",
                        "intensity": "8522.84",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3265.4986",
                                "ion_position": "29",
                                "ion_display_position": "29",
                                "ion_sort_name": "B00029",
                                "ion_left_position": "29",
                                "mass_error": "0.0050",
                                "ppm": "1.53"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "12",
                        "monoisotopic_mass": "2659.2694",
                        "monoisotopic_mz": "887.4304",
                        "intensity": "6644.63",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "-0.0006",
                                "ppm": "-0.24"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "13",
                        "monoisotopic_mass": "2394.2052",
                        "monoisotopic_mz": "1198.1099",
                        "intensity": "5075.26",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "14",
                        "monoisotopic_mass": "2775.2988",
                        "monoisotopic_mz": "926.1069",
                        "intensity": "6206.69",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "15",
                        "monoisotopic_mass": "3518.8005",
                        "monoisotopic_mz": "880.7074",
                        "intensity": "8030.33",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "-0.0009",
                                "ppm": "-0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "16",
                        "monoisotopic_mass": "3718.9168",
                        "monoisotopic_mz": "1240.6462",
                        "intensity": "11234.51",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3718.9175",
                                "ion_position": "57",
                                "ion_display_position": "32",
                                "ion_sort_name": "Y00032",
                                "ion_left_position": "57",
                                "mass_error": "-0.0008",
                                "ppm": "-0.20"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "17",
                        "monoisotopic_mass": "2763.4088",
                        "monoisotopic_mz": "1382.7117",
                        "intensity": "5589.28",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "18",
                        "monoisotopic_mass": "2489.1642",
                        "monoisotopic_mz": "1245.5894",
                        "intensity": "5934.51",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "-0.0003",
                                "ppm": "-0.13"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "19",
                        "monoisotopic_mass": "2692.3761",
                        "monoisotopic_mz": "1347.1953",
                        "intensity": "5259.64",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "20",
                        "monoisotopic_mass": "2559.2043",
                        "monoisotopic_mz": "1280.6094",
                        "intensity": "6166.93",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "21",
                        "monoisotopic_mass": "4171.1458",
                        "monoisotopic_mz": "1391.3892",
                        "intensity": "6375.15",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "22",
                        "monoisotopic_mass": "2578.2876",
                        "monoisotopic_mz": "1290.1511",
                        "intensity": "4667.99",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "23",
                        "monoisotopic_mass": "4171.1451",
                        "monoisotopic_mz": "1043.7935",
                        "intensity": "5250.05",
                        "charge": "4"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "24",
                        "monoisotopic_mass": "2845.4512",
                        "monoisotopic_mz": "1423.7329",
                        "intensity": "4089.28",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "25",
                        "monoisotopic_mass": "4005.0834",
                        "monoisotopic_mz": "1336.0351",
                        "intensity": "4500.30",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "26",
                        "monoisotopic_mass": "2294.1382",
                        "monoisotopic_mz": "1148.0764",
                        "intensity": "3596.57",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "27",
                        "monoisotopic_mass": "770.3558",
                        "monoisotopic_mz": "771.3630",
                        "intensity": "7706.05",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0001",
                                "ppm": "-0.16"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "28",
                        "monoisotopic_mass": "2435.2990",
                        "monoisotopic_mz": "1218.6568",
                        "intensity": "4671.55",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2435.2995",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "69",
                                "mass_error": "-0.0006",
                                "ppm": "-0.23"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "29",
                        "monoisotopic_mass": "2376.0810",
                        "monoisotopic_mz": "1189.0478",
                        "intensity": "2914.47",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "0.0005",
                                "ppm": "0.21"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "30",
                        "monoisotopic_mass": "2658.2681",
                        "monoisotopic_mz": "1330.1413",
                        "intensity": "3763.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "31",
                        "monoisotopic_mass": "829.7214",
                        "monoisotopic_mz": "830.7286",
                        "intensity": "2974.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "32",
                        "monoisotopic_mass": "2990.3701",
                        "monoisotopic_mz": "997.7973",
                        "intensity": "6130.63",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2990.3716",
                                "ion_position": "27",
                                "ion_display_position": "27",
                                "ion_sort_name": "B00027",
                                "ion_left_position": "27",
                                "mass_error": "-0.0016",
                                "ppm": "-0.52"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "33",
                        "monoisotopic_mass": "2541.1872",
                        "monoisotopic_mz": "848.0697",
                        "intensity": "3835.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "34",
                        "monoisotopic_mass": "4189.1714",
                        "monoisotopic_mz": "1397.3978",
                        "intensity": "4967.87",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4189.1664",
                                "ion_position": "52",
                                "ion_display_position": "37",
                                "ion_sort_name": "Y00037",
                                "ion_left_position": "52",
                                "mass_error": "0.0050",
                                "ppm": "1.20"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "35",
                        "monoisotopic_mass": "3370.7560",
                        "monoisotopic_mz": "1124.5926",
                        "intensity": "3104.34",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "36",
                        "monoisotopic_mass": "3500.7825",
                        "monoisotopic_mz": "1167.9348",
                        "intensity": "7080.76",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "37",
                        "monoisotopic_mass": "3800.9535",
                        "monoisotopic_mz": "1267.9918",
                        "intensity": "4683.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "38",
                        "monoisotopic_mass": "3619.8441",
                        "monoisotopic_mz": "905.9683",
                        "intensity": "6487.36",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3619.8491",
                                "ion_position": "58",
                                "ion_display_position": "31",
                                "ion_sort_name": "Y00031",
                                "ion_left_position": "58",
                                "mass_error": "-0.0050",
                                "ppm": "-1.38"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "39",
                        "monoisotopic_mass": "1093.6652",
                        "monoisotopic_mz": "1094.6725",
                        "intensity": "2379.24",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "40",
                        "monoisotopic_mass": "6857.4841",
                        "monoisotopic_mz": "1372.5041",
                        "intensity": "2635.74",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "6858.5001",
                                "ion_position": "27",
                                "ion_display_position": "62",
                                "ion_sort_name": "Y00062",
                                "ion_left_position": "27",
                                "mass_error": "-0.0137",
                                "ppm": "-2.00"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "41",
                        "monoisotopic_mass": "3138.4423",
                        "monoisotopic_mz": "1047.1547",
                        "intensity": "2797.08",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "42",
                        "monoisotopic_mass": "4152.1149",
                        "monoisotopic_mz": "1385.0456",
                        "intensity": "1341.74",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "43",
                        "monoisotopic_mass": "2641.2577",
                        "monoisotopic_mz": "881.4265",
                        "intensity": "2882.87",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "44",
                        "monoisotopic_mass": "2022.0504",
                        "monoisotopic_mz": "1012.0325",
                        "intensity": "1028.87",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "45",
                        "monoisotopic_mass": "3470.8092",
                        "monoisotopic_mz": "1157.9437",
                        "intensity": "2388.37",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "46",
                        "monoisotopic_mass": "2188.7919",
                        "monoisotopic_mz": "1095.4032",
                        "intensity": "3521.01",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "47",
                        "monoisotopic_mass": "479.2378",
                        "monoisotopic_mz": "480.2451",
                        "intensity": "1117.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "48",
                        "monoisotopic_mass": "2902.3406",
                        "monoisotopic_mz": "968.4542",
                        "intensity": "2746.42",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "49",
                        "monoisotopic_mass": "1140.5881",
                        "monoisotopic_mz": "1141.5953",
                        "intensity": "1006.29",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1140.5887",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "-0.0007",
                                "ppm": "-0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "50",
                        "monoisotopic_mass": "1249.6187",
                        "monoisotopic_mz": "1250.6260",
                        "intensity": "867.81",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "51",
                        "monoisotopic_mass": "3873.9882",
                        "monoisotopic_mz": "969.5043",
                        "intensity": "2194.94",
                        "charge": "4"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "52",
                        "monoisotopic_mass": "6547.3585",
                        "monoisotopic_mz": "1310.4790",
                        "intensity": "860.69",
                        "charge": "5"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "53",
                        "monoisotopic_mass": "3247.4813",
                        "monoisotopic_mz": "1083.5010",
                        "intensity": "3254.52",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "54",
                        "monoisotopic_mass": "1005.8987",
                        "monoisotopic_mz": "1006.9060",
                        "intensity": "784.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "55",
                        "monoisotopic_mass": "1236.1158",
                        "monoisotopic_mz": "1237.1230",
                        "intensity": "792.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "56",
                        "monoisotopic_mass": "9520.8172",
                        "monoisotopic_mz": "1058.8759",
                        "intensity": "1447.47",
                        "charge": "9"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "57",
                        "monoisotopic_mass": "7442.3705",
                        "monoisotopic_mz": "1064.2031",
                        "intensity": "835.43",
                        "charge": "7"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "58",
                        "monoisotopic_mass": "982.5083",
                        "monoisotopic_mz": "983.5156",
                        "intensity": "1471.19",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "59",
                        "monoisotopic_mass": "655.3292",
                        "monoisotopic_mz": "656.3365",
                        "intensity": "1572.93",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "655.3289",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "ion_sort_name": "B00007",
                                "ion_left_position": "7",
                                "mass_error": "0.0003",
                                "ppm": "0.41"
                            }
                        }
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "60",
                        "monoisotopic_mass": "3112.5721",
                        "monoisotopic_mz": "1038.5313",
                        "intensity": "2172.28",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "61",
                        "monoisotopic_mass": "1019.3525",
                        "monoisotopic_mz": "1020.3598",
                        "intensity": "1409.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "62",
                        "monoisotopic_mass": "2525.1560",
                        "monoisotopic_mz": "842.7259",
                        "intensity": "902.60",
                        "charge": "3"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "63",
                        "monoisotopic_mass": "949.4859",
                        "monoisotopic_mz": "950.4932",
                        "intensity": "744.21",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "64",
                        "monoisotopic_mass": "1330.6778",
                        "monoisotopic_mz": "1331.6851",
                        "intensity": "629.37",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "65",
                        "monoisotopic_mass": "5334.8358",
                        "monoisotopic_mz": "1067.9744",
                        "intensity": "928.39",
                        "charge": "5"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "66",
                        "monoisotopic_mass": "3792.8665",
                        "monoisotopic_mz": "949.2239",
                        "intensity": "1268.53",
                        "charge": "4"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "67",
                        "monoisotopic_mass": "1039.5362",
                        "monoisotopic_mz": "1040.5435",
                        "intensity": "708.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "68",
                        "monoisotopic_mass": "1186.0101",
                        "monoisotopic_mz": "1187.0173",
                        "intensity": "1254.89",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "69",
                        "monoisotopic_mass": "6225.1090",
                        "monoisotopic_mz": "1246.0291",
                        "intensity": "1047.40",
                        "charge": "5"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "70",
                        "monoisotopic_mass": "1125.1812",
                        "monoisotopic_mz": "1126.1885",
                        "intensity": "602.77",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "71",
                        "monoisotopic_mass": "5944.7163",
                        "monoisotopic_mz": "991.7933",
                        "intensity": "4410.52",
                        "charge": "6"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "72",
                        "monoisotopic_mass": "1107.5782",
                        "monoisotopic_mz": "1108.5854",
                        "intensity": "880.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "73",
                        "monoisotopic_mass": "2677.3446",
                        "monoisotopic_mz": "1339.6796",
                        "intensity": "1986.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "74",
                        "monoisotopic_mass": "6074.0241",
                        "monoisotopic_mz": "1215.8121",
                        "intensity": "2119.87",
                        "charge": "5"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "75",
                        "monoisotopic_mass": "2247.1640",
                        "monoisotopic_mz": "1124.5893",
                        "intensity": "729.25",
                        "charge": "2"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "76",
                        "monoisotopic_mass": "7751.8952",
                        "monoisotopic_mz": "1292.9898",
                        "intensity": "1249.40",
                        "charge": "6"
                    },
                    {
                        "spec_id": "18",
                        "peak_id": "77",
                        "monoisotopic_mass": "6055.9789",
                        "monoisotopic_mz": "1010.3371",
                        "intensity": "2432.31",
                        "charge": "6"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "0",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9848.8717",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "spec_id": "18",
                                "peak_id": "59",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "18",
                                "peak_id": "27",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "18",
                                "peak_id": "49",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "spec_id": "18",
                                "peak_id": "29",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "18",
                                "peak_id": "18",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "spec_id": "18",
                                "peak_id": "8",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "spec_id": "18",
                                "peak_id": "12",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "27",
                                    "ion_display_position": "27",
                                    "spec_id": "18",
                                    "peak_id": "32",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "27",
                                    "ion_display_position": "62",
                                    "spec_id": "18",
                                    "peak_id": "40",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "1",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "29",
                                    "ion_display_position": "29",
                                    "spec_id": "18",
                                    "peak_id": "11",
                                    "peak_charge": "3"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "29",
                                    "ion_display_position": "60",
                                    "spec_id": "18",
                                    "peak_id": "4",
                                    "peak_charge": "5"
                                }
                            ]
                        }
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "52",
                                "ion_display_position": "37",
                                "spec_id": "18",
                                "peak_id": "34",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "53",
                                "ion_display_position": "36",
                                "spec_id": "18",
                                "peak_id": "5",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "55",
                                "ion_display_position": "34",
                                "spec_id": "18",
                                "peak_id": "2",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "spec_id": "18",
                                "peak_id": "3",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "57",
                                "ion_display_position": "32",
                                "spec_id": "18",
                                "peak_id": "16",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "18",
                                    "peak_id": "38",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "58",
                                    "ion_display_position": "31",
                                    "spec_id": "18",
                                    "peak_id": "1",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "18",
                                    "peak_id": "15",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "59",
                                    "ion_display_position": "30",
                                    "spec_id": "18",
                                    "peak_id": "0",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "spec_id": "18",
                                "peak_id": "28",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                }
            }
        }
    }
}
