prsm_data =
{
    "prsm": {
        "prsm_id": "145",
        "p_value": "1.17e-04",
        "e_value": "1.17e-04",
        "fdr": "0",
        "matched_fragment_number": "9",
        "matched_peak_number": "12",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "120",
                "ms1_scans": "327",
                "ids": "206",
                "scans": "328",
                "precursor_mono_mass": "9221.9673",
                "precursor_charge": "13",
                "precursor_mz": "710.3894",
                "feature_inte": "3.0048e+06"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "206",
                        "peak_id": "0",
                        "monoisotopic_mass": "4699.5760",
                        "monoisotopic_mz": "784.2699",
                        "intensity": "35262.72",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4699.5787",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "-0.0027",
                                "ppm": "-0.58"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "1",
                        "monoisotopic_mass": "4798.6448",
                        "monoisotopic_mz": "800.7814",
                        "intensity": "15505.48",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4798.6471",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "ion_sort_name": "Y00046",
                                "ion_left_position": "44",
                                "mass_error": "-0.0023",
                                "ppm": "-0.48"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "2",
                        "monoisotopic_mass": "4567.5324",
                        "monoisotopic_mz": "762.2627",
                        "intensity": "10921.15",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "3",
                        "monoisotopic_mass": "4495.4877",
                        "monoisotopic_mz": "750.2552",
                        "intensity": "11642.77",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4495.4888",
                                "ion_position": "47",
                                "ion_display_position": "43",
                                "ion_sort_name": "Y00043",
                                "ion_left_position": "47",
                                "mass_error": "-0.0011",
                                "ppm": "-0.25"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "4",
                        "monoisotopic_mass": "4699.5792",
                        "monoisotopic_mz": "672.3757",
                        "intensity": "13034.81",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4699.5787",
                                "ion_position": "45",
                                "ion_display_position": "45",
                                "ion_sort_name": "Y00045",
                                "ion_left_position": "45",
                                "mass_error": "0.0005",
                                "ppm": "0.11"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "5",
                        "monoisotopic_mass": "2793.5161",
                        "monoisotopic_mz": "932.1793",
                        "intensity": "7109.77",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2793.5171",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "-0.0010",
                                "ppm": "-0.35"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "6",
                        "monoisotopic_mass": "4911.7270",
                        "monoisotopic_mz": "819.6284",
                        "intensity": "7747.37",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4911.7312",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "ion_sort_name": "Y00047",
                                "ion_left_position": "43",
                                "mass_error": "-0.0042",
                                "ppm": "-0.86"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "7",
                        "monoisotopic_mass": "1472.8097",
                        "monoisotopic_mz": "737.4121",
                        "intensity": "7688.15",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1472.8100",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "ion_sort_name": "Y00014",
                                "ion_left_position": "76",
                                "mass_error": "-0.0003",
                                "ppm": "-0.22"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "8",
                        "monoisotopic_mass": "4682.5549",
                        "monoisotopic_mz": "781.4331",
                        "intensity": "6919.76",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "9",
                        "monoisotopic_mass": "4798.6426",
                        "monoisotopic_mz": "686.5276",
                        "intensity": "6757.99",
                        "charge": "7",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4798.6471",
                                "ion_position": "44",
                                "ion_display_position": "46",
                                "ion_sort_name": "Y00046",
                                "ion_left_position": "44",
                                "mass_error": "-0.0045",
                                "ppm": "-0.94"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "10",
                        "monoisotopic_mass": "4138.1562",
                        "monoisotopic_mz": "1035.5463",
                        "intensity": "4084.38",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4138.1580",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "ion_sort_name": "B00041",
                                "ion_left_position": "41",
                                "mass_error": "-0.0017",
                                "ppm": "-0.42"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "11",
                        "monoisotopic_mass": "4642.5566",
                        "monoisotopic_mz": "774.7667",
                        "intensity": "8942.42",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4642.5572",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "ion_sort_name": "Y00044",
                                "ion_left_position": "46",
                                "mass_error": "-0.0007",
                                "ppm": "-0.14"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "12",
                        "monoisotopic_mass": "4477.4669",
                        "monoisotopic_mz": "747.2518",
                        "intensity": "5787.37",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "13",
                        "monoisotopic_mass": "1455.7818",
                        "monoisotopic_mz": "728.8982",
                        "intensity": "2291.02",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "14",
                        "monoisotopic_mass": "3045.6510",
                        "monoisotopic_mz": "1016.2243",
                        "intensity": "2747.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "15",
                        "monoisotopic_mass": "3225.7650",
                        "monoisotopic_mz": "807.4485",
                        "intensity": "3517.54",
                        "charge": "4"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "16",
                        "monoisotopic_mass": "2181.2094",
                        "monoisotopic_mz": "728.0771",
                        "intensity": "2564.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "17",
                        "monoisotopic_mass": "3021.6763",
                        "monoisotopic_mz": "756.4264",
                        "intensity": "1113.55",
                        "charge": "4"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "18",
                        "monoisotopic_mass": "2490.8785",
                        "monoisotopic_mz": "831.3001",
                        "intensity": "908.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "19",
                        "monoisotopic_mass": "698.3650",
                        "monoisotopic_mz": "699.3723",
                        "intensity": "1052.36",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "20",
                        "monoisotopic_mass": "6870.5690",
                        "monoisotopic_mz": "764.4038",
                        "intensity": "1033.23",
                        "charge": "9"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "21",
                        "monoisotopic_mass": "4982.4455",
                        "monoisotopic_mz": "712.7852",
                        "intensity": "1205.56",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "22",
                        "monoisotopic_mass": "8751.9353",
                        "monoisotopic_mz": "876.2008",
                        "intensity": "1030.91",
                        "charge": "10"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "23",
                        "monoisotopic_mass": "7912.9935",
                        "monoisotopic_mz": "720.3703",
                        "intensity": "977.96",
                        "charge": "11"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "24",
                        "monoisotopic_mass": "3591.9524",
                        "monoisotopic_mz": "719.3978",
                        "intensity": "2366.14",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "25",
                        "monoisotopic_mass": "5714.0285",
                        "monoisotopic_mz": "715.2608",
                        "intensity": "1167.60",
                        "charge": "8"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "26",
                        "monoisotopic_mass": "4509.5016",
                        "monoisotopic_mz": "752.5909",
                        "intensity": "2325.69",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "27",
                        "monoisotopic_mass": "2976.8408",
                        "monoisotopic_mz": "745.2175",
                        "intensity": "1329.66",
                        "charge": "4"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "28",
                        "monoisotopic_mass": "5618.4408",
                        "monoisotopic_mz": "803.6417",
                        "intensity": "1122.51",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "29",
                        "monoisotopic_mass": "746.9123",
                        "monoisotopic_mz": "747.9196",
                        "intensity": "1957.90",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "30",
                        "monoisotopic_mass": "7095.3535",
                        "monoisotopic_mz": "710.5426",
                        "intensity": "1987.20",
                        "charge": "10"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "31",
                        "monoisotopic_mass": "7381.2984",
                        "monoisotopic_mz": "821.1515",
                        "intensity": "830.31",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "2.2476634787",
                                "theoretical_mass": "7380.1948",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "ion_sort_name": "B00072",
                                "ion_left_position": "72",
                                "mass_error": "0.1013",
                                "ppm": "13.73"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "32",
                        "monoisotopic_mass": "777.9328",
                        "monoisotopic_mz": "778.9401",
                        "intensity": "1091.30",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "33",
                        "monoisotopic_mass": "4336.4016",
                        "monoisotopic_mz": "723.7409",
                        "intensity": "1687.25",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "34",
                        "monoisotopic_mass": "831.4582",
                        "monoisotopic_mz": "832.4655",
                        "intensity": "840.42",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "35",
                        "monoisotopic_mass": "1340.7561",
                        "monoisotopic_mz": "671.3853",
                        "intensity": "1173.62",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "36",
                        "monoisotopic_mass": "2159.2071",
                        "monoisotopic_mz": "720.7430",
                        "intensity": "774.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "37",
                        "monoisotopic_mass": "818.7585",
                        "monoisotopic_mz": "819.7657",
                        "intensity": "1154.15",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "38",
                        "monoisotopic_mass": "5391.0963",
                        "monoisotopic_mz": "674.8943",
                        "intensity": "894.02",
                        "charge": "8"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "39",
                        "monoisotopic_mass": "4641.5220",
                        "monoisotopic_mz": "664.0818",
                        "intensity": "1129.08",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "40",
                        "monoisotopic_mass": "3999.9528",
                        "monoisotopic_mz": "800.9978",
                        "intensity": "959.61",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "41",
                        "monoisotopic_mass": "2810.5143",
                        "monoisotopic_mz": "937.8454",
                        "intensity": "1363.04",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "42",
                        "monoisotopic_mass": "9137.3031",
                        "monoisotopic_mz": "831.6712",
                        "intensity": "640.53",
                        "charge": "11"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "43",
                        "monoisotopic_mass": "8037.1428",
                        "monoisotopic_mz": "731.6566",
                        "intensity": "1037.31",
                        "charge": "11"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "44",
                        "monoisotopic_mass": "5680.9673",
                        "monoisotopic_mz": "711.1282",
                        "intensity": "1717.20",
                        "charge": "8"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "45",
                        "monoisotopic_mass": "3607.6178",
                        "monoisotopic_mz": "722.5308",
                        "intensity": "946.06",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "46",
                        "monoisotopic_mass": "8712.4926",
                        "monoisotopic_mz": "793.0521",
                        "intensity": "858.06",
                        "charge": "11"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "47",
                        "monoisotopic_mass": "4951.4249",
                        "monoisotopic_mz": "708.3537",
                        "intensity": "2402.02",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "48",
                        "monoisotopic_mass": "893.8116",
                        "monoisotopic_mz": "894.8189",
                        "intensity": "1698.17",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "49",
                        "monoisotopic_mass": "1308.6963",
                        "monoisotopic_mz": "655.3554",
                        "intensity": "599.22",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "50",
                        "monoisotopic_mass": "974.4186",
                        "monoisotopic_mz": "975.4258",
                        "intensity": "2169.50",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "51",
                        "monoisotopic_mass": "7740.0697",
                        "monoisotopic_mz": "704.6500",
                        "intensity": "2259.14",
                        "charge": "11"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "52",
                        "monoisotopic_mass": "1431.7447",
                        "monoisotopic_mz": "716.8796",
                        "intensity": "694.10",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "53",
                        "monoisotopic_mass": "4283.9129",
                        "monoisotopic_mz": "714.9928",
                        "intensity": "779.79",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "54",
                        "monoisotopic_mass": "1415.9935",
                        "monoisotopic_mz": "709.0040",
                        "intensity": "1786.15",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "55",
                        "monoisotopic_mass": "4681.5665",
                        "monoisotopic_mz": "669.8025",
                        "intensity": "5044.03",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "56",
                        "monoisotopic_mass": "3986.1958",
                        "monoisotopic_mz": "798.2464",
                        "intensity": "2665.92",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "57",
                        "monoisotopic_mass": "4347.0454",
                        "monoisotopic_mz": "870.4164",
                        "intensity": "894.44",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "58",
                        "monoisotopic_mass": "5440.0836",
                        "monoisotopic_mz": "907.6879",
                        "intensity": "856.93",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "59",
                        "monoisotopic_mass": "1021.5549",
                        "monoisotopic_mz": "1022.5622",
                        "intensity": "657.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "60",
                        "monoisotopic_mass": "2793.5093",
                        "monoisotopic_mz": "699.3846",
                        "intensity": "2710.54",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2793.5171",
                                "ion_position": "28",
                                "ion_display_position": "28",
                                "ion_sort_name": "B00028",
                                "ion_left_position": "28",
                                "mass_error": "-0.0078",
                                "ppm": "-2.81"
                            }
                        }
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "61",
                        "monoisotopic_mass": "2110.3048",
                        "monoisotopic_mz": "704.4422",
                        "intensity": "977.45",
                        "charge": "3"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "62",
                        "monoisotopic_mass": "4747.8411",
                        "monoisotopic_mz": "792.3141",
                        "intensity": "1202.44",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "63",
                        "monoisotopic_mass": "5967.3608",
                        "monoisotopic_mz": "746.9274",
                        "intensity": "2107.26",
                        "charge": "8"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "64",
                        "monoisotopic_mass": "5440.1656",
                        "monoisotopic_mz": "778.1738",
                        "intensity": "724.77",
                        "charge": "7"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "65",
                        "monoisotopic_mass": "6045.9985",
                        "monoisotopic_mz": "672.7849",
                        "intensity": "2840.18",
                        "charge": "9"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "66",
                        "monoisotopic_mass": "3866.9702",
                        "monoisotopic_mz": "774.4013",
                        "intensity": "1078.62",
                        "charge": "5"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "67",
                        "monoisotopic_mass": "6027.8003",
                        "monoisotopic_mz": "754.4823",
                        "intensity": "1450.96",
                        "charge": "8"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "68",
                        "monoisotopic_mass": "936.5036",
                        "monoisotopic_mz": "937.5109",
                        "intensity": "810.44",
                        "charge": "1"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "69",
                        "monoisotopic_mass": "4252.0013",
                        "monoisotopic_mz": "709.6742",
                        "intensity": "1931.27",
                        "charge": "6"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "70",
                        "monoisotopic_mass": "2908.8974",
                        "monoisotopic_mz": "728.2316",
                        "intensity": "1675.55",
                        "charge": "4"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "71",
                        "monoisotopic_mass": "1365.8787",
                        "monoisotopic_mz": "683.9466",
                        "intensity": "784.21",
                        "charge": "2"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "72",
                        "monoisotopic_mass": "3084.0894",
                        "monoisotopic_mz": "772.0296",
                        "intensity": "1249.75",
                        "charge": "4"
                    },
                    {
                        "spec_id": "206",
                        "peak_id": "73",
                        "monoisotopic_mass": "860.4719",
                        "monoisotopic_mz": "861.4792",
                        "intensity": "1009.02",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "7",
            "proteoform_id": "16",
            "sequence_name": "sp|P0ACF4|DBHB_ECOLI",
            "sequence_description": "DNA-binding protein HU-beta OS=Escherichia coli (strain K12) OX=83333 GN=hupB PE=1 SV=1",
            "proteoform_mass": "9222.2423",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "90",
                "first_residue_position": "0",
                "last_residue_position": "89",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "N"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "S"
                    },
                    {
                        "position": "4",
                        "acid": "Q"
                    },
                    {
                        "position": "5",
                        "acid": "L"
                    },
                    {
                        "position": "6",
                        "acid": "I"
                    },
                    {
                        "position": "7",
                        "acid": "D"
                    },
                    {
                        "position": "8",
                        "acid": "K"
                    },
                    {
                        "position": "9",
                        "acid": "I"
                    },
                    {
                        "position": "10",
                        "acid": "A"
                    },
                    {
                        "position": "11",
                        "acid": "A"
                    },
                    {
                        "position": "12",
                        "acid": "G"
                    },
                    {
                        "position": "13",
                        "acid": "A"
                    },
                    {
                        "position": "14",
                        "acid": "D"
                    },
                    {
                        "position": "15",
                        "acid": "I"
                    },
                    {
                        "position": "16",
                        "acid": "S"
                    },
                    {
                        "position": "17",
                        "acid": "K"
                    },
                    {
                        "position": "18",
                        "acid": "A"
                    },
                    {
                        "position": "19",
                        "acid": "A"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "G"
                    },
                    {
                        "position": "22",
                        "acid": "R"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "L"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "I"
                    },
                    {
                        "position": "28",
                        "acid": "I"
                    },
                    {
                        "position": "29",
                        "acid": "A"
                    },
                    {
                        "position": "30",
                        "acid": "S"
                    },
                    {
                        "position": "31",
                        "acid": "V"
                    },
                    {
                        "position": "32",
                        "acid": "T"
                    },
                    {
                        "position": "33",
                        "acid": "E"
                    },
                    {
                        "position": "34",
                        "acid": "S"
                    },
                    {
                        "position": "35",
                        "acid": "L"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "E"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "D"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "V"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "L"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "G"
                    },
                    {
                        "position": "46",
                        "acid": "F"
                    },
                    {
                        "position": "47",
                        "acid": "G"
                    },
                    {
                        "position": "48",
                        "acid": "T"
                    },
                    {
                        "position": "49",
                        "acid": "F"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "V"
                    },
                    {
                        "position": "52",
                        "acid": "K"
                    },
                    {
                        "position": "53",
                        "acid": "E"
                    },
                    {
                        "position": "54",
                        "acid": "R"
                    },
                    {
                        "position": "55",
                        "acid": "A"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "R"
                    },
                    {
                        "position": "58",
                        "acid": "T"
                    },
                    {
                        "position": "59",
                        "acid": "G"
                    },
                    {
                        "position": "60",
                        "acid": "R"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "P"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "T"
                    },
                    {
                        "position": "65",
                        "acid": "G"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "I"
                    },
                    {
                        "position": "69",
                        "acid": "T"
                    },
                    {
                        "position": "70",
                        "acid": "I"
                    },
                    {
                        "position": "71",
                        "acid": "A"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "A"
                    },
                    {
                        "position": "74",
                        "acid": "K"
                    },
                    {
                        "position": "75",
                        "acid": "V"
                    },
                    {
                        "position": "76",
                        "acid": "P"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "F"
                    },
                    {
                        "position": "79",
                        "acid": "R"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "G"
                    },
                    {
                        "position": "82",
                        "acid": "K"
                    },
                    {
                        "position": "83",
                        "acid": "A"
                    },
                    {
                        "position": "84",
                        "acid": "L"
                    },
                    {
                        "position": "85",
                        "acid": "K"
                    },
                    {
                        "position": "86",
                        "acid": "D"
                    },
                    {
                        "position": "87",
                        "acid": "A"
                    },
                    {
                        "position": "88",
                        "acid": "V"
                    },
                    {
                        "position": "89",
                        "acid": "N"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "28",
                                    "ion_display_position": "28",
                                    "spec_id": "206",
                                    "peak_id": "60",
                                    "peak_charge": "4"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "28",
                                    "ion_display_position": "28",
                                    "spec_id": "206",
                                    "peak_id": "5",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "41",
                                "ion_display_position": "41",
                                "spec_id": "206",
                                "peak_id": "10",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "43",
                                "ion_display_position": "47",
                                "spec_id": "206",
                                "peak_id": "6",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "44",
                                    "ion_display_position": "46",
                                    "spec_id": "206",
                                    "peak_id": "9",
                                    "peak_charge": "7"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "44",
                                    "ion_display_position": "46",
                                    "spec_id": "206",
                                    "peak_id": "1",
                                    "peak_charge": "6"
                                }
                            ]
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "206",
                                    "peak_id": "0",
                                    "peak_charge": "6"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "45",
                                    "ion_display_position": "45",
                                    "spec_id": "206",
                                    "peak_id": "4",
                                    "peak_charge": "7"
                                }
                            ]
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "46",
                                "ion_display_position": "44",
                                "spec_id": "206",
                                "peak_id": "11",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "47",
                                "ion_display_position": "43",
                                "spec_id": "206",
                                "peak_id": "3",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "72",
                                "ion_display_position": "72",
                                "spec_id": "206",
                                "peak_id": "31",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "76",
                                "ion_display_position": "14",
                                "spec_id": "206",
                                "peak_id": "7",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "mass_shift": {
                    "id": "0",
                    "left_position": "41",
                    "right_position": "43",
                    "anno": "2.2477",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
