prsm_data =
{
    "prsm": {
        "prsm_id": "134",
        "p_value": "0.03",
        "e_value": "0.03",
        "fdr": "4.42e-03",
        "matched_fragment_number": "6",
        "matched_peak_number": "7",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "116",
                "ms1_scans": "304",
                "ids": "189",
                "scans": "307",
                "precursor_mono_mass": "15923.2013",
                "precursor_charge": "19",
                "precursor_mz": "839.0705",
                "feature_inte": "1.8031e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "189",
                        "peak_id": "0",
                        "monoisotopic_mass": "9217.9876",
                        "monoisotopic_mz": "839.0062",
                        "intensity": "39998.47",
                        "charge": "11"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "1",
                        "monoisotopic_mass": "4361.2179",
                        "monoisotopic_mz": "873.2509",
                        "intensity": "7487.49",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "4361.2193",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "ion_sort_name": "B00039",
                                "ion_left_position": "39",
                                "mass_error": "-0.0014",
                                "ppm": "-0.31"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "2",
                        "monoisotopic_mass": "9202.9519",
                        "monoisotopic_mz": "837.6393",
                        "intensity": "10911.21",
                        "charge": "11"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "3",
                        "monoisotopic_mass": "2426.1708",
                        "monoisotopic_mz": "809.7309",
                        "intensity": "4555.25",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "4",
                        "monoisotopic_mass": "5299.6025",
                        "monoisotopic_mz": "884.2744",
                        "intensity": "4735.05",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "5",
                        "monoisotopic_mass": "4360.2217",
                        "monoisotopic_mz": "1091.0627",
                        "intensity": "3050.10",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "6",
                        "monoisotopic_mass": "2556.0703",
                        "monoisotopic_mz": "853.0307",
                        "intensity": "3712.85",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "7",
                        "monoisotopic_mass": "5449.9624",
                        "monoisotopic_mz": "909.3343",
                        "intensity": "3155.01",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "8",
                        "monoisotopic_mass": "4193.0011",
                        "monoisotopic_mz": "839.6075",
                        "intensity": "11452.79",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "9",
                        "monoisotopic_mass": "1136.6192",
                        "monoisotopic_mz": "1137.6265",
                        "intensity": "4451.77",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "0.0002",
                                "ppm": "0.16"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "10",
                        "monoisotopic_mass": "5480.9109",
                        "monoisotopic_mz": "914.4924",
                        "intensity": "4361.20",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "11",
                        "monoisotopic_mass": "8008.1526",
                        "monoisotopic_mz": "890.8020",
                        "intensity": "1434.11",
                        "charge": "9",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "8007.1407",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "ion_sort_name": "B00075",
                                "ion_left_position": "75",
                                "mass_error": "0.0096",
                                "ppm": "1.20"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "12",
                        "monoisotopic_mass": "3498.7361",
                        "monoisotopic_mz": "875.6913",
                        "intensity": "1226.98",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "13",
                        "monoisotopic_mass": "7191.7683",
                        "monoisotopic_mz": "899.9783",
                        "intensity": "2793.23",
                        "charge": "8"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "14",
                        "monoisotopic_mass": "8148.1780",
                        "monoisotopic_mz": "906.3604",
                        "intensity": "1433.71",
                        "charge": "9"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "15",
                        "monoisotopic_mass": "3990.5850",
                        "monoisotopic_mz": "799.1243",
                        "intensity": "1245.30",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "16",
                        "monoisotopic_mass": "7838.0663",
                        "monoisotopic_mz": "871.9035",
                        "intensity": "2457.33",
                        "charge": "9"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "17",
                        "monoisotopic_mass": "9232.9729",
                        "monoisotopic_mz": "840.3685",
                        "intensity": "2709.79",
                        "charge": "11"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "18",
                        "monoisotopic_mass": "9877.4352",
                        "monoisotopic_mz": "824.1269",
                        "intensity": "1326.22",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "19",
                        "monoisotopic_mass": "8972.9045",
                        "monoisotopic_mz": "898.2977",
                        "intensity": "3121.65",
                        "charge": "10"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "20",
                        "monoisotopic_mass": "5364.8987",
                        "monoisotopic_mz": "895.1571",
                        "intensity": "3389.12",
                        "charge": "6",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "5363.8228",
                                "ion_position": "100",
                                "ion_display_position": "48",
                                "ion_sort_name": "Y00048",
                                "ion_left_position": "100",
                                "mass_error": "0.0735",
                                "ppm": "13.70"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "21",
                        "monoisotopic_mass": "15161.7183",
                        "monoisotopic_mz": "892.8731",
                        "intensity": "3442.42",
                        "charge": "17"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "22",
                        "monoisotopic_mass": "14947.6604",
                        "monoisotopic_mz": "1068.6973",
                        "intensity": "4387.27",
                        "charge": "14"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "23",
                        "monoisotopic_mass": "2229.0128",
                        "monoisotopic_mz": "744.0115",
                        "intensity": "1186.88",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "24",
                        "monoisotopic_mass": "13735.8229",
                        "monoisotopic_mz": "916.7288",
                        "intensity": "3530.49",
                        "charge": "15"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "25",
                        "monoisotopic_mass": "14946.2163",
                        "monoisotopic_mz": "935.1458",
                        "intensity": "997.46",
                        "charge": "16"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "26",
                        "monoisotopic_mass": "854.4864",
                        "monoisotopic_mz": "855.4937",
                        "intensity": "1846.25",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "854.4862",
                                "ion_position": "141",
                                "ion_display_position": "7",
                                "ion_sort_name": "Y00007",
                                "ion_left_position": "141",
                                "mass_error": "0.0002",
                                "ppm": "0.21"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "27",
                        "monoisotopic_mass": "940.6448",
                        "monoisotopic_mz": "941.6520",
                        "intensity": "2336.69",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "28",
                        "monoisotopic_mass": "4095.1313",
                        "monoisotopic_mz": "1024.7901",
                        "intensity": "1140.44",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "29",
                        "monoisotopic_mass": "2675.2033",
                        "monoisotopic_mz": "892.7417",
                        "intensity": "2663.96",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "30",
                        "monoisotopic_mass": "755.4194",
                        "monoisotopic_mz": "756.4267",
                        "intensity": "2061.65",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "755.4178",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "ion_sort_name": "Y00006",
                                "ion_left_position": "142",
                                "mass_error": "0.0016",
                                "ppm": "2.16"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "31",
                        "monoisotopic_mass": "4164.5508",
                        "monoisotopic_mz": "833.9174",
                        "intensity": "1083.43",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "32",
                        "monoisotopic_mass": "898.3950",
                        "monoisotopic_mz": "899.4023",
                        "intensity": "1373.78",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "33",
                        "monoisotopic_mass": "874.4562",
                        "monoisotopic_mz": "875.4635",
                        "intensity": "1205.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "34",
                        "monoisotopic_mass": "3518.7960",
                        "monoisotopic_mz": "880.7063",
                        "intensity": "1643.45",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "35",
                        "monoisotopic_mass": "15804.5992",
                        "monoisotopic_mz": "930.6896",
                        "intensity": "1509.38",
                        "charge": "17"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "36",
                        "monoisotopic_mass": "3335.2091",
                        "monoisotopic_mz": "834.8095",
                        "intensity": "1208.74",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "37",
                        "monoisotopic_mass": "1136.6192",
                        "monoisotopic_mz": "569.3169",
                        "intensity": "1209.76",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1136.6190",
                                "ion_position": "138",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "138",
                                "mass_error": "0.0002",
                                "ppm": "0.20"
                            }
                        }
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "38",
                        "monoisotopic_mass": "5269.0931",
                        "monoisotopic_mz": "879.1895",
                        "intensity": "1120.62",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "39",
                        "monoisotopic_mass": "5030.5276",
                        "monoisotopic_mz": "839.4285",
                        "intensity": "9976.43",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "40",
                        "monoisotopic_mass": "4391.3115",
                        "monoisotopic_mz": "879.2696",
                        "intensity": "2185.54",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "41",
                        "monoisotopic_mass": "4059.7743",
                        "monoisotopic_mz": "1015.9509",
                        "intensity": "3805.28",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "42",
                        "monoisotopic_mass": "14352.2954",
                        "monoisotopic_mz": "957.8270",
                        "intensity": "3434.87",
                        "charge": "15"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "43",
                        "monoisotopic_mass": "2512.2749",
                        "monoisotopic_mz": "838.4322",
                        "intensity": "2876.01",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "44",
                        "monoisotopic_mass": "959.5242",
                        "monoisotopic_mz": "960.5314",
                        "intensity": "981.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "45",
                        "monoisotopic_mass": "912.6889",
                        "monoisotopic_mz": "913.6962",
                        "intensity": "1836.29",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "46",
                        "monoisotopic_mass": "8295.8705",
                        "monoisotopic_mz": "830.5943",
                        "intensity": "1054.63",
                        "charge": "10"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "47",
                        "monoisotopic_mass": "5017.4528",
                        "monoisotopic_mz": "837.2494",
                        "intensity": "3336.15",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "48",
                        "monoisotopic_mass": "5774.2447",
                        "monoisotopic_mz": "825.8994",
                        "intensity": "1619.74",
                        "charge": "7"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "49",
                        "monoisotopic_mass": "9643.2199",
                        "monoisotopic_mz": "804.6089",
                        "intensity": "1337.64",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "50",
                        "monoisotopic_mass": "9962.5513",
                        "monoisotopic_mz": "831.2199",
                        "intensity": "1076.88",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "51",
                        "monoisotopic_mass": "2718.8616",
                        "monoisotopic_mz": "907.2945",
                        "intensity": "2098.77",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "52",
                        "monoisotopic_mass": "5600.9941",
                        "monoisotopic_mz": "934.5063",
                        "intensity": "1172.66",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "53",
                        "monoisotopic_mass": "13844.2810",
                        "monoisotopic_mz": "815.3767",
                        "intensity": "1563.56",
                        "charge": "17"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "54",
                        "monoisotopic_mass": "1054.9777",
                        "monoisotopic_mz": "1055.9850",
                        "intensity": "1820.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "55",
                        "monoisotopic_mass": "4488.1147",
                        "monoisotopic_mz": "898.6302",
                        "intensity": "2280.26",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "56",
                        "monoisotopic_mass": "12582.8383",
                        "monoisotopic_mz": "899.7814",
                        "intensity": "903.68",
                        "charge": "14"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "57",
                        "monoisotopic_mass": "8768.7675",
                        "monoisotopic_mz": "975.3148",
                        "intensity": "2778.87",
                        "charge": "9"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "58",
                        "monoisotopic_mass": "12540.9217",
                        "monoisotopic_mz": "837.0687",
                        "intensity": "4303.09",
                        "charge": "15"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "59",
                        "monoisotopic_mass": "4115.1329",
                        "monoisotopic_mz": "824.0339",
                        "intensity": "1175.55",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "60",
                        "monoisotopic_mass": "9911.3183",
                        "monoisotopic_mz": "992.1391",
                        "intensity": "2663.13",
                        "charge": "10"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "61",
                        "monoisotopic_mass": "11937.7626",
                        "monoisotopic_mz": "919.2967",
                        "intensity": "4928.00",
                        "charge": "13"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "62",
                        "monoisotopic_mass": "975.5217",
                        "monoisotopic_mz": "976.5290",
                        "intensity": "1482.18",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "63",
                        "monoisotopic_mass": "1830.5005",
                        "monoisotopic_mz": "916.2575",
                        "intensity": "7134.27",
                        "charge": "2"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "64",
                        "monoisotopic_mass": "3467.5023",
                        "monoisotopic_mz": "867.8828",
                        "intensity": "1279.99",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "65",
                        "monoisotopic_mass": "2938.0370",
                        "monoisotopic_mz": "980.3530",
                        "intensity": "2160.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "66",
                        "monoisotopic_mass": "7982.0682",
                        "monoisotopic_mz": "887.9037",
                        "intensity": "2269.03",
                        "charge": "9"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "67",
                        "monoisotopic_mass": "13195.0326",
                        "monoisotopic_mz": "825.6968",
                        "intensity": "3349.13",
                        "charge": "16"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "68",
                        "monoisotopic_mass": "4544.4793",
                        "monoisotopic_mz": "909.9031",
                        "intensity": "3274.60",
                        "charge": "5"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "69",
                        "monoisotopic_mass": "1018.1003",
                        "monoisotopic_mz": "1019.1076",
                        "intensity": "1183.51",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "70",
                        "monoisotopic_mass": "9742.6836",
                        "monoisotopic_mz": "886.7058",
                        "intensity": "4905.97",
                        "charge": "11"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "71",
                        "monoisotopic_mass": "7272.6823",
                        "monoisotopic_mz": "910.0926",
                        "intensity": "723.62",
                        "charge": "8"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "72",
                        "monoisotopic_mass": "10639.6675",
                        "monoisotopic_mz": "887.6462",
                        "intensity": "2581.58",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "73",
                        "monoisotopic_mass": "8538.0940",
                        "monoisotopic_mz": "949.6844",
                        "intensity": "1124.12",
                        "charge": "9"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "74",
                        "monoisotopic_mass": "9873.1071",
                        "monoisotopic_mz": "898.5625",
                        "intensity": "1389.23",
                        "charge": "11"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "75",
                        "monoisotopic_mass": "12859.6485",
                        "monoisotopic_mz": "1072.6446",
                        "intensity": "4463.91",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "76",
                        "monoisotopic_mass": "12400.3449",
                        "monoisotopic_mz": "827.6969",
                        "intensity": "2906.70",
                        "charge": "15"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "77",
                        "monoisotopic_mass": "5667.5540",
                        "monoisotopic_mz": "945.5996",
                        "intensity": "1142.70",
                        "charge": "6"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "78",
                        "monoisotopic_mass": "5785.4799",
                        "monoisotopic_mz": "827.5044",
                        "intensity": "1040.27",
                        "charge": "7"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "79",
                        "monoisotopic_mass": "3818.0176",
                        "monoisotopic_mz": "955.5117",
                        "intensity": "1747.36",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "80",
                        "monoisotopic_mass": "1473.8136",
                        "monoisotopic_mz": "737.9141",
                        "intensity": "1237.94",
                        "charge": "2"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "81",
                        "monoisotopic_mass": "14301.2288",
                        "monoisotopic_mz": "894.8341",
                        "intensity": "1269.75",
                        "charge": "16"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "82",
                        "monoisotopic_mass": "1069.0532",
                        "monoisotopic_mz": "1070.0605",
                        "intensity": "1532.95",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "83",
                        "monoisotopic_mass": "10908.9761",
                        "monoisotopic_mz": "910.0886",
                        "intensity": "1340.85",
                        "charge": "12"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "84",
                        "monoisotopic_mass": "8397.6165",
                        "monoisotopic_mz": "840.7689",
                        "intensity": "3323.57",
                        "charge": "10"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "85",
                        "monoisotopic_mass": "2538.2584",
                        "monoisotopic_mz": "847.0934",
                        "intensity": "1512.51",
                        "charge": "3"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "86",
                        "monoisotopic_mass": "1232.6322",
                        "monoisotopic_mz": "1233.6394",
                        "intensity": "1275.55",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "87",
                        "monoisotopic_mass": "1786.9016",
                        "monoisotopic_mz": "894.4581",
                        "intensity": "1083.64",
                        "charge": "2"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "88",
                        "monoisotopic_mass": "770.4013",
                        "monoisotopic_mz": "771.4086",
                        "intensity": "977.54",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "89",
                        "monoisotopic_mass": "6180.9159",
                        "monoisotopic_mz": "883.9953",
                        "intensity": "1479.80",
                        "charge": "7"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "90",
                        "monoisotopic_mass": "1086.5806",
                        "monoisotopic_mz": "1087.5879",
                        "intensity": "1122.06",
                        "charge": "1"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "91",
                        "monoisotopic_mass": "3443.8056",
                        "monoisotopic_mz": "861.9587",
                        "intensity": "1619.96",
                        "charge": "4"
                    },
                    {
                        "spec_id": "189",
                        "peak_id": "92",
                        "monoisotopic_mass": "791.9719",
                        "monoisotopic_mz": "792.9792",
                        "intensity": "979.56",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "8",
            "proteoform_id": "11",
            "sequence_name": "sp|P0ADE6|KBP_ECOLI",
            "sequence_description": "Potassium binding protein Kbp OS=Escherichia coli (strain K12) OX=83333 GN=kbp PE=1 SV=2",
            "proteoform_mass": "15922.2440",
            "n_acetylation": "0",
            "unexpected_shift_number": "0",
            "annotation": {
                "protein_length": "149",
                "first_residue_position": "1",
                "last_residue_position": "148",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "G"
                    },
                    {
                        "position": "2",
                        "acid": "L"
                    },
                    {
                        "position": "3",
                        "acid": "F"
                    },
                    {
                        "position": "4",
                        "acid": "N"
                    },
                    {
                        "position": "5",
                        "acid": "F"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "K"
                    },
                    {
                        "position": "8",
                        "acid": "D"
                    },
                    {
                        "position": "9",
                        "acid": "A"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "E"
                    },
                    {
                        "position": "12",
                        "acid": "K"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "W"
                    },
                    {
                        "position": "15",
                        "acid": "D"
                    },
                    {
                        "position": "16",
                        "acid": "A"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "T"
                    },
                    {
                        "position": "19",
                        "acid": "G"
                    },
                    {
                        "position": "20",
                        "acid": "Q"
                    },
                    {
                        "position": "21",
                        "acid": "H"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "K"
                    },
                    {
                        "position": "24",
                        "acid": "D"
                    },
                    {
                        "position": "25",
                        "acid": "D"
                    },
                    {
                        "position": "26",
                        "acid": "Q"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "K"
                    },
                    {
                        "position": "29",
                        "acid": "K"
                    },
                    {
                        "position": "30",
                        "acid": "V"
                    },
                    {
                        "position": "31",
                        "acid": "Q"
                    },
                    {
                        "position": "32",
                        "acid": "E"
                    },
                    {
                        "position": "33",
                        "acid": "H"
                    },
                    {
                        "position": "34",
                        "acid": "L"
                    },
                    {
                        "position": "35",
                        "acid": "N"
                    },
                    {
                        "position": "36",
                        "acid": "K"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "G"
                    },
                    {
                        "position": "39",
                        "acid": "I"
                    },
                    {
                        "position": "40",
                        "acid": "P"
                    },
                    {
                        "position": "41",
                        "acid": "D"
                    },
                    {
                        "position": "42",
                        "acid": "A"
                    },
                    {
                        "position": "43",
                        "acid": "D"
                    },
                    {
                        "position": "44",
                        "acid": "K"
                    },
                    {
                        "position": "45",
                        "acid": "V"
                    },
                    {
                        "position": "46",
                        "acid": "N"
                    },
                    {
                        "position": "47",
                        "acid": "I"
                    },
                    {
                        "position": "48",
                        "acid": "Q"
                    },
                    {
                        "position": "49",
                        "acid": "I"
                    },
                    {
                        "position": "50",
                        "acid": "A"
                    },
                    {
                        "position": "51",
                        "acid": "D"
                    },
                    {
                        "position": "52",
                        "acid": "G"
                    },
                    {
                        "position": "53",
                        "acid": "K"
                    },
                    {
                        "position": "54",
                        "acid": "A"
                    },
                    {
                        "position": "55",
                        "acid": "T"
                    },
                    {
                        "position": "56",
                        "acid": "V"
                    },
                    {
                        "position": "57",
                        "acid": "T"
                    },
                    {
                        "position": "58",
                        "acid": "G"
                    },
                    {
                        "position": "59",
                        "acid": "D"
                    },
                    {
                        "position": "60",
                        "acid": "G"
                    },
                    {
                        "position": "61",
                        "acid": "L"
                    },
                    {
                        "position": "62",
                        "acid": "S"
                    },
                    {
                        "position": "63",
                        "acid": "Q"
                    },
                    {
                        "position": "64",
                        "acid": "E"
                    },
                    {
                        "position": "65",
                        "acid": "A"
                    },
                    {
                        "position": "66",
                        "acid": "K"
                    },
                    {
                        "position": "67",
                        "acid": "E"
                    },
                    {
                        "position": "68",
                        "acid": "K"
                    },
                    {
                        "position": "69",
                        "acid": "I"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "V"
                    },
                    {
                        "position": "72",
                        "acid": "A"
                    },
                    {
                        "position": "73",
                        "acid": "V"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "N"
                    },
                    {
                        "position": "76",
                        "acid": "I"
                    },
                    {
                        "position": "77",
                        "acid": "S"
                    },
                    {
                        "position": "78",
                        "acid": "G"
                    },
                    {
                        "position": "79",
                        "acid": "I"
                    },
                    {
                        "position": "80",
                        "acid": "A"
                    },
                    {
                        "position": "81",
                        "acid": "S"
                    },
                    {
                        "position": "82",
                        "acid": "V"
                    },
                    {
                        "position": "83",
                        "acid": "D"
                    },
                    {
                        "position": "84",
                        "acid": "D"
                    },
                    {
                        "position": "85",
                        "acid": "Q"
                    },
                    {
                        "position": "86",
                        "acid": "V"
                    },
                    {
                        "position": "87",
                        "acid": "K"
                    },
                    {
                        "position": "88",
                        "acid": "T"
                    },
                    {
                        "position": "89",
                        "acid": "A"
                    },
                    {
                        "position": "90",
                        "acid": "T"
                    },
                    {
                        "position": "91",
                        "acid": "P"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "T"
                    },
                    {
                        "position": "94",
                        "acid": "A"
                    },
                    {
                        "position": "95",
                        "acid": "S"
                    },
                    {
                        "position": "96",
                        "acid": "Q"
                    },
                    {
                        "position": "97",
                        "acid": "F"
                    },
                    {
                        "position": "98",
                        "acid": "Y"
                    },
                    {
                        "position": "99",
                        "acid": "T"
                    },
                    {
                        "position": "100",
                        "acid": "V"
                    },
                    {
                        "position": "101",
                        "acid": "K"
                    },
                    {
                        "position": "102",
                        "acid": "S"
                    },
                    {
                        "position": "103",
                        "acid": "G"
                    },
                    {
                        "position": "104",
                        "acid": "D"
                    },
                    {
                        "position": "105",
                        "acid": "T"
                    },
                    {
                        "position": "106",
                        "acid": "L"
                    },
                    {
                        "position": "107",
                        "acid": "S"
                    },
                    {
                        "position": "108",
                        "acid": "A"
                    },
                    {
                        "position": "109",
                        "acid": "I"
                    },
                    {
                        "position": "110",
                        "acid": "S"
                    },
                    {
                        "position": "111",
                        "acid": "K"
                    },
                    {
                        "position": "112",
                        "acid": "Q"
                    },
                    {
                        "position": "113",
                        "acid": "V"
                    },
                    {
                        "position": "114",
                        "acid": "Y"
                    },
                    {
                        "position": "115",
                        "acid": "G"
                    },
                    {
                        "position": "116",
                        "acid": "N"
                    },
                    {
                        "position": "117",
                        "acid": "A"
                    },
                    {
                        "position": "118",
                        "acid": "N"
                    },
                    {
                        "position": "119",
                        "acid": "L"
                    },
                    {
                        "position": "120",
                        "acid": "Y"
                    },
                    {
                        "position": "121",
                        "acid": "N"
                    },
                    {
                        "position": "122",
                        "acid": "K"
                    },
                    {
                        "position": "123",
                        "acid": "I"
                    },
                    {
                        "position": "124",
                        "acid": "F"
                    },
                    {
                        "position": "125",
                        "acid": "E"
                    },
                    {
                        "position": "126",
                        "acid": "A"
                    },
                    {
                        "position": "127",
                        "acid": "N"
                    },
                    {
                        "position": "128",
                        "acid": "K"
                    },
                    {
                        "position": "129",
                        "acid": "P"
                    },
                    {
                        "position": "130",
                        "acid": "M"
                    },
                    {
                        "position": "131",
                        "acid": "L"
                    },
                    {
                        "position": "132",
                        "acid": "K"
                    },
                    {
                        "position": "133",
                        "acid": "S"
                    },
                    {
                        "position": "134",
                        "acid": "P"
                    },
                    {
                        "position": "135",
                        "acid": "D"
                    },
                    {
                        "position": "136",
                        "acid": "K"
                    },
                    {
                        "position": "137",
                        "acid": "I"
                    },
                    {
                        "position": "138",
                        "acid": "Y"
                    },
                    {
                        "position": "139",
                        "acid": "P"
                    },
                    {
                        "position": "140",
                        "acid": "G"
                    },
                    {
                        "position": "141",
                        "acid": "Q"
                    },
                    {
                        "position": "142",
                        "acid": "V"
                    },
                    {
                        "position": "143",
                        "acid": "L"
                    },
                    {
                        "position": "144",
                        "acid": "R"
                    },
                    {
                        "position": "145",
                        "acid": "I"
                    },
                    {
                        "position": "146",
                        "acid": "P"
                    },
                    {
                        "position": "147",
                        "acid": "E"
                    },
                    {
                        "position": "148",
                        "acid": "E"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "39",
                                "ion_display_position": "39",
                                "spec_id": "189",
                                "peak_id": "1",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "75",
                                "ion_display_position": "75",
                                "spec_id": "189",
                                "peak_id": "11",
                                "peak_charge": "9"
                            }
                        }
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "100",
                                "ion_display_position": "48",
                                "spec_id": "189",
                                "peak_id": "20",
                                "peak_charge": "6"
                            }
                        }
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "111",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "112",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "113",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "114",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "115",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "116",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "117",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "118",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "119",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "120",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "121",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "122",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "123",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "124",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "125",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "126",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "127",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "128",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "129",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "130",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "131",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "132",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "133",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "134",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "135",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "136",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "137",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "138",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "139",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "Y",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "spec_id": "189",
                                    "peak_id": "9",
                                    "peak_charge": "1"
                                },
                                {
                                    "ion_type": "Y",
                                    "ion_position": "138",
                                    "ion_display_position": "10",
                                    "spec_id": "189",
                                    "peak_id": "37",
                                    "peak_charge": "2"
                                }
                            ]
                        }
                    },
                    {
                        "position": "140",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "141",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "142",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "141",
                                "ion_display_position": "7",
                                "spec_id": "189",
                                "peak_id": "26",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "143",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "142",
                                "ion_display_position": "6",
                                "spec_id": "189",
                                "peak_id": "30",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "144",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "145",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "146",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "147",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "148",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "149",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ]
            }
        }
    }
}
