prsm_data =
{
    "prsm": {
        "prsm_id": "132",
        "p_value": "1.28e-10",
        "e_value": "1.28e-10",
        "fdr": "0",
        "matched_fragment_number": "20",
        "matched_peak_number": "21",
        "ms": {
            "ms_header": {
                "spectrum_file_name": "ecoli_2_ms2.msalign",
                "ms1_ids": "115",
                "ms1_scans": "298",
                "ids": "183",
                "scans": "300",
                "precursor_mono_mass": "9863.8469",
                "precursor_charge": "12",
                "precursor_mz": "822.9945",
                "feature_inte": "1.2480e+08"
            },
            "peaks": {
                "peak": [
                    {
                        "spec_id": "183",
                        "peak_id": "0",
                        "monoisotopic_mass": "3519.8030",
                        "monoisotopic_mz": "880.9580",
                        "intensity": "95193.57",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "1",
                        "monoisotopic_mass": "3620.8509",
                        "monoisotopic_mz": "906.2200",
                        "intensity": "50029.12",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "2",
                        "monoisotopic_mass": "3519.8020",
                        "monoisotopic_mz": "1174.2746",
                        "intensity": "40218.46",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "3",
                        "monoisotopic_mass": "3518.8019",
                        "monoisotopic_mz": "704.7677",
                        "intensity": "27494.70",
                        "charge": "5",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3518.8014",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "ion_sort_name": "Y00030",
                                "ion_left_position": "59",
                                "mass_error": "0.0005",
                                "ppm": "0.14"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "4",
                        "monoisotopic_mass": "2229.0115",
                        "monoisotopic_mz": "744.0111",
                        "intensity": "37730.07",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2229.0120",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "ion_sort_name": "B00020",
                                "ion_left_position": "20",
                                "mass_error": "-0.0006",
                                "ppm": "-0.26"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "5",
                        "monoisotopic_mass": "3534.7955",
                        "monoisotopic_mz": "884.7061",
                        "intensity": "20932.64",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "6",
                        "monoisotopic_mass": "2376.0805",
                        "monoisotopic_mz": "793.0341",
                        "intensity": "25799.65",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "0.0001",
                                "ppm": "0.02"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "7",
                        "monoisotopic_mass": "3620.8530",
                        "monoisotopic_mz": "725.1779",
                        "intensity": "16843.97",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "8",
                        "monoisotopic_mass": "3238.6289",
                        "monoisotopic_mz": "1080.5502",
                        "intensity": "18918.49",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "9",
                        "monoisotopic_mass": "3620.8506",
                        "monoisotopic_mz": "1207.9575",
                        "intensity": "18456.33",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "10",
                        "monoisotopic_mass": "2560.2011",
                        "monoisotopic_mz": "854.4076",
                        "intensity": "13051.61",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2560.2016",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "ion_sort_name": "B00023",
                                "ion_left_position": "23",
                                "mass_error": "-0.0005",
                                "ppm": "-0.21"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "11",
                        "monoisotopic_mass": "2295.1371",
                        "monoisotopic_mz": "1148.5758",
                        "intensity": "14891.12",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "12",
                        "monoisotopic_mass": "3351.7200",
                        "monoisotopic_mz": "1118.2473",
                        "intensity": "9875.98",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "13",
                        "monoisotopic_mass": "3238.6301",
                        "monoisotopic_mz": "810.6648",
                        "intensity": "13335.85",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "14",
                        "monoisotopic_mass": "2489.1650",
                        "monoisotopic_mz": "830.7289",
                        "intensity": "12214.54",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2489.1645",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "ion_sort_name": "B00022",
                                "ion_left_position": "22",
                                "mass_error": "0.0004",
                                "ppm": "0.18"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "15",
                        "monoisotopic_mass": "2659.2698",
                        "monoisotopic_mz": "887.4305",
                        "intensity": "9361.69",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2659.2701",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "ion_sort_name": "B00024",
                                "ion_left_position": "24",
                                "mass_error": "-0.0003",
                                "ppm": "-0.10"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "16",
                        "monoisotopic_mass": "770.3558",
                        "monoisotopic_mz": "771.3631",
                        "intensity": "11818.10",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "770.3559",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "ion_sort_name": "B00008",
                                "ion_left_position": "8",
                                "mass_error": "-0.0001",
                                "ppm": "-0.08"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "17",
                        "monoisotopic_mass": "3351.7227",
                        "monoisotopic_mz": "838.9380",
                        "intensity": "11467.68",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "18",
                        "monoisotopic_mass": "3873.9954",
                        "monoisotopic_mz": "969.5061",
                        "intensity": "14080.87",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "19",
                        "monoisotopic_mass": "2580.2861",
                        "monoisotopic_mz": "861.1027",
                        "intensity": "10438.37",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "20",
                        "monoisotopic_mass": "2580.2877",
                        "monoisotopic_mz": "1291.1511",
                        "intensity": "10749.72",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "21",
                        "monoisotopic_mass": "3422.7514",
                        "monoisotopic_mz": "1141.9244",
                        "intensity": "6607.56",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "22",
                        "monoisotopic_mass": "3635.8406",
                        "monoisotopic_mz": "909.9674",
                        "intensity": "13479.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "23",
                        "monoisotopic_mass": "4044.0913",
                        "monoisotopic_mz": "1012.0301",
                        "intensity": "9433.19",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "24",
                        "monoisotopic_mass": "2295.1371",
                        "monoisotopic_mz": "766.0530",
                        "intensity": "10871.05",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "25",
                        "monoisotopic_mass": "2359.0715",
                        "monoisotopic_mz": "787.3644",
                        "intensity": "7580.68",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "26",
                        "monoisotopic_mass": "2394.2076",
                        "monoisotopic_mz": "1198.1111",
                        "intensity": "7233.98",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "27",
                        "monoisotopic_mass": "2774.2972",
                        "monoisotopic_mz": "925.7730",
                        "intensity": "6647.57",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2774.2970",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "ion_sort_name": "B00025",
                                "ion_left_position": "25",
                                "mass_error": "0.0002",
                                "ppm": "0.07"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "28",
                        "monoisotopic_mass": "3501.7855",
                        "monoisotopic_mz": "876.4536",
                        "intensity": "9316.48",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "29",
                        "monoisotopic_mass": "3139.5706",
                        "monoisotopic_mz": "1047.5308",
                        "intensity": "8647.72",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "30",
                        "monoisotopic_mass": "3011.4970",
                        "monoisotopic_mz": "1004.8396",
                        "intensity": "8868.24",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "31",
                        "monoisotopic_mass": "3874.9941",
                        "monoisotopic_mz": "776.0061",
                        "intensity": "7821.80",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "32",
                        "monoisotopic_mass": "3422.7493",
                        "monoisotopic_mz": "856.6946",
                        "intensity": "8446.26",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "33",
                        "monoisotopic_mass": "1926.9343",
                        "monoisotopic_mz": "964.4744",
                        "intensity": "5711.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "34",
                        "monoisotopic_mass": "3603.8484",
                        "monoisotopic_mz": "901.9694",
                        "intensity": "7394.91",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "35",
                        "monoisotopic_mass": "2211.0822",
                        "monoisotopic_mz": "1106.5484",
                        "intensity": "6253.68",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "36",
                        "monoisotopic_mass": "3369.7515",
                        "monoisotopic_mz": "1124.2578",
                        "intensity": "7878.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "37",
                        "monoisotopic_mass": "2230.0133",
                        "monoisotopic_mz": "1116.0139",
                        "intensity": "6618.06",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "38",
                        "monoisotopic_mass": "2939.4638",
                        "monoisotopic_mz": "980.8285",
                        "intensity": "6223.04",
                        "charge": "3",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2939.4634",
                                "ion_position": "65",
                                "ion_display_position": "24",
                                "ion_sort_name": "Y00024",
                                "ion_left_position": "65",
                                "mass_error": "0.0004",
                                "ppm": "0.14"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "39",
                        "monoisotopic_mass": "2522.2672",
                        "monoisotopic_mz": "1262.1409",
                        "intensity": "6722.65",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "40",
                        "monoisotopic_mass": "2522.2670",
                        "monoisotopic_mz": "841.7629",
                        "intensity": "4816.06",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "41",
                        "monoisotopic_mass": "3121.5318",
                        "monoisotopic_mz": "1041.5179",
                        "intensity": "5243.26",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "42",
                        "monoisotopic_mass": "3121.5320",
                        "monoisotopic_mz": "781.3903",
                        "intensity": "8215.18",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "43",
                        "monoisotopic_mass": "3534.7998",
                        "monoisotopic_mz": "1179.2739",
                        "intensity": "7560.42",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "44",
                        "monoisotopic_mass": "2435.2965",
                        "monoisotopic_mz": "1218.6555",
                        "intensity": "4603.03",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2435.2995",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "ion_sort_name": "Y00020",
                                "ion_left_position": "69",
                                "mass_error": "-0.0030",
                                "ppm": "-1.23"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "45",
                        "monoisotopic_mass": "3501.7943",
                        "monoisotopic_mz": "1168.2720",
                        "intensity": "8954.42",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "46",
                        "monoisotopic_mass": "3533.7931",
                        "monoisotopic_mz": "707.7659",
                        "intensity": "4963.70",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "47",
                        "monoisotopic_mass": "1825.9201",
                        "monoisotopic_mz": "913.9673",
                        "intensity": "3794.51",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "48",
                        "monoisotopic_mass": "3802.9540",
                        "monoisotopic_mz": "951.7458",
                        "intensity": "8093.23",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "49",
                        "monoisotopic_mass": "3283.6905",
                        "monoisotopic_mz": "821.9299",
                        "intensity": "5730.15",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "50",
                        "monoisotopic_mass": "2542.1898",
                        "monoisotopic_mz": "848.4039",
                        "intensity": "6034.94",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "51",
                        "monoisotopic_mass": "2376.0761",
                        "monoisotopic_mz": "1189.0453",
                        "intensity": "4081.17",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "2376.0805",
                                "ion_position": "21",
                                "ion_display_position": "21",
                                "ion_sort_name": "B00021",
                                "ion_left_position": "21",
                                "mass_error": "-0.0044",
                                "ppm": "-1.85"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "52",
                        "monoisotopic_mass": "1248.6160",
                        "monoisotopic_mz": "1249.6233",
                        "intensity": "3938.42",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1248.6173",
                                "ion_position": "79",
                                "ion_display_position": "10",
                                "ion_sort_name": "Y00010",
                                "ion_left_position": "79",
                                "mass_error": "-0.0013",
                                "ppm": "-1.03"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "53",
                        "monoisotopic_mass": "4106.9912",
                        "monoisotopic_mz": "822.4055",
                        "intensity": "4337.36",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "54",
                        "monoisotopic_mass": "3138.5503",
                        "monoisotopic_mz": "785.6448",
                        "intensity": "6028.02",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3138.5591",
                                "ion_position": "63",
                                "ion_display_position": "26",
                                "ion_sort_name": "Y00026",
                                "ion_left_position": "63",
                                "mass_error": "-0.0088",
                                "ppm": "-2.81"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "55",
                        "monoisotopic_mass": "460.1590",
                        "monoisotopic_mz": "461.1663",
                        "intensity": "4221.12",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "56",
                        "monoisotopic_mass": "3892.0128",
                        "monoisotopic_mz": "974.0105",
                        "intensity": "4761.24",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "57",
                        "monoisotopic_mass": "2394.2023",
                        "monoisotopic_mz": "799.0747",
                        "intensity": "4586.89",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "58",
                        "monoisotopic_mass": "812.0993",
                        "monoisotopic_mz": "813.1066",
                        "intensity": "3295.34",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "59",
                        "monoisotopic_mass": "2562.2787",
                        "monoisotopic_mz": "1282.1466",
                        "intensity": "4235.37",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "60",
                        "monoisotopic_mass": "584.2906",
                        "monoisotopic_mz": "585.2979",
                        "intensity": "3073.63",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "584.2918",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "ion_sort_name": "B00006",
                                "ion_left_position": "6",
                                "mass_error": "-0.0012",
                                "ppm": "-2.03"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "61",
                        "monoisotopic_mass": "3602.8321",
                        "monoisotopic_mz": "721.5737",
                        "intensity": "3436.63",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "62",
                        "monoisotopic_mass": "3819.9679",
                        "monoisotopic_mz": "955.9992",
                        "intensity": "5286.83",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3819.9652",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "ion_sort_name": "Y00033",
                                "ion_left_position": "56",
                                "mass_error": "0.0027",
                                "ppm": "0.70"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "63",
                        "monoisotopic_mass": "3370.7564",
                        "monoisotopic_mz": "843.6964",
                        "intensity": "6457.18",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "64",
                        "monoisotopic_mass": "2870.3799",
                        "monoisotopic_mz": "957.8006",
                        "intensity": "3588.41",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "65",
                        "monoisotopic_mass": "4044.1017",
                        "monoisotopic_mz": "809.8276",
                        "intensity": "5796.21",
                        "charge": "5"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "66",
                        "monoisotopic_mass": "3874.9914",
                        "monoisotopic_mz": "1292.6711",
                        "intensity": "4745.69",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "67",
                        "monoisotopic_mass": "2973.3610",
                        "monoisotopic_mz": "992.1276",
                        "intensity": "5703.40",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "68",
                        "monoisotopic_mass": "7394.6269",
                        "monoisotopic_mz": "822.6325",
                        "intensity": "5158.40",
                        "charge": "9"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "69",
                        "monoisotopic_mass": "2846.4458",
                        "monoisotopic_mz": "1424.2302",
                        "intensity": "3831.25",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "70",
                        "monoisotopic_mass": "2490.1681",
                        "monoisotopic_mz": "623.5493",
                        "intensity": "3932.55",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "71",
                        "monoisotopic_mass": "1090.5562",
                        "monoisotopic_mz": "1091.5635",
                        "intensity": "2776.07",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "72",
                        "monoisotopic_mass": "1723.8595",
                        "monoisotopic_mz": "862.9370",
                        "intensity": "2921.85",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1723.8642",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "ion_sort_name": "B00016",
                                "ion_left_position": "16",
                                "mass_error": "-0.0047",
                                "ppm": "-2.73"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "73",
                        "monoisotopic_mass": "1140.5869",
                        "monoisotopic_mz": "571.3007",
                        "intensity": "3076.52",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1140.5887",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "ion_sort_name": "B00011",
                                "ion_left_position": "11",
                                "mass_error": "-0.0018",
                                "ppm": "-1.62"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "74",
                        "monoisotopic_mass": "2278.1215",
                        "monoisotopic_mz": "1140.0680",
                        "intensity": "5272.70",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "75",
                        "monoisotopic_mass": "3255.7280",
                        "monoisotopic_mz": "1086.2499",
                        "intensity": "2599.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "76",
                        "monoisotopic_mass": "2067.0226",
                        "monoisotopic_mz": "1034.5186",
                        "intensity": "3472.44",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "77",
                        "monoisotopic_mass": "2472.1503",
                        "monoisotopic_mz": "825.0574",
                        "intensity": "3171.93",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "78",
                        "monoisotopic_mass": "2154.0571",
                        "monoisotopic_mz": "1078.0358",
                        "intensity": "2581.96",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "79",
                        "monoisotopic_mass": "3088.5754",
                        "monoisotopic_mz": "1030.5324",
                        "intensity": "2967.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "80",
                        "monoisotopic_mass": "520.2676",
                        "monoisotopic_mz": "521.2748",
                        "intensity": "2418.47",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "520.2680",
                                "ion_position": "85",
                                "ion_display_position": "4",
                                "ion_sort_name": "Y00004",
                                "ion_left_position": "85",
                                "mass_error": "-0.0004",
                                "ppm": "-0.76"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "81",
                        "monoisotopic_mass": "6431.2115",
                        "monoisotopic_mz": "919.7518",
                        "intensity": "1694.40",
                        "charge": "7"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "82",
                        "monoisotopic_mass": "782.6946",
                        "monoisotopic_mz": "783.7019",
                        "intensity": "1740.85",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "83",
                        "monoisotopic_mass": "3010.5023",
                        "monoisotopic_mz": "753.6328",
                        "intensity": "4307.45",
                        "charge": "4",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "Y",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "3010.5005",
                                "ion_position": "64",
                                "ion_display_position": "25",
                                "ion_sort_name": "Y00025",
                                "ion_left_position": "64",
                                "mass_error": "0.0018",
                                "ppm": "0.59"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "84",
                        "monoisotopic_mass": "3576.8196",
                        "monoisotopic_mz": "895.2122",
                        "intensity": "5245.94",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "85",
                        "monoisotopic_mass": "729.3280",
                        "monoisotopic_mz": "730.3353",
                        "intensity": "1418.45",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "86",
                        "monoisotopic_mass": "2660.2738",
                        "monoisotopic_mz": "1331.1442",
                        "intensity": "1230.51",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "87",
                        "monoisotopic_mass": "640.3010",
                        "monoisotopic_mz": "641.3083",
                        "intensity": "1448.93",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "88",
                        "monoisotopic_mass": "1049.0224",
                        "monoisotopic_mz": "1050.0297",
                        "intensity": "1499.28",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "89",
                        "monoisotopic_mass": "3253.6262",
                        "monoisotopic_mz": "814.4138",
                        "intensity": "2811.93",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "90",
                        "monoisotopic_mass": "1944.4881",
                        "monoisotopic_mz": "973.2513",
                        "intensity": "1856.25",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "91",
                        "monoisotopic_mass": "8308.2476",
                        "monoisotopic_mz": "831.8320",
                        "intensity": "3218.22",
                        "charge": "10"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "92",
                        "monoisotopic_mass": "3719.9187",
                        "monoisotopic_mz": "930.9870",
                        "intensity": "7101.39",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "93",
                        "monoisotopic_mass": "606.2284",
                        "monoisotopic_mz": "607.2357",
                        "intensity": "3006.99",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "94",
                        "monoisotopic_mass": "705.2966",
                        "monoisotopic_mz": "706.3039",
                        "intensity": "1497.09",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "95",
                        "monoisotopic_mass": "893.7364",
                        "monoisotopic_mz": "894.7437",
                        "intensity": "1279.02",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "96",
                        "monoisotopic_mass": "1190.5950",
                        "monoisotopic_mz": "1191.6023",
                        "intensity": "1800.20",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "97",
                        "monoisotopic_mass": "2690.3296",
                        "monoisotopic_mz": "897.7838",
                        "intensity": "3092.80",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "98",
                        "monoisotopic_mass": "655.3290",
                        "monoisotopic_mz": "656.3362",
                        "intensity": "2945.88",
                        "charge": "1",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "655.3289",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "ion_sort_name": "B00007",
                                "ion_left_position": "7",
                                "mass_error": "0.0000",
                                "ppm": "0.05"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "99",
                        "monoisotopic_mass": "1450.7510",
                        "monoisotopic_mz": "726.3828",
                        "intensity": "2300.88",
                        "charge": "2",
                        "matched_ions_num": "1",
                        "matched_ions": {
                            "matched_ion": {
                                "ion_type": "B",
                                "match_shift": "0.0000000000",
                                "theoretical_mass": "1450.7528",
                                "ion_position": "14",
                                "ion_display_position": "14",
                                "ion_sort_name": "B00014",
                                "ion_left_position": "14",
                                "mass_error": "-0.0019",
                                "ppm": "-1.30"
                            }
                        }
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "100",
                        "monoisotopic_mass": "1627.3624",
                        "monoisotopic_mz": "814.6885",
                        "intensity": "1651.03",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "101",
                        "monoisotopic_mass": "6535.8845",
                        "monoisotopic_mz": "934.7051",
                        "intensity": "2646.20",
                        "charge": "7"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "102",
                        "monoisotopic_mass": "1008.8298",
                        "monoisotopic_mz": "1009.8371",
                        "intensity": "1515.96",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "103",
                        "monoisotopic_mass": "867.4352",
                        "monoisotopic_mz": "868.4424",
                        "intensity": "1506.41",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "104",
                        "monoisotopic_mass": "9485.4244",
                        "monoisotopic_mz": "863.3186",
                        "intensity": "1410.36",
                        "charge": "11"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "105",
                        "monoisotopic_mass": "1544.7512",
                        "monoisotopic_mz": "773.3829",
                        "intensity": "2694.61",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "106",
                        "monoisotopic_mass": "939.4852",
                        "monoisotopic_mz": "940.4925",
                        "intensity": "1365.97",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "107",
                        "monoisotopic_mass": "8871.9470",
                        "monoisotopic_mz": "888.2020",
                        "intensity": "1223.30",
                        "charge": "10"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "108",
                        "monoisotopic_mass": "7001.5931",
                        "monoisotopic_mz": "778.9621",
                        "intensity": "4755.35",
                        "charge": "9"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "109",
                        "monoisotopic_mass": "1437.7070",
                        "monoisotopic_mz": "1438.7142",
                        "intensity": "868.28",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "110",
                        "monoisotopic_mass": "3735.9147",
                        "monoisotopic_mz": "934.9860",
                        "intensity": "2226.45",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "111",
                        "monoisotopic_mass": "3818.9523",
                        "monoisotopic_mz": "1273.9914",
                        "intensity": "1802.08",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "112",
                        "monoisotopic_mass": "2419.1811",
                        "monoisotopic_mz": "1210.5978",
                        "intensity": "1193.89",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "113",
                        "monoisotopic_mass": "3029.5405",
                        "monoisotopic_mz": "1010.8541",
                        "intensity": "2573.17",
                        "charge": "3"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "114",
                        "monoisotopic_mass": "9255.7433",
                        "monoisotopic_mz": "772.3192",
                        "intensity": "1076.71",
                        "charge": "12"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "115",
                        "monoisotopic_mass": "2045.0299",
                        "monoisotopic_mz": "1023.5222",
                        "intensity": "1206.84",
                        "charge": "2"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "116",
                        "monoisotopic_mass": "6506.4258",
                        "monoisotopic_mz": "814.3105",
                        "intensity": "2553.26",
                        "charge": "8"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "117",
                        "monoisotopic_mass": "831.6274",
                        "monoisotopic_mz": "832.6347",
                        "intensity": "789.27",
                        "charge": "1"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "118",
                        "monoisotopic_mass": "3756.8349",
                        "monoisotopic_mz": "940.2160",
                        "intensity": "1862.58",
                        "charge": "4"
                    },
                    {
                        "spec_id": "183",
                        "peak_id": "119",
                        "monoisotopic_mass": "624.2966",
                        "monoisotopic_mz": "625.3039",
                        "intensity": "1091.20",
                        "charge": "1"
                    }
                ]
            }
        },
        "annotated_protein": {
            "sequence_id": "0",
            "proteoform_id": "6",
            "sequence_name": "sp|P0AES9|HDEA_ECOLI",
            "sequence_description": "Acid stress chaperone HdeA OS=Escherichia coli (strain K12) OX=83333 GN=hdeA PE=1 SV=1",
            "proteoform_mass": "9864.1419",
            "n_acetylation": "0",
            "unexpected_shift_number": "1",
            "annotation": {
                "protein_length": "110",
                "first_residue_position": "21",
                "last_residue_position": "109",
                "residue": [
                    {
                        "position": "0",
                        "acid": "M"
                    },
                    {
                        "position": "1",
                        "acid": "K"
                    },
                    {
                        "position": "2",
                        "acid": "K"
                    },
                    {
                        "position": "3",
                        "acid": "V"
                    },
                    {
                        "position": "4",
                        "acid": "L"
                    },
                    {
                        "position": "5",
                        "acid": "G"
                    },
                    {
                        "position": "6",
                        "acid": "V"
                    },
                    {
                        "position": "7",
                        "acid": "I"
                    },
                    {
                        "position": "8",
                        "acid": "L"
                    },
                    {
                        "position": "9",
                        "acid": "G"
                    },
                    {
                        "position": "10",
                        "acid": "G"
                    },
                    {
                        "position": "11",
                        "acid": "L"
                    },
                    {
                        "position": "12",
                        "acid": "L"
                    },
                    {
                        "position": "13",
                        "acid": "L"
                    },
                    {
                        "position": "14",
                        "acid": "L"
                    },
                    {
                        "position": "15",
                        "acid": "P"
                    },
                    {
                        "position": "16",
                        "acid": "V"
                    },
                    {
                        "position": "17",
                        "acid": "V"
                    },
                    {
                        "position": "18",
                        "acid": "S"
                    },
                    {
                        "position": "19",
                        "acid": "N"
                    },
                    {
                        "position": "20",
                        "acid": "A"
                    },
                    {
                        "position": "21",
                        "acid": "A"
                    },
                    {
                        "position": "22",
                        "acid": "D"
                    },
                    {
                        "position": "23",
                        "acid": "A"
                    },
                    {
                        "position": "24",
                        "acid": "Q"
                    },
                    {
                        "position": "25",
                        "acid": "K"
                    },
                    {
                        "position": "26",
                        "acid": "A"
                    },
                    {
                        "position": "27",
                        "acid": "A"
                    },
                    {
                        "position": "28",
                        "acid": "D"
                    },
                    {
                        "position": "29",
                        "acid": "N"
                    },
                    {
                        "position": "30",
                        "acid": "K"
                    },
                    {
                        "position": "31",
                        "acid": "K"
                    },
                    {
                        "position": "32",
                        "acid": "P"
                    },
                    {
                        "position": "33",
                        "acid": "V"
                    },
                    {
                        "position": "34",
                        "acid": "N"
                    },
                    {
                        "position": "35",
                        "acid": "S"
                    },
                    {
                        "position": "36",
                        "acid": "W"
                    },
                    {
                        "position": "37",
                        "acid": "T"
                    },
                    {
                        "position": "38",
                        "acid": "C"
                    },
                    {
                        "position": "39",
                        "acid": "E"
                    },
                    {
                        "position": "40",
                        "acid": "D"
                    },
                    {
                        "position": "41",
                        "acid": "F"
                    },
                    {
                        "position": "42",
                        "acid": "L"
                    },
                    {
                        "position": "43",
                        "acid": "A"
                    },
                    {
                        "position": "44",
                        "acid": "V"
                    },
                    {
                        "position": "45",
                        "acid": "D"
                    },
                    {
                        "position": "46",
                        "acid": "E"
                    },
                    {
                        "position": "47",
                        "acid": "S"
                    },
                    {
                        "position": "48",
                        "acid": "F"
                    },
                    {
                        "position": "49",
                        "acid": "Q"
                    },
                    {
                        "position": "50",
                        "acid": "P"
                    },
                    {
                        "position": "51",
                        "acid": "T"
                    },
                    {
                        "position": "52",
                        "acid": "A"
                    },
                    {
                        "position": "53",
                        "acid": "V"
                    },
                    {
                        "position": "54",
                        "acid": "G"
                    },
                    {
                        "position": "55",
                        "acid": "F"
                    },
                    {
                        "position": "56",
                        "acid": "A"
                    },
                    {
                        "position": "57",
                        "acid": "E"
                    },
                    {
                        "position": "58",
                        "acid": "A"
                    },
                    {
                        "position": "59",
                        "acid": "L"
                    },
                    {
                        "position": "60",
                        "acid": "N"
                    },
                    {
                        "position": "61",
                        "acid": "N"
                    },
                    {
                        "position": "62",
                        "acid": "K"
                    },
                    {
                        "position": "63",
                        "acid": "D"
                    },
                    {
                        "position": "64",
                        "acid": "K"
                    },
                    {
                        "position": "65",
                        "acid": "P"
                    },
                    {
                        "position": "66",
                        "acid": "E"
                    },
                    {
                        "position": "67",
                        "acid": "D"
                    },
                    {
                        "position": "68",
                        "acid": "A"
                    },
                    {
                        "position": "69",
                        "acid": "V"
                    },
                    {
                        "position": "70",
                        "acid": "L"
                    },
                    {
                        "position": "71",
                        "acid": "D"
                    },
                    {
                        "position": "72",
                        "acid": "V"
                    },
                    {
                        "position": "73",
                        "acid": "Q"
                    },
                    {
                        "position": "74",
                        "acid": "G"
                    },
                    {
                        "position": "75",
                        "acid": "I"
                    },
                    {
                        "position": "76",
                        "acid": "A"
                    },
                    {
                        "position": "77",
                        "acid": "T"
                    },
                    {
                        "position": "78",
                        "acid": "V"
                    },
                    {
                        "position": "79",
                        "acid": "T"
                    },
                    {
                        "position": "80",
                        "acid": "P"
                    },
                    {
                        "position": "81",
                        "acid": "A"
                    },
                    {
                        "position": "82",
                        "acid": "I"
                    },
                    {
                        "position": "83",
                        "acid": "V"
                    },
                    {
                        "position": "84",
                        "acid": "Q"
                    },
                    {
                        "position": "85",
                        "acid": "A"
                    },
                    {
                        "position": "86",
                        "acid": "C"
                    },
                    {
                        "position": "87",
                        "acid": "T"
                    },
                    {
                        "position": "88",
                        "acid": "Q"
                    },
                    {
                        "position": "89",
                        "acid": "D"
                    },
                    {
                        "position": "90",
                        "acid": "K"
                    },
                    {
                        "position": "91",
                        "acid": "Q"
                    },
                    {
                        "position": "92",
                        "acid": "A"
                    },
                    {
                        "position": "93",
                        "acid": "N"
                    },
                    {
                        "position": "94",
                        "acid": "F"
                    },
                    {
                        "position": "95",
                        "acid": "K"
                    },
                    {
                        "position": "96",
                        "acid": "D"
                    },
                    {
                        "position": "97",
                        "acid": "K"
                    },
                    {
                        "position": "98",
                        "acid": "V"
                    },
                    {
                        "position": "99",
                        "acid": "K"
                    },
                    {
                        "position": "100",
                        "acid": "G"
                    },
                    {
                        "position": "101",
                        "acid": "E"
                    },
                    {
                        "position": "102",
                        "acid": "W"
                    },
                    {
                        "position": "103",
                        "acid": "D"
                    },
                    {
                        "position": "104",
                        "acid": "K"
                    },
                    {
                        "position": "105",
                        "acid": "I"
                    },
                    {
                        "position": "106",
                        "acid": "K"
                    },
                    {
                        "position": "107",
                        "acid": "K"
                    },
                    {
                        "position": "108",
                        "acid": "D"
                    },
                    {
                        "position": "109",
                        "acid": "M"
                    }
                ],
                "cleavage": [
                    {
                        "position": "0",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "1",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "2",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "3",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "4",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "5",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "6",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "7",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "8",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "9",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "10",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "11",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "12",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "13",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "14",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "15",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "16",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "17",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "18",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "19",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "20",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "21",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "22",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "23",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "24",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "25",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "26",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "27",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "6",
                                "ion_display_position": "6",
                                "spec_id": "183",
                                "peak_id": "60",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "28",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "7",
                                "ion_display_position": "7",
                                "spec_id": "183",
                                "peak_id": "98",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "29",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "8",
                                "ion_display_position": "8",
                                "spec_id": "183",
                                "peak_id": "16",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "30",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "31",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "32",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "11",
                                "ion_display_position": "11",
                                "spec_id": "183",
                                "peak_id": "73",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "33",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "34",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "35",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "14",
                                "ion_display_position": "14",
                                "spec_id": "183",
                                "peak_id": "99",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "36",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "37",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "16",
                                "ion_display_position": "16",
                                "spec_id": "183",
                                "peak_id": "72",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "38",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "39",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "40",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "41",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "20",
                                "ion_display_position": "20",
                                "spec_id": "183",
                                "peak_id": "4",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "42",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": [
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "183",
                                    "peak_id": "51",
                                    "peak_charge": "2"
                                },
                                {
                                    "ion_type": "B",
                                    "ion_position": "21",
                                    "ion_display_position": "21",
                                    "spec_id": "183",
                                    "peak_id": "6",
                                    "peak_charge": "3"
                                }
                            ]
                        }
                    },
                    {
                        "position": "43",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "22",
                                "ion_display_position": "22",
                                "spec_id": "183",
                                "peak_id": "14",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "44",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "23",
                                "ion_display_position": "23",
                                "spec_id": "183",
                                "peak_id": "10",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "45",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "24",
                                "ion_display_position": "24",
                                "spec_id": "183",
                                "peak_id": "15",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "46",
                        "exist_n_ion": "1",
                        "exist_c_ion": "0",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "B",
                                "ion_position": "25",
                                "ion_display_position": "25",
                                "spec_id": "183",
                                "peak_id": "27",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "47",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "48",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "49",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "50",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "51",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "52",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "53",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "54",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "55",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "56",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "57",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "58",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "59",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "60",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "61",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "62",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "63",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "64",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "65",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "66",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "67",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "68",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "69",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "70",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "71",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "72",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "73",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "74",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "75",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "76",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "77",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "56",
                                "ion_display_position": "33",
                                "spec_id": "183",
                                "peak_id": "62",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "78",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "79",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "80",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "59",
                                "ion_display_position": "30",
                                "spec_id": "183",
                                "peak_id": "3",
                                "peak_charge": "5"
                            }
                        }
                    },
                    {
                        "position": "81",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "82",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "83",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "84",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "63",
                                "ion_display_position": "26",
                                "spec_id": "183",
                                "peak_id": "54",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "85",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "64",
                                "ion_display_position": "25",
                                "spec_id": "183",
                                "peak_id": "83",
                                "peak_charge": "4"
                            }
                        }
                    },
                    {
                        "position": "86",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "65",
                                "ion_display_position": "24",
                                "spec_id": "183",
                                "peak_id": "38",
                                "peak_charge": "3"
                            }
                        }
                    },
                    {
                        "position": "87",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "88",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "89",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "90",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "69",
                                "ion_display_position": "20",
                                "spec_id": "183",
                                "peak_id": "44",
                                "peak_charge": "2"
                            }
                        }
                    },
                    {
                        "position": "91",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "92",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "93",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "94",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "95",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "96",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "97",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "98",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "99",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "100",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "79",
                                "ion_display_position": "10",
                                "spec_id": "183",
                                "peak_id": "52",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "101",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "102",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "103",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "104",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "105",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "106",
                        "exist_n_ion": "0",
                        "exist_c_ion": "1",
                        "matched_peaks": {
                            "matched_peak": {
                                "ion_type": "Y",
                                "ion_position": "85",
                                "ion_display_position": "4",
                                "spec_id": "183",
                                "peak_id": "80",
                                "peak_charge": "1"
                            }
                        }
                    },
                    {
                        "position": "107",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "108",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "109",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    },
                    {
                        "position": "110",
                        "exist_n_ion": "0",
                        "exist_c_ion": "0",
                        "matched_peaks": null
                    }
                ],
                "ptm": {
                    "ptm_type": "Fixed",
                    "ptm": {
                        "abbreviation": "Carbamidomethylation",
                        "unimod": "-1",
                        "mono_mass": "57.0214640000"
                    },
                    "occurence": [
                        {
                            "left_pos": "38",
                            "right_pos": "39",
                            "anno": "C"
                        },
                        {
                            "left_pos": "86",
                            "right_pos": "87",
                            "anno": "C"
                        }
                    ]
                },
                "mass_shift": {
                    "id": "0",
                    "left_position": "46",
                    "right_position": "77",
                    "anno": "15.2702",
                    "shift_type": "unexpected"
                }
            }
        }
    }
}
