prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "6",
        "sequence_name": "sp|P60438|RL3_ECOLI",
        "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
        "proteoform_id": "8",
        "prsm_number": "5",
        "prsm": [
            {
                "prsm_id": "91",
                "p_value": "1.89e-09",
                "e_value": "1.89e-09",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "96",
                        "ms1_scans": "223",
                        "ids": "126",
                        "scans": "224",
                        "precursor_mono_mass": "5199.8466",
                        "precursor_charge": "7",
                        "precursor_mz": "743.8425",
                        "feature_inte": "1.7573e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "126",
                                "peak_id": "0",
                                "monoisotopic_mass": "3676.9876",
                                "monoisotopic_mz": "920.2542",
                                "intensity": "30916.34",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0007",
                                        "ppm": "0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "1",
                                "monoisotopic_mass": "3321.7635",
                                "monoisotopic_mz": "831.4482",
                                "intensity": "19055.66",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "2",
                                "monoisotopic_mass": "1522.8720",
                                "monoisotopic_mz": "762.4433",
                                "intensity": "22562.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0001",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "3",
                                "monoisotopic_mass": "1522.8713",
                                "monoisotopic_mz": "508.6310",
                                "intensity": "20636.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "4",
                                "monoisotopic_mass": "3647.9900",
                                "monoisotopic_mz": "730.6053",
                                "intensity": "11452.78",
                                "charge": "5"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "5",
                                "monoisotopic_mass": "4262.2264",
                                "monoisotopic_mz": "853.4526",
                                "intensity": "12098.00",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "0.0000",
                                        "ppm": "0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "6",
                                "monoisotopic_mass": "4375.3076",
                                "monoisotopic_mz": "876.0688",
                                "intensity": "9774.49",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4375.3104",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "7",
                                "monoisotopic_mass": "3554.9048",
                                "monoisotopic_mz": "889.7335",
                                "intensity": "4460.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "8",
                                "monoisotopic_mass": "3224.7033",
                                "monoisotopic_mz": "807.1831",
                                "intensity": "3790.23",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "9",
                                "monoisotopic_mass": "3448.8614",
                                "monoisotopic_mz": "863.2226",
                                "intensity": "6479.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "10",
                                "monoisotopic_mass": "5181.8420",
                                "monoisotopic_mz": "741.2704",
                                "intensity": "8290.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "11",
                                "monoisotopic_mass": "4939.7253",
                                "monoisotopic_mz": "824.2948",
                                "intensity": "5542.40",
                                "charge": "6"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "12",
                                "monoisotopic_mass": "484.3008",
                                "monoisotopic_mz": "485.3080",
                                "intensity": "3811.25",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3010",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "13",
                                "monoisotopic_mass": "742.8371",
                                "monoisotopic_mz": "743.8444",
                                "intensity": "6209.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "14",
                                "monoisotopic_mass": "3359.7873",
                                "monoisotopic_mz": "840.9541",
                                "intensity": "4211.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "15",
                                "monoisotopic_mass": "395.2530",
                                "monoisotopic_mz": "396.2603",
                                "intensity": "2148.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "16",
                                "monoisotopic_mass": "468.8158",
                                "monoisotopic_mz": "469.8231",
                                "intensity": "1826.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "17",
                                "monoisotopic_mass": "1433.8236",
                                "monoisotopic_mz": "717.9191",
                                "intensity": "2372.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "18",
                                "monoisotopic_mass": "1844.8865",
                                "monoisotopic_mz": "923.4505",
                                "intensity": "1133.99",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1844.8873",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "19",
                                "monoisotopic_mass": "2413.2198",
                                "monoisotopic_mz": "805.4139",
                                "intensity": "3036.99",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2413.2206",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "20",
                                "monoisotopic_mass": "3416.8546",
                                "monoisotopic_mz": "1139.9588",
                                "intensity": "2840.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "21",
                                "monoisotopic_mass": "3337.7864",
                                "monoisotopic_mz": "835.4539",
                                "intensity": "4059.25",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "22",
                                "monoisotopic_mass": "2746.1531",
                                "monoisotopic_mz": "916.3917",
                                "intensity": "1100.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "23",
                                "monoisotopic_mass": "4348.2977",
                                "monoisotopic_mz": "870.6668",
                                "intensity": "1065.66",
                                "charge": "5"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "24",
                                "monoisotopic_mass": "873.2626",
                                "monoisotopic_mz": "874.2698",
                                "intensity": "1225.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "25",
                                "monoisotopic_mass": "711.4645",
                                "monoisotopic_mz": "712.4717",
                                "intensity": "3480.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0001",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "26",
                                "monoisotopic_mass": "726.7939",
                                "monoisotopic_mz": "727.8011",
                                "intensity": "1265.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "27",
                                "monoisotopic_mass": "850.0445",
                                "monoisotopic_mz": "851.0518",
                                "intensity": "975.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "28",
                                "monoisotopic_mass": "1297.7612",
                                "monoisotopic_mz": "649.8879",
                                "intensity": "677.27",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1297.7606",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "37",
                                        "mass_error": "0.0006",
                                        "ppm": "0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "29",
                                "monoisotopic_mass": "4132.6176",
                                "monoisotopic_mz": "827.5308",
                                "intensity": "1722.47",
                                "charge": "5"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "30",
                                "monoisotopic_mass": "1368.7994",
                                "monoisotopic_mz": "685.4070",
                                "intensity": "711.79",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1368.7977",
                                        "ion_position": "36",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "Y00014",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0017",
                                        "ppm": "1.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "31",
                                "monoisotopic_mass": "2970.6624",
                                "monoisotopic_mz": "743.6729",
                                "intensity": "682.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "32",
                                "monoisotopic_mass": "4859.7140",
                                "monoisotopic_mz": "695.2521",
                                "intensity": "1027.90",
                                "charge": "7"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "33",
                                "monoisotopic_mass": "1498.2080",
                                "monoisotopic_mz": "750.1113",
                                "intensity": "689.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "34",
                                "monoisotopic_mass": "966.9933",
                                "monoisotopic_mz": "968.0005",
                                "intensity": "719.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "35",
                                "monoisotopic_mass": "3712.8267",
                                "monoisotopic_mz": "743.5726",
                                "intensity": "56423.14",
                                "charge": "5"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "36",
                                "monoisotopic_mass": "1412.7683",
                                "monoisotopic_mz": "707.3914",
                                "intensity": "1182.61",
                                "charge": "2"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "37",
                                "monoisotopic_mass": "4504.3704",
                                "monoisotopic_mz": "901.8813",
                                "intensity": "2401.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "38",
                                "monoisotopic_mass": "1388.3397",
                                "monoisotopic_mz": "695.1771",
                                "intensity": "480.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "39",
                                "monoisotopic_mass": "2662.9471",
                                "monoisotopic_mz": "888.6563",
                                "intensity": "2662.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "40",
                                "monoisotopic_mass": "887.7264",
                                "monoisotopic_mz": "888.7337",
                                "intensity": "849.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "41",
                                "monoisotopic_mass": "778.8043",
                                "monoisotopic_mz": "779.8116",
                                "intensity": "830.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "126",
                                "peak_id": "42",
                                "monoisotopic_mass": "1021.5517",
                                "monoisotopic_mz": "1022.5590",
                                "intensity": "818.87",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "6",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "126",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "126",
                                        "peak_id": "19",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "126",
                                        "peak_id": "1",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "126",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "126",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "126",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "36",
                                        "ion_display_position": "14",
                                        "spec_id": "126",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "spec_id": "126",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "126",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "126",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "126",
                                        "peak_id": "25",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "126",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "154",
                "p_value": "7.65e-09",
                "e_value": "7.65e-09",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "122",
                        "ms1_scans": "336",
                        "ids": "217",
                        "scans": "341",
                        "precursor_mono_mass": "5198.8477",
                        "precursor_charge": "7",
                        "precursor_mz": "743.6998",
                        "feature_inte": "1.7573e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "217",
                                "peak_id": "0",
                                "monoisotopic_mass": "3676.9849",
                                "monoisotopic_mz": "920.2535",
                                "intensity": "20376.94",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "1",
                                "monoisotopic_mass": "1522.8712",
                                "monoisotopic_mz": "762.4429",
                                "intensity": "18744.24",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "2",
                                "monoisotopic_mass": "1522.8707",
                                "monoisotopic_mz": "508.6308",
                                "intensity": "16013.45",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0013",
                                        "ppm": "-0.83"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "3",
                                "monoisotopic_mass": "3321.7647",
                                "monoisotopic_mz": "831.4485",
                                "intensity": "17893.63",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "4",
                                "monoisotopic_mass": "3648.9961",
                                "monoisotopic_mz": "730.8065",
                                "intensity": "11509.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "5",
                                "monoisotopic_mass": "4376.3090",
                                "monoisotopic_mz": "876.2691",
                                "intensity": "9886.59",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "6",
                                "monoisotopic_mass": "4262.2227",
                                "monoisotopic_mz": "853.4518",
                                "intensity": "11508.24",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "7",
                                "monoisotopic_mass": "5070.7547",
                                "monoisotopic_mz": "846.1331",
                                "intensity": "5272.79",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5071.7639",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0068",
                                        "ppm": "-1.34"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "8",
                                "monoisotopic_mass": "743.2665",
                                "monoisotopic_mz": "744.2737",
                                "intensity": "25122.69",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "9",
                                "monoisotopic_mass": "3221.6924",
                                "monoisotopic_mz": "806.4304",
                                "intensity": "4468.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "10",
                                "monoisotopic_mass": "5181.8322",
                                "monoisotopic_mz": "741.2690",
                                "intensity": "6778.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "11",
                                "monoisotopic_mass": "3449.8599",
                                "monoisotopic_mz": "863.4723",
                                "intensity": "4614.45",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0000",
                                        "ppm": "0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "12",
                                "monoisotopic_mass": "711.4642",
                                "monoisotopic_mz": "712.4715",
                                "intensity": "3946.64",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "13",
                                "monoisotopic_mass": "484.3006",
                                "monoisotopic_mz": "485.3079",
                                "intensity": "2945.48",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3010",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "14",
                                "monoisotopic_mass": "1485.6748",
                                "monoisotopic_mz": "743.8447",
                                "intensity": "5139.95",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "15",
                                "monoisotopic_mass": "3577.9171",
                                "monoisotopic_mz": "895.4865",
                                "intensity": "3136.70",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3577.9185",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0014",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "16",
                                "monoisotopic_mass": "2413.2196",
                                "monoisotopic_mz": "805.4138",
                                "intensity": "2787.54",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2413.2206",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "17",
                                "monoisotopic_mass": "3555.9043",
                                "monoisotopic_mz": "889.9833",
                                "intensity": "3560.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "18",
                                "monoisotopic_mass": "1425.8181",
                                "monoisotopic_mz": "713.9163",
                                "intensity": "2888.94",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1425.8192",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "19",
                                "monoisotopic_mass": "585.2392",
                                "monoisotopic_mz": "586.2465",
                                "intensity": "1558.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "20",
                                "monoisotopic_mass": "3985.1872",
                                "monoisotopic_mz": "798.0447",
                                "intensity": "2269.28",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "21",
                                "monoisotopic_mass": "759.0688",
                                "monoisotopic_mz": "760.0761",
                                "intensity": "1493.73",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "22",
                                "monoisotopic_mass": "1297.7595",
                                "monoisotopic_mz": "649.8870",
                                "intensity": "593.48",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1297.7606",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "Y00013",
                                        "ion_left_position": "37",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "23",
                                "monoisotopic_mass": "2970.3467",
                                "monoisotopic_mz": "743.5939",
                                "intensity": "4228.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "24",
                                "monoisotopic_mass": "877.4726",
                                "monoisotopic_mz": "878.4799",
                                "intensity": "1455.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "25",
                                "monoisotopic_mass": "2227.9325",
                                "monoisotopic_mz": "743.6514",
                                "intensity": "21934.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "26",
                                "monoisotopic_mass": "5044.6824",
                                "monoisotopic_mz": "841.7877",
                                "intensity": "954.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "27",
                                "monoisotopic_mass": "3512.8760",
                                "monoisotopic_mz": "879.2263",
                                "intensity": "984.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "28",
                                "monoisotopic_mass": "3293.7795",
                                "monoisotopic_mz": "824.4522",
                                "intensity": "2461.19",
                                "charge": "4"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "29",
                                "monoisotopic_mass": "1394.8197",
                                "monoisotopic_mz": "698.4171",
                                "intensity": "962.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "30",
                                "monoisotopic_mass": "3531.9988",
                                "monoisotopic_mz": "707.4070",
                                "intensity": "1004.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "31",
                                "monoisotopic_mass": "1499.3895",
                                "monoisotopic_mz": "750.7020",
                                "intensity": "677.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "32",
                                "monoisotopic_mass": "4401.3591",
                                "monoisotopic_mz": "881.2791",
                                "intensity": "2466.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "33",
                                "monoisotopic_mass": "797.4304",
                                "monoisotopic_mz": "798.4377",
                                "intensity": "434.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "217",
                                "peak_id": "34",
                                "monoisotopic_mass": "1064.2437",
                                "monoisotopic_mz": "1065.2510",
                                "intensity": "748.59",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "6",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "spec_id": "217",
                                        "peak_id": "7",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "217",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "217",
                                        "peak_id": "3",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "217",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "217",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "217",
                                            "peak_id": "2",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "217",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "217",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "spec_id": "217",
                                        "peak_id": "18",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "37",
                                        "ion_display_position": "13",
                                        "spec_id": "217",
                                        "peak_id": "22",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "217",
                                        "peak_id": "6",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "217",
                                        "peak_id": "12",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "217",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "120",
                "p_value": "9.34e-09",
                "e_value": "9.34e-09",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "110",
                        "ms1_scans": "278",
                        "ids": "167",
                        "scans": "279",
                        "precursor_mono_mass": "5199.8492",
                        "precursor_charge": "7",
                        "precursor_mz": "743.8429",
                        "feature_inte": "1.7573e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "167",
                                "peak_id": "0",
                                "monoisotopic_mass": "3676.9849",
                                "monoisotopic_mz": "920.2535",
                                "intensity": "26001.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "1",
                                "monoisotopic_mass": "3321.7686",
                                "monoisotopic_mz": "831.4494",
                                "intensity": "19438.92",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "0.0037",
                                        "ppm": "1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "2",
                                "monoisotopic_mass": "1522.8718",
                                "monoisotopic_mz": "762.4432",
                                "intensity": "18811.54",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "3",
                                "monoisotopic_mass": "1522.8711",
                                "monoisotopic_mz": "508.6310",
                                "intensity": "16771.47",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "4",
                                "monoisotopic_mass": "5181.8339",
                                "monoisotopic_mz": "741.2693",
                                "intensity": "12241.71",
                                "charge": "7"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "5",
                                "monoisotopic_mass": "4375.3100",
                                "monoisotopic_mz": "876.0693",
                                "intensity": "8089.22",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4375.3104",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "6",
                                "monoisotopic_mass": "3648.9914",
                                "monoisotopic_mz": "730.8056",
                                "intensity": "10088.44",
                                "charge": "5"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "7",
                                "monoisotopic_mass": "4262.2215",
                                "monoisotopic_mz": "853.4516",
                                "intensity": "11310.12",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4262.2264",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0049",
                                        "ppm": "-1.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "8",
                                "monoisotopic_mass": "3449.8599",
                                "monoisotopic_mz": "863.4723",
                                "intensity": "6779.09",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "0.0000",
                                        "ppm": "0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "9",
                                "monoisotopic_mass": "3222.7016",
                                "monoisotopic_mz": "806.6827",
                                "intensity": "4646.59",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3222.6965",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0051",
                                        "ppm": "1.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "10",
                                "monoisotopic_mass": "3553.9003",
                                "monoisotopic_mz": "889.4824",
                                "intensity": "3614.11",
                                "charge": "4"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "11",
                                "monoisotopic_mass": "5070.7650",
                                "monoisotopic_mz": "846.1348",
                                "intensity": "4869.30",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5071.7639",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "1",
                                        "mass_error": "0.0035",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "12",
                                "monoisotopic_mass": "4487.3916",
                                "monoisotopic_mz": "898.4856",
                                "intensity": "4029.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "13",
                                "monoisotopic_mass": "711.4637",
                                "monoisotopic_mz": "712.4710",
                                "intensity": "2865.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "14",
                                "monoisotopic_mass": "1485.6731",
                                "monoisotopic_mz": "743.8438",
                                "intensity": "5587.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "15",
                                "monoisotopic_mass": "4939.7161",
                                "monoisotopic_mz": "824.2933",
                                "intensity": "4672.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "16",
                                "monoisotopic_mass": "937.6313",
                                "monoisotopic_mz": "469.8229",
                                "intensity": "1949.39",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "937.6325",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0012",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "17",
                                "monoisotopic_mass": "2970.4886",
                                "monoisotopic_mz": "743.6294",
                                "intensity": "1251.56",
                                "charge": "4"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "18",
                                "monoisotopic_mass": "484.3004",
                                "monoisotopic_mz": "485.3077",
                                "intensity": "3349.30",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3010",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-1.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "19",
                                "monoisotopic_mass": "1425.8182",
                                "monoisotopic_mz": "713.9164",
                                "intensity": "2492.35",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1425.8192",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "20",
                                "monoisotopic_mass": "729.7985",
                                "monoisotopic_mz": "730.8058",
                                "intensity": "2199.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "21",
                                "monoisotopic_mass": "1788.9591",
                                "monoisotopic_mz": "895.4868",
                                "intensity": "1836.15",
                                "charge": "2"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "22",
                                "monoisotopic_mass": "1612.8526",
                                "monoisotopic_mz": "807.4336",
                                "intensity": "1765.11",
                                "charge": "2"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "23",
                                "monoisotopic_mass": "1471.0007",
                                "monoisotopic_mz": "736.5076",
                                "intensity": "686.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "24",
                                "monoisotopic_mass": "821.1706",
                                "monoisotopic_mz": "822.1779",
                                "intensity": "943.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "25",
                                "monoisotopic_mass": "622.4169",
                                "monoisotopic_mz": "623.4241",
                                "intensity": "1902.76",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "26",
                                "monoisotopic_mass": "3713.4545",
                                "monoisotopic_mz": "743.6982",
                                "intensity": "966.33",
                                "charge": "5"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "27",
                                "monoisotopic_mass": "5196.8572",
                                "monoisotopic_mz": "743.4154",
                                "intensity": "5772.25",
                                "charge": "7"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "28",
                                "monoisotopic_mass": "3678.9983",
                                "monoisotopic_mz": "736.8069",
                                "intensity": "1302.08",
                                "charge": "5"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "29",
                                "monoisotopic_mass": "2230.0854",
                                "monoisotopic_mz": "744.3691",
                                "intensity": "8999.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "30",
                                "monoisotopic_mass": "1107.5885",
                                "monoisotopic_mz": "1108.5958",
                                "intensity": "1850.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "31",
                                "monoisotopic_mass": "4126.6644",
                                "monoisotopic_mz": "826.3402",
                                "intensity": "2378.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "32",
                                "monoisotopic_mass": "1064.5569",
                                "monoisotopic_mz": "1065.5642",
                                "intensity": "1172.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "33",
                                "monoisotopic_mass": "1371.8014",
                                "monoisotopic_mz": "686.9080",
                                "intensity": "1554.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "34",
                                "monoisotopic_mass": "834.3054",
                                "monoisotopic_mz": "835.3127",
                                "intensity": "854.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "167",
                                "peak_id": "35",
                                "monoisotopic_mass": "1012.1096",
                                "monoisotopic_mz": "1013.1169",
                                "intensity": "856.70",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "6",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "spec_id": "167",
                                        "peak_id": "11",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "167",
                                        "peak_id": "9",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "167",
                                        "peak_id": "1",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "167",
                                        "peak_id": "8",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "167",
                                            "peak_id": "3",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "167",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "167",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "spec_id": "167",
                                        "peak_id": "19",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "41",
                                            "ion_display_position": "9",
                                            "spec_id": "167",
                                            "peak_id": "16",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "41",
                                            "ion_display_position": "41",
                                            "spec_id": "167",
                                            "peak_id": "7",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "167",
                                        "peak_id": "5",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "167",
                                        "peak_id": "13",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "167",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "61",
                "p_value": "7.65e-08",
                "e_value": "7.65e-08",
                "fdr": "0",
                "matched_fragment_number": "11",
                "matched_peak_number": "13",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "82",
                        "ms1_scans": "166",
                        "ids": "83",
                        "scans": "167",
                        "precursor_mono_mass": "5199.8423",
                        "precursor_charge": "7",
                        "precursor_mz": "743.8419",
                        "feature_inte": "1.7573e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "83",
                                "peak_id": "0",
                                "monoisotopic_mass": "3676.9859",
                                "monoisotopic_mz": "920.2537",
                                "intensity": "15763.28",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "1",
                                "monoisotopic_mass": "1522.8717",
                                "monoisotopic_mz": "762.4431",
                                "intensity": "22505.70",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "2",
                                "monoisotopic_mass": "3648.9905",
                                "monoisotopic_mz": "730.8054",
                                "intensity": "7678.11",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "3",
                                "monoisotopic_mass": "4261.2213",
                                "monoisotopic_mz": "853.2515",
                                "intensity": "11779.32",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "4",
                                "monoisotopic_mass": "3321.7644",
                                "monoisotopic_mz": "831.4484",
                                "intensity": "15542.26",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "5",
                                "monoisotopic_mass": "5070.7570",
                                "monoisotopic_mz": "846.1334",
                                "intensity": "8835.25",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5071.7639",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0046",
                                        "ppm": "-0.90"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "6",
                                "monoisotopic_mass": "3449.8585",
                                "monoisotopic_mz": "863.4719",
                                "intensity": "7067.52",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.42"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "7",
                                "monoisotopic_mass": "1522.8712",
                                "monoisotopic_mz": "508.6310",
                                "intensity": "17676.16",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "8",
                                "monoisotopic_mass": "742.8368",
                                "monoisotopic_mz": "743.8441",
                                "intensity": "9542.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "9",
                                "monoisotopic_mass": "4374.3101",
                                "monoisotopic_mz": "875.8693",
                                "intensity": "8547.00",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "10",
                                "monoisotopic_mass": "5181.8369",
                                "monoisotopic_mz": "741.2697",
                                "intensity": "11417.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "11",
                                "monoisotopic_mass": "3222.6997",
                                "monoisotopic_mz": "806.6822",
                                "intensity": "6091.82",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3222.6965",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0032",
                                        "ppm": "0.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "12",
                                "monoisotopic_mass": "3337.7892",
                                "monoisotopic_mz": "835.4546",
                                "intensity": "5669.57",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "13",
                                "monoisotopic_mass": "1486.2469",
                                "monoisotopic_mz": "744.1307",
                                "intensity": "35695.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "14",
                                "monoisotopic_mass": "1425.8181",
                                "monoisotopic_mz": "713.9163",
                                "intensity": "2358.88",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1425.8192",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "Y00015",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "15",
                                "monoisotopic_mass": "3547.8955",
                                "monoisotopic_mz": "1183.6391",
                                "intensity": "2826.34",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "16",
                                "monoisotopic_mass": "3554.9019",
                                "monoisotopic_mz": "889.7328",
                                "intensity": "2908.82",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "17",
                                "monoisotopic_mass": "919.4982",
                                "monoisotopic_mz": "920.5055",
                                "intensity": "3244.08",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "18",
                                "monoisotopic_mass": "484.3005",
                                "monoisotopic_mz": "485.3078",
                                "intensity": "3320.49",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "484.3010",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "ion_sort_name": "Y00005",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.99"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "19",
                                "monoisotopic_mass": "838.0593",
                                "monoisotopic_mz": "839.0665",
                                "intensity": "1160.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "20",
                                "monoisotopic_mass": "4487.3938",
                                "monoisotopic_mz": "898.4860",
                                "intensity": "5556.83",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "21",
                                "monoisotopic_mass": "729.7985",
                                "monoisotopic_mz": "730.8058",
                                "intensity": "2024.62",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "22",
                                "monoisotopic_mass": "3321.7640",
                                "monoisotopic_mz": "1108.2619",
                                "intensity": "1030.47",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "23",
                                "monoisotopic_mass": "818.9034",
                                "monoisotopic_mz": "819.9106",
                                "intensity": "893.35",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "24",
                                "monoisotopic_mass": "4415.2346",
                                "monoisotopic_mz": "884.0542",
                                "intensity": "1221.39",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "25",
                                "monoisotopic_mass": "2870.4895",
                                "monoisotopic_mz": "718.6296",
                                "intensity": "2408.61",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "26",
                                "monoisotopic_mass": "3158.6700",
                                "monoisotopic_mz": "790.6748",
                                "intensity": "2312.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "27",
                                "monoisotopic_mass": "2612.3448",
                                "monoisotopic_mz": "871.7889",
                                "intensity": "985.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "28",
                                "monoisotopic_mass": "711.4638",
                                "monoisotopic_mz": "712.4711",
                                "intensity": "2349.32",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "711.4643",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "ion_sort_name": "Y00007",
                                        "ion_left_position": "43",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "29",
                                "monoisotopic_mass": "789.4105",
                                "monoisotopic_mz": "790.4178",
                                "intensity": "1381.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "30",
                                "monoisotopic_mass": "3531.9121",
                                "monoisotopic_mz": "707.3897",
                                "intensity": "1569.38",
                                "charge": "5"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "31",
                                "monoisotopic_mass": "1001.0242",
                                "monoisotopic_mz": "1002.0315",
                                "intensity": "1090.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "32",
                                "monoisotopic_mass": "2976.0897",
                                "monoisotopic_mz": "745.0297",
                                "intensity": "1752.33",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "33",
                                "monoisotopic_mass": "3006.6394",
                                "monoisotopic_mz": "752.6671",
                                "intensity": "1773.44",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "34",
                                "monoisotopic_mass": "602.5270",
                                "monoisotopic_mz": "603.5343",
                                "intensity": "1557.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "35",
                                "monoisotopic_mass": "3574.8839",
                                "monoisotopic_mz": "894.7283",
                                "intensity": "755.08",
                                "charge": "4"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "36",
                                "monoisotopic_mass": "937.6313",
                                "monoisotopic_mz": "469.8229",
                                "intensity": "1272.65",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "937.6325",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0012",
                                        "ppm": "-1.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "37",
                                "monoisotopic_mass": "1790.4625",
                                "monoisotopic_mz": "896.2385",
                                "intensity": "1837.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "38",
                                "monoisotopic_mass": "2413.2271",
                                "monoisotopic_mz": "805.4163",
                                "intensity": "2981.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2413.2206",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0065",
                                        "ppm": "2.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "39",
                                "monoisotopic_mass": "2475.9720",
                                "monoisotopic_mz": "826.3313",
                                "intensity": "1121.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "40",
                                "monoisotopic_mass": "2221.3637",
                                "monoisotopic_mz": "741.4618",
                                "intensity": "1386.67",
                                "charge": "3"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "41",
                                "monoisotopic_mass": "4547.1627",
                                "monoisotopic_mz": "758.8677",
                                "intensity": "2448.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "83",
                                "peak_id": "42",
                                "monoisotopic_mass": "1499.2706",
                                "monoisotopic_mz": "750.6426",
                                "intensity": "581.13",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "6",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "spec_id": "83",
                                        "peak_id": "5",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "83",
                                        "peak_id": "38",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "83",
                                        "peak_id": "11",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "83",
                                            "peak_id": "22",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "30",
                                            "ion_display_position": "30",
                                            "spec_id": "83",
                                            "peak_id": "4",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "83",
                                        "peak_id": "6",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "83",
                                            "peak_id": "7",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "83",
                                            "peak_id": "1",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "83",
                                            "peak_id": "0",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "35",
                                        "ion_display_position": "15",
                                        "spec_id": "83",
                                        "peak_id": "14",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "spec_id": "83",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "43",
                                        "ion_display_position": "7",
                                        "spec_id": "83",
                                        "peak_id": "28",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "45",
                                        "ion_display_position": "5",
                                        "spec_id": "83",
                                        "peak_id": "18",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            },
            {
                "prsm_id": "33",
                "p_value": "4.82e-05",
                "e_value": "4.82e-05",
                "fdr": "0",
                "matched_fragment_number": "9",
                "matched_peak_number": "10",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "69",
                        "ms1_scans": "110",
                        "ids": "41",
                        "scans": "112",
                        "precursor_mono_mass": "5199.8389",
                        "precursor_charge": "7",
                        "precursor_mz": "743.8414",
                        "feature_inte": "1.7573e+07"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "41",
                                "peak_id": "0",
                                "monoisotopic_mass": "3321.7623",
                                "monoisotopic_mz": "831.4479",
                                "intensity": "16147.03",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3321.7649",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "ion_sort_name": "B00030",
                                        "ion_left_position": "30",
                                        "mass_error": "-0.0026",
                                        "ppm": "-0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "1",
                                "monoisotopic_mass": "3676.9873",
                                "monoisotopic_mz": "920.2541",
                                "intensity": "15494.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3676.9869",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0004",
                                        "ppm": "0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "2",
                                "monoisotopic_mass": "1522.8719",
                                "monoisotopic_mz": "762.4432",
                                "intensity": "16611.67",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "3",
                                "monoisotopic_mass": "3648.9929",
                                "monoisotopic_mz": "730.8059",
                                "intensity": "10401.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "4",
                                "monoisotopic_mass": "1522.8713",
                                "monoisotopic_mz": "508.6310",
                                "intensity": "12504.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1522.8719",
                                        "ion_position": "34",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "Y00016",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "5",
                                "monoisotopic_mass": "5181.8369",
                                "monoisotopic_mz": "741.2697",
                                "intensity": "5415.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "6",
                                "monoisotopic_mass": "4261.2295",
                                "monoisotopic_mz": "853.2532",
                                "intensity": "9237.26",
                                "charge": "5"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "7",
                                "monoisotopic_mass": "3449.8570",
                                "monoisotopic_mz": "863.4715",
                                "intensity": "4970.28",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3449.8599",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "8",
                                "monoisotopic_mass": "4375.3045",
                                "monoisotopic_mz": "876.0682",
                                "intensity": "9077.64",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4375.3104",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0059",
                                        "ppm": "-1.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "9",
                                "monoisotopic_mass": "5071.7633",
                                "monoisotopic_mz": "846.3012",
                                "intensity": "5671.87",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5071.7639",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "ion_sort_name": "Y00049",
                                        "ion_left_position": "1",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "10",
                                "monoisotopic_mass": "3223.6931",
                                "monoisotopic_mz": "806.9305",
                                "intensity": "5613.26",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "11",
                                "monoisotopic_mass": "743.1236",
                                "monoisotopic_mz": "744.1309",
                                "intensity": "21055.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "12",
                                "monoisotopic_mass": "3554.9052",
                                "monoisotopic_mz": "889.7336",
                                "intensity": "4444.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "13",
                                "monoisotopic_mass": "395.2527",
                                "monoisotopic_mz": "396.2600",
                                "intensity": "2089.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "14",
                                "monoisotopic_mass": "3110.6133",
                                "monoisotopic_mz": "778.6606",
                                "intensity": "1483.21",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "15",
                                "monoisotopic_mass": "1183.2978",
                                "monoisotopic_mz": "1184.3051",
                                "intensity": "1500.01",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "16",
                                "monoisotopic_mass": "4489.3972",
                                "monoisotopic_mz": "898.8867",
                                "intensity": "4514.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "17",
                                "monoisotopic_mass": "2971.6329",
                                "monoisotopic_mz": "743.9155",
                                "intensity": "1278.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "18",
                                "monoisotopic_mass": "4587.4632",
                                "monoisotopic_mz": "918.4999",
                                "intensity": "3146.93",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4587.4629",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "0.0003",
                                        "ppm": "0.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "19",
                                "monoisotopic_mass": "3194.6649",
                                "monoisotopic_mz": "1065.8956",
                                "intensity": "2106.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "20",
                                "monoisotopic_mass": "824.5495",
                                "monoisotopic_mz": "825.5568",
                                "intensity": "1390.11",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "824.5484",
                                        "ion_position": "42",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "Y00008",
                                        "ion_left_position": "42",
                                        "mass_error": "0.0011",
                                        "ppm": "1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "21",
                                "monoisotopic_mass": "920.5002",
                                "monoisotopic_mz": "921.5074",
                                "intensity": "1365.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "22",
                                "monoisotopic_mass": "1422.9284",
                                "monoisotopic_mz": "712.4715",
                                "intensity": "4529.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "23",
                                "monoisotopic_mass": "622.4170",
                                "monoisotopic_mz": "623.4243",
                                "intensity": "1586.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "24",
                                "monoisotopic_mass": "1485.6721",
                                "monoisotopic_mz": "743.8433",
                                "intensity": "6950.18",
                                "charge": "2"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "25",
                                "monoisotopic_mass": "585.2392",
                                "monoisotopic_mz": "586.2465",
                                "intensity": "1445.00",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "26",
                                "monoisotopic_mass": "3486.0383",
                                "monoisotopic_mz": "872.5168",
                                "intensity": "2368.97",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "27",
                                "monoisotopic_mass": "706.5840",
                                "monoisotopic_mz": "707.5912",
                                "intensity": "1050.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "28",
                                "monoisotopic_mass": "2228.0097",
                                "monoisotopic_mz": "743.6772",
                                "intensity": "830.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "29",
                                "monoisotopic_mass": "907.9817",
                                "monoisotopic_mz": "908.9890",
                                "intensity": "1068.89",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "30",
                                "monoisotopic_mass": "2454.3792",
                                "monoisotopic_mz": "819.1337",
                                "intensity": "2163.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "31",
                                "monoisotopic_mass": "4836.5065",
                                "monoisotopic_mz": "807.0917",
                                "intensity": "806.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "32",
                                "monoisotopic_mass": "937.6313",
                                "monoisotopic_mz": "469.8229",
                                "intensity": "1417.49",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "937.6325",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "Y00009",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0012",
                                        "ppm": "-1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "33",
                                "monoisotopic_mass": "3659.9613",
                                "monoisotopic_mz": "915.9976",
                                "intensity": "880.14",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "34",
                                "monoisotopic_mass": "4006.7831",
                                "monoisotopic_mz": "802.3639",
                                "intensity": "1044.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "35",
                                "monoisotopic_mass": "1054.5518",
                                "monoisotopic_mz": "1055.5591",
                                "intensity": "667.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "36",
                                "monoisotopic_mass": "1451.7606",
                                "monoisotopic_mz": "726.8876",
                                "intensity": "1235.58",
                                "charge": "2"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "37",
                                "monoisotopic_mass": "3338.7895",
                                "monoisotopic_mz": "835.7047",
                                "intensity": "1667.75",
                                "charge": "4"
                            },
                            {
                                "spec_id": "41",
                                "peak_id": "38",
                                "monoisotopic_mass": "855.4631",
                                "monoisotopic_mz": "856.4704",
                                "intensity": "1153.48",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "6",
                    "proteoform_id": "8",
                    "sequence_name": "sp|P60438|RL3_ECOLI",
                    "sequence_description": "50S ribosomal protein L3 OS=Escherichia coli (strain K12) OX=83333 GN=rplC PE=1 SV=1",
                    "proteoform_mass": "5199.8588",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "209",
                        "first_residue_position": "159",
                        "last_residue_position": "208",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "I"
                            },
                            {
                                "position": "2",
                                "acid": "G"
                            },
                            {
                                "position": "3",
                                "acid": "L"
                            },
                            {
                                "position": "4",
                                "acid": "V"
                            },
                            {
                                "position": "5",
                                "acid": "G"
                            },
                            {
                                "position": "6",
                                "acid": "K"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "V"
                            },
                            {
                                "position": "9",
                                "acid": "G"
                            },
                            {
                                "position": "10",
                                "acid": "M"
                            },
                            {
                                "position": "11",
                                "acid": "T"
                            },
                            {
                                "position": "12",
                                "acid": "R"
                            },
                            {
                                "position": "13",
                                "acid": "I"
                            },
                            {
                                "position": "14",
                                "acid": "F"
                            },
                            {
                                "position": "15",
                                "acid": "T"
                            },
                            {
                                "position": "16",
                                "acid": "E"
                            },
                            {
                                "position": "17",
                                "acid": "D"
                            },
                            {
                                "position": "18",
                                "acid": "G"
                            },
                            {
                                "position": "19",
                                "acid": "V"
                            },
                            {
                                "position": "20",
                                "acid": "S"
                            },
                            {
                                "position": "21",
                                "acid": "I"
                            },
                            {
                                "position": "22",
                                "acid": "P"
                            },
                            {
                                "position": "23",
                                "acid": "V"
                            },
                            {
                                "position": "24",
                                "acid": "T"
                            },
                            {
                                "position": "25",
                                "acid": "V"
                            },
                            {
                                "position": "26",
                                "acid": "I"
                            },
                            {
                                "position": "27",
                                "acid": "E"
                            },
                            {
                                "position": "28",
                                "acid": "V"
                            },
                            {
                                "position": "29",
                                "acid": "E"
                            },
                            {
                                "position": "30",
                                "acid": "A"
                            },
                            {
                                "position": "31",
                                "acid": "N"
                            },
                            {
                                "position": "32",
                                "acid": "R"
                            },
                            {
                                "position": "33",
                                "acid": "V"
                            },
                            {
                                "position": "34",
                                "acid": "T"
                            },
                            {
                                "position": "35",
                                "acid": "Q"
                            },
                            {
                                "position": "36",
                                "acid": "V"
                            },
                            {
                                "position": "37",
                                "acid": "K"
                            },
                            {
                                "position": "38",
                                "acid": "D"
                            },
                            {
                                "position": "39",
                                "acid": "L"
                            },
                            {
                                "position": "40",
                                "acid": "A"
                            },
                            {
                                "position": "41",
                                "acid": "N"
                            },
                            {
                                "position": "42",
                                "acid": "D"
                            },
                            {
                                "position": "43",
                                "acid": "G"
                            },
                            {
                                "position": "44",
                                "acid": "Y"
                            },
                            {
                                "position": "45",
                                "acid": "R"
                            },
                            {
                                "position": "46",
                                "acid": "A"
                            },
                            {
                                "position": "47",
                                "acid": "I"
                            },
                            {
                                "position": "48",
                                "acid": "Q"
                            },
                            {
                                "position": "49",
                                "acid": "V"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "T"
                            },
                            {
                                "position": "52",
                                "acid": "G"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "K"
                            },
                            {
                                "position": "55",
                                "acid": "K"
                            },
                            {
                                "position": "56",
                                "acid": "A"
                            },
                            {
                                "position": "57",
                                "acid": "N"
                            },
                            {
                                "position": "58",
                                "acid": "R"
                            },
                            {
                                "position": "59",
                                "acid": "V"
                            },
                            {
                                "position": "60",
                                "acid": "T"
                            },
                            {
                                "position": "61",
                                "acid": "K"
                            },
                            {
                                "position": "62",
                                "acid": "P"
                            },
                            {
                                "position": "63",
                                "acid": "E"
                            },
                            {
                                "position": "64",
                                "acid": "A"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "H"
                            },
                            {
                                "position": "67",
                                "acid": "F"
                            },
                            {
                                "position": "68",
                                "acid": "A"
                            },
                            {
                                "position": "69",
                                "acid": "K"
                            },
                            {
                                "position": "70",
                                "acid": "A"
                            },
                            {
                                "position": "71",
                                "acid": "G"
                            },
                            {
                                "position": "72",
                                "acid": "V"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "A"
                            },
                            {
                                "position": "75",
                                "acid": "G"
                            },
                            {
                                "position": "76",
                                "acid": "R"
                            },
                            {
                                "position": "77",
                                "acid": "G"
                            },
                            {
                                "position": "78",
                                "acid": "L"
                            },
                            {
                                "position": "79",
                                "acid": "W"
                            },
                            {
                                "position": "80",
                                "acid": "E"
                            },
                            {
                                "position": "81",
                                "acid": "F"
                            },
                            {
                                "position": "82",
                                "acid": "R"
                            },
                            {
                                "position": "83",
                                "acid": "L"
                            },
                            {
                                "position": "84",
                                "acid": "A"
                            },
                            {
                                "position": "85",
                                "acid": "E"
                            },
                            {
                                "position": "86",
                                "acid": "G"
                            },
                            {
                                "position": "87",
                                "acid": "E"
                            },
                            {
                                "position": "88",
                                "acid": "E"
                            },
                            {
                                "position": "89",
                                "acid": "F"
                            },
                            {
                                "position": "90",
                                "acid": "T"
                            },
                            {
                                "position": "91",
                                "acid": "V"
                            },
                            {
                                "position": "92",
                                "acid": "G"
                            },
                            {
                                "position": "93",
                                "acid": "Q"
                            },
                            {
                                "position": "94",
                                "acid": "S"
                            },
                            {
                                "position": "95",
                                "acid": "I"
                            },
                            {
                                "position": "96",
                                "acid": "S"
                            },
                            {
                                "position": "97",
                                "acid": "V"
                            },
                            {
                                "position": "98",
                                "acid": "E"
                            },
                            {
                                "position": "99",
                                "acid": "L"
                            },
                            {
                                "position": "100",
                                "acid": "F"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "D"
                            },
                            {
                                "position": "103",
                                "acid": "V"
                            },
                            {
                                "position": "104",
                                "acid": "K"
                            },
                            {
                                "position": "105",
                                "acid": "K"
                            },
                            {
                                "position": "106",
                                "acid": "V"
                            },
                            {
                                "position": "107",
                                "acid": "D"
                            },
                            {
                                "position": "108",
                                "acid": "V"
                            },
                            {
                                "position": "109",
                                "acid": "T"
                            },
                            {
                                "position": "110",
                                "acid": "G"
                            },
                            {
                                "position": "111",
                                "acid": "T"
                            },
                            {
                                "position": "112",
                                "acid": "S"
                            },
                            {
                                "position": "113",
                                "acid": "K"
                            },
                            {
                                "position": "114",
                                "acid": "G"
                            },
                            {
                                "position": "115",
                                "acid": "K"
                            },
                            {
                                "position": "116",
                                "acid": "G"
                            },
                            {
                                "position": "117",
                                "acid": "F"
                            },
                            {
                                "position": "118",
                                "acid": "A"
                            },
                            {
                                "position": "119",
                                "acid": "G"
                            },
                            {
                                "position": "120",
                                "acid": "T"
                            },
                            {
                                "position": "121",
                                "acid": "V"
                            },
                            {
                                "position": "122",
                                "acid": "K"
                            },
                            {
                                "position": "123",
                                "acid": "R"
                            },
                            {
                                "position": "124",
                                "acid": "W"
                            },
                            {
                                "position": "125",
                                "acid": "N"
                            },
                            {
                                "position": "126",
                                "acid": "F"
                            },
                            {
                                "position": "127",
                                "acid": "R"
                            },
                            {
                                "position": "128",
                                "acid": "T"
                            },
                            {
                                "position": "129",
                                "acid": "Q"
                            },
                            {
                                "position": "130",
                                "acid": "D"
                            },
                            {
                                "position": "131",
                                "acid": "A"
                            },
                            {
                                "position": "132",
                                "acid": "T"
                            },
                            {
                                "position": "133",
                                "acid": "H"
                            },
                            {
                                "position": "134",
                                "acid": "G"
                            },
                            {
                                "position": "135",
                                "acid": "N"
                            },
                            {
                                "position": "136",
                                "acid": "S"
                            },
                            {
                                "position": "137",
                                "acid": "L"
                            },
                            {
                                "position": "138",
                                "acid": "S"
                            },
                            {
                                "position": "139",
                                "acid": "H"
                            },
                            {
                                "position": "140",
                                "acid": "R"
                            },
                            {
                                "position": "141",
                                "acid": "V"
                            },
                            {
                                "position": "142",
                                "acid": "P"
                            },
                            {
                                "position": "143",
                                "acid": "G"
                            },
                            {
                                "position": "144",
                                "acid": "S"
                            },
                            {
                                "position": "145",
                                "acid": "I"
                            },
                            {
                                "position": "146",
                                "acid": "G"
                            },
                            {
                                "position": "147",
                                "acid": "Q"
                            },
                            {
                                "position": "148",
                                "acid": "N"
                            },
                            {
                                "position": "149",
                                "acid": "Q"
                            },
                            {
                                "position": "150",
                                "acid": "T"
                            },
                            {
                                "position": "151",
                                "acid": "P"
                            },
                            {
                                "position": "152",
                                "acid": "G"
                            },
                            {
                                "position": "153",
                                "acid": "K"
                            },
                            {
                                "position": "154",
                                "acid": "V"
                            },
                            {
                                "position": "155",
                                "acid": "F"
                            },
                            {
                                "position": "156",
                                "acid": "K"
                            },
                            {
                                "position": "157",
                                "acid": "G"
                            },
                            {
                                "position": "158",
                                "acid": "K"
                            },
                            {
                                "position": "159",
                                "acid": "K"
                            },
                            {
                                "position": "160",
                                "acid": "M"
                            },
                            {
                                "position": "161",
                                "acid": "A"
                            },
                            {
                                "position": "162",
                                "acid": "G"
                            },
                            {
                                "position": "163",
                                "acid": "Q"
                            },
                            {
                                "position": "164",
                                "acid": "M"
                            },
                            {
                                "position": "165",
                                "acid": "G"
                            },
                            {
                                "position": "166",
                                "acid": "N"
                            },
                            {
                                "position": "167",
                                "acid": "E"
                            },
                            {
                                "position": "168",
                                "acid": "R"
                            },
                            {
                                "position": "169",
                                "acid": "V"
                            },
                            {
                                "position": "170",
                                "acid": "T"
                            },
                            {
                                "position": "171",
                                "acid": "V"
                            },
                            {
                                "position": "172",
                                "acid": "Q"
                            },
                            {
                                "position": "173",
                                "acid": "S"
                            },
                            {
                                "position": "174",
                                "acid": "L"
                            },
                            {
                                "position": "175",
                                "acid": "D"
                            },
                            {
                                "position": "176",
                                "acid": "V"
                            },
                            {
                                "position": "177",
                                "acid": "V"
                            },
                            {
                                "position": "178",
                                "acid": "R"
                            },
                            {
                                "position": "179",
                                "acid": "V"
                            },
                            {
                                "position": "180",
                                "acid": "D"
                            },
                            {
                                "position": "181",
                                "acid": "A"
                            },
                            {
                                "position": "182",
                                "acid": "E"
                            },
                            {
                                "position": "183",
                                "acid": "R"
                            },
                            {
                                "position": "184",
                                "acid": "N"
                            },
                            {
                                "position": "185",
                                "acid": "L"
                            },
                            {
                                "position": "186",
                                "acid": "L"
                            },
                            {
                                "position": "187",
                                "acid": "L"
                            },
                            {
                                "position": "188",
                                "acid": "V"
                            },
                            {
                                "position": "189",
                                "acid": "K"
                            },
                            {
                                "position": "190",
                                "acid": "G"
                            },
                            {
                                "position": "191",
                                "acid": "A"
                            },
                            {
                                "position": "192",
                                "acid": "V"
                            },
                            {
                                "position": "193",
                                "acid": "P"
                            },
                            {
                                "position": "194",
                                "acid": "G"
                            },
                            {
                                "position": "195",
                                "acid": "A"
                            },
                            {
                                "position": "196",
                                "acid": "T"
                            },
                            {
                                "position": "197",
                                "acid": "G"
                            },
                            {
                                "position": "198",
                                "acid": "S"
                            },
                            {
                                "position": "199",
                                "acid": "D"
                            },
                            {
                                "position": "200",
                                "acid": "L"
                            },
                            {
                                "position": "201",
                                "acid": "I"
                            },
                            {
                                "position": "202",
                                "acid": "V"
                            },
                            {
                                "position": "203",
                                "acid": "K"
                            },
                            {
                                "position": "204",
                                "acid": "P"
                            },
                            {
                                "position": "205",
                                "acid": "A"
                            },
                            {
                                "position": "206",
                                "acid": "V"
                            },
                            {
                                "position": "207",
                                "acid": "K"
                            },
                            {
                                "position": "208",
                                "acid": "A"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "109",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "110",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "111",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "112",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "113",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "114",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "115",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "116",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "117",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "118",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "119",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "120",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "121",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "122",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "123",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "124",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "125",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "126",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "127",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "128",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "129",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "130",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "131",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "132",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "133",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "134",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "135",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "136",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "137",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "138",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "139",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "140",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "141",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "142",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "143",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "144",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "145",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "146",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "147",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "148",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "149",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "150",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "151",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "152",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "153",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "154",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "155",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "156",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "157",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "158",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "159",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "160",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "1",
                                        "ion_display_position": "49",
                                        "spec_id": "41",
                                        "peak_id": "9",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "161",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "162",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "163",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "164",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "165",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "166",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "167",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "168",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "169",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "170",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "171",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "172",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "173",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "174",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "175",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "176",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "177",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "178",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "179",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "180",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "181",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "182",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "183",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "184",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "185",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "186",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "187",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "188",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "189",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "30",
                                        "ion_display_position": "30",
                                        "spec_id": "41",
                                        "peak_id": "0",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "190",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "41",
                                        "peak_id": "7",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "191",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "192",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "193",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "41",
                                            "peak_id": "4",
                                            "peak_charge": "3"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "34",
                                            "ion_display_position": "16",
                                            "spec_id": "41",
                                            "peak_id": "2",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "34",
                                            "ion_display_position": "34",
                                            "spec_id": "41",
                                            "peak_id": "1",
                                            "peak_charge": "4"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "194",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "195",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "196",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "197",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "198",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "199",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "200",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "41",
                                        "ion_display_position": "9",
                                        "spec_id": "41",
                                        "peak_id": "32",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "201",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "42",
                                            "ion_display_position": "8",
                                            "spec_id": "41",
                                            "peak_id": "20",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "42",
                                            "ion_display_position": "42",
                                            "spec_id": "41",
                                            "peak_id": "8",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "202",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "203",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "41",
                                        "peak_id": "18",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "204",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "205",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "206",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "207",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "208",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "209",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ]
                    }
                }
            }
        ]
    }
}
