prsm_data =
{
    "compatible_proteoform": {
        "sequence_id": "5",
        "sequence_name": "sp|P0AET2|HDEB_ECOLI",
        "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
        "proteoform_id": "7",
        "prsm_number": "19",
        "prsm": [
            {
                "prsm_id": "176",
                "p_value": "3.01e-10",
                "e_value": "3.01e-10",
                "fdr": "0",
                "matched_fragment_number": "19",
                "matched_peak_number": "21",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "134",
                        "ms1_scans": "388",
                        "ids": "254",
                        "scans": "390",
                        "precursor_mono_mass": "9173.4138",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2755",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "254",
                                "peak_id": "0",
                                "monoisotopic_mass": "8831.2302",
                                "monoisotopic_mz": "1104.9111",
                                "intensity": "41552.59",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0128",
                                        "ppm": "-1.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "1",
                                "monoisotopic_mass": "8831.2377",
                                "monoisotopic_mz": "1262.6127",
                                "intensity": "40438.28",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0054",
                                        "ppm": "-0.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "2",
                                "monoisotopic_mass": "8814.2322",
                                "monoisotopic_mz": "1102.7863",
                                "intensity": "19783.11",
                                "charge": "8"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "3",
                                "monoisotopic_mass": "7579.7963",
                                "monoisotopic_mz": "1264.3067",
                                "intensity": "19313.15",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "4",
                                "monoisotopic_mass": "8927.3079",
                                "monoisotopic_mz": "1116.9208",
                                "intensity": "22929.16",
                                "charge": "8"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "5",
                                "monoisotopic_mass": "8944.3156",
                                "monoisotopic_mz": "1119.0467",
                                "intensity": "19703.10",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0116",
                                        "ppm": "-1.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "6",
                                "monoisotopic_mass": "3973.8142",
                                "monoisotopic_mz": "1325.6120",
                                "intensity": "13437.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "7",
                                "monoisotopic_mass": "8910.2767",
                                "monoisotopic_mz": "1114.7919",
                                "intensity": "16317.86",
                                "charge": "8"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "8",
                                "monoisotopic_mass": "8814.2206",
                                "monoisotopic_mz": "1260.1816",
                                "intensity": "12378.01",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "9",
                                "monoisotopic_mass": "8612.1810",
                                "monoisotopic_mz": "1231.3189",
                                "intensity": "11857.63",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "10",
                                "monoisotopic_mass": "8632.1967",
                                "monoisotopic_mz": "1234.1782",
                                "intensity": "9532.08",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "11",
                                "monoisotopic_mass": "4136.8758",
                                "monoisotopic_mz": "1379.9659",
                                "intensity": "11232.92",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0023",
                                        "ppm": "-0.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "12",
                                "monoisotopic_mass": "4448.6432",
                                "monoisotopic_mz": "1113.1681",
                                "intensity": "10499.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "13",
                                "monoisotopic_mass": "5368.4491",
                                "monoisotopic_mz": "1343.1196",
                                "intensity": "6620.89",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0041",
                                        "ppm": "-0.77"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "14",
                                "monoisotopic_mass": "3018.4826",
                                "monoisotopic_mz": "1007.1681",
                                "intensity": "8493.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "15",
                                "monoisotopic_mass": "4494.0310",
                                "monoisotopic_mz": "1124.5150",
                                "intensity": "7764.11",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0119",
                                        "ppm": "-2.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "16",
                                "monoisotopic_mass": "7433.7174",
                                "monoisotopic_mz": "1239.9602",
                                "intensity": "10360.20",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7433.7204",
                                        "ion_position": "15",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0030",
                                        "ppm": "-0.40"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "17",
                                "monoisotopic_mass": "3955.8017",
                                "monoisotopic_mz": "1319.6079",
                                "intensity": "6086.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "18",
                                "monoisotopic_mass": "3921.9744",
                                "monoisotopic_mz": "1308.3321",
                                "intensity": "5920.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "19",
                                "monoisotopic_mass": "4036.0363",
                                "monoisotopic_mz": "1346.3527",
                                "intensity": "8269.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "20",
                                "monoisotopic_mass": "7560.7632",
                                "monoisotopic_mz": "1261.1345",
                                "intensity": "6300.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "21",
                                "monoisotopic_mass": "3121.5944",
                                "monoisotopic_mz": "1561.8045",
                                "intensity": "7096.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "22",
                                "monoisotopic_mass": "4019.0130",
                                "monoisotopic_mz": "1340.6783",
                                "intensity": "4794.13",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "23",
                                "monoisotopic_mass": "4778.2105",
                                "monoisotopic_mz": "1195.5599",
                                "intensity": "9373.83",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "24",
                                "monoisotopic_mass": "3463.7959",
                                "monoisotopic_mz": "1155.6059",
                                "intensity": "4882.68",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "50",
                                        "mass_error": "0.0037",
                                        "ppm": "1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "25",
                                "monoisotopic_mass": "7818.8628",
                                "monoisotopic_mz": "1304.1511",
                                "intensity": "8425.82",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "26",
                                "monoisotopic_mass": "1364.5337",
                                "monoisotopic_mz": "683.2741",
                                "intensity": "3482.69",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.00"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "27",
                                "monoisotopic_mass": "3691.9226",
                                "monoisotopic_mz": "1231.6481",
                                "intensity": "5460.95",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "28",
                                "monoisotopic_mass": "720.3437",
                                "monoisotopic_mz": "721.3510",
                                "intensity": "4386.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "29",
                                "monoisotopic_mass": "7204.6067",
                                "monoisotopic_mz": "1201.7751",
                                "intensity": "4829.29",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "30",
                                "monoisotopic_mass": "1380.6288",
                                "monoisotopic_mz": "1381.6361",
                                "intensity": "3309.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "31",
                                "monoisotopic_mass": "4795.1973",
                                "monoisotopic_mz": "1199.8066",
                                "intensity": "3684.53",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4795.2067",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "ion_sort_name": "B00042",
                                        "ion_left_position": "42",
                                        "mass_error": "-0.0093",
                                        "ppm": "-1.95"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "32",
                                "monoisotopic_mass": "3707.8546",
                                "monoisotopic_mz": "1236.9588",
                                "intensity": "3366.04",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "33",
                                "monoisotopic_mass": "8515.1048",
                                "monoisotopic_mz": "1217.4508",
                                "intensity": "7032.07",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8515.1412",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "ion_sort_name": "B00073",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0364",
                                        "ppm": "-4.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "34",
                                "monoisotopic_mass": "8431.0912",
                                "monoisotopic_mz": "1205.4489",
                                "intensity": "6633.88",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "35",
                                "monoisotopic_mass": "947.4011",
                                "monoisotopic_mz": "948.4084",
                                "intensity": "3417.97",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "947.4018",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.78"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "36",
                                "monoisotopic_mass": "1102.9002",
                                "monoisotopic_mz": "1103.9075",
                                "intensity": "2462.66",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "37",
                                "monoisotopic_mass": "8545.1915",
                                "monoisotopic_mz": "1221.7489",
                                "intensity": "9403.92",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "38",
                                "monoisotopic_mass": "1739.7143",
                                "monoisotopic_mz": "1740.7216",
                                "intensity": "2157.09",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0012",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "39",
                                "monoisotopic_mass": "3855.4127",
                                "monoisotopic_mz": "1286.1448",
                                "intensity": "4914.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "40",
                                "monoisotopic_mass": "8444.0981",
                                "monoisotopic_mz": "1207.3070",
                                "intensity": "4754.87",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8444.1041",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "B00072",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0059",
                                        "ppm": "-0.70"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "41",
                                "monoisotopic_mass": "3008.5103",
                                "monoisotopic_mz": "1505.2624",
                                "intensity": "3102.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "42",
                                "monoisotopic_mass": "3349.7025",
                                "monoisotopic_mz": "1117.5748",
                                "intensity": "4490.31",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "43",
                                "monoisotopic_mass": "2569.9397",
                                "monoisotopic_mz": "1285.9771",
                                "intensity": "3508.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "44",
                                "monoisotopic_mass": "2612.2990",
                                "monoisotopic_mz": "1307.1568",
                                "intensity": "3698.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "45",
                                "monoisotopic_mass": "1207.3028",
                                "monoisotopic_mz": "1208.3101",
                                "intensity": "2508.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "46",
                                "monoisotopic_mass": "934.4754",
                                "monoisotopic_mz": "935.4827",
                                "intensity": "2887.92",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "47",
                                "monoisotopic_mass": "8073.8947",
                                "monoisotopic_mz": "1154.4208",
                                "intensity": "3451.40",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8073.9076",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0130",
                                        "ppm": "-1.60"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "48",
                                "monoisotopic_mass": "2435.1996",
                                "monoisotopic_mz": "1218.6071",
                                "intensity": "3764.73",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "49",
                                "monoisotopic_mass": "3732.3522",
                                "monoisotopic_mz": "1245.1247",
                                "intensity": "3352.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "50",
                                "monoisotopic_mass": "996.4981",
                                "monoisotopic_mz": "997.5054",
                                "intensity": "1519.93",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "51",
                                "monoisotopic_mass": "2130.0392",
                                "monoisotopic_mz": "1066.0269",
                                "intensity": "1876.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "52",
                                "monoisotopic_mass": "3000.4793",
                                "monoisotopic_mz": "1001.1670",
                                "intensity": "2533.24",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "53",
                                "monoisotopic_mass": "8794.1848",
                                "monoisotopic_mz": "1100.2804",
                                "intensity": "5913.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "54",
                                "monoisotopic_mass": "2068.0415",
                                "monoisotopic_mz": "1035.0280",
                                "intensity": "2573.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "55",
                                "monoisotopic_mass": "2495.1139",
                                "monoisotopic_mz": "1248.5642",
                                "intensity": "2796.92",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2495.1131",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "0.0008",
                                        "ppm": "0.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "56",
                                "monoisotopic_mass": "3234.6764",
                                "monoisotopic_mz": "1079.2327",
                                "intensity": "2236.92",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "57",
                                "monoisotopic_mass": "8474.1293",
                                "monoisotopic_mz": "1211.5972",
                                "intensity": "1001.40",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "58",
                                "monoisotopic_mass": "8596.1935",
                                "monoisotopic_mz": "1229.0349",
                                "intensity": "3458.38",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "59",
                                "monoisotopic_mass": "3103.5739",
                                "monoisotopic_mz": "1552.7942",
                                "intensity": "2289.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "60",
                                "monoisotopic_mass": "5055.9293",
                                "monoisotopic_mz": "1264.9896",
                                "intensity": "6452.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "61",
                                "monoisotopic_mass": "5153.3881",
                                "monoisotopic_mz": "1289.3543",
                                "intensity": "1157.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "62",
                                "monoisotopic_mass": "2019.0157",
                                "monoisotopic_mz": "1010.5151",
                                "intensity": "1824.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "63",
                                "monoisotopic_mass": "8716.1486",
                                "monoisotopic_mz": "1090.5259",
                                "intensity": "3661.60",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8716.2161",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "-0.0675",
                                        "ppm": "-7.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "64",
                                "monoisotopic_mass": "6117.7821",
                                "monoisotopic_mz": "1020.6376",
                                "intensity": "2281.51",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "65",
                                "monoisotopic_mass": "821.3916",
                                "monoisotopic_mz": "822.3989",
                                "intensity": "2000.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "66",
                                "monoisotopic_mass": "8716.2325",
                                "monoisotopic_mz": "1246.1834",
                                "intensity": "1062.72",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8716.2161",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "0.0164",
                                        "ppm": "1.88"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "67",
                                "monoisotopic_mass": "3248.6495",
                                "monoisotopic_mz": "1083.8904",
                                "intensity": "1887.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "68",
                                "monoisotopic_mass": "6250.0473",
                                "monoisotopic_mz": "1251.0167",
                                "intensity": "1518.21",
                                "charge": "5"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "69",
                                "monoisotopic_mass": "4328.5670",
                                "monoisotopic_mz": "1083.1490",
                                "intensity": "1013.70",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "70",
                                "monoisotopic_mass": "6969.2987",
                                "monoisotopic_mz": "1162.5571",
                                "intensity": "1113.82",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "6968.3520",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "ion_sort_name": "B00060",
                                        "ion_left_position": "60",
                                        "mass_error": "-0.0556",
                                        "ppm": "-7.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "71",
                                "monoisotopic_mass": "3546.7650",
                                "monoisotopic_mz": "1183.2623",
                                "intensity": "3293.42",
                                "charge": "3"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "72",
                                "monoisotopic_mass": "8856.8990",
                                "monoisotopic_mz": "1266.2786",
                                "intensity": "1338.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "73",
                                "monoisotopic_mass": "8729.2240",
                                "monoisotopic_mz": "1092.1603",
                                "intensity": "3156.71",
                                "charge": "8"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "74",
                                "monoisotopic_mass": "4986.2101",
                                "monoisotopic_mz": "1247.5598",
                                "intensity": "966.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "75",
                                "monoisotopic_mass": "2185.7994",
                                "monoisotopic_mz": "1093.9070",
                                "intensity": "1090.46",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "76",
                                "monoisotopic_mass": "1174.2880",
                                "monoisotopic_mz": "1175.2953",
                                "intensity": "910.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "77",
                                "monoisotopic_mass": "846.3531",
                                "monoisotopic_mz": "847.3604",
                                "intensity": "1984.98",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "846.3542",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0010",
                                        "ppm": "-1.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "78",
                                "monoisotopic_mass": "7186.5526",
                                "monoisotopic_mz": "1198.7660",
                                "intensity": "3872.32",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "79",
                                "monoisotopic_mass": "8760.3175",
                                "monoisotopic_mz": "1252.4812",
                                "intensity": "7672.75",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "80",
                                "monoisotopic_mass": "1018.4878",
                                "monoisotopic_mz": "1019.4951",
                                "intensity": "1201.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "81",
                                "monoisotopic_mass": "4387.5731",
                                "monoisotopic_mz": "1097.9006",
                                "intensity": "3283.71",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "82",
                                "monoisotopic_mass": "1346.5230",
                                "monoisotopic_mz": "674.2688",
                                "intensity": "1620.79",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "83",
                                "monoisotopic_mass": "1288.1388",
                                "monoisotopic_mz": "1289.1461",
                                "intensity": "1065.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "84",
                                "monoisotopic_mass": "7551.6070",
                                "monoisotopic_mz": "1079.8083",
                                "intensity": "1257.70",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "85",
                                "monoisotopic_mass": "1417.0568",
                                "monoisotopic_mz": "1418.0641",
                                "intensity": "3179.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "86",
                                "monoisotopic_mass": "6542.1479",
                                "monoisotopic_mz": "935.5998",
                                "intensity": "2429.02",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "87",
                                "monoisotopic_mass": "1140.5688",
                                "monoisotopic_mz": "1141.5760",
                                "intensity": "3515.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "88",
                                "monoisotopic_mass": "7733.7223",
                                "monoisotopic_mz": "1105.8247",
                                "intensity": "1411.86",
                                "charge": "7"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "89",
                                "monoisotopic_mass": "2308.1255",
                                "monoisotopic_mz": "1155.0700",
                                "intensity": "1332.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "90",
                                "monoisotopic_mass": "4560.3184",
                                "monoisotopic_mz": "1141.0869",
                                "intensity": "2114.72",
                                "charge": "4"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "91",
                                "monoisotopic_mass": "6705.4423",
                                "monoisotopic_mz": "1118.5810",
                                "intensity": "3483.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "254",
                                "peak_id": "92",
                                "monoisotopic_mass": "7747.8864",
                                "monoisotopic_mz": "1107.8482",
                                "intensity": "2707.94",
                                "charge": "7"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "254",
                                        "peak_id": "77",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "254",
                                        "peak_id": "35",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "254",
                                        "peak_id": "26",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "254",
                                            "peak_id": "38",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "64",
                                            "spec_id": "254",
                                            "peak_id": "16",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "254",
                                        "peak_id": "55",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "254",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "254",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "254",
                                        "peak_id": "15",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "42",
                                        "ion_display_position": "42",
                                        "spec_id": "254",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "254",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "spec_id": "254",
                                        "peak_id": "24",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "60",
                                        "ion_display_position": "60",
                                        "spec_id": "254",
                                        "peak_id": "70",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "spec_id": "254",
                                        "peak_id": "47",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "spec_id": "254",
                                        "peak_id": "40",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "254",
                                        "peak_id": "33",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "254",
                                            "peak_id": "63",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "75",
                                            "ion_display_position": "75",
                                            "spec_id": "254",
                                            "peak_id": "66",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "254",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "254",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "254",
                                        "peak_id": "5",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "116",
                "p_value": "2.45e-09",
                "e_value": "2.45e-09",
                "fdr": "0",
                "matched_fragment_number": "20",
                "matched_peak_number": "22",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "108",
                        "ms1_scans": "270",
                        "ids": "162",
                        "scans": "272",
                        "precursor_mono_mass": "9173.4067",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2747",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "162",
                                "peak_id": "0",
                                "monoisotopic_mass": "8831.2437",
                                "monoisotopic_mz": "1262.6135",
                                "intensity": "61991.74",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0007",
                                        "ppm": "0.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "1",
                                "monoisotopic_mass": "8830.2488",
                                "monoisotopic_mz": "1104.7884",
                                "intensity": "64643.02",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0081",
                                        "ppm": "0.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "2",
                                "monoisotopic_mass": "8813.2205",
                                "monoisotopic_mz": "1102.6598",
                                "intensity": "30002.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "3",
                                "monoisotopic_mass": "8927.2966",
                                "monoisotopic_mz": "1116.9194",
                                "intensity": "32236.87",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "4",
                                "monoisotopic_mass": "8814.2223",
                                "monoisotopic_mz": "1260.1819",
                                "intensity": "24478.49",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "5",
                                "monoisotopic_mass": "7578.7760",
                                "monoisotopic_mz": "1264.1366",
                                "intensity": "27114.77",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "6",
                                "monoisotopic_mass": "8909.2683",
                                "monoisotopic_mz": "1114.6658",
                                "intensity": "26229.40",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "7",
                                "monoisotopic_mass": "8944.3216",
                                "monoisotopic_mz": "1119.0475",
                                "intensity": "37627.07",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0055",
                                        "ppm": "-0.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "8",
                                "monoisotopic_mass": "7708.8304",
                                "monoisotopic_mz": "1285.8123",
                                "intensity": "15274.67",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "9",
                                "monoisotopic_mass": "4136.8707",
                                "monoisotopic_mz": "1379.9642",
                                "intensity": "12970.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0074",
                                        "ppm": "-1.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "10",
                                "monoisotopic_mass": "8630.1698",
                                "monoisotopic_mz": "1233.8887",
                                "intensity": "17409.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "11",
                                "monoisotopic_mass": "4036.0334",
                                "monoisotopic_mz": "1346.3517",
                                "intensity": "17203.16",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "12",
                                "monoisotopic_mass": "5367.4497",
                                "monoisotopic_mz": "1342.8697",
                                "intensity": "11646.02",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "13",
                                "monoisotopic_mass": "7562.7682",
                                "monoisotopic_mz": "1261.4686",
                                "intensity": "15720.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "14",
                                "monoisotopic_mass": "8741.2221",
                                "monoisotopic_mz": "1249.7533",
                                "intensity": "13424.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "15",
                                "monoisotopic_mass": "8759.2254",
                                "monoisotopic_mz": "1252.3252",
                                "intensity": "19149.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "16",
                                "monoisotopic_mass": "4777.1939",
                                "monoisotopic_mz": "1195.3058",
                                "intensity": "16331.10",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "17",
                                "monoisotopic_mass": "3973.8138",
                                "monoisotopic_mz": "1325.6119",
                                "intensity": "21460.23",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0009",
                                        "ppm": "-0.24"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "18",
                                "monoisotopic_mass": "3121.6022",
                                "monoisotopic_mz": "1561.8084",
                                "intensity": "10989.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "19",
                                "monoisotopic_mass": "7820.8843",
                                "monoisotopic_mz": "1304.4880",
                                "intensity": "15155.57",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "20",
                                "monoisotopic_mass": "7431.7185",
                                "monoisotopic_mz": "1239.6270",
                                "intensity": "13986.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "21",
                                "monoisotopic_mass": "8614.1660",
                                "monoisotopic_mz": "1231.6024",
                                "intensity": "11604.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "22",
                                "monoisotopic_mass": "7926.8376",
                                "monoisotopic_mz": "1133.4126",
                                "intensity": "12057.94",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7926.8392",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.20"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "23",
                                "monoisotopic_mass": "7662.7277",
                                "monoisotopic_mz": "1095.6827",
                                "intensity": "11684.89",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7661.8314",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "13",
                                            "mass_error": "-0.1060",
                                            "ppm": "-13.83"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7662.7282",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "B00066",
                                            "ion_left_position": "66",
                                            "mass_error": "-0.0005",
                                            "ppm": "-0.06"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "24",
                                "monoisotopic_mass": "3792.9459",
                                "monoisotopic_mz": "1265.3226",
                                "intensity": "11890.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "25",
                                "monoisotopic_mass": "3691.9079",
                                "monoisotopic_mz": "1231.6433",
                                "intensity": "8581.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "26",
                                "monoisotopic_mass": "7691.8169",
                                "monoisotopic_mz": "1282.9768",
                                "intensity": "13658.14",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "27",
                                "monoisotopic_mass": "5021.3243",
                                "monoisotopic_mz": "1256.3384",
                                "intensity": "6042.22",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5022.3337",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0070",
                                        "ppm": "-1.39"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "28",
                                "monoisotopic_mass": "5151.3735",
                                "monoisotopic_mz": "1031.2820",
                                "intensity": "8445.23",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0027",
                                        "ppm": "-0.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "29",
                                "monoisotopic_mass": "3463.7915",
                                "monoisotopic_mz": "1155.6044",
                                "intensity": "7394.08",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "30",
                                "monoisotopic_mass": "4495.0411",
                                "monoisotopic_mz": "1124.7676",
                                "intensity": "9481.16",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "31",
                                "monoisotopic_mass": "3121.6006",
                                "monoisotopic_mz": "1041.5408",
                                "intensity": "6051.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "32",
                                "monoisotopic_mass": "8881.2874",
                                "monoisotopic_mz": "1111.1682",
                                "intensity": "11635.61",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "33",
                                "monoisotopic_mass": "5583.5829",
                                "monoisotopic_mz": "1117.7239",
                                "intensity": "4783.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "34",
                                "monoisotopic_mass": "7447.6847",
                                "monoisotopic_mz": "1242.2881",
                                "intensity": "6747.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "35",
                                "monoisotopic_mass": "8796.1928",
                                "monoisotopic_mz": "1100.5314",
                                "intensity": "8283.44",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "36",
                                "monoisotopic_mass": "8443.1104",
                                "monoisotopic_mz": "1207.1659",
                                "intensity": "6859.02",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8444.1041",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "B00072",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0087",
                                        "ppm": "1.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "37",
                                "monoisotopic_mass": "3921.9748",
                                "monoisotopic_mz": "1308.3322",
                                "intensity": "5535.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "38",
                                "monoisotopic_mass": "3955.7977",
                                "monoisotopic_mz": "1319.6065",
                                "intensity": "6566.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "39",
                                "monoisotopic_mass": "3674.8821",
                                "monoisotopic_mz": "1225.9680",
                                "intensity": "7885.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "40",
                                "monoisotopic_mass": "8074.9123",
                                "monoisotopic_mz": "1154.5662",
                                "intensity": "7568.93",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8073.9076",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0024",
                                        "ppm": "0.30"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "41",
                                "monoisotopic_mass": "3874.7365",
                                "monoisotopic_mz": "1292.5861",
                                "intensity": "4147.38",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3874.7463",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0098",
                                        "ppm": "-2.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "42",
                                "monoisotopic_mass": "1364.5322",
                                "monoisotopic_mz": "683.2734",
                                "intensity": "5073.04",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "43",
                                "monoisotopic_mass": "2782.3806",
                                "monoisotopic_mz": "1392.1976",
                                "intensity": "5349.54",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "44",
                                "monoisotopic_mass": "1100.3992",
                                "monoisotopic_mz": "1101.4065",
                                "intensity": "3620.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "45",
                                "monoisotopic_mass": "4000.9819",
                                "monoisotopic_mz": "1334.6679",
                                "intensity": "5471.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "46",
                                "monoisotopic_mass": "3018.4835",
                                "monoisotopic_mz": "1007.1684",
                                "intensity": "7182.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "47",
                                "monoisotopic_mass": "3104.5800",
                                "monoisotopic_mz": "1553.2973",
                                "intensity": "4816.41",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "48",
                                "monoisotopic_mass": "4384.6024",
                                "monoisotopic_mz": "1097.1579",
                                "intensity": "4310.89",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "49",
                                "monoisotopic_mass": "2760.2624",
                                "monoisotopic_mz": "1381.1385",
                                "intensity": "5247.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "50",
                                "monoisotopic_mass": "7301.6292",
                                "monoisotopic_mz": "1217.9455",
                                "intensity": "7674.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "51",
                                "monoisotopic_mass": "8676.1825",
                                "monoisotopic_mz": "1240.4619",
                                "intensity": "2039.34",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "52",
                                "monoisotopic_mass": "3660.8298",
                                "monoisotopic_mz": "1221.2839",
                                "intensity": "4613.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "53",
                                "monoisotopic_mass": "7593.7353",
                                "monoisotopic_mz": "1266.6298",
                                "intensity": "6451.30",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "54",
                                "monoisotopic_mass": "8724.2050",
                                "monoisotopic_mz": "1247.3223",
                                "intensity": "3181.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "55",
                                "monoisotopic_mass": "8626.1762",
                                "monoisotopic_mz": "1079.2793",
                                "intensity": "2091.74",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "56",
                                "monoisotopic_mass": "3575.8656",
                                "monoisotopic_mz": "1192.9625",
                                "intensity": "5112.56",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "57",
                                "monoisotopic_mass": "2440.8831",
                                "monoisotopic_mz": "1221.4488",
                                "intensity": "3291.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "58",
                                "monoisotopic_mass": "720.3435",
                                "monoisotopic_mz": "721.3508",
                                "intensity": "5384.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "59",
                                "monoisotopic_mass": "1246.4544",
                                "monoisotopic_mz": "1247.4617",
                                "intensity": "5988.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "60",
                                "monoisotopic_mass": "1966.8359",
                                "monoisotopic_mz": "1967.8432",
                                "intensity": "3080.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1966.8401",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0042",
                                        "ppm": "-2.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "61",
                                "monoisotopic_mass": "1214.4476",
                                "monoisotopic_mz": "1215.4548",
                                "intensity": "3080.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "62",
                                "monoisotopic_mass": "1306.6492",
                                "monoisotopic_mz": "1307.6565",
                                "intensity": "4187.71",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "63",
                                "monoisotopic_mass": "5152.3710",
                                "monoisotopic_mz": "1289.1000",
                                "intensity": "4073.06",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0076",
                                        "ppm": "-1.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "64",
                                "monoisotopic_mass": "1119.5408",
                                "monoisotopic_mz": "1120.5481",
                                "intensity": "2551.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "65",
                                "monoisotopic_mass": "947.4014",
                                "monoisotopic_mz": "948.4087",
                                "intensity": "5126.07",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "947.4018",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.46"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "66",
                                "monoisotopic_mass": "1288.8442",
                                "monoisotopic_mz": "1289.8514",
                                "intensity": "2700.07",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "67",
                                "monoisotopic_mass": "3008.5231",
                                "monoisotopic_mz": "1505.2688",
                                "intensity": "5254.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "68",
                                "monoisotopic_mass": "821.3910",
                                "monoisotopic_mz": "822.3983",
                                "intensity": "3011.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "69",
                                "monoisotopic_mass": "7414.7374",
                                "monoisotopic_mz": "1236.7968",
                                "intensity": "6377.37",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "70",
                                "monoisotopic_mass": "1364.5326",
                                "monoisotopic_mz": "1365.5399",
                                "intensity": "2110.67",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "71",
                                "monoisotopic_mass": "4761.1894",
                                "monoisotopic_mz": "1191.3046",
                                "intensity": "2870.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "72",
                                "monoisotopic_mass": "8059.8956",
                                "monoisotopic_mz": "1152.4209",
                                "intensity": "1533.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "73",
                                "monoisotopic_mass": "6019.0117",
                                "monoisotopic_mz": "1004.1759",
                                "intensity": "1522.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "74",
                                "monoisotopic_mass": "4036.0349",
                                "monoisotopic_mz": "1010.0160",
                                "intensity": "1024.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "75",
                                "monoisotopic_mass": "2660.3126",
                                "monoisotopic_mz": "1331.1636",
                                "intensity": "1198.97",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "76",
                                "monoisotopic_mass": "2602.6136",
                                "monoisotopic_mz": "1302.3141",
                                "intensity": "2991.05",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "77",
                                "monoisotopic_mass": "967.8324",
                                "monoisotopic_mz": "968.8397",
                                "intensity": "1378.67",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "78",
                                "monoisotopic_mass": "557.2804",
                                "monoisotopic_mz": "558.2877",
                                "intensity": "3422.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "79",
                                "monoisotopic_mass": "846.3534",
                                "monoisotopic_mz": "847.3607",
                                "intensity": "2735.88",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "846.3542",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "80",
                                "monoisotopic_mass": "2990.4883",
                                "monoisotopic_mz": "997.8367",
                                "intensity": "3190.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "81",
                                "monoisotopic_mass": "6978.2236",
                                "monoisotopic_mz": "1164.0445",
                                "intensity": "1135.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "82",
                                "monoisotopic_mass": "5332.3700",
                                "monoisotopic_mz": "1067.4813",
                                "intensity": "1135.78",
                                "charge": "5"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "83",
                                "monoisotopic_mass": "6700.4222",
                                "monoisotopic_mz": "1117.7443",
                                "intensity": "5974.56",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "84",
                                "monoisotopic_mass": "8498.1072",
                                "monoisotopic_mz": "1215.0226",
                                "intensity": "4571.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "85",
                                "monoisotopic_mass": "1003.1735",
                                "monoisotopic_mz": "1004.1807",
                                "intensity": "1214.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "86",
                                "monoisotopic_mass": "6639.6749",
                                "monoisotopic_mz": "1107.6198",
                                "intensity": "3378.83",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "87",
                                "monoisotopic_mass": "5449.6790",
                                "monoisotopic_mz": "1090.9431",
                                "intensity": "5561.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "88",
                                "monoisotopic_mass": "987.4938",
                                "monoisotopic_mz": "988.5011",
                                "intensity": "1377.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "89",
                                "monoisotopic_mass": "8674.1156",
                                "monoisotopic_mz": "1085.2717",
                                "intensity": "997.26",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "90",
                                "monoisotopic_mass": "5949.9931",
                                "monoisotopic_mz": "1191.0059",
                                "intensity": "1399.80",
                                "charge": "5"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "91",
                                "monoisotopic_mass": "8316.0295",
                                "monoisotopic_mz": "1189.0115",
                                "intensity": "4239.55",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8316.0455",
                                        "ion_position": "71",
                                        "ion_display_position": "71",
                                        "ion_sort_name": "B00071",
                                        "ion_left_position": "71",
                                        "mass_error": "-0.0160",
                                        "ppm": "-1.93"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "92",
                                "monoisotopic_mass": "7189.5614",
                                "monoisotopic_mz": "1199.2675",
                                "intensity": "2912.81",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "93",
                                "monoisotopic_mass": "1217.4791",
                                "monoisotopic_mz": "609.7468",
                                "intensity": "893.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "94",
                                "monoisotopic_mass": "4212.0279",
                                "monoisotopic_mz": "1054.0143",
                                "intensity": "2332.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "95",
                                "monoisotopic_mass": "1624.6853",
                                "monoisotopic_mz": "1625.6926",
                                "intensity": "2081.53",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1624.6861",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "ion_sort_name": "B00014",
                                        "ion_left_position": "14",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "96",
                                "monoisotopic_mass": "1076.0955",
                                "monoisotopic_mz": "1077.1028",
                                "intensity": "825.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "97",
                                "monoisotopic_mass": "1171.2824",
                                "monoisotopic_mz": "1172.2897",
                                "intensity": "1607.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "98",
                                "monoisotopic_mass": "1049.5132",
                                "monoisotopic_mz": "1050.5205",
                                "intensity": "1852.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "99",
                                "monoisotopic_mass": "1996.0093",
                                "monoisotopic_mz": "999.0119",
                                "intensity": "843.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "100",
                                "monoisotopic_mass": "2639.2032",
                                "monoisotopic_mz": "1320.6089",
                                "intensity": "2582.42",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "101",
                                "monoisotopic_mass": "2171.2796",
                                "monoisotopic_mz": "1086.6471",
                                "intensity": "1812.67",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "102",
                                "monoisotopic_mass": "7372.7140",
                                "monoisotopic_mz": "1229.7929",
                                "intensity": "2388.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "103",
                                "monoisotopic_mass": "8022.0454",
                                "monoisotopic_mz": "1003.7630",
                                "intensity": "2245.83",
                                "charge": "8"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "104",
                                "monoisotopic_mass": "1453.7218",
                                "monoisotopic_mz": "1454.7291",
                                "intensity": "913.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "105",
                                "monoisotopic_mass": "4148.1170",
                                "monoisotopic_mz": "1383.7129",
                                "intensity": "2247.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "106",
                                "monoisotopic_mass": "7138.5612",
                                "monoisotopic_mz": "1020.8017",
                                "intensity": "3941.80",
                                "charge": "7"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "107",
                                "monoisotopic_mass": "6115.0080",
                                "monoisotopic_mz": "1020.1753",
                                "intensity": "1053.02",
                                "charge": "6"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "108",
                                "monoisotopic_mass": "2402.8742",
                                "monoisotopic_mz": "1202.4444",
                                "intensity": "1988.22",
                                "charge": "2"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "109",
                                "monoisotopic_mass": "5479.7365",
                                "monoisotopic_mz": "1096.9546",
                                "intensity": "2043.04",
                                "charge": "5"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "110",
                                "monoisotopic_mass": "1416.7226",
                                "monoisotopic_mz": "1417.7299",
                                "intensity": "2994.75",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "111",
                                "monoisotopic_mass": "934.4772",
                                "monoisotopic_mz": "935.4845",
                                "intensity": "2434.02",
                                "charge": "1"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "112",
                                "monoisotopic_mass": "4861.6124",
                                "monoisotopic_mz": "1216.4104",
                                "intensity": "2539.15",
                                "charge": "4"
                            },
                            {
                                "spec_id": "162",
                                "peak_id": "113",
                                "monoisotopic_mass": "2060.7373",
                                "monoisotopic_mz": "1031.3760",
                                "intensity": "2765.64",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "162",
                                        "peak_id": "79",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "162",
                                        "peak_id": "65",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "162",
                                            "peak_id": "42",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "162",
                                            "peak_id": "70",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "66",
                                        "spec_id": "162",
                                        "peak_id": "23",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "14",
                                        "ion_display_position": "14",
                                        "spec_id": "162",
                                        "peak_id": "95",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "162",
                                        "peak_id": "60",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "162",
                                        "peak_id": "41",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "162",
                                        "peak_id": "17",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "162",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "162",
                                        "peak_id": "27",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "162",
                                            "peak_id": "63",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "162",
                                            "peak_id": "28",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "162",
                                        "peak_id": "12",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "spec_id": "162",
                                        "peak_id": "29",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "66",
                                        "ion_display_position": "66",
                                        "spec_id": "162",
                                        "peak_id": "23",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "162",
                                        "peak_id": "22",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "spec_id": "162",
                                        "peak_id": "40",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "71",
                                        "ion_display_position": "71",
                                        "spec_id": "162",
                                        "peak_id": "91",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "spec_id": "162",
                                        "peak_id": "36",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "162",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "162",
                                            "peak_id": "1",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "162",
                                        "peak_id": "7",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "136",
                "p_value": "1.36e-08",
                "e_value": "1.36e-08",
                "fdr": "0",
                "matched_fragment_number": "17",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "117",
                        "ms1_scans": "310",
                        "ids": "193",
                        "scans": "312",
                        "precursor_mono_mass": "9172.4050",
                        "precursor_charge": "8",
                        "precursor_mz": "1147.5579",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "193",
                                "peak_id": "0",
                                "monoisotopic_mass": "8944.3195",
                                "monoisotopic_mz": "1278.7672",
                                "intensity": "458348.14",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0076",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "1",
                                "monoisotopic_mass": "8927.3108",
                                "monoisotopic_mz": "1276.3374",
                                "intensity": "100972.58",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "2",
                                "monoisotopic_mass": "8831.2420",
                                "monoisotopic_mz": "1262.6133",
                                "intensity": "41970.90",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "3",
                                "monoisotopic_mass": "8958.3084",
                                "monoisotopic_mz": "1280.7656",
                                "intensity": "27101.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "4",
                                "monoisotopic_mass": "3121.6002",
                                "monoisotopic_mz": "1561.8074",
                                "intensity": "14680.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "5",
                                "monoisotopic_mass": "8909.2930",
                                "monoisotopic_mz": "1273.7634",
                                "intensity": "26186.36",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "6",
                                "monoisotopic_mass": "4494.0270",
                                "monoisotopic_mz": "1124.5140",
                                "intensity": "16003.97",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0159",
                                        "ppm": "-3.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "7",
                                "monoisotopic_mass": "8516.1404",
                                "monoisotopic_mz": "1217.5988",
                                "intensity": "14653.30",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8515.1412",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "ion_sort_name": "B00073",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "8",
                                "monoisotopic_mass": "4136.8787",
                                "monoisotopic_mz": "1379.9669",
                                "intensity": "9834.61",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0007",
                                        "ppm": "0.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "9",
                                "monoisotopic_mass": "3973.8076",
                                "monoisotopic_mz": "1325.6098",
                                "intensity": "15607.64",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0072",
                                        "ppm": "-1.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "10",
                                "monoisotopic_mass": "8928.2962",
                                "monoisotopic_mz": "1117.0443",
                                "intensity": "15259.21",
                                "charge": "8"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "11",
                                "monoisotopic_mass": "3956.8015",
                                "monoisotopic_mz": "1319.9411",
                                "intensity": "8567.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "12",
                                "monoisotopic_mass": "4250.1639",
                                "monoisotopic_mz": "1417.7286",
                                "intensity": "15158.01",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "13",
                                "monoisotopic_mass": "5367.4409",
                                "monoisotopic_mz": "1342.8675",
                                "intensity": "8834.83",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0100",
                                        "ppm": "-1.86"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "14",
                                "monoisotopic_mass": "8883.2857",
                                "monoisotopic_mz": "1270.0481",
                                "intensity": "12762.57",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "15",
                                "monoisotopic_mass": "8813.2370",
                                "monoisotopic_mz": "1260.0411",
                                "intensity": "15173.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "16",
                                "monoisotopic_mass": "4679.3441",
                                "monoisotopic_mz": "1560.7887",
                                "intensity": "9354.37",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4679.3905",
                                        "ion_position": "39",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0464",
                                        "ppm": "-9.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "17",
                                "monoisotopic_mass": "4234.1451",
                                "monoisotopic_mz": "1412.3890",
                                "intensity": "4159.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "18",
                                "monoisotopic_mass": "3790.9277",
                                "monoisotopic_mz": "1264.6498",
                                "intensity": "5194.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "19",
                                "monoisotopic_mass": "4036.0272",
                                "monoisotopic_mz": "1346.3497",
                                "intensity": "6402.71",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "20",
                                "monoisotopic_mass": "9041.3626",
                                "monoisotopic_mz": "1131.1776",
                                "intensity": "7505.20",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "9041.3799",
                                        "ion_position": "78",
                                        "ion_display_position": "78",
                                        "ion_sort_name": "B00078",
                                        "ion_left_position": "78",
                                        "mass_error": "-0.0173",
                                        "ppm": "-1.91"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "21",
                                "monoisotopic_mass": "3772.6974",
                                "monoisotopic_mz": "1258.5731",
                                "intensity": "6560.65",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "22",
                                "monoisotopic_mass": "4587.7165",
                                "monoisotopic_mz": "1147.9364",
                                "intensity": "8841.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "23",
                                "monoisotopic_mass": "5566.7787",
                                "monoisotopic_mz": "1392.7019",
                                "intensity": "9263.42",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "24",
                                "monoisotopic_mass": "7824.7839",
                                "monoisotopic_mz": "1118.8335",
                                "intensity": "8906.21",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7825.7915",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "B00067",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0053",
                                        "ppm": "-0.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "25",
                                "monoisotopic_mass": "1380.6305",
                                "monoisotopic_mz": "1381.6378",
                                "intensity": "3098.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "26",
                                "monoisotopic_mass": "4150.1183",
                                "monoisotopic_mz": "1384.3800",
                                "intensity": "5681.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "27",
                                "monoisotopic_mass": "2228.8218",
                                "monoisotopic_mz": "1115.4182",
                                "intensity": "5692.85",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "28",
                                "monoisotopic_mass": "2495.1078",
                                "monoisotopic_mz": "1248.5612",
                                "intensity": "2766.30",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2495.1131",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "ion_sort_name": "B00022",
                                        "ion_left_position": "22",
                                        "mass_error": "-0.0053",
                                        "ppm": "-2.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "29",
                                "monoisotopic_mass": "5809.8856",
                                "monoisotopic_mz": "1453.4787",
                                "intensity": "3574.24",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "30",
                                "monoisotopic_mass": "1739.7129",
                                "monoisotopic_mz": "1740.7202",
                                "intensity": "2892.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "31",
                                "monoisotopic_mass": "1104.4080",
                                "monoisotopic_mz": "1105.4153",
                                "intensity": "2672.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "32",
                                "monoisotopic_mass": "3855.7306",
                                "monoisotopic_mz": "1286.2508",
                                "intensity": "1299.38",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "33",
                                "monoisotopic_mass": "7384.8231",
                                "monoisotopic_mz": "1231.8111",
                                "intensity": "2370.58",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "34",
                                "monoisotopic_mass": "5170.6196",
                                "monoisotopic_mz": "1293.6622",
                                "intensity": "1344.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "35",
                                "monoisotopic_mass": "4173.0238",
                                "monoisotopic_mz": "1392.0152",
                                "intensity": "3306.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "36",
                                "monoisotopic_mass": "3874.7384",
                                "monoisotopic_mz": "1292.5867",
                                "intensity": "4724.97",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3874.7463",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0079",
                                        "ppm": "-2.05"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "37",
                                "monoisotopic_mass": "7921.9094",
                                "monoisotopic_mz": "1321.3255",
                                "intensity": "1371.63",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "38",
                                "monoisotopic_mass": "6550.2658",
                                "monoisotopic_mz": "1311.0604",
                                "intensity": "1145.86",
                                "charge": "5"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "39",
                                "monoisotopic_mass": "2714.8576",
                                "monoisotopic_mz": "1358.4361",
                                "intensity": "1020.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "40",
                                "monoisotopic_mass": "3104.5737",
                                "monoisotopic_mz": "1553.2941",
                                "intensity": "1400.43",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "41",
                                "monoisotopic_mass": "3603.8126",
                                "monoisotopic_mz": "1202.2782",
                                "intensity": "1071.70",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "42",
                                "monoisotopic_mass": "8847.4601",
                                "monoisotopic_mz": "1106.9398",
                                "intensity": "751.34",
                                "charge": "8"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "43",
                                "monoisotopic_mass": "5150.3840",
                                "monoisotopic_mz": "1031.0841",
                                "intensity": "992.86",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0101",
                                        "ppm": "1.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "44",
                                "monoisotopic_mass": "1230.0240",
                                "monoisotopic_mz": "1231.0312",
                                "intensity": "2709.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "45",
                                "monoisotopic_mass": "3577.8867",
                                "monoisotopic_mz": "1193.6362",
                                "intensity": "3549.55",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "46",
                                "monoisotopic_mass": "934.4753",
                                "monoisotopic_mz": "935.4825",
                                "intensity": "1894.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "47",
                                "monoisotopic_mass": "1147.5560",
                                "monoisotopic_mz": "1148.5632",
                                "intensity": "6289.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "48",
                                "monoisotopic_mass": "1207.3027",
                                "monoisotopic_mz": "1208.3099",
                                "intensity": "864.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "49",
                                "monoisotopic_mass": "2529.9781",
                                "monoisotopic_mz": "1265.9963",
                                "intensity": "1426.28",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "50",
                                "monoisotopic_mass": "8812.2082",
                                "monoisotopic_mz": "1102.5333",
                                "intensity": "1342.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "51",
                                "monoisotopic_mass": "3744.5262",
                                "monoisotopic_mz": "1249.1827",
                                "intensity": "1083.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "52",
                                "monoisotopic_mass": "3997.9438",
                                "monoisotopic_mz": "1333.6552",
                                "intensity": "992.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "53",
                                "monoisotopic_mass": "8604.1941",
                                "monoisotopic_mz": "1230.1779",
                                "intensity": "2675.96",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "54",
                                "monoisotopic_mass": "2949.3483",
                                "monoisotopic_mz": "1475.6814",
                                "intensity": "2354.68",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "55",
                                "monoisotopic_mass": "6150.8231",
                                "monoisotopic_mz": "1231.1719",
                                "intensity": "996.57",
                                "charge": "5"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "56",
                                "monoisotopic_mass": "8856.3086",
                                "monoisotopic_mz": "1266.1942",
                                "intensity": "6540.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "57",
                                "monoisotopic_mass": "6280.1566",
                                "monoisotopic_mz": "1257.0386",
                                "intensity": "1487.07",
                                "charge": "5"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "58",
                                "monoisotopic_mass": "1125.2242",
                                "monoisotopic_mz": "1126.2314",
                                "intensity": "876.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "59",
                                "monoisotopic_mass": "2254.8463",
                                "monoisotopic_mz": "1128.4304",
                                "intensity": "799.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "60",
                                "monoisotopic_mass": "1017.4888",
                                "monoisotopic_mz": "1018.4960",
                                "intensity": "769.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "61",
                                "monoisotopic_mass": "7927.8527",
                                "monoisotopic_mz": "1133.5577",
                                "intensity": "2494.66",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7926.8392",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "ion_sort_name": "B00068",
                                        "ion_left_position": "68",
                                        "mass_error": "0.0112",
                                        "ppm": "1.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "62",
                                "monoisotopic_mass": "6635.8403",
                                "monoisotopic_mz": "1106.9807",
                                "intensity": "717.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "63",
                                "monoisotopic_mass": "9013.3890",
                                "monoisotopic_mz": "1127.6809",
                                "intensity": "1187.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "64",
                                "monoisotopic_mass": "1350.8345",
                                "monoisotopic_mz": "1351.8418",
                                "intensity": "753.55",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "65",
                                "monoisotopic_mass": "964.1092",
                                "monoisotopic_mz": "965.1165",
                                "intensity": "774.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "66",
                                "monoisotopic_mass": "8403.9644",
                                "monoisotopic_mz": "1201.5736",
                                "intensity": "1596.45",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "67",
                                "monoisotopic_mass": "1364.5329",
                                "monoisotopic_mz": "683.2737",
                                "intensity": "951.41",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "68",
                                "monoisotopic_mass": "3463.7783",
                                "monoisotopic_mz": "1155.6001",
                                "intensity": "1278.38",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0139",
                                        "ppm": "-4.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "69",
                                "monoisotopic_mass": "3921.9829",
                                "monoisotopic_mz": "1308.3349",
                                "intensity": "1088.00",
                                "charge": "3"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "70",
                                "monoisotopic_mass": "1421.9929",
                                "monoisotopic_mz": "1423.0001",
                                "intensity": "3218.60",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "71",
                                "monoisotopic_mass": "1291.3217",
                                "monoisotopic_mz": "1292.3290",
                                "intensity": "945.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "72",
                                "monoisotopic_mass": "1965.8328",
                                "monoisotopic_mz": "1966.8401",
                                "intensity": "1744.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "73",
                                "monoisotopic_mass": "5969.0665",
                                "monoisotopic_mz": "1194.8206",
                                "intensity": "1313.88",
                                "charge": "5"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "74",
                                "monoisotopic_mass": "5152.3696",
                                "monoisotopic_mz": "1289.0997",
                                "intensity": "4381.50",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0090",
                                        "ppm": "-1.76"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "75",
                                "monoisotopic_mass": "2478.5361",
                                "monoisotopic_mz": "1240.2753",
                                "intensity": "2157.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "76",
                                "monoisotopic_mass": "7761.5719",
                                "monoisotopic_mz": "1109.8033",
                                "intensity": "1149.25",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "77",
                                "monoisotopic_mass": "1450.7432",
                                "monoisotopic_mz": "1451.7505",
                                "intensity": "723.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "78",
                                "monoisotopic_mass": "5334.9408",
                                "monoisotopic_mz": "1334.7425",
                                "intensity": "833.12",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "79",
                                "monoisotopic_mass": "1090.1464",
                                "monoisotopic_mz": "1091.1537",
                                "intensity": "1543.31",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "80",
                                "monoisotopic_mass": "1307.3261",
                                "monoisotopic_mz": "1308.3334",
                                "intensity": "537.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "81",
                                "monoisotopic_mass": "4433.5744",
                                "monoisotopic_mz": "1109.4009",
                                "intensity": "832.58",
                                "charge": "4"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "82",
                                "monoisotopic_mass": "2441.7980",
                                "monoisotopic_mz": "1221.9063",
                                "intensity": "2356.20",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "83",
                                "monoisotopic_mass": "7805.8425",
                                "monoisotopic_mz": "1301.9810",
                                "intensity": "1201.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "84",
                                "monoisotopic_mass": "6565.0033",
                                "monoisotopic_mz": "1095.1745",
                                "intensity": "2303.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "85",
                                "monoisotopic_mass": "2204.0499",
                                "monoisotopic_mz": "1103.0322",
                                "intensity": "3531.93",
                                "charge": "2"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "86",
                                "monoisotopic_mass": "1364.5336",
                                "monoisotopic_mz": "1365.5409",
                                "intensity": "1117.36",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.03"
                                    }
                                }
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "87",
                                "monoisotopic_mass": "6902.0624",
                                "monoisotopic_mz": "1151.3510",
                                "intensity": "1258.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "88",
                                "monoisotopic_mass": "8077.9117",
                                "monoisotopic_mz": "1154.9947",
                                "intensity": "2859.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "89",
                                "monoisotopic_mass": "1472.4145",
                                "monoisotopic_mz": "1473.4218",
                                "intensity": "730.53",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "90",
                                "monoisotopic_mass": "947.0946",
                                "monoisotopic_mz": "948.1019",
                                "intensity": "935.10",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "91",
                                "monoisotopic_mass": "1041.5343",
                                "monoisotopic_mz": "1042.5415",
                                "intensity": "1305.09",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "92",
                                "monoisotopic_mass": "1171.9949",
                                "monoisotopic_mz": "1173.0022",
                                "intensity": "946.27",
                                "charge": "1"
                            },
                            {
                                "spec_id": "193",
                                "peak_id": "93",
                                "monoisotopic_mass": "1497.1543",
                                "monoisotopic_mz": "1498.1616",
                                "intensity": "1708.62",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "193",
                                            "peak_id": "67",
                                            "peak_charge": "2"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "12",
                                            "ion_display_position": "12",
                                            "spec_id": "193",
                                            "peak_id": "86",
                                            "peak_charge": "1"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "193",
                                        "peak_id": "30",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "22",
                                        "ion_display_position": "22",
                                        "spec_id": "193",
                                        "peak_id": "28",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "193",
                                        "peak_id": "36",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "193",
                                        "peak_id": "9",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "193",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "193",
                                            "peak_id": "6",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "40",
                                            "spec_id": "193",
                                            "peak_id": "16",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "193",
                                            "peak_id": "74",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "193",
                                            "peak_id": "43",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "193",
                                        "peak_id": "13",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "spec_id": "193",
                                        "peak_id": "68",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "spec_id": "193",
                                        "peak_id": "24",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "68",
                                        "ion_display_position": "68",
                                        "spec_id": "193",
                                        "peak_id": "61",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "193",
                                        "peak_id": "7",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "spec_id": "193",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "193",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "78",
                                        "ion_display_position": "78",
                                        "spec_id": "193",
                                        "peak_id": "20",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "60",
                "p_value": "1.37e-08",
                "e_value": "1.37e-08",
                "fdr": "0",
                "matched_fragment_number": "24",
                "matched_peak_number": "22",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "81",
                        "ms1_scans": "161",
                        "ids": "81",
                        "scans": "164",
                        "precursor_mono_mass": "9173.4012",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2741",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "81",
                                "peak_id": "0",
                                "monoisotopic_mass": "8831.2369",
                                "monoisotopic_mz": "1262.6125",
                                "intensity": "56932.52",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "8831.2409",
                                        "ion_position": "80",
                                        "ion_display_position": "80",
                                        "ion_sort_name": "B00080",
                                        "ion_left_position": "80",
                                        "mass_error": "-0.0040",
                                        "ppm": "-0.45"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "1",
                                "monoisotopic_mass": "8831.2488",
                                "monoisotopic_mz": "1104.9134",
                                "intensity": "56558.02",
                                "charge": "8",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-342.1925579173",
                                            "theoretical_mass": "8831.2409",
                                            "ion_position": "80",
                                            "ion_display_position": "80",
                                            "ion_sort_name": "B00080",
                                            "ion_left_position": "80",
                                            "mass_error": "0.0079",
                                            "ppm": "0.90"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "-342.1925579173",
                                            "theoretical_mass": "8831.2409",
                                            "ion_position": "4",
                                            "ion_display_position": "79",
                                            "ion_sort_name": "Y00079",
                                            "ion_left_position": "4",
                                            "mass_error": "0.0079",
                                            "ppm": "0.90"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "2",
                                "monoisotopic_mass": "8944.3015",
                                "monoisotopic_mz": "1119.0450",
                                "intensity": "29627.24",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "8944.3249",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "ion_sort_name": "B00081",
                                        "ion_left_position": "81",
                                        "mass_error": "-0.0234",
                                        "ppm": "-2.62"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "3",
                                "monoisotopic_mass": "8813.2263",
                                "monoisotopic_mz": "1102.6606",
                                "intensity": "21299.52",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "4",
                                "monoisotopic_mass": "7707.8287",
                                "monoisotopic_mz": "1285.6454",
                                "intensity": "20176.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "5",
                                "monoisotopic_mass": "8759.2408",
                                "monoisotopic_mz": "1252.3274",
                                "intensity": "17672.36",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "8760.2038",
                                        "ion_position": "5",
                                        "ion_display_position": "78",
                                        "ion_sort_name": "Y00078",
                                        "ion_left_position": "5",
                                        "mass_error": "0.0394",
                                        "ppm": "4.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "6",
                                "monoisotopic_mass": "7579.7966",
                                "monoisotopic_mz": "1264.3067",
                                "intensity": "26175.24",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "7",
                                "monoisotopic_mass": "8912.3015",
                                "monoisotopic_mz": "1115.0450",
                                "intensity": "16711.38",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "8",
                                "monoisotopic_mass": "3973.8171",
                                "monoisotopic_mz": "1325.6130",
                                "intensity": "18142.91",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "3973.8125",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "ion_sort_name": "B00038",
                                        "ion_left_position": "38",
                                        "mass_error": "0.0046",
                                        "ppm": "1.16"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "9",
                                "monoisotopic_mass": "8814.2257",
                                "monoisotopic_mz": "1260.1824",
                                "intensity": "15828.59",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "10",
                                "monoisotopic_mass": "8927.3240",
                                "monoisotopic_mz": "1116.9228",
                                "intensity": "26402.13",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "11",
                                "monoisotopic_mass": "8629.1974",
                                "monoisotopic_mz": "1233.7498",
                                "intensity": "12307.66",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "12",
                                "monoisotopic_mass": "4036.0381",
                                "monoisotopic_mz": "1346.3533",
                                "intensity": "11543.99",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "13",
                                "monoisotopic_mass": "4136.8743",
                                "monoisotopic_mz": "1379.9654",
                                "intensity": "12406.69",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "4136.8758",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.36"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "14",
                                "monoisotopic_mass": "4448.6358",
                                "monoisotopic_mz": "1113.1662",
                                "intensity": "8869.47",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "15",
                                "monoisotopic_mass": "3121.6002",
                                "monoisotopic_mz": "1561.8074",
                                "intensity": "12264.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "16",
                                "monoisotopic_mass": "3463.7886",
                                "monoisotopic_mz": "1155.6035",
                                "intensity": "6293.90",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "54",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "54",
                                        "mass_error": "-0.0037",
                                        "ppm": "-1.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "17",
                                "monoisotopic_mass": "5368.4486",
                                "monoisotopic_mz": "1343.1194",
                                "intensity": "9305.30",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "5367.4486",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0024",
                                        "ppm": "-0.44"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "18",
                                "monoisotopic_mass": "4777.1939",
                                "monoisotopic_mz": "1195.3058",
                                "intensity": "17734.51",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "19",
                                "monoisotopic_mass": "4494.0410",
                                "monoisotopic_mz": "1124.5175",
                                "intensity": "8566.12",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "4494.0407",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0004",
                                        "ppm": "0.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "20",
                                "monoisotopic_mass": "8613.1757",
                                "monoisotopic_mz": "1231.4609",
                                "intensity": "14516.10",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "21",
                                "monoisotopic_mass": "7662.7371",
                                "monoisotopic_mz": "1095.6840",
                                "intensity": "11383.04",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7661.8314",
                                            "ion_position": "17",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "17",
                                            "mass_error": "-0.0966",
                                            "ppm": "-12.61"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-342.1925579173",
                                            "theoretical_mass": "7662.7259",
                                            "ion_position": "70",
                                            "ion_display_position": "70",
                                            "ion_sort_name": "B00070",
                                            "ion_left_position": "70",
                                            "mass_error": "0.0112",
                                            "ppm": "1.46"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "22",
                                "monoisotopic_mass": "7562.7606",
                                "monoisotopic_mz": "1261.4674",
                                "intensity": "9023.68",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "23",
                                "monoisotopic_mass": "7819.8658",
                                "monoisotopic_mz": "1304.3182",
                                "intensity": "9467.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "24",
                                "monoisotopic_mass": "7319.6560",
                                "monoisotopic_mz": "1220.9499",
                                "intensity": "12711.67",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7320.6363",
                                        "ion_position": "20",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "20",
                                        "mass_error": "0.0220",
                                        "ppm": "3.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "25",
                                "monoisotopic_mass": "4389.0962",
                                "monoisotopic_mz": "1098.2813",
                                "intensity": "5627.64",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "26",
                                "monoisotopic_mass": "8741.1931",
                                "monoisotopic_mz": "1249.7491",
                                "intensity": "12507.95",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "27",
                                "monoisotopic_mass": "7433.7137",
                                "monoisotopic_mz": "1239.9596",
                                "intensity": "14360.56",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7433.7204",
                                        "ion_position": "19",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "19",
                                        "mass_error": "-0.0066",
                                        "ppm": "-0.89"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "28",
                                "monoisotopic_mass": "8582.1448",
                                "monoisotopic_mz": "1227.0280",
                                "intensity": "7660.72",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "29",
                                "monoisotopic_mass": "3018.4881",
                                "monoisotopic_mz": "1007.1700",
                                "intensity": "9905.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "30",
                                "monoisotopic_mass": "4018.0294",
                                "monoisotopic_mz": "1340.3504",
                                "intensity": "6092.37",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "31",
                                "monoisotopic_mass": "7204.6067",
                                "monoisotopic_mz": "1201.7751",
                                "intensity": "10851.12",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "32",
                                "monoisotopic_mass": "8542.1631",
                                "monoisotopic_mz": "1221.3163",
                                "intensity": "7524.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "33",
                                "monoisotopic_mass": "3955.8039",
                                "monoisotopic_mz": "1319.6086",
                                "intensity": "8305.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "34",
                                "monoisotopic_mass": "8883.3156",
                                "monoisotopic_mz": "1111.4217",
                                "intensity": "10213.06",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "35",
                                "monoisotopic_mass": "1110.7869",
                                "monoisotopic_mz": "1111.7942",
                                "intensity": "4150.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "36",
                                "monoisotopic_mass": "3121.6043",
                                "monoisotopic_mz": "1041.5420",
                                "intensity": "6239.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "37",
                                "monoisotopic_mass": "3691.9134",
                                "monoisotopic_mz": "1231.6451",
                                "intensity": "6739.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "38",
                                "monoisotopic_mass": "8798.2355",
                                "monoisotopic_mz": "1100.7867",
                                "intensity": "6230.25",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "39",
                                "monoisotopic_mass": "3008.5192",
                                "monoisotopic_mz": "1505.2669",
                                "intensity": "6390.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "40",
                                "monoisotopic_mass": "947.4022",
                                "monoisotopic_mz": "948.4095",
                                "intensity": "4727.89",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "947.3996",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "ion_sort_name": "B00013",
                                        "ion_left_position": "13",
                                        "mass_error": "0.0026",
                                        "ppm": "2.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "41",
                                "monoisotopic_mass": "8516.1421",
                                "monoisotopic_mz": "1217.5990",
                                "intensity": "8713.67",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "B",
                                            "match_shift": "-342.1925579173",
                                            "theoretical_mass": "8515.1390",
                                            "ion_position": "77",
                                            "ion_display_position": "77",
                                            "ion_sort_name": "B00077",
                                            "ion_left_position": "77",
                                            "mass_error": "0.0008",
                                            "ppm": "0.10"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "-342.1925579173",
                                            "theoretical_mass": "8517.1183",
                                            "ion_position": "7",
                                            "ion_display_position": "76",
                                            "ion_sort_name": "Y00076",
                                            "ion_left_position": "7",
                                            "mass_error": "0.0262",
                                            "ppm": "3.08"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "42",
                                "monoisotopic_mass": "1305.6410",
                                "monoisotopic_mz": "1306.6483",
                                "intensity": "4665.11",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "43",
                                "monoisotopic_mass": "3776.9275",
                                "monoisotopic_mz": "1259.9831",
                                "intensity": "6121.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "44",
                                "monoisotopic_mass": "4410.6134",
                                "monoisotopic_mz": "1103.6606",
                                "intensity": "6073.98",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "45",
                                "monoisotopic_mass": "4795.2003",
                                "monoisotopic_mz": "1199.8073",
                                "intensity": "6487.22",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "4795.2044",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "ion_sort_name": "B00046",
                                        "ion_left_position": "46",
                                        "mass_error": "-0.0042",
                                        "ppm": "-0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "46",
                                "monoisotopic_mass": "1364.5326",
                                "monoisotopic_mz": "683.2736",
                                "intensity": "3875.06",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "1364.5314",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "ion_sort_name": "B00016",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0011",
                                        "ppm": "0.84"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "47",
                                "monoisotopic_mass": "5582.5743",
                                "monoisotopic_mz": "1117.5221",
                                "intensity": "4713.77",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "5581.5804",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "ion_sort_name": "B00053",
                                        "ion_left_position": "53",
                                        "mass_error": "-0.0085",
                                        "ppm": "-1.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "48",
                                "monoisotopic_mass": "1290.2424",
                                "monoisotopic_mz": "1291.2496",
                                "intensity": "2294.85",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "49",
                                "monoisotopic_mass": "720.3439",
                                "monoisotopic_mz": "721.3512",
                                "intensity": "5372.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "50",
                                "monoisotopic_mass": "3674.8758",
                                "monoisotopic_mz": "1225.9659",
                                "intensity": "3492.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "51",
                                "monoisotopic_mass": "2783.3751",
                                "monoisotopic_mz": "1392.6948",
                                "intensity": "3998.39",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "52",
                                "monoisotopic_mass": "1228.7403",
                                "monoisotopic_mz": "1229.7476",
                                "intensity": "2172.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "53",
                                "monoisotopic_mass": "3922.9625",
                                "monoisotopic_mz": "1308.6614",
                                "intensity": "5081.86",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "54",
                                "monoisotopic_mass": "4251.1695",
                                "monoisotopic_mz": "1418.0638",
                                "intensity": "3294.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "55",
                                "monoisotopic_mass": "8075.8951",
                                "monoisotopic_mz": "1154.7066",
                                "intensity": "9676.97",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "56",
                                "monoisotopic_mass": "5016.5380",
                                "monoisotopic_mz": "1255.1418",
                                "intensity": "3753.94",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "57",
                                "monoisotopic_mass": "4358.6118",
                                "monoisotopic_mz": "1090.6602",
                                "intensity": "5149.13",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "58",
                                "monoisotopic_mass": "7535.7430",
                                "monoisotopic_mz": "1256.9644",
                                "intensity": "3089.86",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "59",
                                "monoisotopic_mass": "2225.5753",
                                "monoisotopic_mz": "1113.7949",
                                "intensity": "2686.36",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "60",
                                "monoisotopic_mass": "1030.4743",
                                "monoisotopic_mz": "1031.4816",
                                "intensity": "2105.43",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "61",
                                "monoisotopic_mass": "3643.6304",
                                "monoisotopic_mz": "1215.5507",
                                "intensity": "4690.17",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "62",
                                "monoisotopic_mass": "2555.2573",
                                "monoisotopic_mz": "1278.6359",
                                "intensity": "3379.51",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "63",
                                "monoisotopic_mass": "1739.7134",
                                "monoisotopic_mz": "1740.7207",
                                "intensity": "3006.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "1739.7108",
                                        "ion_position": "19",
                                        "ion_display_position": "19",
                                        "ion_sort_name": "B00019",
                                        "ion_left_position": "19",
                                        "mass_error": "0.0026",
                                        "ppm": "1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "64",
                                "monoisotopic_mass": "8646.1668",
                                "monoisotopic_mz": "1236.1740",
                                "intensity": "4869.70",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "8646.1608",
                                        "ion_position": "6",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "Y00077",
                                        "ion_left_position": "6",
                                        "mass_error": "0.0059",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "65",
                                "monoisotopic_mass": "557.2804",
                                "monoisotopic_mz": "558.2877",
                                "intensity": "1878.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "66",
                                "monoisotopic_mass": "5564.7571",
                                "monoisotopic_mz": "1113.9587",
                                "intensity": "3604.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "67",
                                "monoisotopic_mass": "5547.7510",
                                "monoisotopic_mz": "1110.5575",
                                "intensity": "3124.35",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "68",
                                "monoisotopic_mass": "1167.5417",
                                "monoisotopic_mz": "1168.5489",
                                "intensity": "1756.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "69",
                                "monoisotopic_mass": "3285.4434",
                                "monoisotopic_mz": "1096.1551",
                                "intensity": "1127.91",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "70",
                                "monoisotopic_mass": "3901.9518",
                                "monoisotopic_mz": "1301.6579",
                                "intensity": "3915.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "71",
                                "monoisotopic_mass": "3051.4584",
                                "monoisotopic_mz": "1018.1601",
                                "intensity": "2593.40",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "72",
                                "monoisotopic_mass": "5452.6860",
                                "monoisotopic_mz": "1091.5445",
                                "intensity": "1186.49",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "73",
                                "monoisotopic_mass": "1264.0312",
                                "monoisotopic_mz": "1265.0385",
                                "intensity": "1142.50",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "74",
                                "monoisotopic_mass": "4760.1753",
                                "monoisotopic_mz": "1191.0511",
                                "intensity": "3970.02",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "75",
                                "monoisotopic_mass": "2143.7782",
                                "monoisotopic_mz": "1072.8964",
                                "intensity": "1131.26",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "76",
                                "monoisotopic_mass": "8076.0859",
                                "monoisotopic_mz": "1347.0216",
                                "intensity": "3062.45",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "77",
                                "monoisotopic_mass": "7804.7366",
                                "monoisotopic_mz": "1115.9696",
                                "intensity": "5836.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "78",
                                "monoisotopic_mass": "1212.4432",
                                "monoisotopic_mz": "1213.4504",
                                "intensity": "2630.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "79",
                                "monoisotopic_mass": "7236.6030",
                                "monoisotopic_mz": "1207.1078",
                                "intensity": "1001.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "80",
                                "monoisotopic_mass": "7928.8020",
                                "monoisotopic_mz": "1133.6933",
                                "intensity": "5920.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "81",
                                "monoisotopic_mass": "821.3923",
                                "monoisotopic_mz": "822.3996",
                                "intensity": "3173.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "82",
                                "monoisotopic_mass": "771.4126",
                                "monoisotopic_mz": "772.4199",
                                "intensity": "1305.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "83",
                                "monoisotopic_mass": "7755.8485",
                                "monoisotopic_mz": "1108.9856",
                                "intensity": "1011.15",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "84",
                                "monoisotopic_mass": "1193.2934",
                                "monoisotopic_mz": "1194.3007",
                                "intensity": "3080.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "85",
                                "monoisotopic_mass": "2977.1276",
                                "monoisotopic_mz": "993.3832",
                                "intensity": "1776.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "86",
                                "monoisotopic_mass": "1078.8997",
                                "monoisotopic_mz": "1079.9070",
                                "intensity": "1722.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "87",
                                "monoisotopic_mass": "1140.4154",
                                "monoisotopic_mz": "1141.4227",
                                "intensity": "827.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "88",
                                "monoisotopic_mass": "4249.1924",
                                "monoisotopic_mz": "1063.3054",
                                "intensity": "1126.35",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "89",
                                "monoisotopic_mass": "2006.6629",
                                "monoisotopic_mz": "1004.3387",
                                "intensity": "2033.81",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "90",
                                "monoisotopic_mass": "803.3810",
                                "monoisotopic_mz": "804.3883",
                                "intensity": "1739.80",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "91",
                                "monoisotopic_mass": "1624.6858",
                                "monoisotopic_mz": "1625.6931",
                                "intensity": "2329.42",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "1624.6839",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "ion_sort_name": "B00018",
                                        "ion_left_position": "18",
                                        "mass_error": "0.0019",
                                        "ppm": "1.19"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "92",
                                "monoisotopic_mass": "846.3541",
                                "monoisotopic_mz": "847.3613",
                                "intensity": "2888.16",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "846.3519",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "0.0021",
                                        "ppm": "2.51"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "93",
                                "monoisotopic_mass": "5056.5333",
                                "monoisotopic_mz": "1265.1406",
                                "intensity": "2453.68",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "94",
                                "monoisotopic_mass": "8698.1820",
                                "monoisotopic_mz": "1088.2800",
                                "intensity": "4474.48",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "95",
                                "monoisotopic_mass": "3833.3829",
                                "monoisotopic_mz": "1278.8016",
                                "intensity": "967.19",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "96",
                                "monoisotopic_mass": "934.4759",
                                "monoisotopic_mz": "935.4832",
                                "intensity": "2823.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "97",
                                "monoisotopic_mass": "2488.2064",
                                "monoisotopic_mz": "1245.1105",
                                "intensity": "3296.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "98",
                                "monoisotopic_mass": "3758.8824",
                                "monoisotopic_mz": "1253.9681",
                                "intensity": "1299.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "99",
                                "monoisotopic_mass": "870.4192",
                                "monoisotopic_mz": "871.4265",
                                "intensity": "2742.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "100",
                                "monoisotopic_mass": "6121.1783",
                                "monoisotopic_mz": "1021.2037",
                                "intensity": "2008.68",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "101",
                                "monoisotopic_mass": "6461.2515",
                                "monoisotopic_mz": "1077.8825",
                                "intensity": "1580.80",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "102",
                                "monoisotopic_mass": "3341.4551",
                                "monoisotopic_mz": "1114.8256",
                                "intensity": "4613.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "103",
                                "monoisotopic_mass": "1000.4635",
                                "monoisotopic_mz": "1001.4708",
                                "intensity": "823.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "104",
                                "monoisotopic_mass": "7435.2414",
                                "monoisotopic_mz": "1063.1846",
                                "intensity": "1336.14",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "105",
                                "monoisotopic_mass": "1411.7135",
                                "monoisotopic_mz": "1412.7208",
                                "intensity": "1535.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "106",
                                "monoisotopic_mass": "2346.1981",
                                "monoisotopic_mz": "1174.1063",
                                "intensity": "1188.33",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "107",
                                "monoisotopic_mass": "6141.3517",
                                "monoisotopic_mz": "1229.2776",
                                "intensity": "1471.97",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "108",
                                "monoisotopic_mass": "3887.9227",
                                "monoisotopic_mz": "1296.9815",
                                "intensity": "2387.82",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "109",
                                "monoisotopic_mass": "5488.8481",
                                "monoisotopic_mz": "1098.7769",
                                "intensity": "1069.09",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "110",
                                "monoisotopic_mass": "5086.0952",
                                "monoisotopic_mz": "1018.2263",
                                "intensity": "1460.61",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "111",
                                "monoisotopic_mass": "2990.4915",
                                "monoisotopic_mz": "997.8378",
                                "intensity": "2683.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "112",
                                "monoisotopic_mass": "2762.2694",
                                "monoisotopic_mz": "1382.1420",
                                "intensity": "6020.72",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "-342.1925579173",
                                        "theoretical_mass": "2762.2691",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "B00029",
                                        "ion_left_position": "29",
                                        "mass_error": "0.0003",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "113",
                                "monoisotopic_mass": "8038.1333",
                                "monoisotopic_mz": "1005.7739",
                                "intensity": "3483.47",
                                "charge": "8"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "114",
                                "monoisotopic_mass": "2161.7827",
                                "monoisotopic_mz": "1081.8986",
                                "intensity": "1123.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "115",
                                "monoisotopic_mass": "2121.0233",
                                "monoisotopic_mz": "1061.5189",
                                "intensity": "2366.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "116",
                                "monoisotopic_mass": "7302.5235",
                                "monoisotopic_mz": "1218.0945",
                                "intensity": "4427.73",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "117",
                                "monoisotopic_mass": "6047.1781",
                                "monoisotopic_mz": "1008.8703",
                                "intensity": "2650.70",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "118",
                                "monoisotopic_mass": "6077.9435",
                                "monoisotopic_mz": "1013.9979",
                                "intensity": "1483.39",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "119",
                                "monoisotopic_mass": "5806.6261",
                                "monoisotopic_mz": "1162.3325",
                                "intensity": "3450.42",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "120",
                                "monoisotopic_mass": "4856.7131",
                                "monoisotopic_mz": "1215.1855",
                                "intensity": "2634.85",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "121",
                                "monoisotopic_mass": "7479.8177",
                                "monoisotopic_mz": "1069.5527",
                                "intensity": "1505.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "122",
                                "monoisotopic_mass": "1328.5114",
                                "monoisotopic_mz": "665.2630",
                                "intensity": "802.37",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "123",
                                "monoisotopic_mass": "3369.9302",
                                "monoisotopic_mz": "1124.3173",
                                "intensity": "2304.07",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "124",
                                "monoisotopic_mass": "6542.4704",
                                "monoisotopic_mz": "1091.4190",
                                "intensity": "2862.55",
                                "charge": "6"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "125",
                                "monoisotopic_mass": "4937.0288",
                                "monoisotopic_mz": "988.4130",
                                "intensity": "1769.29",
                                "charge": "5"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "126",
                                "monoisotopic_mass": "7286.7842",
                                "monoisotopic_mz": "1041.9765",
                                "intensity": "1257.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "127",
                                "monoisotopic_mass": "4068.5504",
                                "monoisotopic_mz": "1018.1449",
                                "intensity": "2173.43",
                                "charge": "4"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "128",
                                "monoisotopic_mass": "2668.6343",
                                "monoisotopic_mz": "890.5520",
                                "intensity": "3078.87",
                                "charge": "3"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "129",
                                "monoisotopic_mass": "908.4638",
                                "monoisotopic_mz": "909.4710",
                                "intensity": "1548.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "130",
                                "monoisotopic_mass": "2656.3210",
                                "monoisotopic_mz": "1329.1678",
                                "intensity": "2207.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "131",
                                "monoisotopic_mass": "2302.9819",
                                "monoisotopic_mz": "1152.4982",
                                "intensity": "2225.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "81",
                                "peak_id": "132",
                                "monoisotopic_mass": "3190.6790",
                                "monoisotopic_mz": "1064.5669",
                                "intensity": "2444.51",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4312",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "1",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "25",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "4",
                                        "ion_display_position": "79",
                                        "spec_id": "81",
                                        "peak_id": "1",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "5",
                                        "ion_display_position": "78",
                                        "spec_id": "81",
                                        "peak_id": "5",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "6",
                                        "ion_display_position": "77",
                                        "spec_id": "81",
                                        "peak_id": "64",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "7",
                                        "ion_display_position": "76",
                                        "spec_id": "81",
                                        "peak_id": "41",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "81",
                                        "peak_id": "92",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "13",
                                        "ion_display_position": "13",
                                        "spec_id": "81",
                                        "peak_id": "40",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "16",
                                        "ion_display_position": "16",
                                        "spec_id": "81",
                                        "peak_id": "46",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "66",
                                        "spec_id": "81",
                                        "peak_id": "21",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "18",
                                        "ion_display_position": "18",
                                        "spec_id": "81",
                                        "peak_id": "91",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "19",
                                            "ion_display_position": "19",
                                            "spec_id": "81",
                                            "peak_id": "63",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "19",
                                            "ion_display_position": "64",
                                            "spec_id": "81",
                                            "peak_id": "27",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "20",
                                        "ion_display_position": "63",
                                        "spec_id": "81",
                                        "peak_id": "24",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "29",
                                        "ion_display_position": "29",
                                        "spec_id": "81",
                                        "peak_id": "112",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "38",
                                        "ion_display_position": "38",
                                        "spec_id": "81",
                                        "peak_id": "8",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "81",
                                        "peak_id": "13",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "81",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "46",
                                        "ion_display_position": "46",
                                        "spec_id": "81",
                                        "peak_id": "45",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "81",
                                        "peak_id": "17",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "53",
                                        "ion_display_position": "53",
                                        "spec_id": "81",
                                        "peak_id": "47",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "54",
                                        "ion_display_position": "29",
                                        "spec_id": "81",
                                        "peak_id": "16",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "70",
                                        "ion_display_position": "70",
                                        "spec_id": "81",
                                        "peak_id": "21",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "81",
                                        "peak_id": "41",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "80",
                                            "ion_display_position": "80",
                                            "spec_id": "81",
                                            "peak_id": "0",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "80",
                                            "ion_display_position": "80",
                                            "spec_id": "81",
                                            "peak_id": "1",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "81",
                                        "ion_display_position": "81",
                                        "spec_id": "81",
                                        "peak_id": "2",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        },
                        "mass_shift": {
                            "id": "0",
                            "left_position": "32",
                            "right_position": "37",
                            "anno": "-342.1926",
                            "shift_type": "unexpected"
                        }
                    }
                }
            },
            {
                "prsm_id": "108",
                "p_value": "1.56e-08",
                "e_value": "1.56e-08",
                "fdr": "0",
                "matched_fragment_number": "16",
                "matched_peak_number": "15",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "103",
                        "ms1_scans": "254",
                        "ids": "151",
                        "scans": "256",
                        "precursor_mono_mass": "9174.4099",
                        "precursor_charge": "8",
                        "precursor_mz": "1147.8085",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "151",
                                "peak_id": "0",
                                "monoisotopic_mass": "8944.3153",
                                "monoisotopic_mz": "1278.7666",
                                "intensity": "458603.23",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0119",
                                        "ppm": "-1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "1",
                                "monoisotopic_mass": "8927.3049",
                                "monoisotopic_mz": "1276.3365",
                                "intensity": "104144.24",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "2",
                                "monoisotopic_mass": "8831.2523",
                                "monoisotopic_mz": "1262.6147",
                                "intensity": "31307.83",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0092",
                                        "ppm": "1.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "3",
                                "monoisotopic_mass": "8959.3125",
                                "monoisotopic_mz": "1280.9091",
                                "intensity": "30679.99",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "4",
                                "monoisotopic_mass": "8909.2725",
                                "monoisotopic_mz": "1273.7605",
                                "intensity": "20546.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "5",
                                "monoisotopic_mass": "3973.8090",
                                "monoisotopic_mz": "1325.6103",
                                "intensity": "12903.89",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0057",
                                        "ppm": "-1.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "6",
                                "monoisotopic_mass": "4136.8736",
                                "monoisotopic_mz": "1379.9651",
                                "intensity": "9878.71",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0045",
                                        "ppm": "-1.08"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "7",
                                "monoisotopic_mass": "3121.5990",
                                "monoisotopic_mz": "1561.8068",
                                "intensity": "12362.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "8",
                                "monoisotopic_mass": "8812.2321",
                                "monoisotopic_mz": "1259.8976",
                                "intensity": "13055.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "9",
                                "monoisotopic_mass": "4250.1628",
                                "monoisotopic_mz": "1417.7282",
                                "intensity": "11258.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "10",
                                "monoisotopic_mass": "4494.0412",
                                "monoisotopic_mz": "1124.5176",
                                "intensity": "14918.88",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0017",
                                        "ppm": "-0.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "11",
                                "monoisotopic_mass": "5565.7660",
                                "monoisotopic_mz": "1392.4488",
                                "intensity": "8470.30",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "12",
                                "monoisotopic_mass": "9154.4104",
                                "monoisotopic_mz": "1145.3086",
                                "intensity": "12946.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "13",
                                "monoisotopic_mass": "4678.3531",
                                "monoisotopic_mz": "1560.4583",
                                "intensity": "9338.97",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "14",
                                "monoisotopic_mass": "8718.2175",
                                "monoisotopic_mz": "1246.4669",
                                "intensity": "8637.32",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "15",
                                "monoisotopic_mass": "3773.6931",
                                "monoisotopic_mz": "1258.9050",
                                "intensity": "4117.44",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3773.6986",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "ion_sort_name": "B00032",
                                        "ion_left_position": "32",
                                        "mass_error": "-0.0056",
                                        "ppm": "-1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "16",
                                "monoisotopic_mass": "8928.2995",
                                "monoisotopic_mz": "1117.0447",
                                "intensity": "9824.75",
                                "charge": "8"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "17",
                                "monoisotopic_mass": "4036.0386",
                                "monoisotopic_mz": "1346.3535",
                                "intensity": "8080.58",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "18",
                                "monoisotopic_mass": "8515.1185",
                                "monoisotopic_mz": "1217.4528",
                                "intensity": "11512.12",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8515.1412",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "ion_sort_name": "B00073",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0227",
                                        "ppm": "-2.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "19",
                                "monoisotopic_mass": "4586.7097",
                                "monoisotopic_mz": "1147.6847",
                                "intensity": "6475.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "20",
                                "monoisotopic_mass": "3955.7951",
                                "monoisotopic_mz": "1319.6057",
                                "intensity": "6058.59",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "21",
                                "monoisotopic_mass": "3121.5995",
                                "monoisotopic_mz": "1041.5405",
                                "intensity": "5431.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "22",
                                "monoisotopic_mass": "4450.2774",
                                "monoisotopic_mz": "1484.4331",
                                "intensity": "7772.85",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "23",
                                "monoisotopic_mass": "4521.1861",
                                "monoisotopic_mz": "1131.3038",
                                "intensity": "5955.40",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "24",
                                "monoisotopic_mass": "6977.4641",
                                "monoisotopic_mz": "1163.9180",
                                "intensity": "2193.79",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "25",
                                "monoisotopic_mass": "5367.4477",
                                "monoisotopic_mz": "1342.8692",
                                "intensity": "10218.00",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.59"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "26",
                                "monoisotopic_mass": "8445.0552",
                                "monoisotopic_mz": "1207.4437",
                                "intensity": "10038.29",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8444.1041",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "B00072",
                                        "ion_left_position": "72",
                                        "mass_error": "-0.0512",
                                        "ppm": "-6.06"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "27",
                                "monoisotopic_mass": "2228.0758",
                                "monoisotopic_mz": "1115.0452",
                                "intensity": "4353.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "28",
                                "monoisotopic_mass": "5808.8861",
                                "monoisotopic_mz": "1453.2288",
                                "intensity": "3025.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "29",
                                "monoisotopic_mass": "2511.6670",
                                "monoisotopic_mz": "1256.8408",
                                "intensity": "2786.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "30",
                                "monoisotopic_mass": "3344.8792",
                                "monoisotopic_mz": "1115.9670",
                                "intensity": "7504.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "31",
                                "monoisotopic_mass": "4694.1461",
                                "monoisotopic_mz": "1174.5438",
                                "intensity": "3067.95",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4694.1590",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "ion_sort_name": "B00041",
                                        "ion_left_position": "41",
                                        "mass_error": "-0.0129",
                                        "ppm": "-2.75"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "32",
                                "monoisotopic_mass": "8869.2686",
                                "monoisotopic_mz": "1268.0456",
                                "intensity": "4824.16",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "33",
                                "monoisotopic_mass": "3792.9642",
                                "monoisotopic_mz": "1265.3287",
                                "intensity": "4503.47",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "34",
                                "monoisotopic_mass": "8603.1824",
                                "monoisotopic_mz": "1230.0333",
                                "intensity": "4668.21",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8602.1732",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "ion_sort_name": "B00074",
                                        "ion_left_position": "74",
                                        "mass_error": "0.0068",
                                        "ppm": "0.80"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "35",
                                "monoisotopic_mass": "1215.2160",
                                "monoisotopic_mz": "1216.2233",
                                "intensity": "2351.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "36",
                                "monoisotopic_mass": "1966.8385",
                                "monoisotopic_mz": "984.4265",
                                "intensity": "1321.76",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1966.8401",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "ion_sort_name": "B00017",
                                        "ion_left_position": "17",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.79"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "37",
                                "monoisotopic_mass": "5678.8504",
                                "monoisotopic_mz": "1420.7199",
                                "intensity": "3968.05",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "38",
                                "monoisotopic_mass": "8853.3324",
                                "monoisotopic_mz": "1265.7690",
                                "intensity": "5308.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "39",
                                "monoisotopic_mass": "4333.5699",
                                "monoisotopic_mz": "1084.3997",
                                "intensity": "1594.45",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "40",
                                "monoisotopic_mass": "1201.1069",
                                "monoisotopic_mz": "1202.1141",
                                "intensity": "2517.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "41",
                                "monoisotopic_mass": "3398.0790",
                                "monoisotopic_mz": "1133.7003",
                                "intensity": "1111.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "42",
                                "monoisotopic_mass": "3922.9892",
                                "monoisotopic_mz": "1308.6704",
                                "intensity": "3822.77",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "43",
                                "monoisotopic_mass": "2762.2667",
                                "monoisotopic_mz": "1382.1406",
                                "intensity": "3081.17",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2762.2714",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "-0.0046",
                                        "ppm": "-1.68"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "44",
                                "monoisotopic_mass": "4777.1914",
                                "monoisotopic_mz": "1195.3051",
                                "intensity": "5462.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "45",
                                "monoisotopic_mass": "2402.5385",
                                "monoisotopic_mz": "1202.2765",
                                "intensity": "2918.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "46",
                                "monoisotopic_mass": "1154.5965",
                                "monoisotopic_mz": "1155.6038",
                                "intensity": "1363.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "47",
                                "monoisotopic_mass": "1245.4594",
                                "monoisotopic_mz": "1246.4667",
                                "intensity": "1588.56",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "48",
                                "monoisotopic_mass": "720.3431",
                                "monoisotopic_mz": "721.3504",
                                "intensity": "2332.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "49",
                                "monoisotopic_mass": "8739.1978",
                                "monoisotopic_mz": "1249.4641",
                                "intensity": "1262.03",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "50",
                                "monoisotopic_mass": "5792.8690",
                                "monoisotopic_mz": "1449.2245",
                                "intensity": "1036.34",
                                "charge": "4"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "51",
                                "monoisotopic_mass": "9010.2786",
                                "monoisotopic_mz": "1127.2921",
                                "intensity": "1343.82",
                                "charge": "8"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "52",
                                "monoisotopic_mass": "1076.1898",
                                "monoisotopic_mz": "1077.1970",
                                "intensity": "2437.15",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "53",
                                "monoisotopic_mass": "1116.5107",
                                "monoisotopic_mz": "1117.5179",
                                "intensity": "1083.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "54",
                                "monoisotopic_mass": "3426.3904",
                                "monoisotopic_mz": "1143.1374",
                                "intensity": "1192.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "55",
                                "monoisotopic_mass": "5823.7135",
                                "monoisotopic_mz": "1165.7500",
                                "intensity": "950.74",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5822.7253",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "ion_sort_name": "B00051",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0142",
                                        "ppm": "-2.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "56",
                                "monoisotopic_mass": "6002.3508",
                                "monoisotopic_mz": "1201.4774",
                                "intensity": "1306.53",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "57",
                                "monoisotopic_mass": "3445.8014",
                                "monoisotopic_mz": "1149.6077",
                                "intensity": "1146.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "58",
                                "monoisotopic_mass": "1395.8940",
                                "monoisotopic_mz": "1396.9012",
                                "intensity": "824.74",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "59",
                                "monoisotopic_mass": "2496.1164",
                                "monoisotopic_mz": "1249.0655",
                                "intensity": "1089.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "60",
                                "monoisotopic_mass": "2361.4545",
                                "monoisotopic_mz": "1181.7345",
                                "intensity": "1096.52",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "61",
                                "monoisotopic_mass": "2743.3337",
                                "monoisotopic_mz": "1372.6741",
                                "intensity": "1158.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "62",
                                "monoisotopic_mass": "4047.9854",
                                "monoisotopic_mz": "1350.3357",
                                "intensity": "2517.21",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "63",
                                "monoisotopic_mass": "7662.7346",
                                "monoisotopic_mz": "1095.6836",
                                "intensity": "2334.44",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7661.8314",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "13",
                                            "mass_error": "-0.0991",
                                            "ppm": "-12.94"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7662.7282",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "B00066",
                                            "ion_left_position": "66",
                                            "mass_error": "0.0064",
                                            "ppm": "0.84"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "64",
                                "monoisotopic_mass": "5478.2652",
                                "monoisotopic_mz": "1096.6603",
                                "intensity": "1068.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "65",
                                "monoisotopic_mass": "6731.6470",
                                "monoisotopic_mz": "1347.3367",
                                "intensity": "1301.63",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "66",
                                "monoisotopic_mass": "934.4751",
                                "monoisotopic_mz": "935.4824",
                                "intensity": "1344.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "67",
                                "monoisotopic_mass": "870.4195",
                                "monoisotopic_mz": "871.4268",
                                "intensity": "1864.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "68",
                                "monoisotopic_mass": "1337.8611",
                                "monoisotopic_mz": "1338.8684",
                                "intensity": "838.05",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "69",
                                "monoisotopic_mass": "6058.0417",
                                "monoisotopic_mz": "1212.6156",
                                "intensity": "945.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "70",
                                "monoisotopic_mass": "1467.7492",
                                "monoisotopic_mz": "1468.7565",
                                "intensity": "729.83",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "71",
                                "monoisotopic_mass": "5742.8629",
                                "monoisotopic_mz": "1149.5799",
                                "intensity": "874.31",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "72",
                                "monoisotopic_mass": "8001.0390",
                                "monoisotopic_mz": "1144.0128",
                                "intensity": "774.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "73",
                                "monoisotopic_mass": "6598.3325",
                                "monoisotopic_mz": "1320.6738",
                                "intensity": "2292.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "74",
                                "monoisotopic_mass": "7223.5867",
                                "monoisotopic_mz": "1204.9384",
                                "intensity": "1015.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "75",
                                "monoisotopic_mass": "1167.5933",
                                "monoisotopic_mz": "1168.6006",
                                "intensity": "681.99",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "76",
                                "monoisotopic_mass": "1306.5336",
                                "monoisotopic_mz": "1307.5409",
                                "intensity": "1411.03",
                                "charge": "1"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "77",
                                "monoisotopic_mass": "2169.0432",
                                "monoisotopic_mz": "1085.5289",
                                "intensity": "1776.71",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "78",
                                "monoisotopic_mass": "4019.0104",
                                "monoisotopic_mz": "1340.6774",
                                "intensity": "2978.51",
                                "charge": "3"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "79",
                                "monoisotopic_mass": "2609.9339",
                                "monoisotopic_mz": "1305.9742",
                                "intensity": "4329.92",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "80",
                                "monoisotopic_mass": "5452.6967",
                                "monoisotopic_mz": "1091.5466",
                                "intensity": "2308.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "81",
                                "monoisotopic_mass": "2203.2766",
                                "monoisotopic_mz": "1102.6456",
                                "intensity": "1837.53",
                                "charge": "2"
                            },
                            {
                                "spec_id": "151",
                                "peak_id": "82",
                                "monoisotopic_mass": "2261.8384",
                                "monoisotopic_mz": "1131.9265",
                                "intensity": "2928.53",
                                "charge": "2"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "66",
                                        "spec_id": "151",
                                        "peak_id": "63",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "17",
                                        "ion_display_position": "17",
                                        "spec_id": "151",
                                        "peak_id": "36",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "151",
                                        "peak_id": "43",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "32",
                                        "ion_display_position": "32",
                                        "spec_id": "151",
                                        "peak_id": "15",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "151",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "151",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "151",
                                        "peak_id": "10",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "41",
                                        "ion_display_position": "41",
                                        "spec_id": "151",
                                        "peak_id": "31",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "151",
                                        "peak_id": "25",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "51",
                                        "ion_display_position": "51",
                                        "spec_id": "151",
                                        "peak_id": "55",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "66",
                                        "ion_display_position": "66",
                                        "spec_id": "151",
                                        "peak_id": "63",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "spec_id": "151",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "151",
                                        "peak_id": "18",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "74",
                                        "ion_display_position": "74",
                                        "spec_id": "151",
                                        "peak_id": "34",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "spec_id": "151",
                                        "peak_id": "2",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "151",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "148",
                "p_value": "1.70e-08",
                "e_value": "1.70e-08",
                "fdr": "0",
                "matched_fragment_number": "20",
                "matched_peak_number": "21",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "121",
                        "ms1_scans": "331",
                        "ids": "210",
                        "scans": "333",
                        "precursor_mono_mass": "9173.4111",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2752",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "210",
                                "peak_id": "0",
                                "monoisotopic_mass": "8832.2453",
                                "monoisotopic_mz": "1105.0379",
                                "intensity": "46101.16",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0002",
                                        "ppm": "-0.02"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "1",
                                "monoisotopic_mass": "8831.2403",
                                "monoisotopic_mz": "1262.6130",
                                "intensity": "45760.13",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0028",
                                        "ppm": "-0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "2",
                                "monoisotopic_mass": "7579.7754",
                                "monoisotopic_mz": "1264.3032",
                                "intensity": "26967.33",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "3",
                                "monoisotopic_mass": "8813.2097",
                                "monoisotopic_mz": "1102.6585",
                                "intensity": "25186.43",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "4",
                                "monoisotopic_mass": "8742.2168",
                                "monoisotopic_mz": "1249.8954",
                                "intensity": "18122.41",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "5",
                                "monoisotopic_mass": "3973.8142",
                                "monoisotopic_mz": "1325.6120",
                                "intensity": "17072.55",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0006",
                                        "ppm": "-0.14"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "6",
                                "monoisotopic_mass": "7432.7275",
                                "monoisotopic_mz": "1239.7952",
                                "intensity": "21092.77",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7433.7204",
                                        "ion_position": "15",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0095",
                                        "ppm": "1.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "7",
                                "monoisotopic_mass": "8898.2869",
                                "monoisotopic_mz": "1113.2931",
                                "intensity": "20055.23",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "8",
                                "monoisotopic_mass": "8927.3103",
                                "monoisotopic_mz": "1116.9211",
                                "intensity": "24660.36",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "9",
                                "monoisotopic_mass": "7819.8504",
                                "monoisotopic_mz": "1304.3157",
                                "intensity": "11833.05",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "10",
                                "monoisotopic_mass": "7708.8402",
                                "monoisotopic_mz": "1285.8140",
                                "intensity": "13873.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "11",
                                "monoisotopic_mass": "8629.1974",
                                "monoisotopic_mz": "1233.7498",
                                "intensity": "19831.28",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "12",
                                "monoisotopic_mass": "4036.0410",
                                "monoisotopic_mz": "1346.3543",
                                "intensity": "11534.28",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "13",
                                "monoisotopic_mass": "8943.2693",
                                "monoisotopic_mz": "1118.9159",
                                "intensity": "12173.73",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0555",
                                        "ppm": "-6.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "14",
                                "monoisotopic_mass": "4777.1964",
                                "monoisotopic_mz": "1195.3064",
                                "intensity": "12422.48",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "15",
                                "monoisotopic_mass": "8911.2816",
                                "monoisotopic_mz": "1114.9175",
                                "intensity": "11324.72",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "16",
                                "monoisotopic_mass": "8612.1623",
                                "monoisotopic_mz": "1231.3162",
                                "intensity": "14555.47",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "17",
                                "monoisotopic_mass": "8759.2237",
                                "monoisotopic_mz": "1252.3249",
                                "intensity": "15022.69",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "18",
                                "monoisotopic_mass": "4494.0393",
                                "monoisotopic_mz": "1124.5171",
                                "intensity": "10243.71",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.81"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "19",
                                "monoisotopic_mass": "4136.8765",
                                "monoisotopic_mz": "1379.9661",
                                "intensity": "12299.93",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "20",
                                "monoisotopic_mass": "8444.1050",
                                "monoisotopic_mz": "1207.3080",
                                "intensity": "5611.70",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8444.1041",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "ion_sort_name": "B00072",
                                        "ion_left_position": "72",
                                        "mass_error": "0.0009",
                                        "ppm": "0.11"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "21",
                                "monoisotopic_mass": "3121.5992",
                                "monoisotopic_mz": "1561.8069",
                                "intensity": "13818.48",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "22",
                                "monoisotopic_mass": "5366.4551",
                                "monoisotopic_mz": "1342.6211",
                                "intensity": "10138.51",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0066",
                                        "ppm": "1.23"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "23",
                                "monoisotopic_mass": "8796.2205",
                                "monoisotopic_mz": "1100.5348",
                                "intensity": "12740.33",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "24",
                                "monoisotopic_mass": "3121.5973",
                                "monoisotopic_mz": "1041.5397",
                                "intensity": "5572.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "25",
                                "monoisotopic_mass": "7319.6432",
                                "monoisotopic_mz": "1220.9478",
                                "intensity": "10191.47",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7320.6363",
                                        "ion_position": "16",
                                        "ion_display_position": "63",
                                        "ion_sort_name": "Y00063",
                                        "ion_left_position": "16",
                                        "mass_error": "0.0092",
                                        "ppm": "1.26"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "26",
                                "monoisotopic_mass": "7826.7919",
                                "monoisotopic_mz": "1119.1204",
                                "intensity": "9335.58",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7825.7915",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "ion_sort_name": "B00067",
                                        "ion_left_position": "67",
                                        "mass_error": "-0.0020",
                                        "ppm": "-0.25"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "27",
                                "monoisotopic_mass": "8516.1208",
                                "monoisotopic_mz": "1217.5960",
                                "intensity": "6812.84",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8515.1412",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "ion_sort_name": "B00073",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0227",
                                        "ppm": "-2.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "28",
                                "monoisotopic_mass": "3644.6484",
                                "monoisotopic_mz": "1215.8901",
                                "intensity": "4374.82",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3644.6561",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "ion_sort_name": "B00031",
                                        "ion_left_position": "31",
                                        "mass_error": "-0.0076",
                                        "ppm": "-2.09"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "29",
                                "monoisotopic_mass": "3017.4830",
                                "monoisotopic_mz": "1006.8349",
                                "intensity": "8706.96",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "30",
                                "monoisotopic_mass": "5023.3335",
                                "monoisotopic_mz": "1256.8407",
                                "intensity": "6491.39",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5022.3337",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "31",
                                "monoisotopic_mass": "8715.2097",
                                "monoisotopic_mz": "1246.0372",
                                "intensity": "8052.49",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8716.2161",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "ion_sort_name": "B00075",
                                        "ion_left_position": "75",
                                        "mass_error": "-0.0041",
                                        "ppm": "-0.47"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "32",
                                "monoisotopic_mass": "7205.5985",
                                "monoisotopic_mz": "1201.9404",
                                "intensity": "11944.54",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7206.5934",
                                        "ion_position": "17",
                                        "ion_display_position": "62",
                                        "ion_sort_name": "Y00062",
                                        "ion_left_position": "17",
                                        "mass_error": "0.0075",
                                        "ppm": "1.04"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "33",
                                "monoisotopic_mass": "4250.1741",
                                "monoisotopic_mz": "1417.7320",
                                "intensity": "8410.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "34",
                                "monoisotopic_mass": "7689.8130",
                                "monoisotopic_mz": "1282.6428",
                                "intensity": "9949.90",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "35",
                                "monoisotopic_mass": "3955.8010",
                                "monoisotopic_mz": "1319.6076",
                                "intensity": "7586.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "36",
                                "monoisotopic_mass": "8879.2810",
                                "monoisotopic_mz": "1110.9174",
                                "intensity": "7620.51",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "37",
                                "monoisotopic_mass": "720.3439",
                                "monoisotopic_mz": "721.3511",
                                "intensity": "7669.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "38",
                                "monoisotopic_mass": "3008.5189",
                                "monoisotopic_mz": "1505.2667",
                                "intensity": "4724.94",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "39",
                                "monoisotopic_mass": "3464.7939",
                                "monoisotopic_mz": "1155.9386",
                                "intensity": "7351.06",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "40",
                                "monoisotopic_mass": "7560.7537",
                                "monoisotopic_mz": "1261.1329",
                                "intensity": "10751.10",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "41",
                                "monoisotopic_mass": "947.4017",
                                "monoisotopic_mz": "948.4090",
                                "intensity": "4447.75",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "947.4018",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0001",
                                        "ppm": "-0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "42",
                                "monoisotopic_mass": "1739.7176",
                                "monoisotopic_mz": "1740.7249",
                                "intensity": "4062.05",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0045",
                                        "ppm": "2.58"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "43",
                                "monoisotopic_mass": "3690.8942",
                                "monoisotopic_mz": "1231.3054",
                                "intensity": "5222.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "44",
                                "monoisotopic_mass": "934.4746",
                                "monoisotopic_mz": "935.4819",
                                "intensity": "4013.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "45",
                                "monoisotopic_mass": "3103.5678",
                                "monoisotopic_mz": "1552.7912",
                                "intensity": "5388.72",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "46",
                                "monoisotopic_mass": "1112.2830",
                                "monoisotopic_mz": "1113.2903",
                                "intensity": "5401.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "47",
                                "monoisotopic_mass": "1259.4644",
                                "monoisotopic_mz": "1260.4717",
                                "intensity": "3800.97",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "48",
                                "monoisotopic_mass": "3674.8758",
                                "monoisotopic_mz": "1225.9659",
                                "intensity": "4899.57",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "49",
                                "monoisotopic_mass": "846.3530",
                                "monoisotopic_mz": "847.3603",
                                "intensity": "4099.99",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "846.3542",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0012",
                                        "ppm": "-1.37"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "50",
                                "monoisotopic_mass": "3000.4762",
                                "monoisotopic_mz": "1001.1660",
                                "intensity": "2772.89",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "51",
                                "monoisotopic_mass": "8072.8675",
                                "monoisotopic_mz": "1154.2741",
                                "intensity": "6195.73",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8073.9076",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "-0.0377",
                                        "ppm": "-4.67"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "52",
                                "monoisotopic_mass": "2196.2967",
                                "monoisotopic_mz": "1099.1556",
                                "intensity": "3788.75",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "53",
                                "monoisotopic_mass": "3921.9667",
                                "monoisotopic_mz": "1308.3295",
                                "intensity": "4965.20",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "54",
                                "monoisotopic_mass": "5565.7767",
                                "monoisotopic_mz": "1392.4515",
                                "intensity": "2841.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "55",
                                "monoisotopic_mass": "7037.5908",
                                "monoisotopic_mz": "1173.9391",
                                "intensity": "2106.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "56",
                                "monoisotopic_mass": "821.3919",
                                "monoisotopic_mz": "822.3992",
                                "intensity": "4928.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "57",
                                "monoisotopic_mass": "7544.7371",
                                "monoisotopic_mz": "1258.4635",
                                "intensity": "4743.75",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "58",
                                "monoisotopic_mass": "1198.5922",
                                "monoisotopic_mz": "1199.5995",
                                "intensity": "2505.63",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "59",
                                "monoisotopic_mass": "6979.4918",
                                "monoisotopic_mz": "1396.9056",
                                "intensity": "2677.40",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "60",
                                "monoisotopic_mass": "8497.1245",
                                "monoisotopic_mz": "1214.8822",
                                "intensity": "4818.18",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "61",
                                "monoisotopic_mass": "4149.1226",
                                "monoisotopic_mz": "1384.0481",
                                "intensity": "5559.26",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "62",
                                "monoisotopic_mass": "1030.4751",
                                "monoisotopic_mz": "1031.4824",
                                "intensity": "2778.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "63",
                                "monoisotopic_mass": "1217.8748",
                                "monoisotopic_mz": "1218.8821",
                                "intensity": "2436.06",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "64",
                                "monoisotopic_mass": "1139.5590",
                                "monoisotopic_mz": "1140.5663",
                                "intensity": "2653.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "65",
                                "monoisotopic_mass": "2209.5569",
                                "monoisotopic_mz": "1105.7857",
                                "intensity": "2295.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "66",
                                "monoisotopic_mass": "1005.4502",
                                "monoisotopic_mz": "1006.4575",
                                "intensity": "2060.57",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "67",
                                "monoisotopic_mass": "5531.7421",
                                "monoisotopic_mz": "1107.3557",
                                "intensity": "2302.10",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "68",
                                "monoisotopic_mass": "5153.3618",
                                "monoisotopic_mz": "1289.3477",
                                "intensity": "1403.28",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "69",
                                "monoisotopic_mass": "2763.2706",
                                "monoisotopic_mz": "1382.6426",
                                "intensity": "3236.89",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "70",
                                "monoisotopic_mass": "1364.5322",
                                "monoisotopic_mz": "683.2734",
                                "intensity": "5564.14",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0015",
                                        "ppm": "-1.07"
                                    }
                                }
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "71",
                                "monoisotopic_mass": "8054.9070",
                                "monoisotopic_mz": "1151.7083",
                                "intensity": "2312.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "72",
                                "monoisotopic_mass": "528.2728",
                                "monoisotopic_mz": "529.2801",
                                "intensity": "1869.41",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "73",
                                "monoisotopic_mass": "7837.8919",
                                "monoisotopic_mz": "1307.3226",
                                "intensity": "1330.59",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "74",
                                "monoisotopic_mass": "6846.3906",
                                "monoisotopic_mz": "1142.0724",
                                "intensity": "2196.87",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "75",
                                "monoisotopic_mass": "1081.6453",
                                "monoisotopic_mz": "1082.6526",
                                "intensity": "1545.82",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "76",
                                "monoisotopic_mass": "557.2806",
                                "monoisotopic_mz": "558.2878",
                                "intensity": "3027.34",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "77",
                                "monoisotopic_mass": "3057.5478",
                                "monoisotopic_mz": "1020.1899",
                                "intensity": "2155.29",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "78",
                                "monoisotopic_mass": "916.4637",
                                "monoisotopic_mz": "917.4709",
                                "intensity": "1721.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "79",
                                "monoisotopic_mass": "7773.8628",
                                "monoisotopic_mz": "1296.6511",
                                "intensity": "1514.18",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "80",
                                "monoisotopic_mass": "2174.7997",
                                "monoisotopic_mz": "1088.4071",
                                "intensity": "4141.82",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "81",
                                "monoisotopic_mass": "6449.1898",
                                "monoisotopic_mz": "1290.8452",
                                "intensity": "4057.81",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "82",
                                "monoisotopic_mass": "2239.0708",
                                "monoisotopic_mz": "1120.5427",
                                "intensity": "3477.83",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "83",
                                "monoisotopic_mass": "7960.2451",
                                "monoisotopic_mz": "996.0379",
                                "intensity": "1308.73",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "84",
                                "monoisotopic_mass": "4341.5888",
                                "monoisotopic_mz": "1086.4045",
                                "intensity": "2933.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "85",
                                "monoisotopic_mass": "870.4194",
                                "monoisotopic_mz": "871.4267",
                                "intensity": "2901.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "86",
                                "monoisotopic_mass": "1285.5773",
                                "monoisotopic_mz": "1286.5846",
                                "intensity": "913.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "87",
                                "monoisotopic_mass": "5898.6916",
                                "monoisotopic_mz": "984.1226",
                                "intensity": "2534.48",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "88",
                                "monoisotopic_mass": "3321.2956",
                                "monoisotopic_mz": "1108.1058",
                                "intensity": "5131.63",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "89",
                                "monoisotopic_mass": "1168.5143",
                                "monoisotopic_mz": "1169.5216",
                                "intensity": "1264.84",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "90",
                                "monoisotopic_mass": "3446.7652",
                                "monoisotopic_mz": "1149.9290",
                                "intensity": "3677.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "91",
                                "monoisotopic_mass": "4358.1192",
                                "monoisotopic_mz": "1090.5371",
                                "intensity": "2298.00",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "92",
                                "monoisotopic_mass": "8845.2318",
                                "monoisotopic_mz": "1106.6612",
                                "intensity": "660.46",
                                "charge": "8"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "93",
                                "monoisotopic_mass": "8838.6929",
                                "monoisotopic_mz": "983.0843",
                                "intensity": "930.30",
                                "charge": "9"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "94",
                                "monoisotopic_mass": "1306.1463",
                                "monoisotopic_mz": "1307.1536",
                                "intensity": "719.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "95",
                                "monoisotopic_mass": "1346.5227",
                                "monoisotopic_mz": "674.2686",
                                "intensity": "822.99",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "96",
                                "monoisotopic_mass": "2559.1743",
                                "monoisotopic_mz": "854.0654",
                                "intensity": "3212.14",
                                "charge": "3"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "97",
                                "monoisotopic_mass": "7975.3128",
                                "monoisotopic_mz": "1140.3377",
                                "intensity": "1361.53",
                                "charge": "7"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "98",
                                "monoisotopic_mass": "2738.3171",
                                "monoisotopic_mz": "1370.1658",
                                "intensity": "1110.70",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "99",
                                "monoisotopic_mass": "1126.9783",
                                "monoisotopic_mz": "1127.9856",
                                "intensity": "809.61",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "100",
                                "monoisotopic_mass": "771.4122",
                                "monoisotopic_mz": "772.4195",
                                "intensity": "1558.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "101",
                                "monoisotopic_mass": "5638.3464",
                                "monoisotopic_mz": "1128.6766",
                                "intensity": "1024.79",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "102",
                                "monoisotopic_mass": "1047.4803",
                                "monoisotopic_mz": "1048.4875",
                                "intensity": "1283.58",
                                "charge": "1"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "103",
                                "monoisotopic_mass": "6469.0971",
                                "monoisotopic_mz": "1079.1901",
                                "intensity": "1986.95",
                                "charge": "6"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "104",
                                "monoisotopic_mass": "4257.5445",
                                "monoisotopic_mz": "1065.3934",
                                "intensity": "2305.88",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "105",
                                "monoisotopic_mass": "4952.1982",
                                "monoisotopic_mz": "1239.0568",
                                "intensity": "1085.32",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "106",
                                "monoisotopic_mass": "4588.3443",
                                "monoisotopic_mz": "1148.0933",
                                "intensity": "2640.38",
                                "charge": "4"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "107",
                                "monoisotopic_mass": "5670.9602",
                                "monoisotopic_mz": "1135.1993",
                                "intensity": "3143.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "108",
                                "monoisotopic_mass": "2026.9974",
                                "monoisotopic_mz": "1014.5060",
                                "intensity": "1722.07",
                                "charge": "2"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "109",
                                "monoisotopic_mass": "6279.2243",
                                "monoisotopic_mz": "1256.8521",
                                "intensity": "2564.22",
                                "charge": "5"
                            },
                            {
                                "spec_id": "210",
                                "peak_id": "110",
                                "monoisotopic_mass": "3292.9497",
                                "monoisotopic_mz": "1098.6572",
                                "intensity": "2752.67",
                                "charge": "3"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "210",
                                        "peak_id": "49",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "210",
                                        "peak_id": "41",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "210",
                                        "peak_id": "70",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "210",
                                            "peak_id": "42",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "64",
                                            "spec_id": "210",
                                            "peak_id": "6",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "16",
                                        "ion_display_position": "63",
                                        "spec_id": "210",
                                        "peak_id": "25",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "17",
                                        "ion_display_position": "62",
                                        "spec_id": "210",
                                        "peak_id": "32",
                                        "peak_charge": "6"
                                    }
                                }
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "31",
                                        "ion_display_position": "31",
                                        "spec_id": "210",
                                        "peak_id": "28",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "210",
                                        "peak_id": "5",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "210",
                                        "peak_id": "19",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "210",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "210",
                                        "peak_id": "30",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "210",
                                        "peak_id": "22",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "67",
                                        "ion_display_position": "67",
                                        "spec_id": "210",
                                        "peak_id": "26",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "spec_id": "210",
                                        "peak_id": "51",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "72",
                                        "ion_display_position": "72",
                                        "spec_id": "210",
                                        "peak_id": "20",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "210",
                                        "peak_id": "27",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "75",
                                        "ion_display_position": "75",
                                        "spec_id": "210",
                                        "peak_id": "31",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "210",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "210",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "210",
                                        "peak_id": "13",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "88",
                "p_value": "4.50e-08",
                "e_value": "4.50e-08",
                "fdr": "0",
                "matched_fragment_number": "18",
                "matched_peak_number": "19",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "94",
                        "ms1_scans": "217",
                        "ids": "123",
                        "scans": "219",
                        "precursor_mono_mass": "9173.4023",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2742",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "123",
                                "peak_id": "0",
                                "monoisotopic_mass": "8832.2424",
                                "monoisotopic_mz": "1105.0376",
                                "intensity": "57434.73",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0031",
                                        "ppm": "-0.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "1",
                                "monoisotopic_mass": "8831.2395",
                                "monoisotopic_mz": "1262.6129",
                                "intensity": "49414.16",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0036",
                                        "ppm": "-0.41"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "2",
                                "monoisotopic_mass": "8814.2140",
                                "monoisotopic_mz": "1102.7840",
                                "intensity": "27128.24",
                                "charge": "8"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "3",
                                "monoisotopic_mass": "8927.3171",
                                "monoisotopic_mz": "1116.9219",
                                "intensity": "23346.19",
                                "charge": "8"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "4",
                                "monoisotopic_mass": "8944.3255",
                                "monoisotopic_mz": "1119.0480",
                                "intensity": "20521.45",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0016",
                                        "ppm": "-0.18"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "5",
                                "monoisotopic_mass": "7579.7934",
                                "monoisotopic_mz": "1264.3062",
                                "intensity": "28555.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "6",
                                "monoisotopic_mass": "8630.2006",
                                "monoisotopic_mz": "1233.8931",
                                "intensity": "17524.55",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "7",
                                "monoisotopic_mass": "4777.1959",
                                "monoisotopic_mz": "1195.3062",
                                "intensity": "10444.18",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "8",
                                "monoisotopic_mass": "3974.8180",
                                "monoisotopic_mz": "1325.9466",
                                "intensity": "11253.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "9",
                                "monoisotopic_mass": "8516.1327",
                                "monoisotopic_mz": "1217.5977",
                                "intensity": "13823.69",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8515.1412",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "ion_sort_name": "B00073",
                                        "ion_left_position": "73",
                                        "mass_error": "-0.0108",
                                        "ppm": "-1.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "10",
                                "monoisotopic_mass": "8814.2248",
                                "monoisotopic_mz": "1260.1823",
                                "intensity": "16833.67",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "11",
                                "monoisotopic_mass": "4136.8820",
                                "monoisotopic_mz": "1379.9680",
                                "intensity": "10884.13",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "0.0040",
                                        "ppm": "0.96"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "12",
                                "monoisotopic_mass": "7562.7770",
                                "monoisotopic_mz": "1261.4701",
                                "intensity": "10530.66",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "13",
                                "monoisotopic_mass": "4036.0378",
                                "monoisotopic_mz": "1346.3532",
                                "intensity": "13635.66",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "14",
                                "monoisotopic_mass": "4494.0295",
                                "monoisotopic_mz": "1124.5146",
                                "intensity": "10687.85",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0134",
                                        "ppm": "-2.98"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "15",
                                "monoisotopic_mass": "8879.2707",
                                "monoisotopic_mz": "1110.9161",
                                "intensity": "11271.00",
                                "charge": "8"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "16",
                                "monoisotopic_mass": "8896.2970",
                                "monoisotopic_mz": "1113.0444",
                                "intensity": "9445.09",
                                "charge": "8"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "17",
                                "monoisotopic_mass": "8758.2385",
                                "monoisotopic_mz": "1252.1842",
                                "intensity": "14800.22",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "18",
                                "monoisotopic_mass": "3121.6019",
                                "monoisotopic_mz": "1561.8082",
                                "intensity": "13074.50",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "19",
                                "monoisotopic_mass": "5367.4555",
                                "monoisotopic_mz": "1342.8711",
                                "intensity": "9565.93",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0046",
                                        "ppm": "0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "20",
                                "monoisotopic_mass": "4456.6559",
                                "monoisotopic_mz": "1115.1712",
                                "intensity": "8072.63",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "21",
                                "monoisotopic_mass": "3463.7871",
                                "monoisotopic_mz": "1155.6030",
                                "intensity": "7605.54",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0051",
                                        "ppm": "-1.48"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "22",
                                "monoisotopic_mass": "7432.6861",
                                "monoisotopic_mz": "1239.7883",
                                "intensity": "9874.07",
                                "charge": "6",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "7433.7204",
                                        "ion_position": "15",
                                        "ion_display_position": "64",
                                        "ion_sort_name": "Y00064",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0319",
                                        "ppm": "-4.29"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "23",
                                "monoisotopic_mass": "3910.9310",
                                "monoisotopic_mz": "1304.6509",
                                "intensity": "5340.15",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "24",
                                "monoisotopic_mass": "3018.4802",
                                "monoisotopic_mz": "1007.1673",
                                "intensity": "6199.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "25",
                                "monoisotopic_mass": "2569.2741",
                                "monoisotopic_mz": "1285.6443",
                                "intensity": "9979.16",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "26",
                                "monoisotopic_mass": "3955.7955",
                                "monoisotopic_mz": "1319.6058",
                                "intensity": "8074.61",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "27",
                                "monoisotopic_mass": "720.3438",
                                "monoisotopic_mz": "721.3511",
                                "intensity": "6648.79",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "28",
                                "monoisotopic_mass": "4398.1021",
                                "monoisotopic_mz": "1100.5328",
                                "intensity": "5194.06",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "29",
                                "monoisotopic_mass": "3691.9259",
                                "monoisotopic_mz": "1231.6492",
                                "intensity": "8547.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "30",
                                "monoisotopic_mass": "4019.0214",
                                "monoisotopic_mz": "1340.6811",
                                "intensity": "4559.54",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "31",
                                "monoisotopic_mass": "2762.2728",
                                "monoisotopic_mz": "1382.1437",
                                "intensity": "4233.85",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2762.2714",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0015",
                                        "ppm": "0.53"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "32",
                                "monoisotopic_mass": "3775.9233",
                                "monoisotopic_mz": "1259.6484",
                                "intensity": "4415.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "33",
                                "monoisotopic_mass": "947.4025",
                                "monoisotopic_mz": "948.4097",
                                "intensity": "3639.51",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "947.4018",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "0.0006",
                                        "ppm": "0.64"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "34",
                                "monoisotopic_mass": "4250.1594",
                                "monoisotopic_mz": "1417.7271",
                                "intensity": "4681.11",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "35",
                                "monoisotopic_mass": "2605.6228",
                                "monoisotopic_mz": "1303.8187",
                                "intensity": "3067.34",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "36",
                                "monoisotopic_mass": "7466.7049",
                                "monoisotopic_mz": "1245.4581",
                                "intensity": "7358.61",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "37",
                                "monoisotopic_mass": "5151.3789",
                                "monoisotopic_mz": "1031.2830",
                                "intensity": "5375.10",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "0.0026",
                                        "ppm": "0.50"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "38",
                                "monoisotopic_mass": "1364.5327",
                                "monoisotopic_mz": "683.2736",
                                "intensity": "4740.08",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0010",
                                        "ppm": "-0.72"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "39",
                                "monoisotopic_mass": "3120.5818",
                                "monoisotopic_mz": "1041.2012",
                                "intensity": "5027.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "40",
                                "monoisotopic_mass": "5021.3214",
                                "monoisotopic_mz": "1256.3376",
                                "intensity": "6710.83",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5022.3337",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "ion_sort_name": "B00044",
                                        "ion_left_position": "44",
                                        "mass_error": "-0.0099",
                                        "ppm": "-1.97"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "41",
                                "monoisotopic_mass": "934.4753",
                                "monoisotopic_mz": "935.4826",
                                "intensity": "3894.40",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "42",
                                "monoisotopic_mass": "8797.2076",
                                "monoisotopic_mz": "1257.7512",
                                "intensity": "9270.60",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "43",
                                "monoisotopic_mass": "3673.8750",
                                "monoisotopic_mz": "1225.6323",
                                "intensity": "4618.53",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "44",
                                "monoisotopic_mass": "1221.4513",
                                "monoisotopic_mz": "1222.4586",
                                "intensity": "2734.91",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "45",
                                "monoisotopic_mass": "3350.7075",
                                "monoisotopic_mz": "1117.9098",
                                "intensity": "4405.85",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3350.7082",
                                        "ion_position": "51",
                                        "ion_display_position": "28",
                                        "ion_sort_name": "Y00028",
                                        "ion_left_position": "51",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.22"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "46",
                                "monoisotopic_mass": "1306.6495",
                                "monoisotopic_mz": "1307.6567",
                                "intensity": "2612.42",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "47",
                                "monoisotopic_mass": "3576.8738",
                                "monoisotopic_mz": "1193.2985",
                                "intensity": "5432.10",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "48",
                                "monoisotopic_mass": "8646.1514",
                                "monoisotopic_mz": "1236.1718",
                                "intensity": "5584.68",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "49",
                                "monoisotopic_mass": "1739.7116",
                                "monoisotopic_mz": "1740.7189",
                                "intensity": "3025.60",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0015",
                                        "ppm": "-0.85"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "50",
                                "monoisotopic_mass": "7689.8225",
                                "monoisotopic_mz": "1282.6444",
                                "intensity": "4862.47",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "51",
                                "monoisotopic_mass": "5564.7520",
                                "monoisotopic_mz": "1113.9577",
                                "intensity": "4027.30",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "52",
                                "monoisotopic_mass": "8611.1634",
                                "monoisotopic_mz": "1231.1735",
                                "intensity": "6502.79",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "53",
                                "monoisotopic_mass": "1102.9018",
                                "monoisotopic_mz": "1103.9091",
                                "intensity": "2322.39",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "54",
                                "monoisotopic_mass": "3008.5206",
                                "monoisotopic_mz": "1505.2676",
                                "intensity": "5097.74",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "55",
                                "monoisotopic_mass": "2402.8750",
                                "monoisotopic_mz": "1202.4448",
                                "intensity": "3612.32",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "56",
                                "monoisotopic_mass": "1411.3868",
                                "monoisotopic_mz": "1412.3940",
                                "intensity": "3013.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "57",
                                "monoisotopic_mass": "1965.8321",
                                "monoisotopic_mz": "1966.8394",
                                "intensity": "3200.19",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "58",
                                "monoisotopic_mass": "7930.8357",
                                "monoisotopic_mz": "1133.9838",
                                "intensity": "7028.19",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "59",
                                "monoisotopic_mass": "6451.2283",
                                "monoisotopic_mz": "1291.2529",
                                "intensity": "2436.71",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "60",
                                "monoisotopic_mass": "1284.9695",
                                "monoisotopic_mz": "1285.9768",
                                "intensity": "3669.46",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "61",
                                "monoisotopic_mass": "3875.7371",
                                "monoisotopic_mz": "1292.9196",
                                "intensity": "4922.18",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "62",
                                "monoisotopic_mass": "7449.6709",
                                "monoisotopic_mz": "1242.6191",
                                "intensity": "1522.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "63",
                                "monoisotopic_mass": "1113.9135",
                                "monoisotopic_mz": "1114.9208",
                                "intensity": "4767.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "64",
                                "monoisotopic_mass": "4908.2950",
                                "monoisotopic_mz": "1228.0810",
                                "intensity": "1197.39",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4908.2907",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "ion_sort_name": "B00043",
                                        "ion_left_position": "43",
                                        "mass_error": "0.0043",
                                        "ppm": "0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "65",
                                "monoisotopic_mass": "2434.9007",
                                "monoisotopic_mz": "1218.4576",
                                "intensity": "4249.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "66",
                                "monoisotopic_mass": "4695.1596",
                                "monoisotopic_mz": "1174.7972",
                                "intensity": "2835.95",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "67",
                                "monoisotopic_mass": "3058.4770",
                                "monoisotopic_mz": "1020.4996",
                                "intensity": "1981.35",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "68",
                                "monoisotopic_mass": "557.2809",
                                "monoisotopic_mz": "558.2881",
                                "intensity": "3148.54",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "69",
                                "monoisotopic_mass": "658.3282",
                                "monoisotopic_mz": "659.3354",
                                "intensity": "2141.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "70",
                                "monoisotopic_mass": "1235.4904",
                                "monoisotopic_mz": "1236.4977",
                                "intensity": "1454.70",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1235.4911",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "ion_sort_name": "B00011",
                                        "ion_left_position": "11",
                                        "mass_error": "-0.0007",
                                        "ppm": "-0.54"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "71",
                                "monoisotopic_mass": "2187.5552",
                                "monoisotopic_mz": "1094.7849",
                                "intensity": "870.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "72",
                                "monoisotopic_mass": "821.3913",
                                "monoisotopic_mz": "822.3986",
                                "intensity": "3865.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "73",
                                "monoisotopic_mass": "7802.8550",
                                "monoisotopic_mz": "1301.4831",
                                "intensity": "3233.25",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "74",
                                "monoisotopic_mass": "6722.4843",
                                "monoisotopic_mz": "1121.4213",
                                "intensity": "3243.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "75",
                                "monoisotopic_mass": "4082.0203",
                                "monoisotopic_mz": "1021.5124",
                                "intensity": "2337.99",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "76",
                                "monoisotopic_mass": "7203.6100",
                                "monoisotopic_mz": "1201.6089",
                                "intensity": "2826.98",
                                "charge": "6"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "77",
                                "monoisotopic_mass": "1346.5213",
                                "monoisotopic_mz": "674.2679",
                                "intensity": "2453.17",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "78",
                                "monoisotopic_mass": "3104.5869",
                                "monoisotopic_mz": "1035.8696",
                                "intensity": "3086.43",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "79",
                                "monoisotopic_mass": "846.3536",
                                "monoisotopic_mz": "847.3609",
                                "intensity": "2968.41",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "846.3542",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0005",
                                        "ppm": "-0.65"
                                    }
                                }
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "80",
                                "monoisotopic_mass": "1194.2989",
                                "monoisotopic_mz": "1195.3062",
                                "intensity": "380.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "81",
                                "monoisotopic_mass": "8742.1809",
                                "monoisotopic_mz": "1093.7799",
                                "intensity": "2443.80",
                                "charge": "8"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "82",
                                "monoisotopic_mass": "1030.2735",
                                "monoisotopic_mz": "1031.2808",
                                "intensity": "1314.20",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "83",
                                "monoisotopic_mass": "1465.7342",
                                "monoisotopic_mz": "1466.7415",
                                "intensity": "720.29",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "84",
                                "monoisotopic_mass": "1483.7616",
                                "monoisotopic_mz": "1484.7689",
                                "intensity": "2186.17",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "85",
                                "monoisotopic_mass": "5990.0016",
                                "monoisotopic_mz": "1199.0076",
                                "intensity": "1532.74",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "86",
                                "monoisotopic_mass": "870.4190",
                                "monoisotopic_mz": "871.4263",
                                "intensity": "2631.22",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "87",
                                "monoisotopic_mass": "1017.5316",
                                "monoisotopic_mz": "1018.5389",
                                "intensity": "1515.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "88",
                                "monoisotopic_mass": "7797.7272",
                                "monoisotopic_mz": "1114.9683",
                                "intensity": "2080.77",
                                "charge": "7"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "89",
                                "monoisotopic_mass": "1136.5679",
                                "monoisotopic_mz": "1137.5752",
                                "intensity": "1613.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "90",
                                "monoisotopic_mass": "1446.7348",
                                "monoisotopic_mz": "1447.7421",
                                "intensity": "848.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "91",
                                "monoisotopic_mass": "6113.3490",
                                "monoisotopic_mz": "1223.6771",
                                "intensity": "1508.16",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "92",
                                "monoisotopic_mass": "1003.5074",
                                "monoisotopic_mz": "1004.5147",
                                "intensity": "1697.14",
                                "charge": "1"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "93",
                                "monoisotopic_mass": "4890.3029",
                                "monoisotopic_mz": "1223.5830",
                                "intensity": "3445.52",
                                "charge": "4"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "94",
                                "monoisotopic_mass": "2494.1118",
                                "monoisotopic_mz": "1248.0632",
                                "intensity": "1784.65",
                                "charge": "2"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "95",
                                "monoisotopic_mass": "5859.6771",
                                "monoisotopic_mz": "1172.9427",
                                "intensity": "2584.19",
                                "charge": "5"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "96",
                                "monoisotopic_mass": "4152.8942",
                                "monoisotopic_mz": "1385.3053",
                                "intensity": "2628.22",
                                "charge": "3"
                            },
                            {
                                "spec_id": "123",
                                "peak_id": "97",
                                "monoisotopic_mass": "5739.2617",
                                "monoisotopic_mz": "957.5509",
                                "intensity": "2441.39",
                                "charge": "6"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "123",
                                        "peak_id": "79",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "123",
                                        "peak_id": "33",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "11",
                                        "ion_display_position": "11",
                                        "spec_id": "123",
                                        "peak_id": "70",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "123",
                                        "peak_id": "38",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "15",
                                            "ion_display_position": "15",
                                            "spec_id": "123",
                                            "peak_id": "49",
                                            "peak_charge": "1"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "15",
                                            "ion_display_position": "64",
                                            "spec_id": "123",
                                            "peak_id": "22",
                                            "peak_charge": "6"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "123",
                                        "peak_id": "31",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "123",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "spec_id": "123",
                                        "peak_id": "14",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "43",
                                        "ion_display_position": "43",
                                        "spec_id": "123",
                                        "peak_id": "64",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "44",
                                        "ion_display_position": "44",
                                        "spec_id": "123",
                                        "peak_id": "40",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "123",
                                        "peak_id": "37",
                                        "peak_charge": "5"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "123",
                                        "peak_id": "19",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "spec_id": "123",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "51",
                                        "ion_display_position": "28",
                                        "spec_id": "123",
                                        "peak_id": "45",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "73",
                                        "ion_display_position": "73",
                                        "spec_id": "123",
                                        "peak_id": "9",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "123",
                                            "peak_id": "1",
                                            "peak_charge": "7"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "123",
                                            "peak_id": "0",
                                            "peak_charge": "8"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "123",
                                        "peak_id": "4",
                                        "peak_charge": "8"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "166",
                "p_value": "1.12e-07",
                "e_value": "1.12e-07",
                "fdr": "0",
                "matched_fragment_number": "12",
                "matched_peak_number": "12",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "130",
                        "ms1_scans": "369",
                        "ids": "238",
                        "scans": "370",
                        "precursor_mono_mass": "9173.4079",
                        "precursor_charge": "8",
                        "precursor_mz": "1147.6833",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "238",
                                "peak_id": "0",
                                "monoisotopic_mass": "8944.3212",
                                "monoisotopic_mz": "1278.7675",
                                "intensity": "363887.44",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0059",
                                        "ppm": "-0.66"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "1",
                                "monoisotopic_mass": "8927.3066",
                                "monoisotopic_mz": "1276.3368",
                                "intensity": "90663.52",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "2",
                                "monoisotopic_mass": "8959.3107",
                                "monoisotopic_mz": "1280.9088",
                                "intensity": "32579.21",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "3",
                                "monoisotopic_mass": "8831.2420",
                                "monoisotopic_mz": "1262.6133",
                                "intensity": "29741.18",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0011",
                                        "ppm": "-0.12"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "4",
                                "monoisotopic_mass": "8898.3094",
                                "monoisotopic_mz": "1272.1943",
                                "intensity": "16627.05",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "5",
                                "monoisotopic_mass": "8831.2341",
                                "monoisotopic_mz": "1104.9115",
                                "intensity": "12147.67",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0089",
                                        "ppm": "-1.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "6",
                                "monoisotopic_mass": "3973.8087",
                                "monoisotopic_mz": "1325.6102",
                                "intensity": "10549.02",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "-0.0061",
                                        "ppm": "-1.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "7",
                                "monoisotopic_mass": "3121.6024",
                                "monoisotopic_mz": "1561.8085",
                                "intensity": "12732.31",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "8",
                                "monoisotopic_mass": "8884.2958",
                                "monoisotopic_mz": "1270.1924",
                                "intensity": "7834.23",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "9",
                                "monoisotopic_mass": "5565.7709",
                                "monoisotopic_mz": "1392.4500",
                                "intensity": "9416.22",
                                "charge": "4"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "10",
                                "monoisotopic_mass": "4250.1620",
                                "monoisotopic_mz": "1417.7280",
                                "intensity": "9405.83",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "11",
                                "monoisotopic_mass": "4136.8769",
                                "monoisotopic_mz": "1379.9662",
                                "intensity": "7933.38",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4136.8781",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "ion_sort_name": "B00035",
                                        "ion_left_position": "35",
                                        "mass_error": "-0.0012",
                                        "ppm": "-0.28"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "12",
                                "monoisotopic_mass": "8926.2982",
                                "monoisotopic_mz": "1116.7945",
                                "intensity": "12474.56",
                                "charge": "8"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "13",
                                "monoisotopic_mass": "4035.0274",
                                "monoisotopic_mz": "1346.0164",
                                "intensity": "7405.80",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "14",
                                "monoisotopic_mass": "9154.4294",
                                "monoisotopic_mz": "1145.3109",
                                "intensity": "9789.14",
                                "charge": "8"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "15",
                                "monoisotopic_mass": "4494.0400",
                                "monoisotopic_mz": "1124.5173",
                                "intensity": "13042.73",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4494.0429",
                                        "ion_position": "39",
                                        "ion_display_position": "39",
                                        "ion_sort_name": "B00039",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0029",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "16",
                                "monoisotopic_mass": "3955.7992",
                                "monoisotopic_mz": "1319.6070",
                                "intensity": "6940.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "17",
                                "monoisotopic_mass": "8719.2276",
                                "monoisotopic_mz": "1246.6112",
                                "intensity": "6324.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "18",
                                "monoisotopic_mass": "5368.4560",
                                "monoisotopic_mz": "1343.1213",
                                "intensity": "6246.75",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0028",
                                        "ppm": "0.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "19",
                                "monoisotopic_mass": "4679.3518",
                                "monoisotopic_mz": "1560.7912",
                                "intensity": "6182.32",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4679.3905",
                                        "ion_position": "39",
                                        "ion_display_position": "40",
                                        "ion_sort_name": "Y00040",
                                        "ion_left_position": "39",
                                        "mass_error": "-0.0387",
                                        "ppm": "-8.27"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "20",
                                "monoisotopic_mass": "5151.3726",
                                "monoisotopic_mz": "1288.8504",
                                "intensity": "3512.79",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0037",
                                        "ppm": "-0.71"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "21",
                                "monoisotopic_mass": "4264.9760",
                                "monoisotopic_mz": "1422.6659",
                                "intensity": "2796.62",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "4264.9730",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "ion_sort_name": "B00036",
                                        "ion_left_position": "36",
                                        "mass_error": "0.0029",
                                        "ppm": "0.69"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "22",
                                "monoisotopic_mass": "9140.3526",
                                "monoisotopic_mz": "1143.5514",
                                "intensity": "3242.30",
                                "charge": "8"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "23",
                                "monoisotopic_mass": "3793.9632",
                                "monoisotopic_mz": "1265.6617",
                                "intensity": "3124.05",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "24",
                                "monoisotopic_mass": "8343.0086",
                                "monoisotopic_mz": "1391.5087",
                                "intensity": "3735.46",
                                "charge": "6"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "25",
                                "monoisotopic_mass": "1169.2874",
                                "monoisotopic_mz": "1170.2947",
                                "intensity": "1191.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "26",
                                "monoisotopic_mass": "2394.5221",
                                "monoisotopic_mz": "1198.2683",
                                "intensity": "4373.40",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "27",
                                "monoisotopic_mass": "3121.5856",
                                "monoisotopic_mz": "1041.5358",
                                "intensity": "3792.32",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "28",
                                "monoisotopic_mass": "2607.9280",
                                "monoisotopic_mz": "1304.9713",
                                "intensity": "3508.86",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "29",
                                "monoisotopic_mass": "1225.2920",
                                "monoisotopic_mz": "1226.2993",
                                "intensity": "1541.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "30",
                                "monoisotopic_mass": "2761.2639",
                                "monoisotopic_mz": "1381.6392",
                                "intensity": "3285.29",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "31",
                                "monoisotopic_mass": "3464.7871",
                                "monoisotopic_mz": "1733.4008",
                                "intensity": "1002.06",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "32",
                                "monoisotopic_mass": "720.3439",
                                "monoisotopic_mz": "721.3512",
                                "intensity": "2163.68",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "33",
                                "monoisotopic_mass": "1245.6061",
                                "monoisotopic_mz": "1246.6134",
                                "intensity": "3006.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "34",
                                "monoisotopic_mass": "7661.7373",
                                "monoisotopic_mz": "1095.5412",
                                "intensity": "925.30",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7661.8314",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "13",
                                            "mass_error": "-0.0940",
                                            "ppm": "-12.27"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7662.7282",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "B00066",
                                            "ion_left_position": "66",
                                            "mass_error": "0.0115",
                                            "ppm": "1.50"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "35",
                                "monoisotopic_mass": "1112.5369",
                                "monoisotopic_mz": "1113.5442",
                                "intensity": "837.49",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "36",
                                "monoisotopic_mass": "6884.8044",
                                "monoisotopic_mz": "1148.4747",
                                "intensity": "1291.96",
                                "charge": "6"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "37",
                                "monoisotopic_mass": "2291.5967",
                                "monoisotopic_mz": "1146.8056",
                                "intensity": "1694.66",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "38",
                                "monoisotopic_mass": "7068.4958",
                                "monoisotopic_mz": "1010.7924",
                                "intensity": "908.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "39",
                                "monoisotopic_mass": "1306.4810",
                                "monoisotopic_mz": "1307.4883",
                                "intensity": "677.52",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "40",
                                "monoisotopic_mass": "2526.2663",
                                "monoisotopic_mz": "1264.1404",
                                "intensity": "892.88",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "41",
                                "monoisotopic_mass": "4796.2368",
                                "monoisotopic_mz": "1200.0665",
                                "intensity": "1995.67",
                                "charge": "4"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "42",
                                "monoisotopic_mass": "8696.1478",
                                "monoisotopic_mz": "1088.0258",
                                "intensity": "1223.13",
                                "charge": "8"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "43",
                                "monoisotopic_mass": "934.4758",
                                "monoisotopic_mz": "935.4830",
                                "intensity": "757.13",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "44",
                                "monoisotopic_mass": "3541.7315",
                                "monoisotopic_mz": "1181.5844",
                                "intensity": "1167.08",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "45",
                                "monoisotopic_mass": "2260.0856",
                                "monoisotopic_mz": "1131.0501",
                                "intensity": "3342.56",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "46",
                                "monoisotopic_mass": "1484.0923",
                                "monoisotopic_mz": "1485.0996",
                                "intensity": "1490.87",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "47",
                                "monoisotopic_mass": "2407.5563",
                                "monoisotopic_mz": "1204.7854",
                                "intensity": "1209.13",
                                "charge": "2"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "48",
                                "monoisotopic_mass": "4924.9394",
                                "monoisotopic_mz": "1232.2421",
                                "intensity": "1073.31",
                                "charge": "4"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "49",
                                "monoisotopic_mass": "1450.4123",
                                "monoisotopic_mz": "1451.4196",
                                "intensity": "1953.25",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "50",
                                "monoisotopic_mass": "1411.0508",
                                "monoisotopic_mz": "1412.0581",
                                "intensity": "1524.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "51",
                                "monoisotopic_mass": "1739.7123",
                                "monoisotopic_mz": "1740.7196",
                                "intensity": "2140.31",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "-0.0008",
                                        "ppm": "-0.43"
                                    }
                                }
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "52",
                                "monoisotopic_mass": "4450.2727",
                                "monoisotopic_mz": "1484.4315",
                                "intensity": "3822.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "53",
                                "monoisotopic_mass": "3413.1797",
                                "monoisotopic_mz": "1138.7339",
                                "intensity": "1358.90",
                                "charge": "3"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "54",
                                "monoisotopic_mass": "7549.5095",
                                "monoisotopic_mz": "1259.2589",
                                "intensity": "1162.62",
                                "charge": "6"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "55",
                                "monoisotopic_mass": "6023.0604",
                                "monoisotopic_mz": "1205.6194",
                                "intensity": "2380.06",
                                "charge": "5"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "56",
                                "monoisotopic_mass": "1462.5607",
                                "monoisotopic_mz": "1463.5680",
                                "intensity": "2247.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "238",
                                "peak_id": "57",
                                "monoisotopic_mass": "1292.1357",
                                "monoisotopic_mz": "1293.1429",
                                "intensity": "908.75",
                                "charge": "1"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "66",
                                        "spec_id": "238",
                                        "peak_id": "34",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "238",
                                        "peak_id": "51",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "238",
                                        "peak_id": "6",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "35",
                                        "ion_display_position": "35",
                                        "spec_id": "238",
                                        "peak_id": "11",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "36",
                                        "ion_display_position": "36",
                                        "spec_id": "238",
                                        "peak_id": "21",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "1",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "39",
                                            "ion_display_position": "39",
                                            "spec_id": "238",
                                            "peak_id": "15",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "Y",
                                            "ion_position": "39",
                                            "ion_display_position": "40",
                                            "spec_id": "238",
                                            "peak_id": "19",
                                            "peak_charge": "3"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "spec_id": "238",
                                        "peak_id": "20",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "75",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "76",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "spec_id": "238",
                                        "peak_id": "18",
                                        "peak_charge": "4"
                                    }
                                }
                            },
                            {
                                "position": "77",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "78",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "79",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "80",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "81",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "82",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "83",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "84",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "85",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "86",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "87",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "88",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "89",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "90",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "91",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "92",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "93",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "94",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "95",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "66",
                                        "ion_display_position": "66",
                                        "spec_id": "238",
                                        "peak_id": "34",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "96",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "97",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "98",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "99",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "100",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "101",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "102",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "103",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "104",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "105",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "238",
                                            "peak_id": "5",
                                            "peak_charge": "8"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "76",
                                            "ion_display_position": "76",
                                            "spec_id": "238",
                                            "peak_id": "3",
                                            "peak_charge": "7"
                                        }
                                    ]
                                }
                            },
                            {
                                "position": "106",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "spec_id": "238",
                                        "peak_id": "0",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "107",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "108",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            }
                        ],
                        "ptm": {
                            "ptm_type": "Fixed",
                            "ptm": {
                                "abbreviation": "Carbamidomethylation",
                                "unimod": "-1",
                                "mono_mass": "57.0214640000"
                            },
                            "occurence": [
                                {
                                    "left_pos": "38",
                                    "right_pos": "39",
                                    "anno": "C"
                                },
                                {
                                    "left_pos": "86",
                                    "right_pos": "87",
                                    "anno": "C"
                                }
                            ]
                        }
                    }
                }
            },
            {
                "prsm_id": "29",
                "p_value": "2.54e-06",
                "e_value": "2.54e-06",
                "fdr": "0",
                "matched_fragment_number": "15",
                "matched_peak_number": "16",
                "ms": {
                    "ms_header": {
                        "spectrum_file_name": "ecoli_2_ms2.msalign",
                        "ms1_ids": "68",
                        "ms1_scans": "106",
                        "ids": "37",
                        "scans": "107",
                        "precursor_mono_mass": "9173.3946",
                        "precursor_charge": "9",
                        "precursor_mz": "1020.2733",
                        "feature_inte": "3.1002e+08"
                    },
                    "peaks": {
                        "peak": [
                            {
                                "spec_id": "37",
                                "peak_id": "0",
                                "monoisotopic_mass": "8831.2309",
                                "monoisotopic_mz": "1262.6117",
                                "intensity": "36268.84",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "-0.0122",
                                        "ppm": "-1.38"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "1",
                                "monoisotopic_mass": "8831.2459",
                                "monoisotopic_mz": "1104.9130",
                                "intensity": "42377.65",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8831.2431",
                                        "ion_position": "76",
                                        "ion_display_position": "76",
                                        "ion_sort_name": "B00076",
                                        "ion_left_position": "76",
                                        "mass_error": "0.0028",
                                        "ppm": "0.31"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "2",
                                "monoisotopic_mass": "8814.2351",
                                "monoisotopic_mz": "1102.7867",
                                "intensity": "15001.67",
                                "charge": "8"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "3",
                                "monoisotopic_mass": "7579.7856",
                                "monoisotopic_mz": "1264.3049",
                                "intensity": "25707.31",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "4",
                                "monoisotopic_mass": "8926.3079",
                                "monoisotopic_mz": "1116.7958",
                                "intensity": "18403.70",
                                "charge": "8"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "5",
                                "monoisotopic_mass": "7708.8292",
                                "monoisotopic_mz": "1285.8121",
                                "intensity": "15224.22",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "6",
                                "monoisotopic_mass": "8814.2009",
                                "monoisotopic_mz": "1260.1788",
                                "intensity": "13411.27",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "7",
                                "monoisotopic_mass": "8943.3109",
                                "monoisotopic_mz": "1118.9211",
                                "intensity": "21267.36",
                                "charge": "8",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8944.3272",
                                        "ion_position": "77",
                                        "ion_display_position": "77",
                                        "ion_sort_name": "B00077",
                                        "ion_left_position": "77",
                                        "mass_error": "-0.0139",
                                        "ppm": "-1.56"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "8",
                                "monoisotopic_mass": "8911.2869",
                                "monoisotopic_mz": "1114.9181",
                                "intensity": "15019.24",
                                "charge": "8"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "9",
                                "monoisotopic_mass": "8760.2491",
                                "monoisotopic_mz": "1252.4714",
                                "intensity": "14753.11",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "10",
                                "monoisotopic_mass": "3973.8153",
                                "monoisotopic_mz": "1325.6124",
                                "intensity": "16954.22",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3973.8147",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "ion_sort_name": "B00034",
                                        "ion_left_position": "34",
                                        "mass_error": "0.0005",
                                        "ppm": "0.13"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "11",
                                "monoisotopic_mass": "8742.2347",
                                "monoisotopic_mz": "1249.8979",
                                "intensity": "10564.10",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "12",
                                "monoisotopic_mass": "4776.1929",
                                "monoisotopic_mz": "1195.0555",
                                "intensity": "12177.84",
                                "charge": "4"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "13",
                                "monoisotopic_mass": "3121.5980",
                                "monoisotopic_mz": "1561.8063",
                                "intensity": "11318.00",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "14",
                                "monoisotopic_mass": "7561.7685",
                                "monoisotopic_mz": "1261.3020",
                                "intensity": "10267.38",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "15",
                                "monoisotopic_mass": "8630.2126",
                                "monoisotopic_mz": "1233.8948",
                                "intensity": "19139.51",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "16",
                                "monoisotopic_mass": "5150.3692",
                                "monoisotopic_mz": "1031.0811",
                                "intensity": "7851.16",
                                "charge": "5",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0047",
                                        "ppm": "-0.92"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "17",
                                "monoisotopic_mass": "5367.4555",
                                "monoisotopic_mz": "1342.8712",
                                "intensity": "7781.13",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5367.4509",
                                        "ion_position": "47",
                                        "ion_display_position": "47",
                                        "ion_sort_name": "B00047",
                                        "ion_left_position": "47",
                                        "mass_error": "0.0047",
                                        "ppm": "0.87"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "18",
                                "monoisotopic_mass": "3018.4835",
                                "monoisotopic_mz": "1007.1684",
                                "intensity": "8701.93",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "19",
                                "monoisotopic_mass": "4035.0380",
                                "monoisotopic_mz": "1346.0199",
                                "intensity": "9820.52",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "20",
                                "monoisotopic_mass": "4249.1612",
                                "monoisotopic_mz": "1417.3943",
                                "intensity": "6301.68",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "21",
                                "monoisotopic_mass": "7431.7208",
                                "monoisotopic_mz": "1239.6274",
                                "intensity": "13241.88",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "22",
                                "monoisotopic_mass": "3691.9043",
                                "monoisotopic_mz": "1231.6420",
                                "intensity": "6020.48",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "23",
                                "monoisotopic_mass": "4019.0104",
                                "monoisotopic_mz": "1340.6774",
                                "intensity": "4997.60",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "24",
                                "monoisotopic_mass": "7661.7271",
                                "monoisotopic_mz": "1095.5397",
                                "intensity": "7538.16",
                                "charge": "7",
                                "matched_ions_num": "2",
                                "matched_ions": {
                                    "matched_ion": [
                                        {
                                            "ion_type": "Y",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7661.8314",
                                            "ion_position": "13",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "Y00066",
                                            "ion_left_position": "13",
                                            "mass_error": "-0.1043",
                                            "ppm": "-13.61"
                                        },
                                        {
                                            "ion_type": "B",
                                            "match_shift": "0.0000000000",
                                            "theoretical_mass": "7662.7282",
                                            "ion_position": "66",
                                            "ion_display_position": "66",
                                            "ion_sort_name": "B00066",
                                            "ion_left_position": "66",
                                            "mass_error": "0.0013",
                                            "ppm": "0.16"
                                        }
                                    ]
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "25",
                                "monoisotopic_mass": "8725.2440",
                                "monoisotopic_mz": "1247.4707",
                                "intensity": "9691.50",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "26",
                                "monoisotopic_mass": "3955.8116",
                                "monoisotopic_mz": "1319.6111",
                                "intensity": "7236.46",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "27",
                                "monoisotopic_mass": "4137.8847",
                                "monoisotopic_mz": "1380.3022",
                                "intensity": "8990.09",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "28",
                                "monoisotopic_mass": "3846.9085",
                                "monoisotopic_mz": "1283.3101",
                                "intensity": "4532.74",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "29",
                                "monoisotopic_mass": "2494.1067",
                                "monoisotopic_mz": "1248.0606",
                                "intensity": "4072.87",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "30",
                                "monoisotopic_mass": "1364.5318",
                                "monoisotopic_mz": "683.2732",
                                "intensity": "4186.15",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1364.5337",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "ion_sort_name": "B00012",
                                        "ion_left_position": "12",
                                        "mass_error": "-0.0018",
                                        "ppm": "-1.35"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "31",
                                "monoisotopic_mass": "720.3439",
                                "monoisotopic_mz": "721.3512",
                                "intensity": "5083.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "32",
                                "monoisotopic_mass": "1112.4106",
                                "monoisotopic_mz": "1113.4178",
                                "intensity": "3231.47",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "33",
                                "monoisotopic_mass": "8540.1499",
                                "monoisotopic_mz": "1221.0287",
                                "intensity": "4735.62",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "34",
                                "monoisotopic_mass": "821.3919",
                                "monoisotopic_mz": "822.3992",
                                "intensity": "3419.23",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "35",
                                "monoisotopic_mass": "3874.7439",
                                "monoisotopic_mz": "1292.5886",
                                "intensity": "4827.58",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3874.7463",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "ion_sort_name": "B00033",
                                        "ion_left_position": "33",
                                        "mass_error": "-0.0025",
                                        "ppm": "-0.63"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "36",
                                "monoisotopic_mass": "3921.9598",
                                "monoisotopic_mz": "1308.3272",
                                "intensity": "4862.44",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "37",
                                "monoisotopic_mass": "3463.7846",
                                "monoisotopic_mz": "1155.6021",
                                "intensity": "6336.74",
                                "charge": "3",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "Y",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "3463.7922",
                                        "ion_position": "50",
                                        "ion_display_position": "29",
                                        "ion_sort_name": "Y00029",
                                        "ion_left_position": "50",
                                        "mass_error": "-0.0077",
                                        "ppm": "-2.21"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "38",
                                "monoisotopic_mass": "1217.5867",
                                "monoisotopic_mz": "1218.5940",
                                "intensity": "4837.45",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "39",
                                "monoisotopic_mass": "2247.0211",
                                "monoisotopic_mz": "1124.5178",
                                "intensity": "8646.63",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "40",
                                "monoisotopic_mass": "3772.6911",
                                "monoisotopic_mz": "1258.5710",
                                "intensity": "4096.30",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "41",
                                "monoisotopic_mass": "1249.1764",
                                "monoisotopic_mz": "1250.1837",
                                "intensity": "3483.64",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "42",
                                "monoisotopic_mass": "3122.6023",
                                "monoisotopic_mz": "1041.8747",
                                "intensity": "3118.49",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "43",
                                "monoisotopic_mass": "3602.7982",
                                "monoisotopic_mz": "1201.9400",
                                "intensity": "5991.64",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "44",
                                "monoisotopic_mass": "2199.8046",
                                "monoisotopic_mz": "1100.9096",
                                "intensity": "4126.24",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "45",
                                "monoisotopic_mass": "947.4018",
                                "monoisotopic_mz": "948.4091",
                                "intensity": "3311.06",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "947.4018",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "ion_sort_name": "B00009",
                                        "ion_left_position": "9",
                                        "mass_error": "-0.0000",
                                        "ppm": "-0.01"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "46",
                                "monoisotopic_mass": "3904.9471",
                                "monoisotopic_mz": "1302.6563",
                                "intensity": "4979.39",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "47",
                                "monoisotopic_mass": "4438.1207",
                                "monoisotopic_mz": "1110.5375",
                                "intensity": "4339.53",
                                "charge": "4"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "48",
                                "monoisotopic_mass": "8593.1250",
                                "monoisotopic_mz": "1228.5966",
                                "intensity": "3214.73",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "49",
                                "monoisotopic_mass": "870.4181",
                                "monoisotopic_mz": "871.4254",
                                "intensity": "2422.95",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "50",
                                "monoisotopic_mass": "8073.9852",
                                "monoisotopic_mz": "1154.4337",
                                "intensity": "9782.95",
                                "charge": "7",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "8073.9076",
                                        "ion_position": "69",
                                        "ion_display_position": "69",
                                        "ion_sort_name": "B00069",
                                        "ion_left_position": "69",
                                        "mass_error": "0.0776",
                                        "ppm": "9.61"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "51",
                                "monoisotopic_mass": "3008.5164",
                                "monoisotopic_mz": "1505.2655",
                                "intensity": "3907.45",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "52",
                                "monoisotopic_mass": "1262.7501",
                                "monoisotopic_mz": "1263.7574",
                                "intensity": "5173.24",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "53",
                                "monoisotopic_mass": "2762.2750",
                                "monoisotopic_mz": "1382.1448",
                                "intensity": "5098.41",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "2762.2714",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "ion_sort_name": "B00025",
                                        "ion_left_position": "25",
                                        "mass_error": "0.0037",
                                        "ppm": "1.33"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "54",
                                "monoisotopic_mass": "8782.2216",
                                "monoisotopic_mz": "1255.6104",
                                "intensity": "4323.56",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "55",
                                "monoisotopic_mass": "4892.2765",
                                "monoisotopic_mz": "1224.0764",
                                "intensity": "2714.81",
                                "charge": "4"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "56",
                                "monoisotopic_mass": "1305.6415",
                                "monoisotopic_mz": "1306.6488",
                                "intensity": "2451.65",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "57",
                                "monoisotopic_mass": "7819.8798",
                                "monoisotopic_mz": "1304.3206",
                                "intensity": "9448.99",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "58",
                                "monoisotopic_mass": "5587.2483",
                                "monoisotopic_mz": "1118.4569",
                                "intensity": "4016.96",
                                "charge": "5"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "59",
                                "monoisotopic_mass": "1192.2920",
                                "monoisotopic_mz": "1193.2993",
                                "intensity": "2373.78",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "60",
                                "monoisotopic_mass": "7449.6761",
                                "monoisotopic_mz": "1242.6200",
                                "intensity": "2675.16",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "61",
                                "monoisotopic_mass": "658.3276",
                                "monoisotopic_mz": "659.3349",
                                "intensity": "1424.86",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "62",
                                "monoisotopic_mass": "7302.6062",
                                "monoisotopic_mz": "1218.1083",
                                "intensity": "1474.64",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "63",
                                "monoisotopic_mass": "3058.8180",
                                "monoisotopic_mz": "1020.6133",
                                "intensity": "2742.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "64",
                                "monoisotopic_mass": "1132.5522",
                                "monoisotopic_mz": "1133.5594",
                                "intensity": "1278.72",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "65",
                                "monoisotopic_mass": "803.3813",
                                "monoisotopic_mz": "804.3886",
                                "intensity": "1141.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "66",
                                "monoisotopic_mass": "2440.2161",
                                "monoisotopic_mz": "1221.1153",
                                "intensity": "2470.08",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "67",
                                "monoisotopic_mass": "8282.7724",
                                "monoisotopic_mz": "1381.4693",
                                "intensity": "1317.08",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "68",
                                "monoisotopic_mass": "3659.3218",
                                "monoisotopic_mz": "1220.7812",
                                "intensity": "4437.98",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "69",
                                "monoisotopic_mass": "3103.5785",
                                "monoisotopic_mz": "1552.7965",
                                "intensity": "3117.10",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "70",
                                "monoisotopic_mass": "1231.6001",
                                "monoisotopic_mz": "1232.6074",
                                "intensity": "4311.90",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "71",
                                "monoisotopic_mass": "5152.3605",
                                "monoisotopic_mz": "1289.0974",
                                "intensity": "5004.68",
                                "charge": "4",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "5151.3763",
                                        "ion_position": "45",
                                        "ion_display_position": "45",
                                        "ion_sort_name": "B00045",
                                        "ion_left_position": "45",
                                        "mass_error": "-0.0181",
                                        "ppm": "-3.52"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "72",
                                "monoisotopic_mass": "8649.1823",
                                "monoisotopic_mz": "1236.6047",
                                "intensity": "3297.40",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "73",
                                "monoisotopic_mass": "846.3537",
                                "monoisotopic_mz": "847.3610",
                                "intensity": "2870.44",
                                "charge": "1",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "846.3542",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "ion_sort_name": "B00008",
                                        "ion_left_position": "8",
                                        "mass_error": "-0.0004",
                                        "ppm": "-0.49"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "74",
                                "monoisotopic_mass": "5385.6745",
                                "monoisotopic_mz": "1078.1422",
                                "intensity": "1057.96",
                                "charge": "5"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "75",
                                "monoisotopic_mass": "4678.3499",
                                "monoisotopic_mz": "1560.4572",
                                "intensity": "2434.12",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "76",
                                "monoisotopic_mass": "1005.4506",
                                "monoisotopic_mz": "1006.4578",
                                "intensity": "1892.70",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "77",
                                "monoisotopic_mass": "1411.7153",
                                "monoisotopic_mz": "1412.7225",
                                "intensity": "799.26",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "78",
                                "monoisotopic_mass": "454.1803",
                                "monoisotopic_mz": "455.1876",
                                "intensity": "1583.18",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "79",
                                "monoisotopic_mass": "2453.6471",
                                "monoisotopic_mz": "1227.8308",
                                "intensity": "1395.78",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "80",
                                "monoisotopic_mass": "7840.7996",
                                "monoisotopic_mz": "1121.1215",
                                "intensity": "3270.82",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "81",
                                "monoisotopic_mass": "1739.7158",
                                "monoisotopic_mz": "870.8652",
                                "intensity": "2145.05",
                                "charge": "2",
                                "matched_ions_num": "1",
                                "matched_ions": {
                                    "matched_ion": {
                                        "ion_type": "B",
                                        "match_shift": "0.0000000000",
                                        "theoretical_mass": "1739.7131",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "ion_sort_name": "B00015",
                                        "ion_left_position": "15",
                                        "mass_error": "0.0027",
                                        "ppm": "1.55"
                                    }
                                }
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "82",
                                "monoisotopic_mass": "8989.9067",
                                "monoisotopic_mz": "1285.2797",
                                "intensity": "2380.83",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "83",
                                "monoisotopic_mass": "2146.7829",
                                "monoisotopic_mz": "1074.3987",
                                "intensity": "1254.55",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "84",
                                "monoisotopic_mass": "934.4750",
                                "monoisotopic_mz": "935.4823",
                                "intensity": "1880.16",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "85",
                                "monoisotopic_mass": "1965.8393",
                                "monoisotopic_mz": "1966.8466",
                                "intensity": "2693.77",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "86",
                                "monoisotopic_mass": "7031.1004",
                                "monoisotopic_mz": "1172.8573",
                                "intensity": "1300.78",
                                "charge": "6"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "87",
                                "monoisotopic_mass": "1475.1764",
                                "monoisotopic_mz": "1476.1837",
                                "intensity": "772.98",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "88",
                                "monoisotopic_mass": "1061.5152",
                                "monoisotopic_mz": "1062.5225",
                                "intensity": "1535.30",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "89",
                                "monoisotopic_mass": "2184.7998",
                                "monoisotopic_mz": "1093.4072",
                                "intensity": "1611.21",
                                "charge": "2"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "90",
                                "monoisotopic_mass": "1148.8420",
                                "monoisotopic_mz": "1149.8492",
                                "intensity": "1717.88",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "91",
                                "monoisotopic_mass": "9058.4524",
                                "monoisotopic_mz": "1133.3138",
                                "intensity": "1423.26",
                                "charge": "8"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "92",
                                "monoisotopic_mass": "5478.2634",
                                "monoisotopic_mz": "1096.6600",
                                "intensity": "2703.49",
                                "charge": "5"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "93",
                                "monoisotopic_mass": "8208.8779",
                                "monoisotopic_mz": "1173.7041",
                                "intensity": "1347.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "94",
                                "monoisotopic_mass": "1428.4131",
                                "monoisotopic_mz": "1429.4204",
                                "intensity": "792.32",
                                "charge": "1"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "95",
                                "monoisotopic_mass": "8706.3067",
                                "monoisotopic_mz": "1244.7654",
                                "intensity": "4563.93",
                                "charge": "7"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "96",
                                "monoisotopic_mass": "4909.5964",
                                "monoisotopic_mz": "1228.4064",
                                "intensity": "1518.54",
                                "charge": "4"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "97",
                                "monoisotopic_mass": "3446.8111",
                                "monoisotopic_mz": "1149.9443",
                                "intensity": "1616.45",
                                "charge": "3"
                            },
                            {
                                "spec_id": "37",
                                "peak_id": "98",
                                "monoisotopic_mass": "4357.6558",
                                "monoisotopic_mz": "1090.4212",
                                "intensity": "2125.67",
                                "charge": "4"
                            }
                        ]
                    }
                },
                "annotated_protein": {
                    "sequence_id": "5",
                    "proteoform_id": "7",
                    "sequence_name": "sp|P0AET2|HDEB_ECOLI",
                    "sequence_description": "Acid stress chaperone HdeB OS=Escherichia coli (strain K12) OX=83333 GN=hdeB PE=1 SV=1",
                    "proteoform_mass": "9173.4334",
                    "n_acetylation": "0",
                    "unexpected_shift_number": "0",
                    "annotation": {
                        "protein_length": "108",
                        "first_residue_position": "29",
                        "last_residue_position": "107",
                        "residue": [
                            {
                                "position": "0",
                                "acid": "M"
                            },
                            {
                                "position": "1",
                                "acid": "N"
                            },
                            {
                                "position": "2",
                                "acid": "I"
                            },
                            {
                                "position": "3",
                                "acid": "S"
                            },
                            {
                                "position": "4",
                                "acid": "S"
                            },
                            {
                                "position": "5",
                                "acid": "L"
                            },
                            {
                                "position": "6",
                                "acid": "R"
                            },
                            {
                                "position": "7",
                                "acid": "K"
                            },
                            {
                                "position": "8",
                                "acid": "A"
                            },
                            {
                                "position": "9",
                                "acid": "F"
                            },
                            {
                                "position": "10",
                                "acid": "I"
                            },
                            {
                                "position": "11",
                                "acid": "F"
                            },
                            {
                                "position": "12",
                                "acid": "M"
                            },
                            {
                                "position": "13",
                                "acid": "G"
                            },
                            {
                                "position": "14",
                                "acid": "A"
                            },
                            {
                                "position": "15",
                                "acid": "V"
                            },
                            {
                                "position": "16",
                                "acid": "A"
                            },
                            {
                                "position": "17",
                                "acid": "A"
                            },
                            {
                                "position": "18",
                                "acid": "L"
                            },
                            {
                                "position": "19",
                                "acid": "S"
                            },
                            {
                                "position": "20",
                                "acid": "L"
                            },
                            {
                                "position": "21",
                                "acid": "V"
                            },
                            {
                                "position": "22",
                                "acid": "N"
                            },
                            {
                                "position": "23",
                                "acid": "A"
                            },
                            {
                                "position": "24",
                                "acid": "Q"
                            },
                            {
                                "position": "25",
                                "acid": "S"
                            },
                            {
                                "position": "26",
                                "acid": "A"
                            },
                            {
                                "position": "27",
                                "acid": "L"
                            },
                            {
                                "position": "28",
                                "acid": "A"
                            },
                            {
                                "position": "29",
                                "acid": "A"
                            },
                            {
                                "position": "30",
                                "acid": "N"
                            },
                            {
                                "position": "31",
                                "acid": "E"
                            },
                            {
                                "position": "32",
                                "acid": "S"
                            },
                            {
                                "position": "33",
                                "acid": "A"
                            },
                            {
                                "position": "34",
                                "acid": "K"
                            },
                            {
                                "position": "35",
                                "acid": "D"
                            },
                            {
                                "position": "36",
                                "acid": "M"
                            },
                            {
                                "position": "37",
                                "acid": "T"
                            },
                            {
                                "position": "38",
                                "acid": "C"
                            },
                            {
                                "position": "39",
                                "acid": "Q"
                            },
                            {
                                "position": "40",
                                "acid": "E"
                            },
                            {
                                "position": "41",
                                "acid": "F"
                            },
                            {
                                "position": "42",
                                "acid": "I"
                            },
                            {
                                "position": "43",
                                "acid": "D"
                            },
                            {
                                "position": "44",
                                "acid": "L"
                            },
                            {
                                "position": "45",
                                "acid": "N"
                            },
                            {
                                "position": "46",
                                "acid": "P"
                            },
                            {
                                "position": "47",
                                "acid": "K"
                            },
                            {
                                "position": "48",
                                "acid": "A"
                            },
                            {
                                "position": "49",
                                "acid": "M"
                            },
                            {
                                "position": "50",
                                "acid": "T"
                            },
                            {
                                "position": "51",
                                "acid": "P"
                            },
                            {
                                "position": "52",
                                "acid": "V"
                            },
                            {
                                "position": "53",
                                "acid": "A"
                            },
                            {
                                "position": "54",
                                "acid": "W"
                            },
                            {
                                "position": "55",
                                "acid": "W"
                            },
                            {
                                "position": "56",
                                "acid": "M"
                            },
                            {
                                "position": "57",
                                "acid": "L"
                            },
                            {
                                "position": "58",
                                "acid": "H"
                            },
                            {
                                "position": "59",
                                "acid": "E"
                            },
                            {
                                "position": "60",
                                "acid": "E"
                            },
                            {
                                "position": "61",
                                "acid": "T"
                            },
                            {
                                "position": "62",
                                "acid": "V"
                            },
                            {
                                "position": "63",
                                "acid": "Y"
                            },
                            {
                                "position": "64",
                                "acid": "K"
                            },
                            {
                                "position": "65",
                                "acid": "G"
                            },
                            {
                                "position": "66",
                                "acid": "G"
                            },
                            {
                                "position": "67",
                                "acid": "D"
                            },
                            {
                                "position": "68",
                                "acid": "T"
                            },
                            {
                                "position": "69",
                                "acid": "V"
                            },
                            {
                                "position": "70",
                                "acid": "T"
                            },
                            {
                                "position": "71",
                                "acid": "L"
                            },
                            {
                                "position": "72",
                                "acid": "N"
                            },
                            {
                                "position": "73",
                                "acid": "E"
                            },
                            {
                                "position": "74",
                                "acid": "T"
                            },
                            {
                                "position": "75",
                                "acid": "D"
                            },
                            {
                                "position": "76",
                                "acid": "L"
                            },
                            {
                                "position": "77",
                                "acid": "T"
                            },
                            {
                                "position": "78",
                                "acid": "Q"
                            },
                            {
                                "position": "79",
                                "acid": "I"
                            },
                            {
                                "position": "80",
                                "acid": "P"
                            },
                            {
                                "position": "81",
                                "acid": "K"
                            },
                            {
                                "position": "82",
                                "acid": "V"
                            },
                            {
                                "position": "83",
                                "acid": "I"
                            },
                            {
                                "position": "84",
                                "acid": "E"
                            },
                            {
                                "position": "85",
                                "acid": "Y"
                            },
                            {
                                "position": "86",
                                "acid": "C"
                            },
                            {
                                "position": "87",
                                "acid": "K"
                            },
                            {
                                "position": "88",
                                "acid": "K"
                            },
                            {
                                "position": "89",
                                "acid": "N"
                            },
                            {
                                "position": "90",
                                "acid": "P"
                            },
                            {
                                "position": "91",
                                "acid": "Q"
                            },
                            {
                                "position": "92",
                                "acid": "K"
                            },
                            {
                                "position": "93",
                                "acid": "N"
                            },
                            {
                                "position": "94",
                                "acid": "L"
                            },
                            {
                                "position": "95",
                                "acid": "Y"
                            },
                            {
                                "position": "96",
                                "acid": "T"
                            },
                            {
                                "position": "97",
                                "acid": "F"
                            },
                            {
                                "position": "98",
                                "acid": "K"
                            },
                            {
                                "position": "99",
                                "acid": "N"
                            },
                            {
                                "position": "100",
                                "acid": "Q"
                            },
                            {
                                "position": "101",
                                "acid": "A"
                            },
                            {
                                "position": "102",
                                "acid": "S"
                            },
                            {
                                "position": "103",
                                "acid": "N"
                            },
                            {
                                "position": "104",
                                "acid": "D"
                            },
                            {
                                "position": "105",
                                "acid": "L"
                            },
                            {
                                "position": "106",
                                "acid": "P"
                            },
                            {
                                "position": "107",
                                "acid": "N"
                            }
                        ],
                        "cleavage": [
                            {
                                "position": "0",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "1",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "2",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "3",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "4",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "5",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "6",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "7",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "8",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "9",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "10",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "11",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "12",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "13",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "14",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "15",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "16",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "17",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "18",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "19",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "20",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "21",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "22",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "23",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "24",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "25",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "26",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "27",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "28",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "29",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "30",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "31",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "32",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "33",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "34",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "35",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "36",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "37",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "8",
                                        "ion_display_position": "8",
                                        "spec_id": "37",
                                        "peak_id": "73",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "38",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "9",
                                        "ion_display_position": "9",
                                        "spec_id": "37",
                                        "peak_id": "45",
                                        "peak_charge": "1"
                                    }
                                }
                            },
                            {
                                "position": "39",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "40",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "41",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "12",
                                        "ion_display_position": "12",
                                        "spec_id": "37",
                                        "peak_id": "30",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "42",
                                "exist_n_ion": "0",
                                "exist_c_ion": "1",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "Y",
                                        "ion_position": "13",
                                        "ion_display_position": "66",
                                        "spec_id": "37",
                                        "peak_id": "24",
                                        "peak_charge": "7"
                                    }
                                }
                            },
                            {
                                "position": "43",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "44",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "15",
                                        "ion_display_position": "15",
                                        "spec_id": "37",
                                        "peak_id": "81",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "45",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "46",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "47",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "48",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "49",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "50",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "51",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "52",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "53",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "54",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "25",
                                        "ion_display_position": "25",
                                        "spec_id": "37",
                                        "peak_id": "53",
                                        "peak_charge": "2"
                                    }
                                }
                            },
                            {
                                "position": "55",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "56",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "57",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "58",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "59",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "60",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "61",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "62",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "33",
                                        "ion_display_position": "33",
                                        "spec_id": "37",
                                        "peak_id": "35",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "63",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": {
                                        "ion_type": "B",
                                        "ion_position": "34",
                                        "ion_display_position": "34",
                                        "spec_id": "37",
                                        "peak_id": "10",
                                        "peak_charge": "3"
                                    }
                                }
                            },
                            {
                                "position": "64",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "65",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "66",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "67",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "68",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "69",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "70",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "71",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "72",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "73",
                                "exist_n_ion": "0",
                                "exist_c_ion": "0",
                                "matched_peaks": null
                            },
                            {
                                "position": "74",
                                "exist_n_ion": "1",
                                "exist_c_ion": "0",
                                "matched_peaks": {
                                    "matched_peak": [
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "37",
                                            "peak_id": "71",
                                            "peak_charge": "4"
                                        },
                                        {
                                            "ion_type": "B",
                                            "ion_position": "45",
                                            "ion_display_position": "45",
                                            "spec_id": "37",
                                            "peak_id": "16",
                                            "peak_charge": "5"
                                        }
                                    ]
                                }
                            },
                            {
               